/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.utils;

import com.blixx.boom.gui.utils.BPoint;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class StandardDeviation {
    public static double getStandardDeviation(Collection<BPoint> col, double average) {
        double res = -1.0;
        Iterator<BPoint> it = col.iterator();
        double sum = 0.0;
        while (it.hasNext()) {
            double x = it.next().getValue();
            sum += Math.pow(x - average, 2.0);
        }
        res = Math.sqrt(sum / (double)col.size());
        return res;
    }

    public static double ajustAverage(double currentAvrg, double value, long counter) {
        return ((double)counter * currentAvrg + value) / (double)(counter + 1L);
    }

    public static double getAverage(Collection<BPoint> col, double startX, double startY, double scaleX, double scaleY, int textSpaceLeft, int height, List<BPoint> m_trend) {
        Iterator<BPoint> it = col.iterator();
        double sum = 0.0;
        int count = 0;
        while (it.hasNext()) {
            BPoint bbp = it.next();
            double x = bbp.getValue();
            sum += x;
            if (++count <= 2) continue;
            double average = sum / (double)count;
            int xp = textSpaceLeft + (int)(((double)bbp.getTime() - startX) * scaleX);
            int yp = height - (int)((average - startY) * scaleY);
            BPoint bp = new BPoint(xp, yp);
            bp.setTime(bbp.getTime());
            bp.setValue(average);
            m_trend.add(bp);
        }
        return sum / (double)col.size();
    }
}

