/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.utils;

import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.GroupTreeObjectLast;
import com.blixx.shared.utils.ITreeObject;
import java.util.Collection;
import java.util.List;
import java.util.WeakHashMap;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class TreeFilter
extends ViewerFilter {
    private String m_text = null;
    private List<String> m_textList = null;
    WeakHashMap<GroupTreeObject, Object> m_folders = new WeakHashMap();
    public static String SEARCH_ALL = "SEARCH_ALL";
    public static String SEARCH_GTO = "SEARCH_GTO";
    public static String SEARCH_GTOL = "SEARCH_GTOL";
    private String m_type = SEARCH_ALL;

    public TreeFilter(String text, String type) {
        if (text != null && text.length() > 0) {
            this.m_text = text.toLowerCase();
        }
        this.m_type = type;
    }

    public TreeFilter(List<String> textList, String type) {
        if (textList != null) {
            this.m_textList = textList;
        }
        this.m_type = type;
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (this.m_text == null && this.m_textList == null) {
            return true;
        }
        if (element instanceof GroupTreeObjectLast) {
            GroupTreeObjectLast gtol;
            ITreeObject ito;
            if ((this.m_type.equals(SEARCH_GTOL) || this.m_type.equals(SEARCH_ALL)) && (ito = (gtol = (GroupTreeObjectLast)element).getTreeObject()) != null) {
                if (this.m_text != null) {
                    if (ito.getComparableName().toLowerCase().contains(this.m_text)) {
                        return true;
                    }
                } else if (this.m_textList != null) {
                    int i = 0;
                    while (i < this.m_textList.size()) {
                        String name = this.m_textList.get(i);
                        if (ito.getComparableName().toLowerCase().contains(name)) {
                            return true;
                        }
                        ++i;
                    }
                }
            }
            return false;
        }
        if (this.m_folders.containsKey(element)) {
            return true;
        }
        GroupTreeObject gto = (GroupTreeObject)element;
        if (gto.getParent() != null && gto.getParent().getName().equals("root")) {
            this.m_folders.put(gto, "");
            return true;
        }
        if (this.m_type.equals(SEARCH_GTO) || this.m_type.equals(SEARCH_ALL)) {
            if (this.m_text != null) {
                if (gto.getName().toLowerCase().contains(this.m_text)) {
                    this.m_folders.put(gto, "");
                    return true;
                }
            } else if (this.m_textList != null) {
                int i = 0;
                while (i < this.m_textList.size()) {
                    String agtName = this.m_textList.get(i);
                    if (gto.getName().toLowerCase().contains(agtName)) {
                        this.m_folders.put(gto, "");
                        return true;
                    }
                    ++i;
                }
            }
        }
        for (GroupTreeObject child : gto.getElements()) {
            boolean hasChildMatched = this.select(viewer, gto, child);
            if (!hasChildMatched) continue;
            this.m_folders.put(gto, "");
            return true;
        }
        return false;
    }

    public Collection<GroupTreeObject> getFilteredFolders() {
        return this.m_folders.keySet();
    }
}

