/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.utils;

import com.blixx.boom.authentication.UserTreeObject;
import com.blixx.boom.engine.Repository;
import com.blixx.shared.User;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.GroupTreeObjectLast;
import com.blixx.shared.utils.ITreeObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.WeakHashMap;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class UserManagementTreeFilter
extends ViewerFilter {
    private String m_text = null;
    private boolean m_onlineOnly = false;
    List<GroupTreeObjectLast> m_elements = null;
    WeakHashMap<GroupTreeObject, Object> m_cache = new WeakHashMap();

    public UserManagementTreeFilter(String text, boolean onlineOnly) {
        this.m_elements = new ArrayList<GroupTreeObjectLast>();
        if (text != null) {
            this.m_text = text.toLowerCase();
        }
        this.m_onlineOnly = onlineOnly;
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (this.m_text == null) {
            return true;
        }
        if (element instanceof GroupTreeObjectLast) {
            ITreeObject ito = ((GroupTreeObjectLast)element).getTreeObject();
            if (ito != null && ito.getComparableName().toLowerCase().contains(this.m_text)) {
                if (this.m_onlineOnly) {
                    User user = ((UserTreeObject)ito.getObject()).getUserObject();
                    boolean isUserOnline = Repository.getInstance().getUserManager().isUserOnline(user);
                    if (isUserOnline) {
                        this.m_elements.add((GroupTreeObjectLast)element);
                        return true;
                    }
                } else {
                    this.m_elements.add((GroupTreeObjectLast)element);
                    return true;
                }
            }
            return false;
        }
        if (this.m_cache.containsKey(element)) {
            return true;
        }
        GroupTreeObject gto = (GroupTreeObject)element;
        for (GroupTreeObject child : gto.getElements()) {
            boolean hasChildMatched = this.select(viewer, gto, child);
            if (!hasChildMatched) continue;
            this.m_cache.put(gto, "");
            return true;
        }
        return false;
    }

    public List<GroupTreeObjectLast> getFilteredElements() {
        return this.m_elements;
    }

    public Collection<GroupTreeObject> getFilteredFolders() {
        return this.m_cache.keySet();
    }
}

