/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.utils.calendar;

import com.blixx.boom.gui.utils.calendar.SWTCalendar;
import com.blixx.boom.gui.utils.calendar.SWTCalendarEvent;
import com.blixx.boom.gui.utils.calendar.SWTCalendarListener;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public class CalendarDialog
extends Dialog
implements SWTCalendarListener {
    private SWTCalendar swtcal = null;
    SWTCalendarListener listener = null;
    SWTCalendarEvent calendarEvent = null;
    private Calendar calendar = null;
    private Locale defaultLocale = Locale.getDefault();

    public CalendarDialog(Shell parentShell) {
        super(parentShell);
        Locale.setDefault(Locale.US);
        this.calendar = Calendar.getInstance();
    }

    protected void configureShell(Shell newShell) {
        newShell.setText("Calendar");
        super.configureShell(newShell);
    }

    protected Control createDialogArea(Composite parent) {
        FormToolkit toolkit = new FormToolkit(Display.getDefault());
        ScrolledForm form = toolkit.createScrolledForm(parent);
        form.getBody().setLayout((Layout)new GridLayout(1, false));
        Section section = toolkit.createSection(form.getBody(), 256);
        section.setActiveToggleColor(toolkit.getHyperlinkGroup().getActiveForeground());
        GridData gd = new GridData(0x1000000, 0x1000000, true, false);
        section.setLayoutData((Object)gd);
        Composite client = toolkit.createComposite((Composite)section, 64);
        GridLayout layout = new GridLayout(3, false);
        client.setLayout((Layout)layout);
        toolkit.paintBordersFor(client);
        section.setText("Select your Date...");
        section.setClient((Control)client);
        section.setExpanded(true);
        this.swtcal = new SWTCalendar(client);
        gd = new GridData();
        gd.horizontalSpan = 3;
        gd.horizontalAlignment = 0x1000000;
        gd.verticalAlignment = 0x1000000;
        this.swtcal.setLayoutData(gd);
        this.swtcal.addSWTCalendarListener(this);
        this.swtcal.setCalendar(this.calendar);
        this.swtcal.setBackground(new Color((Device)Display.getCurrent(), 255, 255, 255));
        Label c1 = new Label(client, 0x800000);
        gd = new GridData(4, 0x1000000, true, false);
        gd.heightHint = 20;
        c1.setLayoutData((Object)gd);
        c1.setVisible(false);
        Button save = new Button(client, 0x800000);
        gd = new GridData(0x1000008, 0x1000000, false, false);
        save.setText("Save");
        save.setLayoutData((Object)gd);
        Button cancel = new Button(client, 0x800000);
        gd = new GridData(0x1000008, 0x1000000, false, false);
        cancel.setText("Cancel");
        cancel.setLayoutData((Object)gd);
        cancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CalendarDialog.this.close();
            }
        });
        save.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (CalendarDialog.this.calendarEvent != null && CalendarDialog.this.listener != null) {
                    CalendarDialog.this.listener.dateChanged(CalendarDialog.this.calendarEvent);
                }
                CalendarDialog.this.close();
            }
        });
        return client;
    }

    protected void createButtonsForButtonBar(Composite parent) {
    }

    public Calendar getCalendar() {
        return this.swtcal.getCalendar();
    }

    public void setDate(Date date) {
        this.calendar = Calendar.getInstance();
        this.calendar.setTime(date);
    }

    public void addDateChangedListener(SWTCalendarListener pListener) {
        this.listener = pListener;
    }

    protected void buttonPressed(int buttonId) {
        this.swtcal.removeSWTCalendarListener(this.listener);
        this.close();
    }

    @Override
    public void dateChanged(SWTCalendarEvent pCalendarEvent) {
        this.calendarEvent = pCalendarEvent;
    }

    public boolean close() {
        Locale.setDefault(this.defaultLocale);
        return super.close();
    }
}

