/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.utils.calendar;

import com.blixx.boom.gui.utils.calendar.RepeatingButton;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.IdentityHashMap;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TypedListener;

public class Spinner
extends Composite
implements FocusListener {
    private static final int BUTTON_WIDTH = 16;
    private IdentityHashMap selectionListeners = new IdentityHashMap(3);
    private int minimum;
    private int maximum;
    private boolean cyclic;
    private NumberFormat numberFormat = new DecimalFormat("0");
    private boolean settingValue;
    private boolean inFocus;
    private Text text;
    private RepeatingButton upButton;
    private RepeatingButton downButton;

    public Spinner(Composite parent, int style) {
        super(parent, style);
        this.setFont(parent.getFont());
        this.minimum = 0;
        this.maximum = 9;
        this.setBackground(this.getDisplay().getSystemColor(1));
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.verticalSpacing = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.horizontalSpacing = 0;
        this.setLayout((Layout)gridLayout);
        this.text = new Text((Composite)this, 131072);
        this.text.setFont(this.getFont());
        GridData gridData = new GridData(768);
        this.text.setLayoutData((Object)gridData);
        this.text.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent event) {
                Spinner.this.verify(event);
            }
        });
        this.text.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent event) {
                Spinner.this.traverse(event);
            }
        });
        this.text.addFocusListener((FocusListener)this);
        Composite buttonHolder = new Composite((Composite)this, 524288);
        buttonHolder.setFont(this.getFont());
        GridData gridData2 = new GridData(1296);
        gridData2.widthHint = 16;
        buttonHolder.setLayoutData((Object)gridData2);
        buttonHolder.setLayout((Layout)new FillLayout(512));
        this.upButton = new RepeatingButton(buttonHolder, 17301636);
        this.upButton.setFont(this.getFont());
        this.upButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Spinner.this.upInternal();
                Spinner.this.text.setFocus();
            }
        });
        this.downButton = new RepeatingButton(buttonHolder, 17302532);
        this.downButton.setFont(this.getFont());
        this.downButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Spinner.this.downInternal();
                Spinner.this.text.setFocus();
            }
        });
        this.setTabList(new Control[]{this.text});
        this.setValueInternal(this.minimum);
    }

    public void up() {
        this.settingValue = true;
        try {
            this.upInternal();
        }
        finally {
            this.settingValue = false;
        }
    }

    public void down() {
        this.settingValue = true;
        try {
            this.downInternal();
        }
        finally {
            this.settingValue = false;
        }
    }

    public void setValue(int value) {
        this.settingValue = true;
        try {
            this.setValueInternal(value);
        }
        finally {
            this.settingValue = false;
        }
    }

    public int getValue() {
        try {
            return this.numberFormat.parse(this.text.getText()).intValue();
        }
        catch (ParseException parseException) {
            return this.minimum;
        }
    }

    public void setMaximum(int maximum) {
        this.maximum = maximum;
        this.setValue(this.getValue());
    }

    public int getMaximum() {
        return this.maximum;
    }

    public void setMinimum(int minimum) {
        this.minimum = minimum;
        this.setValue(this.getValue());
    }

    public int getMinimum() {
        return this.minimum;
    }

    public boolean isCyclic() {
        return this.cyclic;
    }

    public void setCyclic(boolean cyclic) {
        this.cyclic = cyclic;
    }

    public void setRange(int minimum, int maximum, boolean cyclic) {
        this.minimum = minimum;
        this.maximum = maximum;
        this.cyclic = cyclic;
        this.setValueInternal(this.getValue());
    }

    public NumberFormat getNumberFormat() {
        return this.numberFormat;
    }

    public void setNumberFormat(NumberFormat numberFormat) {
        int val = this.getValue();
        this.numberFormat = numberFormat;
        this.setValue(val);
    }

    public int getInitialRepeatDelay() {
        return this.upButton.getInitialRepeatDelay();
    }

    public void setInitialRepeatDelay(int initialRepeatDelay) {
        this.upButton.setInitialRepeatDelay(initialRepeatDelay);
        this.downButton.setInitialRepeatDelay(initialRepeatDelay);
    }

    public int getRepeatDelay() {
        return this.upButton.getRepeatDelay();
    }

    public void setRepeatDelay(int repeatDelay) {
        this.upButton.setRepeatDelay(repeatDelay);
        this.downButton.setRepeatDelay(repeatDelay);
    }

    public void setFont(Font font) {
        super.setFont(font);
        if (this.text != null) {
            this.text.setFont(font);
        }
    }

    public boolean isSettingValue() {
        return this.settingValue;
    }

    public void addModifyListener(ModifyListener listener) {
        this.text.addModifyListener(listener);
    }

    public void removeModifyListener(ModifyListener listener) {
        this.text.removeModifyListener(listener);
    }

    public void addSelectionListener(SelectionListener listener) {
        if (listener == null) {
            throw new SWTError(4);
        }
        TypedListener typedListener = new TypedListener((SWTEventListener)listener);
        this.selectionListeners.put(listener, typedListener);
        this.addListener(13, (Listener)typedListener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        if (listener == null) {
            throw new SWTError(4);
        }
        TypedListener typedListener = (TypedListener)this.selectionListeners.remove(listener);
        if (typedListener != null) {
            this.removeListener(13, (Listener)typedListener);
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        if (wHint == -1) {
            GC gc = new GC((Drawable)this.text);
            wHint = Math.max(gc.textExtent((String)this.numberFormat.format((long)((long)this.maximum))).x, gc.textExtent((String)this.numberFormat.format((long)((long)this.maximum))).x);
            gc.dispose();
        }
        Point size = this.text.computeSize(wHint, hHint, changed);
        size.x += 16;
        if ((this.getStyle() & 0x800) != 0) {
            int border = this.getBorderWidth();
            size.x += border * 2;
            size.y += border * 2 + 3;
        }
        size.y = size.y + 1 & 0xFFFFFFFE;
        return size;
    }

    protected void upInternal() {
        int val = this.getValue();
        if (++val > this.maximum) {
            val = this.cyclic ? this.minimum : this.maximum;
        }
        this.setValueInternal(val);
        this.notifyListeners(13, new Event());
    }

    protected void downInternal() {
        int val = this.getValue();
        if (--val < this.minimum) {
            val = this.cyclic ? this.maximum : this.minimum;
        }
        this.setValueInternal(val);
        this.notifyListeners(13, new Event());
    }

    protected void setValueInternal(int value) {
        if (value < this.minimum) {
            value = this.minimum;
        } else if (value > this.maximum) {
            value = this.maximum;
        }
        String str = this.numberFormat.format(value);
        if (!str.equals(this.text.getText())) {
            this.text.setText(str);
        }
    }

    private void verify(VerifyEvent event) {
        int i = 0;
        while (i < event.text.length()) {
            char c = event.text.charAt(i);
            if (!(Character.isDigit(c) || this.minimum < 0 && c == '-' && i == 0 && event.start == 0 || this.numberFormat.format(this.minimum).indexOf(c) >= 0)) {
                event.doit = false;
                break;
            }
            ++i;
        }
    }

    private void traverse(TraverseEvent event) {
        switch (event.detail) {
            case 32: {
                if (event.keyCode != 0x1000001) break;
                event.doit = true;
                event.detail = 0;
                this.upInternal();
                break;
            }
            case 64: {
                if (event.keyCode != 0x1000002) break;
                event.doit = true;
                event.detail = 0;
                this.downInternal();
            }
        }
    }

    public void focusGained(FocusEvent focusEvent) {
        if (!this.inFocus) {
            this.inFocus = true;
            Event event = new Event();
            event.time = focusEvent.time;
            this.notifyListeners(15, event);
        }
    }

    public void focusLost(FocusEvent focusEvent) {
        if (!this.isFocusControl()) {
            this.inFocus = false;
            Event event = new Event();
            event.time = focusEvent.time;
            this.notifyListeners(16, event);
        }
    }

    public boolean isFocusControl() {
        Control control = this.getDisplay().getFocusControl();
        return control == this || control == this.text;
    }
}

