/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.engine.UIJob;
import com.blixx.boom.engine.UIJobManager;
import com.blixx.boom.gui.dialogs.NameValidatorPolicyName;
import com.blixx.boom.gui.dialogs.PVDialog;
import com.blixx.boom.gui.dialogs.ShowMessageBox;
import com.blixx.boom.gui.policies.PolicyManager;
import com.blixx.boom.gui.policies.PolicyTreeProvider;
import com.blixx.boom.gui.utils.GUIDisplayElements;
import com.blixx.boom.gui.utils.ImageCombo;
import com.blixx.boom.gui.utils.PatternValidator;
import com.blixx.boom.gui.views.ConditionOverviewManager;
import com.blixx.boom.gui.views.PolicyView;
import com.blixx.boom.gui.views.actions.AddDefaultContentMenuAction;
import com.blixx.ctrl.sc.ICmdPostProcess;
import com.blixx.ctrl.sc.ServerClient;
import com.blixx.ctrl.sc.in.ScGetHistoryVersions;
import com.blixx.ctrl.sc.in.ScUpdatePolicy;
import com.blixx.log.RTLogger;
import com.blixx.shared.AbstractPolicy;
import com.blixx.shared.Cryptor;
import com.blixx.shared.PatternB;
import com.blixx.shared.Policy;
import com.blixx.shared.PolicyFactory;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.GroupTreeObjectLast;
import com.blixx.shared.utils.GroupTreeObjectUnsubmitted;
import java.io.File;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractPolicyTab<K extends AbstractPolicy>
extends CTabItem
implements ICmdPostProcess,
ModifyListener,
SelectionListener,
DisposeListener {
    public static final String SLAVE_SERVER = "SLAVE_SERVER";
    public static final String OLDVERSION_DATA = "OLDVERSION";
    public static final String CLOSE_DATA = "CLOSE";
    public static final String ACTIVATE_IF_VAR = "ENABLED_IF_VAR";
    public static final String ACTIVATE_IF_PATTERN = "ENABLED_IF_PATTERN";
    public static String HAS_VERSION_CONFLICT = "has_version_confict";
    public static String TREE_PATH = "tree_Path";
    public static String DIRTY_STATUS = "dirty_Status";
    public static final String POLICY_NAME = "POLICY_NAME";
    public static String SEARCH_GLOBAL_PATH = "Search Path: \nGLOBAL";
    public static String SEARCH_LOCAL_PATH = "Search Path: \ni.e. <agent/spi/>";
    public static String SEARCH_LOCAL_PATH_TOOLTIP = "For GLOBAL Search, \nadd a '#' at the begin of the first line.";
    public static String SEARCH_GLOBAL_PATH_TOOLTIP = "For LOCAL Search, \nremove the '#' from the first line.";
    public static String NEWER_VERSION_AVAILABLE = "Newest Server Version";
    public static String SAVE_WITH_NEXT_VERSION = "SAVE_WITH_NEWER_VERSION";
    public static final String POLICY_VERSIONS_ACTION = "POLICY_VERSIONS_ACTION";
    public static final String POLICY_VERSIONS = "POLICY_VERSIONS";
    public static String POLICYNAME = "policyName";
    public static String BUTTON_SCHEDULER = "Deactivation Schedule";
    public static String BUTTON_SAVE = "save";
    public static String BUTTON_UNDO = "undo";
    public static String BUTTON_UP = "Up";
    public static String BUTTON_DOWN = "Down";
    public static String BUTTON_TOP = "Top";
    public static String BUTTON_BOTTOM = "Bottom";
    public static String BUTTON_ADD = "add";
    public static String BUTTON_COPY = "copy";
    public static String BUTTON_DELETE = "delete";
    public static String MOVE_UP = "Move One Up";
    public static String MOVE_DOWN = "Move One Down";
    public static String MOVE_TOP = "Move to Top";
    public static String MOVE_BOTTOM = "Move to Bottom";
    protected static String DETAILS = "Details";
    protected static String OVERVIEW = "Overview";
    public static String[] SEVERITY_LIST = new String[]{"unknown", "normal", "warning", "minor", "major", "critical", ""};
    public String m_selectedCondUUID = null;
    public GUIDisplayElements m_gui = null;
    public PolicyView m_pView = null;
    protected boolean isDirty = false;
    private boolean isNew = false;
    protected boolean m_init = true;
    protected AtomicBoolean m_isReadOnly = null;
    protected String m_pNameUnsubmitted_orig = null;
    public Button m_save_Button = null;
    public Button m_undo_Button = null;
    public Button m_up_Button = null;
    public Button m_down_Button = null;
    public Button m_top_Button = null;
    public Button m_bottom_Button = null;
    public Button m_add_Button = null;
    public Button m_copy_Button = null;
    public Button m_delete_Button = null;
    public Button m_scheduler_Button = null;
    public Button m_saveWithNewerVersion_check = null;
    protected ConditionOverviewManager m_condManager = null;
    protected Table m_overviewTable = null;
    protected TableViewer m_overview_tv = null;
    public String m_selectedCondTab = DETAILS;
    public Text m_activateIFVarName_Field = null;
    public StyledText m_activateIFPattern_Field = null;
    protected AbstractPolicyTab<K> m_tab = this;
    public AbstractPolicy m_policy = null;
    public String m_treePath = null;
    public Clipboard m_systemClipboard = null;
    protected TreeViewer m_treeViewer = null;
    protected CTabFolder m_policyFolder = null;
    protected Composite m_compositeInCtab = null;
    protected Label m_policyVersionInfo_Field = null;
    protected Label m_policyVersion_Field = null;
    public CCombo m_policyVersion_FieldDD = null;
    public Label m_plugInName_Field = null;
    public Text m_policyName_Field = null;
    protected Button m_compare = null;
    private Label m_readOnly;
    public boolean m_isPolicyNameValid = true;

    public AbstractPolicyTab(CTabFolder parent, int style, int index, TreeViewer treeViewer, AbstractPolicy mp, String treePath, String selectedCondUUID, boolean _isNew) {
        super(parent, style, index);
        this.m_pView = PolicyView.getInstance();
        this.m_gui = new GUIDisplayElements();
        this.m_systemClipboard = new Clipboard(Display.getCurrent());
        this.setNew(_isNew);
        this.m_treeViewer = treeViewer;
        try {
            GroupTreeObject gto = PolicyManager.getInstance().getPolicyTree().searchPath(treePath, BMUI.type_folder);
            if (gto != null && gto instanceof GroupTreeObjectLast) {
                treePath = gto.getParentPath();
            }
        }
        catch (Throwable throwable) {}
        this.m_treePath = treePath;
        this.m_policyFolder = parent;
        this.m_policy = mp;
        this.setText(((AbstractPolicy)this.getPolicy()).getName());
        this.setData(POLICY_NAME, ((AbstractPolicy)this.getPolicy()).getName());
        this.setData(TREE_PATH, this.m_treePath);
        this.setData(DIRTY_STATUS, this.isDirty);
        this.setData(HAS_VERSION_CONFLICT, false);
        this.addDisposeListener(this);
        if (this.isNew()) {
            this.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_NEW_WIZARD"));
            this.m_pNameUnsubmitted_orig = ((AbstractPolicy)this.getPolicy()).getName();
        } else {
            Image im = BMUI.IMAGE_MAP.get(this.getPolicyType());
            this.setImage(im);
            PolicyView.checkPowerGroups(mp, this);
        }
    }

    public void setDirty(boolean b) {
        if (this.isDisposed() || this.isReadOnly()) {
            return;
        }
        this.isDirty = b;
        if (!this.m_save_Button.isDisposed()) {
            this.m_save_Button.setEnabled(b);
        }
        if (!this.m_undo_Button.isDisposed() && !this.isNew()) {
            this.m_undo_Button.setEnabled(b);
        }
        this.setData(DIRTY_STATUS, this.isDirty);
        if (!this.getText().startsWith("*") && b) {
            this.setText("* " + this.getText());
        } else if (this.getText().startsWith("*") && !b) {
            this.setText("" + this.getData(POLICY_NAME));
        }
    }

    public boolean isNew() {
        return this.isNew;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    protected void processReadOnly() {
        this.m_gui.enableField(this.m_save_Button, !this.isReadOnly());
        this.m_gui.enableField(this.m_undo_Button, !this.isReadOnly());
        this.m_readOnly.setVisible(this.isReadOnly());
        if (BMUI.type_mon.equals(this.getPolicyType())) {
            this.setImage(this.isReadOnly() ? BMUI.IMAGE_MON_LOCK : BMUI.IMAGE_MON);
        } else if (BMUI.type_msg.equals(this.getPolicyType())) {
            this.setImage(this.isReadOnly() ? BMUI.IMAGE_MSG_LOCK : BMUI.IMAGE_MSG);
        }
    }

    public void setReadOnlyFlag(boolean readOnly) {
        if (this.m_isReadOnly == null) {
            this.m_isReadOnly = new AtomicBoolean(readOnly);
        }
    }

    public boolean isReadOnly() {
        int rights = Repository.getInstance().getRights(1001);
        boolean res = this.m_isReadOnly == null ? rights < 3 : this.m_isReadOnly.get();
        return res;
    }

    private void setNew(boolean b) {
        this.isNew = b;
    }

    public void setActivateIF() {
        String varName;
        ((AbstractPolicy)this.getPolicy()).setEnabledIF("");
        if (this.m_activateIFVarName_Field != null && !this.m_activateIFVarName_Field.isDisposed() && (varName = this.m_activateIFVarName_Field.getText().trim()).length() > 0) {
            String varPattern = this.m_activateIFPattern_Field.getText().trim();
            StringBuffer sb = new StringBuffer();
            sb.append(varName).append('=').append(varPattern);
            ((AbstractPolicy)this.getPolicy()).setEnabledIF(sb.toString());
        }
    }

    public void setEditableFalse(Widget obj) {
        if (obj == null) {
            return;
        }
        if (obj instanceof Text) {
            Text t = (Text)obj;
            if (t.isDisposed()) {
                return;
            }
            t.setEditable(false);
            t.setBackground(BMUI.defaultBackground);
        } else if (obj instanceof StyledText) {
            StyledText t = (StyledText)obj;
            if (t.isDisposed()) {
                return;
            }
            t.setEditable(false);
            t.setBackground(BMUI.defaultBackground);
        } else if (obj instanceof CCombo) {
            CCombo c = (CCombo)obj;
            if (c.isDisposed()) {
                return;
            }
            c.setEnabled(false);
            c.setBackground(BMUI.defaultBackground);
        } else if (obj instanceof ImageCombo) {
            ImageCombo c = (ImageCombo)obj;
            if (c.isDisposed()) {
                return;
            }
            c.setEnabled(false);
            c.setBackground(BMUI.defaultBackground);
        } else if (obj instanceof Button) {
            Button b = (Button)obj;
            if (b.isDisposed()) {
                return;
            }
            b.setEnabled(false);
            if (((String)b.getData()).equals("16") || ((String)b.getData()).equals("32")) {
                b.setForeground(BMUI.color_black);
            }
        }
    }

    protected void createPolicyVersionAndActivateIfPart(Composite sectionClient, String polType) {
        Boolean hasVersionConflictObj = (Boolean)this.getData(HAS_VERSION_CONFLICT);
        boolean hasVersionConflict = false;
        if (hasVersionConflictObj != null) {
            hasVersionConflict = hasVersionConflictObj;
        }
        GridLayout la = (GridLayout)sectionClient.getLayout();
        Composite comp1 = new Composite(sectionClient, 0);
        comp1.setLayoutData((Object)new GridData(4, 128, true, false, la.numColumns, 1));
        GridLayout gl = new GridLayout(6, false);
        gl.marginHeight = 0;
        gl.marginTop = 0;
        comp1.setLayout((Layout)gl);
        this.m_policyVersion_Field = this.m_gui.addTextField(comp1, "Policy Version: ", ((AbstractPolicy)this.getPolicy()).getVersion().toString(), 1, 1, 0, 2, BMUI.font_arial8_bold);
        ((GridData)this.m_policyVersion_Field.getLayoutData()).widthHint = 70;
        ((GridData)this.m_policyVersion_Field.getLayoutData()).horizontalIndent = 13;
        if (!this.isNew()) {
            ScGetHistoryVersions scv = new ScGetHistoryVersions(Repository.getInstance(), ((AbstractPolicy)this.getPolicy()).getName(), this.getPolicyType());
            scv.run();
            if (scv.isSuccess()) {
                Object versions = scv.getResultObject();
                String[] array = versions.toArray(new String[0]);
                this.m_policyVersion_FieldDD = this.m_gui.addDropDown(comp1, POLICY_VERSIONS, null, array, array[0], null, 1, 1, 0, 0, this);
                ((GridData)this.m_policyVersion_FieldDD.getLayoutData()).horizontalAlignment = 1;
                if (hasVersionConflict) {
                    this.m_policyVersion_FieldDD.add(NEWER_VERSION_AVAILABLE, 0);
                    this.m_policyVersion_FieldDD.pack(true);
                    this.m_policyVersion_FieldDD.select(0);
                }
                this.m_compare = this.m_gui.addButton(comp1, POLICY_VERSIONS_ACTION, " Compare ", true, 70, 20, 0, this);
            } else {
                this.m_gui.addTextField(comp1, null, "", 2, 1, 0, 0, null);
            }
        } else {
            this.m_gui.addTextField(comp1, null, "", 2, 1, 0, 0, null);
        }
        this.m_readOnly = new Label(comp1, 0);
        this.m_readOnly.setText(" Read only! ");
        this.m_readOnly.setFont(BMUI.font_arial8_italic);
        this.m_readOnly.setForeground(BMUI.color_critical);
        this.m_readOnly.setLayoutData((Object)new GridData(16384, 128, true, true));
        if (!this.isReadOnly()) {
            this.m_readOnly.setVisible(false);
        }
        if (hasVersionConflict) {
            this.m_policyVersionInfo_Field = this.m_gui.addTextField(comp1, null, "Version Conflict: A newer version is available on the Server!", 1, 1, 0, 0, BMUI.font_arial8_bold);
            ((GridData)this.m_policyVersionInfo_Field.getLayoutData()).horizontalIndent = 20;
            this.m_policyVersionInfo_Field.setForeground(BMUI.color_critical);
            this.m_gui.addTextField(comp1, null, "", 2, 1, 0, 0, null);
            Composite c = new Composite(comp1, 0);
            c.setLayoutData((Object)new GridData(16384, 128, false, false, 2, 1));
            c.setLayout((Layout)new GridLayout(2, false));
            this.m_saveWithNewerVersion_check = this.m_gui.addCheckbox(c, SAVE_WITH_NEXT_VERSION, null, false, 1, 1, 0, this);
            ((GridData)this.m_saveWithNewerVersion_check.getLayoutData()).horizontalAlignment = 131072;
            Label l = this.m_gui.addTextField(c, null, "Save with next Version", 1, 1, 0, 0, BMUI.font_arial8_bold);
            l.setForeground(BMUI.color_critical);
        }
        Composite comp2 = new Composite(sectionClient, 0);
        comp2.setLayoutData((Object)new GridData(4, 128, true, false, la.numColumns, 1));
        gl = new GridLayout(4, false);
        gl.marginHeight = 0;
        gl.marginBottom = 1;
        gl.marginTop = 1;
        comp2.setLayout((Layout)gl);
        String polName = ((AbstractPolicy)this.getPolicy()).getName();
        if (this.isNew()) {
            this.m_policyName_Field = this.m_gui.addInputFieldSingle(comp2, POLICYNAME, "Policy Name:   ", polName, 3, 1, 3, 0, 80, this);
            ((GridData)this.m_policyName_Field.getLayoutData()).horizontalAlignment = 4;
            ((GridData)this.m_policyName_Field.getLayoutData()).grabExcessHorizontalSpace = true;
            NameValidatorPolicyName validation = new NameValidatorPolicyName();
            String validatorError = validation.isValid(this.m_policyName_Field.getText().trim());
            boolean bl = this.m_isPolicyNameValid = validatorError == null;
            if (!this.m_isPolicyNameValid) {
                if (polName.equals(this.getPolicyNameUnsubmitted())) {
                    this.m_isPolicyNameValid = true;
                } else {
                    this.m_policyName_Field.setBackground(BMUI.color_critical);
                }
            }
            this.m_policyName_Field.setToolTipText(validatorError);
            this.m_plugInName_Field = this.m_gui.addTextField(comp2, "Plugin Name: ", ((AbstractPolicy)this.getPolicy()).getSpiName().toString(), 3, 1, 1, 3, BMUI.font_arial8_bold);
        } else {
            this.m_gui.addTextReadOnlyNoBorder(comp2, "Policy Name: ", polName, 1, 1, 2, 1, BMUI.font_arial8_bold);
            this.m_plugInName_Field = this.m_gui.addTextField(comp2, "Plugin Name: ", ((AbstractPolicy)this.getPolicy()).getSpiName().toString(), 1, 1, 1, 10, BMUI.font_arial8_bold);
        }
        Composite comp3 = new Composite(sectionClient, 0);
        gl = new GridLayout(2, false);
        gl.horizontalSpacing = 0;
        gl.verticalSpacing = 0;
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        comp3.setLayout((Layout)gl);
        comp3.setLayoutData((Object)new GridData(4, 4, true, false, la.numColumns, 1));
        Group activation_grp = new Group(comp3, 4);
        activation_grp.setText("Activate If");
        gl = new GridLayout(4, false);
        gl.marginHeight = 0;
        gl.marginBottom = 4;
        activation_grp.setLayout((Layout)gl);
        activation_grp.setLayoutData((Object)new GridData(4, 4, true, false));
        String varName = ((AbstractPolicy)this.getPolicy()).getEnabledIfVariable();
        if (varName == null) {
            varName = "";
        }
        this.m_activateIFVarName_Field = this.m_gui.addInputFieldSingle((Composite)activation_grp, ACTIVATE_IF_VAR, "Global Variable ", varName, 1, 1, 4, 0, 150, this);
        this.m_activateIFVarName_Field.setToolTipText("Specify Agent's Global Variable Name\nI.e. CLUSTER_NAME");
        ((GridData)this.m_activateIFVarName_Field.getLayoutData()).horizontalAlignment = 1;
        ((GridData)this.m_activateIFVarName_Field.getLayoutData()).grabExcessHorizontalSpace = false;
        this.m_activateIFVarName_Field.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 32) {
                    e.doit = false;
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        String patternStr = "";
        PatternB patternB = ((AbstractPolicy)this.getPolicy()).getEnabledIfPattern();
        if (patternB != null && (patternStr = patternB.getOvPattern()) == null) {
            patternStr = "";
        }
        this.m_activateIFPattern_Field = this.m_gui.addStyledText((Composite)activation_grp, " matches Pattern ", ACTIVATE_IF_PATTERN, patternStr, 1, 1, 1, 0, this);
        ((GridData)this.m_activateIFPattern_Field.getLayoutData()).horizontalAlignment = 4;
        ((GridData)this.m_activateIFPattern_Field.getLayoutData()).grabExcessHorizontalSpace = true;
        AbstractPolicyTab.addContentMenu4PatternField((Widget)this.m_activateIFPattern_Field, false, null);
        if (varName.trim().isEmpty()) {
            this.m_gui.enableField(this.m_activateIFPattern_Field, false);
        } else {
            AbstractPolicyTab.validatePattern(this.m_activateIFPattern_Field);
        }
        this.m_scheduler_Button = this.m_gui.addButton(comp3, BUTTON_SCHEDULER, BUTTON_SCHEDULER, true, 35, 20, 5, this);
        ((GridData)this.m_scheduler_Button.getLayoutData()).horizontalIndent = 15;
        ((GridData)this.m_scheduler_Button.getLayoutData()).verticalAlignment = 0x1000000;
        ((GridData)this.m_scheduler_Button.getLayoutData()).grabExcessVerticalSpace = true;
    }

    public void createLowButtons(Composite compositeInCtab) {
        Composite compLine = new Composite(compositeInCtab, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        compLine.setLayout((Layout)gridLayout);
        compLine.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        Label line = new Label(compLine, 259);
        line.setForeground(BMUI.color_darkGrey2);
        line.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        Composite compBtn = new Composite(compositeInCtab, 0);
        gridLayout = new GridLayout(2, true);
        gridLayout.marginHeight = 0;
        gridLayout.marginBottom = 0;
        compBtn.setLayout((Layout)gridLayout);
        compBtn.setLayoutData((Object)new GridData(16384, 4, false, false, 1, 1));
        this.m_save_Button = this.m_gui.addButton(compBtn, BUTTON_SAVE, "&Save Policy", false, 90, 30, 0, this);
        this.m_save_Button.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        this.m_undo_Button = this.m_gui.addButton(compBtn, BUTTON_UNDO, "&Undo Changes", false, 90, 30, 0, this);
        this.m_undo_Button.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
    }

    public boolean checkPolicyVersion(String policyType) {
        boolean isOk = true;
        PolicyManager pm = PolicyManager.getInstance();
        GroupTreeObject root = pm.getPolicyTree();
        PolicyFactory pf = new PolicyFactory();
        if (this.isNew()) {
            GroupTreeObject target_gto;
            GroupTreeObjectLast gtol = root.findElement(((AbstractPolicy)this.getPolicy()).getName(), policyType);
            if (gtol != null && !(gtol instanceof GroupTreeObjectUnsubmitted)) {
                isOk = false;
                new ShowMessageBox("Save Policy", "Policy Name already exists. Please enter a different name!", 1);
            }
            if ((target_gto = root.searchPath(this.m_treePath, BMUI.type_folder)) == null) {
                this.m_treePath = "/root/Policies";
            }
        } else if (this.m_saveWithNewerVersion_check != null && !this.m_saveWithNewerVersion_check.isDisposed() && this.m_saveWithNewerVersion_check.isVisible() && this.m_saveWithNewerVersion_check.getSelection()) {
            File fileP = Repository.getInstance().fetchFile(((AbstractPolicy)this.getPolicy()).getName(), String.valueOf(policyType) + ".xml");
            if (fileP != null) {
                try {
                    Policy verP = pf.initPolicy(fileP);
                    ((AbstractPolicy)this.getPolicy()).setVersion(PolicyFactory.getNextVersion(verP.getVersion()));
                }
                catch (Throwable throwable) {
                    isOk = false;
                }
            } else {
                new ShowMessageBox("Error saving Policy", "Error saving the Policy " + ((AbstractPolicy)this.getPolicy()).getName(), 1);
            }
        } else {
            ((AbstractPolicy)this.getPolicy()).setVersion(PolicyFactory.getNextVersion(((AbstractPolicy)this.getPolicy()).getVersion()));
        }
        return isOk;
    }

    public abstract void internalRestore(String var1);

    public abstract K getPolicy();

    public abstract String getPolicyType();

    public void postProcess(ServerClient sc0) {
        PostProcess pr = new PostProcess(this, sc0);
        UIJobManager.getInstance().schedule(pr);
    }

    public static void addContentMenu4PatternField(final Widget field, final boolean activateEncoding, final Shell shell) {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        if (field instanceof Text) {
            Menu menu = menuMgr.createContextMenu((Control)((Text)field));
            ((Text)field).setMenu(menu);
        } else if (field instanceof StyledText) {
            Menu menu = menuMgr.createContextMenu((Control)((StyledText)field));
            ((StyledText)field).setMenu(menu);
        }
        PolicyView.getInstance().getSite().registerContextMenu(menuMgr, null);
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                try {
                    if (activateEncoding) {
                        manager.add((IAction)new Action(){

                            public String getText() {
                                return "Encode";
                            }

                            public void run() {
                                String sel = "";
                                if (field instanceof Text) {
                                    Text text = (Text)field;
                                    sel = text.getSelectionText();
                                    String enc = Cryptor.encrypt(sel);
                                    enc = "<$BOOMMON_ONINIT($$" + enc + ")>";
                                    text.cut();
                                    text.insert(enc);
                                } else if (field instanceof StyledText) {
                                    StyledText styledText = (StyledText)field;
                                    sel = styledText.getSelectionText();
                                    String enc = Cryptor.encrypt(sel);
                                    enc = "<$BOOMMON_ONINIT($$" + enc + ")>";
                                    styledText.cut();
                                    styledText.insert(enc);
                                }
                            }
                        });
                    }
                    manager.add((IAction)new Action(){

                        public String getText() {
                            return "Pattern Validation";
                        }

                        public ImageDescriptor getImageDescriptor() {
                            return BMUI.IMAGE_DESCRIPTOR_ACCEPT_GREEN;
                        }

                        public void run() {
                            String sel = "";
                            if (field instanceof Text) {
                                sel = ((Text)field).getText();
                            } else if (field instanceof StyledText) {
                                sel = ((StyledText)field).getText();
                            }
                            PVDialog pvd = new PVDialog(sel, shell, PatternValidator.JAVA);
                            pvd.open();
                        }
                    });
                    manager.add((IContributionItem)new Separator());
                    manager.add((IAction)new AddDefaultContentMenuAction(field, 1, true));
                    manager.add((IAction)new AddDefaultContentMenuAction(field, 2, true));
                    manager.add((IAction)new AddDefaultContentMenuAction(field, 3, true));
                    manager.add((IAction)new AddDefaultContentMenuAction(field, 4, true));
                    manager.add((IContributionItem)new Separator());
                    manager.add((IAction)new AddDefaultContentMenuAction(field, 5, true));
                    manager.add((IContributionItem)new Separator());
                }
                catch (RuntimeException e) {
                    RTLogger.print(5, "Error creating context menu", e);
                }
            }
        });
    }

    public static boolean validatePattern(StyledText styledText) {
        boolean isValid;
        block11: {
            block7: {
                String pattern = styledText.getText().trim();
                isValid = false;
                if (pattern == null) {
                    pattern = "";
                }
                int length = pattern.length();
                boolean isValidated = false;
                try {
                    Pattern.compile(pattern, 32);
                    isValidated = true;
                }
                catch (PatternSyntaxException patternSyntaxException) {}
                if (length <= 0 || !isValidated) break block7;
                isValid = true;
                styledText.setBackground(BMUI.color_light_green);
                StyleRange range = new StyleRange();
                range.foreground = BMUI.color_black;
                range.start = 0;
                range.length = styledText.getText().length();
                styledText.setStyleRange(range);
                RTLogger.print(5, String.valueOf(System.currentTimeMillis()) + " = start processing styled text");
                boolean started = false;
                int start = -1;
                int brackets = 0;
                int i = 0;
                while (i < pattern.length()) {
                    block9: {
                        block10: {
                            block8: {
                                if (pattern.charAt(i) != '(') break block8;
                                if (i > 0 && pattern.charAt(i - 1) == '\\' || i < pattern.length() && pattern.charAt(i + 1) == '?' && pattern.charAt(i + 2) == ':') break block9;
                                if (!started) {
                                    started = true;
                                    start = i;
                                }
                                ++brackets;
                                break block10;
                            }
                            if (started && pattern.charAt(i) == ')') {
                                --brackets;
                            }
                        }
                        if (started && brackets == 0) {
                            StyleRange range1 = new StyleRange();
                            range1.foreground = BMUI.color_lightblue;
                            range1.start = start;
                            range1.length = i + 1 - start;
                            styledText.setStyleRange(range1);
                            started = false;
                        }
                    }
                    ++i;
                }
                break block11;
            }
            isValid = false;
            styledText.setBackground(BMUI.color_light_red);
            StyleRange range = new StyleRange();
            range.foreground = BMUI.color_black;
            range.start = 0;
            range.length = styledText.getText().length();
            styledText.setStyleRange(range);
        }
        return isValid;
    }

    public static boolean validatePattern(String pattern) {
        boolean isValid = false;
        if (pattern == null) {
            pattern = "";
        }
        int length = pattern.length();
        boolean isValidated = false;
        try {
            Pattern.compile(pattern, 32);
            isValidated = true;
        }
        catch (PatternSyntaxException patternSyntaxException) {}
        isValid = length > 0 && isValidated;
        return isValid;
    }

    public String getPolicyNameUnsubmitted() {
        return this.m_pNameUnsubmitted_orig;
    }

    public class PostProcess
    extends UIJob {
        AbstractPolicyTab<K> m_tabObj;
        ServerClient m_sc;

        public PostProcess(AbstractPolicyTab<K> tab, ServerClient sc) {
            super(null);
            this.m_tabObj = null;
            this.m_sc = null;
            this.m_tabObj = tab;
            this.m_sc = sc;
        }

        @Override
        public IStatus runInUIThread(IProgressMonitor monitor) {
            block20: {
                try {
                    if (this.m_sc instanceof ScGetHistoryVersions) {
                        if (this.m_tabObj.getControl() != null) {
                            this.m_tabObj.getControl().dispose();
                        }
                        AbstractPolicyTab.this.internalRestore(AbstractPolicyTab.this.m_selectedCondUUID);
                        break block20;
                    }
                    if (!(this.m_sc instanceof ScUpdatePolicy)) break block20;
                    ScUpdatePolicy sc = (ScUpdatePolicy)this.m_sc;
                    if (sc.isSuccess()) {
                        boolean closeTab;
                        boolean wasNew = AbstractPolicyTab.this.isNew();
                        RTLogger.print(4, "Policy has been saved: " + sc.getFileName());
                        if (wasNew) {
                            AbstractPolicyTab.this.setNew(false);
                            try {
                                AbstractPolicyTab.this.isDirty = false;
                                PolicyView.closeTab(AbstractPolicyTab.this.m_pNameUnsubmitted_orig);
                                PolicyManager.getInstance().removeUnsubmitted(AbstractPolicyTab.this.m_pNameUnsubmitted_orig, AbstractPolicyTab.this.getPolicyType());
                            }
                            catch (Throwable throwable) {}
                        }
                        if (closeTab = ((Boolean)sc.getData(AbstractPolicyTab.CLOSE_DATA)).booleanValue()) {
                            if (!this.m_tabObj.isDisposed()) {
                                this.m_tabObj.dispose();
                            }
                            break block20;
                        }
                        AbstractPolicyTab.this.setDirty(false);
                        if (wasNew) {
                            try {
                                PolicyView.displayPolicy(((AbstractPolicy)AbstractPolicyTab.this.getPolicy()).getName(), AbstractPolicyTab.this.getPolicyType(), AbstractPolicyTab.this.m_treePath, null);
                            }
                            catch (RuntimeException runtimeException) {}
                            Repository.getInstance().fetchPolicies(true);
                            PolicyTreeProvider.getInstance().setTreeSelection(((AbstractPolicy)AbstractPolicyTab.this.getPolicy()).getName(), AbstractPolicyTab.this.getPolicyType());
                            break block20;
                        }
                        AbstractPolicyTab.this.setData(HAS_VERSION_CONFLICT, false);
                        ScGetHistoryVersions scn = new ScGetHistoryVersions(Repository.getInstance(), ((AbstractPolicy)AbstractPolicyTab.this.getPolicy()).getName(), BMUI.type_mon);
                        scn.addCmdPostProcess(this.m_tabObj);
                        scn.start();
                        break block20;
                    }
                    try {
                        if (sc.getResultObject().contains("Version")) {
                            AbstractPolicyTab.this.setData(HAS_VERSION_CONFLICT, true);
                        } else {
                            MessageDialog.openError((Shell)this.m_tabObj.getControl().getShell(), (String)"Error saving Policy", (String)sc.getResultObject());
                        }
                    }
                    catch (Throwable throwable) {}
                    String oldPolicyVersion = (String)sc.getData(AbstractPolicyTab.OLDVERSION_DATA);
                    ((AbstractPolicy)AbstractPolicyTab.this.getPolicy()).setVersion(oldPolicyVersion);
                    try {
                        if (this.m_tabObj.getControl() != null) {
                            this.m_tabObj.getControl().dispose();
                        }
                    }
                    catch (Throwable throwable) {}
                    AbstractPolicyTab.this.internalRestore(AbstractPolicyTab.this.m_selectedCondUUID);
                }
                catch (Throwable throwable) {}
            }
            return Status.OK_STATUS;
        }
    }
}

