/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.engine.ServerClient;
import com.blixx.boom.gui.dialogs.ShowMessageBox;
import com.blixx.boom.gui.utils.GUIDisplayElements;
import com.blixx.boom.gui.views.ActionView;
import com.blixx.boom.gui.views.ActionsListView;
import com.blixx.log.RTLogger;
import com.blixx.shared.Action;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.GroupTreeObjectLast;
import com.blixx.shared.utils.GroupTreeObjectUnsubmitted;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class ActionTab
extends CTabItem
implements ModifyListener,
SelectionListener,
DisposeListener {
    private CTabFolder m_folder = null;
    private Action m_action = null;
    private String m_group = null;
    public String m_oldLabelName = null;
    private boolean m_isNew = false;
    public boolean m_isDirty = false;
    public boolean m_isLabelValid = true;
    public boolean m_isCallValid = true;
    public boolean m_isTimeoutValid = true;
    private GUIDisplayElements m_gui = null;
    private ScrolledComposite m_scroll;
    private Composite m_compositeInCtab = null;
    private Composite m_actDetailsComposite;
    private Button m_saveButton;
    private Button m_undoButton;
    private Button m_server_action_btn = null;
    private Text m_label_field = null;
    private Text m_call_field = null;
    private Text m_callType_field = null;
    private Text m_timeOut_field = null;
    private Text m_optional_params_field = null;
    private Text m_description_field = null;
    private Text m_help_field = null;
    private static final String SERVER_ACTION = "SERVER_ACTION";
    private static final String HELP = "help";
    private static final String DESC = "desc";
    private static final String OPT_PARAMS = "OptParams";
    private static final String CALL = "Call";
    private static final String TIME_OUT = "TimeOut";
    private static final String LABEL = "Label";
    private static final String BUTTON_SAVE = "Save";
    private static final String BUTTON_UNDO = "Undo";
    public static String ACTION = "ACTION";
    public static String DIRTY_STATUS = "DIRTY_STATUS";

    public ActionTab(CTabFolder parent, int style, int position, Action action, String group, GroupTreeObjectLast gtol, boolean isNewAction) {
        super(parent, style);
        this.m_folder = parent;
        this.m_action = action;
        this.m_group = group;
        this.m_oldLabelName = this.m_action.m_label;
        this.setText(action.m_label);
        if (isNewAction) {
            this.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_NEW_WIZARD"));
        } else if (action.m_serverAction) {
            this.setImage(BMUI.IMAGE_ACTION_SERVER);
        } else {
            this.setImage(BMUI.IMAGE_ACTION);
        }
        this.m_gui = new GUIDisplayElements();
        this.setNew(isNewAction);
        this.setDirty(isNewAction);
        this.setData(ACTION, this.m_action);
        this.setData(DIRTY_STATUS, isNewAction);
        this.addDisposeListener(this);
        this.createMainArea();
    }

    public void internalRestore() {
        this.createMainArea();
    }

    public void createMainArea() {
        this.m_compositeInCtab = new Composite((Composite)this.m_folder, 0);
        this.m_compositeInCtab.setLayout((Layout)new GridLayout());
        this.m_scroll = new ScrolledComposite(this.m_compositeInCtab, 2816);
        this.m_scroll.setBackground(BMUI.color_grey);
        this.m_scroll.setAlwaysShowScrollBars(false);
        this.m_scroll.setExpandHorizontal(true);
        this.m_scroll.setExpandVertical(true);
        this.m_scroll.setLayout((Layout)new GridLayout(1, false));
        this.m_scroll.setLayoutData((Object)new GridData(4, 4, true, true));
        this.m_scroll.addListener(37, new Listener(){

            public void handleEvent(Event event) {
                ScrolledComposite sc = (ScrolledComposite)event.widget;
                sc.getVerticalBar().setIncrement(event.count * 4);
            }
        });
        this.m_actDetailsComposite = new Composite((Composite)this.m_scroll, 0);
        GridLayout gridLayout = new GridLayout(4, false);
        gridLayout.marginLeft = 12;
        gridLayout.marginRight = 12;
        gridLayout.marginTop = 12;
        this.m_actDetailsComposite.setLayout((Layout)gridLayout);
        this.m_actDetailsComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.m_label_field = this.m_gui.addInputFieldSingle(this.m_actDetailsComposite, LABEL, "Label: ", this.m_action.m_label, 3, 1, 0, 12, 60, this);
        this.m_call_field = this.m_gui.addInputFieldSingle(this.m_actDetailsComposite, CALL, "Call: ", this.m_action.m_call, 3, 1, 0, 5, 60, this);
        this.m_callType_field = this.m_gui.addTextReadOnly(this.m_actDetailsComposite, "Type: ", this.m_action.m_calltype, 3, 1, 0, 5, null, null);
        ((GridData)this.m_callType_field.getLayoutData()).horizontalAlignment = 1;
        ((GridData)this.m_callType_field.getLayoutData()).widthHint = 150;
        if (this.m_action.m_call.startsWith("IAction ")) {
            this.m_callType_field.setText("JAVA_ACTION");
        }
        new Label(this.m_actDetailsComposite, 0);
        this.m_server_action_btn = this.m_gui.addCheckbox(this.m_actDetailsComposite, SERVER_ACTION, "Server Action", this.m_action.m_serverAction, 3, 1, 5, this);
        this.m_timeOut_field = this.m_gui.addInputFieldSingle(this.m_actDetailsComposite, TIME_OUT, "Timeout (sec): ", "" + this.m_action.m_timeoutSeconds, 3, 1, 0, 5, 50, this);
        ((GridData)this.m_timeOut_field.getLayoutData()).horizontalAlignment = 16384;
        this.m_optional_params_field = this.m_gui.addInputFieldSingle(this.m_actDetailsComposite, OPT_PARAMS, "Editable Params: ", this.m_action.m_optional_parameters, 3, 1, 0, 5, 60, this);
        this.m_description_field = this.m_gui.addInputFieldMultiLineNoWrap(this.m_actDetailsComposite, DESC, "Description: ", this.m_action.m_description, 3, 1, 100, 150, 0, 5, this);
        this.m_help_field = this.m_gui.addInputFieldMultiLineNoWrap(this.m_actDetailsComposite, HELP, "Help: ", this.m_action.m_help, 3, 1, 100, 150, 0, 5, this);
        new Label(this.m_actDetailsComposite, 0);
        Composite btnComp = new Composite(this.m_compositeInCtab, 0);
        btnComp.setLayout((Layout)new GridLayout(2, false));
        btnComp.setLayoutData((Object)new GridData(4, 1024, true, false));
        this.m_saveButton = this.m_gui.addButton(btnComp, BUTTON_SAVE, " &Save Action ", this.m_isNew, 80, 20, 5, this);
        this.m_undoButton = this.m_gui.addButton(btnComp, BUTTON_UNDO, " &Undo Changes ", this.m_isNew, 80, 20, 5, this);
        this.m_scroll.setContent((Control)this.m_actDetailsComposite);
        this.m_scroll.setMinSize(this.m_actDetailsComposite.computeSize(-1, -1, true));
        this.setControl((Control)this.m_compositeInCtab);
    }

    public void modifyText(ModifyEvent e) {
        if (e.getSource() instanceof Text) {
            Text field = (Text)e.getSource();
            String fieldName = (String)field.getData();
            String value = field.getText().trim();
            if (fieldName.equals(CALL)) {
                this.m_isCallValid = true;
                if (value.trim().length() == 0) {
                    field.setBackground(BMUI.color_critical);
                    this.m_isCallValid = false;
                } else if (value.startsWith("IAction ")) {
                    this.m_callType_field.setText("JAVA_ACTION");
                }
            } else if (!fieldName.equals(DESC) && !fieldName.equals(HELP)) {
                if (fieldName.equals(LABEL)) {
                    GroupTreeObjectLast potentialConflict;
                    field.setToolTipText(null);
                    this.setText(value);
                    this.m_isLabelValid = true;
                    field.setBackground(BMUI.color_white);
                    if (value.trim().length() == 0) {
                        field.setBackground(BMUI.color_critical);
                        this.m_isLabelValid = false;
                    } else if ((this.isNew() || !this.m_label_field.getText().equals(this.m_action.m_label)) && (potentialConflict = this.getActionGroupGTO(this.m_group).findElement(value, BMUI.type_act)) != null) {
                        field.setToolTipText("Conflicting Action Name!");
                        field.setBackground(BMUI.color_critical);
                        this.m_isLabelValid = false;
                    }
                } else if (!fieldName.equals(OPT_PARAMS) && fieldName == TIME_OUT) {
                    this.m_isTimeoutValid = true;
                    try {
                        Integer.parseInt(value);
                        field.setBackground(BMUI.color_white);
                    }
                    catch (NumberFormatException numberFormatException) {
                        field.setBackground(BMUI.color_critical);
                        this.m_isTimeoutValid = false;
                    }
                }
            }
            this.setDirty(true);
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.getSource() instanceof Button) {
            this.setDirty(true);
            Button b = (Button)e.getSource();
            String name = (String)b.getData();
            if (name.equalsIgnoreCase(BUTTON_SAVE)) {
                this.save(false);
            } else if (name.equalsIgnoreCase(BUTTON_UNDO)) {
                this.undoChanges(false);
            } else if (name.equalsIgnoreCase(SERVER_ACTION)) {
                if (this.isNew()) {
                    this.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_NEW_WIZARD"));
                } else if (this.m_server_action_btn.getSelection()) {
                    this.setImage(BMUI.IMAGE_ACTION_SERVER);
                } else {
                    this.setImage(BMUI.IMAGE_ACTION);
                }
            }
        }
    }

    public Action getAction() {
        return this.m_action;
    }

    public String getActionGrpName() {
        return this.m_group;
    }

    private GroupTreeObject getActionGroupGTO(String actionGroupName) {
        GroupTreeObject aTree = Repository.getInstance().m_actionRepository.getTree();
        GroupTreeObject actionGroup = aTree.findFirstGroupByName(actionGroupName);
        return actionGroup;
    }

    public void undoChanges(boolean closeTab) {
        this.m_label_field.setText(this.m_action.m_label);
        this.setText(this.m_action.m_label);
        this.m_call_field.setText(this.m_action.m_call);
        this.m_callType_field.setText(this.m_action.m_calltype);
        if (this.m_action.m_calltype.startsWith("IAction ")) {
            this.m_callType_field.setText("JAVA_ACTION");
        }
        this.m_server_action_btn.setSelection(this.m_action.m_serverAction);
        this.m_timeOut_field.setText("" + this.m_action.m_timeoutSeconds);
        this.m_optional_params_field.setText(this.m_action.m_optional_parameters);
        this.m_description_field.setText(this.m_action.m_description);
        this.m_help_field.setText(this.m_action.m_help);
        this.setDirty(false);
    }

    public void save(boolean closeTab) {
        GroupTreeObject actionGroupGTO;
        GroupTreeObjectLast gtol;
        this.m_action.m_label = this.m_label_field.getText().trim();
        if (!(!this.isNew() && this.m_label_field.getText().trim().equals(this.m_action.m_label) || (gtol = (actionGroupGTO = this.getActionGroupGTO(this.m_group)).findElement(this.m_action.m_label, BMUI.type_act)) == null || gtol instanceof GroupTreeObjectUnsubmitted)) {
            new ShowMessageBox("Save Action", "Action Name does already exist!", 1);
            return;
        }
        this.m_action.m_call = this.m_call_field.getText().trim();
        this.m_action.m_calltype = this.m_callType_field.getText().trim();
        try {
            this.m_action.m_timeoutSeconds = Integer.parseInt(this.m_timeOut_field.getText().trim());
        }
        catch (NumberFormatException numberFormatException) {}
        this.m_action.m_serverAction = this.m_server_action_btn.getSelection();
        this.m_action.m_optional_parameters = this.m_optional_params_field.getText().trim();
        this.m_action.m_optional = this.m_action.m_optional_parameters.length() > 0;
        this.m_action.m_description = this.m_description_field.getText().trim();
        this.m_action.m_help = this.m_help_field.getText().trim();
        ServerClient sc = Repository.getInstance().m_actionRepository.saveAction(this.m_action, this.m_group);
        if (sc.isSuccess()) {
            RTLogger.print(3, "UPDATEACTION OK: " + sc.getResultObject());
            if (closeTab) {
                this.dispose();
            } else {
                this.setDirty(false);
                this.setNew(false);
                ActionView.reOpenActionTab(this.m_action, this.m_group);
            }
        } else {
            RTLogger.print(3, "UPDATEACTION Error: " + sc.getResultObject());
            new ShowMessageBox("Save Action", "Error saving the Action '" + this.m_action.m_label + "'", 1);
            this.setDirty(true);
            this.setNew(this.m_isNew);
        }
    }

    public void setDirty(boolean isDirty) {
        boolean isValid;
        boolean bl = isValid = this.m_isLabelValid && this.m_isCallValid && this.m_isTimeoutValid;
        if (!isDirty && !isValid) {
            isDirty = true;
        }
        this.m_isDirty = isDirty;
        this.setData(DIRTY_STATUS, this.m_isDirty);
        this.m_gui.enableField(this.m_saveButton, isDirty && isValid);
        this.m_gui.enableField(this.m_undoButton, isDirty);
        if (!this.getText().startsWith("*") && isDirty) {
            this.setText("* " + this.getText());
        } else if (this.getText().startsWith("*") && !isDirty) {
            try {
                this.setText(this.m_action.m_label);
            }
            catch (Exception exception) {}
        }
    }

    public boolean isDirty() {
        return this.m_isDirty;
    }

    public void setNew(boolean b) {
        this.m_isNew = b;
    }

    public boolean isNew() {
        return this.m_isNew;
    }

    public void dispose() {
        try {
            this.m_compositeInCtab.dispose();
        }
        catch (Exception exception) {}
        super.dispose();
    }

    public void widgetDisposed(DisposeEvent e) {
        Object obj = e.getSource();
        if (obj instanceof ActionTab) {
            ActionTab agentTab = (ActionTab)((Object)obj);
            try {
                if (agentTab.isDirty() && !agentTab.isNew()) {
                    this.save(true);
                } else {
                    GroupTreeObject parent;
                    GroupTreeObjectLast gtol;
                    GroupTreeObject actionGroupGTO = this.getActionGroupGTO(this.m_group);
                    if (actionGroupGTO != null && (gtol = actionGroupGTO.findElement(this.m_action.m_label, BMUI.type_act)) != null && gtol instanceof GroupTreeObjectUnsubmitted && (parent = gtol.getParent()) != null) {
                        parent.removeElement(gtol);
                    }
                }
                Action action = agentTab.getAction();
                if (action != null) {
                    ActionView.m_tabList.remove(action.m_ID);
                }
                Object[] expanded = ActionsListView.viewer.getExpandedElements();
                ActionsListView.viewer.refresh();
                int index = 0;
                while (index < expanded.length) {
                    ActionsListView.viewer.setExpandedState(expanded[index], true);
                    ++index;
                }
            }
            catch (Exception exception) {}
            try {
                this.m_scroll.dispose();
            }
            catch (Throwable throwable) {}
            try {
                this.m_compositeInCtab.dispose();
            }
            catch (Throwable throwable) {}
            try {
                this.m_actDetailsComposite.dispose();
            }
            catch (Throwable throwable) {}
            try {
                this.dispose();
            }
            catch (Throwable throwable) {}
        }
    }
}

