/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.engine.UIJob;
import com.blixx.boom.gui.Activator;
import com.blixx.boom.gui.dialogs.SaveDialog;
import com.blixx.boom.gui.views.ActionTab;
import com.blixx.boom.gui.views.actions.ShowViewAction;
import com.blixx.log.RTLogger;
import com.blixx.shared.Action;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.GroupTreeObjectLast;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolder2Listener;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;

public class ActionView
extends ViewPart
implements Listener,
DisposeListener,
CTabFolder2Listener,
SelectionListener {
    public static final String ID = "com.blixx.boom.gui.views.actionview";
    private static ActionView m_instance = null;
    public static HashMap<String, CTabItem> m_tabList = new HashMap();
    public static CTabFolder m_folder = null;
    public Composite m_parent = null;
    public static GroupTreeObject m_gto = null;
    public static GroupTreeObjectLast m_gtol = null;
    public static String DIRTY_STATUS = "DIRTY_STATUS";
    public static final String CLOSE_ALL = "CLOSE_ALL";
    public static final String CLOSE_OTHERS = "CLOSE_OTHERS";
    public static final String CLOSE = "CLOSE";
    public static String YES = "YES";
    public static String NO = "NO";
    public static String CANCEL = "CANCEL";

    public ActionView() {
        m_instance = this;
    }

    public static ActionView getInstance() {
        return m_instance;
    }

    public CTabFolder getFolder() {
        return m_folder;
    }

    public HashMap<String, CTabItem> getTabList() {
        return m_tabList;
    }

    public static CTabItem getTab(String name) {
        return m_tabList.get(name);
    }

    public void createPartControl(Composite parent) {
        if (Repository.getInstance().getRights(1007) < 2) {
            parent.setLayout((Layout)new GridLayout(2, false));
            Label l = new Label(parent, 0);
            l.setText(" Insufficient rights.");
            l.setForeground(BMUI.color_critical);
            Button close = new Button(parent, 8);
            close.setText("Close");
            close.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    ActionView.this.getSite().getPage().hideView(ActionView.this.getSite().getPage().findView(ActionView.ID));
                }
            });
            UIJob uiJob = new UIJob("Close Viewcom.blixx.boom.gui.views.actionview"){

                @Override
                public IStatus runInUIThread(IProgressMonitor monitor) {
                    ActionView.this.getSite().getPage().hideView(ActionView.this.getSite().getPage().findView(ActionView.ID));
                    return Status.OK_STATUS;
                }
            };
            Repository.getUIJobManager().schedule(uiJob);
            return;
        }
        RTLogger.print(5, "ActionView here.");
        ActionView.m_instance.m_parent = parent;
        ActionView.createFolder();
        this.setTitleImage(BMUI.IMAGE_ACTION);
    }

    public static void createFolder() {
        m_folder = new CTabFolder(ActionView.m_instance.m_parent, 2816);
        m_folder.setSimple(false);
        m_folder.setMinimizeVisible(false);
        m_folder.setMaximizeVisible(false);
        m_folder.setBorderVisible(false);
        m_folder.setBackground(BMUI.color_unknown);
        m_folder.addCTabFolder2Listener((CTabFolder2Listener)m_instance);
        m_folder.addSelectionListener((SelectionListener)m_instance);
        m_folder.addListener(35, new Listener(){

            public void handleEvent(Event event) {
                Point point = m_folder.getDisplay().map(null, (Control)m_folder, new Point(event.x, event.y));
                CTabItem cTabItem = m_folder.getItem(point);
                if (cTabItem != null && cTabItem instanceof ActionTab) {
                    ActionTab tab = (ActionTab)cTabItem;
                    tab.createMainArea();
                    tab.getControl().setVisible(true);
                    m_folder.setSelection((CTabItem)tab);
                }
            }
        });
        ActionView.createContentMenu();
    }

    public static void createContentMenu() {
        Menu menu = new Menu((Control)m_folder);
        menu.addMenuListener(new MenuListener(){

            public void menuHidden(MenuEvent e) {
            }

            public void menuShown(MenuEvent e) {
                block6: {
                    int count;
                    MenuItem[] mi;
                    block7: {
                        block5: {
                            Menu menu = (Menu)e.getSource();
                            mi = menu.getItems();
                            count = m_folder.getItemCount();
                            if (count != 0) break block5;
                            int index = 0;
                            while (index < mi.length) {
                                mi[index].setEnabled(false);
                                ++index;
                            }
                            break block6;
                        }
                        if (count != 1) break block7;
                        int index = 0;
                        while (index < mi.length) {
                            if (mi[index].getData().equals(ActionView.CLOSE)) {
                                mi[index].setEnabled(true);
                            } else {
                                mi[index].setEnabled(false);
                            }
                            ++index;
                        }
                        break block6;
                    }
                    if (count <= 1) break block6;
                    int index = 0;
                    while (index < mi.length) {
                        mi[index].setEnabled(true);
                        ++index;
                    }
                }
            }
        });
        MenuItem mi_close = new MenuItem(menu, -1);
        mi_close.setText("Close");
        mi_close.setData((Object)CLOSE);
        mi_close.addListener(13, (Listener)m_instance);
        MenuItem mi_closeOthers = new MenuItem(menu, -1);
        mi_closeOthers.setText("Close Others");
        mi_closeOthers.setData((Object)CLOSE_OTHERS);
        mi_closeOthers.addListener(13, (Listener)m_instance);
        MenuItem mi_closeAll = new MenuItem(menu, -1);
        mi_closeAll.setText("Close All");
        mi_closeAll.setData((Object)CLOSE_ALL);
        mi_closeAll.addListener(13, (Listener)m_instance);
        m_folder.setMenu(menu);
    }

    public static void displayAction(Action action, String group, GroupTreeObject gto, GroupTreeObjectLast gtol, boolean isNewAction) {
        m_gto = gto;
        m_gtol = gtol;
        Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().activate((IWorkbenchPart)ActionView.getInstance());
        CTabItem cTabItem = null;
        if (m_tabList.containsKey(action.m_ID)) {
            cTabItem = m_tabList.get(action.m_ID);
            if (cTabItem.getControl() == null || cTabItem.getControl().isDisposed()) {
                ((ActionTab)cTabItem).internalRestore();
            }
        } else {
            if (m_folder == null || m_folder.isDisposed()) {
                int itemID = Repository.getInstance().getUserManager().getUItemIDForActionGroup(group);
                ShowViewAction activateView = new ShowViewAction(itemID, 1, ID, "Action View", BMUI.IMAGE_DESCR_ACTION);
                activateView.run();
            }
            cTabItem = new ActionTab(m_folder, 64, m_folder.getItemCount(), action, group, m_gtol, isNewAction);
            cTabItem.addDisposeListener((DisposeListener)m_instance);
            m_tabList.put(action.m_ID, cTabItem);
        }
        m_folder.setSelection(cTabItem);
        ActionView.hideAllOther(cTabItem);
    }

    private static void hideAllOther(CTabItem cTabItem) {
        int i = 0;
        while (i < m_folder.getItemCount()) {
            CTabItem item = m_folder.getItem(i);
            if (!item.equals(cTabItem) && item.getControl() != null) {
                item.getControl().dispose();
            }
            ++i;
        }
    }

    public static void closeActionTab(Object obj) {
        Action action = null;
        if (obj instanceof Action) {
            action = (Action)obj;
        }
        if (action != null && m_tabList.get(action.m_ID) != null) {
            CTabItem cTabItem = m_tabList.get(action.m_ID);
            cTabItem.dispose();
            m_tabList.remove(action.m_ID);
        }
    }

    public static void reOpenActionTab(Action action, String group) {
        if (m_tabList.containsKey(action.m_ID)) {
            ActionView.closeActionTab(action);
            ActionView.displayAction(action, group, m_gto, m_gtol, false);
        }
    }

    public static CTabItem getCTabItem(String actionID) {
        CTabItem cti = null;
        if (m_folder != null && !m_folder.isDisposed()) {
            CTabItem[] list = m_folder.getItems();
            int i = 0;
            while (i < list.length) {
                cti = list[i];
                if (cti != null && !cti.isDisposed()) {
                    Action action = (Action)cti.getData(ActionTab.ACTION);
                    if (action.m_ID.equalsIgnoreCase(actionID)) {
                        return cti;
                    }
                }
                ++i;
            }
        }
        return null;
    }

    public void handleEvent(Event event) {
        boolean dirtyStatus = false;
        String name = (String)event.widget.getData();
        if (name.equals(CLOSE)) {
            CTabItem selectedTab = m_folder.getSelection();
            if (((Boolean)selectedTab.getData(DIRTY_STATUS)).booleanValue()) {
                this.openSaveDialogMulitple(CLOSE);
            } else {
                this.closeOpenTabs(CLOSE);
            }
        } else if (name.equals(CLOSE_OTHERS)) {
            CTabItem selectedTab = m_folder.getSelection();
            CTabItem[] cTabs = m_folder.getItems();
            int index = 0;
            while (index < cTabs.length) {
                CTabItem tab = cTabs[index];
                if (!selectedTab.equals(tab) && ((Boolean)tab.getData(DIRTY_STATUS)).booleanValue()) {
                    dirtyStatus = true;
                    break;
                }
                ++index;
            }
            if (dirtyStatus) {
                this.openSaveDialogMulitple(CLOSE_OTHERS);
            } else {
                this.closeOpenTabs(CLOSE_OTHERS);
            }
        } else if (name.equals(CLOSE_ALL)) {
            CTabItem[] cTabs = m_folder.getItems();
            int i = 0;
            while (i < cTabs.length) {
                if (((Boolean)cTabs[i].getData(DIRTY_STATUS)).booleanValue()) {
                    dirtyStatus = true;
                    break;
                }
                ++i;
            }
            if (dirtyStatus) {
                this.openSaveDialogMulitple(CLOSE_ALL);
            } else {
                this.closeOpenTabs(CLOSE_ALL);
            }
        }
    }

    public int openSaveDialogMulitple(String action) {
        int returnCode;
        block8: {
            SaveDialog dialog;
            block7: {
                returnCode = -1;
                dialog = new SaveDialog(m_instance.getFolder().getShell());
                dialog.init(this.getFolder(), action, null, SaveDialog.ACTION);
                dialog.setBlockOnOpen(true);
                dialog.open();
                returnCode = dialog.getReturnCode();
                if (returnCode != 0) break block7;
                ArrayList<CTabItem> tabs_doSave = dialog.m_tabs_doSave;
                int index = 0;
                while (index < tabs_doSave.size()) {
                    CTabItem cTab = (CTabItem)tabs_doSave.get(index);
                    cTab.dispose();
                    ++index;
                }
                CTabItem selected = m_folder.getSelection();
                ArrayList<CTabItem> tabs_doNotSave = dialog.m_tabs_doNotSave;
                int index2 = 0;
                while (index2 < tabs_doNotSave.size()) {
                    CTabItem cTab = (CTabItem)tabs_doNotSave.get(index2);
                    if (!action.equals(CLOSE_ALL) || !cTab.equals(selected)) {
                        ((ActionTab)cTab).undoChanges(true);
                        ((ActionTab)cTab).setDirty(false);
                        cTab.dispose();
                    }
                    ++index2;
                }
                if (action.equals(CLOSE_ALL) && selected != null) {
                    ((ActionTab)selected).undoChanges(true);
                    ((ActionTab)selected).setDirty(false);
                    selected.dispose();
                }
                ArrayList<CTabItem> tabs_unchanged = dialog.m_unchangedTabs;
                int index3 = 0;
                while (index3 < tabs_unchanged.size()) {
                    CTabItem cTab = (CTabItem)tabs_unchanged.get(index3);
                    cTab.dispose();
                    ++index3;
                }
                break block8;
            }
            if (returnCode != SaveDialog.JUST_CLOSE_ID) break block8;
            ArrayList<CTabItem> tabs_doNotSave = dialog.m_tabs_doNotSave;
            int index = 0;
            while (index < tabs_doNotSave.size()) {
                CTabItem cTab = (CTabItem)tabs_doNotSave.get(index);
                ((ActionTab)cTab).undoChanges(true);
                ((ActionTab)cTab).setDirty(false);
                cTab.dispose();
                ++index;
            }
            ArrayList<CTabItem> tabs_unchanged = dialog.m_unchangedTabs;
            int index4 = 0;
            while (index4 < tabs_unchanged.size()) {
                CTabItem cTab = (CTabItem)tabs_unchanged.get(index4);
                cTab.dispose();
                ++index4;
            }
        }
        return returnCode;
    }

    public void closeOpenTabs(String type) {
        if (m_folder != null && !m_folder.isDisposed()) {
            CTabItem[] openTabs = m_folder.getItems();
            if (type.equals(CLOSE)) {
                CTabItem cTab = m_folder.getSelection();
                if (cTab != null && !cTab.isDisposed()) {
                    cTab.dispose();
                }
            } else if (type.equals(CLOSE_ALL)) {
                int index = 0;
                while (index < openTabs.length) {
                    CTabItem cTab = openTabs[index];
                    if (cTab != null && !cTab.isDisposed()) {
                        cTab.dispose();
                    }
                    ++index;
                }
            } else if (type.equals(CLOSE_OTHERS)) {
                CTabItem selectedCTab = m_folder.getSelection();
                int index = 0;
                while (index < openTabs.length) {
                    CTabItem cTab;
                    if (!openTabs[index].equals(selectedCTab) && (cTab = openTabs[index]) != null && !cTab.isDisposed()) {
                        cTab.dispose();
                    }
                    ++index;
                }
            }
        }
        if (m_tabList.size() == 0) {
            this.closeView();
        }
    }

    public void minimize(CTabFolderEvent event) {
        m_folder.setMinimized(true);
        ActionView.m_instance.m_parent.layout(true);
    }

    public void maximize(CTabFolderEvent event) {
        m_folder.setMaximized(true);
        m_folder.setLayoutData((Object)new GridData(4, 4, true, true));
        ActionView.m_instance.m_parent.layout(true);
    }

    public void restore(CTabFolderEvent event) {
        m_folder.setMinimized(false);
        m_folder.setMaximized(false);
        m_folder.setLayoutData((Object)new GridData(4, 4, true, false));
        ActionView.m_instance.m_parent.layout(true);
    }

    public void close(CTabFolderEvent event) {
        CTabItem cTab = (CTabItem)event.item;
        if (cTab == null || cTab.isDisposed()) {
            return;
        }
        if (cTab instanceof ActionTab) {
            int returnCode;
            ActionTab tab = (ActionTab)cTab;
            if (!this.isTabActiv(tab) || tab.getControl().isDisposed()) {
                tab.createMainArea();
                tab.getControl().setVisible(true);
                m_folder.setSelection((CTabItem)tab);
            }
            if (((Boolean)tab.getData(DIRTY_STATUS)).booleanValue() && (returnCode = this.openSaveDialogMulitple(CLOSE)) == 1) {
                event.doit = false;
            }
        }
    }

    public boolean isTabActiv(CTabItem tab) {
        boolean b = false;
        if (m_folder != null && !m_folder.isDisposed()) {
            CTabItem activeTab = m_folder.getSelection();
            if (tab.getText().equals(activeTab.getText())) {
                b = true;
            }
        }
        return b;
    }

    public void closeView() {
        try {
            IWorkbenchPage activePage = Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
            activePage.hideView((IViewPart)ActionView.getInstance());
        }
        catch (Throwable throwable) {}
    }

    public void showList(CTabFolderEvent event) {
    }

    public void dispose() {
        super.dispose();
    }

    public void setFocus() {
    }

    public void widgetDisposed(DisposeEvent event) {
        if (event.getSource() instanceof ActionTab) {
            ActionTab aTab = (ActionTab)((Object)event.getSource());
            m_tabList.remove(aTab.getAction().m_ID);
            if (m_tabList.size() == 0) {
                this.closeView();
            }
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        Object obj = e.getSource();
        if (obj instanceof CTabFolder) {
            CTabFolder folder = (CTabFolder)obj;
            CTabItem cTabItem = folder.getSelection();
            int i = 0;
            while (i < folder.getItemCount()) {
                CTabItem item = folder.getItem(i);
                if (!item.equals(cTabItem)) {
                    if (item.getControl() != null) {
                        item.getControl().dispose();
                    }
                } else if (item instanceof ActionTab) {
                    ActionTab acTab = (ActionTab)item;
                    boolean wasDirty = acTab.isDirty();
                    acTab.createMainArea();
                    acTab.getControl().setVisible(true);
                    acTab.setDirty(wasDirty);
                }
                ++i;
            }
        }
    }
}

