/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.engine.UIJob;
import com.blixx.boom.gui.dialogs.ShowMessageBox;
import com.blixx.boom.gui.policies.ViewContentProvider;
import com.blixx.boom.gui.policies.ViewLabelProvider;
import com.blixx.boom.gui.utils.FilterComposite;
import com.blixx.boom.gui.utils.STreeViewer;
import com.blixx.boom.gui.utils.TreeElementComparer;
import com.blixx.boom.gui.views.actions.AddNewActionAction;
import com.blixx.boom.gui.views.actions.AddRenameActionGroupAction;
import com.blixx.boom.gui.views.actions.AgentRemoteAction;
import com.blixx.boom.gui.views.actions.CutGroupTreeObjectAction;
import com.blixx.boom.gui.views.actions.DeleteActionAction;
import com.blixx.boom.gui.views.actions.DuplicateActionAction;
import com.blixx.boom.gui.views.actions.EditActionAction;
import com.blixx.boom.gui.views.actions.ExpandCollapseAction;
import com.blixx.boom.gui.views.actions.ExportActionGroup;
import com.blixx.boom.gui.views.actions.FastAndRemoteActions;
import com.blixx.boom.gui.views.actions.ImportActionGroup;
import com.blixx.boom.gui.views.actions.ManageDialogAction;
import com.blixx.boom.gui.views.actions.RefreshTreeAction;
import com.blixx.boom.gui.views.dnd.DNDCutCopyActionTreeAction;
import com.blixx.boom.gui.views.dnd.DNDPasteToActionTreeAction;
import com.blixx.boom.gui.views.dnd.DNDShare;
import com.blixx.boom.gui.views.dnd.DNDSourceActionsList;
import com.blixx.boom.gui.views.dnd.DNDTargetActionsList;
import com.blixx.boom.gui.views.dnd.DNDTreeIconManager;
import com.blixx.log.RTLogger;
import com.blixx.shared.Action;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.GroupTreeObjectLast;
import com.blixx.shared.utils.GroupTreeObjectUnsubmitted;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.part.ViewPart;

public class ActionsListView
extends ViewPart
implements IDoubleClickListener {
    public static final String ID = "com.blixx.boom.gui.views.actlistview";
    public static final int VIEW_ID = 1007;
    public static STreeViewer viewer;
    private Clipboard m_clipboard = null;
    private DNDTreeIconManager m_treeIconManager = null;
    public static String TREE_VIEWER_TYPE;
    public static String ACTION_LIST;
    private static ActionsListView m_instance;

    static {
        TREE_VIEWER_TYPE = "TREE_VIEWER_TYPE";
        ACTION_LIST = "ACTION_LIST";
        m_instance = null;
    }

    public static ActionsListView getInstance() {
        return m_instance;
    }

    public ActionsListView() {
        m_instance = this;
    }

    public void createPartControl(Composite parent) {
        if (Repository.getInstance().getRights(1007) < 2) {
            parent.setLayout((Layout)new GridLayout(2, false));
            Label l = new Label(parent, 0);
            l.setText(" Insufficient rights.");
            l.setForeground(BMUI.color_critical);
            Button close = new Button(parent, 8);
            close.setText("Close");
            close.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    ActionsListView.this.getSite().getPage().hideView(ActionsListView.this.getSite().getPage().findView(ActionsListView.ID));
                }
            });
            UIJob uiJob = new UIJob("Close Viewcom.blixx.boom.gui.views.actlistview"){

                @Override
                public IStatus runInUIThread(IProgressMonitor monitor) {
                    ActionsListView.this.getSite().getPage().hideView(ActionsListView.this.getSite().getPage().findView(ActionsListView.ID));
                    return Status.OK_STATUS;
                }
            };
            Repository.getUIJobManager().schedule(uiJob);
            return;
        }
        this.m_clipboard = new Clipboard(Display.getCurrent());
        this.m_treeIconManager = new DNDTreeIconManager();
        parent.setLayout((Layout)new GridLayout(1, false));
        new FilterComposite(parent, (Object)this);
        viewer = new STreeViewer(parent, 2818);
        viewer.setData(TREE_VIEWER_TYPE, ACTION_LIST);
        viewer.getTree().setLayoutData((Object)new GridData(4, 4, true, true));
        viewer.setComparer(new TreeElementComparer());
        viewer.setContentProvider((IContentProvider)new ViewContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider(null, null));
        viewer.setInput(Repository.getInstance().getActionTree((Viewer)viewer));
        viewer.expandToLevel(1);
        Transfer[] types = new Transfer[]{LocalSelectionTransfer.getTransfer()};
        viewer.addDragSupport(2, types, new DNDSourceActionsList(viewer));
        viewer.addDropSupport(2, types, new DNDTargetActionsList(viewer));
        viewer.getTree().addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                if (e.stateMask == 262144) {
                    if (e.keyCode == 120) {
                        DNDCutCopyActionTreeAction cutAction = new DNDCutCopyActionTreeAction(viewer, DNDShare.DND_CUT_ACTION, ActionsListView.this.m_clipboard);
                        cutAction.run();
                    } else if (e.keyCode == 99) {
                        DNDCutCopyActionTreeAction copyAction = new DNDCutCopyActionTreeAction(viewer, DNDShare.DND_COPY_ACTION, ActionsListView.this.m_clipboard);
                        copyAction.run();
                    } else if (e.keyCode == 118) {
                        DNDPasteToActionTreeAction pasteAction = new DNDPasteToActionTreeAction(viewer, ActionsListView.this.m_clipboard);
                        pasteAction.run();
                    }
                }
                if (e.keyCode == 27) {
                    String DNDType = (String)ActionsListView.this.m_clipboard.getContents((Transfer)TextTransfer.getInstance());
                    ActionsListView.this.m_treeIconManager.restoreActionTreeIcons((Object)viewer, DNDType);
                    ActionsListView.this.m_clipboard.clearContents();
                    DNDShare.getInstance().clearDNDAsnTreeObjects();
                }
            }
        });
        IWorkbenchPartSite part = this.getSite();
        part.setSelectionProvider((ISelectionProvider)viewer);
        this.createContentMenu();
        viewer.addDoubleClickListener(this);
        this.setTitleImage(BMUI.IMAGE_ACTION);
    }

    public TreeViewer getTreeViewer() {
        return viewer;
    }

    public void setFocus() {
    }

    public void createContentMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        Menu menu = menuMgr.createContextMenu(viewer.getControl());
        viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)viewer);
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                GroupTreeObject m_actionGrpRoot = Repository.getInstance().getActionTree((Viewer)viewer);
                try {
                    StructuredSelection ssel = (StructuredSelection)viewer.getSelection();
                    manager.add((IAction)new RefreshTreeAction(null, "GETACTIONS", null, null));
                    manager.add((IContributionItem)new Separator());
                    manager.add((IAction)new ImportActionGroup());
                    if (ssel.isEmpty()) {
                        manager.add((IAction)new AddRenameActionGroupAction(viewer, m_actionGrpRoot, AddRenameActionGroupAction.ADD));
                    } else if (!ssel.isEmpty()) {
                        Object o = ssel.getFirstElement();
                        if (o instanceof GroupTreeObject && !(o instanceof GroupTreeObjectLast)) {
                            GroupTreeObject gto = (GroupTreeObject)o;
                            manager.add((IAction)new ExportActionGroup(viewer));
                            FastAndRemoteActions fastAndRemoteActions = new FastAndRemoteActions(manager, viewer, null, null);
                            fastAndRemoteActions.addFastActionSubMenu();
                            manager.add((IContributionItem)new Separator());
                            manager.add((IAction)new AddRenameActionGroupAction(viewer, m_actionGrpRoot, AddRenameActionGroupAction.ADD));
                            manager.add((IAction)new AddRenameActionGroupAction(viewer, gto, AddRenameActionGroupAction.RENAME));
                            manager.add((IAction)new CutGroupTreeObjectAction(viewer, gto, BMUI.type_tree_action));
                            manager.add((IContributionItem)new Separator());
                            manager.add((IAction)new AddNewActionAction(viewer, gto));
                            manager.add((IAction)new DNDPasteToActionTreeAction(viewer, ActionsListView.this.m_clipboard));
                        } else if (o instanceof GroupTreeObjectLast) {
                            GroupTreeObjectLast gtoLast = (GroupTreeObjectLast)o;
                            Action action = (Action)gtoLast.getTreeObject().getObject();
                            if (gtoLast.getLinkedPath() == null) {
                                FastAndRemoteActions fastAndRemoteActions = new FastAndRemoteActions(manager, viewer, action, gtoLast);
                                try {
                                    fastAndRemoteActions.addAgentRemoteActionOnSelected();
                                }
                                catch (RuntimeException e) {
                                    RTLogger.print(5, "", e);
                                }
                                fastAndRemoteActions.addFastActionSubMenu();
                                manager.add((IContributionItem)new Separator());
                                manager.add((IAction)new EditActionAction((StructuredViewer)viewer));
                                manager.add((IAction)new AddNewActionAction(viewer, gtoLast.getParent()));
                                manager.add((IAction)new DuplicateActionAction(viewer));
                                manager.add((IAction)new DeleteActionAction(viewer));
                                manager.add((IContributionItem)new Separator());
                                manager.add((IAction)new DNDCutCopyActionTreeAction(viewer, DNDShare.DND_CUT_ACTION, ActionsListView.this.m_clipboard));
                                manager.add((IAction)new DNDCutCopyActionTreeAction(viewer, DNDShare.DND_COPY_ACTION, ActionsListView.this.m_clipboard));
                                manager.add((IAction)new DNDPasteToActionTreeAction(viewer, ActionsListView.this.m_clipboard));
                            }
                        }
                    }
                    manager.add((IContributionItem)new Separator());
                    manager.add((IAction)new ExpandCollapseAction(viewer, "ExpandAll"));
                    manager.add((IAction)new ExpandCollapseAction(viewer, "CollapseAll"));
                }
                catch (RuntimeException e) {
                    RTLogger.print(5, "", e);
                }
            }
        });
    }

    public void doubleClick(DoubleClickEvent event) {
        if (Repository.getInstance().getRights(1007) < 2) {
            return;
        }
        StructuredSelection ssel = (StructuredSelection)viewer.getSelection();
        if (!ssel.isEmpty()) {
            Object o = ssel.getFirstElement();
            if (o instanceof GroupTreeObjectUnsubmitted) {
                new ShowMessageBox("Run Unsubmitted Action", "  Cannot run an unsubmitted Action!  ", 1);
                return;
            }
            if (o instanceof GroupTreeObject && !(o instanceof GroupTreeObjectLast)) {
                GroupTreeObject gto;
                viewer.setExpandedState(gto, !viewer.getExpandedState(gto = (GroupTreeObject)o));
            } else if (o instanceof GroupTreeObjectLast) {
                GroupTreeObjectLast gtoLast = (GroupTreeObjectLast)o;
                String actionGroupName = gtoLast.getParent().getName();
                if (Repository.getInstance().getRights(actionGroupName) < 2) {
                    new ShowMessageBox("Insufficient rights", " You are not allowed to run actions inside " + actionGroupName, 1);
                    return;
                }
                try {
                    Action action = (Action)gtoLast.getTreeObject().getObject();
                    Shell s = ManageDialogAction.isActionDialogOpen(action.m_ID);
                    if (s != null) {
                        s.setActive();
                    } else {
                        String title_a = action.m_label;
                        if (action.m_serverAction) {
                            title_a = " Server action: " + title_a;
                        }
                        AgentRemoteAction dblclk = new AgentRemoteAction(title_a, action, gtoLast.getParent().getName());
                        dblclk.setEnabled(false);
                        dblclk.run();
                    }
                }
                catch (RuntimeException e) {
                    RTLogger.print(5, "", e);
                }
            }
        }
    }
}

