/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views;

import com.blixx.boom.engine.AgentCard;
import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.EventStatusRefreshJob;
import com.blixx.boom.engine.JobManager;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.engine.UIJob;
import com.blixx.boom.gui.dialogs.IRefreshable;
import com.blixx.boom.gui.utils.AgentOverview_FilterOnComposite;
import com.blixx.boom.gui.utils.AgentTableFilter;
import com.blixx.boom.gui.utils.AgentTableFilterOnExternal;
import com.blixx.boom.gui.utils.AgentTableFilterOnStatus;
import com.blixx.boom.gui.utils.GUIDisplayElements;
import com.blixx.boom.gui.views.AgentCardView;
import com.blixx.boom.gui.views.AgentOverviewTableProvider;
import com.blixx.boom.gui.views.FancyToolTipSupport;
import com.blixx.boom.gui.views.actions.AddNewAgent;
import com.blixx.boom.gui.views.actions.AddVirtAgentAction;
import com.blixx.boom.gui.views.actions.ApproveAgentAction;
import com.blixx.boom.gui.views.actions.ClipboardAgents;
import com.blixx.boom.gui.views.actions.DeleteAgentAction;
import com.blixx.boom.gui.views.actions.EnableDisableHostAction;
import com.blixx.boom.gui.views.actions.ExportAgentOverviewAction;
import com.blixx.boom.gui.views.actions.FastAndRemoteActions;
import com.blixx.boom.gui.views.actions.OpenMessageBrowserAction;
import com.blixx.boom.gui.views.actions.RedeployAgentAction;
import com.blixx.boom.gui.views.actions.RestartAgentAction;
import com.blixx.boom.gui.views.actions.SelectAgentInTreeAction;
import com.blixx.boom.gui.views.actions.SetFirewallAction;
import com.blixx.boom.gui.views.actions.ShowAssignedPoliciesAction;
import com.blixx.boom.gui.views.actions.ShowRelatedHostInfosAction;
import com.blixx.boom.gui.views.actions.StartAdHocMaintenanceAction;
import com.blixx.boom.gui.views.actions.SyncAgentsAction;
import com.blixx.boom.gui.views.actions.TriggerInventoryAction;
import com.blixx.boom.gui.views.actions.UndeployFromAll;
import com.blixx.ctrl.sc.in.ScGetAgentCards;
import com.blixx.ctrl.sc.in.ScGetAgentVersions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchPartSite;

public class AgentOverviewTab
extends CTabItem
implements SelectionListener,
IDoubleClickListener,
IRefreshable {
    private static AgentOverviewTab m_tab = null;
    private CTabFolder m_folder = null;
    private GUIDisplayElements m_gui = null;
    private Composite m_compInView = null;
    private Composite m_compTable = null;
    private Composite m_compCounter = null;
    private Button m_refresh_btn = null;
    private CCombo m_filter_combo = null;
    private Text m_counter_label = null;
    private Table m_table = null;
    private TableViewer m_tableViewer = null;
    public AgentOverviewTableProvider m_agentOverviewTableProvider = null;
    public String m_displayType = null;
    protected boolean m_displayLongFooter = true;
    public static String AGENT_OVERVIEW_TAB = "AGENT_OVERVIEW_TAB";
    public static String DIRTY_STATUS = "dirty_Status";
    public static String VIEWER_TYPE = "VIEWER_TYPE";
    public static String AGENT_OVERVIEW = "AGENT_OVERVIEW";
    public static String REFRESH_BTN = "REFRESH_BTN";
    public static String SHOW_ALL = "All";
    public static String SHOW_ONLINE = "Online";
    public static String SHOW_OFFLINE = "Offline";
    public static String SHOW_DISABLED = "Disabled";
    public static String SHOW_NOT_APPROVED = "Not Approved";
    public static String SHOW_FIREWALLED = "Firewalled";
    public static String SHOW_NOT_FIREWALLED = "Not Firewalled";
    public static String FILTER_COMBO = "FILTER_COMBO";
    public static String DISPLAY_NORMAL_NODES = "DISPLAY_NORMAL_NODES";
    public static String DISPLAY_EXTERNAL_NODES = "DISPLAY_EXTERNAL_NODES";
    public static String SHOW_MAINTENANCED = "Maintenanced";
    public static String[] m_filterList = new String[8];
    public Map<String, ViewerFilter> m_tableFilters = new HashMap<String, ViewerFilter>();
    public static String FILTER_BY_NAME;
    public static String FILTER_BY_STATUS;
    public static String ENABLE;
    public static String DISABLE;
    public static String SET_FIREWALLED_OFF;
    public static String SET_FIREWALLED_ON;
    public static HashMap<String, Integer> m_colIndices;
    public static HashMap<Integer, String> m_colNames;
    public static HashMap<String, Integer> m_columnWidth;
    public Listener sortListener = new Listener(){

        public void handleEvent(Event e) {
            if (e.type == 13) {
                TableColumn sortColumn = AgentOverviewTab.this.m_tableViewer.getTable().getSortColumn();
                TableColumn currentColumn = (TableColumn)e.widget;
                int dir = AgentOverviewTab.this.m_tableViewer.getTable().getSortDirection();
                if (sortColumn == currentColumn) {
                    dir = dir == 128 ? 1024 : 128;
                } else {
                    AgentOverviewTab.this.m_tableViewer.getTable().setSortColumn(currentColumn);
                    dir = 128;
                }
                String sortIdentifier = currentColumn.getText();
                AgentOverviewTab.this.m_agentOverviewTableProvider.setSortingProps(sortIdentifier, dir);
                AgentOverviewTab.this.m_tableViewer.getTable().setSortDirection(dir);
                ISelection sel = AgentOverviewTab.this.m_tableViewer.getSelection();
                if (AgentOverviewTab.this.m_tableViewer.getSorter() != AgentOverviewTab.this.m_agentOverviewTableProvider) {
                    AgentOverviewTab.this.m_tableViewer.setSorter((ViewerSorter)AgentOverviewTab.this.m_agentOverviewTableProvider);
                } else {
                    AgentOverviewTab.this.m_tableViewer.refresh(true, false);
                }
                AgentOverviewTab.this.m_tableViewer.setSelection(sel, false);
            }
        }
    };

    static {
        AgentOverviewTab.m_filterList[0] = SHOW_ALL;
        AgentOverviewTab.m_filterList[1] = SHOW_ONLINE;
        AgentOverviewTab.m_filterList[2] = SHOW_OFFLINE;
        AgentOverviewTab.m_filterList[3] = SHOW_DISABLED;
        AgentOverviewTab.m_filterList[4] = SHOW_MAINTENANCED;
        AgentOverviewTab.m_filterList[5] = SHOW_NOT_APPROVED;
        AgentOverviewTab.m_filterList[6] = SHOW_FIREWALLED;
        AgentOverviewTab.m_filterList[7] = SHOW_NOT_FIREWALLED;
        FILTER_BY_NAME = " FILTER_BY_NAME";
        FILTER_BY_STATUS = "FILTER_BY_STATUS";
        ENABLE = "Enable Agent";
        DISABLE = "Disable Agent";
        SET_FIREWALLED_OFF = "Set firewalled-OFF";
        SET_FIREWALLED_ON = "Set firewalled-ON";
        m_colIndices = null;
        m_colNames = null;
        m_columnWidth = new HashMap();
        m_columnWidth.put("Status", 28);
        m_columnWidth.put("Label", 230);
        m_columnWidth.put("OS", 110);
        m_columnWidth.put("Disabled", 23);
        m_columnWidth.put("Maintenanced", 28);
        m_columnWidth.put("Max Severity", 25);
        m_columnWidth.put("Version", 60);
        m_columnWidth.put("IP", 100);
        m_columnWidth.put("Port", 45);
        m_columnWidth.put("Transport", 45);
        m_columnWidth.put("Host", 140);
        m_columnWidth.put("Last Indication (Days)", 50);
        m_columnWidth.put("BOOM Server", 100);
        m_columnWidth.put("Agent ID", 200);
    }

    public AgentOverviewTab(CTabFolder parent) {
        super(parent, 0, 0);
        m_tab = this;
        this.m_folder = parent;
        this.setText("Agent Overview");
        this.setImage(BMUI.IMAGE_PC_OVERVIEW);
        this.setData(AGENT_OVERVIEW_TAB);
        this.setData(DIRTY_STATUS, false);
        this.m_displayType = SHOW_ALL;
        this.createMainArea();
    }

    public static AgentOverviewTab getInstance() {
        return m_tab;
    }

    public void createMainArea() {
        this.m_gui = new GUIDisplayElements();
        this.m_compInView = new Composite((Composite)this.m_folder, 0);
        GridLayout gl = new GridLayout(1, false);
        gl.horizontalSpacing = 0;
        this.m_compInView.setLayout((Layout)gl);
        this.m_compInView.setLayoutData((Object)new GridData(4, 4, true, true));
        this.m_compInView.addControlListener(new ControlListener(){

            public void controlResized(ControlEvent e) {
                AgentOverviewTab.this.m_compTable.layout(true);
            }

            public void controlMoved(ControlEvent e) {
            }
        });
        this.createFilterSection(this.m_compInView);
        this.createTable(this.m_compInView);
        this.createCounterSection(this.m_compInView);
        this.setControl((Control)this.m_compInView);
        Repository.getEventProvider().registerRefreshable(this, false);
    }

    public void createFilterSection(Composite parent) {
        Composite filter_comp = new Composite(parent, 0);
        GridLayout gl = new GridLayout(4, false);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        filter_comp.setLayout((Layout)gl);
        filter_comp.setLayoutData((Object)new GridData(4, 4, true, false));
        Group filterOnStatus_grp = new Group(filter_comp, 0);
        filterOnStatus_grp.setText(" Filter on Status ");
        filterOnStatus_grp.setLayout((Layout)new GridLayout(2, false));
        filterOnStatus_grp.setLayoutData((Object)new GridData(4, 4, false, false));
        Label searchIcon = new Label((Composite)filterOnStatus_grp, 0);
        searchIcon.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        searchIcon.setImage(BMUI.IMAGE_FILTERED_14x14);
        this.m_filter_combo = this.m_gui.addDropDown((Composite)filterOnStatus_grp, FILTER_COMBO, null, m_filterList, null, null, 1, 1, 0, 0, this);
        this.m_filter_combo.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        this.m_filter_combo.setVisibleItemCount(10);
        Group displayNodes_grp = new Group(filter_comp, 0);
        displayNodes_grp.setText(" Display ");
        displayNodes_grp.setLayout((Layout)new GridLayout(1, false));
        displayNodes_grp.setLayoutData((Object)new GridData(4, 4, false, false));
        this.m_gui.addCheckbox((Composite)displayNodes_grp, DISPLAY_NORMAL_NODES, "Agents", true, 1, 1, 0, this);
        this.m_gui.addCheckbox((Composite)displayNodes_grp, DISPLAY_EXTERNAL_NODES, "External", true, 1, 1, 0, this);
        Group filterOn_grp = new Group(filter_comp, 0);
        filterOn_grp.setText(" Filter on ");
        gl = new GridLayout(1, false);
        gl.marginWidth = 0;
        filterOn_grp.setLayout((Layout)gl);
        GridData gd = new GridData(4, 4, true, false);
        gd.minimumWidth = 120;
        filterOn_grp.setLayoutData((Object)gd);
        AgentOverview_FilterOnComposite filterComp = new AgentOverview_FilterOnComposite((Composite)filterOn_grp, this);
        filterComp.setCompositeLayoutData(new GridData(4, 0x1000000, true, true));
        this.m_refresh_btn = this.m_gui.addButton(filter_comp, REFRESH_BTN, "Refresh ", true, 60, 20, 0, this);
        this.m_refresh_btn.setImage(BMUI.IMAGE_REFRESH_14x14);
        ((GridData)this.m_refresh_btn.getLayoutData()).verticalAlignment = 1024;
    }

    public void createTable(Composite parent) {
        this.m_compTable = new Composite(parent, 0);
        GridLayout gl = new GridLayout(1, false);
        gl.verticalSpacing = 0;
        gl.horizontalSpacing = 0;
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        this.m_compTable.setLayout((Layout)gl);
        this.m_compTable.setLayoutData((Object)new GridData(4, 4, true, true));
        this.m_table = new Table(this.m_compTable, 268503810);
        this.m_table.setHeaderVisible(true);
        this.m_table.setLinesVisible(true);
        this.m_table.setLayout((Layout)new GridLayout(1, false));
        GridData gd = new GridData(4, 4, true, true);
        gd.verticalIndent = 5;
        gd.heightHint = 50;
        this.m_table.setLayoutData((Object)gd);
        this.m_tableViewer = new TableViewer(this.m_table);
        this.m_tableViewer.setData(VIEWER_TYPE, (Object)AGENT_OVERVIEW);
        this.m_agentOverviewTableProvider = new AgentOverviewTableProvider();
        TableViewerColumn col0 = new TableViewerColumn(this.m_tableViewer, 16384);
        col0.getColumn().setText("Status");
        col0.getColumn().setWidth(Integer.parseInt("" + m_columnWidth.get("Status")));
        col0.setLabelProvider(this.m_agentOverviewTableProvider.labelProvider);
        TableViewerColumn col1 = new TableViewerColumn(this.m_tableViewer, 16384);
        col1.getColumn().setText("Label");
        col1.getColumn().setWidth(Integer.parseInt("" + m_columnWidth.get("Label")));
        col1.setLabelProvider(this.m_agentOverviewTableProvider.labelProvider);
        col1.getColumn().addListener(13, this.sortListener);
        TableViewerColumn col2 = new TableViewerColumn(this.m_tableViewer, 16384);
        col2.getColumn().setText("OS");
        col2.getColumn().setWidth(Integer.parseInt("" + m_columnWidth.get("OS")));
        col2.setLabelProvider(this.m_agentOverviewTableProvider.labelProvider);
        col2.getColumn().addListener(13, this.sortListener);
        TableViewerColumn col3 = new TableViewerColumn(this.m_tableViewer, 16384);
        col3.getColumn().setText("Disabled");
        col3.getColumn().setWidth(Integer.parseInt("" + m_columnWidth.get("Disabled")));
        col3.setLabelProvider(this.m_agentOverviewTableProvider.labelProvider);
        col3.getColumn().addListener(13, this.sortListener);
        TableViewerColumn col4 = new TableViewerColumn(this.m_tableViewer, 16384);
        col4.getColumn().setText("Maintenanced");
        col4.getColumn().setWidth(Integer.parseInt("" + m_columnWidth.get("Maintenanced")));
        col4.setLabelProvider(this.m_agentOverviewTableProvider.labelProvider);
        col4.getColumn().addListener(13, this.sortListener);
        TableViewerColumn col5 = new TableViewerColumn(this.m_tableViewer, 16384);
        col5.getColumn().setText("Max Severity");
        col5.getColumn().setWidth(Integer.parseInt("" + m_columnWidth.get("Max Severity")));
        col5.setLabelProvider(this.m_agentOverviewTableProvider.labelProvider);
        col5.getColumn().addListener(13, this.sortListener);
        TableViewerColumn col6 = new TableViewerColumn(this.m_tableViewer, 16384);
        col6.getColumn().setText("Version");
        col6.getColumn().setWidth(Integer.parseInt("" + m_columnWidth.get("Version")));
        col6.setLabelProvider(this.m_agentOverviewTableProvider.labelProvider);
        col6.getColumn().addListener(13, this.sortListener);
        TableViewerColumn col7 = new TableViewerColumn(this.m_tableViewer, 16384);
        col7.getColumn().setText("IP");
        col7.getColumn().setWidth(Integer.parseInt("" + m_columnWidth.get("IP")));
        col7.setLabelProvider(this.m_agentOverviewTableProvider.labelProvider);
        col7.getColumn().addListener(13, this.sortListener);
        TableViewerColumn col8 = new TableViewerColumn(this.m_tableViewer, 16384);
        col8.getColumn().setText("Port");
        col8.getColumn().setWidth(Integer.parseInt("" + m_columnWidth.get("Port")));
        col8.setLabelProvider(this.m_agentOverviewTableProvider.labelProvider);
        col8.getColumn().addListener(13, this.sortListener);
        TableViewerColumn col9 = new TableViewerColumn(this.m_tableViewer, 16384);
        col9.getColumn().setText("Transport");
        col9.getColumn().setWidth(Integer.parseInt("" + m_columnWidth.get("Transport")));
        col9.setLabelProvider(this.m_agentOverviewTableProvider.labelProvider);
        col9.getColumn().addListener(13, this.sortListener);
        TableViewerColumn col10 = new TableViewerColumn(this.m_tableViewer, 16384);
        col10.getColumn().setText("Host");
        col10.getColumn().setWidth(Integer.parseInt("" + m_columnWidth.get("Host")));
        col10.setLabelProvider(this.m_agentOverviewTableProvider.labelProvider);
        col10.getColumn().addListener(13, this.sortListener);
        TableViewerColumn col11 = new TableViewerColumn(this.m_tableViewer, 16384);
        col11.getColumn().setText("Last Indication (Days)");
        col11.getColumn().setWidth(Integer.parseInt("" + m_columnWidth.get("Last Indication (Days)")));
        col11.setLabelProvider(this.m_agentOverviewTableProvider.labelProvider);
        col11.getColumn().addListener(13, this.sortListener);
        TableViewerColumn col12 = new TableViewerColumn(this.m_tableViewer, 16384);
        col12.getColumn().setText("BOOM Server");
        col12.getColumn().setWidth(Integer.parseInt("" + m_columnWidth.get("BOOM Server")));
        col12.setLabelProvider(this.m_agentOverviewTableProvider.labelProvider);
        col12.getColumn().addListener(13, this.sortListener);
        TableViewerColumn col13 = new TableViewerColumn(this.m_tableViewer, 16384);
        col13.getColumn().setText("Agent ID");
        col13.getColumn().setWidth(Integer.parseInt("" + m_columnWidth.get("Agent ID")));
        col13.setLabelProvider(this.m_agentOverviewTableProvider.labelProvider);
        col13.getColumn().addListener(13, this.sortListener);
        TableColumnLayout tableLayout = new TableColumnLayout();
        this.m_compTable.setLayout((Layout)tableLayout);
        tableLayout.setColumnData((Widget)col0.getColumn(), (ColumnLayoutData)new ColumnWeightData(0, col0.getColumn().getWidth()));
        tableLayout.setColumnData((Widget)col1.getColumn(), (ColumnLayoutData)new ColumnWeightData(0, col1.getColumn().getWidth()));
        tableLayout.setColumnData((Widget)col2.getColumn(), (ColumnLayoutData)new ColumnWeightData(0, col2.getColumn().getWidth()));
        tableLayout.setColumnData((Widget)col3.getColumn(), (ColumnLayoutData)new ColumnWeightData(0, col3.getColumn().getWidth()));
        tableLayout.setColumnData((Widget)col4.getColumn(), (ColumnLayoutData)new ColumnWeightData(0, col4.getColumn().getWidth()));
        tableLayout.setColumnData((Widget)col5.getColumn(), (ColumnLayoutData)new ColumnWeightData(0, col5.getColumn().getWidth()));
        tableLayout.setColumnData((Widget)col6.getColumn(), (ColumnLayoutData)new ColumnWeightData(0, col6.getColumn().getWidth()));
        tableLayout.setColumnData((Widget)col7.getColumn(), (ColumnLayoutData)new ColumnWeightData(0, col7.getColumn().getWidth()));
        tableLayout.setColumnData((Widget)col8.getColumn(), (ColumnLayoutData)new ColumnWeightData(0, col8.getColumn().getWidth()));
        tableLayout.setColumnData((Widget)col9.getColumn(), (ColumnLayoutData)new ColumnWeightData(0, col9.getColumn().getWidth()));
        tableLayout.setColumnData((Widget)col10.getColumn(), (ColumnLayoutData)new ColumnWeightData(0, col10.getColumn().getWidth()));
        tableLayout.setColumnData((Widget)col11.getColumn(), (ColumnLayoutData)new ColumnWeightData(0, col11.getColumn().getWidth()));
        tableLayout.setColumnData((Widget)col12.getColumn(), (ColumnLayoutData)new ColumnWeightData(0, col12.getColumn().getWidth()));
        tableLayout.setColumnData((Widget)col13.getColumn(), (ColumnLayoutData)new ColumnWeightData(100, col13.getColumn().getWidth()));
        m_colIndices = new HashMap();
        m_colNames = new HashMap();
        TableColumn[] cols = this.m_table.getColumns();
        int i = 0;
        while (i < cols.length) {
            TableColumn col = cols[i];
            m_colIndices.put(col.getText(), i);
            m_colNames.put(i, col.getText());
            ++i;
        }
        this.m_table.setSortColumn(this.m_table.getColumn(m_colIndices.get("Label").intValue()));
        this.m_table.setSortDirection(128);
        this.m_tableViewer.setContentProvider((IContentProvider)this.m_agentOverviewTableProvider);
        FancyToolTipSupport.enableFor((ColumnViewer)this.m_tableViewer, 2);
        this.m_tableViewer.setSorter((ViewerSorter)this.m_agentOverviewTableProvider);
        this.m_tableViewer.setComparer((IElementComparer)this.m_agentOverviewTableProvider);
        this.m_tableViewer.setInput((Object)this.m_agentOverviewTableProvider.getElements(null));
        this.m_tableViewer.addDoubleClickListener((IDoubleClickListener)this);
        this.m_tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AgentOverviewTab.this.updateCounters();
                AgentOverviewTab.this.m_compCounter.layout(true);
            }
        });
        this.m_table.setToolTipText("");
        this.createTable_CM();
    }

    public void createTable_CM() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(false);
        Menu menu = menuMgr.createContextMenu(this.m_tableViewer.getControl());
        this.m_tableViewer.getControl().setMenu(menu);
        IWorkbenchPartSite site = AgentCardView.getInstance().getSite();
        site.registerContextMenu(menuMgr, (ISelectionProvider)this.m_tableViewer);
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                try {
                    StructuredSelection ssel = (StructuredSelection)AgentOverviewTab.this.m_tableViewer.getSelection();
                    AgentCard firstSelectedAC = AgentOverviewTab.this.getFirstSelectedAgentCard();
                    ArrayList<AgentCard> selectedACs = new ArrayList<AgentCard>();
                    ArrayList<String> selectedAC_Ids = new ArrayList<String>();
                    ArrayList<AgentCard> acDisabled = new ArrayList<AgentCard>();
                    ArrayList<AgentCard> acEnabled = new ArrayList<AgentCard>();
                    ArrayList<AgentCard> acFirewalledOn = new ArrayList<AgentCard>();
                    ArrayList<AgentCard> acFirewalledOff = new ArrayList<AgentCard>();
                    for (Object o : ssel) {
                        if (!(o instanceof AgentCard)) continue;
                        AgentCard ac = (AgentCard)o;
                        selectedACs.add(ac);
                        selectedAC_Ids.add(ac.getAgentID());
                        if (ac.isExternal()) continue;
                        if (ac.isDisabled()) {
                            acDisabled.add(ac);
                        } else {
                            acEnabled.add(ac);
                        }
                        if (ac.isFirewalled()) {
                            acFirewalledOn.add(ac);
                            continue;
                        }
                        acFirewalledOff.add(ac);
                    }
                    manager.add((IAction)new RefreshTableAction());
                    manager.add((IContributionItem)new Separator());
                    if (firstSelectedAC != null) {
                        SelectAgentInTreeAction selectAgent = new SelectAgentInTreeAction(firstSelectedAC.getAgentID());
                        manager.add((IAction)selectAgent);
                        if (ssel.size() > 1) {
                            selectAgent.setEnabled(false);
                        }
                        ShowRelatedHostInfosAction showRelGroups = new ShowRelatedHostInfosAction(AgentOverviewTab.this.m_tableViewer, firstSelectedAC, AgentOverviewTab.this.m_folder.getShell());
                        manager.add((IAction)showRelGroups);
                        if (ssel.size() > 1) {
                            showRelGroups.setEnabled(false);
                        }
                    }
                    manager.add((IAction)new OpenMessageBrowserAction(selectedACs));
                    manager.add((IContributionItem)new Separator());
                    manager.add((IAction)new ShowAssignedPoliciesAction(selectedACs));
                    manager.add((IAction)new ApproveAgentAction(selectedACs));
                    manager.add((IAction)new RedeployAgentAction(selectedACs));
                    manager.add((IAction)new SyncAgentsAction(ssel));
                    if (acDisabled.size() > 0) {
                        manager.add((IAction)new EnableDisableHostAction(acDisabled, ENABLE));
                    }
                    if (acEnabled.size() > 0) {
                        manager.add((IAction)new EnableDisableHostAction(acEnabled, DISABLE));
                    }
                    manager.add((IAction)new UndeployFromAll(selectedAC_Ids));
                    if (acFirewalledOn.size() > 0) {
                        manager.add((IAction)new SetFirewallAction(acFirewalledOn, SET_FIREWALLED_OFF));
                    }
                    if (acFirewalledOff.size() > 0) {
                        manager.add((IAction)new SetFirewallAction(acFirewalledOff, SET_FIREWALLED_ON));
                    }
                    manager.add((IContributionItem)new Separator());
                    manager.add((IAction)new StartAdHocMaintenanceAction(selectedACs, 3));
                    manager.add((IAction)new StartAdHocMaintenanceAction(selectedACs, 1));
                    manager.add((IContributionItem)new Separator());
                    manager.add((IAction)new TriggerInventoryAction(selectedACs));
                    FastAndRemoteActions fastAndRemoteActions = new FastAndRemoteActions(manager, AgentOverviewTab.this.m_folder.getShell(), AgentOverviewTab.this.m_tableViewer);
                    if (fastAndRemoteActions.selectionContainsRunnableAgents(ssel)) {
                        fastAndRemoteActions.addActions();
                    }
                    manager.add((IContributionItem)new Separator());
                    manager.add((IAction)new AddNewAgent());
                    manager.add((IAction)new AddVirtAgentAction());
                    manager.add((IAction)new RestartAgentAction(selectedACs));
                    manager.add((IAction)new DeleteAgentAction(AgentOverviewTab.this.m_tableViewer));
                    manager.add((IContributionItem)new Separator());
                    manager.add((IAction)new ClipboardAgents("Copy as text", ssel));
                    manager.add((IAction)new ExportAgentOverviewAction(AgentOverviewTab.this.m_tableViewer));
                }
                catch (RuntimeException runtimeException) {}
            }
        });
    }

    public void createCounterSection(Composite parent) {
        this.m_compCounter = new Composite(parent, 0);
        GridLayout gl = new GridLayout(1, false);
        gl.verticalSpacing = 0;
        gl.horizontalSpacing = 0;
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        this.m_compCounter.setLayout((Layout)gl);
        this.m_compCounter.setLayoutData((Object)new GridData(4, 4, true, false));
        this.m_compCounter.addControlListener(new ControlListener(){

            public void controlResized(ControlEvent e) {
                boolean displayLongFooter = AgentOverviewTab.this.m_displayLongFooter;
                AgentOverviewTab.this.checkCounterSectionWidth();
                if (displayLongFooter != AgentOverviewTab.this.m_displayLongFooter) {
                    AgentOverviewTab.this.updateCounters();
                }
            }

            public void controlMoved(ControlEvent e) {
            }
        });
        this.updateCounters();
    }

    public void checkCounterSectionWidth() {
        int CTabFolderWidth = this.getParent().getBounds().width;
        int widthAvailable = CTabFolderWidth - 10;
        int widthNeeded = 700;
        try {
            widthNeeded = this.m_counter_label.getClientArea().width + 10;
        }
        catch (Throwable throwable) {}
        this.m_displayLongFooter = true;
        if (widthAvailable < widthNeeded) {
            this.m_displayLongFooter = false;
        }
    }

    public void updateCounters() {
        this.m_agentOverviewTableProvider.recalculateCounters(this.m_agentOverviewTableProvider.getElements(null));
        int filtered = this.m_tableViewer.getTable().getItemCount();
        int total = this.m_agentOverviewTableProvider.getNumberOfAgents();
        int disabled = this.m_agentOverviewTableProvider.getNumberOfDisabled();
        int online = this.m_agentOverviewTableProvider.getNumberOfOnline();
        int offline = this.m_agentOverviewTableProvider.getNumberOfOffline();
        int notApproved = this.m_agentOverviewTableProvider.getNumberOfNotApproved();
        int firewalled = this.m_agentOverviewTableProvider.getNumberOfFirewalled();
        int normal = this.m_agentOverviewTableProvider.getNumberOfNormalNodes();
        int external = this.m_agentOverviewTableProvider.getNumberOfExternalNodes();
        int selected = this.m_table.getSelectionCount();
        int maintenanced = this.m_agentOverviewTableProvider.getNumberMaintenanceHosts();
        this.m_filter_combo.setItem(0, String.valueOf(SHOW_ALL) + " (" + total + ")");
        this.m_filter_combo.setItem(1, String.valueOf(SHOW_ONLINE) + " (" + online + ")");
        this.m_filter_combo.setItem(2, String.valueOf(SHOW_OFFLINE) + " (" + offline + ")");
        this.m_filter_combo.setItem(3, String.valueOf(SHOW_DISABLED) + " (" + disabled + ")");
        this.m_filter_combo.setItem(4, String.valueOf(SHOW_MAINTENANCED) + " (" + maintenanced + ")");
        this.m_filter_combo.setItem(5, String.valueOf(SHOW_NOT_APPROVED) + " (" + notApproved + ")");
        this.m_filter_combo.setItem(6, String.valueOf(SHOW_FIREWALLED) + " (" + firewalled + ")");
        this.m_filter_combo.setItem(7, String.valueOf(SHOW_NOT_FIREWALLED) + " (" + (total - firewalled) + ")");
        int selIndex = this.getDisplayTypeMode(this.m_displayType);
        String currentlyDisplayedText = this.m_filter_combo.getText();
        String textInDropDownList = this.m_filter_combo.getItem(selIndex);
        if (!currentlyDisplayedText.equals(textInDropDownList)) {
            this.m_filter_combo.setText(textInDropDownList);
        }
        StringBuffer sb = new StringBuffer();
        sb.append("Selected (").append(selected);
        sb.append(") Total (").append(total);
        if (filtered < total) {
            sb.append("/").append(filtered);
        }
        sb.append(")   Online (").append(online).append(")   Offline (").append(offline);
        this.m_displayLongFooter = true;
        if (this.m_displayLongFooter) {
            sb.append(")   Disabled (").append(disabled).append(")   Maintenanced (").append(maintenanced).append(")   NOT Approved (").append(notApproved).append(")   Firewalled (").append(firewalled).append(")   Normal (").append(normal).append(")   External (").append(external).append(")");
        }
        if (this.m_counter_label == null || this.m_counter_label.isDisposed()) {
            this.m_counter_label = this.m_gui.addTextReadOnlyNoBorder(this.m_compCounter, null, sb.toString(), 1, 1, 0, 0, null);
        }
        this.m_counter_label.setText(sb.toString());
        this.m_counter_label.pack();
    }

    public void filterTableOnExternal(String filterName, boolean display) {
        this.m_tableFilters.remove(filterName);
        AgentTableFilterOnExternal filter = new AgentTableFilterOnExternal(filterName, display);
        this.m_tableFilters.put(filterName, filter);
        this.updateTable();
    }

    public void filterTableByStatus() {
        this.m_tableFilters.remove(FILTER_BY_STATUS);
        if (!this.m_displayType.equals(SHOW_ALL)) {
            AgentTableFilterOnStatus filterOnType = new AgentTableFilterOnStatus(this.getDisplayTypeMode(this.m_displayType));
            this.m_tableFilters.put(FILTER_BY_STATUS, filterOnType);
        }
        this.updateTable();
    }

    public void filterTable(String filterText, boolean byName, boolean byIP, boolean byHost, boolean byAgentID, boolean byBOOMSever) {
        this.m_tableFilters.remove(FILTER_BY_NAME);
        if (filterText != null && filterText.length() != 0) {
            AgentTableFilter filterOnName = new AgentTableFilter(filterText, byName, byIP, byHost, byAgentID, byBOOMSever);
            this.m_tableFilters.put(FILTER_BY_NAME, filterOnName);
        }
        this.updateTable();
    }

    public void updateTable() {
        if (this.m_tableFilters.size() == 0) {
            this.m_tableViewer.resetFilters();
        } else {
            ViewerFilter[] filters = this.m_tableFilters.values().toArray(new ViewerFilter[0]);
            this.m_tableViewer.resetFilters();
            this.m_tableViewer.setFilters(filters);
        }
        this.updateCounters();
    }

    public TableViewer getTableViewer() {
        return this.m_tableViewer;
    }

    public AgentCard getFirstSelectedAgentCard() {
        AgentCard selAC = null;
        StructuredSelection ssel = (StructuredSelection)this.m_tableViewer.getSelection();
        if (!ssel.isEmpty()) {
            selAC = (AgentCard)ssel.getFirstElement();
        }
        return selAC;
    }

    public List<AgentCard> getSelectedAgentCards() {
        ArrayList<AgentCard> selAgentCards = new ArrayList<AgentCard>();
        StructuredSelection ssel = (StructuredSelection)this.m_tableViewer.getSelection();
        if (ssel.isEmpty()) {
            return selAgentCards;
        }
        for (Object o : ssel) {
            if (!(o instanceof AgentCard)) continue;
            AgentCard ac = (AgentCard)o;
            selAgentCards.add(ac);
        }
        return selAgentCards;
    }

    public void dispose() {
        super.dispose();
    }

    public int getDisplayTypeMode(String displayType) {
        int mode = 0;
        if (displayType.contains("(")) {
            String[] arr = displayType.split("\\(");
            displayType = arr[0].trim();
        }
        if (displayType.equals(SHOW_ALL)) {
            mode = 0;
        } else if (displayType.equals(SHOW_ONLINE)) {
            mode = 1;
        } else if (displayType.equals(SHOW_OFFLINE)) {
            mode = 2;
        } else if (displayType.equals(SHOW_DISABLED)) {
            mode = 3;
        } else if (displayType.equals(SHOW_MAINTENANCED)) {
            mode = 4;
        } else if (displayType.equals(SHOW_NOT_APPROVED)) {
            mode = 5;
        } else if (displayType.equals(SHOW_FIREWALLED)) {
            mode = 6;
        } else if (displayType.equals(SHOW_NOT_FIREWALLED)) {
            mode = 7;
        }
        return mode;
    }

    public String getDisplayTypeText(int mode) {
        String type = SHOW_ALL;
        switch (mode) {
            case 0: {
                type = SHOW_ALL;
                break;
            }
            case 1: {
                type = SHOW_ONLINE;
                break;
            }
            case 2: {
                type = SHOW_OFFLINE;
                break;
            }
            case 3: {
                type = SHOW_DISABLED;
                break;
            }
            case 4: {
                type = SHOW_MAINTENANCED;
                break;
            }
            case 5: {
                type = SHOW_NOT_APPROVED;
                break;
            }
            case 6: {
                type = SHOW_FIREWALLED;
                break;
            }
            case 7: {
                type = SHOW_NOT_FIREWALLED;
                break;
            }
        }
        return type;
    }

    @Override
    public void refresh() {
        try {
            if (m_tab != null && !m_tab.isDisposed() && m_tab.isShowing()) {
                this.m_tableViewer.refresh();
                this.m_compTable.layout(true);
                this.m_compCounter.layout(true);
                this.updateCounters();
            }
        }
        catch (Throwable throwable) {}
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        CCombo combo;
        String name;
        Object obj = e.getSource();
        if (obj instanceof Button) {
            Button b = (Button)obj;
            String name2 = (String)b.getData();
            if (name2.equals(REFRESH_BTN)) {
                RefreshTableAction action = new RefreshTableAction();
                action.run();
            } else if (name2.equals(DISPLAY_NORMAL_NODES)) {
                this.filterTableOnExternal(DISPLAY_NORMAL_NODES, b.getSelection());
            } else if (name2.equals(DISPLAY_EXTERNAL_NODES)) {
                this.filterTableOnExternal(DISPLAY_EXTERNAL_NODES, b.getSelection());
            }
        } else if (obj instanceof CCombo && (name = (String)(combo = (CCombo)obj).getData()).equals(FILTER_COMBO)) {
            int selIndex = combo.getSelectionIndex();
            this.m_displayType = this.getDisplayTypeText(selIndex);
            this.filterTableByStatus();
            this.m_tableViewer.getTable().setFocus();
        }
    }

    public void doubleClick(DoubleClickEvent event) {
        ShowAssignedPoliciesAction sa = new ShowAssignedPoliciesAction(this.getSelectedAgentCards());
        sa.run();
    }

    private class RefreshTableAction
    extends Action {
        public RefreshTableAction() {
            super("refreshtable");
            this.setId("refreshtable");
            this.setText("Refresh");
            this.setImageDescriptor(BMUI.IMAGE_DESCR_REFRESH);
            if (Repository.getInstance().getRights(1001) < 3) {
                this.setEnabled(false);
            }
        }

        public void run() {
            new UIJob("AgentOverviewRefresh"){

                @Override
                public IStatus runInUIThread(IProgressMonitor monitor) {
                    AgentOverviewTab.this.refresh();
                    return null;
                }
            };
            ScGetAgentCards scga = new ScGetAgentCards(Repository.getInstance(), AgentCard.class);
            scga.addCmdPostProcess(Repository.getInstance());
            Repository.getJobManager().schedule(scga);
            ScGetAgentVersions sc = new ScGetAgentVersions(Repository.getInstance());
            sc.addCmdPostProcess(Repository.getInstance());
            Repository.getJobManager().schedule(sc);
            EventStatusRefreshJob errj = new EventStatusRefreshJob(Repository.getInstance().getAgentCards());
            JobManager.getInstance().schedule(errj);
        }
    }
}

