/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views;

import com.blixx.boom.engine.AgentCard;
import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.gui.views.AgentOverviewTab;
import com.blixx.shared.utils.GroupTreeObjectLast;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public class AgentOverviewTableProvider
extends ViewerSorter
implements IElementComparer,
Comparator,
IStructuredContentProvider {
    private int m_total = 0;
    private int m_online = 0;
    private int m_offline = 0;
    private int m_disabled = 0;
    private int m_notApproved = 0;
    private int m_firewalled = 0;
    private int m_normalNodes = 0;
    private int m_externalNodes = 0;
    private String column = "Label";
    private int dir = 128;
    public static final String REFRESH = "REFRESH";
    public static final String COL_STATUS = "Status";
    public static final String COL_OS = "OS";
    public static final String COL_DISABLED = "Disabled";
    public static final String COL_MAINTENANCED = "Maintenanced";
    public static final String COL_AGENT_LABEL = "Label";
    public static final String COL_AGENT_MAXSeverity = "Max Severity";
    public static final String COL_AGENT_VERSION = "Version";
    public static final String COL_IP = "IP";
    public static final String COL_PORT = "Port";
    public static final String COL_TRANSPORT = "Transport";
    public static final String COL_HOST = "Host";
    public static final String COL_LAST_MSG = "Last Indication (Days)";
    public static final String COL_SERVER = "BOOM Server";
    public static final String COL_AGENT_ID = "Agent ID";
    public static final int COL_STATUS_INT = 0;
    public static final int COL_AGENT_LABEL_INT = 1;
    public static final int COL_OS_INT = 2;
    public static final int COL_DISABLED_INT = 3;
    public static final int COL_MAINTENANCED_INT = 4;
    public static final int COL_AGENT_MAXSeverity_INT = 5;
    public static final int COL_AGENT_VERSION_INT = 6;
    public static final int COL_IP_INT = 7;
    public static final int COL_PORT_INT = 8;
    public static final int COL_TRANSPORT_INT = 9;
    public static final int COL_HOST_INT = 10;
    public static final int COL_LAST_MSG_INT = 11;
    public static final int COL_SERVER_INT = 12;
    public static final int COL_AGENT_ID_INT = 13;
    public static int MAX_LINES = 3;
    private static int m_maintenanced = 0;
    public CellLabelProvider labelProvider = new CellLabelProvider(){

        public String getToolTipText(Object element) {
            StringBuffer htmlStr = new StringBuffer();
            if (element instanceof AgentCard) {
                AgentCard ac = (AgentCard)element;
                String agentID = ac.getID();
                String name = ac.getComparableName().trim();
                String ip = ac.getAgentIP();
                String os = AgentOverviewTableProvider.getOS(ac);
                String disabled = "" + ac.isDisabled();
                String maintenanced = "???";
                String version = Repository.getInstance().getAgentVersion(ac.getID());
                String port = "" + ac.getAgentPort();
                String host = ac.getAgentHost();
                String lastIndi = AgentOverviewTableProvider.getLastMessage(ac);
                String server = ac.getRelatedServer();
                if (server == null) {
                    server = "";
                }
                htmlStr.append("<html><body bgcolor='#FFFFE1'>");
                htmlStr.append("<table border='0' cellspacing='0' cellpadding='0'>");
                htmlStr.append("<tr valign='top'><td nowrap ><font face='Arial' size='1' color='#000000'>Label:</font></td>");
                htmlStr.append("<td nowrap ><font face='Arial' size='1' color='#000000'><b>").append(name).append("</b></font></td></tr>");
                htmlStr.append("<tr valign='top'><td nowrap ><font face='Arial' size='1' color='#000000'>IP:</font></td>");
                htmlStr.append("<td nowrap ><font face='Arial' size='1' color='#000000'><b>").append(ip).append("</b></font></td></tr>");
                htmlStr.append("<tr valign='top'><td nowrap ><font face='Arial' size='1' color='#000000'>OS:</font></td>");
                htmlStr.append("<td nowrap ><font face='Arial' size='1' color='#000000'>").append(os).append("</font></td></tr>");
                htmlStr.append("<tr valign='top'><td nowrap ><font face='Arial' size='1' color='#000000'>Agent ID:</font></td>");
                htmlStr.append("<td nowrap ><font face='Arial' size='1' color='#000000'>").append(agentID).append("</font></td></tr>");
                htmlStr.append("<tr valign='top'><td nowrap ><font face='Arial' size='1' color='#000000'>Disabled:</font></td>");
                htmlStr.append("<td nowrap ><font face='Arial' size='1' color='#000000'>").append(disabled).append("</font></td></tr>");
                htmlStr.append("<tr valign='top'><td nowrap ><font face='Arial' size='1' color='#000000'>Maintenanced:</font></td>");
                htmlStr.append("<td nowrap ><font face='Arial' size='1' color='#000000'>").append(maintenanced).append("</font></td></tr>");
                htmlStr.append("<tr valign='top'><td nowrap ><font face='Arial' size='1' color='#000000'>Version:</font></td>");
                htmlStr.append("<td nowrap ><font face='Arial' size='1' color='#000000'>").append(version).append("</font></td></tr>");
                htmlStr.append("<tr valign='top'><td nowrap ><font face='Arial' size='1' color='#000000'>Port:</font></td>");
                htmlStr.append("<td nowrap ><font face='Arial' size='1' color='#000000'>").append(port).append("</font></td></tr>");
                htmlStr.append("<tr valign='top'><td nowrap ><font face='Arial' size='1' color='#000000'>Host:</font></td>");
                htmlStr.append("<td nowrap ><font face='Arial' size='1' color='#000000'>").append(host).append("</font></td></tr>");
                htmlStr.append("<tr valign='top'><td nowrap ><font face='Arial' size='1' color='#000000'>").append("BOOM").append(" Server:</font></td>");
                htmlStr.append("<td nowrap ><font face='Arial' size='1' color='#000000'>").append(server).append("</font></td></tr>");
                htmlStr.append("<tr valign='top'><td nowrap ><font face='Arial' size='1' color='#000000'>Last Indication:&nbsp;&nbsp;</font></td>");
                htmlStr.append("<td nowrap ><font face='Arial' size='1' color='#000000'>").append(lastIndi).append("</font></td></tr>");
                htmlStr.append("</table>");
                htmlStr.append("</body></html>");
            }
            return htmlStr.toString();
        }

        public Point getToolTipShift(Object object) {
            return new Point(3, 3);
        }

        public int getToolTipDisplayDelayTime(Object object) {
            return 1000;
        }

        public int getToolTipTimeDisplayed(Object object) {
            return 3000;
        }

        public void update(ViewerCell cell) {
            AgentCard ac = null;
            int columnIndex = cell.getColumnIndex();
            if (!(cell.getElement() instanceof AgentCard)) {
                return;
            }
            ac = (AgentCard)cell.getElement();
            String result = AgentOverviewTableProvider.getText(columnIndex, ac);
            Image image = AgentOverviewTableProvider.getImage(columnIndex, ac);
            cell.setText(result);
            if (!result.matches("\\A\\p{ASCII}*\\z")) {
                cell.setForeground(BMUI.color_orange);
                cell.setFont(BMUI.font_arial7_bold);
            }
            cell.setImage(image);
        }
    };

    public void setSortingProps(String column, int direction) {
        this.column = column;
        this.dir = direction;
    }

    public Object[] getElements(Object inputElement) {
        return Repository.getInstance().getAgentCards().toArray();
    }

    public static Image getStatusIcon(String status) {
        Image image = BMUI.IMAGE_MAP.get(status);
        if (image == null) {
            image = BMUI.IMAGE_PC;
        }
        return image;
    }

    public static String getOS(AgentCard ac) {
        String os = ac.getOSNameOnly();
        return os;
    }

    public static String getLastMessage(AgentCard ac) {
        String msg = "";
        long last = -1L;
        last = ac.getLastMessageReceived();
        if (last > 0L) {
            long diff = System.currentTimeMillis() - last;
            msg = "" + (int)(diff / 86400000L);
        }
        return msg;
    }

    public static boolean isAgentOnline(AgentCard ac) {
        return ac == null ? false : ac.isOnline();
    }

    public int getNumberOfAgents() {
        return this.m_total;
    }

    public int getNumberOfOnline() {
        return this.m_online;
    }

    public int getNumberOfOffline() {
        return this.m_offline;
    }

    public int getNumberOfDisabled() {
        return this.m_disabled;
    }

    public int getNumberOfNotApproved() {
        return this.m_notApproved;
    }

    public int getNumberOfFirewalled() {
        return this.m_firewalled;
    }

    public int getNumberOfNormalNodes() {
        return this.m_normalNodes;
    }

    public int getNumberOfExternalNodes() {
        return this.m_externalNodes;
    }

    public int getNumberMaintenanceHosts() {
        return m_maintenanced;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        Object[] arr = (Object[])newInput;
        this.recalculateCounters(arr);
    }

    public void recalculateCounters(Object[] arr) {
        if (arr == null) {
            return;
        }
        this.m_total = arr.length;
        this.m_disabled = 0;
        this.m_notApproved = 0;
        this.m_firewalled = 0;
        this.m_offline = 0;
        this.m_online = 0;
        this.m_normalNodes = 0;
        this.m_externalNodes = 0;
        m_maintenanced = 0;
        int i = 0;
        while (i < arr.length) {
            AgentCard ac = (AgentCard)arr[i];
            if (ac.isDisabled()) {
                ++this.m_disabled;
            }
            if (!ac.isApproved()) {
                ++this.m_notApproved;
            }
            if (ac.isFirewalled()) {
                ++this.m_firewalled;
            }
            if (ac.isExternal()) {
                ++this.m_externalNodes;
            } else {
                ++this.m_normalNodes;
            }
            if (AgentOverviewTableProvider.isAgentOnline(ac)) {
                ++this.m_online;
            } else {
                ++this.m_offline;
            }
            if (ac.getAgentOutage()) {
                ++m_maintenanced;
            }
            ++i;
        }
    }

    public static String getTransport(AgentCard ac) {
        return ac.isTlsAgent() ? "TLS" : (ac.isHttpAgent() ? BMUI.HTTP_PROTOCOL.toUpperCase() : "");
    }

    public static String getText(int columnIndex, AgentCard ac) {
        String result = "";
        switch (columnIndex) {
            case 0: {
                break;
            }
            case 2: {
                result = ac.getOSNameOnly();
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                if (!ac.getAgentOutage()) break;
                result = new String(Character.toChars(Integer.parseInt("1F6C7", 16)));
                break;
            }
            case 1: {
                result = ac.getComparableName().trim();
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                result = Repository.getInstance().getAgentVersion(ac.getID());
                break;
            }
            case 7: {
                result = ac.getAgentIP();
                break;
            }
            case 8: {
                result = "" + ac.getAgentPort();
                break;
            }
            case 9: {
                result = AgentOverviewTableProvider.getTransport(ac);
                break;
            }
            case 10: {
                result = ac.getAgentHost();
                break;
            }
            case 11: {
                result = AgentOverviewTableProvider.getLastMessage(ac);
                break;
            }
            case 12: {
                result = ac.getRelatedServer();
                break;
            }
            case 13: {
                result = ac.getAgentID();
            }
        }
        if (result == null) {
            result = "";
        }
        return result;
    }

    public static Image getImage(int columnIndex, AgentCard ac) {
        Image image = null;
        switch (columnIndex) {
            case 0: {
                image = AgentOverviewTableProvider.getStatusIcon(ac.getIconnameForAgent());
                break;
            }
            case 2: {
                image = AgentCard.getOSIcon(AgentOverviewTableProvider.getOS(ac));
                break;
            }
            case 3: {
                if (!ac.isDisabled()) break;
                image = BMUI.IMAGE_PC_DISABLED;
                break;
            }
            case 5: {
                image = BMUI.getBox(BMUI.getMaxSeverityInt(ac));
            }
        }
        return image;
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        return this.compare(e1, e2);
    }

    public int compare(Object e1, Object e2) {
        int returnValue = 0;
        String p1Str = "";
        String p2Str = "";
        AgentCard ac1 = (AgentCard)e1;
        AgentCard ac2 = (AgentCard)e2;
        int colIndex = AgentOverviewTab.m_colIndices.get(this.column);
        if (colIndex > -1) {
            if (this.column.equals(COL_AGENT_LABEL) || this.column.equals(COL_IP) || this.column.equals(COL_AGENT_VERSION)) {
                p1Str = AgentOverviewTableProvider.getText(colIndex, ac1);
                p2Str = AgentOverviewTableProvider.getText(colIndex, ac2);
                returnValue = p1Str.compareToIgnoreCase(p2Str);
            } else if (this.column.equals(COL_PORT) || this.column.equals(COL_LAST_MSG)) {
                int p1Int = -1;
                int p2Int = -1;
                try {
                    String s1 = AgentOverviewTableProvider.getText(colIndex, ac1);
                    s1 = s1.replaceAll("\\.", "");
                    p1Int = Integer.valueOf(s1);
                }
                catch (NumberFormatException numberFormatException) {
                    p1Int = -1;
                }
                try {
                    String s2 = AgentOverviewTableProvider.getText(colIndex, ac2);
                    s2 = s2.replaceAll("\\.", "");
                    p2Int = Integer.valueOf(s2);
                }
                catch (NumberFormatException numberFormatException) {
                    p2Int = -1;
                }
                returnValue = Integer.compare(p1Int, p2Int);
            } else if (this.column.equals(COL_AGENT_MAXSeverity)) {
                int r1 = Math.max(Math.max(ac1.getEvents().getStatusAV(), ac1.getEvents().getStatusKPI()), ac1.getEvents().getStatusOther());
                int r2 = Math.max(Math.max(ac2.getEvents().getStatusAV(), ac2.getEvents().getStatusKPI()), ac2.getEvents().getStatusOther());
                returnValue = Integer.compare(r1, r2);
            } else if (this.column.equals(COL_DISABLED)) {
                int r1 = ac1.isDisabled() ? 1 : 0;
                int r2 = ac2.isDisabled() ? 1 : 0;
                returnValue = Integer.compare(r1, r2);
            } else {
                p1Str = AgentOverviewTableProvider.getText(colIndex, ac1);
                returnValue = p1Str.compareToIgnoreCase(p2Str = AgentOverviewTableProvider.getText(colIndex, ac2));
                if (returnValue == 0) {
                    p1Str = AgentOverviewTableProvider.getText(1, ac1);
                    p2Str = AgentOverviewTableProvider.getText(1, ac2);
                    returnValue = p1Str.compareToIgnoreCase(p2Str);
                }
            }
        }
        if (this.dir == 1024) {
            returnValue *= -1;
        }
        return returnValue;
    }

    public void sort(Viewer viewer, Object[] elements) {
        Arrays.sort(elements, this);
    }

    public boolean equals(Object a, Object b) {
        if (a instanceof GroupTreeObjectLast && b instanceof GroupTreeObjectLast) {
            return a == null ? b == null : ((GroupTreeObjectLast)a).getName().equals(((GroupTreeObjectLast)b).getName());
        }
        return a == null ? b == null : a.equals(b);
    }

    public int hashCode(Object element) {
        if (element instanceof GroupTreeObjectLast) {
            return ((GroupTreeObjectLast)element).getName().hashCode();
        }
        return element.hashCode();
    }
}

