/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views;

import com.blixx.boom.engine.AgentCMTableProvider;
import com.blixx.boom.engine.AgentCard;
import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.EventBrowserProvider;
import com.blixx.boom.engine.EventFilter;
import com.blixx.boom.engine.HostsTableProvider;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.engine.ServerClient;
import com.blixx.boom.engine.UIJob;
import com.blixx.boom.engine.UIJobManager;
import com.blixx.boom.gui.Activator;
import com.blixx.boom.gui.dialogs.AgentCMAddAttributeDialog;
import com.blixx.boom.gui.dialogs.RemoteActionDialog;
import com.blixx.boom.gui.dialogs.SelectActionDialog;
import com.blixx.boom.gui.dialogs.ShowMessageBox;
import com.blixx.boom.gui.policies.AgentInventoryLabelProvider;
import com.blixx.boom.gui.policies.ViewContentProvider;
import com.blixx.boom.gui.utils.ActionTreeFilter;
import com.blixx.boom.gui.utils.GUIDisplayElements;
import com.blixx.boom.gui.utils.IColorer;
import com.blixx.boom.gui.utils.STreeViewer;
import com.blixx.boom.gui.views.AgentCardView;
import com.blixx.boom.gui.views.AgentViewLabelProvider;
import com.blixx.boom.gui.views.FileCompareTab;
import com.blixx.boom.gui.views.MessageBrowserTab;
import com.blixx.boom.gui.views.MessagesView;
import com.blixx.boom.gui.views.actions.ApproveAgentAction;
import com.blixx.boom.gui.views.actions.AssignToNodeAction;
import com.blixx.boom.gui.views.actions.DeleteAgentAction;
import com.blixx.boom.gui.views.actions.EnableDisablePolicies;
import com.blixx.boom.gui.views.actions.ExpandCollapseAction;
import com.blixx.boom.gui.views.actions.ManageDialogAction;
import com.blixx.boom.gui.views.actions.OpenPolicyAction;
import com.blixx.boom.gui.views.actions.RedeployAgentAction;
import com.blixx.boom.gui.views.actions.RestartAgentAction;
import com.blixx.boom.gui.views.actions.SelectAssignmentInTreeAction;
import com.blixx.boom.gui.views.actions.SelectBinaryInTreeAction;
import com.blixx.boom.gui.views.actions.SelectPolicyInTreeAction;
import com.blixx.boom.gui.views.actions.ServerClientAction2;
import com.blixx.boom.gui.views.actions.ShowMessagesForSource;
import com.blixx.boom.gui.views.actions.ShowRelatedPolicyInfosAction;
import com.blixx.boom.gui.views.actions.SyncAgentsAction;
import com.blixx.boom.gui.views.actions.TriggerInventoryAction;
import com.blixx.boom.gui.views.actions.UndeployFromAll;
import com.blixx.boom.gui.views.actions.ViewFilterAction;
import com.blixx.ctrl.sc.ICmdPostProcess;
import com.blixx.ctrl.sc.IServerAuth;
import com.blixx.ctrl.sc.in.ScGetAgentInventoryCard;
import com.blixx.ctrl.sc.in.ScGetAgentsCM;
import com.blixx.ctrl.sc.in.ScGetAssigned;
import com.blixx.ctrl.sc.in.ScPutAgent;
import com.blixx.ctrl.sc.in.ScPutAgentsCM;
import com.blixx.ctrl.sc.in.ScRemoteAction;
import com.blixx.log.RTLogger;
import com.blixx.shared.AbstractAgentCard;
import com.blixx.shared.AgentCardCM;
import com.blixx.shared.AgentInventoryCard;
import com.blixx.shared.MonitorSerie;
import com.blixx.shared.io.SDataInputStream;
import com.blixx.shared.io.SDataOutputStream;
import com.blixx.shared.jobs.UnsupportedTypeException;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.GroupTreeObjectLast;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public class AgentTab
extends CTabItem
implements ModifyListener,
SelectionListener,
IColorer {
    private static final String ERROR_REQUESTING_MONITOR_VALUES_FROM_THE_AGENT = "Error requesting monitor values from the Agent!";
    private static final String REFRESH_MON_SERIES = "refreshMonSeries";
    public static final String SAVE_CM = "SAVE_CM";
    public static final String DELETE_CM = "DELETE_CM";
    public static final String EDIT_CM = "MODIFY_CM";
    public static final String ADD_CM = "ADD_CM";
    public static final String RELOAD_CM = "REFRESH_CM";
    private static String AGENT_TAB = "AGENT_TAB";
    private static final String VERSION_HISTORY = "VERSION_HISTORY";
    private static final String REFRESH_INVENTORY = "REFRESH_INVENTORY";
    private static final String TRIGGER_INVENTORY_BUTTON = "TriggerInventory";
    private static final String COMPARE_BUTTON = "Compare";
    private static final String LABEL = "label";
    private static final String PORT = "port";
    private static final String TLS = "tls";
    private static final String HOST = "host";
    private static final String IP = "IP";
    private static final String REDEPLOY_AGENT = "REDEPLOY_AGENT";
    private static final String RESTART = "RESTART";
    private static final String DESC = "desc";
    private static final String DISABLED_CHECKBOX = "disabled";
    private static final String FIREWALL = "firewall";
    private static final String SAVE = "SAVE";
    private static final String APPROVED = "approved";
    public static final String DELETE = "DELETE";
    public static final String VERSION = "VERSION (SERVER)";
    public static final String POLICYTYPE = "POLICYTYPE";
    public static String TREE_VIEWER_TYPE = "TREE_VIEWER_TYPE";
    public static final String POLICYNAME = "POLICYNAME";
    private CTabFolder m_parent = null;
    public TableViewer m_tableViewer = null;
    public TableViewer m_hostsViewer = null;
    private IWorkbenchPartSite site;
    private AgentCard m_ac = null;
    private HostsTableProvider m_hostsProvider = null;
    private TreeViewer m_treeViewer;
    private SashForm m_comp_mainArea;
    private SashForm m_sash = null;
    private ScrolledForm m_form = null;
    public Text m_agentID = null;
    public Text m_hostIP = null;
    public Button m_isFirewalled = null;
    public Button m_isApproved = null;
    public Button m_isDisabled = null;
    public Button m_isTls = null;
    public Text m_hostname = null;
    public Text m_label = null;
    public Text m_port = null;
    public Text m_os = null;
    public Text m_desc = null;
    private Button m_delete;
    private Button m_save;
    private Button m_restart;
    private Button m_redeploy;
    private boolean m_isAuthorized = false;
    public String m_oldACName = null;
    public boolean m_isDirty = false;
    private GUIDisplayElements m_gui = null;
    public AgentInventoryCard m_aci;
    public TreeViewer m_ACI = null;
    private CCombo m_versionsInv;
    private Button m_compareInv;
    private Button m_triggerInv;
    private Text m_discoveredInv;
    private Text m_versionInv;
    private Button m_refreshInv;
    private TableViewer m_agentCM_tv = null;
    private AgentCMTableProvider m_agentCM_tp = null;
    private Button m_editCM = null;
    public Button m_deleteCM = null;
    private Button m_saveCM = null;
    private List<MonitorSerie> m_monitorSeries = new ArrayList<MonitorSerie>();
    private static final String REQUEST_MONITOR_SERIES = "Requesting data from the Agent ...";
    private String m_monitorSeriesError = "Requesting data from the Agent ...";
    ISharedImages m_sharedImages = Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getWorkbench().getSharedImages();
    private Label m_monitorSeriesStatus;
    private TableViewer m_monitorSeriesViewer;
    private Button m_refreshMonSeries;
    private Button m_refresgCM;
    private Section m_sectionAttributes;
    private Section m_sectionLastMonitorValues;
    private Section m_sectionInventory;
    private Section m_sectionMonitoredHosts;
    private static MessageBrowserTab m_msgBrowerTab = null;

    public AgentTab(CTabFolder parent, int style, int position, AgentCard ac) {
        super(parent, style);
        try {
            this.m_parent = parent;
            this.site = AgentCardView.getInstance().getSite();
            this.m_ac = ac;
            this.setText("" + this.m_ac);
            this.setImage(AgentCard.getOSIcon(this.m_ac.getOSName()));
            this.setData(ac);
            if (Repository.getInstance().isPermittedAgentModify(this.m_ac)) {
                this.m_isAuthorized = true;
            }
            this.createMainArea();
        }
        catch (RuntimeException e) {
            RTLogger.print(4, "", e);
        }
    }

    public void createMainArea() {
        this.m_gui = new GUIDisplayElements();
        this.m_comp_mainArea = new SashForm((Composite)this.m_parent, 512);
        this.m_sash = new SashForm((Composite)this.m_comp_mainArea, 256);
        this.createAgentDetails(this.m_sash);
        this.createAssignmentTree((Composite)this.m_sash);
        if (!this.m_ac.isExternal()) {
            this.m_sash.setWeights(new int[]{60, 40});
        } else {
            int[] nArray = new int[2];
            nArray[0] = 100;
            this.m_sash.setWeights(nArray);
        }
        this.createMessageBrowser((Composite)this.m_comp_mainArea);
        this.m_comp_mainArea.setWeights(new int[]{60, 40});
        this.setControl((Control)this.m_comp_mainArea);
    }

    private void createMessageBrowser(Composite comp) {
        CTabFolder ctf = new CTabFolder(comp, 2048);
        m_msgBrowerTab = new MessageBrowserTab(AgentCardView.getInstance().getSite(), ctf, 0, 1, "Agent filtered ", true, MessageBrowserTab.DEFAULT_TAB, null);
        ViewFilterAction.m_filters.remove((Object)AgentTab.m_msgBrowerTab.tableViewer);
        EventFilter ef = null;
        ef = !this.m_ac.isExternal() ? new EventFilter(null, "AgentID", this.m_ac.getAgentID(), false, 4, AgentTab.m_msgBrowerTab.tableViewer, true, 0, 0) : new EventFilter(null, "Host", String.valueOf(this.m_ac.getAgentHost()) + "|" + this.m_ac.getAgentIP(), false, 4, AgentTab.m_msgBrowerTab.tableViewer, true, 0, 0);
        ViewFilterAction.addFilter((Object)m_msgBrowerTab, AgentTab.m_msgBrowerTab.tableViewer, ef);
        if (Repository.getInstance().getRights(2016) > 1) {
            MessageBrowserTab mtb = new MessageBrowserTab(AgentCardView.getInstance().getSite(), ctf, 0, ctf.getItemCount(), "Maintenance Agent filtered ", true, new EventBrowserProvider(Repository.getOuEventProvider()), Repository.getOuEventsSummary(), MessageBrowserTab.DEFAULT_TAB, null);
            ViewFilterAction.addFilter((Object)mtb, mtb.tableViewer, ef);
        }
        ctf.setSelection((CTabItem)m_msgBrowerTab);
    }

    private void createAgentDetails(SashForm sash) {
        this.m_form = BMUI.getFormToolkit(sash.getDisplay()).createScrolledForm((Composite)sash);
        Composite topComp = this.m_form.getBody();
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        topComp.setLayout((Layout)gridLayout);
        topComp.setLayoutData((Object)new GridData(4, 4, false, false));
        Composite agentDetails = new Composite(topComp, 2048);
        gridLayout = new GridLayout(4, false);
        gridLayout.marginHeight = 10;
        gridLayout.marginLeft = 10;
        gridLayout.marginBottom = 20;
        agentDetails.setLayout((Layout)gridLayout);
        agentDetails.setLayoutData((Object)new GridData(4, 4, true, true));
        int vIndent = 2;
        this.m_agentID = this.m_gui.addTextReadOnlyNoBorder(agentDetails, "Agent ID: ", this.m_ac.getAgentID(), 3, 1, 0, vIndent, null);
        ((GridData)this.m_agentID.getLayoutData()).horizontalAlignment = 4;
        if (!this.m_ac.isExternal()) {
            this.m_hostIP = this.m_gui.addTextReadOnlyNoBorder(agentDetails, "IP: ", this.m_ac.getAgentIP(), 3, 1, 0, vIndent, BMUI.font_arial8_bold);
            ((GridData)this.m_hostIP.getLayoutData()).horizontalAlignment = 4;
        } else {
            this.m_hostIP = this.m_gui.addInputFieldSingle(agentDetails, IP, "IP: ", this.m_ac.getAgentIP(), 2, 1, 1, vIndent, 60, this);
            ((GridData)this.m_hostIP.getLayoutData()).horizontalAlignment = 4;
            this.m_hostIP.setTextLimit(255);
            this.m_gui.setEditable(this.m_hostIP, this.m_isAuthorized);
            new Label(agentDetails, 0);
        }
        new Label(agentDetails, 0);
        this.m_isFirewalled = this.m_gui.addCheckbox(agentDetails, FIREWALL, "Firewalled", this.m_ac.isFirewalled(), 1, 1, vIndent, this);
        this.m_isFirewalled.setEnabled(this.m_isAuthorized && !this.m_ac.isExternal());
        ((GridData)this.m_isFirewalled.getLayoutData()).horizontalAlignment = 16384;
        this.m_isDisabled = this.m_gui.addCheckbox(agentDetails, DISABLED_CHECKBOX, "Disabled", this.m_ac.isDisabled(), 2, 1, vIndent, this);
        ((GridData)this.m_isDisabled.getLayoutData()).horizontalIndent = 10;
        ((GridData)this.m_isDisabled.getLayoutData()).horizontalAlignment = 16384;
        this.m_isDisabled.setEnabled(this.m_isAuthorized);
        this.m_label = this.m_gui.addInputFieldSingle(agentDetails, LABEL, "Label: ", this.m_ac.getLabel(), 3, 1, 1, vIndent, 60, this);
        this.m_label.setTextLimit(255);
        this.m_gui.setEditable(this.m_label, this.m_isAuthorized);
        if (!this.m_ac.isExternal()) {
            this.m_hostname = this.m_gui.addTextReadOnlyNoBorder(agentDetails, "Host: ", this.m_ac.getAgentHost(), 3, 1, 0, vIndent, BMUI.font_arial8_bold);
            ((GridData)this.m_hostname.getLayoutData()).horizontalAlignment = 4;
        } else {
            this.m_hostname = this.m_gui.addInputFieldSingle(agentDetails, HOST, "Host: ", this.m_ac.getAgentHost(), 3, 1, 1, vIndent, 60, this);
            ((GridData)this.m_hostname.getLayoutData()).horizontalAlignment = 4;
            this.m_hostname.setTextLimit(255);
            this.m_gui.setEditable(this.m_hostname, this.m_isAuthorized);
        }
        if (!this.m_ac.isExternal()) {
            this.m_port = this.m_gui.addInputFieldSingle(agentDetails, PORT, "Port: ", "" + this.m_ac.getAgentPort(), 3, 1, 1, vIndent, 60, this);
            this.m_port.setTextLimit(6);
            this.m_gui.setEditable(this.m_port, this.m_isAuthorized);
        } else {
            this.m_port = this.m_gui.addTextReadOnlyNoBorder(agentDetails, "Port: ", "" + this.m_ac.getAgentPort(), 3, 1, 1, vIndent, BMUI.font_arial8_bold);
        }
        new Label(agentDetails, 0);
        this.m_isTls = this.m_gui.addCheckbox(agentDetails, TLS, "TLS", this.m_ac.isTlsAgent(), 3, 1, vIndent, this);
        ((GridData)this.m_isTls.getLayoutData()).horizontalAlignment = 16384;
        this.m_isTls.setEnabled(this.m_isAuthorized && !this.m_ac.isExternal());
        Text server = this.m_gui.addTextReadOnlyNoBorder(agentDetails, "SlaveServer: ", this.m_ac.getRelatedServer() == null ? "" : this.m_ac.getRelatedServer(), 3, 1, 1, vIndent, BMUI.font_arial8_bold);
        ((GridData)server.getLayoutData()).horizontalAlignment = 4;
        this.m_os = this.m_gui.addTextReadOnlyNoBorder(agentDetails, "OS: ", this.m_ac.getOSNameOnly(), 3, 1, 0, vIndent, BMUI.font_arial8_bold);
        int height = 80;
        if (this.m_ac.isExternal()) {
            height = 150;
        }
        this.m_desc = this.m_gui.addInputFieldMultiLineNoWrap(agentDetails, DESC, "Description: ", this.m_ac.getDescription(), 3, 1, height, 60, 1, vIndent, this);
        this.m_desc.setTextLimit(1024);
        this.m_gui.setEditable(this.m_desc, this.m_isAuthorized);
        Composite compBtn2 = new Composite(agentDetails, 0);
        gridLayout = new GridLayout(6, true);
        gridLayout.marginWidth = 0;
        gridLayout.marginBottom = vIndent;
        compBtn2.setLayout((Layout)gridLayout);
        compBtn2.setLayoutData((Object)new GridData(1, 128, false, false, 3, 1));
        this.m_save = this.m_gui.addButton(compBtn2, SAVE, " &Save ", false, 80, 20, 2, this);
        GridData gridData = new GridData(4, 128, true, false, 1, 1);
        this.m_save.setLayoutData((Object)gridData);
        this.m_save.setImage(BMUI.IMAGE_SAVE);
        if (!this.m_ac.isExternal()) {
            this.m_redeploy = this.m_gui.addButton(compBtn2, REDEPLOY_AGENT, " Upgrade ", this.m_isAuthorized, 100, 20, 2, this);
            this.m_redeploy.setLayoutData((Object)gridData);
            this.m_gui.enableField(this.m_redeploy, this.m_ac.isApproved() && this.m_isAuthorized);
            this.m_restart = this.m_gui.addButton(compBtn2, RESTART, " Restart ", true, 80, 20, 2, this);
            this.m_restart.setLayoutData((Object)gridData);
            this.m_gui.enableField(this.m_restart, this.m_ac.isApproved() && this.m_isAuthorized);
            this.m_isApproved = this.m_gui.addButton(compBtn2, APPROVED, " Approve ", !this.m_ac.isApproved() && this.m_isAuthorized, 80, 20, 2, this);
            this.m_isApproved.setLayoutData((Object)gridData);
            Button runAction = this.m_gui.addButton(compBtn2, "RUNACTION", "Run Action...", Repository.getInstance().getRights(1002) >= 2 && Repository.getInstance().getRights(1007) >= 2, new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    com.blixx.shared.Action action = null;
                    String actionGrpName = null;
                    SelectActionDialog sad = new SelectActionDialog(AgentTab.this.m_parent.getShell(), " Select Action", ActionTreeFilter.DISPLAY_AGENT_ACTIONS);
                    int value = sad.open();
                    if (value == 0) {
                        action = sad.getAction();
                        actionGrpName = sad.getActionGrpName();
                        if (action != null && actionGrpName != null) {
                            Shell s = ManageDialogAction.isActionDialogOpen(action.m_ID);
                            if (s != null) {
                                s.setActive();
                            } else {
                                int rights = Repository.getInstance().getRights(actionGrpName);
                                RemoteActionDialog rad = new RemoteActionDialog("Run: " + action.m_label, action, true, rights, Repository.getInstance().getRights(1007) == 3);
                                ArrayList<String> filerList = new ArrayList<String>();
                                filerList.add(AgentTab.this.m_ac.getComparableName());
                                rad.setFilters(filerList, AgentTab.this.m_ac.getComparableName());
                                rad.open();
                            }
                        }
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            runAction.setImage(BMUI.IMAGE_ACTION);
        }
        this.m_delete = this.m_gui.addButton(compBtn2, DELETE, " Delete ", true, 80, 20, 2, this);
        this.m_delete.setLayoutData((Object)gridData);
        this.m_delete.setImage(this.m_sharedImages.getImage("IMG_TOOL_DELETE"));
        this.m_gui.enableField(this.m_delete, this.m_ac.isApproved() && this.m_isAuthorized);
        if (Repository.getInstance().getRights(2015) > 1) {
            this.createAgentCMSection(agentDetails);
        }
        if (!this.m_ac.isExternal()) {
            this.createInventorySection(agentDetails);
            this.createMonitorValuesSection(agentDetails);
            this.createMonitoredHostsSection(agentDetails);
        }
        this.m_form.setContent((Control)agentDetails);
        this.m_form.setMinSize(agentDetails.computeSize(-1, -1, true));
    }

    private void createInventorySection(final Composite agentDetails) {
        this.m_aci = this.m_ac.getInventoryCard(true);
        this.m_sectionInventory = BMUI.getFormToolkit(Display.getCurrent()).createSection(agentDetails, 514);
        this.m_sectionInventory.setLayoutData((Object)new GridData(4, 128, false, false, 3, 1));
        Composite sectionClient = BMUI.getFormToolkit(Display.getCurrent()).createComposite((Composite)this.m_sectionInventory, 66);
        GridLayout gl = new GridLayout(1, false);
        gl.horizontalSpacing = 0;
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        sectionClient.setLayout((Layout)gl);
        sectionClient.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        Composite comp = new Composite(sectionClient, 0);
        gl = new GridLayout(8, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        gl.horizontalSpacing = 2;
        comp.setLayout((Layout)gl);
        comp.setLayoutData((Object)new GridData(4, 4, false, false));
        this.m_discoveredInv = this.m_gui.addTextReadOnly(comp, "Discovered: ", this.m_aci.getTime(), 1, 1, 0, 0, BMUI.defaultBackground, null);
        ((GridData)this.m_discoveredInv.getLayoutData()).grabExcessHorizontalSpace = false;
        ((GridData)this.m_discoveredInv.getLayoutData()).widthHint = 100;
        this.m_versionInv = this.m_gui.addTextReadOnly(comp, "Ver: ", this.m_aci.getVersion(), 1, 1, 0, 0, BMUI.defaultBackground, null);
        ((GridData)this.m_versionInv.getLayoutData()).grabExcessHorizontalSpace = false;
        ((GridData)this.m_versionInv.getLayoutData()).widthHint = 30;
        String[] valueList = this.m_aci.getVersionHistory().split("\\s+");
        this.m_versionsInv = this.m_gui.addDropDown(comp, VERSION_HISTORY, null, valueList, valueList[0], "Version history", 1, 1, 0, 0, this);
        this.m_compareInv = this.m_gui.addButton(comp, COMPARE_BUTTON, COMPARE_BUTTON, true, 1, 1, 0, 0, this);
        this.m_refreshInv = this.m_gui.addButton(comp, REFRESH_INVENTORY, "Refresh", true, 1, 1, 0, 0, this);
        this.m_refreshInv.setImage(BMUI.IMAGE_REFRESH);
        this.m_triggerInv = this.m_gui.addButton(comp, TRIGGER_INVENTORY_BUTTON, "Trigger Inventory", Repository.getInstance().isPermittedAgentModify(this.m_ac), 1, 1, 0, 0, this);
        Composite treeComp = new Composite(sectionClient, 0);
        GridLayout gdLayout = new GridLayout(1, false);
        gdLayout.marginHeight = 0;
        gdLayout.marginWidth = 0;
        gdLayout.verticalSpacing = 0;
        treeComp.setLayout((Layout)gdLayout);
        treeComp.setLayoutData((Object)new GridData(4, 128, true, false));
        this.m_ACI = new STreeViewer(treeComp, 2820);
        GridData gd = new GridData(4, 128, true, false, 1, 1);
        gd.widthHint = 200;
        gd.heightHint = 200;
        this.m_ACI.getTree().setLayoutData((Object)gd);
        this.m_ACI.setContentProvider((IContentProvider)new ViewContentProvider());
        this.m_ACI.setLabelProvider((IBaseLabelProvider)new AgentInventoryLabelProvider(null));
        ViewerFilter vf = new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return !element.toString().startsWith("_");
            }
        };
        this.m_ACI.setFilters(new ViewerFilter[]{vf});
        this.m_ACI.setInput((Object)this.m_aci.getTree());
        this.m_sectionInventory.setText("Inventory Data");
        this.m_sectionInventory.setClient((Control)sectionClient);
        this.m_sectionInventory.setExpanded(false);
        this.m_sectionInventory.addExpansionListener(new IExpansionListener(){

            public void expansionStateChanged(ExpansionEvent e) {
                AgentTab.this.m_form.setContent((Control)agentDetails);
                AgentTab.this.m_form.setMinSize(agentDetails.computeSize(-1, -1, true));
            }

            public void expansionStateChanging(ExpansionEvent e) {
                AgentTab.this.m_ACI.expandAll();
            }
        });
        this.reloadInventory();
    }

    private void createAgentCMSection(final Composite agentDetails) {
        this.m_sectionAttributes = BMUI.getFormToolkit(Display.getCurrent()).createSection(agentDetails, 514);
        this.m_sectionAttributes.setLayoutData((Object)new GridData(4, 128, true, false, 3, 1));
        Composite sectionClient = BMUI.getFormToolkit(Display.getCurrent()).createComposite((Composite)this.m_sectionAttributes, 66);
        GridLayout gl = new GridLayout(1, false);
        gl.horizontalSpacing = 0;
        gl.marginWidth = 0;
        gl.marginLeft = 5;
        sectionClient.setLayout((Layout)gl);
        sectionClient.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite buttons = new Composite(sectionClient, 0);
        gl = new GridLayout(5, true);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        gl.marginBottom = 5;
        buttons.setLayout((Layout)gl);
        buttons.setLayoutData((Object)new GridData(16384, 4, false, false));
        this.m_refresgCM = this.m_gui.addButton(buttons, RELOAD_CM, "Reload", true, this);
        this.m_refresgCM.setLayoutData((Object)new GridData(4, 128, true, false));
        this.m_refresgCM.setImage(BMUI.IMAGE_REFRESH);
        this.m_saveCM = this.m_gui.addButton(buttons, SAVE_CM, "Save", false, this);
        this.m_saveCM.setLayoutData((Object)new GridData(4, 128, true, false));
        this.m_saveCM.setImage(BMUI.IMAGE_SAVE);
        Button addCM = this.m_gui.addButton(buttons, ADD_CM, "Add", this.m_isAuthorized, this);
        addCM.setLayoutData((Object)new GridData(4, 128, true, false));
        addCM.setImage(this.m_sharedImages.getImage("IMG_OBJ_ADD"));
        this.m_editCM = this.m_gui.addButton(buttons, EDIT_CM, "Edit", false, this);
        this.m_editCM.setLayoutData((Object)new GridData(4, 128, true, false));
        this.m_editCM.setImage(BMUI.IMAGE_EDIT);
        this.m_deleteCM = this.m_gui.addButton(buttons, DELETE_CM, "Delete", false, this);
        this.m_deleteCM.setLayoutData((Object)new GridData(4, 128, true, false));
        this.m_deleteCM.setImage(this.m_sharedImages.getImage("IMG_TOOL_DELETE"));
        this.m_deleteCM.setLayoutData((Object)new GridData(4, 128, true, false));
        Composite tableComp = new Composite(sectionClient, 0);
        gl = new GridLayout(1, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        gl.verticalSpacing = 0;
        gl.horizontalSpacing = 0;
        tableComp.setLayout((Layout)gl);
        tableComp.setLayoutData((Object)new GridData(4, 4, true, false));
        tableComp.layout(true);
        Table tbl = new Table(tableComp, 0x10010B00);
        tbl.setHeaderVisible(true);
        tbl.setLinesVisible(true);
        tbl.setLayout((Layout)gl);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.minimumHeight = 250;
        tbl.setLayoutData((Object)gridData);
        tbl.setBackground(BMUI.color_unknown);
        TableColumn col1 = new TableColumn(tbl, 131072);
        col1.setAlignment(16384);
        col1.setText("Type");
        col1.setWidth(0);
        TableColumn col2 = new TableColumn(tbl, 16384);
        col2.setAlignment(16384);
        col2.setText("Custom Attribute");
        col2.setWidth(160);
        TableColumn col3 = new TableColumn(tbl, 131072);
        col3.setAlignment(16384);
        col3.setText("Value");
        col3.setWidth(330);
        tbl.setSortColumn(col2);
        this.m_agentCM_tp = new AgentCMTableProvider(this.m_ac);
        this.m_agentCM_tv = new TableViewer(tbl);
        this.m_agentCM_tv.setSorter((ViewerSorter)new AttributeSorted());
        this.m_agentCM_tv.setContentProvider((IContentProvider)this.m_agentCM_tp);
        this.m_agentCM_tv.setLabelProvider((IBaseLabelProvider)this.m_agentCM_tp);
        this.m_agentCM_tv.setInput((Object)this.m_agentCM_tp.getElements(null));
        this.m_agentCM_tv.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (!AgentTab.this.m_isAuthorized) {
                    return;
                }
                Object o = event.getSource();
                if (o instanceof TableViewer) {
                    TableViewer tv = (TableViewer)o;
                    if (tv.getTable().getSelectionCount() == 1) {
                        AgentTab.this.m_gui.enableField(AgentTab.this.m_deleteCM, true);
                        AgentTab.this.m_gui.enableField(AgentTab.this.m_editCM, true);
                    } else {
                        AgentTab.this.m_gui.enableField(AgentTab.this.m_deleteCM, false);
                        AgentTab.this.m_gui.enableField(AgentTab.this.m_editCM, false);
                    }
                }
            }
        });
        this.m_agentCM_tv.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (!AgentTab.this.m_isAuthorized) {
                    return;
                }
                StructuredSelection ssel = (StructuredSelection)event.getSelection();
                Object o = ssel.getFirstElement();
                if (o instanceof Map.Entry) {
                    Map.Entry sel = (Map.Entry)ssel.getFirstElement();
                    String sel_attribute = (String)sel.getKey();
                    String sel_value = sel.getValue().toString();
                    AgentTab.this.modifyAgentCM(sel_attribute, sel_value);
                }
            }
        });
        this.m_sectionAttributes.setText("Attributes");
        this.m_sectionAttributes.setClient((Control)sectionClient);
        this.m_sectionAttributes.setExpanded(false);
        this.m_sectionAttributes.addExpansionListener(new IExpansionListener(){

            public void expansionStateChanged(ExpansionEvent e) {
                AgentTab.this.m_form.setContent((Control)agentDetails);
                AgentTab.this.m_form.setMinSize(agentDetails.computeSize(-1, -1, true));
            }

            public void expansionStateChanging(ExpansionEvent e) {
            }
        });
        this.reloadAgentCM();
    }

    private void createMonitoredHostsSection(final Composite agentDetails) {
        this.m_sectionMonitoredHosts = BMUI.getFormToolkit(Display.getCurrent()).createSection(agentDetails, 514);
        this.m_sectionMonitoredHosts.setLayoutData((Object)new GridData(4, 128, true, false, 6, 1));
        Composite sectionClient = BMUI.getFormToolkit(Display.getCurrent()).createComposite((Composite)this.m_sectionMonitoredHosts, 64);
        GridLayout gdLayout = new GridLayout(1, false);
        sectionClient.setLayout((Layout)gdLayout);
        sectionClient.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.createHostsTable(sectionClient);
        this.m_sectionMonitoredHosts.setText("Monitored Hosts");
        this.m_sectionMonitoredHosts.setClient((Control)sectionClient);
        this.m_sectionMonitoredHosts.setExpanded(false);
        this.m_sectionMonitoredHosts.addExpansionListener(new IExpansionListener(){

            public void expansionStateChanged(ExpansionEvent e) {
                AgentTab.this.m_form.setContent((Control)agentDetails);
                AgentTab.this.m_form.setMinSize(agentDetails.computeSize(-1, -1, true));
            }

            public void expansionStateChanging(ExpansionEvent e) {
            }
        });
    }

    public void createHostsTable(Composite parent) {
        Table tbl = new Table(parent, 268438274);
        tbl.setHeaderVisible(true);
        tbl.setLinesVisible(true);
        TableColumn col1 = new TableColumn(tbl, 16384);
        col1.setText("Monitored host");
        col1.setWidth(180);
        TableColumn col2 = new TableColumn(tbl, 131072);
        col2.setText("Unknown");
        col2.setImage(BMUI.IMAGE_UNKNOWN);
        col2.setWidth(30);
        TableColumn col3 = new TableColumn(tbl, 131072);
        col3.setText("Normal");
        col3.setImage(BMUI.IMAGE_NORMAL);
        col3.setWidth(30);
        TableColumn col4 = new TableColumn(tbl, 131072);
        col4.setText("Warning");
        col4.setImage(BMUI.IMAGE_WARNING);
        col4.setWidth(30);
        TableColumn col5 = new TableColumn(tbl, 131072);
        col5.setText("Major");
        col5.setImage(BMUI.IMAGE_MAJOR);
        col5.setWidth(30);
        TableColumn col6 = new TableColumn(tbl, 131072);
        col6.setText("Minor");
        col6.setImage(BMUI.IMAGE_MINOR);
        col6.setWidth(30);
        TableColumn col7 = new TableColumn(tbl, 131072);
        col7.setText("Critical");
        col7.setImage(BMUI.IMAGE_CRITICAL);
        col7.setWidth(30);
        this.m_hostsViewer = new TableViewer(tbl);
        this.m_hostsProvider = new HostsTableProvider(this.m_ac.getAgentHost(), new String[]{"Monitored host", "Unknown", "Normal", "Warning", "Minor", "Major", "Critical"});
        this.m_hostsViewer.setContentProvider((IContentProvider)this.m_hostsProvider);
        this.m_hostsViewer.setLabelProvider((IBaseLabelProvider)this.m_hostsProvider);
        this.m_hostsViewer.setInput((Object)this.m_hostsProvider.getElements(null));
        GridData gd = new GridData(4, 4, true, false, 1, 1);
        tbl.setLayoutData((Object)gd);
        tbl.setBackground(BMUI.color_unknown);
        Repository.getEventProvider().addTableToRefresh(this.m_hostsViewer);
        this.m_hostsViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (Repository.getInstance().getRights(1000) > 3) {
                    return;
                }
                ISelection iSelect = event.getViewer().getSelection();
                Map obj = (Map)((IStructuredSelection)iSelect).getFirstElement();
                if (obj != null) {
                    String hostname = "" + obj.get("Monitored host");
                    MessagesView.showMessagesForHost(hostname, "Host=" + hostname);
                }
            }
        });
        this.createContentMenuMonitoredHosts();
    }

    public void createContentMenuMonitoredHosts() {
        MenuManager menuMgr = new MenuManager("#PopupMenuMH");
        Menu menu = menuMgr.createContextMenu(this.m_hostsViewer.getControl());
        this.m_hostsViewer.getControl().setMenu(menu);
        this.site.registerContextMenu(menuMgr, (ISelectionProvider)this.m_hostsViewer);
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                Action action = new Action("Copy"){

                    public void run() {
                        Clipboard cb = new Clipboard(Display.getDefault());
                        ISelection selection = (this).AgentTab.this.m_hostsViewer.getSelection();
                        if (selection != null && selection instanceof IStructuredSelection) {
                            StringBuilder sb = new StringBuilder();
                            IStructuredSelection sel = (IStructuredSelection)selection;
                            for (Map map : sel) {
                                sb.append(map.get("Monitored host")).append('\n');
                            }
                            TextTransfer textTransfer = TextTransfer.getInstance();
                            cb.setContents(new Object[]{sb.toString()}, new Transfer[]{textTransfer});
                        }
                    }
                };
                action.setAccelerator(262211);
                ISharedImages sharedImages = null;
                try {
                    IWorkbenchWindow window = Activator.getDefault().getWorkbench().getActiveWorkbenchWindow();
                    sharedImages = window.getWorkbench().getSharedImages();
                }
                catch (Throwable throwable) {}
                if (sharedImages != null) {
                    action.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY"));
                    action.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY_DISABLED"));
                }
                manager.add((IAction)action);
            }
        });
    }

    public void createAssignmentTree(Composite parent) {
        try {
            this.m_treeViewer = new STreeViewer(parent, 268438274);
            this.m_treeViewer.setData(TREE_VIEWER_TYPE, (Object)AGENT_TAB);
            this.m_treeViewer.setContentProvider((IContentProvider)new ViewContentProvider());
            this.m_treeViewer.setUseHashlookup(true);
            this.m_treeViewer.setLabelProvider((IBaseLabelProvider)new AgentViewLabelProvider());
            if (this.m_ac.m_asn.numberOfElements() == 0) {
                this.m_ac.m_asn.addElement(new GroupTreeObject("Requesting data ...", ""));
            }
            this.m_treeViewer.setInput((Object)this.m_ac.m_asn);
            this.m_treeViewer.collapseAll();
            this.m_treeViewer.addDoubleClickListener(new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent event) {
                    ISelection iSelect = event.getViewer().getSelection();
                    Object obj = ((IStructuredSelection)iSelect).getFirstElement();
                    if (obj instanceof GroupTreeObject && !(obj instanceof GroupTreeObjectLast)) {
                        AgentTab.this.m_treeViewer.setExpandedState((Object)((GroupTreeObject)obj), !AgentTab.this.m_treeViewer.getExpandedState((Object)((GroupTreeObject)obj)));
                    } else if (obj instanceof GroupTreeObjectLast) {
                        GroupTreeObjectLast gtol = (GroupTreeObjectLast)obj;
                        String type = gtol.getType();
                        if (type.equals(BMUI.type_mon) || type.equals(BMUI.type_msg)) {
                            OpenPolicyAction action = new OpenPolicyAction(AgentTab.this.m_treeViewer, true);
                            action.run();
                        } else if (type.equals(BMUI.type_assignment_bin)) {
                            String gtol_name = gtol.getTreeObject().getObject().toString();
                            GroupTreeObject root_bin = Repository.getInstance().getBinaryTree();
                            GroupTreeObject gto_bin = root_bin.findFirstGroupByName(gtol_name);
                            if (gto_bin != null) {
                                SelectBinaryInTreeAction selectAction = new SelectBinaryInTreeAction(gtol_name);
                                selectAction.run();
                            }
                        }
                    }
                }
            });
            this.createContentMenu2();
            Repository.getInstance().addAgentAssignmentsViewer((Viewer)this.m_treeViewer);
        }
        catch (Throwable e) {
            RTLogger.print(5, "", e);
        }
    }

    public void createContentMenu2() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        Menu menu = menuMgr.createContextMenu(this.m_treeViewer.getControl());
        this.m_treeViewer.getControl().setMenu(menu);
        this.site.registerContextMenu(menuMgr, (ISelectionProvider)this.m_treeViewer);
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                try {
                    if (AgentTab.this.m_ac.isExternal()) {
                        return;
                    }
                    StructuredSelection ssel = (StructuredSelection)AgentTab.this.m_treeViewer.getSelection();
                    ScGetAssigned sc = new ScGetAssigned(Repository.getInstance(), AgentTab.this.m_ac.getAgentID());
                    sc.addCmdPostProcess(Repository.getInstance());
                    manager.add((IAction)new ServerClientAction2(sc, (Viewer)AgentTab.this.m_treeViewer, null, null));
                    manager.add((IAction)new SyncAgentsAction(new StructuredSelection((Object)AgentTab.this.m_ac)));
                    manager.add((IContributionItem)new Separator());
                    manager.add((IAction)new UndeployFromAll(AgentTab.this.m_ac.getAgentID()));
                    if (!ssel.isEmpty()) {
                        if (ssel.size() == 1) {
                            Object o = ssel.getFirstElement();
                            if (o instanceof GroupTreeObject && !(o instanceof GroupTreeObjectLast)) {
                                GroupTreeObject gto = (GroupTreeObject)o;
                                if (gto.getTreeObject().getType().equals(BMUI.type_assignment_pol)) {
                                    manager.add((IContributionItem)new Separator());
                                    manager.add((IAction)new SelectAssignmentInTreeAction(AgentTab.this.m_treeViewer));
                                }
                                if (gto.getTreeObject().getType().equals(BMUI.type_assignment_pol) || gto.getName().equalsIgnoreCase("Single deployed")) {
                                    manager.add((IContributionItem)new Separator());
                                    manager.add((IAction)new AssignToNodeAction((StructuredViewer)AgentTab.this.m_treeViewer, "DEPLOY", AgentTab.this.m_ac));
                                    manager.add((IAction)new AssignToNodeAction((StructuredViewer)AgentTab.this.m_treeViewer, "UNDEPLOY", AgentTab.this.m_ac));
                                    manager.add((IContributionItem)new Separator());
                                    manager.add((IAction)new AssignToNodeAction((StructuredViewer)AgentTab.this.m_treeViewer, "DEPLOY_DELAYED", AgentTab.this.m_ac));
                                    manager.add((IAction)new AssignToNodeAction((StructuredViewer)AgentTab.this.m_treeViewer, "UNDEPLOY_DELAYED", AgentTab.this.m_ac));
                                }
                            } else if (o instanceof GroupTreeObjectLast) {
                                String type;
                                String name;
                                GroupTreeObjectLast gtolOne = (GroupTreeObjectLast)o;
                                if (gtolOne.getTreeObject().getType().equals(BMUI.type_agt)) {
                                    return;
                                }
                                if (gtolOne.getName().indexOf("(DELETED)") != -1) {
                                    manager.add((IAction)new AssignToNodeAction((StructuredViewer)AgentTab.this.m_treeViewer, "UNDEPLOY", AgentTab.this.m_ac));
                                    manager.add((IContributionItem)new Separator());
                                    String name2 = gtolOne.getTreeObject().getObject().toString();
                                    String type2 = gtolOne.getType();
                                    if (type2.equals(BMUI.type_msg) || type2.equals(BMUI.type_mon)) {
                                        manager.add((IAction)new OpenPolicyAction(AgentTab.this.m_treeViewer, true));
                                        manager.add((IAction)new SelectPolicyInTreeAction(name2, type2));
                                        manager.add((IAction)new ShowRelatedPolicyInfosAction(name2, type2, AgentTab.this.m_parent.getShell()));
                                        manager.add((IAction)new ShowMessagesForSource(name2, type2, AgentTab.this.m_ac.getAgentID()));
                                    }
                                    manager.add((IContributionItem)new Separator());
                                    manager.add((IAction)new ExpandCollapseAction(AgentTab.this.m_treeViewer, "ExpandAll"));
                                    manager.add((IAction)new ExpandCollapseAction(AgentTab.this.m_treeViewer, "CollapseAll"));
                                    return;
                                }
                                if (gtolOne.getParent().getName().equalsIgnoreCase("Single deployed")) {
                                    manager.add((IAction)new AssignToNodeAction((StructuredViewer)AgentTab.this.m_treeViewer, "DEPLOY", AgentTab.this.m_ac));
                                    manager.add((IAction)new AssignToNodeAction((StructuredViewer)AgentTab.this.m_treeViewer, "UNDEPLOY", AgentTab.this.m_ac));
                                    manager.add((IContributionItem)new Separator());
                                    name = gtolOne.getTreeObject().getObject().toString();
                                    type = gtolOne.getType();
                                    if (type.equals(BMUI.type_msg) || type.equals(BMUI.type_mon)) {
                                        manager.add((IAction)new OpenPolicyAction(AgentTab.this.m_treeViewer, true));
                                        manager.add((IAction)new SelectPolicyInTreeAction(name, type));
                                        manager.add((IAction)new ShowRelatedPolicyInfosAction(name, type, AgentTab.this.m_parent.getShell()));
                                        manager.add((IAction)new ShowMessagesForSource(name, type, AgentTab.this.m_ac.getAgentID()));
                                    } else if (type.equals(BMUI.type_assignment_bin)) {
                                        manager.add((IAction)new SelectBinaryInTreeAction(name));
                                    }
                                } else {
                                    name = gtolOne.getTreeObject().getObject().toString();
                                    type = gtolOne.getType();
                                    if (type.equals(BMUI.type_msg) || type.equals(BMUI.type_mon)) {
                                        manager.add((IAction)new OpenPolicyAction(AgentTab.this.m_treeViewer, true));
                                        manager.add((IAction)new SelectPolicyInTreeAction(name, type));
                                        manager.add((IAction)new ShowRelatedPolicyInfosAction(name, type, AgentTab.this.m_parent.getShell()));
                                        manager.add((IAction)new ShowMessagesForSource(name, type, AgentTab.this.m_ac.getAgentID()));
                                    } else if (type.equals(BMUI.type_assignment_bin)) {
                                        manager.add((IAction)new SelectBinaryInTreeAction(name));
                                    }
                                }
                            }
                        } else if (ssel.size() > 1) {
                            GroupTreeObjectLast gtol;
                            Object o2;
                            boolean flagElement = true;
                            boolean flagFolder = true;
                            for (Object o2 : ssel) {
                                if (o2 instanceof GroupTreeObject && !(o2 instanceof GroupTreeObjectLast)) {
                                    flagElement = false;
                                    GroupTreeObject gto = (GroupTreeObject)o2;
                                    if (gto.getTreeObject().getType().equals(BMUI.type_assignment_pol) || gto.getName().equalsIgnoreCase("Single deployed")) continue;
                                    flagFolder = false;
                                    continue;
                                }
                                if (!(o2 instanceof GroupTreeObjectLast)) continue;
                                flagFolder = false;
                                gtol = (GroupTreeObjectLast)o2;
                                if (gtol.getParent().getName().equalsIgnoreCase("Single deployed")) continue;
                                flagElement = false;
                            }
                            if (flagFolder || flagElement) {
                                manager.add((IAction)new AssignToNodeAction((StructuredViewer)AgentTab.this.m_treeViewer, "DEPLOY", AgentTab.this.m_ac));
                                manager.add((IAction)new AssignToNodeAction((StructuredViewer)AgentTab.this.m_treeViewer, "UNDEPLOY", AgentTab.this.m_ac));
                            }
                            if ((o2 = ssel.getFirstElement()) instanceof GroupTreeObjectLast && ((gtol = (GroupTreeObjectLast)o2).getType().equals(BMUI.type_msg) || gtol.getType().equals(BMUI.type_mon))) {
                                manager.add((IContributionItem)new Separator());
                                manager.add((IAction)new OpenPolicyAction(AgentTab.this.m_treeViewer, true));
                            }
                        }
                    }
                    manager.add((IContributionItem)new Separator());
                    LinkedList<String> pol = new LinkedList<String>();
                    for (Object object : ssel) {
                        if (object instanceof GroupTreeObjectLast) {
                            GroupTreeObjectLast gtol = (GroupTreeObjectLast)object;
                            this.addIfPolicy(pol, gtol);
                            continue;
                        }
                        if (!(object instanceof GroupTreeObject)) continue;
                        GroupTreeObject gto = (GroupTreeObject)object;
                        List<GroupTreeObjectLast> els = GroupTreeObject.collectElements(gto);
                        for (GroupTreeObjectLast gtol : els) {
                            this.addIfPolicy(pol, gtol);
                        }
                    }
                    manager.add((IAction)new EnableDisablePolicies(AgentTab.this.m_ac, true, pol));
                    manager.add((IAction)new EnableDisablePolicies(AgentTab.this.m_ac, false, pol));
                    manager.add((IContributionItem)new Separator());
                    manager.add((IAction)new ExpandCollapseAction(AgentTab.this.m_treeViewer, "ExpandAll"));
                    manager.add((IAction)new ExpandCollapseAction(AgentTab.this.m_treeViewer, "CollapseAll"));
                }
                catch (RuntimeException e) {
                    RTLogger.print(5, "Error creating content menu ", e);
                }
            }

            private void addIfPolicy(LinkedList<String> pol, GroupTreeObjectLast gtol) {
                try {
                    String name = gtol.getTreeObject().getObject().toString();
                    String type = gtol.getType();
                    if (type.equals(BMUI.type_msg) || type.equals(BMUI.type_mon)) {
                        pol.add(name);
                    }
                }
                catch (Throwable e) {
                    RTLogger.print(5, "", e);
                }
            }
        });
    }

    public void udpateFields(AgentCard ac) {
        try {
            this.m_agentID.setText(ac.getAgentID());
            this.m_hostIP.setText(ac.getAgentIP());
            if (this.m_isFirewalled != null) {
                this.m_isFirewalled.setSelection(ac.isFirewalled());
                this.m_gui.enableField(this.m_isFirewalled, this.m_isAuthorized);
            }
            if (this.m_isApproved != null) {
                this.m_gui.enableField(this.m_isApproved, !ac.isApproved() && this.m_isAuthorized);
            }
            if (this.m_isDisabled != null) {
                this.m_isDisabled.setSelection(ac.isDisabled());
                this.m_gui.enableField(this.m_isDisabled, this.m_isAuthorized);
            }
            if (this.m_isTls != null) {
                this.m_isTls.setSelection(ac.isTlsAgent());
                this.m_gui.enableField(this.m_isTls, this.m_isAuthorized);
            }
            this.m_port.setText("" + ac.getAgentPort());
            this.m_hostname.setText(ac.getAgentHost());
            this.m_label.setText(ac.getLabel());
            this.m_gui.setEditable(this.m_label, this.m_isAuthorized);
            this.m_os.setText(ac.getOSNameOnly());
            this.m_desc.setText(ac.getDescription());
            this.m_gui.setEditable(this.m_desc, this.m_isAuthorized);
            this.m_gui.enableField(this.m_delete, ac.isApproved() && this.m_isAuthorized);
            this.m_gui.enableField(this.m_save, false);
            this.m_gui.enableField(this.m_restart, ac.isApproved() && this.m_isAuthorized);
            this.m_gui.enableField(this.m_redeploy, ac.isApproved() && this.m_isAuthorized);
            this.setText("" + ac);
            this.m_agentCM_tv.refresh();
        }
        catch (Throwable e) {
            RTLogger.print(5, "", e);
        }
    }

    public void udpateAgentInventoryCard(AgentInventoryCard aci) {
        this.m_discoveredInv.setText(this.m_aci.getTime());
        this.m_versionInv.setText(this.m_aci.getVersion());
        String versionHistory = this.m_aci.getVersionHistory();
        if (versionHistory.length() > 1) {
            String[] val = versionHistory.split("\\s+");
            this.m_versionsInv.setItems(val);
            this.m_versionsInv.setEnabled(true);
        } else {
            this.m_versionsInv.setEnabled(false);
        }
        this.m_ACI.setInput((Object)this.m_aci.getTree());
        this.m_ACI.expandAll();
    }

    public void modifyAgentCM(String attribute, String value) {
        try {
            AgentCardCM acm = new AgentCardCM(this.m_ac.getID());
            acm.add(attribute, value);
            AgentCMAddAttributeDialog dialog = new AgentCMAddAttributeDialog(Display.getCurrent().getActiveShell(), this.m_ac, this.m_agentCM_tp, attribute, value);
            dialog.setBlockOnOpen(true);
            int ret = dialog.open();
            if (ret == 0) {
                String attribute_modified = dialog.get_dataType();
                Object value_modified = dialog.getValue();
                this.m_agentCM_tp.modifyACM(attribute_modified, value_modified);
                this.refreshAgentCM_table();
                this.m_gui.enableField(this.m_saveCM, true);
            }
        }
        catch (Exception e1) {
            RTLogger.print(3, "", e1);
        }
    }

    public void enableApproveButton(boolean b) {
        this.m_gui.enableField(this.m_isApproved, b);
    }

    public void setDirty(boolean b) {
        this.m_isDirty = b;
        if (this.m_save != null) {
            this.m_gui.enableField(this.m_save, this.m_isAuthorized && b);
        }
        if (!this.getText().startsWith("*") && b) {
            this.setText("* " + this.getText());
        } else if (this.getText().startsWith("*") && !b) {
            this.setText("" + this.m_ac);
        }
    }

    public boolean isDirty() {
        return this.m_isDirty;
    }

    public void saveAgentDetails() {
        AgentCard tempAC = null;
        if (this.m_isDirty) {
            tempAC = new AgentCard();
            try {
                ByteArrayOutputStream buff = new ByteArrayOutputStream();
                this.m_ac.send(new SDataOutputStream(buff, ServerClient.getDetectedServerProtocolVersion()));
                tempAC.read(new SDataInputStream(new ByteArrayInputStream(buff.toByteArray())));
            }
            catch (Throwable throwable) {}
            if (this.m_isFirewalled != null) {
                if (this.m_isFirewalled.getSelection()) {
                    tempAC.setMode(7);
                } else {
                    tempAC.setMode(0);
                }
            }
            this.m_oldACName = tempAC.toString();
            if (this.m_isDisabled != null) {
                tempAC.setDisabled(this.m_isDisabled.getSelection());
            }
            if (this.m_isTls != null) {
                if (this.m_isTls.getSelection()) {
                    tempAC.setSingleFlagON(64);
                } else {
                    tempAC.setSingleFlagOFF(64);
                }
            }
            tempAC.setDescription(this.m_desc.getText());
            tempAC.setLabel(this.m_label.getText());
            if (tempAC.isExternal()) {
                tempAC.setHost(this.m_hostname.getText());
                tempAC.setIP(this.m_hostIP.getText());
            } else {
                try {
                    tempAC.setAgentPort(Integer.parseInt(this.m_port.getText()));
                }
                catch (Throwable throwable) {}
            }
        }
        try {
            ScPutAgent sc = new ScPutAgent((IServerAuth)Repository.getInstance(), new AbstractAgentCard[]{tempAC});
            sc.run();
            if (sc.isSuccess()) {
                this.m_treeViewer.refresh(true);
                this.setDirty(false);
                if (tempAC != null) {
                    this.m_ac.updateFrom(tempAC);
                }
                this.m_ac.resetPreparedToString();
                if (this.getText().equals(this.m_oldACName) && !this.getText().equals(this.m_ac.toString())) {
                    this.setText(this.m_ac.toString());
                }
                RTLogger.print(5, "Saved AC: " + this.m_ac.getAgentID());
            } else {
                new ShowMessageBox("Error", sc.getResultObject(), 1);
                RTLogger.print(5, "Error saving AC:" + this.m_ac.getAgentID());
            }
        }
        catch (RuntimeException e1) {
            RTLogger.print(5, "Error saving AC:" + this.m_ac.getAgentID(), e1);
        }
    }

    public void saveAgentCM() {
        AgentCardCM acm = this.m_ac.getAgentCardCM();
        Map<String, Object> acms_newAndModified = this.m_agentCM_tp.getACMs();
        Iterator<String> it = acms_newAndModified.keySet().iterator();
        acm.getValues().clear();
        while (it.hasNext()) {
            String key = it.next();
            Object value = acms_newAndModified.get(key);
            try {
                acm.add(key, value);
            }
            catch (Exception exception) {}
        }
        HashMap<String, AgentCardCM> m = new HashMap<String, AgentCardCM>(1);
        m.put(this.m_ac.getAgentID(), acm);
        ScPutAgentsCM scpcm = new ScPutAgentsCM(Repository.getInstance(), m);
        Repository.getJobManager().schedule(scpcm);
        this.m_gui.enableField(this.m_saveCM, false);
    }

    public void reloadAgentCM() {
        ScGetAgentsCM sccm = new ScGetAgentsCM((IServerAuth)Repository.getInstance(), this.m_ac.getAgentID());
        sccm.addCmdPostProcess(Repository.getInstance());
        sccm.addCmdPostProcess(new ICmdPostProcess<ScGetAgentsCM>(){

            @Override
            public void postProcess(ScGetAgentsCM sc) {
                UIJob uij = new UIJob(AgentTab.RELOAD_CM){

                    @Override
                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        Object[] elements = AgentTab.this.m_agentCM_tp.getElements(AgentTab.this.m_ac);
                        if (elements != null && elements.length > 0) {
                            AgentTab.this.m_sectionAttributes.setText("Attributes (" + elements.length + ")");
                        } else {
                            AgentTab.this.m_sectionAttributes.setText("Attributes");
                        }
                        AgentTab.this.m_sectionAttributes.layout();
                        AgentTab.this.m_agentCM_tv.setInput((Object)elements);
                        AgentTab.this.m_gui.enableField(AgentTab.this.m_saveCM, false);
                        AgentTab.this.m_gui.enableField(AgentTab.this.m_refresgCM, true);
                        return Status.OK_STATUS;
                    }
                };
                UIJobManager.getInstance().schedule(uij);
            }
        });
        Repository.getJobManager().schedule(sccm);
        this.m_gui.enableField(this.m_refresgCM, false);
    }

    public static void showMessagesForSource(String policyName, String filterName, String agentID) {
        AgentCardView.getInstance().getSite();
        EventFilter ef = new EventFilter(null, "Source", filterName, false, 1, AgentTab.m_msgBrowerTab.tableViewer, false, 0, 0);
        List<EventFilter> filters = ViewFilterAction.getFilters(AgentTab.m_msgBrowerTab.tableViewer);
        Iterator<EventFilter> it = filters.iterator();
        while (it.hasNext()) {
            EventFilter ev = it.next();
            if (ev.m_pattern.equals(agentID)) continue;
            it.remove();
        }
        ViewFilterAction.addFilter((Object)m_msgBrowerTab, AgentTab.m_msgBrowerTab.tableViewer, ef);
        m_msgBrowerTab.setText("Source (" + policyName + ")");
    }

    public void modifyText(ModifyEvent e) {
        Object obj = e.getSource();
        if (obj instanceof Text) {
            Text text = (Text)obj;
            String name = (String)text.getData();
            if (DESC.equals(name)) {
                this.setDirty(true);
            } else if (LABEL.equals(name)) {
                this.setDirty(true);
            } else if (PORT.equals(name)) {
                this.setDirty(true);
            } else if (HOST.equals(name)) {
                this.setDirty(true);
            } else if (IP.equals(name)) {
                this.setDirty(true);
            }
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        Object obj = e.getSource();
        if (obj instanceof Button) {
            Button b = (Button)obj;
            String name = (String)b.getData();
            if (APPROVED.equals(name)) {
                this.m_gui.enableField(this.m_isApproved, false);
                ArrayList<AgentCard> list = new ArrayList<AgentCard>(1);
                list.add(this.m_ac);
                ApproveAgentAction action = new ApproveAgentAction(list);
                action.run();
            } else if (DELETE.equals(name)) {
                DeleteAgentAction delete = new DeleteAgentAction(null, this.m_ac, this);
                delete.run();
            } else if (SAVE.equals(name)) {
                this.saveAgentDetails();
            } else if (RESTART.equals(name)) {
                ArrayList<AgentCard> ac1 = new ArrayList<AgentCard>(1);
                ac1.add(this.m_ac);
                RestartAgentAction restart = new RestartAgentAction(ac1);
                restart.run();
            } else if (REDEPLOY_AGENT.equals(name)) {
                RedeployAgentAction redeploy = new RedeployAgentAction(null, this.m_ac);
                redeploy.run();
            } else if (DISABLED_CHECKBOX.equals(name)) {
                this.setDirty(true);
            } else if (FIREWALL.equals(name)) {
                this.setDirty(true);
            } else if (TLS.equals(name)) {
                this.setDirty(true);
            } else if (TRIGGER_INVENTORY_BUTTON.equals(name)) {
                TriggerInventoryAction triggerAction = new TriggerInventoryAction(this.m_ac);
                triggerAction.run();
            } else if (REFRESH_INVENTORY.equals(name)) {
                this.reloadInventory();
            } else if (COMPARE_BUTTON.equals(name)) {
                ServerClient sc = null;
                sc = this.m_ac.getRelatedServer() != null ? ServerClient.getFileSlave(new String[]{"srv/inventory/" + this.m_aci.getID() + "." + this.m_versionsInv.getText(), BMUI.type_file, this.m_ac.getRelatedServer(), String.valueOf(Repository.getUserTmpDirectory()) + "/inventory"}) : ServerClient.getFile(new String[]{"srv/inventory/" + this.m_aci.getID() + "." + this.m_versionsInv.getText(), BMUI.type_file, String.valueOf(Repository.getUserTmpDirectory()) + "/inventory"});
                sc.runInUIThread(null);
                if (sc.isSuccess()) {
                    File version = (File)sc.getResultObject();
                    File dir = new File(String.valueOf(Repository.getUserTmpDirectory()) + "/inventory");
                    this.m_aci.saveSDIS(dir);
                    File orig = new File(dir, this.m_aci.getID());
                    FileCompareTab compare = new FileCompareTab(Display.getCurrent().getActiveShell(), orig, version, String.valueOf(this.m_ac.toString()) + " v" + this.m_aci.getAttribute(AgentInventoryCard.getPath("_VERSION")), "v" + this.m_versionsInv.getText(), true);
                    compare.open();
                } else {
                    new ShowMessageBox("Error", "Error getting version from the server.", 1);
                }
            } else if (RELOAD_CM.equals(name)) {
                this.reloadAgentCM();
            } else if (SAVE_CM.equals(name)) {
                this.saveAgentCM();
            } else if (ADD_CM.equals(name)) {
                this.addAgentCMAttribute();
            } else if (EDIT_CM.equals(name)) {
                this.editAgentCMAttribute();
            } else if (DELETE_CM.equals(name)) {
                this.deleteAgentCMAttribute();
            } else if (REFRESH_MON_SERIES.equals(name)) {
                this.requestMonitorSeries();
            }
        }
    }

    private void reloadInventory() {
        ScGetAgentInventoryCard sc = new ScGetAgentInventoryCard(Repository.getInstance(), this.m_aci.getID());
        sc.addCmdPostProcess(new ICmdPostProcess<ScGetAgentInventoryCard>(){

            @Override
            public void postProcess(ScGetAgentInventoryCard sca) {
                if (sca.isSuccess()) {
                    AgentInventoryCard resultObject = sca.getResultObject();
                    Repository.getInstance().updateOpenAgentCardInventory(resultObject);
                } else {
                    UIJob uj = new UIJob("ErrorGettingInventory"){

                        @Override
                        public IStatus runInUIThread(IProgressMonitor monitor) {
                            new ShowMessageBox("Error", "Error getting inventory from the server.", 1);
                            return Status.OK_STATUS;
                        }
                    };
                    Repository.getUIJobManager().schedule(uj);
                }
            }
        });
        sc.start();
    }

    private void deleteAgentCMAttribute() {
        Object o;
        StructuredSelection ssel = (StructuredSelection)this.m_agentCM_tv.getSelection();
        if (!ssel.isEmpty() && (o = ssel.getFirstElement()) instanceof Map.Entry) {
            Map.Entry sel = (Map.Entry)ssel.getFirstElement();
            String attribute = (String)sel.getKey();
            this.m_agentCM_tp.removeACM(attribute);
            this.refreshAgentCM_table();
            this.m_gui.enableField(this.m_saveCM, true);
        }
    }

    private void editAgentCMAttribute() {
        Object o;
        StructuredSelection ssel = (StructuredSelection)this.m_agentCM_tv.getSelection();
        if (!ssel.isEmpty() && (o = ssel.getFirstElement()) instanceof Map.Entry) {
            Map.Entry sel = (Map.Entry)ssel.getFirstElement();
            String sel_attribute = (String)sel.getKey();
            String sel_value = sel.getValue().toString();
            this.modifyAgentCM(sel_attribute, sel_value);
        }
    }

    private void addAgentCMAttribute() {
        AgentCMAddAttributeDialog dialog = new AgentCMAddAttributeDialog(Display.getCurrent().getActiveShell(), this.m_ac, this.m_agentCM_tp, null, null);
        dialog.setBlockOnOpen(true);
        int ret = dialog.open();
        if (ret == 0) {
            String attribute = dialog.get_dataType();
            Object value = dialog.getValue();
            try {
                this.m_agentCM_tp.addACM(attribute, value);
                this.refreshAgentCM_table();
                this.m_gui.enableField(this.m_saveCM, true);
            }
            catch (Exception e1) {
                RTLogger.print(3, "", e1);
            }
        }
    }

    private void requestMonitorSeries() {
        this.m_monitorSeriesError = REQUEST_MONITOR_SERIES;
        this.m_monitorSeriesStatus.setText(this.m_monitorSeriesError);
        this.m_monitorSeriesStatus.getParent().layout();
        this.m_refreshMonSeries.setEnabled(false);
        String uuid = UUID.randomUUID().toString();
        ScRemoteAction sc = new ScRemoteAction(Repository.getInstance(), uuid, "BOOM_AGENT GET_MONITOR_HISTORY", this.m_ac.getAgentID(), 120);
        sc.addCmdPostProcess(new ICmdPostProcess<ScRemoteAction>(){

            @Override
            public void postProcess(ScRemoteAction cmd) {
                if (cmd.isSuccess()) {
                    try {
                        GsonBuilder builder = new GsonBuilder();
                        Gson gson = builder.create();
                        String[] array = cmd.getResultObject().split("\\r*\\n");
                        StringBuilder sb = new StringBuilder();
                        String[] stringArray = array;
                        int n = array.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String s = stringArray[n2];
                            if (s != null && !s.startsWith("===") && !s.startsWith("Result = Success")) {
                                if (sb.length() > 0) {
                                    sb.append('\n');
                                }
                                sb.append(s);
                            }
                            if (s.startsWith("Result = FAILED")) {
                                if (!AgentTab.this.m_ac.isOnline()) {
                                    throw new Exception("Agent is offline");
                                }
                                throw new UnsupportedTypeException();
                            }
                            ++n2;
                        }
                        JsonElement aaa = gson.fromJson(sb.toString(), JsonElement.class);
                        JsonArray arr = aaa.getAsJsonArray();
                        ArrayList<MonitorSerie> msList = new ArrayList<MonitorSerie>(arr.size());
                        Iterator<JsonElement> it = arr.iterator();
                        while (it.hasNext()) {
                            MonitorSerie ms = MonitorSerie.create(it.next());
                            msList.add(ms);
                        }
                        AgentTab.this.m_monitorSeries.clear();
                        AgentTab.this.m_monitorSeries.addAll(msList);
                        Collections.sort(AgentTab.this.m_monitorSeries, new Comparator<MonitorSerie>(){

                            @Override
                            public int compare(MonitorSerie o1, MonitorSerie o2) {
                                return o1 == null ? 0 : o1.getKey().compareToIgnoreCase(o2.getKey());
                            }
                        });
                        AgentTab.this.m_monitorSeriesError = "";
                    }
                    catch (UnsupportedTypeException unsupportedTypeException) {
                        AgentTab.this.m_monitorSeriesError = "The Agent does not supports this feature! Please update the Agent to the latest version.";
                    }
                    catch (Throwable e) {
                        RTLogger.print(4, "Error getting Monitor series from Agent: " + AgentTab.this.m_ac, e);
                        AgentTab.this.m_monitorSeriesError = AgentTab.ERROR_REQUESTING_MONITOR_VALUES_FROM_THE_AGENT;
                    }
                } else {
                    RTLogger.print(4, "Error getting Monitor series from Agent: " + AgentTab.this.m_ac + ". " + cmd.getResultObject());
                    AgentTab.this.m_monitorSeriesError = AgentTab.ERROR_REQUESTING_MONITOR_VALUES_FROM_THE_AGENT;
                }
                UIJob job = new UIJob("RefreshMonitorSeries"){

                    @Override
                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        AgentTab.this.m_monitorSeriesStatus.setText(AgentTab.this.m_monitorSeriesError);
                        AgentTab.this.m_monitorSeriesViewer.setInput((Object)AgentTab.this.m_monitorSeries);
                        AgentTab.this.m_monitorSeriesViewer.refresh();
                        AgentTab.this.m_refreshMonSeries.setEnabled(true);
                        AgentTab.this.m_monitorSeriesStatus.getParent().layout();
                        if (AgentTab.this.m_monitorSeries.size() > 0) {
                            AgentTab.this.m_sectionLastMonitorValues.setText("Last Monitor values (" + AgentTab.this.m_monitorSeries.size() + ")");
                            AgentTab.this.m_sectionLastMonitorValues.layout();
                        } else {
                            AgentTab.this.m_sectionLastMonitorValues.setText("Last Monitor values");
                            AgentTab.this.m_sectionLastMonitorValues.layout();
                        }
                        return null;
                    }
                };
                UIJobManager.getInstance().schedule(job);
            }
        });
        sc.start();
    }

    public void refreshAgentCM_table() {
        this.m_agentCM_tv.setInput((Object)this.m_agentCM_tp.getElements(null));
        this.m_agentCM_tv.refresh();
    }

    public AgentCard getAgentCard() {
        return this.m_ac;
    }

    @Override
    public Color getBackground(Object element) {
        if (element != null && element instanceof GroupTreeObjectLast) {
            GroupTreeObjectLast gtol = (GroupTreeObjectLast)element;
            if (gtol.getName().endsWith("(OK)")) {
                return BMUI.color_light_green;
            }
            if (gtol.getName().endsWith("(X)")) {
                return BMUI.color_light_red;
            }
            if (gtol.getName().endsWith("(!)")) {
                return BMUI.color_light_yellow;
            }
        }
        return null;
    }

    @Override
    public Color getForeground(Object element) {
        return null;
    }

    public void dispose() {
        super.dispose();
        try {
            this.m_comp_mainArea.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_sash.dispose();
        }
        catch (Throwable throwable) {}
    }

    private void createMonitorValuesSection(final Composite agentDetails) {
        this.m_sectionLastMonitorValues = BMUI.getFormToolkit(Display.getCurrent()).createSection(agentDetails, 514);
        this.m_sectionLastMonitorValues.setLayoutData((Object)new GridData(4, 128, true, false, 6, 1));
        Composite sectionClient = BMUI.getFormToolkit(Display.getCurrent()).createComposite((Composite)this.m_sectionLastMonitorValues, 66);
        GridLayout gdLayout = new GridLayout(2, false);
        sectionClient.setLayout((Layout)gdLayout);
        sectionClient.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.m_refreshMonSeries = this.m_gui.addButton(sectionClient, REFRESH_MON_SERIES, " Refresh ", true, this);
        this.m_refreshMonSeries.setImage(BMUI.IMAGE_REFRESH);
        this.m_monitorSeriesStatus = new Label(sectionClient, 4);
        this.m_monitorSeriesStatus.setText(this.m_monitorSeriesError);
        this.createMonitorsTable(sectionClient);
        this.m_sectionLastMonitorValues.setText("Last Monitor values");
        this.m_sectionLastMonitorValues.setClient((Control)sectionClient);
        this.m_sectionLastMonitorValues.setExpanded(false);
        this.m_sectionLastMonitorValues.addExpansionListener(new IExpansionListener(){

            public void expansionStateChanged(ExpansionEvent e) {
                AgentTab.this.m_form.setContent((Control)agentDetails);
                AgentTab.this.m_form.setMinSize(agentDetails.computeSize(-1, -1, true));
            }

            public void expansionStateChanging(ExpansionEvent e) {
            }
        });
    }

    public void createMonitorsTable(Composite parent) {
        Table tbl = new Table(parent, 268438274);
        tbl.setHeaderVisible(true);
        tbl.setLinesVisible(true);
        TableColumn col1 = new TableColumn(tbl, 16384);
        col1.setText("Monitor Policy");
        col1.setImage(BMUI.IMAGE_MON);
        col1.setWidth(180);
        TableColumn col2 = new TableColumn(tbl, 16384);
        col2.setText("Object");
        col2.setWidth(180);
        TableColumn col3 = new TableColumn(tbl, 16384);
        col3.setText("Host");
        col3.setWidth(50);
        TableColumn col4 = new TableColumn(tbl, 16384);
        col4.setText("Value");
        col4.setWidth(50);
        TableColumn col5 = new TableColumn(tbl, 16384);
        col5.setText("Last time");
        col5.setWidth(120);
        this.m_monitorSeriesViewer = new TableViewer(tbl);
        MonitorTableProvider mt = new MonitorTableProvider();
        this.m_monitorSeriesViewer.setContentProvider((IContentProvider)mt);
        this.m_monitorSeriesViewer.setLabelProvider((IBaseLabelProvider)mt);
        this.m_monitorSeriesViewer.setInput(this.m_monitorSeries);
        GridData gd = new GridData(4, 4, true, false, 2, 1);
        tbl.setLayoutData((Object)gd);
        tbl.setBackground(BMUI.color_white);
        Repository.getEventProvider().addTableToRefresh(this.m_monitorSeriesViewer);
        this.requestMonitorSeries();
    }

    public class AttributeSorted
    extends ViewerSorter
    implements Comparator<Object> {
        public int compare(Viewer viewer, Object e1, Object e2) {
            if (e1 instanceof Map.Entry && e2 instanceof Map.Entry) {
                return this.compare((Map.Entry)e1, (Map.Entry)e2);
            }
            return super.compare(viewer, e1, e2);
        }

        public void sort(Viewer viewer, Object[] elements) {
            if (elements != null && elements.length > 0) {
                Arrays.sort(elements, this);
            }
        }

        @Override
        public int compare(Object o1, Object o2) {
            String s1 = "";
            String s2 = "";
            if (o1 instanceof Map.Entry && o2 instanceof Map.Entry) {
                Map.Entry e1 = (Map.Entry)o1;
                Map.Entry e2 = (Map.Entry)o2;
                s1 = Repository.getInstance().getAgentCMLabel("" + e1.getKey());
                s2 = Repository.getInstance().getAgentCMLabel("" + e2.getKey());
            } else {
                s1 = "" + o1;
                s2 = "" + o2;
            }
            return s1.compareToIgnoreCase(s2);
        }
    }

    public class MonitorTableProvider
    implements IStructuredContentProvider,
    ITableLabelProvider {
        private List<MonitorSerie> data = null;

        public void addListener(ILabelProviderListener arg0) {
        }

        public void dispose() {
        }

        public Image getColumnImage(Object arg0, int arg1) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof MonitorSerie) {
                MonitorSerie ms = (MonitorSerie)element;
                switch (columnIndex) {
                    case 0: {
                        return ms.getPolicyName();
                    }
                    case 1: {
                        return ms.getObject();
                    }
                    case 2: {
                        return ms.getHost();
                    }
                    case 3: {
                        if (ms.getLatestValue() == null) {
                            return "-";
                        }
                        String dblStr = String.format("%4.3f", ms.getLatestValue().getValue());
                        if (dblStr.endsWith(".000")) {
                            dblStr = dblStr.substring(0, dblStr.length() - 4);
                        }
                        return dblStr;
                    }
                    case 4: {
                        if (ms.getLatestValue() == null) {
                            return "-";
                        }
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        return sdf.format(new Date(ms.getLatestValue().getTime()));
                    }
                }
            }
            return null;
        }

        public Object[] getElements(Object arg0) {
            return this.data == null ? new Object[]{} : this.data.toArray();
        }

        public void inputChanged(Viewer arg0, Object arg1, Object arg2) {
            this.data = (List)arg2;
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

