/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views;

import com.blixx.boom.engine.BMUI;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.GroupTreeObjectLast;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;

class AgentViewLabelProvider
extends StyledCellLabelProvider {
    public static final String DISABLED = "(!DISABLED!)";

    public void update(ViewerCell cell) {
        StyledString styledString = null;
        String decoration = "";
        Object element = cell.getElement();
        if (element instanceof GroupTreeObjectLast) {
            String regex = null;
            String suffix = null;
            String pattern = "  ({0})";
            RGB rgb = null;
            GroupTreeObjectLast gtol = (GroupTreeObjectLast)element;
            cell.setBackground(null);
            if (gtol.getName().contains("(DELETED)")) {
                regex = "\\(DELETED\\)";
                suffix = "DELETED";
                rgb = BMUI.color_critical.getRGB();
                cell.setBackground(BMUI.color_light_red);
            } else if (gtol.getName().endsWith("(OK)")) {
                regex = "\\(OK\\)";
                suffix = "ok";
                pattern = "  {0}";
                rgb = BMUI.color_green.getRGB();
            } else if (gtol.getName().endsWith("(X)")) {
                regex = "\\(X\\)";
                suffix = "X";
                rgb = BMUI.color_critical.getRGB();
            } else if (gtol.getName().endsWith("(!)")) {
                regex = "\\(!\\)";
                suffix = "!";
                rgb = BMUI.color_critical.getRGB();
                cell.setBackground(BMUI.color_minor);
            } else if (gtol.getName().endsWith("(expected by server)")) {
                regex = "\\(expected by server\\)";
                suffix = "expected by server";
                rgb = BMUI.color_darkGrey2.getRGB();
            } else {
                styledString = new StyledString();
                styledString.append(gtol.getName());
                StyleRange range = new StyleRange();
                range.foreground = BMUI.color_black;
                range.start = 0;
                range.length = gtol.getName().length();
                cell.setStyleRanges(new StyleRange[]{range});
                cell.setText(styledString.toString());
                cell.setImage(BMUI.IMAGE_MAP.get(gtol.getIcon()));
            }
            if (regex != null) {
                String[] split = gtol.getName().split(regex);
                styledString = new StyledString(split[0].trim());
                JFaceResources.getColorRegistry().put("COUNTER_COLOR", rgb);
                decoration = MessageFormat.format(pattern, suffix);
                styledString.append(decoration, StyledString.COUNTER_STYLER);
                cell.setStyleRanges(styledString.getStyleRanges());
                cell.setText(styledString.toString());
            }
            if (gtol.getName().contains(DISABLED)) {
                String iconName = gtol.getIcon();
                Image im = BMUI.IMAGE_MAP.get(iconName = String.valueOf(iconName) + "_CUT");
                if (im != null) {
                    cell.setImage(im);
                } else {
                    cell.setImage(BMUI.IMAGE_MAP.get(gtol.getIcon()));
                }
            } else {
                cell.setImage(BMUI.IMAGE_MAP.get(gtol.getIcon()));
            }
        } else if (element instanceof GroupTreeObject) {
            GroupTreeObject gto = (GroupTreeObject)element;
            String type = gto.getTreeObject().getType();
            if (type == null) {
                cell.setImage(BMUI.IMAGE_FOLDER_DEFAULT);
                cell.setText(gto.getName());
            } else {
                Image icon = BMUI.IMAGE_MAP.get(type);
                if (icon != null) {
                    cell.setImage(icon);
                } else {
                    cell.setImage(BMUI.IMAGE_FOLDER_DEFAULT);
                }
                if (type.equals(BMUI.type_assignment_pol)) {
                    if (gto.getName().startsWith("!")) {
                        String[] split = gto.getName().split("!");
                        styledString = new StyledString();
                        JFaceResources.getColorRegistry().put("COUNTER_COLOR", BMUI.color_critical.getRGB());
                        decoration = MessageFormat.format("{0}", "!");
                        styledString.append(decoration, StyledString.COUNTER_STYLER);
                        styledString.append(split[1]);
                        cell.setStyleRanges(styledString.getStyleRanges());
                        cell.setText(styledString.toString());
                    } else {
                        styledString = new StyledString();
                        styledString.append(gto.getName());
                        StyleRange range = new StyleRange();
                        range.foreground = BMUI.color_black;
                        range.start = 0;
                        range.length = gto.getName().length();
                        cell.setStyleRanges(new StyleRange[]{range});
                        cell.setText(styledString.toString());
                    }
                } else {
                    styledString = new StyledString();
                    styledString.append(String.valueOf(gto.getName()) + " [" + this.getElementCounter(gto) + "]");
                    StyleRange range = new StyleRange();
                    range.foreground = BMUI.color_black;
                    range.start = 0;
                    range.length = gto.getName().length();
                    cell.setStyleRanges(new StyleRange[]{range});
                    cell.setText(styledString.toString());
                }
            }
        }
        super.update(cell);
    }

    private String getElementCounter(GroupTreeObject parentGTO) {
        int polCount = 0;
        int binCount = 0;
        List<GroupTreeObject> elements = parentGTO.getAllElements();
        for (GroupTreeObject gto : elements) {
            if (!(gto instanceof GroupTreeObjectLast)) continue;
            String type = gto.getType();
            if (type.equals(BMUI.type_mon) || type.equals(BMUI.type_msg)) {
                ++polCount;
                continue;
            }
            if (!type.equals(BMUI.type_assignment_bin)) continue;
            ++binCount;
        }
        return String.valueOf(polCount) + ":" + binCount;
    }
}

