/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.engine.UIJob;
import com.blixx.boom.gui.policies.AssignmentTreeProvider;
import com.blixx.boom.gui.policies.ViewContentProvider;
import com.blixx.boom.gui.policies.ViewLabelProvider;
import com.blixx.boom.gui.utils.FilterComposite;
import com.blixx.boom.gui.utils.STreeViewer;
import com.blixx.boom.gui.utils.TreeComparator;
import com.blixx.boom.gui.utils.TreeElementComparer;
import com.blixx.boom.gui.views.actions.AddGroupTreeObjectAction;
import com.blixx.boom.gui.views.actions.AssignToNodeAction;
import com.blixx.boom.gui.views.actions.DeleteGroupTreeObjectAction;
import com.blixx.boom.gui.views.actions.DeleteLink;
import com.blixx.boom.gui.views.actions.ExpandCollapseAction;
import com.blixx.boom.gui.views.actions.GtoAddBinaryLinkAction;
import com.blixx.boom.gui.views.actions.GtoAddPolicyLinkAction;
import com.blixx.boom.gui.views.actions.OpenPolicyAction;
import com.blixx.boom.gui.views.actions.RedeployAction;
import com.blixx.boom.gui.views.actions.RefreshTreeAction;
import com.blixx.boom.gui.views.actions.RenameGroupTreeObjectAction;
import com.blixx.boom.gui.views.actions.SelectBinaryInTreeAction;
import com.blixx.boom.gui.views.actions.SelectPolicyInTreeAction;
import com.blixx.boom.gui.views.dnd.DNDCutCopyAsnLinksAction;
import com.blixx.boom.gui.views.dnd.DNDPasteToAsnTreeAction;
import com.blixx.boom.gui.views.dnd.DNDShare;
import com.blixx.boom.gui.views.dnd.DNDSourceAssignTreeProcessor;
import com.blixx.boom.gui.views.dnd.DNDTargetAssignTreeProcessor;
import com.blixx.boom.gui.views.dnd.DNDTreeIconManager;
import com.blixx.log.RTLogger;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.GroupTreeObjectLast;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.part.ViewPart;

public class AssignmentListView
extends ViewPart
implements IDoubleClickListener {
    public static final int VIEW_ID = 1008;
    public static final String ID = "com.blixx.boom.gui.views.assignmentlistview";
    protected STreeViewer m_treeViewer;
    public GroupTreeObject m_assignmentROOT;
    public static AssignmentListView m_alv = null;
    public static String TREE_VIEWER_TYPE = "TREE_VIEWER_TYPE";
    public static String ASSIGNMENT_LIST = "ASSIGNMENT_LIST";
    private Clipboard m_clipboard = null;
    private DNDTreeIconManager m_treeIconManager = null;

    public static AssignmentListView getInstance() {
        return m_alv;
    }

    public AssignmentListView() {
        m_alv = this;
    }

    public void createPartControl(Composite parent) {
        if (Repository.getInstance().getRights(1008) <= 1) {
            parent.setLayout((Layout)new GridLayout(2, false));
            Label l = new Label(parent, 0);
            l.setText(" Insufficient rights.");
            l.setForeground(BMUI.color_critical);
            Button close = new Button(parent, 8);
            close.setText("Close");
            close.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    AssignmentListView.this.getSite().getPage().hideView(AssignmentListView.this.getSite().getPage().findView(AssignmentListView.ID));
                }
            });
            UIJob uiJob = new UIJob("Close Viewcom.blixx.boom.gui.views.assignmentlistview"){

                @Override
                public IStatus runInUIThread(IProgressMonitor monitor) {
                    AssignmentListView.this.getSite().getPage().hideView(AssignmentListView.this.getSite().getPage().findView(AssignmentListView.ID));
                    return Status.OK_STATUS;
                }
            };
            Repository.getUIJobManager().schedule(uiJob);
            return;
        }
        this.m_clipboard = new Clipboard(Display.getCurrent());
        this.m_treeIconManager = new DNDTreeIconManager();
        parent.setLayout((Layout)new GridLayout(1, false));
        new FilterComposite(parent, (Object)this);
        this.m_treeViewer = new STreeViewer(parent, 268438274);
        this.m_treeViewer.setUseHashlookup(true);
        this.m_treeViewer.setData(TREE_VIEWER_TYPE, ASSIGNMENT_LIST);
        this.m_treeViewer.getTree().setLayoutData((Object)new GridData(4, 4, true, true));
        this.m_treeViewer.setComparer(new TreeElementComparer());
        this.m_treeViewer.setContentProvider((IContentProvider)new ViewContentProvider());
        this.m_treeViewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider(null, this.m_treeViewer));
        this.m_assignmentROOT = AssignmentTreeProvider.getInstance().createAssignmentTree();
        this.m_treeViewer.setComparator(new TreeComparator());
        this.m_treeViewer.setInput(this.m_assignmentROOT);
        this.m_treeViewer.expandToLevel(2);
        this.m_treeViewer.setAutoExpandLevel(2);
        this.m_treeViewer.addDoubleClickListener(this);
        Transfer[] types = new Transfer[]{LocalSelectionTransfer.getTransfer()};
        if (Repository.getInstance().getRights(1008) == 3) {
            this.m_treeViewer.addDragSupport(2, types, new DNDSourceAssignTreeProcessor(this.m_treeViewer));
            this.m_treeViewer.addDropSupport(6, types, new DNDTargetAssignTreeProcessor(this.m_treeViewer));
        }
        this.m_treeViewer.getTree().addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                if (e.stateMask == 262144) {
                    if (e.keyCode == 120) {
                        DNDCutCopyAsnLinksAction cutAction = new DNDCutCopyAsnLinksAction(AssignmentListView.this.m_treeViewer, DNDShare.DND_CUT, AssignmentListView.this.m_clipboard);
                        cutAction.run();
                    } else if (e.keyCode == 99) {
                        DNDCutCopyAsnLinksAction copyAction = new DNDCutCopyAsnLinksAction(AssignmentListView.this.m_treeViewer, DNDShare.DND_COPY, AssignmentListView.this.m_clipboard);
                        copyAction.run();
                    } else if (e.keyCode == 118) {
                        DNDPasteToAsnTreeAction pasteAction = new DNDPasteToAsnTreeAction(AssignmentListView.this.m_treeViewer, AssignmentListView.this.m_clipboard);
                        pasteAction.run();
                    }
                }
                if (e.keyCode == 27) {
                    String DNDType = (String)AssignmentListView.this.m_clipboard.getContents((Transfer)TextTransfer.getInstance());
                    AssignmentListView.this.m_treeIconManager.restoreAssignmentTreeIcons((Object)AssignmentListView.this.m_treeViewer, DNDType);
                    AssignmentListView.this.m_clipboard.clearContents();
                    DNDShare.getInstance().clearDNDAsnTreeObjects();
                }
            }
        });
        this.createContentMenu();
        this.setTitleImage(BMUI.IMAGE_ASSIGNMENTS);
    }

    public void createContentMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        Menu menu = menuMgr.createContextMenu(this.m_treeViewer.getControl());
        this.m_treeViewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.m_treeViewer);
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                try {
                    manager.add((IAction)new RefreshTreeAction(AssignmentListView.this.m_treeViewer, null, null, null));
                    manager.add((IContributionItem)new Separator());
                    StructuredSelection ssel = (StructuredSelection)AssignmentListView.this.m_treeViewer.getSelection();
                    if (!ssel.isEmpty()) {
                        Object o = ssel.getFirstElement();
                        if (o instanceof GroupTreeObject && !(o instanceof GroupTreeObjectLast)) {
                            GroupTreeObject gto = (GroupTreeObject)o;
                            if (gto.getTreeObject().getType().equals(BMUI.type_assignment_pol)) {
                                manager.add((IAction)new AssignToNodeAction(AssignmentListView.this.m_treeViewer, "DEPLOY"));
                                manager.add((IAction)new RedeployAction(AssignmentListView.this.m_treeViewer, "DEPLOY"));
                                manager.add((IAction)new AssignToNodeAction(AssignmentListView.this.m_treeViewer, "UNDEPLOY"));
                                manager.add((IAction)new RedeployAction(AssignmentListView.this.m_treeViewer, "UNDEPLOY"));
                                manager.add((IAction)new AssignToNodeAction(AssignmentListView.this.m_treeViewer, "DEPLOY_VIRTUAL"));
                                manager.add((IContributionItem)new Separator());
                                manager.add((IAction)new AssignToNodeAction(AssignmentListView.this.m_treeViewer, "DEPLOY_DELAYED"));
                                manager.add((IAction)new RedeployAction(AssignmentListView.this.m_treeViewer, "DEPLOY_DELAYED"));
                                manager.add((IAction)new AssignToNodeAction(AssignmentListView.this.m_treeViewer, "UNDEPLOY_DELAYED"));
                                manager.add((IAction)new RedeployAction(AssignmentListView.this.m_treeViewer, "UNDEPLOY_DELAYED"));
                                manager.add((IContributionItem)new Separator());
                            }
                            manager.add((IAction)new AddGroupTreeObjectAction(AssignmentListView.this.m_treeViewer, gto, BMUI.type_tree_assignment, gto.getTreeObject().getType()));
                            if (!gto.getTreeObject().getType().equals(BMUI.type_toplevel)) {
                                manager.add((IAction)new RenameGroupTreeObjectAction(AssignmentListView.this.m_treeViewer, gto, BMUI.type_tree_assignment));
                                manager.add((IAction)new DeleteGroupTreeObjectAction(AssignmentListView.this.m_treeViewer, BMUI.type_tree_assignment));
                                manager.add((IContributionItem)new Separator());
                                manager.add((IAction)new GtoAddPolicyLinkAction(AssignmentListView.this.m_treeViewer, gto));
                                manager.add((IAction)new GtoAddBinaryLinkAction(AssignmentListView.this.m_treeViewer, gto));
                                manager.add((IContributionItem)new Separator());
                                if (!gto.getTreeObject().getType().equals(BMUI.type_assignment_pol)) {
                                    manager.add((IAction)new DNDCutCopyAsnLinksAction(AssignmentListView.this.m_treeViewer, DNDShare.DND_CUT_ASN_FOLDER, AssignmentListView.this.m_clipboard));
                                    manager.add((IAction)new DNDCutCopyAsnLinksAction(AssignmentListView.this.m_treeViewer, DNDShare.DND_COPY_ASN_FOLDER, AssignmentListView.this.m_clipboard));
                                }
                                manager.add((IAction)new DNDPasteToAsnTreeAction(AssignmentListView.this.m_treeViewer, AssignmentListView.this.m_clipboard));
                            }
                        } else if (o instanceof GroupTreeObjectLast) {
                            GroupTreeObjectLast gtol = (GroupTreeObjectLast)o;
                            String type = gtol.getTreeObject().getType();
                            if (type.equals(BMUI.type_mon) || type.equals(BMUI.type_msg)) {
                                manager.add((IAction)new OpenPolicyAction(AssignmentListView.this.m_treeViewer, true));
                                manager.add((IAction)new SelectPolicyInTreeAction(AssignmentListView.this.m_treeViewer));
                            } else if (type.equals(BMUI.type_assignment_bin)) {
                                manager.add((IAction)new SelectBinaryInTreeAction(gtol));
                            }
                            manager.add((IAction)new DeleteLink(AssignmentListView.this.m_treeViewer));
                            manager.add((IContributionItem)new Separator());
                            manager.add((IAction)new DNDCutCopyAsnLinksAction(AssignmentListView.this.m_treeViewer, DNDShare.DND_CUT_ASN_LINKS, AssignmentListView.this.m_clipboard));
                            manager.add((IAction)new DNDCutCopyAsnLinksAction(AssignmentListView.this.m_treeViewer, DNDShare.DND_COPY_ASN_LINKS, AssignmentListView.this.m_clipboard));
                            manager.add((IAction)new DNDPasteToAsnTreeAction(AssignmentListView.this.m_treeViewer, AssignmentListView.this.m_clipboard));
                        }
                    }
                    manager.add((IContributionItem)new Separator());
                    manager.add((IAction)new ExpandCollapseAction(AssignmentListView.this.m_treeViewer, "ExpandAll"));
                    manager.add((IAction)new ExpandCollapseAction(AssignmentListView.this.m_treeViewer, "CollapseAll"));
                }
                catch (RuntimeException e) {
                    RTLogger.print(5, "Error creating content menu " + e);
                }
            }
        });
    }

    public TreeViewer getTreeViewer() {
        return this.m_treeViewer;
    }

    public void setFocus() {
    }

    public void doubleClick(DoubleClickEvent event) {
        TreeViewer treeViewer = (TreeViewer)event.getViewer();
        StructuredSelection sel = (StructuredSelection)treeViewer.getSelection();
        Object o = sel.getFirstElement();
        if (o instanceof GroupTreeObject && !(o instanceof GroupTreeObjectLast)) {
            this.m_treeViewer.setExpandedState(o, !this.m_treeViewer.getExpandedState(o));
            return;
        }
        if (o instanceof GroupTreeObjectLast) {
            GroupTreeObjectLast gtol = (GroupTreeObjectLast)o;
            String type = gtol.getTreeObject().getType();
            if (type.equalsIgnoreCase(BMUI.type_assignment_bin)) {
                SelectBinaryInTreeAction selectAction = new SelectBinaryInTreeAction(gtol);
                selectAction.run();
            } else if ((type.equalsIgnoreCase(BMUI.type_mon) || type.equalsIgnoreCase(BMUI.type_msg)) && Repository.getInstance().getRights(1001) > 1) {
                OpenPolicyAction action = new OpenPolicyAction((TreeViewer)event.getViewer(), true);
                action.run();
            }
        }
    }
}

