/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views;

import com.blixx.boom.engine.AgentCard;
import com.blixx.boom.engine.AllAssignmentTableProvider;
import com.blixx.boom.engine.AssignmentFilter;
import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.engine.RunningAssignmentsProvider;
import com.blixx.boom.engine.TableSorter;
import com.blixx.boom.engine.UIJob;
import com.blixx.boom.gui.Activator;
import com.blixx.boom.gui.dialogs.AgentTreeDialog;
import com.blixx.boom.gui.dialogs.ShowMessageBox;
import com.blixx.boom.gui.dialogs.ShowMessageDialog;
import com.blixx.boom.gui.policies.AssignmentTreeProvider;
import com.blixx.boom.gui.policies.PolicyTreeProvider;
import com.blixx.boom.gui.policies.ViewContentProvider;
import com.blixx.boom.gui.utils.GUIDisplayElements;
import com.blixx.boom.gui.utils.STreeViewer;
import com.blixx.boom.gui.views.AssignmentListView;
import com.blixx.boom.gui.views.BinariesListView;
import com.blixx.boom.gui.views.FancyToolTipSupport;
import com.blixx.boom.gui.views.PrintJob;
import com.blixx.boom.gui.views.StyledTreeLabelProvider;
import com.blixx.boom.gui.views.actions.AssignmentFilterAction;
import com.blixx.boom.gui.views.actions.CancelDeploymentAction;
import com.blixx.boom.gui.views.actions.DeployFilteredAction;
import com.blixx.boom.gui.views.actions.ExpandCollapseAction;
import com.blixx.boom.gui.views.actions.ExportTreeAction;
import com.blixx.boom.gui.views.actions.OpenPolicyAction;
import com.blixx.boom.gui.views.actions.RefreshAssignSummaryTreeAction;
import com.blixx.boom.gui.views.actions.SelectAgentInTreeAction;
import com.blixx.boom.gui.views.actions.SelectAssignmentInTreeAction;
import com.blixx.boom.gui.views.actions.SelectBinaryInTreeAction;
import com.blixx.boom.gui.views.actions.SelectNodeGroupInTreeAction;
import com.blixx.boom.gui.views.actions.SelectPolicyInTreeAction;
import com.blixx.boom.gui.views.actions.ShowAssignedPoliciesAction;
import com.blixx.boom.gui.views.actions.TriggerDeploymentAction;
import com.blixx.log.RTLogger;
import com.blixx.shared.Assignment;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.GroupTreeObjectLast;
import com.blixx.shared.utils.ITreeObject;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.part.ViewPart;

public class AssignmentsSummaryView
extends ViewPart
implements IDoubleClickListener,
DisposeListener,
KeyListener,
SelectionListener,
ISelectionChangedListener {
    public static final String ID = "com.blixx.boom.gui.views.assignmentssummaryview";
    private static AssignmentsSummaryView m_instance = null;
    private TreeViewer m_treeViewer_assign = null;
    private TreeViewer m_treeViewer_agentOverview = null;
    private TreeViewer m_treeViewer_nodeGroup = null;
    private TableViewer m_tableViewer_singleDeployed = null;
    private TableViewer m_tableViewer_DeploymentQueue = null;
    private TableViewer m_tableViewer_DeploymentsRunning = null;
    private AllAssignmentTableProvider m_tableProvider_singleDeployed = null;
    private AllAssignmentTableProvider m_tableProvider_deploymentQueue = null;
    private RunningAssignmentsProvider m_tableProvider_deploymentsRunning = null;
    private Button m_deployAll_button = null;
    private Button m_deploySelected_button = null;
    private Button m_deployForAgent_button = null;
    private Button m_cancelButton = null;
    private Button m_cancelButton2 = null;
    private GUIDisplayElements m_gui = null;
    private SashForm m_topSash = null;
    private Composite m_nodeGroup_comp = null;
    public static final String MOD_TIME = "Modification Time";
    public static final String CREATION_TIME = "Creation Time";
    public static final String USER = "User";
    public static final String AGENT = "Agent";
    public static final String STATUS = "Status";
    public static final String NAME = "Name";
    public static final String SIZE = "Size";
    public static final String TYPE = "Type";
    public static final String ASSIGNMENT_GRP = "Assignment Groups";
    public static final String ACTION = "Action";
    public static final String TIME = "Time";
    public static final String START_TIME = "Start Time";
    public static final String EXPIRE_TIME = "Expire Time";
    public static String VIEWER_TYPE = "VIEWER_TYPE";
    public static String ASSIGN_TREE_VIEWER = "ASSIGN_TREE_VIEWER";
    public static String AGENT_TREE_VIEWER = "AGENT_TREE_VIEWER";
    public static String NODE_GROUP_TREE_VIEWER = "NODE_GROUP_TREE_VIEWER";
    public static String SINGLE_DEPLOYED_TABLE_VIEWER = "SINGLE_DEPLOYED_TABLE_VIEWER";
    public static String DEPLOYMENT_QUEUE_TABLE_VIEWER = "DEPLOYMENT_QUEUE_TABLE_VIEWER";
    public static String DEPLOYMENTS_RUNNING_TABLE_VIEWER = "DEPLOYMENTS_RUNNING_TABLE_VIEWER";
    public static String DEPLOY = "Deploy";
    public static String REDEPLOY = "Redeploy";
    public static String UNDEPLOY = "Undeploy";
    public static String CANCEL_DEPLOYMENT = "Cancel Deployment";
    public static String DEPLOY_ALL_BUTTON = "DEPLOY_ALL_BUTTON";
    public static String DEPLOY_SELECTED_BUTTON = "DEPLOY_SELECTED_BUTTON";
    public static String DEPLOY_AGENT_BUTTON = "DEPLOY_AGENT_BUTTON";
    public static String CANCEL_BUTTON = "CANCEL_BUTTON";
    public static String CANCEL_BUTTON2 = "CANCEL_BUTTON2";
    public static String DELAYED_DEPLOY = "DELAYED_DEPLOY";
    public static String CANCEL = "CANCEL";
    public boolean m_hasDeploymentRights = true;
    private Listener sortListener = new Listener(){

        public void handleEvent(Event e) {
            TableColumn currentColumn = (TableColumn)e.widget;
            Table t = currentColumn.getParent();
            TableViewer tableViewer = (TableViewer)t.getData();
            if (e.type == 13) {
                TableColumn sortColumn = tableViewer.getTable().getSortColumn();
                int dir = tableViewer.getTable().getSortDirection();
                if (sortColumn == currentColumn) {
                    dir = dir == 128 ? 1024 : 128;
                } else {
                    tableViewer.getTable().setSortColumn(currentColumn);
                    dir = 128;
                }
                ISelection iSelection = tableViewer.getSelection();
                String sortIdentifier = currentColumn.getText();
                TableSorter tableSorter = (TableSorter)tableViewer.getSorter();
                tableSorter.setConfig(sortIdentifier, dir);
                tableViewer.getTable().setSortDirection(dir);
                tableViewer.refresh();
                tableViewer.setSelection(iSelection);
            }
        }
    };

    public AssignmentsSummaryView() {
        m_instance = this;
    }

    public static AssignmentsSummaryView getInstance() {
        return m_instance;
    }

    public void createPartControl(Composite parent) {
        if (Repository.getInstance().getRights(1008) <= 1) {
            parent.setLayout((Layout)new GridLayout(2, false));
            Label l = new Label(parent, 0);
            l.setText(" Insufficient rights.");
            l.setForeground(BMUI.color_critical);
            Button close = new Button(parent, 8);
            close.setText("Close");
            close.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    AssignmentsSummaryView.this.getSite().getPage().hideView(AssignmentsSummaryView.this.getSite().getPage().findView(AssignmentsSummaryView.ID));
                }
            });
            UIJob uiJob = new UIJob("Close Viewcom.blixx.boom.gui.views.assignmentssummaryview"){

                @Override
                public IStatus runInUIThread(IProgressMonitor monitor) {
                    AssignmentsSummaryView.this.getSite().getPage().hideView(AssignmentsSummaryView.this.getSite().getPage().findView(AssignmentsSummaryView.ID));
                    return Status.OK_STATUS;
                }
            };
            Repository.getUIJobManager().schedule(uiJob);
            return;
        }
        parent.setLayout((Layout)new GridLayout(1, false));
        if (Repository.getInstance().getRights(1008) < 3) {
            this.m_hasDeploymentRights = false;
        }
        this.m_gui = new GUIDisplayElements();
        SashForm main = new SashForm(parent, 512);
        main.setLayoutData((Object)new GridData(4, 4, true, true));
        this.m_topSash = new SashForm((Composite)main, 256);
        SashForm bottom = new SashForm((Composite)main, 512);
        this.createAssignTree((Composite)this.m_topSash);
        this.createAgentTree((Composite)this.m_topSash);
        boolean displayNodeGroups = false;
        if (displayNodeGroups) {
            this.createNodeGroupTree((Composite)this.m_topSash);
        }
        this.createSingleDeployedTable((Composite)bottom);
        this.createDeploymentQueueTable((Composite)bottom);
        boolean isSupported = Repository.getInstance().getAllAssignments().isSupported();
        if (isSupported) {
            this.createDeploymentStatusTable((Composite)bottom);
            this.refreshDeploymentButtons(this.m_tableViewer_DeploymentsRunning);
        }
        this.refreshDeploymentButtons(this.m_tableViewer_DeploymentQueue);
        main.setWeights(new int[]{30, 70});
        if (displayNodeGroups) {
            this.m_topSash.setWeights(new int[]{35, 35, 30});
        } else {
            this.m_topSash.setWeights(new int[]{30, 40});
        }
        if (isSupported) {
            bottom.setWeights(new int[]{33, 33, 30});
        } else {
            bottom.setWeights(new int[]{50, 50});
        }
        this.setTitleImage(BMUI.IMAGE_ASSIGNMENTS);
    }

    public void createAssignTree(Composite parent) {
        this.m_treeViewer_assign = new STreeViewer(parent, 268438274);
        this.m_treeViewer_assign.setData(VIEWER_TYPE, (Object)ASSIGN_TREE_VIEWER);
        this.m_treeViewer_assign.setUseHashlookup(true);
        this.m_treeViewer_assign.setContentProvider((IContentProvider)new ViewContentProvider());
        this.m_treeViewer_assign.setLabelProvider((IBaseLabelProvider)new StyledTreeLabelProvider(StyledTreeLabelProvider.AsnTable));
        this.m_treeViewer_assign.addDoubleClickListener((IDoubleClickListener)this);
        this.m_treeViewer_assign.setInput((Object)Repository.getInstance().getAllAssignments().getAllAssignmentRoot());
        this.m_treeViewer_assign.collapseAll();
        this.m_treeViewer_assign.getTree().addKeyListener((KeyListener)this);
        this.createTreeContentMenu(this.m_treeViewer_assign);
    }

    public void createAgentTree(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new FillLayout());
        this.m_treeViewer_agentOverview = new STreeViewer(composite, 268438274);
        this.m_treeViewer_agentOverview.setData(VIEWER_TYPE, (Object)AGENT_TREE_VIEWER);
        this.m_treeViewer_agentOverview.setUseHashlookup(true);
        this.m_treeViewer_agentOverview.setContentProvider((IContentProvider)new ViewContentProvider());
        this.m_treeViewer_agentOverview.setLabelProvider((IBaseLabelProvider)new StyledTreeLabelProvider());
        this.m_treeViewer_agentOverview.addDoubleClickListener((IDoubleClickListener)this);
        this.m_treeViewer_agentOverview.setInput((Object)Repository.getInstance().getAllAssignments().getAllAgentsRoot());
        this.m_treeViewer_agentOverview.collapseAll();
        this.m_treeViewer_agentOverview.getTree().addKeyListener((KeyListener)this);
        this.createTreeContentMenu(this.m_treeViewer_agentOverview);
    }

    public void createNodeGroupTree(Composite parent) {
        if (this.m_nodeGroup_comp == null || this.m_nodeGroup_comp.isDisposed()) {
            this.m_nodeGroup_comp = new Composite(parent, 0);
        }
        this.m_nodeGroup_comp.setLayout((Layout)new FillLayout());
        this.m_treeViewer_nodeGroup = new STreeViewer(this.m_nodeGroup_comp, 268438274);
        this.m_treeViewer_nodeGroup.setData(VIEWER_TYPE, (Object)NODE_GROUP_TREE_VIEWER);
        this.m_treeViewer_nodeGroup.setUseHashlookup(true);
        this.m_treeViewer_nodeGroup.setContentProvider((IContentProvider)new ViewContentProvider());
        this.m_treeViewer_nodeGroup.setLabelProvider((IBaseLabelProvider)new StyledTreeLabelProvider());
        this.m_treeViewer_nodeGroup.addDoubleClickListener((IDoubleClickListener)this);
        this.m_treeViewer_nodeGroup.setInput((Object)Repository.getInstance().getAllAssignments().getAllNodeGroupsRoot());
        this.m_treeViewer_nodeGroup.collapseAll();
        this.m_treeViewer_nodeGroup.getTree().addKeyListener((KeyListener)this);
        this.createTreeContentMenu(this.m_treeViewer_nodeGroup);
    }

    public void toggleNGTree(boolean activate) {
        if (activate) {
            this.createNodeGroupTree((Composite)this.m_topSash);
            this.m_topSash.setWeights(new int[]{35, 35, 30});
        } else {
            this.m_nodeGroup_comp.dispose();
            this.m_topSash.setWeights(new int[]{30, 30});
        }
        this.m_topSash.redraw();
    }

    public boolean isNGTreeActive() {
        return this.m_nodeGroup_comp != null && !this.m_nodeGroup_comp.isDisposed();
    }

    public void createTreeContentMenu(final TreeViewer treeViewer) {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(false);
        Menu menu = menuMgr.createContextMenu(treeViewer.getControl());
        treeViewer.getControl().setMenu(menu);
        IWorkbenchPartSite site = AssignmentsSummaryView.getInstance().getSite();
        site.registerContextMenu(menuMgr, (ISelectionProvider)treeViewer);
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                try {
                    manager.add((IAction)new RefreshAssignSummaryTreeAction());
                    StructuredSelection ssel = (StructuredSelection)treeViewer.getSelection();
                    if (!ssel.isEmpty()) {
                        Object o = ssel.getFirstElement();
                        if (o instanceof GroupTreeObjectLast) {
                            GroupTreeObjectLast gtol = (GroupTreeObjectLast)o;
                            if (treeViewer.getData(VIEWER_TYPE).equals(AGENT_TREE_VIEWER)) {
                                String type = gtol.getTreeObject().getType();
                                if (type.equals(BMUI.type_mon) || type.equals(BMUI.type_msg)) {
                                    manager.add((IContributionItem)new Separator());
                                    manager.add((IAction)new OpenPolicyAction(treeViewer, true));
                                    manager.add((IAction)new SelectPolicyInTreeAction(treeViewer));
                                } else if (type.equals(BMUI.type_assignment_bin)) {
                                    manager.add((IContributionItem)new Separator());
                                    manager.add((IAction)new SelectBinaryInTreeAction(treeViewer));
                                } else if (type.equals(BMUI.type_assignment_pol)) {
                                    manager.add((IContributionItem)new Separator());
                                    manager.add((IAction)new SelectAssignmentInTreeAction(treeViewer));
                                }
                            } else if (treeViewer.getData(VIEWER_TYPE).equals(ASSIGN_TREE_VIEWER)) {
                                manager.add((IContributionItem)new Separator());
                                manager.add((IAction)new ShowAssignedPoliciesAction(treeViewer));
                                AgentCard ac = null;
                                if (gtol.getTreeObject() instanceof AgentCard) {
                                    ac = (AgentCard)gtol.getTreeObject();
                                    manager.add((IAction)new SelectAgentInTreeAction(ac.getAgentID()));
                                }
                            } else if (treeViewer.getData(VIEWER_TYPE).equals(NODE_GROUP_TREE_VIEWER)) {
                                String type = gtol.getTreeObject().getType();
                                if (type.equals(BMUI.type_mon) || type.equals(BMUI.type_msg)) {
                                    manager.add((IContributionItem)new Separator());
                                    manager.add((IAction)new OpenPolicyAction(treeViewer, true));
                                    manager.add((IAction)new SelectPolicyInTreeAction(treeViewer));
                                } else if (type.equals(BMUI.type_assignment_bin)) {
                                    manager.add((IContributionItem)new Separator());
                                    manager.add((IAction)new SelectBinaryInTreeAction(treeViewer));
                                } else if (type.equals(BMUI.type_assignment_pol)) {
                                    manager.add((IContributionItem)new Separator());
                                    manager.add((IAction)new SelectAssignmentInTreeAction(treeViewer));
                                }
                            }
                        } else if (o instanceof GroupTreeObject) {
                            GroupTreeObject gto = (GroupTreeObject)o;
                            String type = gto.getTreeObject().getType();
                            if (type.equals(BMUI.type_agt)) {
                                manager.add((IContributionItem)new Separator());
                                manager.add((IAction)new ShowAssignedPoliciesAction(treeViewer));
                                AgentCard ac = null;
                                if (gto.getTreeObject() instanceof AgentCard) {
                                    ac = (AgentCard)gto.getTreeObject();
                                    manager.add((IAction)new SelectAgentInTreeAction(ac.getAgentID()));
                                }
                            } else if (type.equals(BMUI.type_assignment_pol)) {
                                manager.add((IContributionItem)new Separator());
                                manager.add((IAction)new SelectAssignmentInTreeAction(treeViewer));
                            } else {
                                String oid = gto.getTreeObject().getOID();
                                if (oid != null && oid.length() > 0 && oid.indexOf("-") == -1) {
                                    manager.add((IContributionItem)new Separator());
                                    manager.add((IAction)new SelectNodeGroupInTreeAction(gto));
                                }
                            }
                        }
                    }
                    manager.add((IContributionItem)new Separator());
                    GroupTreeObject root = (GroupTreeObject)treeViewer.getTree().getData();
                    manager.add((IAction)new ExportTreeAction(root));
                    manager.add((IContributionItem)new Separator());
                    manager.add((IAction)new ExpandCollapseAction(treeViewer, "ExpandAll"));
                    manager.add((IAction)new ExpandCollapseAction(treeViewer, "CollapseAll"));
                }
                catch (RuntimeException e) {
                    RTLogger.print(4, "", e);
                }
            }
        });
    }

    public void createSingleDeployedTable(Composite parent) {
        CTabFolder folder = new CTabFolder(parent, 2816);
        folder.setSimple(false);
        folder.setBorderVisible(false);
        folder.setBackground(BMUI.color_unknown);
        CTabItem tab = new CTabItem(folder, 0);
        tab.setText("Single Deployed Policies/Packages");
        Composite compInTab = new Composite((Composite)folder, 2048);
        GridLayout gl = new GridLayout(1, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        gl.verticalSpacing = 0;
        gl.horizontalSpacing = 0;
        compInTab.setLayout((Layout)gl);
        Composite tableComp = new Composite(compInTab, 0);
        tableComp.setLayout((Layout)gl);
        tableComp.setLayoutData((Object)new GridData(4, 4, true, true));
        Table tbl = new Table(tableComp, 268503810);
        tbl.setHeaderVisible(true);
        tbl.setLinesVisible(true);
        tbl.setLayout((Layout)gl);
        tbl.setBackground(BMUI.color_unknown);
        TableColumn col0 = new TableColumn(tbl, 16384);
        col0.setText(TYPE);
        col0.setWidth(40);
        col0.addListener(13, this.sortListener);
        TableColumn col1 = new TableColumn(tbl, 16384);
        col1.setText(NAME);
        col1.setWidth(220);
        col1.addListener(13, this.sortListener);
        TableColumn col2 = new TableColumn(tbl, 16384);
        col2.setText(STATUS);
        col2.setWidth(45);
        col2.addListener(13, this.sortListener);
        TableColumn col3 = new TableColumn(tbl, 16384);
        col3.setText(AGENT);
        col3.setWidth(200);
        col3.addListener(13, this.sortListener);
        TableColumn col4 = new TableColumn(tbl, 16384);
        col4.setText(USER);
        col4.setWidth(100);
        col4.addListener(13, this.sortListener);
        TableColumn col5 = new TableColumn(tbl, 16384);
        col5.setText(CREATION_TIME);
        col5.setWidth(120);
        col5.addListener(13, this.sortListener);
        TableColumn col6 = new TableColumn(tbl, 16384);
        col6.setText(MOD_TIME);
        col6.setWidth(120);
        col6.addListener(13, this.sortListener);
        TableColumnLayout tableLayout = new TableColumnLayout();
        tableComp.setLayout((Layout)tableLayout);
        tableLayout.setColumnData((Widget)col0, (ColumnLayoutData)new ColumnWeightData(0, col0.getWidth()));
        tableLayout.setColumnData((Widget)col1, (ColumnLayoutData)new ColumnWeightData(30, col1.getWidth()));
        tableLayout.setColumnData((Widget)col2, (ColumnLayoutData)new ColumnWeightData(0, col2.getWidth()));
        tableLayout.setColumnData((Widget)col3, (ColumnLayoutData)new ColumnWeightData(30, col3.getWidth()));
        tableLayout.setColumnData((Widget)col4, (ColumnLayoutData)new ColumnWeightData(0, col4.getWidth()));
        tableLayout.setColumnData((Widget)col5, (ColumnLayoutData)new ColumnWeightData(0, col5.getWidth()));
        tableLayout.setColumnData((Widget)col6, (ColumnLayoutData)new ColumnWeightData(40, col6.getWidth()));
        this.m_tableViewer_singleDeployed = new TableViewer(tbl);
        this.m_tableViewer_singleDeployed.setData(VIEWER_TYPE, (Object)SINGLE_DEPLOYED_TABLE_VIEWER);
        this.m_tableProvider_singleDeployed = new AllAssignmentTableProvider(true);
        this.m_tableViewer_singleDeployed.setContentProvider((IContentProvider)this.m_tableProvider_singleDeployed);
        this.m_tableViewer_singleDeployed.setLabelProvider((IBaseLabelProvider)this.m_tableProvider_singleDeployed.labelProvider);
        this.m_tableViewer_singleDeployed.setInput((Object)this.m_tableProvider_singleDeployed.getElements(null));
        TableSorter tableSorter = new TableSorter(NAME, 1024);
        this.m_tableViewer_singleDeployed.setSorter((ViewerSorter)tableSorter);
        this.m_tableViewer_singleDeployed.addDoubleClickListener((IDoubleClickListener)this);
        this.m_tableViewer_singleDeployed.addSelectionChangedListener((ISelectionChangedListener)this);
        tbl.setData((Object)this.m_tableViewer_singleDeployed);
        this.createContentMenu_single(this.m_tableViewer_singleDeployed, tab);
        tab.setControl((Control)compInTab);
        folder.setSelection(tab);
    }

    public void createContentMenu_single(final TableViewer tableViewer, final CTabItem tab) {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(false);
        Menu menu = menuMgr.createContextMenu(tableViewer.getControl());
        tableViewer.getControl().setMenu(menu);
        final IWorkbenchPartSite site = AssignmentsSummaryView.getInstance().getSite();
        site.registerContextMenu(menuMgr, (ISelectionProvider)tableViewer);
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                try {
                    Object o;
                    manager.add((IAction)new RefreshAssignSummaryTreeAction());
                    manager.add((IContributionItem)new Separator());
                    StructuredSelection ssel = (StructuredSelection)tableViewer.getSelection();
                    if (!ssel.isEmpty() && (o = ssel.getFirstElement()) instanceof Assignment) {
                        Assignment asn = (Assignment)o;
                        String type = asn.getType();
                        if (type.equals(BMUI.type_mon) || type.equals(BMUI.type_msg)) {
                            manager.add((IAction)new OpenPolicyAction(tableViewer, true));
                            manager.add((IAction)new SelectPolicyInTreeAction(tableViewer));
                            manager.add((IContributionItem)new Separator());
                        } else if (type.equals(BMUI.type_assignment_bin)) {
                            manager.add((IAction)new SelectBinaryInTreeAction(tableViewer));
                            manager.add((IContributionItem)new Separator());
                        }
                    }
                    manager.add((IContributionItem)new Separator());
                    manager.add((IAction)new AssignmentFilterAction(site.getWorkbenchWindow(), tableViewer, null, tab, false));
                    Iterator<AssignmentFilter> it = AssignmentFilterAction.getActiveFiltersIterator(tableViewer);
                    while (it.hasNext()) {
                        AssignmentFilter af = it.next();
                        if (af.getTableViewer() != tableViewer) continue;
                        AssignmentFilterAction action = new AssignmentFilterAction(site.getWorkbenchWindow(), tableViewer, af.toString(), tab, af.m_isActive);
                        action.setEnabled(!af.m_isLocked);
                        manager.add((IAction)action);
                    }
                }
                catch (RuntimeException runtimeException) {}
            }
        });
    }

    public void createDeploymentQueueTable(Composite parent) {
        CTabFolder folder = new CTabFolder(parent, 2816);
        folder.setSimple(false);
        folder.setBorderVisible(false);
        folder.setBackground(BMUI.color_unknown);
        CTabItem tab = new CTabItem(folder, 0);
        tab.setText("Deployment Queue");
        Composite compInTab = new Composite((Composite)folder, 2048);
        GridLayout gl = new GridLayout(1, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        gl.verticalSpacing = 0;
        gl.horizontalSpacing = 0;
        compInTab.setLayout((Layout)gl);
        Composite tableComp = new Composite(compInTab, 0);
        tableComp.setLayout((Layout)gl);
        tableComp.setLayoutData((Object)new GridData(4, 4, true, true));
        Table tbl = new Table(tableComp, 268503810);
        tbl.setHeaderVisible(true);
        tbl.setLinesVisible(true);
        tbl.setBackground(BMUI.color_unknown);
        TableColumn col0 = new TableColumn(tbl, 16384);
        col0.setText(ASSIGNMENT_GRP);
        col0.setWidth(40);
        col0.addListener(13, this.sortListener);
        TableColumn col1 = new TableColumn(tbl, 16384);
        col1.setText(TYPE);
        col1.setWidth(40);
        col1.addListener(13, this.sortListener);
        TableColumn col2 = new TableColumn(tbl, 16384);
        col2.setText(NAME);
        col2.setWidth(220);
        col2.addListener(13, this.sortListener);
        TableColumn col3 = new TableColumn(tbl, 16384);
        col3.setText(STATUS);
        col3.setWidth(45);
        col3.addListener(13, this.sortListener);
        TableColumn col4 = new TableColumn(tbl, 16384);
        col4.setText(AGENT);
        col4.setWidth(200);
        col4.addListener(13, this.sortListener);
        TableColumn col5 = new TableColumn(tbl, 16384);
        col5.setText(ACTION);
        col5.setWidth(110);
        col5.addListener(13, this.sortListener);
        TableColumn col6 = new TableColumn(tbl, 16384);
        col6.setText(USER);
        col6.setWidth(90);
        col6.addListener(13, this.sortListener);
        TableColumn col7 = new TableColumn(tbl, 16384);
        col7.setText(TIME);
        col7.setWidth(120);
        col7.addListener(13, this.sortListener);
        TableColumnLayout tableLayout = new TableColumnLayout();
        tableComp.setLayout((Layout)tableLayout);
        tableLayout.setColumnData((Widget)col0, (ColumnLayoutData)new ColumnWeightData(0, col0.getWidth()));
        tableLayout.setColumnData((Widget)col1, (ColumnLayoutData)new ColumnWeightData(0, col1.getWidth()));
        tableLayout.setColumnData((Widget)col2, (ColumnLayoutData)new ColumnWeightData(30, col2.getWidth()));
        tableLayout.setColumnData((Widget)col3, (ColumnLayoutData)new ColumnWeightData(0, col3.getWidth()));
        tableLayout.setColumnData((Widget)col4, (ColumnLayoutData)new ColumnWeightData(30, col4.getWidth()));
        tableLayout.setColumnData((Widget)col5, (ColumnLayoutData)new ColumnWeightData(0, col5.getWidth()));
        tableLayout.setColumnData((Widget)col6, (ColumnLayoutData)new ColumnWeightData(0, col6.getWidth()));
        tableLayout.setColumnData((Widget)col7, (ColumnLayoutData)new ColumnWeightData(40, col7.getWidth()));
        this.m_tableViewer_DeploymentQueue = new TableViewer(tbl);
        this.m_tableViewer_DeploymentQueue.setData(VIEWER_TYPE, (Object)DEPLOYMENT_QUEUE_TABLE_VIEWER);
        this.m_tableProvider_deploymentQueue = new AllAssignmentTableProvider(false);
        this.m_tableViewer_DeploymentQueue.setContentProvider((IContentProvider)this.m_tableProvider_deploymentQueue);
        this.m_tableViewer_DeploymentQueue.setLabelProvider((IBaseLabelProvider)this.m_tableProvider_deploymentQueue.labelProvider);
        this.m_tableViewer_DeploymentQueue.setInput((Object)this.m_tableProvider_deploymentQueue.getElements(null));
        TableSorter tableSorter = new TableSorter(NAME, 1024);
        this.m_tableViewer_DeploymentQueue.setSorter((ViewerSorter)tableSorter);
        this.m_tableViewer_DeploymentQueue.addDoubleClickListener((IDoubleClickListener)this);
        this.m_tableViewer_DeploymentQueue.addSelectionChangedListener((ISelectionChangedListener)this);
        tbl.setData((Object)this.m_tableViewer_DeploymentQueue);
        FancyToolTipSupport.enableFor((ColumnViewer)this.m_tableViewer_DeploymentQueue, 2);
        tbl.setToolTipText("");
        this.createContentMenu_queue(this.m_tableViewer_DeploymentQueue, tab);
        AssignmentFilter af1 = new AssignmentFilter(ACTION, DEPLOY, false, 4, this.m_tableViewer_DeploymentQueue, false);
        af1.m_isActive = false;
        af1.m_isDefault = true;
        AssignmentFilterAction.m_filters.putV(this.m_tableViewer_DeploymentQueue, af1);
        AssignmentFilter af2 = new AssignmentFilter(ACTION, REDEPLOY, false, 4, this.m_tableViewer_DeploymentQueue, false);
        af2.m_isActive = false;
        af2.m_isDefault = true;
        AssignmentFilterAction.m_filters.putV(this.m_tableViewer_DeploymentQueue, af2);
        AssignmentFilter af3 = new AssignmentFilter(ACTION, UNDEPLOY, false, 4, this.m_tableViewer_DeploymentQueue, false);
        af3.m_isActive = false;
        af3.m_isDefault = true;
        AssignmentFilterAction.m_filters.putV(this.m_tableViewer_DeploymentQueue, af3);
        Composite buttonComp = new Composite(compInTab, 0);
        GridLayout gla = new GridLayout(5, false);
        gla.marginWidth = 0;
        gla.marginHeight = 0;
        buttonComp.setLayout((Layout)gla);
        GridData gridData = new GridData(4, 1024, false, false);
        gridData.minimumHeight = 50;
        buttonComp.setLayoutData((Object)gridData);
        this.m_deployAll_button = this.m_gui.addButton(buttonComp, DEPLOY_ALL_BUTTON, "Trigger All", false, this);
        this.m_deployAll_button.setLayoutData((Object)new GridData(4, 128, false, false));
        this.m_deploySelected_button = this.m_gui.addButton(buttonComp, DEPLOY_SELECTED_BUTTON, "Trigger Selected", false, this);
        this.m_deploySelected_button.setLayoutData((Object)new GridData(4, 128, false, false));
        this.m_deployForAgent_button = this.m_gui.addButton(buttonComp, DEPLOY_AGENT_BUTTON, "Trigger For Agent ...", false, this);
        this.m_deployForAgent_button.setLayoutData((Object)new GridData(4, 128, false, false));
        this.m_cancelButton = this.m_gui.addButton(buttonComp, CANCEL_BUTTON, "Cancel Selected", false, this);
        this.m_cancelButton.setLayoutData((Object)new GridData(4, 128, false, false));
        tab.setControl((Control)compInTab);
        folder.setSelection(tab);
    }

    public void createDeploymentStatusTable(Composite parent) {
        CTabFolder folder = new CTabFolder(parent, 2816);
        folder.setLayoutData((Object)new GridData(4, 1024, false, false));
        folder.setSimple(false);
        folder.setBorderVisible(false);
        folder.setBackground(BMUI.color_unknown);
        CTabItem tab = new CTabItem(folder, 0);
        tab.setText("Running and Finished Deployments");
        Composite compInTab = new Composite((Composite)folder, 2048);
        GridLayout gl = new GridLayout(1, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        gl.verticalSpacing = 0;
        gl.horizontalSpacing = 0;
        compInTab.setLayout((Layout)gl);
        Composite tableComp = new Composite(compInTab, 0);
        tableComp.setLayout((Layout)gl);
        tableComp.setLayoutData((Object)new GridData(4, 4, true, true));
        Table tbl = new Table(tableComp, 268503810);
        tbl.setHeaderVisible(true);
        tbl.setLinesVisible(true);
        tbl.setBackground(BMUI.color_unknown);
        TableColumn col0 = new TableColumn(tbl, 16384);
        col0.setText(TYPE);
        col0.setWidth(40);
        col0.addListener(13, this.sortListener);
        TableColumn col1 = new TableColumn(tbl, 16384);
        col1.setText(SIZE);
        col1.setWidth(35);
        col1.setAlignment(131072);
        col1.addListener(13, this.sortListener);
        TableColumn col2 = new TableColumn(tbl, 16384);
        col2.setText(NAME);
        col2.setWidth(320);
        col2.addListener(13, this.sortListener);
        TableColumn col3 = new TableColumn(tbl, 16384);
        col3.setText(STATUS);
        col3.setWidth(120);
        col3.addListener(13, this.sortListener);
        TableColumn col4 = new TableColumn(tbl, 16384);
        col4.setText(ACTION);
        col4.setWidth(110);
        col4.addListener(13, this.sortListener);
        TableColumn col5 = new TableColumn(tbl, 16384);
        col5.setText(AGENT);
        col5.setWidth(120);
        col5.addListener(13, this.sortListener);
        TableColumn col6 = new TableColumn(tbl, 16384);
        col6.setText(START_TIME);
        col6.setWidth(120);
        col6.addListener(13, this.sortListener);
        TableColumn col7 = new TableColumn(tbl, 16384);
        col7.setText(EXPIRE_TIME);
        col7.setWidth(120);
        col7.addListener(13, this.sortListener);
        TableColumnLayout tableLayout = new TableColumnLayout();
        tableComp.setLayout((Layout)tableLayout);
        tableLayout.setColumnData((Widget)col0, (ColumnLayoutData)new ColumnWeightData(0, col0.getWidth()));
        tableLayout.setColumnData((Widget)col1, (ColumnLayoutData)new ColumnWeightData(0, col1.getWidth()));
        tableLayout.setColumnData((Widget)col2, (ColumnLayoutData)new ColumnWeightData(30, col2.getWidth()));
        tableLayout.setColumnData((Widget)col3, (ColumnLayoutData)new ColumnWeightData(0, col3.getWidth()));
        tableLayout.setColumnData((Widget)col4, (ColumnLayoutData)new ColumnWeightData(0, col4.getWidth()));
        tableLayout.setColumnData((Widget)col5, (ColumnLayoutData)new ColumnWeightData(30, col5.getWidth()));
        tableLayout.setColumnData((Widget)col6, (ColumnLayoutData)new ColumnWeightData(0, col6.getWidth()));
        tableLayout.setColumnData((Widget)col7, (ColumnLayoutData)new ColumnWeightData(40, col7.getWidth()));
        this.m_tableViewer_DeploymentsRunning = new TableViewer(tbl);
        this.m_tableViewer_DeploymentsRunning.setData(VIEWER_TYPE, (Object)DEPLOYMENTS_RUNNING_TABLE_VIEWER);
        this.m_tableProvider_deploymentsRunning = new RunningAssignmentsProvider();
        this.m_tableViewer_DeploymentsRunning.setContentProvider((IContentProvider)this.m_tableProvider_deploymentsRunning);
        this.m_tableViewer_DeploymentsRunning.setLabelProvider((IBaseLabelProvider)this.m_tableProvider_deploymentsRunning.labelProvider);
        this.m_tableViewer_DeploymentsRunning.setInput((Object)this.m_tableProvider_deploymentsRunning.getElements(null));
        TableSorter tableSorter = new TableSorter(START_TIME, 1024);
        this.m_tableViewer_DeploymentsRunning.setSorter((ViewerSorter)tableSorter);
        this.m_tableViewer_DeploymentsRunning.addSelectionChangedListener((ISelectionChangedListener)this);
        tbl.setData((Object)this.m_tableViewer_DeploymentsRunning);
        this.createContentMenu_status(this.m_tableViewer_DeploymentsRunning, tab);
        FancyToolTipSupport.enableFor((ColumnViewer)this.m_tableViewer_DeploymentsRunning, 2);
        tbl.setToolTipText("");
        Composite buttonComp = new Composite(compInTab, 0);
        gl = new GridLayout(1, false);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        buttonComp.setLayout((Layout)gl);
        GridData gd = new GridData(4, 1024, false, false);
        gd.minimumHeight = 50;
        buttonComp.setLayoutData((Object)gd);
        this.m_cancelButton2 = this.m_gui.addButton(buttonComp, CANCEL_BUTTON2, "Cancel Selected", false, this);
        this.m_cancelButton2.setLayoutData((Object)new GridData(4, 128, false, false));
        tab.setControl((Control)compInTab);
        folder.setSelection(tab);
    }

    public void createContentMenu_queue(final TableViewer tableViewer, final CTabItem tab) {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(false);
        Menu menu = menuMgr.createContextMenu(tableViewer.getControl());
        tableViewer.getControl().setMenu(menu);
        final IWorkbenchPartSite site = AssignmentsSummaryView.getInstance().getSite();
        site.registerContextMenu(menuMgr, (ISelectionProvider)tableViewer);
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                try {
                    Object o;
                    manager.add((IAction)new RefreshAssignSummaryTreeAction());
                    manager.add((IContributionItem)new Separator());
                    manager.add((IAction)new CancelDeploymentAction(tableViewer));
                    manager.add((IAction)new DeployFilteredAction(tableViewer));
                    manager.add((IContributionItem)new Separator());
                    manager.add((IAction)new TriggerDeploymentAction(AssignmentsSummaryView.this.m_tableProvider_deploymentQueue.getElements(null)));
                    manager.add((IAction)new TriggerDeploymentForAgents());
                    manager.add((IContributionItem)new Separator());
                    StructuredSelection ssel = (StructuredSelection)tableViewer.getSelection();
                    if (!ssel.isEmpty() && (o = ssel.getFirstElement()) instanceof Assignment) {
                        Assignment asn = (Assignment)o;
                        String type = asn.getType();
                        if (type.equals(BMUI.type_mon) || type.equals(BMUI.type_msg)) {
                            manager.add((IContributionItem)new Separator());
                            manager.add((IAction)new OpenPolicyAction(tableViewer, true));
                            manager.add((IAction)new SelectPolicyInTreeAction(tableViewer));
                            manager.add((IContributionItem)new Separator());
                        } else if (type.equals(BMUI.type_assignment_bin)) {
                            manager.add((IContributionItem)new Separator());
                            manager.add((IAction)new SelectBinaryInTreeAction(tableViewer));
                            manager.add((IContributionItem)new Separator());
                        }
                    }
                    manager.add((IContributionItem)new Separator());
                    manager.add((IAction)new AssignmentFilterAction(site.getWorkbenchWindow(), tableViewer, null, tab, false));
                    Iterator<AssignmentFilter> it = AssignmentFilterAction.getActiveFiltersIterator(tableViewer);
                    while (it.hasNext()) {
                        AssignmentFilter af = it.next();
                        if (af.getTableViewer() != tableViewer) continue;
                        AssignmentFilterAction action = new AssignmentFilterAction(site.getWorkbenchWindow(), tableViewer, af.toString(), tab, af.m_isActive);
                        action.setEnabled(!af.m_isLocked);
                        manager.add((IAction)action);
                    }
                }
                catch (RuntimeException runtimeException) {}
            }
        });
    }

    public void createContentMenu_status(final TableViewer tableViewer, final CTabItem tab) {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(false);
        Menu menu = menuMgr.createContextMenu(tableViewer.getControl());
        tableViewer.getControl().setMenu(menu);
        final IWorkbenchPartSite site = AssignmentsSummaryView.getInstance().getSite();
        site.registerContextMenu(menuMgr, (ISelectionProvider)tableViewer);
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                try {
                    manager.add((IAction)new RefreshAssignSummaryTreeAction());
                    manager.add((IAction)new CancelDeploymentAction(tableViewer));
                    manager.add((IContributionItem)new Separator());
                    manager.add((IAction)new AssignmentFilterAction(site.getWorkbenchWindow(), tableViewer, null, tab, false));
                    Iterator<AssignmentFilter> it = AssignmentFilterAction.getActiveFiltersIterator(tableViewer);
                    while (it.hasNext()) {
                        AssignmentFilter af = it.next();
                        if (af.getTableViewer() != tableViewer) continue;
                        AssignmentFilterAction action = new AssignmentFilterAction(site.getWorkbenchWindow(), tableViewer, af.toString(), tab, af.m_isActive);
                        action.setEnabled(!af.m_isLocked);
                        manager.add((IAction)action);
                    }
                }
                catch (RuntimeException runtimeException) {}
            }
        });
    }

    public AllAssignmentTableProvider getTableProvider_singleDeployed() {
        return this.m_tableProvider_singleDeployed;
    }

    public AllAssignmentTableProvider getTableProvider_deploymentQueue() {
        return this.m_tableProvider_deploymentQueue;
    }

    public RunningAssignmentsProvider getTableProvider_deploymentsRunning() {
        return this.m_tableProvider_deploymentsRunning;
    }

    public void setFocus() {
    }

    public void doubleClick(DoubleClickEvent event) {
        ISelection iSelect = event.getViewer().getSelection();
        Object obj = ((IStructuredSelection)iSelect).getFirstElement();
        if (event.getViewer().getData(VIEWER_TYPE).equals(ASSIGN_TREE_VIEWER)) {
            GroupTreeObjectLast gtol;
            Object o;
            if (obj instanceof GroupTreeObject && !(obj instanceof GroupTreeObjectLast)) {
                this.m_treeViewer_assign.setExpandedState((Object)((GroupTreeObject)obj), !this.m_treeViewer_assign.getExpandedState((Object)((GroupTreeObject)obj)));
            } else if (obj instanceof GroupTreeObjectLast && (o = (gtol = (GroupTreeObjectLast)obj).getTreeObject().getObject()) instanceof AgentCard) {
                AgentCard selAgentCard = (AgentCard)o;
                SelectAgentInTreeAction action = new SelectAgentInTreeAction(selAgentCard.getAgentID());
                action.run();
            }
        } else if (event.getViewer().getData(VIEWER_TYPE).equals(AGENT_TREE_VIEWER)) {
            if (obj instanceof GroupTreeObject && !(obj instanceof GroupTreeObjectLast)) {
                GroupTreeObject gto = (GroupTreeObject)obj;
                if (gto.getTreeObject().getType().equals(BMUI.type_assignment_bin)) {
                    if (Repository.getInstance().getRights(1006) <= 1) {
                        return;
                    }
                    GroupTreeObject root_bin = Repository.getInstance().getBinaryTree();
                    GroupTreeObject gto_bin = root_bin.findFirstGroupByName(gto.getName());
                    if (gto_bin != null) {
                        Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().activate((IWorkbenchPart)BinariesListView.getInstance());
                        Repository.getInstance().setBinariesTreeSelection(gto.getName());
                    }
                } else {
                    this.m_treeViewer_agentOverview.setExpandedState((Object)((GroupTreeObject)obj), !this.m_treeViewer_agentOverview.getExpandedState((Object)((GroupTreeObject)obj)));
                }
            } else if (obj instanceof GroupTreeObjectLast) {
                GroupTreeObjectLast gtol = (GroupTreeObjectLast)obj;
                ITreeObject treeObject = gtol.getTreeObject();
                if (treeObject.getType().equals(BMUI.type_mon) || treeObject.getType().equals(BMUI.type_msg)) {
                    if (Repository.getInstance().getRights(1001) <= 1) {
                        return;
                    }
                    PolicyTreeProvider.getInstance().setTreeSelection(treeObject.getName(), treeObject.getType());
                } else if (treeObject.getType().equals(BMUI.type_assignment_bin)) {
                    if (Repository.getInstance().getRights(1006) <= 1) {
                        return;
                    }
                    GroupTreeObject root_bin = Repository.getInstance().getBinaryTree();
                    GroupTreeObject gto_bin = root_bin.findFirstGroupByName(gtol.getName());
                    if (gto_bin != null) {
                        Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().activate((IWorkbenchPart)BinariesListView.getInstance());
                        Repository.getInstance().setBinariesTreeSelection(gtol.getName());
                    }
                }
            }
        } else if ((event.getViewer().getData(VIEWER_TYPE).equals(SINGLE_DEPLOYED_TABLE_VIEWER) || event.getViewer().getData(VIEWER_TYPE).equals(DEPLOYMENT_QUEUE_TABLE_VIEWER)) && obj instanceof Assignment) {
            Assignment asn = (Assignment)obj;
            if (asn.getType().equals(BMUI.type_mon) || asn.getType().equals(BMUI.type_msg)) {
                if (Repository.getInstance().getRights(1001) <= 1) {
                    return;
                }
                PolicyTreeProvider.getInstance().setTreeSelection(asn.getName(), asn.getType());
            } else if (asn.getType().equals(BMUI.type_assignment_bin)) {
                if (Repository.getInstance().getRights(1006) <= 1) {
                    return;
                }
                GroupTreeObject root_bin = Repository.getInstance().getBinaryTree();
                GroupTreeObject gto_bin = root_bin.findFirstGroupByName(asn.getName());
                if (gto_bin != null) {
                    Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().activate((IWorkbenchPart)BinariesListView.getInstance());
                    Repository.getInstance().setBinariesTreeSelection(asn.getName());
                }
            } else if (asn.getType().equals(BMUI.type_assignment_pol)) {
                if (Repository.getInstance().getRights(1008) <= 1) {
                    return;
                }
                GroupTreeObject root_asn = AssignmentTreeProvider.getInstance().createAssignmentTree();
                GroupTreeObject gto_asn = root_asn.findFirstGroupByName(asn.getName());
                if (gto_asn != null) {
                    Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().activate((IWorkbenchPart)AssignmentListView.getInstance());
                    Repository.getInstance().setAssignmentTreeSelection(root_asn, asn.getName());
                }
            }
        }
    }

    public void widgetDisposed(DisposeEvent e) {
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        Object o;
        Tree t;
        GroupTreeObject root;
        if (e.keyCode == 112 && e.stateMask == 262144) {
            Object o2 = e.getSource();
            Tree t2 = (Tree)o2;
            PrintJob job = new PrintJob("name", (Control)t2);
            if (job.showDialog()) {
                job.schedule();
            }
        } else if (e.keyCode == 101 && e.stateMask == 262144 && (root = (GroupTreeObject)(t = (Tree)(o = e.getSource())).getData()) != null) {
            ExportTreeAction export = new ExportTreeAction(root);
            export.run();
        }
    }

    public void refresh() {
        Object[] expanded = this.m_treeViewer_assign.getExpandedElements();
        RTLogger.print(6, "GAssignments 21");
        this.m_treeViewer_assign.setInput((Object)Repository.getInstance().getAllAssignments().getAllAssignmentRoot());
        int index = 0;
        while (index < expanded.length) {
            this.m_treeViewer_assign.setExpandedState(expanded[index], true);
            ++index;
        }
        RTLogger.print(6, "GAssignments 22");
        expanded = this.m_treeViewer_agentOverview.getExpandedElements();
        this.m_treeViewer_agentOverview.setInput((Object)Repository.getInstance().getAllAssignments().getAllAgentsRoot());
        index = 0;
        while (index < expanded.length) {
            this.m_treeViewer_agentOverview.setExpandedState(expanded[index], true);
            ++index;
        }
        RTLogger.print(6, "GAssignments 23");
        if (this.m_treeViewer_nodeGroup != null) {
            expanded = this.m_treeViewer_nodeGroup.getExpandedElements();
            this.m_treeViewer_nodeGroup.setInput((Object)Repository.getInstance().getAllAssignments().getAllNodeGroupsRoot());
            index = 0;
            while (index < expanded.length) {
                this.m_treeViewer_nodeGroup.setExpandedState(expanded[index], true);
                ++index;
            }
            RTLogger.print(6, "GAssignments 24");
        }
        this.m_tableViewer_singleDeployed.refresh();
        RTLogger.print(6, "GAssignments 25");
        this.m_tableViewer_DeploymentQueue.refresh();
        RTLogger.print(6, "GAssignments 26");
        this.refreshDeploymentButtons(this.m_tableViewer_DeploymentQueue);
        this.refreshRunningDeployments();
    }

    public void refreshRunningDeployments() {
        if (this.m_tableViewer_DeploymentsRunning != null) {
            this.m_tableViewer_DeploymentsRunning.refresh();
            this.refreshDeploymentButtons(this.m_tableViewer_DeploymentsRunning);
        }
    }

    public void refreshDeploymentButtons(TableViewer tv) {
        if (!this.m_hasDeploymentRights || tv == null) {
            return;
        }
        String type = (String)tv.getData(VIEWER_TYPE);
        if (type.equals(DEPLOYMENT_QUEUE_TABLE_VIEWER)) {
            if (tv.getTable().getItemCount() > 0) {
                this.m_gui.enableField(this.m_deployAll_button, true);
                this.m_gui.enableField(this.m_deployForAgent_button, true);
            } else {
                this.m_gui.enableField(this.m_deployAll_button, false);
                this.m_gui.enableField(this.m_deployForAgent_button, false);
            }
            int selCount = tv.getTable().getSelectionCount();
            if (selCount == 0) {
                this.m_gui.enableField(this.m_cancelButton, false);
                this.m_gui.enableField(this.m_deploySelected_button, false);
            } else if (selCount == 1) {
                this.m_gui.enableField(this.m_cancelButton, true);
                this.m_gui.enableField(this.m_deploySelected_button, true);
            } else if (selCount > 1) {
                this.m_gui.enableField(this.m_cancelButton, true);
                this.m_gui.enableField(this.m_deploySelected_button, true);
            }
        } else if (type.equals(DEPLOYMENTS_RUNNING_TABLE_VIEWER)) {
            int selCount = tv.getTable().getSelectionCount();
            if (selCount == 0) {
                this.m_gui.enableField(this.m_cancelButton2, false);
            } else {
                this.m_gui.enableField(this.m_cancelButton2, true);
            }
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.getSource() instanceof Button) {
            Button b = (Button)e.getSource();
            String name = (String)b.getData();
            if (name.equals(DEPLOY_ALL_BUTTON)) {
                TriggerDeploymentAction action = new TriggerDeploymentAction(this.m_tableProvider_deploymentQueue.getElements(null));
                action.run();
            } else if (name.equals(DEPLOY_SELECTED_BUTTON)) {
                DeployFilteredAction action = new DeployFilteredAction(this.m_tableViewer_DeploymentQueue);
                action.run();
            } else if (name.equals(DEPLOY_AGENT_BUTTON)) {
                TriggerDeploymentForAgents action = new TriggerDeploymentForAgents();
                action.run();
            } else if (name.equals(CANCEL_BUTTON)) {
                CancelDeploymentAction cancelAction = new CancelDeploymentAction(this.m_tableViewer_DeploymentQueue);
                cancelAction.run();
                this.m_gui.enableField(this.m_cancelButton, false);
            } else if (name.equals(CANCEL_BUTTON2)) {
                if (this.m_tableViewer_DeploymentsRunning != null) {
                    CancelDeploymentAction cancelAction = new CancelDeploymentAction(this.m_tableViewer_DeploymentsRunning);
                    cancelAction.run();
                    this.m_gui.enableField(this.m_cancelButton2, false);
                }
            } else if (name.equals("TEST")) {
                this.toggleNGTree(!this.isNGTreeActive());
            }
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        TableViewer tv = (TableViewer)event.getSource();
        String type = (String)tv.getData(VIEWER_TYPE);
        if (type.equals(DEPLOYMENT_QUEUE_TABLE_VIEWER) || type.equals(DEPLOYMENTS_RUNNING_TABLE_VIEWER)) {
            this.refreshDeploymentButtons(tv);
        } else {
            this.m_gui.enableField(this.m_deployAll_button, false);
            this.m_gui.enableField(this.m_deploySelected_button, false);
            this.m_gui.enableField(this.m_deployForAgent_button, false);
            this.m_gui.enableField(this.m_cancelButton, false);
        }
    }

    public class TriggerDeploymentForAgents
    extends Action {
        public TriggerDeploymentForAgents() {
            super("TriggerDeploymentForAgents");
            this.setText("Trigger Deployment For Agent ...");
            this.setId("TriggerDeploymentForAgent");
            StructuredSelection ssel = (StructuredSelection)AssignmentsSummaryView.this.m_tableViewer_DeploymentQueue.getSelection();
            if (ssel == null || ssel.isEmpty()) {
                this.setEnabled(false);
            }
        }

        public void run() {
            if (!this.isEnabled()) {
                return;
            }
            List<AgentCard> agents = null;
            AgentTreeDialog atd = new AgentTreeDialog(Display.getCurrent().getActiveShell(), "  Deploy on ...");
            atd.setBlockOnOpen(true);
            try {
                atd.open();
            }
            catch (RuntimeException runtimeException) {}
            agents = atd.getSelectedAgentCards(true);
            if (agents.size() == 0) {
                if (atd.getSelectedAgentCards(false).size() > 0) {
                    new ShowMessageBox("Error", "Selected Agents are read-only", 8);
                }
                return;
            }
            String title = "    Agent";
            String header = "Do you want to Trigger Deployments for following Agent:";
            String footer = String.valueOf(agents.size()) + " Agents selected";
            String noElementText = "No Agents selected";
            ShowMessageDialog md = new ShowMessageDialog(new Shell(Display.getCurrent().getActiveShell()), title, header, footer, true, "OK", agents, noElementText, ShowMessageDialog.TYPE_LIST_WITH_IMAGES);
            md.setBlockOnOpen(true);
            md.open();
            if (md.getReturnCode() == 0) {
                TriggerDeploymentAction action = new TriggerDeploymentAction(agents);
                action.run();
            }
        }
    }
}

