/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views;

import com.blixx.boom.editors.OpenFileAction;
import com.blixx.boom.editors.SimpleEditor;
import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.engine.UIJob;
import com.blixx.boom.gui.Activator;
import com.blixx.boom.gui.policies.ViewContentProvider;
import com.blixx.boom.gui.policies.ViewLabelProvider;
import com.blixx.boom.gui.utils.FilterComposite;
import com.blixx.boom.gui.utils.STreeViewer;
import com.blixx.boom.gui.utils.TreeElementComparer;
import com.blixx.boom.gui.views.actions.AssignToNodeAction;
import com.blixx.boom.gui.views.actions.CreateFileAction;
import com.blixx.boom.gui.views.actions.CreateFolderAction;
import com.blixx.boom.gui.views.actions.DeleteBinaryAction;
import com.blixx.boom.gui.views.actions.DeleteFileAction;
import com.blixx.boom.gui.views.actions.DeleteFolderAction;
import com.blixx.boom.gui.views.actions.ExpandCollapseAction;
import com.blixx.boom.gui.views.actions.PushBinPackagesOnProxies;
import com.blixx.boom.gui.views.actions.RedeployAction;
import com.blixx.boom.gui.views.actions.RenameFileAction;
import com.blixx.boom.gui.views.actions.RenamePkgAction;
import com.blixx.boom.gui.views.actions.ShowRelatedBinaryInfosAction;
import com.blixx.boom.gui.views.actions.UploadFileAction;
import com.blixx.boom.gui.views.dnd.DNDCutCopyBinaryAction;
import com.blixx.boom.gui.views.dnd.DNDPasteToBinaryTreeAction;
import com.blixx.boom.gui.views.dnd.DNDShare;
import com.blixx.boom.gui.views.dnd.DNDSourceBinariesTreeProcessor;
import com.blixx.boom.gui.views.dnd.DNDTreeIconManager;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.GroupTreeObjectLast;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.part.ViewPart;

public class BinariesListView
extends ViewPart
implements IDoubleClickListener {
    public static String TREE_VIEWER_TYPE = "TREE_VIEWER_TYPE";
    public static final int VIEW_ID = 1006;
    public static final String ID = "com.blixx.boom.gui.views.binlistview";
    public static BinariesListView m_blv = null;
    private Shell m_parentShell = null;
    private STreeViewer viewer;
    private Clipboard m_clipboard = null;
    private DNDTreeIconManager m_treeIconManager = null;

    public static BinariesListView getInstance() {
        return m_blv;
    }

    public BinariesListView() {
        m_blv = this;
    }

    public void createPartControl(Composite parent) {
        if (Repository.getInstance().getRights(1006) <= 1) {
            parent.setLayout((Layout)new GridLayout(2, false));
            Label l = new Label(parent, 0);
            l.setText(" Insufficient rights.");
            l.setForeground(BMUI.color_critical);
            Button close = new Button(parent, 8);
            close.setText("Close");
            close.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    BinariesListView.this.getSite().getPage().hideView(BinariesListView.this.getSite().getPage().findView(BinariesListView.ID));
                }
            });
            UIJob uiJob = new UIJob("Close Viewcom.blixx.boom.gui.views.binlistview"){

                @Override
                public IStatus runInUIThread(IProgressMonitor monitor) {
                    BinariesListView.this.getSite().getPage().hideView(BinariesListView.this.getSite().getPage().findView(BinariesListView.ID));
                    return Status.OK_STATUS;
                }
            };
            Repository.getUIJobManager().schedule(uiJob);
            return;
        }
        this.m_parentShell = parent.getShell();
        this.m_clipboard = new Clipboard(Display.getCurrent());
        this.m_treeIconManager = new DNDTreeIconManager();
        parent.setLayout((Layout)new GridLayout(1, false));
        new FilterComposite(parent, (Object)this);
        this.viewer = new STreeViewer(parent, 268438274);
        this.viewer.setData(TREE_VIEWER_TYPE, "Packages");
        this.viewer.getTree().setLayoutData((Object)new GridData(4, 4, true, true));
        this.viewer.setComparer(new TreeElementComparer());
        this.viewer.setUseHashlookup(true);
        this.viewer.setContentProvider((IContentProvider)new ViewContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider(null, null));
        this.viewer.setInput(Repository.getInstance().getBinaryTree());
        this.viewer.setAutoExpandLevel(2);
        this.viewer.expandToLevel(2);
        this.viewer.addDoubleClickListener(this);
        Transfer[] types = new Transfer[]{LocalSelectionTransfer.getTransfer()};
        this.viewer.addDragSupport(4, types, new DNDSourceBinariesTreeProcessor(this.viewer));
        this.viewer.getTree().addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                if (e.stateMask == 262144) {
                    DNDPasteToBinaryTreeAction pasteAction;
                    if (e.keyCode == 120) {
                        DNDCutCopyBinaryAction cutAction = new DNDCutCopyBinaryAction(BinariesListView.this.viewer, DNDShare.DND_CUT, BinariesListView.this.m_clipboard);
                        if (cutAction.isEnabled()) {
                            cutAction.run();
                        }
                    } else if (e.keyCode == 99) {
                        DNDCutCopyBinaryAction copyAction = new DNDCutCopyBinaryAction(BinariesListView.this.viewer, DNDShare.DND_COPY, BinariesListView.this.m_clipboard);
                        if (copyAction.isEnabled()) {
                            copyAction.run();
                        }
                    } else if (e.keyCode == 118 && (pasteAction = new DNDPasteToBinaryTreeAction(m_blv.getSite().getWorkbenchWindow(), BinariesListView.this.viewer, BinariesListView.this.m_clipboard)).isEnabled()) {
                        pasteAction.run();
                    }
                }
                if (e.keyCode == 27) {
                    String DNDType = (String)BinariesListView.this.m_clipboard.getContents((Transfer)TextTransfer.getInstance());
                    BinariesListView.this.m_treeIconManager.restoreBinaryTreeIcons((Object)BinariesListView.this.viewer, DNDType);
                    BinariesListView.this.m_clipboard.clearContents();
                    DNDShare.getInstance().clearDNDBinaryObjects();
                }
            }
        });
        IWorkbenchPartSite part = this.getSite();
        part.setSelectionProvider((ISelectionProvider)this.viewer);
        this.createContentMenu();
        this.setTitleImage(BMUI.IMAGE_PKG);
    }

    public void setFocus() {
    }

    public void createContentMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                try {
                    manager.add((IAction)new Action(){

                        public String getText() {
                            return "Refresh";
                        }

                        public ImageDescriptor getImageDescriptor() {
                            return BMUI.IMAGE_DESCR_REFRESH;
                        }

                        public void run() {
                            BinariesListView.this.refreshTree(true);
                        }
                    });
                    manager.add((IContributionItem)new Separator());
                    StructuredSelection ssel = (StructuredSelection)BinariesListView.this.viewer.getSelection();
                    if (!ssel.isEmpty()) {
                        GroupTreeObject o = (GroupTreeObject)ssel.getFirstElement();
                        if (!o.getPath().equals("/root/Packages")) {
                            if (o instanceof GroupTreeObject && !(o instanceof GroupTreeObjectLast)) {
                                GroupTreeObject gto = o;
                                String path = gto.getPath();
                                path = path.replace("/root/Packages", "");
                                if (gto.getType().equals(BMUI.type_assignment_bin)) {
                                    manager.add((IAction)new AssignToNodeAction(BinariesListView.this.viewer, "DEPLOY"));
                                    manager.add((IAction)new RedeployAction(BinariesListView.this.viewer, "DEPLOY"));
                                    manager.add((IAction)new AssignToNodeAction(BinariesListView.this.viewer, "DEPLOY_DELAYED"));
                                    manager.add((IAction)new RedeployAction(BinariesListView.this.viewer, "DEPLOY_DELAYED"));
                                    manager.add((IAction)new AssignToNodeAction(BinariesListView.this.viewer, "DEPLOY_VIRTUAL"));
                                    manager.add((IAction)new AssignToNodeAction(BinariesListView.this.viewer, "UNDEPLOY"));
                                    manager.add((IAction)new RedeployAction(BinariesListView.this.viewer, "UNDEPLOY"));
                                    manager.add((IContributionItem)new Separator());
                                    manager.add((IAction)new RenamePkgAction(ssel, path, gto.getName(), "Rename Package"));
                                    manager.add((IAction)new DeleteBinaryAction(m_blv, BinariesListView.this.viewer));
                                    manager.add((IContributionItem)new Separator());
                                    manager.add((IAction)new CreateFolderAction(ssel, path, "Create Folder", gto));
                                    manager.add((IAction)new CreateFileAction(path, gto));
                                    manager.add((IAction)new UploadFileAction(path));
                                    manager.add((IContributionItem)new Separator());
                                } else {
                                    manager.add((IAction)new CreateFolderAction(ssel, path, "Create Folder", gto));
                                    manager.add((IAction)new RenamePkgAction(ssel, path, gto.getName(), "Rename Folder"));
                                    manager.add((IAction)new DeleteFolderAction(ssel));
                                    manager.add((IContributionItem)new Separator());
                                    manager.add((IAction)new CreateFileAction(path, gto));
                                    manager.add((IAction)new UploadFileAction(path));
                                    manager.add((IContributionItem)new Separator());
                                }
                                manager.add((IAction)new DNDPasteToBinaryTreeAction(m_blv.getSite().getWorkbenchWindow(), BinariesListView.this.viewer, BinariesListView.this.m_clipboard));
                                if (gto.getType().equals(BMUI.type_assignment_bin)) {
                                    manager.add((IContributionItem)new Separator());
                                    manager.add((IAction)new PushBinPackagesOnProxies(ssel));
                                    manager.add((IContributionItem)new Separator());
                                    manager.add((IAction)new ShowRelatedBinaryInfosAction(ssel, BinariesListView.this.m_parentShell));
                                }
                            } else {
                                GroupTreeObjectLast gtol = (GroupTreeObjectLast)o;
                                String parentPath = gtol.getParentPath();
                                parentPath = parentPath.replace("/root/Packages", "");
                                manager.add((IAction)new CreateFileAction(parentPath, gtol.getParent()));
                                String path = gtol.getPath();
                                path = path.replace("/root/Packages", "");
                                manager.add((IAction)new OpenFileAction(m_blv.getSite().getWorkbenchWindow(), ssel));
                                manager.add((IAction)new RenameFileAction(ssel, path, gtol));
                                manager.add((IAction)new DeleteFileAction(m_blv.getSite().getWorkbenchWindow(), ssel));
                                manager.add((IContributionItem)new Separator());
                                manager.add((IAction)new DNDCutCopyBinaryAction(BinariesListView.this.viewer, DNDShare.DND_CUT_BINARY_FILE, BinariesListView.this.m_clipboard));
                            }
                        } else {
                            manager.add((IAction)new CreateFolderAction(ssel, "", "Add Binary Package", o));
                        }
                    }
                    manager.add((IContributionItem)new Separator());
                    manager.add((IAction)new ExpandCollapseAction(BinariesListView.this.viewer, "ExpandAll"));
                    manager.add((IAction)new ExpandCollapseAction(BinariesListView.this.viewer, "CollapseAll"));
                }
                catch (RuntimeException runtimeException) {}
            }
        });
    }

    public TreeViewer getTreeViewer() {
        return this.viewer;
    }

    public void doubleClick(DoubleClickEvent event) {
        ISelection iSelect = event.getViewer().getSelection();
        int size = ((IStructuredSelection)iSelect).size();
        if (size == 1) {
            Object obj = ((IStructuredSelection)iSelect).getFirstElement();
            if (obj instanceof GroupTreeObjectLast) {
                Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().activate((IWorkbenchPart)new SimpleEditor());
                GroupTreeObjectLast gtol = (GroupTreeObjectLast)obj;
                OpenFileAction openFile = new OpenFileAction(m_blv.getSite().getWorkbenchWindow(), gtol);
                openFile.run();
            } else if (obj instanceof GroupTreeObject) {
                this.viewer.setExpandedState((GroupTreeObject)obj, !this.viewer.getExpandedState((GroupTreeObject)obj));
            }
        }
    }

    public void refreshTree(boolean fetchFile) {
        Object[] expanded = this.viewer.getExpandedElements();
        if (fetchFile) {
            GroupTreeObject bt = Repository.getInstance().createBinariesTree();
            this.viewer.setInput(bt);
        } else {
            this.viewer.refresh();
        }
        if (expanded == null || expanded.length == 0) {
            this.viewer.expandToLevel(2);
        } else {
            this.viewer.setExpandedElements(expanded);
        }
    }
}

