/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.gui.utils.GUIDisplayElements;
import com.blixx.boom.gui.views.BrowserView;
import com.blixx.log.RTLogger;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.CloseWindowListener;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.browser.StatusTextEvent;
import org.eclipse.swt.browser.StatusTextListener;
import org.eclipse.swt.browser.TitleEvent;
import org.eclipse.swt.browser.TitleListener;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;

public class BrowserTab
extends CTabItem
implements DisposeListener {
    private BrowserView m_browserView = null;
    private CTabFolder m_folder = null;
    public static String URL = "URL";
    public static String BACK = "Back";
    public static String FORWARD = "Forward";
    public static String REFRESH = "Refresh";
    public static String HISTORY = "History";
    public static String HOME = "Home";
    public static String BROWSER = "BROWSER";
    public static String GO = "Open URL";
    public static String STOP = "STOP";
    private String m_url = null;
    private String m_home = null;
    private List<String> m_history = null;
    private int m_index = 0;
    private ToolItem m_back;
    private ToolItem m_forward;
    private Text m_url_field = null;
    private Text m_progress_field = null;
    private Text m_status_field = null;
    private Browser m_browser = null;
    private DropdownSelectionListener m_historyListener = null;

    public BrowserTab(CTabFolder parent, int style, int index, String url) {
        super(parent, style, index);
        this.m_folder = parent;
        this.m_browserView = BrowserView.getInstance();
        this.m_history = new ArrayList<String>();
        if (url == null) {
            this.m_home = "";
            this.setText(BrowserView.NEW_TAB);
        } else {
            this.m_home = url;
            this.setText(this.m_home);
        }
        this.m_url = this.m_home;
        this.setData(HOME, this.m_home);
        this.addDisposeListener(this);
        this.setImage(BMUI.IMAGE_BROWSER);
        this.createContent();
    }

    private void createContent() {
        GUIDisplayElements gui = new GUIDisplayElements();
        Composite compInCTab = new Composite((Composite)this.m_folder, 0);
        GridLayout gl = new GridLayout(3, false);
        gl.horizontalSpacing = 0;
        gl.verticalSpacing = 0;
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        gl.marginTop = 5;
        compInCTab.setLayout((Layout)gl);
        compInCTab.setLayoutData((Object)new GridData(4, 4, true, true));
        try {
            ToolBar navBar_left = new ToolBar(compInCTab, 0);
            gl = new GridLayout(4, false);
            gl.horizontalSpacing = 0;
            navBar_left.setLayout((Layout)gl);
            navBar_left.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
            this.m_back = new ToolItem(navBar_left, 8);
            this.m_back.setData((Object)BACK);
            this.m_back.setImage(BMUI.IMAGE_BROWSER_BACK);
            this.m_back.setToolTipText(BACK);
            this.m_back.setEnabled(false);
            this.m_back.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    BrowserTab.this.browserBack();
                }
            });
            this.m_forward = new ToolItem(navBar_left, 8);
            this.m_forward.setData((Object)FORWARD);
            this.m_forward.setImage(BMUI.IMAGE_BROWSER_FORWARD);
            this.m_forward.setToolTipText(FORWARD);
            this.m_forward.setEnabled(false);
            this.m_forward.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    BrowserTab.this.browserForward();
                }
            });
            ToolItem home = new ToolItem(navBar_left, 8);
            home.setData((Object)HOME);
            home.setImage(BMUI.IMAGE_BROWSER_HOME);
            home.setToolTipText(this.m_home);
            home.setEnabled(true);
            home.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    BrowserTab.this.browserHome();
                }
            });
            ToolItem refresh = new ToolItem(navBar_left, 8);
            refresh.setData((Object)REFRESH);
            refresh.setImage(BMUI.IMAGE_BROWSER_REFRESH);
            refresh.setToolTipText(REFRESH);
            refresh.setEnabled(true);
            refresh.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    BrowserTab.this.browserRefresh();
                }
            });
            ToolItem history = new ToolItem(navBar_left, 4);
            history.setData((Object)HISTORY);
            history.setImage(BMUI.IMAGE_BROWSER_HISTORY);
            history.setToolTipText(HISTORY);
            history.setEnabled(true);
            this.m_historyListener = new DropdownSelectionListener(history);
            history.addSelectionListener((SelectionListener)this.m_historyListener);
            this.m_url_field = gui.addInputFieldSingle(compInCTab, URL, null, this.m_home, 1, 1, 0, 0, 60, null);
            this.m_url_field.addKeyListener(new KeyListener(){

                public void keyReleased(KeyEvent e) {
                    if (e.character == '\r' || e.keyCode == 13 || e.keyCode == 0x1000050) {
                        BrowserTab.this.browserGo();
                    }
                }

                public void keyPressed(KeyEvent e) {
                }
            });
            ToolBar navBar_right = new ToolBar(compInCTab, 0);
            navBar_right.setLayout((Layout)new GridLayout(2, false));
            navBar_right.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
            ToolItem go = new ToolItem(navBar_right, 8);
            go.setData((Object)GO);
            go.setImage(BMUI.IMAGE_RUN);
            go.setToolTipText(GO);
            go.setEnabled(true);
            go.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    BrowserTab.this.browserGo();
                }
            });
            ToolItem stop = new ToolItem(navBar_right, 8);
            stop.setData((Object)STOP);
            stop.setImage(BMUI.IMAGE_DEL);
            stop.setToolTipText(STOP);
            stop.setEnabled(true);
            stop.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    BrowserTab.this.browserStop();
                }
            });
            Composite browserComp = new Composite(compInCTab, 0);
            gl = new GridLayout(1, false);
            gl.verticalSpacing = 0;
            gl.horizontalSpacing = 0;
            gl.marginTop = 5;
            browserComp.setLayout((Layout)gl);
            browserComp.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
            try {
                this.m_browser = new Browser(browserComp, 64);
            }
            catch (Error e) {
                RTLogger.print(3, e.getMessage());
                try {
                    RTLogger.print(3, "try to open link in integrated browser ....");
                    this.m_browser = new Browser(browserComp, 32832);
                }
                catch (Error e1) {
                    navBar_left.dispose();
                    browserComp.setLayout((Layout)new GridLayout(2, false));
                    Label l = new Label(browserComp, 0);
                    l.setImage(BMUI.IMAGE_CANCEL_ROUND);
                    Label l1 = new Label(browserComp, 0);
                    l1.setText("Browser initialization failed.");
                    l1.setForeground(BMUI.color_critical);
                    new Label(browserComp, 0);
                    Text text = new Text(browserComp, 0);
                    text.setText("Please use external browser: " + HOME);
                    text.setEditable(false);
                    throw e1;
                }
            }
            this.m_browser.setLayoutData((Object)new GridData(4, 4, true, true));
            this.m_browser.addLocationListener(new LocationListener(){

                public void changing(LocationEvent event) {
                    if (event.top) {
                        BrowserTab.this.m_url_field.setText("Loading " + event.location + "...");
                    }
                }

                public void changed(LocationEvent event) {
                    if (event.top) {
                        BrowserTab.this.m_url = event.location;
                        if (BrowserTab.this.m_history.isEmpty()) {
                            BrowserTab.this.m_index = 1;
                            BrowserTab.this.m_url_field.setText(BrowserTab.this.m_url);
                            BrowserTab.this.m_home = BrowserTab.this.m_url;
                            BrowserTab.this.setData(HOME, BrowserTab.this.m_home);
                            BrowserTab.this.addToHistory(BrowserTab.this.m_url);
                            BrowserTab.this.refreshBtnStatus();
                        } else {
                            String lastURL = (String)BrowserTab.this.m_history.get(BrowserTab.this.m_history.size() - 1);
                            if (!BrowserTab.this.m_url.equals(lastURL)) {
                                BrowserTab.this.m_url_field.setText(BrowserTab.this.m_url);
                                BrowserTab.this.addToHistory(BrowserTab.this.m_url);
                                BrowserTab.this.refreshBtnStatus();
                            }
                        }
                    }
                }
            });
            this.m_browser.addProgressListener(new ProgressListener(){

                public void completed(ProgressEvent event) {
                    BrowserTab.this.m_progress_field.setText("Completed");
                }

                public void changed(ProgressEvent event) {
                    if (event.total != 0) {
                        int percent = event.current / event.total;
                        BrowserTab.this.m_progress_field.setText(String.valueOf(percent) + "%");
                    } else {
                        BrowserTab.this.m_progress_field.setText("");
                    }
                }
            });
            this.m_browser.addTitleListener(new TitleListener(){

                public void changed(TitleEvent event) {
                    String title = event.title;
                    if (!title.equals("about:blank")) {
                        if (title.length() > 30) {
                            title = String.valueOf(title.substring(0, 29)) + "...";
                        }
                        BrowserTab.this.setText(title);
                    }
                }
            });
            this.m_browser.addStatusTextListener(new StatusTextListener(){

                public void changed(StatusTextEvent event) {
                    BrowserTab.this.m_status_field.setText(event.text);
                }
            });
            this.m_browser.addCloseWindowListener(new CloseWindowListener(){

                public void close(WindowEvent event) {
                    ((Browser)event.widget).getShell().close();
                }
            });
            if (this.m_home.equals("")) {
                this.setText(BrowserView.NEW_TAB);
            } else {
                this.m_browser.setUrl(this.m_home);
            }
            Composite statusLineComp = new Composite(compInCTab, 0);
            gl = new GridLayout(2, false);
            gl.marginHeight = 0;
            statusLineComp.setLayout((Layout)gl);
            statusLineComp.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
            this.m_status_field = gui.addTextReadOnlyNoBorder(statusLineComp, null, "", 1, 1, 0, 0, null);
            ((GridData)this.m_status_field.getLayoutData()).horizontalAlignment = 4;
            ((GridData)this.m_status_field.getLayoutData()).grabExcessHorizontalSpace = true;
            this.m_progress_field = gui.addTextReadOnlyNoBorder(statusLineComp, null, "", 1, 1, 0, 0, null);
            ((GridData)this.m_progress_field.getLayoutData()).horizontalAlignment = 131072;
            ((GridData)this.m_progress_field.getLayoutData()).horizontalIndent = 10;
        }
        catch (SWTError sWTError) {}
        this.setControl((Control)compInCTab);
    }

    public String getCurrentURL() {
        return this.m_url;
    }

    public void browserGo() {
        this.browserGo(this.m_url_field.getText().trim());
    }

    public void browserGo(String url) {
        this.m_url = url;
        if (this.m_history.size() > 0 && this.m_history.get(this.m_history.size() - 1).equals(this.m_url)) {
            this.browserRefresh();
        } else {
            ++this.m_index;
            this.m_browser.setUrl(this.m_url);
        }
    }

    public void browserHome() {
        this.browserGo(this.m_home);
    }

    public void browserBack() {
        this.m_browser.back();
        --this.m_index;
    }

    public void browserForward() {
        this.m_browser.forward();
        ++this.m_index;
    }

    public void browserStop() {
        this.m_browser.stop();
    }

    public void browserRefresh() {
        this.m_browser.refresh();
        this.m_url_field.setText(this.m_url);
    }

    public void addToHistory(String url) {
        this.m_historyListener.add(url);
        this.m_history.add(url);
    }

    private void refreshBtnStatus() {
        if (this.m_index > 1) {
            this.m_back.setEnabled(true);
        } else {
            this.m_back.setEnabled(false);
        }
        if (this.m_index < this.m_history.size()) {
            this.m_forward.setEnabled(true);
        } else {
            this.m_forward.setEnabled(false);
        }
    }

    public void widgetDisposed(DisposeEvent e) {
        CTabItem tab = (CTabItem)e.getSource();
        try {
            tab.getControl().dispose();
        }
        catch (Throwable throwable) {}
        try {
            tab.dispose();
        }
        catch (Throwable throwable) {}
        CTabItem[] items = this.m_folder.getItems();
        if (items.length == 0) {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().hideView((IViewPart)this.m_browserView);
        }
    }

    class DropdownSelectionListener
    extends SelectionAdapter {
        private ToolItem dropdown;
        private Menu menu;

        public DropdownSelectionListener(ToolItem dropdown) {
            this.dropdown = dropdown;
            this.menu = new Menu((Control)dropdown.getParent().getShell());
        }

        public void add(String item) {
            MenuItem menuItem = new MenuItem(this.menu, 0);
            menuItem.setText(item);
            menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    String url = ((MenuItem)event.widget).getText();
                    BrowserTab.this.browserGo(url);
                }
            });
        }

        public void widgetSelected(SelectionEvent event) {
            if (event.detail == 4) {
                ToolItem item = (ToolItem)event.widget;
                Rectangle rect = item.getBounds();
                Point pt = item.getParent().toDisplay(new Point(rect.x, rect.y));
                this.menu.setLocation(pt.x, pt.y + rect.height);
                this.menu.setVisible(true);
            }
        }
    }
}

