/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.gui.settings.UISettings;
import com.blixx.boom.gui.views.BrowserTab;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolder2Listener;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.part.ViewPart;

public class BrowserView
extends ViewPart
implements CTabFolder2Listener,
MenuListener,
Listener {
    public static final int VIEW_ID = 2005;
    public static final String ID = "com.blixx.boom.gui.views.browserview";
    private static BrowserView m_instance = null;
    public static CTabFolder m_folder = null;
    private Composite m_parent = null;
    public static String NEW_TAB = "New Tab";
    public static String REFRESH = "Refresh";
    public static String CLOSE_OTHERS = "Close Others";
    public static String CLOSE = "Close";

    public BrowserView() {
        m_instance = this;
    }

    public static BrowserView getInstance() {
        return m_instance;
    }

    public void createPartControl(Composite parent) {
        BrowserView.m_instance.m_parent = parent;
        BrowserView.createFolder();
        this.setTitleImage(BMUI.IMAGE_BROWSER);
        UISettings.getInstance().createPredefinedAndUserWBTabs(this, m_folder);
    }

    public static void createFolder() {
        m_folder = new CTabFolder(BrowserView.m_instance.m_parent, 2816);
        m_folder.setSimple(false);
        m_folder.setMinimizeVisible(false);
        m_folder.setMaximizeVisible(false);
        m_folder.setBorderVisible(false);
        m_folder.setBackground(BMUI.color_unknown);
        m_folder.addCTabFolder2Listener((CTabFolder2Listener)m_instance);
        m_folder.addListener(35, new Listener(){

            public void handleEvent(Event event) {
                Point point = m_folder.getDisplay().map(null, (Control)m_folder, new Point(event.x, event.y));
                CTabItem cTab = m_folder.getItem(point);
                if (cTab != null && cTab instanceof BrowserTab) {
                    BrowserTab tab = (BrowserTab)cTab;
                    m_folder.setSelection((CTabItem)tab);
                }
            }
        });
        BrowserView.createContentMenu();
    }

    public static void createContentMenu() {
        Menu menu = new Menu((Control)m_folder);
        menu.addMenuListener((MenuListener)m_instance);
        MenuItem mi = new MenuItem(menu, -1);
        mi.setText(NEW_TAB);
        mi.setData((Object)NEW_TAB);
        mi.addListener(13, (Listener)m_instance);
        new MenuItem(menu, 2);
        mi = new MenuItem(menu, -1);
        mi.setText(REFRESH);
        mi.setData((Object)REFRESH);
        mi.addListener(13, (Listener)m_instance);
        new MenuItem(menu, 2);
        mi = new MenuItem(menu, -1);
        mi.setText(CLOSE);
        mi.setData((Object)CLOSE);
        mi.addListener(13, (Listener)m_instance);
        mi = new MenuItem(menu, -1);
        mi.setText(CLOSE_OTHERS);
        mi.setData((Object)CLOSE_OTHERS);
        mi.addListener(13, (Listener)m_instance);
        m_folder.setMenu(menu);
    }

    public static void openBrowser(String startURL, int index) {
        BrowserTab tab;
        if (index < 0) {
            index = m_folder.getItemCount();
        }
        if ((tab = new BrowserTab(m_folder, 64, index, startURL)) != null && !tab.isDisposed()) {
            m_folder.setSelection((CTabItem)tab);
        }
    }

    public void setFocus() {
    }

    public void close(CTabFolderEvent event) {
    }

    public void minimize(CTabFolderEvent event) {
        m_folder.setMinimized(true);
        BrowserView.m_instance.m_parent.layout(true);
    }

    public void maximize(CTabFolderEvent event) {
        m_folder.setMaximized(true);
        m_folder.setLayoutData((Object)new GridData(4, 4, true, true));
        BrowserView.m_instance.m_parent.layout(true);
    }

    public void restore(CTabFolderEvent event) {
        m_folder.setMinimized(false);
        m_folder.setMaximized(false);
        m_folder.setLayoutData((Object)new GridData(4, 4, true, false));
        BrowserView.m_instance.m_parent.layout(true);
    }

    public void showList(CTabFolderEvent event) {
    }

    public void menuHidden(MenuEvent e) {
    }

    public void menuShown(MenuEvent e) {
        block12: {
            int cTabCount;
            MenuItem[] mi;
            block11: {
                Menu menu = (Menu)e.getSource();
                mi = menu.getItems();
                cTabCount = m_folder.getItemCount();
                if (cTabCount == 0) {
                    int index = 0;
                    while (index < mi.length) {
                        String action = (String)mi[index].getData();
                        if (action != null) {
                            if (action.equals(NEW_TAB)) {
                                mi[index].setEnabled(true);
                            } else {
                                mi[index].setEnabled(false);
                            }
                        }
                        ++index;
                    }
                    return;
                }
                if (cTabCount != 1) break block11;
                int index = 0;
                while (index < mi.length) {
                    String action = (String)mi[index].getData();
                    if (action != null) {
                        if (action.equals(NEW_TAB) || action.equals(REFRESH)) {
                            mi[index].setEnabled(true);
                        } else {
                            mi[index].setEnabled(false);
                        }
                    }
                    ++index;
                }
                break block12;
            }
            if (cTabCount <= 1) break block12;
            int index = 0;
            while (index < mi.length) {
                String action = (String)mi[index].getData();
                if (action != null) {
                    mi[index].setEnabled(true);
                }
                ++index;
            }
        }
    }

    public void handleEvent(Event event) {
        String menuAction = (String)event.widget.getData();
        CTabItem[] openTabs = m_folder.getItems();
        CTabItem selTab = m_folder.getSelection();
        if (menuAction.equals(NEW_TAB)) {
            BrowserView.openBrowser("", m_folder.getItemCount());
        } else if (menuAction.equals(REFRESH)) {
            ((BrowserTab)selTab).browserRefresh();
        } else if (menuAction.equals(CLOSE)) {
            selTab.dispose();
        } else if (menuAction.equals(CLOSE_OTHERS)) {
            int index = 0;
            while (index < openTabs.length) {
                if (!openTabs[index].equals(selTab)) {
                    CTabItem cTab = openTabs[index];
                    cTab.dispose();
                }
                ++index;
            }
        }
    }

    public void dispose() {
        super.dispose();
    }
}

