/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.DSRow;
import com.blixx.boom.engine.DSRowSorter;
import com.blixx.boom.engine.DiskEventStorage;
import com.blixx.boom.engine.DiskEventStorageTableProvider;
import com.blixx.boom.engine.GuiClient;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.engine.ServerClient;
import com.blixx.boom.gui.dialogs.ProgressDialog;
import com.blixx.boom.gui.utils.GUIDisplayElements;
import com.blixx.boom.gui.utils.STreeViewer;
import com.blixx.ctrl.sc.in.ScDeleteIndications;
import com.blixx.log.RTLogger;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.part.ViewPart;

public class CleaningModeView
extends ViewPart
implements IDoubleClickListener {
    public static final String COLUMN_CLOSED = "Closed";
    public static final String COLUMN_ACTIVE = "Active";
    public static final String COLUMN_SOURCE = "Source";
    public static final String COLUMN_HOST = "Host";
    public static final String ID = "com.blixx.boom.gui.views.cleaningmodeview";
    protected STreeViewer m_treeViewer;
    public Shell m_parentShell = null;
    public static CleaningModeView m_instance = null;
    public TableViewer m_tableViewer = null;
    private DiskEventStorageTableProvider m_dstp;
    private DSRowSorter m_sorter;
    private GUIDisplayElements m_gui = null;
    private Composite m_mainComp = null;
    private Composite m_footerComp = null;
    private Text m_activeCountField = null;
    private Text m_closedCountField = null;
    public Listener sortListener = new Listener(){

        public void handleEvent(Event e) {
            if (e.type == 13) {
                TableColumn sortColumn = CleaningModeView.this.m_tableViewer.getTable().getSortColumn();
                TableColumn currentColumn = (TableColumn)e.widget;
                int dir = CleaningModeView.this.m_tableViewer.getTable().getSortDirection();
                if (sortColumn == currentColumn) {
                    dir = dir == 128 ? 1024 : 128;
                } else {
                    CleaningModeView.this.m_tableViewer.getTable().setSortColumn(currentColumn);
                    if (CleaningModeView.COLUMN_ACTIVE.equals(currentColumn.getText()) || CleaningModeView.COLUMN_CLOSED.equals(currentColumn.getText())) {
                        dir = 1024;
                    }
                }
                String sortIdentifier = currentColumn.getText();
                CleaningModeView.this.m_sorter.setConfig(sortIdentifier, dir);
                CleaningModeView.this.m_tableViewer.getTable().setSortDirection(dir);
                ISelection sel = CleaningModeView.this.m_tableViewer.getSelection();
                if (CleaningModeView.this.m_tableViewer.getSorter() != CleaningModeView.this.m_sorter) {
                    CleaningModeView.this.m_tableViewer.setSorter((ViewerSorter)CleaningModeView.this.m_sorter);
                } else {
                    CleaningModeView.this.m_tableViewer.refresh(true, false);
                }
                CleaningModeView.this.m_tableViewer.setSelection(sel, false);
            }
        }
    };

    public static CleaningModeView getInstance() {
        return m_instance;
    }

    public CleaningModeView() {
        m_instance = this;
    }

    public void createPartControl(Composite parent) {
        this.m_parentShell = parent.getShell();
        this.setTitleImage(BMUI.IMAGE_INDICATIONS);
        this.m_gui = new GUIDisplayElements();
        this.m_mainComp = new Composite(parent, 0);
        GridLayout gl = new GridLayout(1, false);
        gl.horizontalSpacing = 0;
        gl.verticalSpacing = 0;
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        this.m_mainComp.setLayout((Layout)gl);
        this.m_mainComp.setLayoutData((Object)new GridData(4, 4, true, true));
        Table table = new Table(this.m_mainComp, 268503810);
        TableColumn col1 = new TableColumn(table, 16384);
        col1.setText(COLUMN_HOST);
        col1.setWidth(150);
        col1.addListener(13, this.sortListener);
        col1.setMoveable(true);
        TableColumn col2 = new TableColumn(table, 16384);
        col2.setText(COLUMN_SOURCE);
        col2.setWidth(200);
        col2.addListener(13, this.sortListener);
        col2.setMoveable(true);
        TableColumn col3 = new TableColumn(table, 16384);
        col3.setText(COLUMN_ACTIVE);
        col3.setWidth(70);
        col3.pack();
        col3.addListener(13, this.sortListener);
        col3.setMoveable(true);
        TableColumn col4 = new TableColumn(table, 16384);
        col4.setText(COLUMN_CLOSED);
        col4.setWidth(70);
        col4.pack();
        col4.addListener(13, this.sortListener);
        col4.setMoveable(true);
        table.setSortColumn(col1);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        GridData gd = new GridData(1808);
        gd.heightHint = 450;
        table.setLayoutData((Object)gd);
        this.m_tableViewer = new TableViewer(table);
        this.m_tableViewer.setData("SUMMARY", (Object)this);
        this.m_dstp = new DiskEventStorageTableProvider();
        this.m_tableViewer.setContentProvider((IContentProvider)this.m_dstp);
        this.m_sorter = new DSRowSorter();
        this.m_tableViewer.setSorter((ViewerSorter)this.m_sorter);
        this.m_tableViewer.setComparer((IElementComparer)this.m_sorter);
        this.m_tableViewer.setUseHashlookup(true);
        this.m_tableViewer.setLabelProvider((IBaseLabelProvider)this.m_dstp);
        this.m_tableViewer.setInput(null);
        this.m_tableViewer.getTable().setEnabled(false);
        this.m_tableViewer.addDoubleClickListener((IDoubleClickListener)this);
        table.setBackground(BMUI.color_lightYellow);
        table.setForeground(BMUI.color_black);
        this.createContentMenu();
        Repository.getEventProvider().addTableToRefresh(this.m_tableViewer);
        this.m_footerComp = new Composite(this.m_mainComp, 0);
        gl = new GridLayout(4, false);
        this.m_footerComp.setLayout((Layout)gl);
        this.m_footerComp.setLayoutData((Object)new GridData(4, 4, true, false));
        this.m_activeCountField = this.m_gui.addTextReadOnlyNoBorder(this.m_footerComp, "Total Active: ", "", 1, 1, 1, 1, null);
        this.m_closedCountField = this.m_gui.addTextReadOnlyNoBorder(this.m_footerComp, "Total Closed: ", "", 1, 1, 10, 1, null);
        ((GridData)this.m_closedCountField.getLayoutData()).horizontalIndent = 1;
    }

    public void createContentMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(false);
        Menu menu = menuMgr.createContextMenu(this.m_tableViewer.getControl());
        this.m_tableViewer.getControl().setMenu(menu);
        CleaningModeView.getInstance().getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.m_tableViewer);
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                try {
                    StructuredSelection ssel = (StructuredSelection)CleaningModeView.this.m_tableViewer.getSelection();
                    if (!ssel.isEmpty()) {
                        manager.add((IAction)new LoadIndications((IStructuredSelection)ssel));
                        manager.add((IContributionItem)new Separator());
                        manager.add((IAction)new CloseIndications(ssel));
                        manager.add((IAction)new ArchiveIndications(ssel));
                        manager.add((IContributionItem)new Separator());
                        manager.add((IAction)new DeleteIndications(ssel));
                    }
                    manager.add((IAction)new Reconnect());
                }
                catch (RuntimeException e) {
                    RTLogger.print(4, "MM11", e);
                }
            }
        });
    }

    public void refresh() {
        this.m_tableViewer.setInput((Object)this.m_dstp.getElements(null));
        this.m_tableViewer.getTable().setEnabled(!GuiClient.getInstance().m_isnewConnect);
        this.updateFooter();
    }

    public void updateFooter() {
        this.m_activeCountField.setText(this.m_dstp.getActiveCount());
        this.m_closedCountField.setText(this.m_dstp.getClosedCount());
        this.m_footerComp.pack();
    }

    public void setFocus() {
        try {
            this.m_tableViewer.getControl().setFocus();
        }
        catch (Throwable throwable) {}
    }

    public void doubleClick(DoubleClickEvent event) {
        ISelection iSelect = event.getViewer().getSelection();
        IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelect;
        LoadIndications la = new LoadIndications(iStructuredSelection);
        la.run();
    }

    public class ArchiveIndications
    extends Action {
        private List<String> m_elements;

        public ArchiveIndications(StructuredSelection ssel) {
            super("ArchiveIndications");
            this.m_elements = null;
            this.setId("ArchiveIndications");
            this.setText("Archive Closed Indications (Selected)");
            if (ssel == null || ssel.isEmpty()) {
                this.setEnabled(false);
                return;
            }
            this.m_elements = new ArrayList<String>();
            for (Object o : ssel) {
                if (o == null || !(o instanceof DSRow)) continue;
                DSRow ti = (DSRow)o;
                this.m_elements.add(ti.getKeyShort());
            }
        }

        public void run() {
            if (this.m_elements == null || this.m_elements.size() == 0) {
                return;
            }
            ProgressDialog pd = new ProgressDialog("Archiving indications", "", 0, this.m_elements.size() * 4);
            pd.setBlockOnOpen(false);
            pd.open();
            int count = 0;
            try {
                for (String shortKey : this.m_elements) {
                    pd.setProgress("loading indications for: " + shortKey, ++count);
                    List<String> ids = DiskEventStorage.getClosedStorage().loadIDs(shortKey);
                    pd.setProgress("sending indications for: " + shortKey, ++count);
                    ArrayList<String> limited10T = new ArrayList<String>(10000);
                    for (String id : ids) {
                        limited10T.add(id);
                        if (limited10T.size() < 10000) continue;
                        ServerClient sc = new ServerClient("ARCH_MSG", null, limited10T.toArray(new String[0]));
                        sc.runInUIThread(null);
                        limited10T.clear();
                    }
                    if (limited10T.size() > 0) {
                        ServerClient sc = new ServerClient("ARCH_MSG", null, limited10T.toArray(new String[0]));
                        sc.runInUIThread(null);
                        limited10T.clear();
                    }
                    int waitingNum = ++count;
                    pd.setProgress("waiting confirmation for: " + shortKey + " - " + ids.size(), waitingNum);
                    while (ids.size() > 0) {
                        try {
                            Thread.sleep(500L);
                            ids.removeAll(DiskEventStorage.m_archivedEvents.keySet());
                            pd.setProgress("waiting confirmation for: " + shortKey + " - " + ids.size(), waitingNum);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    pd.setProgress("updating cache: " + shortKey, ++count);
                    DiskEventStorage.getClosedStorage().clean(shortKey);
                }
            }
            catch (Throwable throwable) {
                try {
                    pd.close();
                }
                catch (Throwable throwable2) {}
                throw throwable;
            }
            try {
                pd.close();
            }
            catch (Throwable throwable) {}
        }
    }

    public class CloseIndications
    extends Action {
        private List<String> m_elements;

        public CloseIndications(StructuredSelection ssel) {
            super("CloseIndications");
            this.m_elements = null;
            this.setId("CloseIndications");
            this.setText("Close Active Indications (Selected)");
            if (ssel == null || ssel.isEmpty()) {
                this.setEnabled(false);
                return;
            }
            this.m_elements = new ArrayList<String>();
            for (Object o : ssel) {
                if (o == null || !(o instanceof DSRow)) continue;
                DSRow ti = (DSRow)o;
                this.m_elements.add(ti.getKeyShort());
            }
        }

        public void run() {
            if (this.m_elements == null || this.m_elements.size() == 0) {
                return;
            }
            ProgressDialog pd = new ProgressDialog("Closing indications", "", 0, this.m_elements.size() * 4);
            pd.setBlockOnOpen(false);
            pd.open();
            int count = 0;
            try {
                for (String shortKey : this.m_elements) {
                    pd.setProgress("loading indications for: " + shortKey, ++count);
                    List<String> ids = DiskEventStorage.getActiveStorage().loadIDs(shortKey);
                    pd.setProgress("sending indications for: " + shortKey, ++count);
                    ArrayList<String> limited10T = new ArrayList<String>(10000);
                    for (String id : ids) {
                        limited10T.add(id);
                        if (limited10T.size() < 10000) continue;
                        ServerClient sc = new ServerClient("ACKN_MSG", null, limited10T.toArray(new String[0]));
                        sc.runInUIThread(null);
                        limited10T.clear();
                    }
                    if (limited10T.size() > 0) {
                        ServerClient sc = new ServerClient("ACKN_MSG", null, limited10T.toArray(new String[0]));
                        sc.runInUIThread(null);
                        limited10T.clear();
                    }
                    int waitingNum = ++count;
                    pd.setProgress("waiting confirmation for: " + shortKey + " - " + ids.size(), waitingNum);
                    int size = ids.size();
                    while (ids.size() > 0) {
                        try {
                            Thread.sleep(500L);
                            ids.removeAll(DiskEventStorage.m_closedEvents.keySet());
                            pd.setProgress("waiting confirmation for: " + shortKey + " - " + ids.size(), waitingNum);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    pd.setProgress("updating cache: " + shortKey, ++count);
                    DiskEventStorage.moveActiveToClosed(shortKey, size);
                }
            }
            catch (Throwable throwable) {
                try {
                    pd.close();
                }
                catch (Throwable throwable2) {}
                throw throwable;
            }
            try {
                pd.close();
            }
            catch (Throwable throwable) {}
        }
    }

    public class DeleteIndications
    extends Action {
        private List<String> m_elements;

        public DeleteIndications(StructuredSelection ssel) {
            super("DeleteIndications");
            this.m_elements = null;
            this.setId("DeleteIndications");
            this.setText("Delete All Indications (Selected)");
            if (ssel == null || ssel.isEmpty()) {
                this.setEnabled(false);
                return;
            }
            this.m_elements = new ArrayList<String>();
            for (Object o : ssel) {
                if (o == null || !(o instanceof DSRow)) continue;
                DSRow ti = (DSRow)o;
                this.m_elements.add(ti.getKeyShort());
            }
        }

        public void run() {
            if (this.m_elements == null || this.m_elements.size() == 0) {
                return;
            }
            ProgressDialog pd = new ProgressDialog("Archiving indications", "", 0, this.m_elements.size() * 4);
            pd.setBlockOnOpen(false);
            pd.open();
            int count = 0;
            try {
                for (String shortKey : this.m_elements) {
                    pd.setProgress("loading indications for: " + shortKey, ++count);
                    List<String> ids = DiskEventStorage.getClosedStorage().loadIDs(shortKey);
                    ids.addAll(DiskEventStorage.getActiveStorage().loadIDs(shortKey));
                    pd.setProgress("sending indications for: " + shortKey, ++count);
                    ArrayList<String> limited10T = new ArrayList<String>(10000);
                    for (String id : ids) {
                        limited10T.add(id);
                        if (limited10T.size() < 10000) continue;
                        ScDeleteIndications sc = new ScDeleteIndications(Repository.getInstance(), limited10T.toArray(new String[0]));
                        sc.run();
                        limited10T.clear();
                    }
                    if (limited10T.size() > 0) {
                        ScDeleteIndications sc = new ScDeleteIndications(Repository.getInstance(), limited10T.toArray(new String[0]));
                        sc.run();
                        limited10T.clear();
                    }
                    int waitingNum = ++count;
                    pd.setProgress("waiting confirmation for: " + shortKey + " - " + ids.size(), waitingNum);
                    while (ids.size() > 0) {
                        try {
                            Thread.sleep(500L);
                            ids.removeAll(DiskEventStorage.m_archivedEvents.keySet());
                            ids.removeAll(DiskEventStorage.m_closedEvents.keySet());
                            pd.setProgress("waiting confirmation for: " + shortKey + " - " + ids.size(), waitingNum);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    pd.setProgress("updating cache: " + shortKey, ++count);
                    DiskEventStorage.getClosedStorage().clean(shortKey);
                }
            }
            catch (Throwable throwable) {
                try {
                    pd.close();
                }
                catch (Throwable throwable2) {}
                throw throwable;
            }
            try {
                pd.close();
            }
            catch (Throwable throwable) {}
        }
    }

    public class LoadIndications
    extends Action {
        private List<String> m_elements;

        public LoadIndications(IStructuredSelection ssel) {
            super("LoadIndications");
            this.m_elements = null;
            this.setId("LoadIndications");
            this.setText("Load Indications (Selected)");
            if (ssel == null || ssel.isEmpty()) {
                this.setEnabled(false);
                return;
            }
            this.m_elements = new ArrayList<String>();
            for (Object o : ssel) {
                if (o == null || !(o instanceof DSRow)) continue;
                DSRow ti = (DSRow)o;
                this.m_elements.add(ti.getKeyShort());
            }
        }

        public void run() {
            if (this.m_elements == null || this.m_elements.size() == 0) {
                return;
            }
            Repository.getEventStorageSubmit().removeAll();
            DiskEventStorage.loadStorages(this.m_elements);
            GuiClient.getInstance().refreshMessageBrowsers();
        }
    }

    public class Reconnect
    extends Action {
        public Reconnect() {
            super("Reconnect");
            this.setId("Reconnect");
            this.setText("Reload all Indications");
        }

        public void run() {
            GuiClient.getInstance().stopClient();
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException interruptedException) {}
            GuiClient.getInstance();
        }
    }
}

