/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Event;

public class CondVFilterTableProvider
implements IStructuredContentProvider,
ITableLabelProvider {
    private TableViewer m_tableViewer = null;
    private LinkedList<String> m_elements = new LinkedList();
    public static String SPACE = " ";
    public static String EQUAL = "=";

    public CondVFilterTableProvider(TableViewer tableViewer, String condVFilter) {
        this.m_tableViewer = tableViewer;
        if (condVFilter != null && condVFilter.length() > 0) {
            this.init(condVFilter);
        }
    }

    public void init(String condVFilter) {
        this.m_elements.clear();
        if (condVFilter != null && condVFilter.length() > 0) {
            StringBuffer sb = null;
            int splitPoint = condVFilter.indexOf(SPACE);
            if (splitPoint != -1) {
                String vars = condVFilter.substring(0, splitPoint);
                String patterns = condVFilter.substring(splitPoint + 1);
                String[] split = new String[]{vars, patterns};
                String[] variables = split[0].split("\u2663");
                String[] pattern = split[1].split("\u2663");
                int max = Math.max(variables.length, pattern.length);
                int i = 0;
                while (i < max) {
                    String var = "";
                    String pat = "";
                    if (variables.length > i) {
                        var = variables[i];
                    }
                    if (pattern.length > i) {
                        pat = pattern[i];
                    }
                    sb = new StringBuffer();
                    sb.append(var).append(EQUAL).append(pat);
                    this.m_elements.add(sb.toString());
                    ++i;
                }
            }
        }
    }

    public Object[] getElements(Object object) {
        return this.m_elements.toArray();
    }

    public String getElement(int index) {
        if (index < this.m_elements.size()) {
            return this.m_elements.get(index);
        }
        return null;
    }

    private String[] getNameAndPattern(String oneLine) {
        int posEQ = oneLine.indexOf(61);
        String[] array = new String[]{"", ""};
        if (oneLine == null) {
            return array;
        }
        if (posEQ != -1) {
            array[0] = oneLine.substring(0, posEQ);
            array[1] = oneLine.substring(posEQ + 1);
        } else {
            array[0] = oneLine;
        }
        return array;
    }

    public void addElement(String element) {
        this.m_elements.add(element);
    }

    public void removeElement() {
        int[] selIndices = this.m_tableViewer.getTable().getSelectionIndices();
        int i = selIndices.length - 1;
        while (i >= 0) {
            int selIndex = selIndices[i];
            if (this.m_elements.size() > selIndex) {
                this.m_elements.remove(selIndex);
            }
            --i;
        }
    }

    public void updateElement(int selIndex, String elementOld, String elementNew) {
        String selection;
        block4: {
            selection = null;
            try {
                selection = this.m_elements.get(selIndex);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                if (!this.m_elements.contains(elementOld)) break block4;
                selIndex = this.m_elements.indexOf(elementOld);
                selection = elementOld;
            }
        }
        if (selection != null && selIndex != -1) {
            this.m_elements.remove(selection);
            this.m_elements.add(selIndex, elementNew);
        } else {
            this.m_elements.add(elementNew);
        }
    }

    public int getNumberOfElements() {
        return this.m_elements.size();
    }

    public String getVFilterAsInPolicy() {
        StringBuffer sb = new StringBuffer();
        StringBuffer sbVariables = new StringBuffer();
        StringBuffer sbPattern = new StringBuffer();
        int count = 0;
        for (String s : this.m_elements) {
            String[] split = this.getNameAndPattern(s);
            if (split.length == 2) {
                if (count > 0) {
                    sbVariables.append('\u2663');
                    sbPattern.append('\u2663');
                }
                sbVariables.append(split[0]);
                sbPattern.append(split[1]);
            }
            ++count;
        }
        sb.append(sbVariables.toString()).append(SPACE).append(sbPattern.toString());
        return sb.toString().trim();
    }

    public List<String> getVFilter() {
        return this.m_elements;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public void dispose() {
    }

    protected void measure(Event event, Object element) {
    }

    protected void paint(Event event, Object element) {
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        String elem;
        String[] split;
        String text = null;
        if (element instanceof String && (split = this.getNameAndPattern(elem = (String)element)).length > columnIndex) {
            text = split[columnIndex];
        }
        return text;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

