/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views;

import com.blixx.boom.engine.AgentCard;
import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.gui.views.FilterPolicyTab;
import com.blixx.boom.gui.views.MonitorPolicyTab;
import com.blixx.boom.gui.views.PolicyView;
import com.blixx.boom.gui.views.actions.AddDefaultContentMenuAction;
import com.blixx.log.RTLogger;
import com.blixx.shared.Condition;
import com.blixx.shared.Conditions;
import com.blixx.shared.Interval;
import com.blixx.shared.MsgCondition;
import com.blixx.shared.MsgConditions;
import com.blixx.shared.Severity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.OwnerDrawLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.ControlEditor;
import org.eclipse.swt.custom.TableCursor;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class ConditionOverviewManager
extends OwnerDrawLabelProvider
implements IStructuredContentProvider {
    private Object m_policyTab = null;
    private TableViewer m_tableViewer = null;
    public List m_conditionList = null;
    private boolean m_isDirty = false;
    private static String TRUE = "true";
    private static String FALSE = "false";
    private static String TYPE_TEXT = "TYPE_TEXT";
    private static String TYPE_COMBO = "TYPE_COMBO";

    public ConditionOverviewManager(TableViewer tv, Object conditions, Object policyTab) {
        this.m_tableViewer = tv;
        this.m_policyTab = policyTab;
        if (conditions instanceof MsgConditions) {
            MsgConditions msgConditions = (MsgConditions)conditions;
            this.m_conditionList = msgConditions.getConditionList();
        } else if (conditions instanceof Conditions) {
            Conditions monConditions = (Conditions)conditions;
            this.m_conditionList = monConditions.getConditionList();
        }
        this.setOwnerDrawEnabled((ColumnViewer)tv, null, false);
    }

    public Object[] getElements(Object inputElement) {
        return this.m_conditionList.toArray();
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    protected void measure(Event arg0, Object arg1) {
    }

    protected void paint(Event arg0, Object arg1) {
    }

    public void update(ViewerCell cell) {
        Object o = cell.getElement();
        if (o instanceof MsgCondition) {
            MsgCondition msgCond = (MsgCondition)o;
            this.updateMsgCondition(msgCond, cell);
        } else if (o instanceof Condition) {
            Condition monCond = (Condition)o;
            this.updateMonCondition(monCond, cell);
        }
        super.update(cell);
    }

    private void updateMsgCondition(MsgCondition msgCond, ViewerCell cell) {
        int colIndex = cell.getColumnIndex();
        switch (colIndex) {
            case 0: {
                if (msgCond.getActionType().equalsIgnoreCase("STOP")) {
                    cell.setImage(BMUI.IMAGE_STOP);
                    break;
                }
                if (msgCond.getInsertClosed() == 1) {
                    cell.setImage(BMUI.IMAGE_INSERT_CLOSED);
                    break;
                }
                cell.setImage(BMUI.IMAGE_TRANSPARENT_12x12);
                break;
            }
            case 1: {
                String seqnr = FilterPolicyTab.mapCondPos(null).get(msgCond.getConditionId()).toString();
                cell.setText("(" + seqnr + ") " + msgCond.getDescription());
                int sev = Severity.getSeverity(msgCond.getSetSeverity());
                if (sev == 0) {
                    cell.setBackground(BMUI.color_white);
                    break;
                }
                cell.setBackground(BMUI.getColor(sev));
                break;
            }
            case 2: {
                if (msgCond.getTypeA() == 0) {
                    cell.setImage(BMUI.IMAGE_COMBO_UNCHECKED);
                    break;
                }
                cell.setImage(BMUI.IMAGE_COMBO_CHECKED);
                break;
            }
            case 3: {
                if (msgCond.getTypeK() == 0) {
                    cell.setImage(BMUI.IMAGE_COMBO_UNCHECKED);
                    break;
                }
                cell.setImage(BMUI.IMAGE_COMBO_CHECKED);
                break;
            }
            case 4: {
                if (!msgCond.isDedupl()) {
                    cell.setImage(BMUI.IMAGE_COMBO_UNCHECKED);
                    break;
                }
                cell.setImage(BMUI.IMAGE_COMBO_CHECKED);
                break;
            }
            case 5: {
                if (!msgCond.isDeduplKeyOnly()) {
                    cell.setImage(BMUI.IMAGE_COMBO_UNCHECKED);
                    break;
                }
                cell.setImage(BMUI.IMAGE_COMBO_CHECKED);
                break;
            }
            case 6: {
                if (msgCond.getInsertClosed() != 0) {
                    cell.setImage(BMUI.IMAGE_COMBO_CHECKED);
                    break;
                }
                cell.setImage(BMUI.IMAGE_COMBO_UNCHECKED);
                break;
            }
            case 7: {
                cell.setText(msgCond.getKey());
                break;
            }
            case 8: {
                cell.setText(msgCond.getCloseMask());
                break;
            }
            case 9: {
                cell.setText(msgCond.getApplicationFilter());
                break;
            }
            case 10: {
                cell.setText(msgCond.getGroupFilter());
                break;
            }
            case 11: {
                cell.setText(msgCond.getObjectFilter());
                break;
            }
            case 12: {
                cell.setText(msgCond.getNodeFilter());
                break;
            }
            case 13: {
                cell.setText(msgCond.getSeverityFilter());
                break;
            }
            case 14: {
                String set_appl = msgCond.getSetApplication();
                if (set_appl == null || set_appl.equals("")) {
                    msgCond.setSetApplication("");
                    cell.setText(((FilterPolicyTab)this.m_policyTab).getPolicy().getSetApplication());
                    cell.setForeground(BMUI.color_darkGrey2);
                    break;
                }
                cell.setText(set_appl);
                cell.setForeground(BMUI.color_black);
                break;
            }
            case 15: {
                String set_group = msgCond.getSetGroup();
                if (set_group == null || set_group.equals("")) {
                    msgCond.setSetGroup("");
                    cell.setText(((FilterPolicyTab)this.m_policyTab).getPolicy().getSetGroup());
                    cell.setForeground(BMUI.color_darkGrey2);
                    break;
                }
                cell.setText(set_group);
                cell.setForeground(BMUI.color_black);
                break;
            }
            case 16: {
                cell.setText(msgCond.getSetObject());
                break;
            }
            case 17: {
                cell.setText(msgCond.getSetNode());
                break;
            }
            case 18: {
                String severity = msgCond.getSetSeverity();
                if (severity == null) {
                    severity = "";
                }
                cell.setText(severity);
                break;
            }
            case 19: {
                cell.setText(msgCond.getTextFilter());
                break;
            }
            case 20: {
                cell.setText(msgCond.getSetText());
                break;
            }
            case 21: {
                if (msgCond.getSuppressInterval() < 0) {
                    msgCond.setSuppressInterval(0);
                }
                cell.setText("" + msgCond.getSuppressInterval());
                break;
            }
            case 22: {
                cell.setText("" + msgCond.getSuppressCount());
                break;
            }
            case 23: {
                cell.setText(msgCond.getAutoAction());
                break;
            }
            case 24: {
                cell.setText(msgCond.getAutoAction_Node());
                break;
            }
            case 25: {
                cell.setText("" + msgCond.getAutoActionTimeout());
                break;
            }
            case 26: {
                cell.setText(msgCond.getOpAction());
                break;
            }
            case 27: {
                if (!msgCond.getExpected()) {
                    cell.setImage(BMUI.IMAGE_COMBO_CHECKED);
                    break;
                }
                cell.setImage(BMUI.IMAGE_COMBO_UNCHECKED);
                break;
            }
            case 28: {
                if ("".equals(msgCond.getActionType())) {
                    cell.setText("SEND");
                    break;
                }
                cell.setText(msgCond.getActionType());
                break;
            }
        }
    }

    private void updateMonCondition(Condition monCond, ViewerCell cell) {
        Color textColor = null;
        StyledString styledString = null;
        int colIndex = cell.getColumnIndex();
        switch (colIndex) {
            case 0: {
                if (monCond.getActionType().equalsIgnoreCase("STOP")) {
                    cell.setImage(BMUI.IMAGE_STOP);
                    break;
                }
                if (monCond.getInsertClosed() != 0) {
                    cell.setImage(BMUI.IMAGE_INSERT_CLOSED);
                    break;
                }
                cell.setImage(BMUI.IMAGE_TRANSPARENT_12x12);
                break;
            }
            case 1: {
                cell.setText(monCond.getDescription());
                cell.setBackground(BMUI.getColor(monCond.getSetSeverity()));
                break;
            }
            case 2: {
                if (monCond.getTypeA() == 0) {
                    cell.setImage(BMUI.IMAGE_COMBO_UNCHECKED);
                    break;
                }
                cell.setImage(BMUI.IMAGE_COMBO_CHECKED);
                break;
            }
            case 3: {
                if (monCond.getTypeK() == 0) {
                    cell.setImage(BMUI.IMAGE_COMBO_UNCHECKED);
                    break;
                }
                cell.setImage(BMUI.IMAGE_COMBO_CHECKED);
                break;
            }
            case 4: {
                if (!monCond.isDedupl()) {
                    cell.setImage(BMUI.IMAGE_COMBO_UNCHECKED);
                    break;
                }
                cell.setImage(BMUI.IMAGE_COMBO_CHECKED);
                break;
            }
            case 5: {
                if (!monCond.isDeduplKeyOnly()) {
                    cell.setImage(BMUI.IMAGE_COMBO_UNCHECKED);
                    break;
                }
                cell.setImage(BMUI.IMAGE_COMBO_CHECKED);
                break;
            }
            case 6: {
                if (monCond.getInsertClosed() == 0) {
                    cell.setImage(BMUI.IMAGE_COMBO_UNCHECKED);
                    break;
                }
                cell.setImage(BMUI.IMAGE_COMBO_CHECKED);
                break;
            }
            case 7: {
                String msgKey = monCond.getKey();
                if (msgKey == null || msgKey.equals("")) {
                    monCond.setKey("");
                    cell.setText(((MonitorPolicyTab)this.m_policyTab).getPolicy().getKey());
                    cell.setForeground(BMUI.color_darkGrey2);
                    break;
                }
                cell.setText(msgKey);
                cell.setForeground(BMUI.color_black);
                break;
            }
            case 8: {
                cell.setText(monCond.getCloseMask());
                break;
            }
            case 9: {
                cell.setText("" + monCond.getThreshold());
                break;
            }
            case 10: {
                textColor = BMUI.color_black;
                if (!((MonitorPolicyTab)this.m_policyTab).getPolicy().isReset()) {
                    textColor = BMUI.color_darkGrey2;
                }
                String text = "" + monCond.getReset();
                styledString = new StyledString();
                styledString.append(text);
                cell.setForeground(textColor);
                cell.setText(styledString.toString());
                break;
            }
            case 11: {
                textColor = BMUI.color_black;
                if (!((MonitorPolicyTab)this.m_policyTab).getPolicy().isReset()) {
                    textColor = BMUI.color_darkGrey2;
                }
                String txt = "" + monCond.isIgnoreReset();
                styledString = new StyledString();
                styledString.append(txt);
                cell.setForeground(textColor);
                cell.setText(styledString.toString());
                break;
            }
            case 12: {
                cell.setText("" + monCond.getSilenceCount());
                break;
            }
            case 13: {
                cell.setText(Severity.getSeverity(monCond.getSetSeverity()));
                break;
            }
            case 14: {
                cell.setText(monCond.getObjectFilter());
                break;
            }
            case 15: {
                cell.setText(monCond.getSetNode());
                break;
            }
            case 16: {
                String set_application = monCond.getSetApplication();
                if (set_application == null || set_application.equals("")) {
                    monCond.setSetApplication("");
                    cell.setText(((MonitorPolicyTab)this.m_policyTab).getPolicy().getSetApplication());
                    cell.setForeground(BMUI.color_darkGrey2);
                    break;
                }
                cell.setText(set_application);
                cell.setForeground(BMUI.color_black);
                break;
            }
            case 17: {
                cell.setText(monCond.getSetObject());
                break;
            }
            case 18: {
                String set_msgGrp = monCond.getSetGroup();
                if (set_msgGrp == null || set_msgGrp.equals("")) {
                    monCond.setSetGroup("");
                    cell.setText(((MonitorPolicyTab)this.m_policyTab).getPolicy().getSetGroup());
                    cell.setForeground(BMUI.color_darkGrey2);
                    break;
                }
                cell.setText(set_msgGrp);
                cell.setForeground(BMUI.color_black);
                break;
            }
            case 19: {
                cell.setText(monCond.getAutoAction());
                break;
            }
            case 20: {
                cell.setText(((MonitorPolicyTab)this.m_policyTab).getSelectedHost(monCond));
                break;
            }
            case 21: {
                cell.setText("" + monCond.getAutoActionTimeout());
                break;
            }
            case 22: {
                cell.setText(monCond.getOpAction());
                break;
            }
            case 23: {
                cell.setText(monCond.getSetText());
                break;
            }
            case 24: {
                if ("".equals(monCond.getActionType())) {
                    cell.setText("SEND");
                    break;
                }
                cell.setText(monCond.getActionType());
                break;
            }
        }
    }

    public boolean canModifyCell(Object element, int columnIndex) {
        boolean canModify = false;
        if (element instanceof MsgCondition) {
            canModify = this.canModifyMsgCondition(columnIndex);
        } else if (element instanceof Condition) {
            canModify = this.canModifyMonCondition(columnIndex);
        }
        return canModify;
    }

    public String getCellType(Object element, int columnIndex) {
        String type = TYPE_TEXT;
        if (element instanceof MsgCondition) {
            if (columnIndex == 28) {
                type = TYPE_COMBO;
            }
        } else if (element instanceof Condition && columnIndex == 24) {
            type = TYPE_COMBO;
        }
        return type;
    }

    public List getConditionList() {
        return this.m_conditionList;
    }

    public boolean canModifyMsgCondition(int columnIndex) {
        boolean canModify = true;
        if (this.hasCheckbox(BMUI.type_msg, columnIndex)) {
            canModify = false;
        } else if (columnIndex == 0 || columnIndex == 20) {
            canModify = false;
        }
        return canModify;
    }

    public boolean canModifyMonCondition(int columnIndex) {
        boolean canModify = true;
        if (this.hasCheckbox(BMUI.type_mon, columnIndex)) {
            canModify = false;
        } else if (columnIndex == 10 || columnIndex == 11) {
            if (!((MonitorPolicyTab)this.m_policyTab).getPolicy().isReset()) {
                canModify = false;
            }
        } else if (columnIndex == 0 || columnIndex == 23) {
            canModify = false;
        }
        return canModify;
    }

    public boolean updateCondition(Object element, int columnIndex, String value, Object tableCellElement, TableItem row) {
        boolean modified = false;
        if (element instanceof MsgCondition) {
            MsgCondition msgCond = (MsgCondition)element;
            modified = this.updateMsgCondition(msgCond, columnIndex, value, tableCellElement, row);
        } else if (element instanceof Condition) {
            Condition monCond = (Condition)element;
            modified = this.updateMonCondition(monCond, columnIndex, value, tableCellElement, row);
        }
        return modified;
    }

    public boolean updateMsgCondition(MsgCondition msgCond, int columnIndex, String value, Object tableCellElement, TableItem row) {
        boolean modified = false;
        String oldValue = "";
        switch (columnIndex) {
            case 0: {
                break;
            }
            case 1: {
                msgCond.setDescription(value.trim());
                modified = true;
                break;
            }
            case 2: {
                msgCond.setTypeA(msgCond.getTypeA() == 0 ? 1 : 0);
                msgCond.setTypeK(0);
                modified = true;
                break;
            }
            case 3: {
                msgCond.setTypeK(msgCond.getTypeK() == 0 ? 1 : 0);
                msgCond.setTypeA(0);
                modified = true;
                break;
            }
            case 4: {
                msgCond.setDedupl(!msgCond.isDedupl());
                msgCond.setDeduplKeyOnly(false);
                modified = true;
                break;
            }
            case 5: {
                msgCond.setDeduplKeyOnly(!msgCond.isDeduplKeyOnly());
                msgCond.setDedupl(false);
                modified = true;
                break;
            }
            case 6: {
                msgCond.setInsertClosed(msgCond.getInsertClosed() == 0 ? 1 : 0);
                modified = true;
                break;
            }
            case 7: {
                msgCond.setKey(value.trim());
                modified = true;
                break;
            }
            case 8: {
                msgCond.setCloseMask(value.trim());
                modified = true;
                break;
            }
            case 9: {
                msgCond.setApplicationFilter(value.trim());
                modified = true;
                break;
            }
            case 10: {
                msgCond.setGroupFilter(value.trim());
                modified = true;
                break;
            }
            case 11: {
                msgCond.setObjectFilter(value.trim());
                modified = true;
                break;
            }
            case 12: {
                msgCond.setNodeFilter(value.trim());
                modified = true;
                break;
            }
            case 13: {
                oldValue = msgCond.getSeverityFilter();
                String sevOrig = value.trim();
                String sevValidated = this.validateSeverities(sevOrig);
                if (sevOrig.equals(sevValidated)) break;
                ((Text)tableCellElement).setText(sevValidated);
                msgCond.setSeverityFilter(sevValidated);
                modified = true;
                break;
            }
            case 14: {
                msgCond.setSetApplication(value.trim());
                modified = true;
                break;
            }
            case 15: {
                msgCond.setSetGroup(value.trim());
                modified = true;
                break;
            }
            case 16: {
                msgCond.setSetObject(value.trim());
                modified = true;
                break;
            }
            case 17: {
                msgCond.setSetNode(value.trim());
                modified = true;
                break;
            }
            case 18: {
                Color color = null;
                String severity = value.trim();
                oldValue = msgCond.getSetSeverity();
                int sev = Severity.getSeverity(severity);
                if (sev == 0) {
                    severity = "";
                    color = BMUI.color_white;
                } else {
                    severity = Severity.getSeverity(sev);
                    color = BMUI.getColor(Severity.getSeverity(severity));
                }
                msgCond.setSetSeverity(severity);
                ((Text)tableCellElement).setText(severity);
                row.setBackground(1, color);
                modified = true;
                break;
            }
            case 19: {
                msgCond.setTextFilter(value.trim());
                modified = true;
                break;
            }
            case 20: {
                break;
            }
            case 21: {
                if (msgCond.getSuppressInterval() < 0) {
                    msgCond.setSuppressInterval(0);
                }
                oldValue = msgCond.getSuppressInterval() / 60 + "m";
                if (Interval.checkInterval(value)) {
                    int parsed = Interval.parseInterval(value, -1).getIntervalSeconds();
                    if (parsed >= 0) {
                        msgCond.setSuppressInterval(parsed);
                        modified = true;
                        break;
                    }
                    ((Text)tableCellElement).setText(oldValue);
                    break;
                }
                ((Text)tableCellElement).setText(oldValue);
                break;
            }
            case 22: {
                oldValue = "" + msgCond.getSuppressCount();
                int old = msgCond.getSuppressCount();
                try {
                    msgCond.setSuppressCount(Integer.valueOf(value.trim()));
                    modified = true;
                }
                catch (NumberFormatException numberFormatException) {
                    if (value.trim().isEmpty()) {
                        ((Text)tableCellElement).setText("0");
                        msgCond.setSuppressCount(0);
                        modified = true;
                        break;
                    }
                    ((Text)tableCellElement).setText(oldValue);
                    msgCond.setSuppressCount(old);
                }
                break;
            }
            case 23: {
                msgCond.setAutoAction(value.trim());
                modified = true;
                break;
            }
            case 24: {
                msgCond.setAutoAction_Node(value.trim());
                modified = true;
                break;
            }
            case 25: {
                try {
                    msgCond.setAutoActionTimeout(Integer.parseInt(value.trim()));
                    modified = true;
                }
                catch (NumberFormatException numberFormatException) {
                    ((Text)tableCellElement).setText("120");
                    msgCond.setAutoActionTimeout(120);
                }
                break;
            }
            case 26: {
                msgCond.setOpAction(value.trim());
                modified = true;
                break;
            }
            case 27: {
                msgCond.setExpected(!msgCond.getExpected());
                modified = true;
                break;
            }
            case 28: {
                String type = value.trim().toUpperCase();
                if (type.equals("STOP")) {
                    msgCond.setActionType("STOP");
                } else {
                    msgCond.setActionType("SEND");
                }
                modified = true;
                break;
            }
        }
        return modified;
    }

    public boolean updateMonCondition(Condition monCond, int columnIndex, String value, Object tableCellElement, TableItem row) {
        boolean modified = false;
        String old = "";
        switch (columnIndex) {
            case 0: {
                break;
            }
            case 1: {
                monCond.setDescription(value.trim());
                modified = true;
                break;
            }
            case 2: {
                monCond.setTypeA(monCond.getTypeA() == 0 ? 1 : 0);
                monCond.setTypeK(0);
                modified = true;
                break;
            }
            case 3: {
                monCond.setTypeK(monCond.getTypeK() == 0 ? 1 : 0);
                monCond.setTypeA(0);
                modified = true;
                break;
            }
            case 4: {
                monCond.setDedupl(!monCond.isDedupl());
                monCond.setDeduplKeyOnly(false);
                modified = true;
                break;
            }
            case 5: {
                monCond.setDeduplKeyOnly(!monCond.isDeduplKeyOnly());
                monCond.setDedupl(false);
                modified = true;
                break;
            }
            case 6: {
                monCond.setInsertClosed(monCond.getInsertClosed() == 0 ? 1 : 0);
                modified = true;
                break;
            }
            case 7: {
                monCond.setKey(value.trim());
                modified = true;
                break;
            }
            case 8: {
                monCond.setCloseMask(value.trim());
                modified = true;
                break;
            }
            case 9: {
                old = "" + monCond.getThreshold();
                try {
                    monCond.setThreshold(Double.parseDouble(value.trim()));
                    modified = true;
                }
                catch (NumberFormatException numberFormatException) {
                    Text cell = (Text)tableCellElement;
                    cell.removeModifyListener((ModifyListener)((MonitorPolicyTab)this.m_policyTab).m_conditionDetails);
                    cell.setText(old);
                    cell.addModifyListener((ModifyListener)((MonitorPolicyTab)this.m_policyTab).m_conditionDetails);
                }
                break;
            }
            case 10: {
                old = "" + monCond.getReset();
                try {
                    monCond.setReset(Double.parseDouble(value.trim()));
                    modified = true;
                }
                catch (NumberFormatException numberFormatException) {
                    ((Text)tableCellElement).setText(old);
                }
                break;
            }
            case 11: {
                old = "" + monCond.isIgnoreReset();
                try {
                    String strBool = value.trim();
                    if (strBool.equalsIgnoreCase(FALSE)) {
                        monCond.setIgnoreReset(Boolean.valueOf(FALSE));
                        Text cell = (Text)tableCellElement;
                        cell.removeModifyListener((ModifyListener)((MonitorPolicyTab)this.m_policyTab).m_conditionDetails);
                        cell.setText(cell.getText());
                        cell.addModifyListener((ModifyListener)((MonitorPolicyTab)this.m_policyTab).m_conditionDetails);
                        modified = true;
                        break;
                    }
                    if (!strBool.equalsIgnoreCase(TRUE)) break;
                    monCond.setIgnoreReset(Boolean.valueOf(TRUE));
                    Text cell = (Text)tableCellElement;
                    cell.removeModifyListener((ModifyListener)((MonitorPolicyTab)this.m_policyTab).m_conditionDetails);
                    cell.setText(cell.getText());
                    cell.addModifyListener((ModifyListener)((MonitorPolicyTab)this.m_policyTab).m_conditionDetails);
                    modified = true;
                }
                catch (NumberFormatException numberFormatException) {
                    Text cell = (Text)tableCellElement;
                    cell.removeModifyListener((ModifyListener)((MonitorPolicyTab)this.m_policyTab).m_conditionDetails);
                    cell.setText(old);
                    cell.addModifyListener((ModifyListener)((MonitorPolicyTab)this.m_policyTab).m_conditionDetails);
                }
                break;
            }
            case 12: {
                old = "" + monCond.getSilenceCount();
                try {
                    monCond.setSilenceCount(Long.parseLong(value.trim()));
                    modified = true;
                }
                catch (NumberFormatException numberFormatException) {
                    Text cell = (Text)tableCellElement;
                    cell.removeModifyListener((ModifyListener)((MonitorPolicyTab)this.m_policyTab).m_conditionDetails);
                    cell.setText(old);
                    cell.addModifyListener((ModifyListener)((MonitorPolicyTab)this.m_policyTab).m_conditionDetails);
                }
                break;
            }
            case 13: {
                old = Severity.getSeverity(monCond.getSetSeverity());
                try {
                    String sev = value.trim();
                    int severity = Severity.getSeverity(sev);
                    monCond.setSetSeverity(severity);
                    modified = true;
                }
                catch (NumberFormatException numberFormatException) {
                    Text cell = (Text)tableCellElement;
                    cell.removeModifyListener((ModifyListener)((MonitorPolicyTab)this.m_policyTab).m_conditionDetails);
                    cell.setText(old);
                    cell.addModifyListener((ModifyListener)((MonitorPolicyTab)this.m_policyTab).m_conditionDetails);
                    row.setBackground(0, BMUI.getColor(Severity.getSeverity(old)));
                }
                break;
            }
            case 14: {
                monCond.setObjectFilter(value.trim());
                modified = true;
                break;
            }
            case 15: {
                monCond.setSetNode(value.trim());
                modified = true;
                break;
            }
            case 16: {
                monCond.setSetApplication(value.trim());
                modified = true;
                break;
            }
            case 17: {
                monCond.setSetObject(value.trim());
                modified = true;
                break;
            }
            case 18: {
                monCond.setSetGroup(value.trim());
                modified = true;
                break;
            }
            case 19: {
                monCond.setAutoAction(value.trim());
                modified = true;
                break;
            }
            case 20: {
                String newNode = value.trim();
                if (newNode.indexOf(124) != -1) {
                    String host = this.checkNode(newNode = newNode.substring(newNode.indexOf(124) + 1));
                    if (host == null) break;
                    monCond.setAutoAction_Node(newNode);
                    Text cell = (Text)tableCellElement;
                    cell.removeModifyListener((ModifyListener)((MonitorPolicyTab)this.m_policyTab).m_conditionDetails);
                    cell.setText(host);
                    cell.addModifyListener((ModifyListener)((MonitorPolicyTab)this.m_policyTab).m_conditionDetails);
                    modified = true;
                    break;
                }
                monCond.setAutoAction_Node("");
                Text cell = (Text)tableCellElement;
                cell.removeModifyListener((ModifyListener)((MonitorPolicyTab)this.m_policyTab).m_conditionDetails);
                cell.setText("");
                cell.addModifyListener((ModifyListener)((MonitorPolicyTab)this.m_policyTab).m_conditionDetails);
                modified = true;
                break;
            }
            case 21: {
                old = "" + monCond.getAutoActionTimeout();
                try {
                    monCond.setAutoActionTimeout(Integer.parseInt(value.trim()));
                    modified = true;
                }
                catch (NumberFormatException numberFormatException) {
                    Text cell = (Text)tableCellElement;
                    cell.removeModifyListener((ModifyListener)((MonitorPolicyTab)this.m_policyTab).m_conditionDetails);
                    cell.setText(old);
                    cell.addModifyListener((ModifyListener)((MonitorPolicyTab)this.m_policyTab).m_conditionDetails);
                }
                break;
            }
            case 22: {
                monCond.setOpAction(value.trim());
                modified = true;
                break;
            }
            case 23: {
                monCond.setSetText(value.trim());
                modified = true;
                break;
            }
            case 24: {
                String type = value.trim().toUpperCase();
                if (type.equals("STOP")) {
                    monCond.setActionType("STOP");
                } else {
                    monCond.setActionType("SEND");
                }
                modified = true;
                break;
            }
        }
        return modified;
    }

    public boolean isDirty() {
        return this.m_isDirty;
    }

    public void setDirty(boolean b) {
        this.m_isDirty = b;
    }

    private String checkNode(String hostID) {
        String host = null;
        Collection<AgentCard> agents = Repository.getInstance().getAgentCards();
        for (AgentCard agentCard : agents) {
            if (!agentCard.getAgentID().equals(hostID)) continue;
            host = String.valueOf(agentCard.getAgentHost()) + "|" + agentCard.getAgentID();
            break;
        }
        return host;
    }

    public void addContentMenuToCell(final Control control) {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        Menu menu = menuMgr.createContextMenu(control);
        control.setMenu(menu);
        PolicyView.getInstance().getSite().registerContextMenu(menuMgr, null);
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                try {
                    manager.add((IContributionItem)new Separator());
                    manager.add((IAction)new AddDefaultContentMenuAction(control, 1, true));
                    manager.add((IAction)new AddDefaultContentMenuAction(control, 2, true));
                    manager.add((IAction)new AddDefaultContentMenuAction(control, 3, true));
                    manager.add((IAction)new AddDefaultContentMenuAction(control, 4, true));
                    manager.add((IContributionItem)new Separator());
                    manager.add((IAction)new AddDefaultContentMenuAction(control, 5, true));
                    manager.add((IContributionItem)new Separator());
                }
                catch (RuntimeException e) {
                    RTLogger.print(5, "Error creating context menu", e);
                }
            }
        });
    }

    public void changeTableCheckboxSelection(TableCursor cursor, int column, TableItem item) {
        if (cursor == null || item == null) {
            return;
        }
        Object condition = item.getData();
        boolean modified = this.updateCondition(condition, column, null, null, null);
        if (modified) {
            this.m_tableViewer.refresh();
            this.setDirty(true);
            if (this.m_policyTab instanceof MonitorPolicyTab) {
                ((MonitorPolicyTab)this.m_policyTab).setDirty(true);
            } else if (this.m_policyTab instanceof FilterPolicyTab) {
                ((FilterPolicyTab)this.m_policyTab).setDirty(true);
            }
            this.m_tableViewer.getTable().setSelection(new TableItem[]{cursor.getRow()});
        }
    }

    public void changeTableComboSelection(TableCursor cursor, int column, TableItem item) {
        if (cursor == null || item == null) {
            return;
        }
        Object condition = item.getData();
        boolean modified = this.updateCondition(condition, column, null, null, null);
        if (modified) {
            this.m_tableViewer.refresh();
            this.setDirty(true);
            if (this.m_policyTab instanceof MonitorPolicyTab) {
                ((MonitorPolicyTab)this.m_policyTab).setDirty(true);
            } else if (this.m_policyTab instanceof FilterPolicyTab) {
                ((FilterPolicyTab)this.m_policyTab).setDirty(true);
            }
            this.m_tableViewer.getTable().setSelection(new TableItem[]{cursor.getRow()});
        }
    }

    public TableItem moveToCell(TableCursor cursor, int rowIndex, int columnIndex) {
        TableItem nextRow = this.m_tableViewer.getTable().getItem(rowIndex);
        if (this.m_tableViewer.getTable().getSelectionIndex() != rowIndex) {
            this.m_tableViewer.getTable().setSelection(new TableItem[]{nextRow});
        }
        cursor.setSelection(nextRow, columnIndex);
        cursor.setVisible(true);
        cursor.setFocus();
        return nextRow;
    }

    public boolean moveToNextCell(TableCursor cursor, ControlEditor editor, int currColumn) {
        if (cursor == null || editor == null) {
            return false;
        }
        boolean moved = false;
        int rowIndex = this.m_tableViewer.getTable().getSelectionIndex();
        int nextColumn = -1;
        if (currColumn == this.m_tableViewer.getTable().getColumnCount() - 1) {
            nextColumn = 0;
            rowIndex = rowIndex == this.m_tableViewer.getTable().getItemCount() - 1 ? 0 : ++rowIndex;
        } else {
            nextColumn = currColumn + 1;
        }
        if (nextColumn != -1) {
            TableItem nextRow = this.moveToCell(cursor, rowIndex, nextColumn);
            this.makeCellEditable(cursor, editor, nextRow, rowIndex, nextColumn);
            moved = true;
        }
        return moved;
    }

    public boolean moveToPreviousCell(TableCursor cursor, ControlEditor editor, int currColumn) {
        if (cursor == null || editor == null) {
            return false;
        }
        boolean moved = false;
        int rowIndex = this.m_tableViewer.getTable().getSelectionIndex();
        int nextColumn = -1;
        if (currColumn == 0) {
            nextColumn = this.m_tableViewer.getTable().getColumnCount() - 1;
            rowIndex = rowIndex == 0 ? this.m_tableViewer.getTable().getItemCount() - 1 : --rowIndex;
        } else {
            nextColumn = currColumn - 1;
        }
        if (nextColumn != -1) {
            TableItem nextRow = this.moveToCell(cursor, rowIndex, nextColumn);
            this.makeCellEditable(cursor, editor, nextRow, rowIndex, nextColumn);
            moved = true;
        }
        return moved;
    }

    public int getNextRow() {
        int nextRowIndex = -1;
        int rowIndex = this.m_tableViewer.getTable().getSelectionIndex();
        nextRowIndex = rowIndex == this.m_tableViewer.getTable().getItemCount() - 1 ? 0 : rowIndex + 1;
        return nextRowIndex;
    }

    public int getPreviousRow() {
        int nextRowIndex = -1;
        int rowIndex = this.m_tableViewer.getTable().getSelectionIndex();
        nextRowIndex = rowIndex == 0 ? this.m_tableViewer.getTable().getItemCount() - 1 : rowIndex - 1;
        return nextRowIndex;
    }

    public boolean hasCheckbox(String polType, int colIndex) {
        boolean hasCheckbox = false;
        if (polType.equals("msg")) {
            if (colIndex == 2 || colIndex == 3 || colIndex == 4 || colIndex == 5 || colIndex == 6 || colIndex == 27) {
                hasCheckbox = true;
            }
        } else if (polType.equals("mon") && (colIndex == 2 || colIndex == 3 || colIndex == 4 || colIndex == 5 || colIndex == 6)) {
            hasCheckbox = true;
        }
        return hasCheckbox;
    }

    public void makeCellEditable(TableCursor cursor, ControlEditor editor, TableItem row, int rowIndex, int columnIndex) {
        if (cursor == null || editor == null) {
            return;
        }
        Object condition = row.getData();
        boolean b = this.canModifyCell(condition, columnIndex);
        if (b) {
            String cellType = this.getCellType(condition, columnIndex);
            if (cellType.equals(TYPE_COMBO)) {
                String[] list = this.getComboList(condition, columnIndex);
                int selIndex = this.getComboSelIndex(list, row.getText(columnIndex));
                CCombo newEditableCombo = new CCombo((Composite)cursor, 8);
                newEditableCombo.setData(this.getCellPropsList(rowIndex, columnIndex));
                newEditableCombo.setItems(list);
                newEditableCombo.select(selIndex);
                if (condition instanceof Condition) {
                    ((MonitorPolicyTab)this.m_policyTab).setEditableCell(newEditableCombo);
                    ((MonitorPolicyTab)this.m_policyTab).addListenersToCellCombo();
                } else if (condition instanceof MsgCondition) {
                    ((FilterPolicyTab)this.m_policyTab).setEditableCell(newEditableCombo);
                    ((FilterPolicyTab)this.m_policyTab).addListenersToCellCombo();
                }
                editor.setEditor((Control)newEditableCombo);
                newEditableCombo.setFocus();
            } else {
                Text newEditableCell = new Text((Composite)cursor, 0);
                newEditableCell.setData(this.getCellPropsList(rowIndex, columnIndex));
                newEditableCell.setText(row.getText(columnIndex));
                newEditableCell.setBackground(row.getBackground(columnIndex));
                newEditableCell.setForeground(row.getForeground(columnIndex));
                newEditableCell.selectAll();
                this.addContentMenuToCell((Control)newEditableCell);
                if (condition instanceof Condition) {
                    ((MonitorPolicyTab)this.m_policyTab).setEditableCell(newEditableCell);
                    ((MonitorPolicyTab)this.m_policyTab).addListenersToCellText();
                } else if (condition instanceof MsgCondition) {
                    ((FilterPolicyTab)this.m_policyTab).setEditableCell(newEditableCell);
                    ((FilterPolicyTab)this.m_policyTab).addListenersToCellText();
                }
                editor.setEditor((Control)newEditableCell);
                newEditableCell.setFocus();
            }
        }
    }

    public List<Integer> getCellPropsList(int rowIndex, int columnIndex) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(rowIndex);
        list.add(columnIndex);
        return list;
    }

    public String[] getComboList(Object element, int columnIndex) {
        String[] list = null;
        if (element instanceof MsgCondition) {
            if (columnIndex == 28) {
                list = new String[]{"SEND", "STOP"};
            }
        } else if (element instanceof Condition && columnIndex == 24) {
            list = new String[]{"SEND", "STOP"};
        }
        return list;
    }

    public int getComboSelIndex(String[] comboList, String text) {
        int i = 0;
        while (i < comboList.length) {
            if (text.equals(comboList[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public String validateSeverities(String severity) {
        String[] split = severity.split("\\|");
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < split.length) {
            String sev = split[i];
            int sevInt = Severity.getSeverity(sev);
            if (sevInt == 0) {
                sb = new StringBuffer();
                sb.append("<*>");
                break;
            }
            if (i > 0) {
                sb.append('|');
            }
            sb.append(Severity.getSeverity(sevInt));
            ++i;
        }
        return sb.toString();
    }
}

