/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.gui.graph.LWS;
import com.blixx.boom.gui.utils.GUIDisplayElements;
import com.blixx.boom.gui.views.DashBoardView2;
import com.blixx.boom.gui.views.dashboard2d.Application2D;
import com.blixx.boom.gui.views.dashboard2d.CrossCube2D;
import com.blixx.boom.gui.views.dashboard2d.Group2D;
import com.blixx.boom.gui.views.dashboard2d.UpperLeftCorner;
import com.blixx.shared.utils.HashMapArray;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.zest.core.widgets.Graph;

public class DashBoardGraph2D
extends Graph {
    public static Color m_bgColor_grey = GUIDisplayElements.m_labelBkgrndColor;
    public static Color m_bgColor_white = BMUI.color_white;
    private DashBoardView2 m_dashboardView = null;
    private LightweightSystem m_lws = null;
    private Figure m_dasboardContent = null;
    private ToolbarLayout m_dashboardContentLayout = null;
    private HorizontalRow m_topRow = null;
    private boolean m_pack = true;
    private UpperLeftCorner m_upperLeftCorner = null;
    private Map<String, Group2D> m_groups = new HashMap<String, Group2D>();
    private static Dimension sevCubeSize = new Dimension(16, 16);
    private static int fontHeight = 0;

    public DashBoardGraph2D(Composite parent, int style, DashBoardView2 dashboardView) {
        super(parent, style, new LWS());
        this.m_dashboardView = dashboardView;
        this.m_lws = this.getLightweightSystem();
        this.m_dasboardContent = new Figure();
        this.m_dashboardContentLayout = new ToolbarLayout(false);
        this.m_dashboardContentLayout.setSpacing(1);
        this.m_dasboardContent.setLayoutManager((LayoutManager)this.m_dashboardContentLayout);
        this.setBackground(m_bgColor_white);
    }

    public void init(boolean pack) {
        this.m_pack = pack;
        if (this.m_dasboardContent.getChildren().size() > 0) {
            this.m_dasboardContent.erase();
            this.m_dasboardContent.removeAll();
            this.m_groups.clear();
        }
        this.m_topRow = new HorizontalRow();
        this.m_dasboardContent.add((IFigure)this.m_topRow);
        this.calculateFontHeight();
        this.m_upperLeftCorner = new UpperLeftCorner(this.m_dashboardView, this.m_pack);
        this.m_topRow.add((IFigure)this.m_upperLeftCorner);
    }

    public void addGroup(String name, List<Integer> severities) {
        Group2D grp2D_1 = new Group2D(this.m_dashboardView, this.m_pack, name, severities);
        this.m_groups.put(name, grp2D_1);
        this.m_topRow.add((IFigure)grp2D_1);
    }

    public Group2D getGroup2D(String name) {
        return this.m_groups.get(name);
    }

    public void addApplicaton(List<String> msggrps, HashMapArray<String, Integer> grpsApps, String applName, List<Integer> severities) {
        HorizontalRow row = new HorizontalRow();
        Application2D appl2D_1 = new Application2D(this.m_dashboardView, applName, severities);
        row.add((IFigure)appl2D_1);
        List grpList = this.m_topRow.getChildren();
        int i = 0;
        while (i < msggrps.size()) {
            String grp = msggrps.get(i);
            List<Integer> sevsCross = grpsApps.getArray(String.valueOf(grp) + '\u25ba' + applName);
            int maxSevCross = 0;
            if (sevsCross != null) {
                int j = 1;
                while (j < sevsCross.size()) {
                    if (sevsCross.get(j) > 0) {
                        maxSevCross = Math.max(maxSevCross, j);
                    }
                    ++j;
                }
            }
            Group2D group = (Group2D)((Object)grpList.get(i + 1));
            int width = group.getSize().width;
            int hight = appl2D_1.getHeight();
            CrossCube2D crossCube = new CrossCube2D(this.m_dashboardView, this.m_pack, applName, group.getName(), maxSevCross, width, hight);
            row.add((IFigure)crossCube);
            ++i;
        }
        this.m_dasboardContent.add((IFigure)row);
    }

    public void paint() {
        this.m_lws.setContents((IFigure)this.m_dasboardContent);
    }

    public UpperLeftCorner getUpperLeftCorner() {
        return this.m_upperLeftCorner;
    }

    private void calculateFontHeight() {
        FontData[] fds = BMUI.m_fontRegistry.defaultFont().getFontData();
        FontData fd = fds[0];
        fontHeight = fd.getHeight();
    }

    public static int getFontHeight() {
        return fontHeight;
    }

    public static Dimension getSevCubeSize() {
        return sevCubeSize;
    }

    public class HorizontalRow
    extends Figure {
        public HorizontalRow() {
            ToolbarLayout layout = new ToolbarLayout(true);
            layout.setStretchMinorAxis(false);
            layout.setSpacing(2);
            this.setLayoutManager((LayoutManager)layout);
        }
    }
}

