/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.engine.ServiceDashBoard;
import com.blixx.boom.engine.ServiceDashBoardProvider;
import com.blixx.boom.engine.UIJob;
import com.blixx.boom.gui.Activator;
import com.blixx.boom.gui.dialogs.EventFilterServiceDialog;
import com.blixx.boom.gui.dialogs.IRefreshable;
import com.blixx.boom.gui.dialogs.SelectDialog;
import com.blixx.boom.gui.dialogs.ShowMessageBox;
import com.blixx.boom.gui.dialogs.ShowSimpleDialog;
import com.blixx.boom.gui.utils.BLabelServiceController;
import com.blixx.boom.gui.utils.BLabelServiceOverview;
import com.blixx.boom.gui.utils.GUIDisplayElements;
import com.blixx.boom.gui.views.MessagesView;
import com.blixx.boom.gui.views.actions.AddServiceAction;
import com.blixx.shared.UserRole;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.part.ViewPart;

public class DashBoardServicesView
extends ViewPart
implements MouseListener,
IRefreshable,
SelectionListener,
ISelectionProvider {
    private static final String GLOBAL = "GLOBAL";
    public static final String ID = "com.blixx.boom.gui.views.dashboardcustomerview";
    private static DashBoardServicesView m_instance = null;
    private Composite parent = null;
    private ScrolledComposite m_sc = null;
    public static int VIEW_ID = 2001;
    private static String ADD_BUTTON = "ADD_BUTTON";
    private static String UPLOAD_BUTTON = "UPLOAD_BUTTON";
    private static String DOWNLOAD_BUTTON = "DOWNLOAD_BUTTON";
    private static String DOWNLOAD_FOR_ROLE_BUTTON = "DOWNLOAD_FOR_ROLE_BUTTON";
    private static String DELETE_FOR_ROLE_BUTTON = "DELETE_FOR_ROLE_BUTTON";
    private List<ISelectionChangedListener> m_selectionListeners = new ArrayList<ISelectionChangedListener>();
    private ISelection m_selected = null;
    public static HashMap<String, EventFilterServiceDialog> m_openEFSDialogs = new HashMap();
    private Label m_currentURLabel;
    private ServiceDashBoardProvider m_serviceProvider = Repository.getInstance().getServiceDashBoardProvider();
    private Composite mainComp;
    private Button m_delete_FU_btn;

    public static DashBoardServicesView getInstance() {
        return m_instance;
    }

    public DashBoardServicesView() {
        m_instance = this;
    }

    public void createPartControl(Composite parent) {
        if (Repository.getInstance().getRights(VIEW_ID) <= 1) {
            parent.setLayout((Layout)new GridLayout(2, false));
            Label l = new Label(parent, 0);
            l.setText(" Insufficient rights.");
            l.setForeground(BMUI.color_critical);
            Button close = new Button(parent, 8);
            close.setText("Close");
            close.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    DashBoardServicesView.this.getSite().getPage().hideView(DashBoardServicesView.this.getSite().getPage().findView(DashBoardServicesView.ID));
                }
            });
            UIJob uiJob = new UIJob("Close Viewcom.blixx.boom.gui.views.dashboardcustomerview"){

                @Override
                public IStatus runInUIThread(IProgressMonitor monitor) {
                    DashBoardServicesView.this.getSite().getPage().hideView(DashBoardServicesView.this.getSite().getPage().findView(DashBoardServicesView.ID));
                    return Status.OK_STATUS;
                }
            };
            Repository.getUIJobManager().schedule(uiJob);
            return;
        }
        this.parent = parent;
        Composite compositeInView = new Composite(parent, 0);
        compositeInView.setLayout((Layout)new GridLayout());
        compositeInView.setBackground(BMUI.color_white);
        this.m_sc = new ScrolledComposite(compositeInView, 512);
        this.m_sc.setAlwaysShowScrollBars(false);
        this.m_sc.setExpandHorizontal(true);
        this.m_sc.setExpandVertical(true);
        GridLayout gridLayout = new GridLayout(1, false);
        this.m_sc.setLayout((Layout)gridLayout);
        this.m_sc.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createMainComponent();
        GUIDisplayElements gui = new GUIDisplayElements();
        Composite compLine = new Composite(compositeInView, 0);
        GridLayout gl = new GridLayout(1, false);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        compLine.setLayout((Layout)gl);
        compLine.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        Label line = new Label(compLine, 259);
        line.setForeground(BMUI.color_darkGrey2);
        line.setLayoutData((Object)new GridData(4, 128, true, false, 2, 1));
        Composite btnComp = new Composite(compositeInView, 0);
        gl = new GridLayout(6, false);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        btnComp.setLayout((Layout)gl);
        btnComp.setLayoutData((Object)new GridData(16384, 4, false, false, 1, 1));
        Button add_btn = gui.addButton(btnComp, ADD_BUTTON, "Add Service", true, this);
        add_btn.setEnabled(this.m_serviceProvider.isLocalChangesAllowed());
        add_btn.setLayoutData((Object)new GridData(4, 128, true, false));
        Button upload_btn = gui.addButton(btnComp, UPLOAD_BUTTON, "Upload to Server", true, this);
        upload_btn.setLayoutData((Object)new GridData(4, 128, true, false));
        upload_btn.setEnabled(this.m_serviceProvider.isLocalChangesAllowed());
        int rights = Repository.getInstance().getRights(VIEW_ID);
        if (rights > 0 && rights < 3) {
            upload_btn.setEnabled(false);
        }
        Button download_btn = gui.addButton(btnComp, DOWNLOAD_BUTTON, "Download from Server", true, this);
        download_btn.setLayoutData((Object)new GridData(4, 128, true, false));
        Button download_FU_btn = gui.addButton(btnComp, DOWNLOAD_FOR_ROLE_BUTTON, "Switch ...", true, this);
        download_FU_btn.setLayoutData((Object)new GridData(4, 128, true, false));
        download_FU_btn.setToolTipText("Load UserRole-specific dashboard configuration");
        this.m_delete_FU_btn = gui.addButton(btnComp, DELETE_FOR_ROLE_BUTTON, "Delete ...", false, this);
        this.m_delete_FU_btn.setLayoutData((Object)new GridData(4, 128, true, false));
        this.m_delete_FU_btn.setToolTipText("Delete UserRole-specific dashborad configuration");
        this.m_currentURLabel = new Label(btnComp, 0);
        this.m_currentURLabel.setText(GLOBAL);
        if (rights != 3) {
            download_FU_btn.setVisible(false);
            this.m_currentURLabel.setVisible(false);
        }
        this.m_sc.setContent((Control)this.mainComp);
        this.m_sc.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle r = DashBoardServicesView.this.m_sc.getClientArea();
                DashBoardServicesView.this.m_sc.setMinSize(DashBoardServicesView.this.mainComp.computeSize(r.width, -1));
            }
        });
        this.refresh();
        IWorkbenchPartSite part = this.getSite();
        part.setSelectionProvider((ISelectionProvider)this);
        this.m_serviceProvider.addRefreshable(this);
    }

    private void createMainComponent() {
        if (this.mainComp == null || this.mainComp.isDisposed()) {
            this.mainComp = new Composite((Composite)this.m_sc, 0);
        }
        this.mainComp.setBackground(BMUI.color_white);
    }

    public void startDashBoard() {
        this.refresh();
    }

    public void stopDashboard() {
        try {
            Control[] children = this.parent.getChildren();
            int i = 0;
            while (i < children.length) {
                children[i].dispose();
                ++i;
            }
        }
        catch (Throwable throwable) {}
        this.setSelection(null);
    }

    public boolean isVisible() {
        return !this.m_sc.isDisposed();
    }

    @Override
    public void refresh() {
        block9: {
            try {
                if (this.m_sc != null && !this.m_sc.isDisposed()) {
                    this.m_sc.getVerticalBar().getThumb();
                    this.m_sc.getVerticalBar().getSelection();
                }
                if (this.mainComp == null || this.mainComp.isDisposed()) {
                    this.createMainComponent();
                } else {
                    Control[] children;
                    Control[] controlArray = children = this.mainComp.getChildren();
                    int n = children.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Control control = controlArray[n2];
                        control.dispose();
                        ++n2;
                    }
                }
                this.createMainComponent();
                this.m_selectionListeners.clear();
                this.dataLoaded();
                this.m_delete_FU_btn.setEnabled(false);
                if (this.m_serviceProvider.getCurrentUserRole() == null) {
                    this.m_currentURLabel.setText(GLOBAL);
                } else {
                    UserRole ur = Repository.getInstance().getUserManager().getRoleByID(this.m_serviceProvider.getCurrentUserRole());
                    if (ur != null) {
                        this.m_currentURLabel.setText("Current UserRole: " + ur.getName());
                        this.m_currentURLabel.getParent().getParent().layout(true, true);
                        this.m_delete_FU_btn.setEnabled(true);
                    }
                }
            }
            catch (Throwable throwable) {
                if (!this.m_sc.isDisposed()) break block9;
                throw new RuntimeException("Widget disposed");
            }
        }
    }

    private void dataLoaded() {
        Map<String, ServiceDashBoard> map = this.m_serviceProvider.getServices();
        ArrayList<ServiceDashBoard> services = new ArrayList<ServiceDashBoard>(map.values());
        Collections.sort(services);
        for (ServiceDashBoard serv : services) {
            this.createServiceCompositeOverview(this.mainComp, serv);
        }
        RowLayout layout = new RowLayout(256);
        layout.wrap = true;
        this.mainComp.setLayout((Layout)layout);
        this.mainComp.pack();
        Point computeSize = this.mainComp.computeSize(-1, -1, true);
        computeSize.y += 40;
        Rectangle r = this.m_sc.getClientArea();
        this.m_sc.setMinSize(this.mainComp.computeSize(r.width, -1));
    }

    private void createServiceCompositeOverview(Composite parent, ServiceDashBoard service) {
        BLabelServiceOverview cl = new BLabelServiceOverview(parent, 0, service);
        BLabelServiceOverview.m_scale = 1.0f;
        cl.setBackground(BMUI.color_critical);
        cl.addMouseListener(this);
        this.createContentMenu(cl);
    }

    public void setFocus() {
    }

    public void dispose() {
        this.stopDashboard();
    }

    public void mouseDoubleClick(MouseEvent e) {
        if (e.getSource() instanceof BLabelServiceOverview) {
            BLabelServiceOverview labelServiceOverview = (BLabelServiceOverview)e.getSource();
            MessagesView.showMessages(labelServiceOverview.getService());
        }
    }

    public void mouseDown(MouseEvent e) {
        if (e.getSource() instanceof BLabelServiceOverview) {
            BLabelServiceOverview labelServiceOverview = (BLabelServiceOverview)e.getSource();
            ServiceDashBoard sdb = labelServiceOverview.getService();
            StructuredSelection selected = new StructuredSelection((Object)sdb);
            this.setSelection((ISelection)selected);
        }
    }

    public void mouseUp(MouseEvent e) {
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.getSource() instanceof Button) {
            Button b = (Button)e.getSource();
            String name = (String)b.getData();
            String loggedUserRoleID = Repository.getInstance().getUserManager().getUserByLoginName((String)Repository.m_user).m_roleID;
            if (name.equals(ADD_BUTTON)) {
                AddServiceAction addService = new AddServiceAction(this.parent.getShell(), this.m_serviceProvider, Repository.getEventProvider(), Repository.getEventsSummary());
                addService.run();
            } else if (name.equals(UPLOAD_BUTTON)) {
                this.m_serviceProvider.uploadToServer();
                this.m_serviceProvider.loadFromServer();
            } else if (name.equals(DOWNLOAD_BUTTON)) {
                this.m_serviceProvider.loadFromServer();
            } else if (name.equals(DOWNLOAD_FOR_ROLE_BUTTON)) {
                List<UserRole> list = Repository.getInstance().getUserManager().getRoleList();
                Collections.sort(list, new Comparator<UserRole>(){

                    @Override
                    public int compare(UserRole o1, UserRole o2) {
                        return o1 == null ? 0 : o1.getName().compareToIgnoreCase(o2.getName());
                    }
                });
                SelectDialog sd = new SelectDialog(this.parent.getShell(), list.toArray(), "Select User role", null);
                sd.setBlockOnOpen(true);
                int res = sd.open();
                if (res == 0) {
                    UserRole ur = (UserRole)sd.getResult();
                    if (ur.getID().equals(loggedUserRoleID)) {
                        this.m_serviceProvider.loadFromServer(null);
                    } else {
                        this.m_serviceProvider.loadFromServer(ur.getID());
                    }
                }
            } else if (DELETE_FOR_ROLE_BUTTON.equals(name)) {
                String currentUserRole = this.m_serviceProvider.getCurrentUserRole();
                if (currentUserRole != null) {
                    ShowSimpleDialog sd = new ShowSimpleDialog(this.getSite().getShell(), "Delete dashboard configuration", "Are you sure you want to delete dashboard configuration\nfor " + this.m_currentURLabel.getText(), "Delete", "Cancel");
                    if (sd.open() == 0) {
                        this.m_serviceProvider.deleteDashBoard();
                        this.m_serviceProvider.loadFromServer(currentUserRole);
                    }
                } else {
                    new ShowMessageBox("Error", "You can't delete GLOBAL dashboard configuration", 512);
                }
            }
            this.m_serviceProvider.refresh();
        }
    }

    public void createContentMenu(BLabelServiceController ctrl) {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        Menu menu = menuMgr.createContextMenu((Control)ctrl);
        ctrl.setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this);
        final String name = "Service: " + ctrl.getService().getName();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                try {
                    manager.add((IAction)new Action(){

                        public String getText() {
                            return "Refresh";
                        }

                        public boolean isEnabled() {
                            return true;
                        }

                        public ImageDescriptor getImageDescriptor() {
                            return BMUI.IMAGE_DESCR_REFRESH;
                        }

                        public void run() {
                            DashBoardServicesView.this.m_serviceProvider.refresh();
                        }
                    });
                    manager.add((IAction)new Action(){

                        public String getText() {
                            return name;
                        }

                        public boolean isEnabled() {
                            return false;
                        }
                    });
                    manager.add((IContributionItem)new Separator());
                    manager.add((IAction)new Action(){

                        public boolean isEnabled() {
                            return Repository.getInstance().getRights(1000) > 1;
                        }

                        public String getText() {
                            return "Show Indications";
                        }

                        public ImageDescriptor getImageDescriptor() {
                            return BMUI.IMAGE_DESC_INDICATIONS;
                        }

                        public void run() {
                            StructuredSelection sel = (StructuredSelection)DashBoardServicesView.this.getSelection();
                            if (sel != null && !sel.isEmpty()) {
                                ServiceDashBoard sdb = (ServiceDashBoard)sel.getFirstElement();
                                MessagesView.showMessages(sdb);
                            }
                        }
                    });
                    manager.add((IAction)new Action(){

                        public String getText() {
                            return "Edit";
                        }

                        public boolean isEnabled() {
                            return DashBoardServicesView.this.m_serviceProvider.isLocalChangesAllowed();
                        }

                        public void run() {
                            StructuredSelection sel = (StructuredSelection)DashBoardServicesView.this.getSelection();
                            if (sel != null && !sel.isEmpty()) {
                                ServiceDashBoard sdb = (ServiceDashBoard)sel.getFirstElement();
                                if (m_openEFSDialogs.containsKey(sdb.getID())) {
                                    EventFilterServiceDialog efsd = m_openEFSDialogs.get(sdb.getID());
                                    efsd.m_shell.setActive();
                                } else {
                                    EventFilterServiceDialog efsd = new EventFilterServiceDialog("  Service: " + sdb.getName(), sdb, DashBoardServicesView.this.m_serviceProvider, false, Repository.getEventProvider(), Repository.getEventsSummary());
                                    efsd.open();
                                    m_openEFSDialogs.put(sdb.getID(), efsd);
                                }
                            }
                        }
                    });
                    manager.add((IAction)new Action(){

                        public String getText() {
                            ServiceDashBoard sdb;
                            StructuredSelection sel = (StructuredSelection)DashBoardServicesView.this.getSelection();
                            if (sel != null && !sel.isEmpty() && (sdb = (ServiceDashBoard)sel.getFirstElement()).isGlobalOnly()) {
                                return "Delete Item on Server";
                            }
                            return "Delete Local Item";
                        }

                        public ImageDescriptor getImageDescriptor() {
                            ISharedImages sharedImages = Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getWorkbench().getSharedImages();
                            return sharedImages.getImageDescriptor("IMG_TOOL_DELETE");
                        }

                        public ImageDescriptor getDisabledImageDescriptor() {
                            ISharedImages sharedImages = Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getWorkbench().getSharedImages();
                            return sharedImages.getImageDescriptor("IMG_TOOL_DELETE_DISABLED");
                        }

                        public boolean isEnabled() {
                            return DashBoardServicesView.this.m_serviceProvider.isLocalChangesAllowed();
                        }

                        public void run() {
                            StructuredSelection sel = (StructuredSelection)DashBoardServicesView.this.getSelection();
                            if (sel != null && !sel.isEmpty()) {
                                boolean value;
                                ServiceDashBoard sdb = (ServiceDashBoard)sel.getFirstElement();
                                String msg = "LOCAL Instance";
                                if (sdb.isGlobalOnly()) {
                                    msg = "GLOBAL Instance";
                                }
                                if (value = MessageDialog.openQuestion((Shell)DashBoardServicesView.this.parent.getShell(), (String)("  Delete " + msg), (String)("Do you want to delete the " + msg + " of the Service '" + sdb.getName() + "'?"))) {
                                    DashBoardServicesView.this.m_serviceProvider.removeService(sdb.getID());
                                    if (sdb.isGlobalOnly()) {
                                        DashBoardServicesView.this.m_serviceProvider.saveGlobalFile();
                                    } else {
                                        DashBoardServicesView.this.m_serviceProvider.saveLocalFile();
                                    }
                                    DashBoardServicesView.this.m_serviceProvider.reload();
                                    DashBoardServicesView.this.m_serviceProvider.refresh();
                                }
                            }
                        }
                    });
                }
                catch (RuntimeException runtimeException) {}
            }
        });
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        if (!this.m_selectionListeners.contains(listener)) {
            this.m_selectionListeners.add(listener);
        }
    }

    public ISelection getSelection() {
        return this.m_selected;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.m_selectionListeners.remove(listener);
    }

    public void setSelection(ISelection selection) {
        Composite com;
        for (Map.Entry<String, ServiceDashBoard> en : this.m_serviceProvider.getServices().entrySet()) {
            en.getValue().setSelected(false);
        }
        this.m_selected = selection;
        if (this.m_selected != null && !this.m_selected.isEmpty() && selection instanceof StructuredSelection) {
            StructuredSelection ss = (StructuredSelection)selection;
            for (Object obj : ss) {
                if (obj == null || !(obj instanceof ServiceDashBoard)) continue;
                ((ServiceDashBoard)obj).setSelected(true);
            }
        }
        if (this.m_sc != null && !this.m_sc.isDisposed() && (com = (Composite)this.m_sc.getContent()) != null && !com.isDisposed()) {
            com.redraw(0, 0, com.getBounds().width, com.getBounds().height, true);
        }
    }
}

