/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.engine.UIJob;
import com.blixx.boom.gui.dialogs.IRefreshable;
import com.blixx.boom.gui.utils.BLabel;
import com.blixx.boom.gui.utils.BLabel2;
import com.blixx.boom.gui.views.MessagesView;
import com.blixx.log.RTLogger;
import com.blixx.shared.Severity;
import com.blixx.shared.utils.HashMapArray;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.part.ViewPart;

public class DashBoardView
extends ViewPart
implements MouseListener,
IRefreshable,
SelectionListener {
    private static final String CNT = "CNT";
    private static final String SEV = "SEV";
    private static final String APP = "APP";
    private static final String GRP = "GRP";
    public static final String ID = "com.blixx.boom.gui.views.dashboardview";
    private static DashBoardView m_instance = null;
    private Composite m_parent = null;
    private ScrolledComposite m_sc = null;
    private List<String> m_groups = null;
    private List<String> m_applications = null;
    private boolean m_pack = false;
    private Label m_corner;
    private static String PACK_BUTTON = "PACK_BUTTON";
    private static String PACK = "  pack ";
    private static String UNPACK = " unpack";

    public static DashBoardView getInstance() {
        return m_instance;
    }

    public DashBoardView() {
        m_instance = this;
    }

    public void createPartControl(Composite parent) {
        if (Repository.getInstance().getRights(1000) <= 1) {
            parent.setLayout((Layout)new GridLayout(2, false));
            Label l = new Label(parent, 0);
            l.setText(" Insufficient rights.");
            l.setForeground(BMUI.color_critical);
            Button close = new Button(parent, 8);
            close.setText("Close");
            close.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    DashBoardView.this.getSite().getPage().hideView(DashBoardView.this.getSite().getPage().findView(DashBoardView.ID));
                }
            });
            UIJob uiJob = new UIJob("Close Viewcom.blixx.boom.gui.views.dashboardview"){

                @Override
                public IStatus runInUIThread(IProgressMonitor monitor) {
                    DashBoardView.this.getSite().getPage().hideView(DashBoardView.this.getSite().getPage().findView(DashBoardView.ID));
                    return Status.OK_STATUS;
                }
            };
            Repository.getUIJobManager().schedule(uiJob);
            return;
        }
        this.m_parent = new Composite(parent, 0);
        this.m_parent.setLayout((Layout)new FillLayout(512));
        Repository.getEventProvider().registerRefreshable(this, false);
    }

    public void startDashBoard() {
        this.refresh();
        Repository.getEventProvider().registerRefreshable(this, false);
    }

    public void stopDashboard() {
        Repository.getEventProvider().unregisterRefreshable(this, false);
        try {
            Control[] children = this.m_parent.getChildren();
            int i = 0;
            while (i < children.length) {
                children[i].dispose();
                ++i;
            }
        }
        catch (Exception exception) {}
    }

    public boolean isVisible() {
        return !this.m_sc.isDisposed();
    }

    @Override
    public void refresh() {
        if (this.m_parent == null || this.m_parent.isDisposed()) {
            throw new SWTException(39);
        }
        try {
            if (this.m_parent == null || !this.m_parent.isVisible()) {
                return;
            }
            Control[] children = this.m_parent.getChildren();
            if (children.length == 0) {
                this.dataLoaded();
            } else {
                int i = 0;
                while (i < children.length) {
                    children[i].dispose();
                    ++i;
                }
                long start = System.currentTimeMillis();
                this.dataLoaded();
                RTLogger.print(5, "Dashboard refresh takes: " + (System.currentTimeMillis() - start) + "ms");
            }
            this.m_parent.layout();
        }
        catch (Throwable throwable) {}
    }

    public void dataLoaded() {
        HashMapArray<String, Integer> msggrps = Repository.getEventsSummary().getMsgGrps();
        Iterator itk = msggrps.keySet().iterator();
        while (itk.hasNext()) {
            String key = (String)itk.next();
            Iterator<Integer> itv = msggrps.iterator(key);
            boolean notempty = false;
            if (itv.hasNext()) {
                itv.next();
                while (itv.hasNext()) {
                    if (itv.next() <= 0) continue;
                    notempty = true;
                    break;
                }
            }
            if (notempty) continue;
            itk.remove();
        }
        this.m_sc = new ScrolledComposite(this.m_parent, 768);
        this.m_sc.setExpandHorizontal(true);
        this.m_sc.setExpandVertical(true);
        Composite header = new Composite((Composite)this.m_sc, 2048);
        header.setBackground(BMUI.color_white);
        GridLayout gl = new GridLayout(msggrps.size() + 2, false);
        gl.marginHeight = 1;
        gl.marginWidth = 1;
        gl.horizontalSpacing = 1;
        gl.verticalSpacing = 1;
        header.setLayout((Layout)gl);
        header.setLayoutData((Object)new GridData(4, 128, false, false));
        Composite cornerComp = new Composite(header, 0);
        gl = new GridLayout(1, false);
        gl.marginHeight = 0;
        gl.marginWidth = 5;
        cornerComp.setLayout((Layout)gl);
        cornerComp.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.m_corner = new Label(cornerComp, 0);
        this.m_corner.setImage(BMUI.IMAGE_APPGRP_PACK);
        GridData cornerGD = new GridData(0x1000000, 0x1000000, true, true);
        this.m_corner.setLayoutData((Object)cornerGD);
        this.m_corner.setToolTipText("Double-click here to pack/unpack the view");
        Button btn = new Button(cornerComp, 8);
        btn.setData((Object)PACK_BUTTON);
        btn.setBackground(BMUI.color_white);
        btn.setText(this.m_pack ? UNPACK : PACK);
        btn.setAlignment(0x1000000);
        btn.setLayoutData((Object)new GridData(0x1000000, 128, true, true));
        btn.setToolTipText(this.m_pack ? "Click here to UNPACK the view!" : "Click here to PACK the view!");
        btn.addSelectionListener((SelectionListener)this);
        this.m_groups = new ArrayList(msggrps.keySet());
        Collections.sort(this.m_groups);
        for (String name : this.m_groups) {
            this.createGroupComposite(header, msggrps, name);
        }
        HashMapArray<String, Integer> appls = Repository.getEventsSummary().getApplications();
        Composite emptyComp = new Composite(header, 0);
        emptyComp.setBackground(BMUI.color_white);
        gl = new GridLayout(1, false);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        emptyComp.setLayout((Layout)gl);
        GridData gd = new GridData(4, 4, true, false, 1, 1);
        gd.verticalSpan = appls.size() + 1;
        emptyComp.setLayoutData((Object)gd);
        this.m_applications = new ArrayList(appls.keySet());
        Collections.sort(this.m_applications);
        for (String name : this.m_applications) {
            this.createApplComposite(this.m_groups, header, appls.getArray(name), name);
        }
        this.m_sc.setContent((Control)header);
        this.m_sc.setMinSize(header.computeSize(-1, -1, true));
    }

    private void createApplComposite(List<String> msggrps, Composite header, List<Integer> severities, String name) {
        Composite application = new Composite(header, 2048);
        GridLayout groupLayout = new GridLayout(2, false);
        groupLayout.marginHeight = 1;
        groupLayout.marginWidth = 1;
        groupLayout.horizontalSpacing = 1;
        groupLayout.verticalSpacing = 1;
        application.setLayout((Layout)groupLayout);
        GridData groupGD = new GridData();
        groupGD.horizontalAlignment = 4;
        groupGD.verticalAlignment = 4;
        application.setLayoutData((Object)groupGD);
        BLabel l = new BLabel(application, 0);
        l.setVertical(false);
        l.setText(name);
        l.setData(name);
        l.setToolTipText(name);
        l.setData(APP, name);
        l.setPacked(this.m_pack);
        l.addMouseListener(this);
        GridData ggd1 = new GridData();
        ggd1.minimumWidth = 16;
        if (this.m_pack) {
            ggd1.horizontalIndent = 0;
            ggd1.widthHint = 80;
        }
        ggd1.horizontalSpan = 2;
        ggd1.horizontalAlignment = 16384;
        l.setLayoutData(ggd1);
        List<Integer> arr = severities;
        if (arr == null) {
            arr = new ArrayList<Integer>();
            arr.add(0);
            arr.add(0);
            arr.add(0);
            arr.add(0);
            arr.add(0);
            arr.add(0);
        }
        BLabel2 l2 = new BLabel2(application, 2048);
        l2.setSeverities(arr);
        l2.setApplication(name);
        l2.setVertical(false);
        l2.setPacked(this.m_pack);
        String tooltip = "normal: " + arr.get(1) + "\nwarning: " + arr.get(2) + "\nminor: " + arr.get(3) + "\nmajor: " + arr.get(4) + "\ncritical: " + arr.get(5);
        l2.setToolTipText(tooltip);
        l2.addMouseListener(this);
        GridData gdL2 = new GridData(4, 128, true, false);
        if (this.m_pack) {
            gdL2.horizontalIndent = 0;
            gdL2.minimumWidth = 80;
            gdL2.widthHint = 80;
        } else {
            gdL2.minimumWidth = 80;
            gdL2.widthHint = 160;
        }
        gdL2.horizontalSpan = 2;
        gdL2.horizontalAlignment = 16384;
        l2.setLayoutData(gdL2);
        int max = 1;
        int totalMsgs = 0;
        int j = 1;
        while (j < 6) {
            Integer count = arr.get(j);
            if (count == null) {
                count = 0;
            }
            if (count != 0) {
                max = j;
                totalMsgs += max;
            }
            ++j;
        }
        l.setImage(BMUI.getBox(max));
        if (totalMsgs == 0) {
            application.dispose();
            return;
        }
        HashMapArray<String, Integer> GandA = Repository.getEventsSummary().getGRPandAPP();
        Label last = null;
        int i = 0;
        while (i < msggrps.size()) {
            String grp = msggrps.get(i);
            List<Integer> sevsCross = GandA.getArray(String.valueOf(grp) + '\u25ba' + name);
            if (sevsCross != null) {
                Label iconCross = new Label(header, 0);
                last = null;
                int maxSevCross = 0;
                int j2 = 1;
                while (j2 < sevsCross.size()) {
                    if (sevsCross.get(j2) > 0) {
                        maxSevCross = Math.max(maxSevCross, j2);
                    }
                    ++j2;
                }
                iconCross.setImage(BMUI.getBox(maxSevCross));
                GridData ggd = new GridData();
                ggd.verticalAlignment = 4;
                ggd.horizontalAlignment = 4;
                iconCross.setLayoutData((Object)ggd);
                iconCross.setAlignment(0x1000000);
                iconCross.setData(APP, (Object)name);
                iconCross.setData(GRP, (Object)grp);
                iconCross.setData(SEV, (Object)maxSevCross);
                iconCross.setData(CNT, (Object)0);
                iconCross.addMouseListener((MouseListener)this);
                iconCross.setToolTipText("Group: " + grp + " App: " + name);
                if (maxSevCross == 0) {
                    iconCross.setVisible(false);
                }
            } else if (last == null) {
                Label b = new Label(header, 0);
                b.setVisible(false);
                GridData gGD = new GridData();
                gGD.widthHint = 0;
                gGD.minimumHeight = 0;
                gGD.minimumWidth = 0;
                gGD.heightHint = 0;
                gGD.verticalIndent = 0;
                gGD.horizontalIndent = 0;
                gGD.verticalSpan = 1;
                gGD.horizontalSpan = 1;
                b.setLayoutData((Object)gGD);
                b.setEnabled(false);
                last = b;
            } else {
                GridData gd = (GridData)last.getLayoutData();
                ++gd.horizontalSpan;
            }
            ++i;
        }
    }

    private void createGroupComposite(Composite parent, HashMapArray<String, Integer> mapArray, String name) {
        Composite group = new Composite(parent, 2048);
        GridLayout groupLayout = new GridLayout(1, false);
        groupLayout.marginHeight = 1;
        groupLayout.marginWidth = 1;
        groupLayout.horizontalSpacing = 1;
        groupLayout.verticalSpacing = 1;
        group.setLayout((Layout)groupLayout);
        GridData groupGD = new GridData();
        groupGD.horizontalAlignment = 4;
        if (this.m_pack) {
            groupGD.minimumWidth = 22;
            groupGD.widthHint = 22;
        } else {
            groupGD.minimumWidth = 40;
        }
        group.setLayoutData((Object)groupGD);
        BLabel l = new BLabel(group, 0);
        l.setText("\n" + name);
        l.setData(name);
        l.setToolTipText(name);
        l.setData(GRP, name);
        l.setVertical(true);
        l.setPacked(this.m_pack);
        l.addMouseListener(this);
        GridData ggd1 = new GridData();
        if (this.m_pack) {
            ggd1.widthHint = 18;
            l.setAlignment(16384);
        } else {
            ggd1.minimumWidth = 18;
            l.setAlignment(0x1000000);
        }
        ggd1.horizontalAlignment = 4;
        ggd1.heightHint = 32;
        ggd1.grabExcessHorizontalSpace = true;
        l.setLayoutData(ggd1);
        List<Integer> arr = mapArray.getArray(name);
        int max = 1;
        int totalMsgs = 0;
        if (arr == null) {
            arr = new ArrayList<Integer>();
            arr.add(0);
            arr.add(0);
            arr.add(0);
            arr.add(0);
            arr.add(0);
            arr.add(0);
        }
        BLabel2 l2 = new BLabel2(group, 2048);
        l2.setSeverities(arr);
        l2.setGroup(name);
        String tooltip = "normal: " + arr.get(1) + "\nwarning: " + arr.get(2) + "\nminor: " + arr.get(3) + "\nmajor: " + arr.get(4) + "\ncritical: " + arr.get(5);
        l2.setToolTipText(tooltip);
        l2.setVertical(true);
        l2.setPacked(this.m_pack);
        l2.addMouseListener(this);
        GridData gdL2 = new GridData(4, 4, true, false);
        gdL2.widthHint = 18;
        gdL2.minimumWidth = 18;
        if (this.m_pack) {
            l2.setAlignment(16384);
        } else {
            l2.setAlignment(0x1000000);
        }
        gdL2.heightHint = 76;
        l2.setLayoutData(gdL2);
        int j = 1;
        while (j < 6) {
            Integer count = arr.get(j);
            if (count == null) {
                count = 0;
            }
            if (count != 0) {
                max = j;
                totalMsgs += max;
            }
            ++j;
        }
        l.setImage(BMUI.getBox(max));
        if (totalMsgs == 0) {
            Control[] ctrls = group.getChildren();
            int i = 0;
            while (i < ctrls.length) {
                try {
                    ctrls[i].dispose();
                }
                catch (Throwable throwable) {}
                ++i;
            }
            GridData gGD = new GridData();
            gGD.widthHint = 0;
            gGD.minimumHeight = 0;
            gGD.minimumWidth = 0;
            gGD.heightHint = 0;
            gGD.verticalIndent = 0;
            gGD.horizontalIndent = 0;
            gGD.verticalSpan = 0;
            gGD.horizontalSpan = 0;
            group.setLayoutData((Object)gGD);
            group.setVisible(false);
        }
    }

    public void setFocus() {
    }

    public void dispose() {
        this.stopDashboard();
    }

    public void mouseDoubleClick(MouseEvent e) {
        if (e.getSource() instanceof Label) {
            Label l = (Label)e.getSource();
            String group = (String)l.getData(GRP);
            String appl = (String)l.getData(APP);
            Integer sev = (Integer)l.getData(SEV);
            if (sev == null) {
                sev = -1;
            }
            StringBuffer sb = new StringBuffer();
            if (group != null) {
                sb.append("Group:" + group).append(" ");
            }
            if (appl != null) {
                sb.append("Application:" + appl).append(" ");
            }
            MessagesView.showMessages(sb.toString(), null, appl, group, null, sev, null, 0, 0);
        } else if (e.getSource() instanceof BLabel) {
            BLabel l = (BLabel)((Object)e.getSource());
            String group = (String)l.getData(GRP);
            String appl = (String)l.getData(APP);
            Integer sev = (Integer)l.getData(SEV);
            if (sev == null) {
                sev = -1;
            }
            StringBuffer sb = new StringBuffer();
            if (group != null) {
                sb.append("Group:" + group).append(" ");
            }
            if (appl != null) {
                sb.append("Application:" + appl).append(" ");
            }
            MessagesView.showMessages(sb.toString(), null, appl, group, null, sev, null, 0, 0);
        } else if (e.getSource() instanceof BLabel2) {
            BLabel2 l = (BLabel2)((Object)e.getSource());
            List<Integer> severities = l.getSeverities();
            String group = l.getGroup();
            String appl = l.getAppliaction();
            int total = 0;
            int single = 0;
            int e_XY = 0;
            if (l.isVertical().booleanValue()) {
                total = ((GridData)l.getLayoutData()).heightHint;
                single = total / 5;
                e_XY = e.y;
            } else {
                total = ((GridData)l.getLayoutData()).widthHint;
                single = total / 5;
                e_XY = e.x;
            }
            int i = 0;
            while (i < 5) {
                int start = i * single + 1;
                int end = start - 1 + single;
                if (start < e_XY && e_XY < end) {
                    int count = severities.get(i + 1);
                    if (count == 0) {
                        return;
                    }
                    Integer sev = i + 1;
                    StringBuffer sb = new StringBuffer();
                    if (group != null) {
                        sb.append("Group:" + group).append(" ");
                    }
                    if (appl != null) {
                        sb.append("Application:" + appl).append(" ");
                    }
                    String severity = null;
                    severity = sev == 2 ? String.valueOf(Severity.getSeverity(1)) + "|" + Severity.getSeverity(2) : Severity.getSeverity(sev);
                    sb.append("(" + severity + ")").append(" ");
                    MessagesView.showMessages(sb.toString(), null, appl, group, null, sev, null, 0, 0);
                    return;
                }
                ++i;
            }
        }
    }

    public void mouseDown(MouseEvent e) {
    }

    public void mouseUp(MouseEvent e) {
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        Button b;
        String name;
        if (e.getSource() instanceof Button && (name = (String)(b = (Button)e.getSource()).getData()).equals(PACK_BUTTON)) {
            this.m_pack = !this.m_pack;
            UIJob job = new UIJob("RefreshDabo"){

                @Override
                public IStatus runInUIThread(IProgressMonitor monitor) {
                    DashBoardView.this.refresh();
                    return Status.OK_STATUS;
                }
            };
            Repository.getUIJobManager().schedule(job);
            return;
        }
    }
}

