/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views;

import com.blixx.boom.engine.AgentCard;
import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.EventStorageUtils;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.engine.UIJob;
import com.blixx.boom.gui.dialogs.IRefreshable;
import com.blixx.boom.gui.utils.BLabel;
import com.blixx.boom.gui.utils.BLabel2;
import com.blixx.boom.gui.utils.FilterComposite;
import com.blixx.boom.gui.utils.GUIDisplayElements;
import com.blixx.boom.gui.views.AgentCardView;
import com.blixx.boom.gui.views.DashBoardGraph2D;
import com.blixx.boom.gui.views.DashBoardViewHostTableProvider;
import com.blixx.boom.gui.views.MessagesView;
import com.blixx.boom.gui.views.actions.SelectAgentInTreeAction;
import com.blixx.boom.gui.views.actions.ShowAssignedPoliciesAction;
import com.blixx.boom.gui.views.actions.ShowRelatedHostInfosAction;
import com.blixx.shared.SEvent;
import com.blixx.shared.Severity;
import com.blixx.shared.utils.HashMapArray;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.part.ViewPart;

public class DashBoardView2
extends ViewPart
implements MouseListener,
IRefreshable,
SelectionListener,
ISelectionChangedListener {
    public static final String ID = "com.blixx.boom.gui.views.dashboardview2";
    private static final String SEV = "SEV";
    private static final String APP = "APP";
    private static final String GRP = "GRP";
    public static Integer HOST = 0;
    public static Integer AGENT = 1;
    private static DashBoardView2 m_instance = null;
    private DashBoardGraph2D m_dashboardGraph2D = null;
    public Composite m_parent = null;
    private ScrolledComposite m_sc = null;
    private boolean m_pack = true;
    private static String DISPLAY_ALL_CHK = "DISPLAY_ALL_BUTTON";
    private SashForm m_mainSash = null;
    private DashBoardViewHostTableProvider m_hostTableProvider = null;
    private TableViewer m_tableViewer = null;
    public static String VIEWER_TYPE = "VIEWER_TYPE";
    public static String HOST_LIST = "HOST_LIST";
    public static final String COL_HOSTS = "Hosts";
    public static final String COL_TYPE = "Type";
    private FilterComposite m_filterComp = null;
    private Composite m_footerComp = null;
    private Text m_hostCountField = null;
    private Button m_displayAll_chk = null;
    private boolean m_displayAll = true;
    private GUIDisplayElements m_gui = null;
    private HashMapArray<String, Integer> m_grpsApps = new HashMapArray();
    private HashMapArray<String, Integer> m_hostsApps = new HashMapArray();
    private HashMapArray<String, Integer> m_hostsGrps = new HashMapArray();
    private Map<String, Integer> m_hostAndType = new HashMap<String, Integer>();
    private Map<String, Object> m_filteredHosts = new HashMap<String, Object>();
    private Map<String, Object> m_selectedHosts = new HashMap<String, Object>();
    private HashMapArray<String, Integer> m_grps2Display = new HashMapArray();
    private HashMapArray<String, Integer> m_appl2Display = new HashMapArray();
    private String m_filterText = null;
    private Listener sortListener = new Listener(){

        public void handleEvent(Event e) {
            TableColumn currentColumn = (TableColumn)e.widget;
            Table t = currentColumn.getParent();
            TableViewer tableViewer = (TableViewer)t.getData();
            if (e.type == 13) {
                TableColumn sortColumn = tableViewer.getTable().getSortColumn();
                int dir = tableViewer.getTable().getSortDirection();
                if (sortColumn == currentColumn) {
                    dir = dir == 128 ? 1024 : 128;
                } else {
                    tableViewer.getTable().setSortColumn(currentColumn);
                    dir = 128;
                }
                ISelection iSelection = tableViewer.getSelection();
                DashBoardView2.this.m_hostTableProvider.setConfig(currentColumn.getText(), dir);
                tableViewer.getTable().setSortDirection(dir);
                tableViewer.refresh();
                tableViewer.setSelection(iSelection);
            }
        }
    };
    private Composite m_dashboardComp;

    public static DashBoardView2 getInstance() {
        return m_instance;
    }

    public DashBoardView2() {
        m_instance = this;
        this.m_gui = new GUIDisplayElements();
    }

    public void createPartControl(Composite parent) {
        if (Repository.getInstance().getRights(1000) < 2) {
            parent.setLayout((Layout)new GridLayout(2, false));
            Label l = new Label(parent, 0);
            l.setText(" Insufficient rights.");
            l.setForeground(BMUI.color_critical);
            Button close = new Button(parent, 8);
            close.setText("Close");
            close.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    DashBoardView2.this.getSite().getPage().hideView(DashBoardView2.this.getSite().getPage().findView(DashBoardView2.ID));
                }
            });
            UIJob uiJob = new UIJob("Close Viewcom.blixx.boom.gui.views.dashboardview2"){

                @Override
                public IStatus runInUIThread(IProgressMonitor monitor) {
                    DashBoardView2.this.getSite().getPage().hideView(DashBoardView2.this.getSite().getPage().findView(DashBoardView2.ID));
                    return Status.OK_STATUS;
                }
            };
            Repository.getUIJobManager().schedule(uiJob);
            return;
        }
        this.m_parent = new Composite(parent, 0);
        this.m_parent.setLayout((Layout)new FillLayout(512));
        Repository.getEventProvider().registerRefreshable(this, false);
    }

    public void startDashBoard() {
        try {
            this.refresh();
            this.setTableSelection();
            Repository.getEventProvider().registerRefreshable(this, false);
        }
        catch (SWTException sWTException) {}
    }

    public void stopDashboard() {
        try {
            this.m_filterText = this.m_filterComp.getFilter();
            Repository.getEventProvider().unregisterRefreshable(this, false);
            Control[] children = this.m_parent.getChildren();
            int i = 0;
            while (i < children.length) {
                children[i].dispose();
                ++i;
            }
        }
        catch (Exception exception) {}
    }

    public boolean isVisible() {
        return !this.m_sc.isDisposed();
    }

    @Override
    public synchronized void refresh() {
        if (this.m_parent == null || this.m_parent.isDisposed()) {
            throw new SWTException(39);
        }
        if (this.m_parent == null || !this.m_parent.isVisible()) {
            return;
        }
        try {
            this.loadData();
            this.createContent();
            this.m_parent.layout();
        }
        catch (Throwable throwable) {}
    }

    public void loadData() {
        this.m_hostAndType.clear();
        HashMapArray<String, Integer> hosts = Repository.getEventsSummary().getHosts();
        Iterator it = hosts.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            List li = (List)entry.getValue();
            int t = 0;
            int i = 1;
            while (i < li.size()) {
                t += ((Integer)li.get(i)).intValue();
                ++i;
            }
            if (t != 0) continue;
            it.remove();
        }
        ArrayList hostList = new ArrayList(hosts.keySet());
        for (String key : hostList) {
            int indexOf = key.indexOf(9658);
            if (indexOf == -1) continue;
            String node = key.substring(0, indexOf);
            String agentNode = key.substring(indexOf + 1, key.length());
            int typeNew = HOST;
            if (node.equals(agentNode)) {
                typeNew = AGENT;
            }
            if (this.m_hostAndType.containsKey(node)) {
                int typeExist = this.m_hostAndType.get(node);
                if (typeNew <= typeExist) continue;
                this.m_hostAndType.put(node, Math.max(typeNew, typeExist));
                continue;
            }
            this.m_hostAndType.put(node, typeNew);
        }
        boolean isFiltered = this.isFiltered();
        this.m_appl2Display.clear();
        this.m_hostsApps = Repository.getEventsSummary().getAppAndHost();
        HashMapArray<String, Integer> appls = Repository.getEventsSummary().getApplications();
        ArrayList applications = new ArrayList(appls.keySet());
        Collections.sort(applications);
        for (String applName : applications) {
            List<Integer> sevSum = this.getSevForApplication(applName, isFiltered);
            if (sevSum == null) continue;
            this.m_appl2Display.put(applName, sevSum);
        }
        this.m_grps2Display.clear();
        this.m_hostsGrps = Repository.getEventsSummary().getGrpAndHost();
        HashMapArray<String, Integer> grps = Repository.getEventsSummary().getMsgGrps();
        ArrayList groups = new ArrayList(grps.keySet());
        Collections.sort(groups);
        for (String grpName : groups) {
            List<Integer> sevSum = this.getSevForGroup(grpName, isFiltered);
            if (sevSum == null) continue;
            this.m_grps2Display.put(grpName, sevSum);
        }
        this.recalcAppGrpCross();
    }

    public void recalcAppGrpCross() {
        if (this.m_grpsApps == null) {
            this.m_grpsApps = new HashMapArray();
        }
        this.m_grpsApps.clear();
        if (this.isDisplayAll()) {
            this.m_grpsApps.putAll(Repository.getEventsSummary().getGRPandAPP());
        } else {
            for (Map.Entry<String, SEvent> entry : Repository.getEventProvider().getActiveMap().entrySet()) {
                SEvent se = entry.getValue();
                String host = se.getNode();
                String key = new StringBuffer().append(se.getGroup()).append('\u25ba').append(se.getApplication()).toString();
                if (this.m_selectedHosts.size() > 0) {
                    if (!this.m_selectedHosts.containsKey(host)) continue;
                    this._processSEvent_GrpApp(se, key);
                    continue;
                }
                if (!this.m_filteredHosts.containsKey(host)) continue;
                this._processSEvent_GrpApp(se, key);
            }
        }
    }

    private void _processSEvent_GrpApp(SEvent se, String key) {
        List<Integer> current = this.m_grpsApps.getArray(key);
        int pos = this.getPosition(se.getSeverityInt());
        if (current == null) {
            current = new ArrayList<Integer>(EventStorageUtils.sevEmpty);
            current.set(pos, 1);
            this.m_grpsApps.put(key, current);
        } else {
            current.set(pos, current.get(pos) + 1);
        }
    }

    private int getPosition(int severity) {
        if (severity < 0) {
            severity += 6;
        }
        switch (severity) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 5;
            }
        }
        return 0;
    }

    public void createContent() {
        if (this.m_mainSash == null || this.m_mainSash.isDisposed()) {
            this.m_mainSash = new SashForm(this.m_parent, 256);
            this.createTable();
            this.createDashBoard2D();
            this.m_mainSash.setWeights(new int[]{1, 6});
        } else {
            this.updateTable();
            this.setFilteredHosts();
            this.createDashBoard2D();
        }
    }

    private void createTable() {
        Composite tableComp = new Composite((Composite)this.m_mainSash, 2048);
        GridLayout gl = new GridLayout(2, false);
        gl.horizontalSpacing = 0;
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        tableComp.setLayout((Layout)gl);
        tableComp.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.m_displayAll_chk = this.m_gui.addCheckbox(tableComp, DISPLAY_ALL_CHK, "Display All", this.m_displayAll, this);
        GridData gd = new GridData();
        gd.verticalIndent = 3;
        gd.horizontalIndent = 3;
        this.m_displayAll_chk.setLayoutData((Object)gd);
        this.m_filterComp = new FilterComposite(tableComp, this);
        this.m_filterComp.setCompositeLayoutData(new GridData(4, 0x1000000, true, false, 2, 1));
        Table table = new Table(tableComp, 268503810);
        table.setHeaderVisible(true);
        table.setLinesVisible(false);
        gl = new GridLayout(1, false);
        gl.verticalSpacing = 0;
        gl.horizontalSpacing = 0;
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        table.setLayout((Layout)gl);
        table.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.m_tableViewer = new TableViewer(table);
        this.m_tableViewer.setData(VIEWER_TYPE, (Object)HOST_LIST);
        this.m_hostTableProvider = new DashBoardViewHostTableProvider(this.m_hostAndType, COL_HOSTS, 128);
        TableColumn col0 = new TableColumn(table, 16384);
        col0.setText(COL_HOSTS);
        col0.setWidth(100);
        col0.addListener(13, this.sortListener);
        TableColumn col1 = new TableColumn(table, 16384);
        col1.setText(COL_TYPE);
        col1.setWidth(50);
        col1.addListener(13, this.sortListener);
        this.m_tableViewer.setContentProvider((IContentProvider)this.m_hostTableProvider);
        this.m_tableViewer.setLabelProvider((IBaseLabelProvider)this.m_hostTableProvider);
        this.m_tableViewer.setInput((Object)this.m_hostTableProvider.getElements(null));
        this.m_tableViewer.setSorter((ViewerSorter)this.m_hostTableProvider);
        this.m_tableViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        table.setData((Object)this.m_tableViewer);
        table.addMouseListener((MouseListener)this);
        this.createTable_ContentMenu();
        this.m_footerComp = new Composite(tableComp, 0);
        gl = new GridLayout(2, false);
        gl.verticalSpacing = 0;
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        gl.marginBottom = 3;
        this.m_footerComp.setLayout((Layout)gl);
        this.m_footerComp.setLayoutData((Object)new GridData(4, 4, true, false));
        this.m_hostCountField = this.m_gui.addTextReadOnlyNoBorder(this.m_footerComp, "Total Hosts: ", "", 1, 1, 1, 1, null);
        this.updateTableFooter();
        if (this.m_filterText != null && this.m_filterText.length() > 0) {
            this.m_filterComp.setFilter(this.m_filterText);
        }
    }

    public void createTable_ContentMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(false);
        Menu menu = menuMgr.createContextMenu(this.m_tableViewer.getControl());
        this.m_tableViewer.getControl().setMenu(menu);
        IWorkbenchPartSite site = AgentCardView.getInstance().getSite();
        site.registerContextMenu(menuMgr, (ISelectionProvider)this.m_tableViewer);
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                try {
                    StructuredSelection ssel = (StructuredSelection)DashBoardView2.this.m_tableViewer.getSelection();
                    if (!ssel.isEmpty()) {
                        String hostName = (String)ssel.getFirstElement();
                        AgentCard firstSelectedAC = Repository.getInstance().getAgentCardByHostname(hostName);
                        ArrayList<AgentCard> selectedACs = DashBoardView2.this.getSelectedAgentCards();
                        SelectAgentInTreeAction selectAgent = new SelectAgentInTreeAction(firstSelectedAC);
                        manager.add((IAction)selectAgent);
                        if (ssel.size() > 1) {
                            selectAgent.setEnabled(false);
                        }
                        ShowRelatedHostInfosAction showRelGroups = new ShowRelatedHostInfosAction(DashBoardView2.this.m_tableViewer, firstSelectedAC, DashBoardView2.this.m_parent.getShell());
                        manager.add((IAction)showRelGroups);
                        if (ssel.size() > 1) {
                            showRelGroups.setEnabled(false);
                        }
                        manager.add((IAction)new ShowIndications(DashBoardView2.this.m_tableViewer.getTable()));
                        manager.add((IContributionItem)new Separator());
                        manager.add((IAction)new ShowAssignedPoliciesAction(selectedACs));
                    }
                }
                catch (RuntimeException runtimeException) {}
            }
        });
    }

    public void createDashBoard2D() {
        if (this.m_sc == null || this.m_sc.isDisposed()) {
            this.m_sc = new ScrolledComposite((Composite)this.m_mainSash, 768);
            this.m_sc.setExpandHorizontal(true);
            this.m_sc.setExpandVertical(true);
            this.m_dashboardComp = new Composite((Composite)this.m_sc, 2048);
            this.m_dashboardComp.setBackground(BMUI.color_white);
            GridLayout gl = new GridLayout(1, false);
            gl.marginWidth = 0;
            gl.marginHeight = 0;
            gl.verticalSpacing = 0;
            gl.horizontalSpacing = 0;
            this.m_dashboardComp.setLayout((Layout)gl);
            this.m_dashboardComp.setLayoutData((Object)new GridData(4, 128, false, false));
            this.m_dashboardGraph2D = new DashBoardGraph2D(this.m_dashboardComp, 0, m_instance);
            this.m_sc.setContent((Control)this.m_dashboardComp);
        }
        this.m_dashboardGraph2D.init(this.m_pack);
        ArrayList<String> grps2Display = new ArrayList<String>(this.m_grps2Display.keySet());
        Collections.sort(grps2Display);
        for (String grpName : grps2Display) {
            List<Integer> sev = this.m_grps2Display.getArray(grpName);
            this.m_dashboardGraph2D.addGroup(grpName, sev);
        }
        ArrayList AppKeys = new ArrayList(this.m_appl2Display.keySet());
        Collections.sort(AppKeys);
        for (String applName : AppKeys) {
            List<Integer> sev = this.m_appl2Display.getArray(applName);
            if (sev == null) continue;
            this.m_dashboardGraph2D.addApplicaton(grps2Display, this.m_grpsApps, applName, sev);
        }
        this.m_dashboardGraph2D.paint();
        this.m_dashboardGraph2D.pack(true);
        this.m_sc.setMinSize(this.m_dashboardComp.computeSize(-1, -1, true));
    }

    public void updateTable() {
        this.m_tableViewer.setInput((Object)this.m_hostTableProvider.getElements(this.m_hostAndType));
        this.updateTableFooter();
    }

    public void updateTableFooter() {
        this.m_hostCountField.setText("" + this.m_tableViewer.getTable().getItemCount());
        this.m_footerComp.pack();
    }

    private void setTableSelection() {
        if (this.m_selectedHosts.size() == 0) {
            if (this.m_tableViewer != null) {
                this.m_tableViewer.getTable().deselectAll();
            }
        } else {
            TableItem[] tableItems = this.m_tableViewer.getTable().getItems();
            TableItem[] items = new TableItem[this.m_selectedHosts.size()];
            int count = 0;
            int ii = 0;
            while (ii < tableItems.length) {
                TableItem ti = tableItems[ii];
                if (this.m_selectedHosts.containsKey(ti.getText(0))) {
                    items[count] = ti;
                    ++count;
                }
                ++ii;
            }
            if (this.m_tableViewer != null) {
                this.m_tableViewer.getTable().setSelection(items);
            }
        }
    }

    public List<String> getGroups4Appl(String applName) {
        LinkedList<String> grps = new LinkedList<String>();
        String grp = null;
        String app = null;
        for (String key : this.m_grpsApps.keySet()) {
            int iOf = key.indexOf(9658);
            if (iOf == -1) continue;
            grp = key.substring(0, iOf);
            app = key.substring(iOf + 1);
            if (!app.equals(applName) || grps.contains(grp)) continue;
            grps.add(grp);
        }
        return grps;
    }

    private List<Integer> getSevForGroup(String group, boolean isFiltered) {
        Iterator hostGrpIT = this.m_hostsGrps.keySet().iterator();
        StringBuffer sb = null;
        String hostAndGrp = null;
        List<Integer> sev = null;
        while (hostGrpIT.hasNext()) {
            List sevNew;
            hostAndGrp = (String)hostGrpIT.next();
            if (this.m_selectedHosts.size() == 0 && !isFiltered) {
                String grp;
                int indOf = hostAndGrp.indexOf(9658);
                if (indOf == -1 || !group.equals(grp = hostAndGrp.substring(0, indOf))) continue;
                sevNew = (List)this.m_hostsGrps.get(hostAndGrp);
                sev = this.summerizeSeverities(sev, sevNew);
                continue;
            }
            if (this.m_selectedHosts.size() > 0) {
                for (String host : this.m_selectedHosts.keySet()) {
                    sb = new StringBuffer().append(group).append('\u25ba').append(host);
                    if (!hostAndGrp.equals(sb.toString())) continue;
                    sevNew = (List)this.m_hostsGrps.get(hostAndGrp);
                    sev = this.summerizeSeverities(sev, sevNew);
                }
                continue;
            }
            for (String host : this.m_filteredHosts.keySet()) {
                sb = new StringBuffer().append(group).append('\u25ba').append(host);
                if (!hostAndGrp.equals(sb.toString())) continue;
                sevNew = (List)this.m_hostsGrps.get(hostAndGrp);
                sev = this.summerizeSeverities(sev, sevNew);
            }
        }
        if (sev != null) {
            boolean empty = true;
            Iterator it = sev.iterator();
            while (it.hasNext()) {
                int s = (Integer)it.next();
                if (s <= 0) continue;
                empty = false;
                break;
            }
            if (empty) {
                sev = null;
            }
        }
        return sev;
    }

    private List<Integer> getSevForApplication(String application, boolean isFiltered) {
        Iterator hostsAndAppsIT = this.m_hostsApps.keySet().iterator();
        StringBuffer sb = null;
        String hostAndApp = null;
        List<Integer> sev = null;
        while (hostsAndAppsIT.hasNext()) {
            List sevNew;
            hostAndApp = (String)hostsAndAppsIT.next();
            if (this.m_selectedHosts.size() == 0 && !isFiltered) {
                String app;
                int indOf = hostAndApp.indexOf(9658);
                if (indOf == -1 || !application.equals(app = hostAndApp.substring(0, indOf))) continue;
                sevNew = (List)this.m_hostsApps.get(hostAndApp);
                sev = this.summerizeSeverities(sev, sevNew);
                continue;
            }
            if (this.m_selectedHosts.size() > 0) {
                for (String host : this.m_selectedHosts.keySet()) {
                    sb = new StringBuffer().append(application).append('\u25ba').append(host);
                    if (!hostAndApp.equals(sb.toString())) continue;
                    sevNew = (List)this.m_hostsApps.get(hostAndApp);
                    sev = this.summerizeSeverities(sev, sevNew);
                }
                continue;
            }
            for (String host : this.m_filteredHosts.keySet()) {
                sb = new StringBuffer().append(application).append('\u25ba').append(host);
                if (!hostAndApp.equals(sb.toString())) continue;
                sevNew = (List)this.m_hostsApps.get(hostAndApp);
                sev = this.summerizeSeverities(sev, sevNew);
            }
        }
        return sev;
    }

    private List<Integer> summerizeSeverities(List<Integer> sev, List<Integer> sevNew) {
        if (sev == null) {
            sev = new ArrayList<Integer>(EventStorageUtils.sevEmpty);
        }
        int i = 0;
        while (i < sev.size()) {
            int sum = sev.get(i) + sevNew.get(i);
            sev.set(i, sum);
            ++i;
        }
        return sev;
    }

    public void displayAll(boolean displayAll) {
        if (displayAll) {
            this.m_displayAll = true;
            if (!this.m_displayAll_chk.getSelection()) {
                this.m_displayAll_chk.setSelection(true);
            }
            this.m_tableViewer.setFilters(new ViewerFilter[0]);
            this.setFilteredHosts();
            this.m_selectedHosts.clear();
            this.refresh();
            this.setTableSelection();
        } else {
            this.m_displayAll = false;
            if (this.m_displayAll_chk.getSelection()) {
                this.m_displayAll_chk.setSelection(false);
            }
            this.setFilteredHosts();
            this.setSelectedHosts();
            this.refresh();
            this.setTableSelection();
        }
    }

    public void setFilteredHosts() {
        this.m_filteredHosts.clear();
        TableItem[] items = this.m_tableViewer.getTable().getItems();
        int i = 0;
        while (i < items.length) {
            String host = items[i].getText(0);
            this.m_filteredHosts.put(host, null);
            ++i;
        }
    }

    public boolean isDisplayAll() {
        return this.m_displayAll;
    }

    public boolean isFiltered() {
        if (this.m_tableViewer == null) {
            return false;
        }
        return this.m_tableViewer.getFilters().length > 0;
    }

    public void setSelectedHosts() {
        HashMap<String, Object> selHosts = new HashMap<String, Object>();
        StructuredSelection ssel = (StructuredSelection)this.m_tableViewer.getSelection();
        if (!ssel.isEmpty()) {
            Iterator it = ssel.iterator();
            while (it.hasNext()) {
                selHosts.put((String)it.next(), null);
            }
        }
        this.m_selectedHosts = selHosts;
    }

    public List<String> getActiveHosts() {
        LinkedList<String> hosts = new LinkedList<String>();
        if (this.hasSelectedHosts()) {
            hosts.addAll(this.m_selectedHosts.keySet());
        } else if (this.isFiltered()) {
            hosts.addAll(this.m_filteredHosts.keySet());
        }
        return hosts;
    }

    public boolean hasSelectedHosts() {
        return this.m_selectedHosts.size() != 0;
    }

    public ArrayList<AgentCard> getSelectedAgentCards() {
        ArrayList<AgentCard> selAgentCards = new ArrayList<AgentCard>();
        StructuredSelection ssel = (StructuredSelection)this.m_tableViewer.getSelection();
        if (ssel.isEmpty()) {
            return selAgentCards;
        }
        for (Object o : ssel) {
            if (!(o instanceof String)) continue;
            String hostname = (String)o;
            AgentCard ac = Repository.getInstance().getAgentCardByHostname(hostname);
            if (ac == null) continue;
            selAgentCards.add(ac);
        }
        return selAgentCards;
    }

    public DashBoardGraph2D getDashboardGraph() {
        return this.m_dashboardGraph2D;
    }

    public boolean isPack() {
        return this.m_pack;
    }

    public void setPack(boolean pack) {
        this.m_pack = pack;
    }

    public void setFocus() {
    }

    public void dispose() {
        this.stopDashboard();
    }

    public void mouseDoubleClick(MouseEvent e) {
        if (e.getSource() instanceof Label) {
            Label l = (Label)e.getSource();
            String group = (String)l.getData(GRP);
            String appl = (String)l.getData(APP);
            Integer sev = (Integer)l.getData(SEV);
            if (sev == null) {
                sev = -1;
            }
            StringBuffer sb = new StringBuffer();
            if (group != null) {
                sb.append("Group:" + group).append(" ");
            }
            if (appl != null) {
                sb.append("Application:" + appl).append(" ");
            }
            MessagesView.showMessagesForHosts(sb.toString(), this.getActiveHosts(), appl, group, null, sev, null, 0, 0);
        } else if (e.getSource() instanceof BLabel) {
            BLabel l = (BLabel)((Object)e.getSource());
            String group = (String)l.getData(GRP);
            String appl = (String)l.getData(APP);
            Integer sev = (Integer)l.getData(SEV);
            if (sev == null) {
                sev = -1;
            }
            StringBuffer sb = new StringBuffer();
            if (group != null) {
                sb.append("Group:" + group).append(" ");
            }
            if (appl != null) {
                sb.append("Application:" + appl).append(" ");
            }
            MessagesView.showMessagesForHosts(sb.toString(), this.getActiveHosts(), appl, group, null, sev, null, 0, 0);
        } else if (e.getSource() instanceof BLabel2) {
            BLabel2 l = (BLabel2)((Object)e.getSource());
            List<Integer> severities = l.getSeverities();
            String group = l.getGroup();
            String appl = l.getAppliaction();
            int total = 0;
            int single = 0;
            int e_XY = 0;
            if (l.isVertical().booleanValue()) {
                total = ((GridData)l.getLayoutData()).heightHint;
                single = total / 5;
                e_XY = e.y;
            } else {
                total = ((GridData)l.getLayoutData()).widthHint;
                single = total / 5;
                e_XY = e.x;
            }
            int i = 0;
            while (i < 5) {
                int start = i * single + 1;
                int end = start - 1 + single;
                if (start < e_XY && e_XY < end) {
                    int count = severities.get(i + 1);
                    if (count == 0) {
                        return;
                    }
                    Integer sev = i + 1;
                    StringBuffer sb = new StringBuffer();
                    if (group != null) {
                        sb.append("Group:" + group).append(" ");
                    }
                    if (appl != null) {
                        sb.append("Application:" + appl).append(" ");
                    }
                    String severity = null;
                    severity = sev == 2 ? String.valueOf(Severity.getSeverity(1)) + "|" + Severity.getSeverity(2) : Severity.getSeverity(sev);
                    sb.append("(" + severity + ")").append(" ");
                    MessagesView.showMessagesForHosts(sb.toString(), this.getActiveHosts(), appl, group, null, sev, null, 0, 0);
                    return;
                }
                ++i;
            }
        } else if (e.getSource() instanceof Table) {
            Table tbl = (Table)e.getSource();
            ShowIndications showIndications = new ShowIndications(tbl);
            showIndications.run();
        }
    }

    public void mouseDown(MouseEvent e) {
    }

    public void mouseUp(MouseEvent e) {
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        Button b;
        String name;
        if (e.getSource() instanceof Button && (name = (String)(b = (Button)e.getSource()).getData()).equals(DISPLAY_ALL_CHK)) {
            if (this.m_displayAll_chk.getSelection()) {
                this.m_filterComp.activateSearchIcon(false);
                this.m_filterComp.clearSearchText();
                this.displayAll(true);
            } else {
                this.displayAll(true);
                this.setTableSelection();
            }
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        DisplayAppsAndGrpsAction displayAppsAndGrps = new DisplayAppsAndGrpsAction(this);
        displayAppsAndGrps.run();
    }

    public TableViewer getTableViewer() {
        return this.m_tableViewer;
    }

    public class DisplayAppsAndGrpsAction
    extends Action {
        private DashBoardView2 m_dashboard;
        private StructuredSelection m_ssel;

        public DisplayAppsAndGrpsAction(DashBoardView2 dashboard) {
            super("displayapplicationsandgroups");
            this.m_dashboard = null;
            this.m_ssel = null;
            this.setText("Display Applications and Groups");
            this.setId("displayapplicationsAndGroups");
            this.m_dashboard = dashboard;
            this.m_ssel = (StructuredSelection)dashboard.getTableViewer().getSelection();
            if (this.m_ssel.isEmpty()) {
                this.setEnabled(false);
            }
        }

        public void run() {
            if (this.m_ssel.size() == this.m_dashboard.m_hostAndType.size()) {
                DashBoardView2.this.displayAll(true);
            } else {
                DashBoardView2.this.displayAll(false);
            }
        }
    }

    public class ShowIndications
    extends Action {
        private TableItem[] m_selItems;
        private int MAX;

        public ShowIndications(Table table) {
            super("showindications");
            this.m_selItems = null;
            this.MAX = 10;
            this.setText("Show Indications");
            this.setImageDescriptor(BMUI.IMAGE_DESC_INDICATIONS);
            this.setId("showindications");
            this.m_selItems = table.getSelection();
            if (this.m_selItems == null || this.m_selItems.length == 0 || this.m_selItems.length > this.MAX) {
                this.setEnabled(false);
            }
        }

        public void run() {
            LinkedList<String> hosts = new LinkedList<String>();
            StringBuffer sb = new StringBuffer("Hosts:");
            int i = 0;
            while (i < this.m_selItems.length) {
                String hostName = this.m_selItems[i].getText(0);
                if (hostName != null && hostName.length() > 0 && !hosts.contains(hostName)) {
                    hosts.add(hostName);
                    sb.append(hostName).append('|');
                }
                ++i;
            }
            sb.deleteCharAt(sb.length() - 1);
            MessagesView.showMessagesForHosts(sb.toString(), hosts, null, null, null, -1, null, 0, 0);
        }
    }
}

