/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views;

import com.blixx.boom.engine.BMUI;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableFontProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

public class DashBoardViewHostTableProvider
extends ViewerSorter
implements IStructuredContentProvider,
ITableLabelProvider,
ITableColorProvider,
ITableFontProvider {
    private Map<String, Integer> m_hosts = new TreeMap<String, Integer>();
    private String m_column = null;
    private int m_dir = 128;

    public DashBoardViewHostTableProvider(Map<String, Integer> hosts, String column, int direction) {
        this.m_hosts = hosts;
        this.m_column = column;
        this.m_dir = direction;
    }

    public void setHosts(Map<String, Integer> hosts) {
        this.m_hosts = hosts;
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement != null && inputElement instanceof Map) {
            this.m_hosts = (Map)inputElement;
        }
        return this.m_hosts.keySet().toArray();
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        String result = null;
        String host = (String)element;
        switch (columnIndex) {
            case 0: {
                result = host;
                break;
            }
            case 1: {
                int type = this.m_hosts.get(host);
                result = this.getTypeStr(type);
            }
        }
        return result;
    }

    public String getTypeStr(int type) {
        String typeStr = null;
        switch (type) {
            case 0: {
                typeStr = "host";
                break;
            }
            case 1: {
                typeStr = "agent";
            }
        }
        return typeStr;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public void dispose() {
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public Color getBackground(Object element, int columnIndex) {
        Color color = BMUI.color_white;
        int type = this.m_hosts.get((String)element);
        switch (type) {
            case 1: {
                color = BMUI.color_light_yellow;
            }
        }
        return color;
    }

    public Color getForeground(Object element, int columnIndex) {
        Color color = null;
        switch (columnIndex) {
            case 0: {
                break;
            }
            case 1: {
                color = BMUI.color_darkGrey2;
            }
        }
        return color;
    }

    public Font getFont(Object element, int columnIndex) {
        Font font = null;
        switch (columnIndex) {
            case 0: {
                break;
            }
            case 1: {
                font = BMUI.font_arial8_italic;
            }
        }
        return font;
    }

    public void setConfig(String column, int direction) {
        this.m_column = column;
        this.m_dir = direction;
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        int returnValue = 0;
        String e1Str = (String)e1;
        String e2Str = (String)e2;
        if (this.m_column.equals("Hosts")) {
            returnValue = e1Str.compareToIgnoreCase(e2Str);
        } else if (this.m_column.equals("Type")) {
            int type1 = this.m_hosts.get(e1Str);
            int type2 = this.m_hosts.get(e2Str);
            returnValue = type1 - type2;
        }
        if (this.m_dir == 1024) {
            returnValue *= -1;
        }
        return returnValue;
    }
}

