/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.gui.utils.GUIDisplayElements;
import com.blixx.boom.gui.utils.calendar.CalendarDialog;
import com.blixx.boom.gui.utils.calendar.SWTCalListener;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class DateTimeGroup
extends Composite
implements ModifyListener {
    public static final String HRS_FIELD = "HRS_FIELD";
    public static final String MIN_FIELD = "MIN_FIELD";
    public static final String SEC_FIELD = "SEC_FIELD";
    public Label m_calendar_icon = null;
    private Text m_YYMMDD_field = null;
    private CCombo m_hrs_field = null;
    private CCombo m_min_field = null;
    private CCombo m_sec_field = null;
    private Label m_time_label = null;
    GUIDisplayElements m_gui = new GUIDisplayElements();
    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
    private List<ModifyListener> m_parentListeners = new ArrayList<ModifyListener>(1);
    public Calendar m_calendar = null;
    AtomicBoolean m_ignoreModify = new AtomicBoolean(false);
    public static final String[] HOURS = new String[]{"00", "01", "02", "03", "04", "05", "06", "07", "08", "09", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23"};
    public static final String[] MIN_SEC = new String[]{"00", "01", "02", "03", "04", "05", "06", "07", "08", "09", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30", "31", "32", "33", "34", "35", "36", "37", "38", "39", "40", "41", "42", "43", "44", "45", "46", "47", "48", "49", "50", "51", "52", "53", "54", "55", "56", "57", "58", "59"};
    public String m_title = "Date:";

    public DateTimeGroup(Composite parent, String title) {
        super(parent, 64);
        this.m_title = title;
        this.init();
    }

    public DateTimeGroup(Composite parent, String title, ModifyListener listener) {
        this(parent, title);
        this.init();
    }

    public void setTime(long milliseconds) {
        if (milliseconds > 0L) {
            this.m_calendar = Calendar.getInstance();
            this.m_calendar.setTimeInMillis(milliseconds);
        } else {
            this.m_calendar = null;
        }
        this.update();
    }

    public long getTime() {
        if (this.m_calendar == null) {
            return -1L;
        }
        return this.m_calendar.getTimeInMillis();
    }

    public void addModifyListener(ModifyListener listener) {
        if (!this.m_parentListeners.contains(listener)) {
            this.m_parentListeners.add(listener);
        }
    }

    public void init() {
        GridLayout gl = null;
        if (this.m_title != null && this.m_title.length() > 0) {
            gl = new GridLayout(1, false);
            Label l = new Label((Composite)this, 0);
            l.setText(this.m_title);
            l.setLayoutData((Object)new GridData(4, 4, false, false));
        } else {
            gl = new GridLayout(1, false);
        }
        gl.horizontalSpacing = 0;
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        this.setLayout((Layout)gl);
        this.setLayoutData(new GridData(4, 4, true, false));
        Composite comp_date = new Composite((Composite)this, 0);
        gl = new GridLayout(4, false);
        gl.horizontalSpacing = 0;
        gl.verticalSpacing = 0;
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        comp_date.setLayout((Layout)gl);
        comp_date.setLayoutData((Object)new GridData(4, 4, false, false));
        this.m_gui.addTextField(comp_date, null, "Date: ", 1, 1, 1, 1, null);
        this.m_YYMMDD_field = this.m_gui.addTextReadOnly(comp_date, null, null, 1, 1, 1, 1, null, null);
        this.m_YYMMDD_field.addModifyListener((ModifyListener)this);
        ((GridData)this.m_YYMMDD_field.getLayoutData()).horizontalIndent = 12;
        this.m_calendar_icon = new Label(comp_date, 0);
        GridData gd = new GridData();
        gd.horizontalIndent = 5;
        this.m_calendar_icon.setLayoutData((Object)gd);
        this.m_calendar_icon.setImage(BMUI.IMAGE_CALENDAR);
        this.m_calendar_icon.addListener(4, new Listener(){

            public void handleEvent(Event event) {
                DateTimeGroup.this.runCalendarWidget();
            }
        });
        Label label = this.m_gui.addTextField(comp_date, null, "yyyy-MM-dd", 1, 1, 1, 1, null);
        ((GridData)label.getLayoutData()).horizontalIndent = 10;
        Composite comp_time = new Composite((Composite)this, 0);
        gl = new GridLayout(5, false);
        gl.verticalSpacing = 0;
        gl.horizontalSpacing = 0;
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        comp_time.setLayout((Layout)gl);
        comp_time.setLayoutData((Object)new GridData(4, 4, false, false));
        this.m_time_label = this.m_gui.addTextField(comp_time, null, "Time: ", 1, 1, 1, 1, null);
        this.m_hrs_field = this.m_gui.addDropDown(comp_time, HRS_FIELD, HOURS, "00", 1, 1, 1, this);
        ((GridData)this.m_hrs_field.getLayoutData()).horizontalIndent = 10;
        this.m_min_field = this.m_gui.addDropDown(comp_time, MIN_FIELD, MIN_SEC, "00", 1, 1, 1, this);
        this.m_sec_field = this.m_gui.addDropDown(comp_time, SEC_FIELD, MIN_SEC, "00", 1, 1, 1, this);
        Label label2 = this.m_gui.addTextField(comp_time, null, "h/m/s", 1, 1, 1, 1, null);
        ((GridData)label2.getLayoutData()).horizontalIndent = 5;
    }

    public void update() {
        this.m_ignoreModify.set(true);
        if (this.m_calendar == null) {
            this.m_YYMMDD_field.setText("");
            this.m_hrs_field.setText("");
            this.m_min_field.setText("");
            this.m_sec_field.setText("");
        } else {
            this.m_YYMMDD_field.setText(this.sdf.format(this.m_calendar.getTime()));
            this.m_hrs_field.setText("" + this.m_calendar.get(11));
            this.m_min_field.setText("" + this.m_calendar.get(12));
            this.m_sec_field.setText("" + this.m_calendar.get(13));
        }
        this.computeSize(-1, -1);
        super.update();
        this.m_ignoreModify.set(false);
    }

    public void modifyText(ModifyEvent e) {
        if (e.getSource() instanceof CCombo) {
            CCombo text = (CCombo)e.getSource();
            String value = text.getText();
            if (text.getData() != null) {
                int val;
                if (text.getData().equals(HRS_FIELD)) {
                    this.m_hrs_field.setBackground(BMUI.defaultBackground);
                    if (value.length() > 0) {
                        try {
                            val = Integer.parseInt(this.m_hrs_field.getText().trim());
                            if (val < 0 || val > 23) {
                                throw new RuntimeException();
                            }
                            this.m_calendar.set(11, val);
                        }
                        catch (Throwable throwable) {
                            this.m_hrs_field.setBackground(BMUI.color_critical);
                        }
                    }
                } else if (text.getData().equals(MIN_FIELD)) {
                    this.m_min_field.setBackground(BMUI.defaultBackground);
                    if (value.length() > 0) {
                        try {
                            val = Integer.parseInt(this.m_min_field.getText().trim());
                            if (val < 0 || val > 59) {
                                throw new RuntimeException();
                            }
                            this.m_calendar.set(12, val);
                        }
                        catch (Throwable throwable) {
                            this.m_min_field.setBackground(BMUI.color_critical);
                        }
                    }
                } else if (text.getData().equals(SEC_FIELD)) {
                    this.m_sec_field.setBackground(BMUI.defaultBackground);
                    if (value.length() > 0) {
                        try {
                            val = Integer.parseInt(this.m_sec_field.getText().trim());
                            if (val < 0 || val > 59) {
                                throw new RuntimeException();
                            }
                            this.m_calendar.set(13, val);
                        }
                        catch (Throwable throwable) {
                            this.m_sec_field.setBackground(BMUI.color_critical);
                        }
                    }
                }
            }
        }
        if (!this.m_ignoreModify.get()) {
            Event ev = new Event();
            ev.item = this;
            ev.data = this.m_calendar;
            ev.widget = this;
            ModifyEvent me = new ModifyEvent(ev);
            for (ModifyListener ml : this.m_parentListeners) {
                ml.modifyText(me);
            }
        }
    }

    private void runCalendarWidget() {
        CalendarDialog cd = new CalendarDialog(this.getShell());
        SWTCalListener calendar2 = new SWTCalListener();
        cd.addDateChangedListener(calendar2);
        cd.setBlockOnOpen(true);
        if (cd.open() == 0 && calendar2.getCalendar() != null) {
            this.m_YYMMDD_field.setText(this.sdf.format(calendar2.getCalendar().getTime()));
            if (this.m_calendar != null) {
                this.m_calendar.set(1, calendar2.getCalendar().get(1));
                this.m_calendar.set(2, calendar2.getCalendar().get(2));
                this.m_calendar.set(5, calendar2.getCalendar().get(5));
            }
        }
    }
}

