/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views;

import com.blixx.boom.editors.OpenFileAction;
import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.engine.ServerClientBatch;
import com.blixx.boom.gui.dialogs.ProgressDialog;
import com.blixx.boom.gui.dialogs.ShowMessageBox;
import com.blixx.boom.gui.dialogs.ShowMessageDialog;
import com.blixx.boom.gui.dialogs.ShowSimpleDialog;
import com.blixx.boom.gui.policies.AssignmentTreeProvider;
import com.blixx.boom.gui.policies.PolicyManager;
import com.blixx.boom.gui.policies.PolicyTreeProvider;
import com.blixx.boom.gui.policies.ViewContentProvider;
import com.blixx.boom.gui.policies.ViewLabelProvider;
import com.blixx.boom.gui.policies.ViewLabelProviderMPIExport;
import com.blixx.boom.gui.utils.GUIDisplayElements;
import com.blixx.boom.gui.utils.IRefreshListener;
import com.blixx.boom.gui.utils.STreeViewer;
import com.blixx.boom.gui.utils.XMLTree;
import com.blixx.boom.gui.views.NodeListView;
import com.blixx.boom.gui.views.StyledTreeLabelProvider;
import com.blixx.boom.gui.views.actions.ExpandCollapseAction;
import com.blixx.boom.gui.views.actions.ExportActionGroup;
import com.blixx.boom.gui.views.actions.ExportPolicyAction;
import com.blixx.boom.gui.views.actions.OpenPolicyAction;
import com.blixx.boom.gui.views.actions.RefreshTreeAction;
import com.blixx.boom.gui.views.actions.SelectAssignmentInTreeAction;
import com.blixx.boom.gui.views.actions.SelectBinaryInTreeAction;
import com.blixx.boom.gui.views.actions.SelectPolicyInTreeAction;
import com.blixx.boom.gui.views.actions.ShowRelatedPolicyInfosAction;
import com.blixx.log.RTLogger;
import com.blixx.shared.XMLFactory;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.GroupTreeObjectLast;
import com.blixx.shared.utils.TreeObject;
import com.blixx.shared.utils.ZIP;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.part.ViewPart;
import org.w3c.dom.Document;

public class ExportMPIView
extends ViewPart
implements DisposeListener,
IDoubleClickListener,
SelectionListener,
ISelectionChangedListener,
IExpansionListener {
    public static final String ID = "com.blixx.boom.gui.views.exportmpiview";
    private static ExportMPIView m_instance = null;
    private static String m_lastDirSelected = null;
    private Map<String, List<GroupTreeObject>> m_conflicts = null;
    private STreeViewer m_tv_pol = null;
    public TreeViewer m_tv_pol4Export = null;
    private STreeViewer m_tv_asn = null;
    private TreeViewer m_tv_asn4Export = null;
    private STreeViewer m_tv_bin = null;
    private TreeViewer m_tv_bin4Export = null;
    private STreeViewer m_tv_act = null;
    private TreeViewer m_tv_act4Export = null;
    private STreeViewer m_tv_node = null;
    private TreeViewer m_tv_node4Export = null;
    private GroupTreeObject m_polRoot = null;
    private GroupTreeObject m_asnRoot = null;
    private GroupTreeObject m_binRoot = null;
    private GroupTreeObject m_actRoot = null;
    private GroupTreeObject m_nodRoot = null;
    private GroupTreeObject m_pol4ExportRoot = null;
    private GroupTreeObject m_asn4ExportRoot = null;
    private GroupTreeObject m_bin4ExportRoot = null;
    private GroupTreeObject m_act4ExportRoot = null;
    private GroupTreeObject m_nod4ExportRoot = null;
    private GUIDisplayElements m_gui = null;
    private ScrolledComposite m_sc = null;
    private FormToolkit m_toolkit = null;
    private Composite m_compInView = null;
    private Composite m_mainComp = null;
    private Section m_polSection = null;
    private Section m_asnSection = null;
    private Section m_binSection = null;
    private Section m_actSection = null;
    private Section m_nodSection = null;
    public Label m_brokenLinks_Field = null;
    private Button m_add_pol_btn = null;
    private Button m_add_asn_btn = null;
    private Button m_add_bin_btn = null;
    private Button m_add_act_btn = null;
    private Button m_add_nod_btn = null;
    private Button m_remove_pol_btn = null;
    private Button m_remove_asn_btn = null;
    private Button m_remove_bin_btn = null;
    private Button m_remove_act_btn = null;
    private Button m_remove_nod_btn = null;
    private Button m_resolveLinks_btn = null;
    private Button m_clear_btn = null;
    private Button m_selectAll_btn = null;
    private Button m_export_btn = null;
    private static GridData m_gd_tree = new GridData(4, 4, true, true);
    public static String TREE_VIEWER_TYPE;
    public static String POLICY;
    public static String POLICY_4EXPORT;
    public static String ASSIGNMENT;
    public static String ASSIGNMENT_4EXPORT;
    public static String BINARY;
    public static String BINARY_4EXPORT;
    public static String ACTION;
    public static String ACTION_4EXPORT;
    public static String NODE;
    public static String NODE_4EXPORT;
    public static String ADD_POL_BTN;
    public static String ADD_ASN_BTN;
    public static String ADD_BIN_BTN;
    public static String ADD_ACTION_BTN;
    public static String ADD_NODE_BTN;
    public static String REMOVE_POL_BTN;
    public static String REMOVE_ASN_BTN;
    public static String REMOVE_BIN_BTN;
    public static String REMOVE_ACTION_BTN;
    public static String REMOVE_NODE_BTN;
    public static String RESOLVE_LINKS_BTN;
    public static String CLEAR_BTN;
    public static String SELECT_ALL_BTN;
    public static String EXPORT_BTN;
    private File m_exportDir_pol = null;
    private File m_exportDir_act = null;
    private File m_exportDir_asn = null;
    private File m_exportDir_bin = null;
    private File m_exportDir_nod = null;

    static {
        ExportMPIView.m_gd_tree.heightHint = 200;
        ExportMPIView.m_gd_tree.widthHint = 150;
        TREE_VIEWER_TYPE = "TREE_VIEWER_TYPE";
        POLICY = "POLICY";
        POLICY_4EXPORT = "POLICY_4EXPORT";
        ASSIGNMENT = "ASSIGNMENT";
        ASSIGNMENT_4EXPORT = "ASSIGNMENT_4EXPORT";
        BINARY = "BINARY";
        BINARY_4EXPORT = "BINARY_4EXPORT";
        ACTION = "ACTION";
        ACTION_4EXPORT = "ACTION_4EXPORT";
        NODE = "NODE";
        NODE_4EXPORT = "NODE_4EXPORT";
        ADD_POL_BTN = "ADD_POL_BTN";
        ADD_ASN_BTN = "ADD_ASN_BTN";
        ADD_BIN_BTN = "ADD_BIN_BTN";
        ADD_ACTION_BTN = "ADD_ACTTION_BTN";
        ADD_NODE_BTN = "ADD_NODE_BTN";
        REMOVE_POL_BTN = "REMOVE_POL_BTN";
        REMOVE_ASN_BTN = "REMOVE_ASN_BTN";
        REMOVE_BIN_BTN = "REMOVE_BIN_BTN";
        REMOVE_ACTION_BTN = "REMOVE_ACTTION_BTN";
        REMOVE_NODE_BTN = "REMOVE_NODE_BTN";
        RESOLVE_LINKS_BTN = "RESOLVE_LINKS_BTN";
        CLEAR_BTN = "CLEAR_BTN";
        SELECT_ALL_BTN = "SELECT_ALL_BTN";
        EXPORT_BTN = "EXPORT_BTN";
    }

    public ExportMPIView() {
        m_instance = this;
    }

    public static ExportMPIView getInstance() {
        return m_instance;
    }

    public void createPartControl(Composite parent) {
        this.setTitleImage(BMUI.IMAGE_EXPORT);
        this.m_gui = new GUIDisplayElements();
        this.m_toolkit = BMUI.getFormToolkit(Display.getCurrent());
        this.m_conflicts = new HashMap<String, List<GroupTreeObject>>();
        this.m_compInView = new Composite(parent, 0);
        GridLayout gl = new GridLayout(1, false);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        this.m_compInView.setLayout((Layout)gl);
        this.m_compInView.setLayoutData((Object)new GridData(4, 4, true, true));
        this.m_sc = new ScrolledComposite(this.m_compInView, 768);
        this.m_sc.setAlwaysShowScrollBars(false);
        this.m_sc.setExpandHorizontal(true);
        this.m_sc.setExpandVertical(true);
        this.m_sc.setLayout((Layout)new GridLayout());
        this.m_sc.setLayoutData((Object)new GridData(4, 4, true, true));
        this.m_mainComp = new Composite((Composite)this.m_sc, 0);
        gl = new GridLayout(1, false);
        gl.marginBottom = 10;
        gl.marginTop = 10;
        gl.marginWidth = 10;
        this.m_mainComp.setLayout((Layout)gl);
        this.m_mainComp.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createPolicySection(this.m_mainComp);
        this.createAssignSection(this.m_mainComp);
        this.createBinarySection(this.m_mainComp);
        this.createActionSection(this.m_mainComp);
        this.createNodeSection(this.m_mainComp);
        this.m_sc.setContent((Control)this.m_mainComp);
        this.m_sc.setMinSize(this.m_mainComp.computeSize(-1, -1, true));
        Composite compLine = new Composite(this.m_compInView, 0);
        gl = new GridLayout(1, false);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        compLine.setLayout((Layout)gl);
        compLine.setLayoutData((Object)new GridData(4, 128, true, false));
        Label line = new Label(compLine, 259);
        line.setForeground(BMUI.color_darkGrey2);
        line.setLayoutData((Object)new GridData(4, 128, true, false));
        Composite compBtn = new Composite(this.m_compInView, 0);
        gl = new GridLayout(3, true);
        gl.marginHeight = 0;
        gl.marginBottom = 5;
        compBtn.setLayout((Layout)gl);
        compBtn.setLayoutData((Object)new GridData(131072, 4, true, false));
        this.m_selectAll_btn = this.m_gui.addButton(compBtn, SELECT_ALL_BTN, "&Select All", true, 90, 30, 0, this);
        this.m_selectAll_btn.setLayoutData((Object)new GridData(4, 128, false, false));
        this.m_clear_btn = this.m_gui.addButton(compBtn, CLEAR_BTN, "&Clear All", true, 90, 30, 0, this);
        this.m_clear_btn.setLayoutData((Object)new GridData(4, 128, false, false));
        this.m_export_btn = this.m_gui.addButton(compBtn, EXPORT_BTN, "&Export", false, 90, 30, 0, this);
        this.m_export_btn.setLayoutData((Object)new GridData(4, 128, false, false));
        this.checkButtons();
    }

    public void createPolicySection(Composite parent) {
        this.m_polSection = this.m_toolkit.createSection(parent, 578);
        this.m_polSection.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        this.m_polSection.addExpansionListener((IExpansionListener)this);
        this.setSectionTitle(POLICY);
        Composite sectionClient = this.m_toolkit.createComposite((Composite)this.m_polSection, 0);
        sectionClient.setLayout((Layout)new GridLayout(3, false));
        sectionClient.setLayoutData((Object)new GridData(4, 4, true, true));
        if (Repository.getInstance().getRights(1001) > 1) {
            this.m_tv_pol = new STreeViewer(sectionClient, 268438274);
            this.m_tv_pol.getTree().setLayoutData((Object)m_gd_tree);
            this.m_tv_pol.setData(TREE_VIEWER_TYPE, POLICY);
            this.m_tv_pol.setUseHashlookup(true);
            this.m_tv_pol.setContentProvider((IContentProvider)new ViewContentProvider());
            this.m_tv_pol.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider(null, null));
            this.m_polRoot = PolicyTreeProvider.getInstance().createPolicyTree();
            this.m_tv_pol.setInput(this.m_polRoot);
            this.m_tv_pol.expandToLevel(2);
            this.m_tv_pol.addSelectionChangedListener(this);
            this.m_tv_pol.addDoubleClickListener(this);
            this.createCM(this.m_tv_pol);
            Composite btnComp = new Composite(sectionClient, 0);
            btnComp.setLayout((Layout)new GridLayout(1, false));
            btnComp.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
            this.m_add_pol_btn = this.m_gui.addButton(btnComp, ADD_POL_BTN, " >> ", false, 120, 10, 1, 0, this);
            this.m_remove_pol_btn = this.m_gui.addButton(btnComp, REMOVE_POL_BTN, " << ", false, 120, 10, 1, 0, this);
            this.m_tv_pol4Export = new STreeViewer(sectionClient, 268438274);
            this.m_tv_pol4Export.getTree().setLayoutData((Object)m_gd_tree);
            this.m_tv_pol4Export.setData(TREE_VIEWER_TYPE, (Object)POLICY_4EXPORT);
            this.m_tv_pol4Export.setUseHashlookup(true);
            this.m_tv_pol4Export.setContentProvider((IContentProvider)new ViewContentProvider());
            this.m_tv_pol4Export.setLabelProvider((IBaseLabelProvider)new ViewLabelProviderMPIExport(null, this.m_tv_pol4Export));
            this.m_pol4ExportRoot = new GroupTreeObject(new TreeObject("root", BMUI.type_folder, null));
            this.m_tv_pol4Export.setInput((Object)this.m_pol4ExportRoot);
            this.m_tv_pol4Export.addSelectionChangedListener((ISelectionChangedListener)this);
            this.m_tv_pol4Export.addDoubleClickListener((IDoubleClickListener)this);
            this.createCM_4Export(this.m_tv_pol4Export);
        } else {
            this.m_polSection.setExpanded(false);
            this.m_polSection.setEnabled(false);
        }
        this.m_polSection.setClient((Control)sectionClient);
    }

    public void createAssignSection(Composite parent) {
        this.m_asnSection = this.m_toolkit.createSection(parent, 578);
        this.m_asnSection.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        this.m_asnSection.addExpansionListener((IExpansionListener)this);
        this.setSectionTitle(ASSIGNMENT);
        Composite sectionClient = this.m_toolkit.createComposite((Composite)this.m_asnSection, 0);
        sectionClient.setLayout((Layout)new GridLayout(3, false));
        sectionClient.setLayoutData((Object)new GridData(4, 4, true, true));
        if (Repository.getInstance().getRights(1008) > 1 && Repository.getInstance().getRights(1006) > 1 && Repository.getInstance().getRights(1001) > 1) {
            this.m_tv_asn = new STreeViewer(sectionClient, 268438274);
            this.m_tv_asn.getTree().setLayoutData((Object)m_gd_tree);
            this.m_tv_asn.setData(TREE_VIEWER_TYPE, ASSIGNMENT);
            this.m_tv_asn.setUseHashlookup(true);
            this.m_tv_asn.setContentProvider((IContentProvider)new ViewContentProvider());
            this.m_tv_asn.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider(null, this.m_tv_asn));
            this.m_asnRoot = AssignmentTreeProvider.getInstance().createAssignmentTree();
            this.m_tv_asn.setInput(this.m_asnRoot);
            this.m_tv_asn.expandToLevel(2);
            this.m_tv_asn.addSelectionChangedListener(this);
            this.m_tv_asn.addDoubleClickListener(this);
            this.createCM(this.m_tv_asn);
            Composite btnComp = new Composite(sectionClient, 0);
            btnComp.setLayout((Layout)new GridLayout(1, false));
            btnComp.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
            this.m_add_asn_btn = this.m_gui.addButton(btnComp, ADD_ASN_BTN, " >> ", false, 120, 10, 1, 0, this);
            this.m_remove_asn_btn = this.m_gui.addButton(btnComp, REMOVE_ASN_BTN, " << ", false, 120, 10, 1, 0, this);
            this.m_tv_asn4Export = new STreeViewer(sectionClient, 268438274);
            this.m_tv_asn4Export.getTree().setLayoutData((Object)m_gd_tree);
            this.m_tv_asn4Export.setData(TREE_VIEWER_TYPE, (Object)ASSIGNMENT_4EXPORT);
            this.m_tv_asn4Export.setUseHashlookup(true);
            this.m_tv_asn4Export.setContentProvider((IContentProvider)new ViewContentProvider());
            this.m_tv_asn4Export.setLabelProvider((IBaseLabelProvider)new ViewLabelProviderMPIExport(null, this.m_tv_asn4Export));
            this.m_asn4ExportRoot = new GroupTreeObject(new TreeObject("root", BMUI.type_folder, null));
            this.m_tv_asn4Export.setInput((Object)this.m_asn4ExportRoot);
            this.m_tv_asn4Export.addSelectionChangedListener((ISelectionChangedListener)this);
            this.m_tv_asn4Export.addDoubleClickListener((IDoubleClickListener)this);
            this.createCM_4Export(this.m_tv_asn4Export);
            Composite comp = new Composite(sectionClient, 0);
            comp.setLayout((Layout)new GridLayout(2, false));
            comp.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 3, 1));
            this.m_brokenLinks_Field = this.m_gui.addTextField(comp, null, "0 broken links!       ", 1, 1, 1, 0, BMUI.font_arial7);
            this.m_brokenLinks_Field.setForeground(BMUI.color_critical);
            ((GridData)this.m_brokenLinks_Field.getLayoutData()).horizontalAlignment = 16384;
            this.m_brokenLinks_Field.setVisible(false);
            this.m_resolveLinks_btn = this.m_gui.addButton(comp, RESOLVE_LINKS_BTN, "Resolve broken Links", false, 120, 10, 1, 0, this);
        } else {
            this.m_asnSection.setExpanded(false);
            this.m_asnSection.setEnabled(false);
        }
        this.m_asnSection.setClient((Control)sectionClient);
    }

    public void createBinarySection(Composite parent) {
        this.m_binSection = this.m_toolkit.createSection(parent, 578);
        this.m_binSection.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        this.m_binSection.addExpansionListener((IExpansionListener)this);
        this.setSectionTitle(BINARY);
        Composite sectionClient = this.m_toolkit.createComposite((Composite)this.m_binSection, 0);
        sectionClient.setLayout((Layout)new GridLayout(3, false));
        sectionClient.setLayoutData((Object)new GridData(4, 4, true, true));
        if (Repository.getInstance().getRights(1006) > 1) {
            this.m_tv_bin = new STreeViewer(sectionClient, 268438274);
            this.m_tv_bin.getTree().setLayoutData((Object)m_gd_tree);
            this.m_tv_bin.setData(TREE_VIEWER_TYPE, BINARY);
            this.m_tv_bin.setUseHashlookup(true);
            this.m_tv_bin.setContentProvider((IContentProvider)new ViewContentProvider());
            this.m_tv_bin.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider(null, null));
            this.m_binRoot = Repository.getInstance().getBinaryTree();
            this.m_tv_bin.setInput(this.m_binRoot);
            this.m_tv_bin.expandToLevel(2);
            this.m_tv_bin.addSelectionChangedListener(this);
            this.m_tv_bin.addDoubleClickListener(this);
            this.createCM(this.m_tv_bin);
            this.m_tv_bin.addRefreshListener(new IRefreshListener(){

                @Override
                public void linkedRefresh(GroupTreeObject updatedGTO) {
                    ExportMPIView.this.validateExportTrees(BINARY_4EXPORT, updatedGTO, ExportMPIView.this.m_bin4ExportRoot);
                    ExportMPIView.this.refreshTree(ExportMPIView.this.m_tv_bin4Export, ExportMPIView.this.m_bin4ExportRoot);
                }
            });
            Composite btnComp = new Composite(sectionClient, 0);
            btnComp.setLayout((Layout)new GridLayout(1, false));
            btnComp.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
            this.m_add_bin_btn = this.m_gui.addButton(btnComp, ADD_BIN_BTN, " >> ", false, 120, 10, 1, 0, this);
            this.m_remove_bin_btn = this.m_gui.addButton(btnComp, REMOVE_BIN_BTN, " << ", false, 120, 10, 1, 0, this);
            this.m_tv_bin4Export = new STreeViewer(sectionClient, 268438274);
            this.m_tv_bin4Export.getTree().setLayoutData((Object)m_gd_tree);
            this.m_tv_bin4Export.setData(TREE_VIEWER_TYPE, (Object)BINARY_4EXPORT);
            this.m_tv_bin4Export.setUseHashlookup(true);
            this.m_tv_bin4Export.setContentProvider((IContentProvider)new ViewContentProvider());
            this.m_tv_bin4Export.setLabelProvider((IBaseLabelProvider)new ViewLabelProviderMPIExport(null, this.m_tv_bin4Export, this.m_conflicts));
            this.m_bin4ExportRoot = new GroupTreeObject(new TreeObject("root", BMUI.type_folder, null));
            this.m_tv_bin4Export.setInput((Object)this.m_bin4ExportRoot);
            this.m_tv_bin4Export.addSelectionChangedListener((ISelectionChangedListener)this);
            this.m_tv_bin4Export.addDoubleClickListener((IDoubleClickListener)this);
            this.createCM_4Export(this.m_tv_bin4Export);
        } else {
            this.m_binSection.setExpanded(false);
            this.m_binSection.setEnabled(false);
        }
        this.m_binSection.setClient((Control)sectionClient);
    }

    public void createActionSection(Composite parent) {
        this.m_actSection = this.m_toolkit.createSection(parent, 514);
        this.m_actSection.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        this.m_actSection.addExpansionListener((IExpansionListener)this);
        this.setSectionTitle(ACTION);
        Composite sectionClient = this.m_toolkit.createComposite((Composite)this.m_actSection, 0);
        sectionClient.setLayout((Layout)new GridLayout(3, false));
        sectionClient.setLayoutData((Object)new GridData(4, 4, true, true));
        if (Repository.getInstance().getRights(1007) > 1) {
            this.m_tv_act = new STreeViewer(sectionClient, 268438274);
            this.m_tv_act.getTree().setLayoutData((Object)m_gd_tree);
            this.m_tv_act.setData(TREE_VIEWER_TYPE, ACTION);
            this.m_tv_act.setUseHashlookup(true);
            this.m_tv_act.setContentProvider((IContentProvider)new ViewContentProvider());
            this.m_tv_act.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider(null, null));
            this.m_actRoot = Repository.getInstance().getActionTree((Viewer)this.m_tv_act);
            this.m_tv_act.setInput(this.m_actRoot);
            this.m_tv_act.expandToLevel(1);
            this.m_tv_act.addSelectionChangedListener(this);
            this.m_tv_act.addDoubleClickListener(this);
            this.createCM(this.m_tv_act);
            Composite btnComp = new Composite(sectionClient, 0);
            btnComp.setLayout((Layout)new GridLayout(1, false));
            btnComp.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
            this.m_add_act_btn = this.m_gui.addButton(btnComp, ADD_ACTION_BTN, " >> ", false, 120, 10, 1, 0, this);
            this.m_remove_act_btn = this.m_gui.addButton(btnComp, REMOVE_ACTION_BTN, " << ", false, 120, 10, 1, 0, this);
            this.m_tv_act4Export = new STreeViewer(sectionClient, 268438274);
            this.m_tv_act4Export.getTree().setLayoutData((Object)m_gd_tree);
            this.m_tv_act4Export.setData(TREE_VIEWER_TYPE, (Object)ACTION_4EXPORT);
            this.m_tv_act4Export.setUseHashlookup(true);
            this.m_tv_act4Export.setContentProvider((IContentProvider)new ViewContentProvider());
            this.m_tv_act4Export.setLabelProvider((IBaseLabelProvider)new ViewLabelProviderMPIExport(null, this.m_tv_act4Export));
            this.m_act4ExportRoot = new GroupTreeObject(new TreeObject("root", BMUI.type_folder, null));
            this.m_tv_act4Export.setInput((Object)this.m_act4ExportRoot);
            this.m_tv_act4Export.addSelectionChangedListener((ISelectionChangedListener)this);
            this.m_tv_act4Export.addDoubleClickListener((IDoubleClickListener)this);
            this.createCM_4Export(this.m_tv_act4Export);
        } else {
            this.m_actSection.setExpanded(false);
            this.m_actSection.setEnabled(false);
        }
        this.m_actSection.setClient((Control)sectionClient);
    }

    public void createNodeSection(Composite parent) {
        this.m_nodSection = this.m_toolkit.createSection(parent, 514);
        this.m_nodSection.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        this.m_nodSection.addExpansionListener((IExpansionListener)this);
        this.setSectionTitle(NODE);
        Composite sectionClient = this.m_toolkit.createComposite((Composite)this.m_nodSection, 0);
        sectionClient.setLayout((Layout)new GridLayout(3, false));
        sectionClient.setLayoutData((Object)new GridData(4, 4, true, true));
        if (Repository.getInstance().getRights(1002) > 1) {
            this.m_tv_node = new STreeViewer(sectionClient, 268438274);
            this.m_tv_node.getTree().setLayoutData((Object)m_gd_tree);
            this.m_tv_node.setData(TREE_VIEWER_TYPE, NODE);
            this.m_tv_node.setUseHashlookup(true);
            this.m_tv_node.setContentProvider((IContentProvider)new ViewContentProvider());
            this.m_tv_node.setLabelProvider((IBaseLabelProvider)new StyledTreeLabelProvider());
            this.m_nodRoot = new GroupTreeObject(new TreeObject("root", BMUI.type_folder, null));
            GroupTreeObject nodeRoot = Repository.getInstance().getNodeGroupTree();
            if (nodeRoot != null) {
                try {
                    this.m_nodRoot.addElement(nodeRoot.clone());
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {}
            }
            this.m_tv_node.setInput(this.m_nodRoot);
            this.m_tv_node.expandToLevel(1);
            this.m_tv_node.addSelectionChangedListener(this);
            this.m_tv_node.addDoubleClickListener(this);
            try {
                NodeListView.getInstance().m_treeViewer.addRefreshListener(new IRefreshListener(){

                    @Override
                    public void linkedRefresh(GroupTreeObject updatedGTO) {
                        ExportMPIView.this.refreshTree(ExportMPIView.this.m_tv_node, ExportMPIView.this.m_nodRoot);
                    }
                });
            }
            catch (Throwable throwable) {}
            this.createCM(this.m_tv_node);
            Composite btnComp = new Composite(sectionClient, 0);
            btnComp.setLayout((Layout)new GridLayout(1, false));
            btnComp.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
            this.m_add_nod_btn = this.m_gui.addButton(btnComp, ADD_NODE_BTN, " >> ", false, 120, 10, 1, 0, this);
            this.m_remove_nod_btn = this.m_gui.addButton(btnComp, REMOVE_NODE_BTN, " << ", false, 120, 10, 1, 0, this);
            this.m_tv_node4Export = new STreeViewer(sectionClient, 268438274);
            this.m_tv_node4Export.getTree().setLayoutData((Object)m_gd_tree);
            this.m_tv_node4Export.setData(TREE_VIEWER_TYPE, (Object)NODE_4EXPORT);
            this.m_tv_node4Export.setUseHashlookup(true);
            this.m_tv_node4Export.setContentProvider((IContentProvider)new ViewContentProvider());
            this.m_tv_node4Export.setLabelProvider((IBaseLabelProvider)new ViewLabelProviderMPIExport(null, this.m_tv_node4Export));
            this.m_nod4ExportRoot = new GroupTreeObject(new TreeObject("root", BMUI.type_folder, null));
            this.m_tv_node4Export.setInput((Object)this.m_nod4ExportRoot);
            this.m_tv_node4Export.addSelectionChangedListener((ISelectionChangedListener)this);
            this.m_tv_node4Export.addDoubleClickListener((IDoubleClickListener)this);
            this.createCM_4Export(this.m_tv_node4Export);
        } else {
            this.m_nodSection.setExpanded(false);
            this.m_nodSection.setEnabled(false);
        }
        this.m_nodSection.setClient((Control)sectionClient);
    }

    public void createCM(final TreeViewer tv) {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        Menu menu = menuMgr.createContextMenu(tv.getControl());
        tv.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)tv);
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                if (tv == null) {
                    return;
                }
                int iCount = tv.getTree().getItemCount();
                if (iCount > 0) {
                    String treeTYPE = (String)tv.getData(TREE_VIEWER_TYPE);
                    StructuredSelection ssel = (StructuredSelection)tv.getSelection();
                    Object o = ssel.getFirstElement();
                    try {
                        manager.add((IAction)new RefreshTreeAction(tv, null, null, null));
                        if (treeTYPE.equals(POLICY)) {
                            if (o != null && o instanceof GroupTreeObjectLast) {
                                manager.add((IContributionItem)new Separator());
                                manager.add((IAction)new OpenPolicyAction(tv, true));
                                manager.add((IAction)new SelectPolicyInTreeAction(tv));
                                manager.add((IAction)new ShowRelatedPolicyInfosAction(tv, Display.getCurrent().getActiveShell()));
                            }
                        } else if (treeTYPE.equals(ASSIGNMENT)) {
                            GroupTreeObject gto;
                            if (o != null && o instanceof GroupTreeObjectLast) {
                                GroupTreeObjectLast gtol = (GroupTreeObjectLast)o;
                                if (gtol.getType().equals(BMUI.type_mon) || gtol.getType().equals(BMUI.type_msg)) {
                                    manager.add((IContributionItem)new Separator());
                                    manager.add((IAction)new SelectPolicyInTreeAction(tv));
                                } else if (gtol.getType().equals(BMUI.type_assignment_bin)) {
                                    manager.add((IContributionItem)new Separator());
                                    manager.add((IAction)new SelectBinaryInTreeAction(tv));
                                }
                            } else if (o != null && o instanceof GroupTreeObject && (gto = (GroupTreeObject)o).getType().equals(BMUI.type_assignment_pol)) {
                                manager.add((IContributionItem)new Separator());
                                manager.add((IAction)new SelectAssignmentInTreeAction(gto.getName()));
                            }
                        } else if (treeTYPE.equals(BINARY)) {
                            GroupTreeObject gto;
                            if (o != null && o instanceof GroupTreeObjectLast) {
                                manager.add((IContributionItem)new Separator());
                                manager.add((IAction)new OpenFileAction(m_instance.getSite().getWorkbenchWindow(), ssel));
                            } else if (o != null && o instanceof GroupTreeObject && (gto = (GroupTreeObject)o).getType().equals(BMUI.type_assignment_bin)) {
                                manager.add((IContributionItem)new Separator());
                                manager.add((IAction)new SelectBinaryInTreeAction(gto.getName()));
                            }
                        }
                        manager.add((IContributionItem)new Separator());
                        manager.add((IAction)new ExpandCollapseAction(tv, "ExpandAll"));
                        manager.add((IAction)new ExpandCollapseAction(tv, "CollapseAll"));
                    }
                    catch (RuntimeException e) {
                        RTLogger.print(5, "Error creating context menu", e);
                    }
                }
            }
        });
    }

    public void createCM_4Export(final TreeViewer tv) {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        Menu menu = menuMgr.createContextMenu(tv.getControl());
        tv.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)tv);
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                if (tv == null) {
                    return;
                }
                int iCount = tv.getTree().getItemCount();
                if (iCount > 0) {
                    String treeTYPE = (String)tv.getData(TREE_VIEWER_TYPE);
                    StructuredSelection ssel = (StructuredSelection)tv.getSelection();
                    Object o = ssel.getFirstElement();
                    try {
                        manager.add((IAction)new RefreshTreeAction(tv, null, null, null));
                        if (treeTYPE.equals(POLICY_4EXPORT)) {
                            if (o != null && o instanceof GroupTreeObjectLast) {
                                manager.add((IContributionItem)new Separator());
                                manager.add((IAction)new OpenPolicyAction(tv, true));
                                manager.add((IAction)new SelectPolicyInTreeAction(tv));
                                manager.add((IAction)new ShowRelatedPolicyInfosAction(tv, Display.getCurrent().getActiveShell()));
                            }
                        } else if (treeTYPE.equals(ASSIGNMENT_4EXPORT)) {
                            GroupTreeObject gto;
                            manager.add((IContributionItem)new Separator());
                            if (o != null && o instanceof GroupTreeObjectLast) {
                                GroupTreeObjectLast gtol = (GroupTreeObjectLast)o;
                                if (gtol.getType().equals(BMUI.type_mon) || gtol.getType().equals(BMUI.type_msg)) {
                                    manager.add((IAction)new SelectPolicyInTreeAction(tv));
                                } else if (gtol.getType().equals(BMUI.type_assignment_bin)) {
                                    manager.add((IAction)new SelectBinaryInTreeAction(tv));
                                }
                            } else if (o != null && o instanceof GroupTreeObject && (gto = (GroupTreeObject)o).getType().equals(BMUI.type_assignment_pol)) {
                                manager.add((IAction)new SelectAssignmentInTreeAction(gto.getName()));
                            }
                            manager.add((IAction)new ResolveLinks(m_instance));
                        } else if (treeTYPE.equals(BINARY_4EXPORT)) {
                            GroupTreeObject gto;
                            if (o != null && o instanceof GroupTreeObjectLast) {
                                manager.add((IContributionItem)new Separator());
                                manager.add((IAction)new OpenFileAction(m_instance.getSite().getWorkbenchWindow(), ssel));
                            } else if (o != null && o instanceof GroupTreeObject && (gto = (GroupTreeObject)o).getType().equals(BMUI.type_assignment_bin)) {
                                manager.add((IContributionItem)new Separator());
                                manager.add((IAction)new UpdatePackage(m_instance, gto));
                                manager.add((IAction)new SelectBinaryInTreeAction(gto.getName()));
                            }
                        }
                        manager.add((IContributionItem)new Separator());
                        manager.add((IAction)new ExpandCollapseAction(tv, "ExpandAll"));
                        manager.add((IAction)new ExpandCollapseAction(tv, "CollapseAll"));
                    }
                    catch (RuntimeException e) {
                        RTLogger.print(5, "Error creating context menu", e);
                    }
                }
            }
        });
    }

    public void processAddElements(TreeViewer tv, TreeViewer tv_export, boolean exportAll) {
        if (tv == null || tv_export == null) {
            return;
        }
        StructuredSelection ssel = null;
        String treeTYPE = (String)tv.getData(TREE_VIEWER_TYPE);
        if (exportAll) {
            if (treeTYPE.equals(POLICY)) {
                ssel = new StructuredSelection((Object)this.m_polRoot.getFirstChild("Policies"));
            } else if (treeTYPE.equals(ASSIGNMENT)) {
                ssel = new StructuredSelection((Object)this.m_asnRoot.getFirstChild("Assignments"));
            } else if (treeTYPE.equals(BINARY)) {
                ssel = new StructuredSelection((Object)this.m_binRoot.getFirstChild("Packages"));
            } else if (treeTYPE.equals(ACTION)) {
                ssel = new StructuredSelection(this.m_actRoot.getElements());
            } else if (treeTYPE.equals(NODE)) {
                ssel = new StructuredSelection((Object)this.m_nodRoot.getChild("_Groups", BMUI.type_folder));
            }
        } else {
            ssel = (StructuredSelection)tv.getSelection();
        }
        if (ssel == null || ssel.isEmpty()) {
            return;
        }
        for (Object o : ssel) {
            if (!(o instanceof GroupTreeObject)) continue;
            GroupTreeObject selGTO = (GroupTreeObject)o;
            String gtoTYPE = selGTO.getType();
            if (treeTYPE.equals(POLICY)) {
                this.addElement(tv_export, this.m_pol4ExportRoot, selGTO);
                continue;
            }
            if (treeTYPE.equals(ASSIGNMENT)) {
                if (!gtoTYPE.equals(BMUI.type_toplevel) && !gtoTYPE.equals(BMUI.type_assignment_pol)) continue;
                this.addElement(tv_export, this.m_asn4ExportRoot, selGTO);
                continue;
            }
            if (treeTYPE.equals(BINARY)) {
                if (!gtoTYPE.equals(BMUI.type_toplevel) && !gtoTYPE.equals(BMUI.type_assignment_bin)) continue;
                this.addElement(tv_export, this.m_bin4ExportRoot, selGTO);
                continue;
            }
            if (treeTYPE.equals(ACTION)) {
                this.addElement(tv_export, this.m_act4ExportRoot, selGTO);
                continue;
            }
            if (!treeTYPE.equals(NODE) || selGTO instanceof GroupTreeObjectLast) continue;
            this.addElement(tv_export, this.m_nod4ExportRoot, selGTO);
        }
        if (treeTYPE.equals(POLICY)) {
            this.refreshTree(tv_export, this.m_pol4ExportRoot);
            this.identifyUnresolvedLinks(this.m_asn4ExportRoot);
            this.refreshTree(this.m_tv_asn4Export, this.m_asn4ExportRoot);
        } else if (treeTYPE.equals(ASSIGNMENT)) {
            this.refreshTree(tv_export, this.m_asn4ExportRoot);
            this.identifyUnresolvedLinks(this.m_asn4ExportRoot);
            this.refreshTree(this.m_tv_asn4Export, this.m_asn4ExportRoot);
        } else if (treeTYPE.equals(BINARY)) {
            this.refreshTree(tv_export, this.m_bin4ExportRoot);
            this.identifyUnresolvedLinks(this.m_asn4ExportRoot);
            this.refreshTree(this.m_tv_asn4Export, this.m_asn4ExportRoot);
        } else if (treeTYPE.equals(ACTION)) {
            this.refreshTree(tv_export, this.m_act4ExportRoot);
        } else if (treeTYPE.equals(NODE)) {
            this.refreshTree(tv_export, this.m_nod4ExportRoot);
        }
    }

    public void addElement(TreeViewer tv_export, GroupTreeObject exportTreeRoot, GroupTreeObject selected) {
        if (tv_export == null || exportTreeRoot == null || selected == null) {
            return;
        }
        String treeTYPE = (String)tv_export.getData(TREE_VIEWER_TYPE);
        GroupTreeObject parentGTO = null;
        GroupTreeObject existingGTO = null;
        if (treeTYPE.equals(ACTION_4EXPORT)) {
            String path = selected.getPath();
            if (path.startsWith("/Actions")) {
                path = path.replaceFirst("/Actions", "/root");
                existingGTO = exportTreeRoot.searchPath(path, selected.getType());
            }
        } else {
            existingGTO = exportTreeRoot.searchPath(selected.getPath(), selected.getType());
        }
        if (existingGTO != null) {
            parentGTO = existingGTO.getParent();
            parentGTO.removeElement(existingGTO);
        } else {
            try {
                parentGTO = GroupTreeObject.createPath(selected.getParentPath(), exportTreeRoot);
                parentGTO.setType(selected.getParent().getType());
            }
            catch (Exception exception) {}
        }
        if (parentGTO != null) {
            try {
                LinkedList<GroupTreeObjectLast> noPermittedToRead = new LinkedList<GroupTreeObjectLast>();
                GroupTreeObject clone = selected.clone();
                if (clone != null) {
                    if (treeTYPE.equals(POLICY_4EXPORT)) {
                        List<GroupTreeObjectLast> elements = clone.getAllGTOLs();
                        for (GroupTreeObjectLast el : elements) {
                            if (PolicyManager.getInstance().isPermittedPolicyRead(el)) continue;
                            el.getParent().removeElement(el);
                            noPermittedToRead.add(el);
                        }
                    }
                    if (treeTYPE.equals(NODE_4EXPORT)) {
                        clone = this.removeGTOLs(clone);
                    }
                    parentGTO.addElement(clone);
                    if (noPermittedToRead.size() > 0) {
                        ShowMessageDialog smd = new ShowMessageDialog(this.getSite().getShell(), "Not permitted elements selected", "You are not permitted to export:", String.valueOf(noPermittedToRead.size()) + " policies", true, "Continue", noPermittedToRead, "");
                        smd.setIconInHeader(BMUI.IMAGE_CRITICAL);
                        smd.setBlockOnOpen(true);
                        int res = smd.open();
                        if (res == 1) {
                            throw new RuntimeException("Cancel operation requested by user");
                        }
                    }
                }
            }
            catch (CloneNotSupportedException e) {
                RTLogger.print(5, "Error cloning element " + selected.getName(), e);
            }
        }
    }

    public GroupTreeObject removeGTOLs(GroupTreeObject gtol) {
        if (gtol == null) {
            return null;
        }
        List<GroupTreeObject> elements = gtol.getAllElements();
        for (GroupTreeObject o : elements) {
            if (!(o instanceof GroupTreeObjectLast)) continue;
            GroupTreeObjectLast gtol2Del = (GroupTreeObjectLast)o;
            gtol2Del.getParent().removeElement(gtol2Del);
        }
        return gtol;
    }

    public void processRemoveElements(TreeViewer tv_export, GroupTreeObject root4Export) {
        if (tv_export == null || root4Export == null) {
            return;
        }
        StructuredSelection ssel = (StructuredSelection)tv_export.getSelection();
        if (ssel.isEmpty()) {
            return;
        }
        for (Object o : ssel) {
            if (!(o instanceof GroupTreeObject)) continue;
            GroupTreeObject selection = (GroupTreeObject)o;
            selection.getParent().removeElement(selection);
            String treeType = (String)tv_export.getData(TREE_VIEWER_TYPE);
            this.removeConflict(treeType, selection);
        }
        String treeTYPE = (String)tv_export.getData(TREE_VIEWER_TYPE);
        if (treeTYPE.equals(POLICY_4EXPORT) || treeTYPE.equals(BINARY_4EXPORT) || treeTYPE.equals(ASSIGNMENT_4EXPORT)) {
            this.identifyUnresolvedLinks(this.m_asn4ExportRoot);
            if (tv_export != this.m_tv_asn4Export) {
                this.refreshTree(this.m_tv_asn4Export, this.m_asn4ExportRoot);
            }
        }
        this.refreshTree(tv_export, root4Export);
    }

    private void identifyUnresolvedLinks(GroupTreeObject gto) {
        if (gto == null) {
            return;
        }
        List<Object> elements = new ArrayList<GroupTreeObject>();
        if (gto instanceof GroupTreeObjectLast) {
            elements.add(gto);
        } else {
            elements = gto.getAllElements();
        }
        int i = 0;
        while (i < elements.size()) {
            GroupTreeObject gto2 = (GroupTreeObject)elements.get(i);
            if (gto2 instanceof GroupTreeObjectLast) {
                GroupTreeObjectLast gtol = (GroupTreeObjectLast)gto2;
                String type = gtol.getTreeObject().getType();
                if (type.equals(BMUI.type_mon) || type.equals(BMUI.type_msg)) {
                    if (this.m_pol4ExportRoot.findElement(gtol.getName(), type) == null) {
                        gtol.setLinkOK(false);
                        if (type.equals(BMUI.type_mon)) {
                            gtol.setIcon("IMAGE_MON_LNK_BROKEN");
                        } else {
                            gtol.setIcon("IMAGE_MSG_LNK__BROKEN");
                        }
                    } else {
                        gtol.setLinkOK(true);
                        if (type.equals(BMUI.type_mon)) {
                            gtol.setIcon("IMAGE_MON_LNK");
                        } else {
                            gtol.setIcon("IMAGE_MSG_LNK");
                        }
                    }
                } else if (type.equals(BMUI.type_assignment_bin)) {
                    GroupTreeObject gto_bin = this.m_bin4ExportRoot.findFirstGroupByName(gtol.getName());
                    if (gto_bin == null) {
                        gtol.setLinkOK(false);
                        gtol.setIcon("IMAGE_PKG_LNK_BROKEN");
                    } else {
                        gtol.setLinkOK(true);
                        gtol.setIcon("IMAGE_PKG_LNK");
                    }
                }
            }
            ++i;
        }
        this.m_gui.enableField(this.m_resolveLinks_btn, this.hasUnresolvedLinks());
        int numOfBrokenLinks = this.getUnresolvedLinksCount();
        if (numOfBrokenLinks == 0) {
            this.m_brokenLinks_Field.setVisible(false);
        } else if (numOfBrokenLinks > 0) {
            this.m_brokenLinks_Field.setVisible(true);
            this.m_brokenLinks_Field.setText(numOfBrokenLinks + " broken links!");
        }
    }

    public boolean hasUnresolvedLinks() {
        return this.getUnresolvedLinksCount() > 0;
    }

    public int getUnresolvedLinksCount() {
        ArrayList<GroupTreeObjectLast> brokenLinkedPaths = new ArrayList<GroupTreeObjectLast>();
        if (this.m_asn4ExportRoot != null && this.m_asn4ExportRoot.hasElements().booleanValue()) {
            List<GroupTreeObject> elements = this.m_asn4ExportRoot.getAllElements();
            for (GroupTreeObject o : elements) {
                GroupTreeObjectLast gtol;
                if (!(o instanceof GroupTreeObjectLast) || (gtol = (GroupTreeObjectLast)o).isLinkOK()) continue;
                brokenLinkedPaths.add(gtol);
            }
        }
        return brokenLinkedPaths.size();
    }

    public void validateExportTrees(String treeType, GroupTreeObject updatedRoot, GroupTreeObject exportRoot) {
        this.m_conflicts.clear();
        for (GroupTreeObject gto : exportRoot.getAllElements()) {
            if (updatedRoot.searchPath(gto.getPath(), gto.getType()) == null) {
                this.addConflict(treeType, gto);
                continue;
            }
            this.removeConflict(treeType, gto);
        }
    }

    public void addConflict(String treeType, GroupTreeObject gto) {
        if (this.m_conflicts.containsKey(treeType)) {
            List<GroupTreeObject> list = this.m_conflicts.get(treeType);
            if (!list.contains(gto)) {
                list.add(gto);
            }
        } else {
            ArrayList<GroupTreeObject> list = new ArrayList<GroupTreeObject>();
            list.add(gto);
            this.m_conflicts.put(treeType, list);
        }
    }

    public void removeConflict(String treeType, GroupTreeObject gto) {
        if (this.m_conflicts.containsKey(treeType)) {
            List<GroupTreeObject> list = this.m_conflicts.get(treeType);
            if (list.contains(gto)) {
                list.remove(gto);
            }
            this.m_conflicts.put(treeType, list);
        }
    }

    public void refreshTree(TreeViewer tv, GroupTreeObject root) {
        if (tv == null || root == null) {
            return;
        }
        Object[] expanded = tv.getExpandedElements();
        tv.setInput((Object)root);
        if (expanded == null || expanded.length == 0) {
            String treeTYPE = (String)tv.getData(TREE_VIEWER_TYPE);
            if (!ACTION_4EXPORT.equals(treeTYPE)) {
                tv.expandToLevel(2);
            }
        } else {
            int i = 0;
            while (i < expanded.length) {
                tv.setExpandedState(expanded[i], true);
                ++i;
            }
        }
        tv.refresh();
    }

    public void checkButtons() {
        if (this.isTreeEmpty(this.m_pol4ExportRoot) && this.isTreeEmpty(this.m_asn4ExportRoot) && this.isTreeEmpty(this.m_bin4ExportRoot) && this.isTreeEmpty(this.m_act4ExportRoot) && this.isTreeEmpty(this.m_nod4ExportRoot)) {
            this.m_gui.enableField(this.m_clear_btn, false);
            this.m_gui.enableField(this.m_export_btn, false);
        } else {
            this.m_gui.enableField(this.m_clear_btn, true);
            this.m_gui.enableField(this.m_export_btn, true);
        }
    }

    public boolean isTreeEmpty(GroupTreeObject treeViewerGTO) {
        boolean isEmpty = true;
        if (treeViewerGTO != null && treeViewerGTO.hasElements().booleanValue()) {
            isEmpty = false;
        }
        return isEmpty;
    }

    public void clearSection(TreeViewer tv, GroupTreeObject root) {
        if (root != null && !this.isTreeEmpty(root)) {
            root.clean();
        }
        tv.setInput((Object)root);
    }

    public void exportMPI() {
        boolean hasElem4Export = false;
        this.m_exportDir_pol = null;
        this.m_exportDir_act = null;
        this.m_exportDir_asn = null;
        this.m_exportDir_bin = null;
        this.m_exportDir_nod = null;
        File exportDir = this.askForExportDirectory();
        if (exportDir != null) {
            boolean success = this.createExportDirectory(exportDir);
            if (success) {
                if (this.m_polSection.isEnabled()) {
                    GroupTreeObject polGTO = this.m_pol4ExportRoot.getFirstChild("Policies");
                    if (this.m_exportDir_pol != null && polGTO != null && polGTO.hasElements().booleanValue()) {
                        try {
                            ExportPolicyAction exportPolicies = new ExportPolicyAction(this.m_tv_pol4Export, this.m_pol4ExportRoot, this.m_exportDir_pol);
                            if (exportPolicies.hasElements4Export()) {
                                exportPolicies.run();
                                hasElem4Export = true;
                            }
                        }
                        catch (Throwable e) {
                            RTLogger.print(5, "Error exporting MPI Policies", e);
                        }
                    }
                }
                if (this.m_actSection.isEnabled() && this.m_exportDir_act != null && this.m_act4ExportRoot.hasElements().booleanValue()) {
                    try {
                        ExportActionGroup exportActions = new ExportActionGroup(this.m_tv_act4Export, this.m_act4ExportRoot, this.m_exportDir_act);
                        if (exportActions.hasElements4Export()) {
                            exportActions.run();
                            hasElem4Export = true;
                        }
                    }
                    catch (Throwable e) {
                        RTLogger.print(5, "Error exporting MPI Actions", e);
                    }
                }
                if (this.m_asnSection.isEnabled()) {
                    GroupTreeObject asnGTO = this.m_asn4ExportRoot.getFirstChild("Assignments");
                    if (this.m_exportDir_asn != null && asnGTO != null && asnGTO.hasElements().booleanValue()) {
                        hasElem4Export = true;
                        try {
                            this.exportAssignments(asnGTO);
                        }
                        catch (Throwable e) {
                            RTLogger.print(5, "Error exporting MPI Assignment Groups " + asnGTO.getName(), e);
                        }
                    }
                }
                if (this.m_binSection.isEnabled()) {
                    GroupTreeObject packagesGTO = this.m_bin4ExportRoot.getFirstChild("Packages");
                    if (this.m_exportDir_bin != null && packagesGTO != null && packagesGTO.hasElements().booleanValue()) {
                        hasElem4Export = true;
                        try {
                            this.exportPackages(packagesGTO);
                        }
                        catch (Throwable e) {
                            RTLogger.print(5, "Error exporting MPI Packages", e);
                        }
                    }
                }
                if (this.m_nodSection.isEnabled()) {
                    GroupTreeObject nodeGroupGTO = this.m_nod4ExportRoot.getFirstChild("_Groups");
                    if (this.m_exportDir_nod != null && nodeGroupGTO != null && nodeGroupGTO.hasElements().booleanValue()) {
                        hasElem4Export = true;
                        try {
                            this.exportNodeGroups(nodeGroupGTO);
                        }
                        catch (Throwable e) {
                            RTLogger.print(5, "Error exporting MPI NodeGroups", e);
                        }
                    }
                }
            }
            if (!hasElem4Export) {
                new ShowMessageBox("   Export MPI", "There was nothing to export!", 32);
            }
        }
    }

    public boolean doesOldMPIDirExist(File exportDir) {
        boolean exist = false;
        File[] contents = exportDir.listFiles();
        if (contents != null) {
            int i = 0;
            while (i < contents.length) {
                File f = contents[i];
                if (f.isDirectory() && (f.getName().equals("policies") || f.getName().equals("actions") || f.getName().equals("packages") || f.getName().equals("nodes"))) {
                    exist = true;
                    break;
                }
                ++i;
            }
        }
        return exist;
    }

    public void exportAssignments(GroupTreeObject asnGTO) {
        block15: {
            ProgressDialog pd;
            block14: {
                XMLTree m_xmlTools = new XMLTree();
                pd = new ProgressDialog("Export Assignments", "Initialization... ", 1, asnGTO.getElements().size());
                pd.setBlockOnOpen(false);
                pd.open();
                try {
                    try {
                        String asnGroupsFile = this.m_exportDir_asn + File.separator + "assignmentGroups.xml";
                        File asnGrpFile = new File(asnGroupsFile);
                        if (!asnGrpFile.exists() || !asnGrpFile.canRead()) {
                            Document doc = m_xmlTools.getXML(this.m_asn4ExportRoot);
                            XMLFactory.writeXml(doc, asnGroupsFile);
                            break block14;
                        }
                        FileInputStream fio = new FileInputStream(asnGroupsFile);
                        this.m_asn4ExportRoot = m_xmlTools.parseXML(fio, true);
                        try {
                            fio.close();
                        }
                        catch (Throwable throwable) {}
                        if (!this.m_asn4ExportRoot.getFirstChild("Assignments").getTreeObject().getType().equals(BMUI.type_toplevel)) {
                            this.m_asn4ExportRoot.getFirstChild("Assignments").setType(BMUI.type_toplevel);
                            Document doc = m_xmlTools.getXML(this.m_asn4ExportRoot);
                            XMLFactory.writeXml(doc, asnGroupsFile);
                        }
                    }
                    catch (Throwable throwable) {
                        RTLogger.print(2, "Assignment groups tree failed to be initialized");
                        try {
                            pd.close();
                        }
                        catch (Throwable throwable2) {}
                        break block15;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        pd.close();
                    }
                    catch (Throwable throwable3) {}
                    throw throwable;
                }
            }
            try {
                pd.close();
            }
            catch (Throwable throwable) {}
        }
    }

    public void exportPackages(GroupTreeObject packagesGTO) {
        block21: {
            ServerClientBatch scb = null;
            ProgressDialog pd = new ProgressDialog("Export binary package", "Initialization... ", 1, packagesGTO.getElements().size());
            pd.setBlockOnOpen(false);
            pd.open();
            try {
                try {
                    Iterator<GroupTreeObject> it = packagesGTO.getAllElements().iterator();
                    scb = new ServerClientBatch("GET_BINPKG_ZIP");
                    while (it.hasNext()) {
                        try {
                            GroupTreeObject pkg = it.next();
                            if (!pkg.getType().equals(BMUI.type_assignment_bin)) continue;
                            String pkgName = pkg.getName();
                            pd.setProgress("getting " + pkgName, 1);
                            scb.setCommand("GET_BINPKG_ZIP", pkgName, new String[0]);
                            String tmpZip = (String)scb.runBatch();
                            if (scb.isSuccess() && tmpZip != null) {
                                File pkgDir = new File(this.m_exportDir_bin, pkgName);
                                pkgDir.mkdir();
                                ZIP zz = new ZIP();
                                pd.setProgress("unzipping " + pkgName, 1);
                                zz.unzip(tmpZip, pkgDir.getCanonicalPath());
                                continue;
                            }
                            throw new RuntimeException("Failed to get package from the server");
                        }
                        catch (Throwable throwable) {}
                    }
                }
                catch (Throwable ee) {
                    ee.printStackTrace();
                    try {
                        scb.close();
                    }
                    catch (Throwable throwable) {}
                    try {
                        pd.close();
                    }
                    catch (Throwable throwable) {}
                    break block21;
                }
            }
            catch (Throwable throwable) {
                try {
                    scb.close();
                }
                catch (Throwable throwable2) {}
                try {
                    pd.close();
                }
                catch (Throwable throwable3) {}
                throw throwable;
            }
            try {
                scb.close();
            }
            catch (Throwable throwable) {}
            try {
                pd.close();
            }
            catch (Throwable throwable) {}
        }
    }

    public void exportNodeGroups(GroupTreeObject nodeGroupGTO) {
        block15: {
            ProgressDialog pd;
            block14: {
                XMLTree m_xmlTools = new XMLTree();
                GroupTreeObject nodeTreeRoot = null;
                pd = new ProgressDialog("Export Node Groups", "Initialization... ", 1, nodeGroupGTO.getElements().size());
                pd.setBlockOnOpen(false);
                pd.open();
                try {
                    try {
                        String nodeGroupsFile = this.m_exportDir_nod + File.separator + "nodeGroups.xml";
                        File nodeGrpFile = new File(nodeGroupsFile);
                        if (!nodeGrpFile.exists() || !nodeGrpFile.canRead()) {
                            nodeTreeRoot = new GroupTreeObject(new TreeObject("root", BMUI.type_folder, null));
                            nodeTreeRoot.addElement(nodeGroupGTO);
                            Document doc = m_xmlTools.getXML(nodeTreeRoot);
                            XMLFactory.writeXml(doc, nodeGroupsFile);
                            break block14;
                        }
                        FileInputStream fio = new FileInputStream(nodeGrpFile);
                        nodeTreeRoot = m_xmlTools.parseXML(fio, true);
                        try {
                            fio.close();
                        }
                        catch (Throwable throwable) {}
                        if (!nodeTreeRoot.getFirstChild("_Groups").getTreeObject().getType().equals(BMUI.type_toplevel)) {
                            nodeTreeRoot.getFirstChild("_Groups").setType(BMUI.type_toplevel);
                            Document doc = m_xmlTools.getXML(nodeTreeRoot);
                            XMLFactory.writeXml(doc, nodeGroupsFile);
                        }
                    }
                    catch (Throwable throwable) {
                        RTLogger.print(2, "Node Group tree failed to be initialized");
                        try {
                            pd.close();
                        }
                        catch (Throwable throwable2) {}
                        break block15;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        pd.close();
                    }
                    catch (Throwable throwable3) {}
                    throw throwable;
                }
            }
            try {
                pd.close();
            }
            catch (Throwable throwable) {}
        }
    }

    public File askForExportDirectory() {
        String dirName;
        File dir = null;
        DirectoryDialog fd = new DirectoryDialog(Display.getCurrent().getActiveShell());
        fd.setText("Select directory");
        if (m_lastDirSelected != null) {
            fd.setFilterPath(m_lastDirSelected);
        }
        if ((dirName = fd.open()) != null) {
            dir = new File(dirName);
            if (!dir.isDirectory()) {
                dir = dir.getParentFile();
            }
            m_lastDirSelected = dir.getPath();
            boolean exist = this.doesOldMPIDirExist(dir);
            if (exist) {
                String msg = "Previous Export Data found. Do you want to overwrite them?";
                ShowSimpleDialog dialog = new ShowSimpleDialog(Display.getCurrent().getActiveShell(), "  Export Data found", msg, "Overwrite", "Cancel");
                int res = dialog.open();
                if (res == 0) {
                    return dir;
                }
                dir = this.askForExportDirectory();
            }
        }
        return dir;
    }

    public boolean createExportDirectory(File dir) {
        boolean created = false;
        String exportPath = dir.getPath();
        try {
            this.m_exportDir_pol = new File(String.valueOf(exportPath) + File.separator + "policies");
            if (this.m_exportDir_pol.exists()) {
                this.clearDirectory(this.m_exportDir_pol);
            } else {
                this.m_exportDir_pol.mkdir();
            }
            this.m_exportDir_act = new File(String.valueOf(exportPath) + File.separator + "actions");
            if (this.m_exportDir_act.exists()) {
                this.clearDirectory(this.m_exportDir_act);
            } else {
                this.m_exportDir_act.mkdir();
            }
            this.m_exportDir_asn = new File(String.valueOf(exportPath) + File.separator + "policies");
            if (this.m_exportDir_asn.exists()) {
                this.clearDirectory(this.m_exportDir_asn);
            } else {
                this.m_exportDir_asn.mkdir();
            }
            this.m_exportDir_bin = new File(String.valueOf(exportPath) + File.separator + "packages");
            if (this.m_exportDir_bin.exists()) {
                this.clearDirectory(this.m_exportDir_bin);
            } else {
                this.m_exportDir_bin.mkdir();
            }
            this.m_exportDir_nod = new File(String.valueOf(exportPath) + File.separator + "nodes");
            if (this.m_exportDir_nod.exists()) {
                this.clearDirectory(this.m_exportDir_nod);
            } else {
                this.m_exportDir_nod.mkdir();
            }
            created = true;
        }
        catch (Exception e) {
            RTLogger.print(3, "Error creating export diretories: " + e.getMessage());
            new ShowMessageBox("  Error", "Error creating Export Directories!", 1);
            created = false;
        }
        return created;
    }

    public void clearDirectory(File diretory) {
        if (diretory.exists()) {
            File[] files = diretory.listFiles();
            int i = 0;
            while (i < files.length) {
                if (files[i].isDirectory()) {
                    this.clearDirectory(files[i]);
                    files[i].delete();
                } else {
                    files[i].delete();
                }
                ++i;
            }
        }
    }

    public void setSectionTitle(String type) {
        if (type.equals(POLICY)) {
            this.m_polSection.setText("Policies");
        } else if (type.equals(ASSIGNMENT)) {
            this.m_asnSection.setText("Assignment Groups");
        } else if (type.equals(BINARY)) {
            this.m_binSection.setText("Packages");
        } else if (type.equals(ACTION)) {
            this.m_actSection.setText("Actions");
        } else if (type.equals(NODE)) {
            this.m_nodSection.setText("Node Groups");
        }
    }

    public void setFocus() {
    }

    public void doubleClick(DoubleClickEvent event) {
        Viewer v = event.getViewer();
        if (v instanceof TreeViewer) {
            Object obj;
            TreeViewer tv = (TreeViewer)v;
            StructuredSelection ssel = (StructuredSelection)event.getViewer().getSelection();
            if (ssel.size() == 1 && !((obj = ssel.getFirstElement()) instanceof GroupTreeObjectLast) && obj instanceof GroupTreeObject) {
                tv.setExpandedState((Object)((GroupTreeObject)obj), !tv.getExpandedState((Object)((GroupTreeObject)obj)));
            }
        }
    }

    public void widgetDisposed(DisposeEvent e) {
        this.m_tv_pol4Export = null;
        this.m_tv_asn = null;
        this.m_tv_asn4Export = null;
        this.m_tv_bin = null;
        this.m_tv_bin4Export = null;
        this.m_tv_act = null;
        this.m_tv_act4Export = null;
        this.m_tv_node = null;
        this.m_tv_node4Export = null;
        this.m_polRoot = null;
        this.m_asnRoot = null;
        this.m_binRoot = null;
        this.m_actRoot = null;
        this.m_pol4ExportRoot = null;
        this.m_asn4ExportRoot = null;
        this.m_bin4ExportRoot = null;
        this.m_act4ExportRoot = null;
    }

    public void keyPressed(KeyEvent e) {
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.getSource() instanceof Button) {
            Button b = (Button)e.getSource();
            String name = (String)b.getData();
            if (name.equals(ADD_POL_BTN)) {
                this.processAddElements(this.m_tv_pol, this.m_tv_pol4Export, false);
            } else if (name.equals(REMOVE_POL_BTN)) {
                this.processRemoveElements(this.m_tv_pol4Export, this.m_pol4ExportRoot);
            } else if (name.equals(ADD_ASN_BTN)) {
                this.processAddElements(this.m_tv_asn, this.m_tv_asn4Export, false);
            } else if (name.equals(REMOVE_ASN_BTN)) {
                this.processRemoveElements(this.m_tv_asn4Export, this.m_asn4ExportRoot);
            } else if (name.equals(ADD_BIN_BTN)) {
                this.processAddElements(this.m_tv_bin, this.m_tv_bin4Export, false);
            } else if (name.equals(REMOVE_BIN_BTN)) {
                this.processRemoveElements(this.m_tv_bin4Export, this.m_bin4ExportRoot);
            } else if (name.equals(ADD_ACTION_BTN)) {
                this.processAddElements(this.m_tv_act, this.m_tv_act4Export, false);
            } else if (name.equals(REMOVE_ACTION_BTN)) {
                this.processRemoveElements(this.m_tv_act4Export, this.m_act4ExportRoot);
            } else if (name.equals(ADD_NODE_BTN)) {
                this.processAddElements(this.m_tv_node, this.m_tv_node4Export, false);
            } else if (name.equals(REMOVE_NODE_BTN)) {
                this.processRemoveElements(this.m_tv_node4Export, this.m_nod4ExportRoot);
            } else if (name.equals(RESOLVE_LINKS_BTN)) {
                ResolveLinks resolve = new ResolveLinks(m_instance, this.m_asn4ExportRoot);
                resolve.run();
                if (!this.hasUnresolvedLinks()) {
                    this.m_gui.enableField(this.m_resolveLinks_btn, false);
                }
            } else if (name.equals(CLEAR_BTN)) {
                this.clearSection(this.m_tv_pol4Export, this.m_pol4ExportRoot);
                this.clearSection(this.m_tv_asn4Export, this.m_asn4ExportRoot);
                this.clearSection(this.m_tv_bin4Export, this.m_bin4ExportRoot);
                this.clearSection(this.m_tv_act4Export, this.m_act4ExportRoot);
                this.clearSection(this.m_tv_node4Export, this.m_nod4ExportRoot);
                this.identifyUnresolvedLinks(this.m_asn4ExportRoot);
                this.m_conflicts.clear();
            } else if (name.equals(SELECT_ALL_BTN)) {
                this.processAddElements(this.m_tv_pol, this.m_tv_pol4Export, true);
                this.processAddElements(this.m_tv_asn, this.m_tv_asn4Export, true);
                this.processAddElements(this.m_tv_bin, this.m_tv_bin4Export, true);
                this.processAddElements(this.m_tv_act, this.m_tv_act4Export, true);
                this.processAddElements(this.m_tv_node, this.m_tv_node4Export, true);
            } else if (name.equals(EXPORT_BTN)) {
                this.exportMPI();
            }
            this.checkButtons();
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        boolean validSel = true;
        TreeViewer tv = (TreeViewer)event.getSource();
        String treeType = (String)tv.getData(TREE_VIEWER_TYPE);
        StructuredSelection ssel = (StructuredSelection)tv.getSelection();
        if (!ssel.isEmpty()) {
            Iterator it = ssel.iterator();
            if (treeType.equals(POLICY)) {
                if (!this.m_add_pol_btn.isEnabled()) {
                    this.m_add_pol_btn.setEnabled(true);
                }
            } else if (treeType.equals(ASSIGNMENT)) {
                while (it.hasNext()) {
                    GroupTreeObject gto = (GroupTreeObject)it.next();
                    if (gto.getType().equals(BMUI.type_toplevel) || gto.getType().equals(BMUI.type_assignment_pol)) continue;
                    validSel = false;
                    break;
                }
                this.m_add_asn_btn.setEnabled(validSel);
            } else if (treeType.equals(BINARY)) {
                while (it.hasNext()) {
                    GroupTreeObject gto = (GroupTreeObject)it.next();
                    if (gto.getType().equals(BMUI.type_toplevel) || gto.getType().equals(BMUI.type_assignment_bin)) continue;
                    validSel = false;
                    break;
                }
                this.m_add_bin_btn.setEnabled(validSel);
            } else if (treeType.equals(ACTION)) {
                if (!this.m_add_act_btn.isEnabled()) {
                    this.m_add_act_btn.setEnabled(true);
                }
            } else if (treeType.equals(NODE)) {
                while (it.hasNext()) {
                    GroupTreeObject gto = (GroupTreeObject)it.next();
                    if (!(gto instanceof GroupTreeObjectLast)) continue;
                    validSel = false;
                    break;
                }
                this.m_add_nod_btn.setEnabled(validSel);
            } else if (treeType.equals(POLICY_4EXPORT)) {
                if (!this.m_remove_pol_btn.isEnabled()) {
                    this.m_remove_pol_btn.setEnabled(true);
                }
            } else if (treeType.equals(ASSIGNMENT_4EXPORT)) {
                if (!this.m_remove_asn_btn.isEnabled()) {
                    this.m_remove_asn_btn.setEnabled(true);
                }
            } else if (treeType.equals(BINARY_4EXPORT)) {
                while (it.hasNext()) {
                    GroupTreeObject gto = (GroupTreeObject)it.next();
                    if (gto.getType().equals(BMUI.type_toplevel) || gto.getType().equals(BMUI.type_assignment_bin)) continue;
                    validSel = false;
                    break;
                }
                this.m_remove_bin_btn.setEnabled(validSel);
            } else if (treeType.equals(ACTION_4EXPORT)) {
                if (!this.m_remove_act_btn.isEnabled()) {
                    this.m_remove_act_btn.setEnabled(true);
                }
            } else if (treeType.equals(NODE_4EXPORT) && !this.m_remove_nod_btn.isEnabled()) {
                this.m_remove_nod_btn.setEnabled(true);
            }
        }
    }

    public void expansionStateChanged(ExpansionEvent e) {
        int hight1 = Display.getCurrent().getClientArea().height;
        int hight2 = this.m_sc.getClientArea().height;
        if (hight1 > hight2) {
            this.m_sc.setContent((Control)this.m_mainComp);
            this.m_sc.setMinSize(this.m_mainComp.computeSize(-1, -1, true));
        }
    }

    public void expansionStateChanging(ExpansionEvent e) {
    }

    public class ResolveLinks
    extends Action {
        private ExportMPIView m_exportMPIView;
        private List<GroupTreeObjectLast> m_brokenLinkedPaths;

        public ResolveLinks(ExportMPIView exportMPIView2) {
            super("resolvelinks");
            this.m_exportMPIView = null;
            this.m_brokenLinkedPaths = new ArrayList<GroupTreeObjectLast>();
            this.setText("Resolve broken Links");
            this.setId("resolvelinks");
            this.m_exportMPIView = exportMPIView2;
            StructuredSelection ssel = (StructuredSelection)exportMPIView2.m_tv_asn4Export.getSelection();
            if (!ssel.isEmpty()) {
                for (Object o : ssel) {
                    if (o instanceof GroupTreeObjectLast) {
                        GroupTreeObjectLast gtol = (GroupTreeObjectLast)o;
                        if (gtol.isLinkOK()) continue;
                        this.m_brokenLinkedPaths.add(gtol);
                        continue;
                    }
                    if (!(o instanceof GroupTreeObject)) continue;
                    GroupTreeObject gto = (GroupTreeObject)o;
                    List<GroupTreeObject> elems = gto.getAllElements();
                    int i = 0;
                    while (i < elems.size()) {
                        GroupTreeObjectLast gtol;
                        GroupTreeObject obj = elems.get(i);
                        if (obj instanceof GroupTreeObjectLast && !(gtol = (GroupTreeObjectLast)obj).isLinkOK()) {
                            this.m_brokenLinkedPaths.add(gtol);
                        }
                        ++i;
                    }
                }
            }
            if (this.m_brokenLinkedPaths.size() == 0) {
                this.setEnabled(false);
            }
        }

        public ResolveLinks(ExportMPIView exportMPIView2, GroupTreeObject gto) {
            super("resolvelinks");
            this.m_exportMPIView = null;
            this.m_brokenLinkedPaths = new ArrayList<GroupTreeObjectLast>();
            this.setText("Resolve broken Links");
            this.setId("resolvelinks");
            this.m_exportMPIView = exportMPIView2;
            this.m_brokenLinkedPaths = new ArrayList<GroupTreeObjectLast>();
            List<GroupTreeObject> elements = gto.getAllElements();
            for (GroupTreeObject o : elements) {
                GroupTreeObjectLast gtol;
                if (!(o instanceof GroupTreeObjectLast) || (gtol = (GroupTreeObjectLast)o).isLinkOK()) continue;
                this.m_brokenLinkedPaths.add(gtol);
            }
            if (this.m_brokenLinkedPaths.size() == 0) {
                this.setEnabled(false);
            }
        }

        public void run() {
            if (this.m_brokenLinkedPaths == null || this.m_brokenLinkedPaths.size() == 0) {
                return;
            }
            for (GroupTreeObjectLast gtol : this.m_brokenLinkedPaths) {
                GroupTreeObject foundBin;
                String linkedPath = gtol.getLinkedPath();
                String type = gtol.getType();
                if (type.equals(BMUI.type_mon) || type.equals(BMUI.type_msg)) {
                    GroupTreeObject foundPol = this.m_exportMPIView.m_polRoot.searchPath(linkedPath, type);
                    if (foundPol == null) continue;
                    gtol.setLinkOK(true);
                    this.m_exportMPIView.addElement(this.m_exportMPIView.m_tv_pol4Export, this.m_exportMPIView.m_pol4ExportRoot, foundPol);
                    continue;
                }
                if (!type.equals(BMUI.type_assignment_bin) || (foundBin = this.m_exportMPIView.m_binRoot.searchPath(linkedPath, type)) == null) continue;
                gtol.setLinkOK(true);
                this.m_exportMPIView.addElement(this.m_exportMPIView.m_tv_bin4Export, this.m_exportMPIView.m_bin4ExportRoot, foundBin);
            }
            this.m_exportMPIView.refreshTree(this.m_exportMPIView.m_tv_pol4Export, this.m_exportMPIView.m_pol4ExportRoot);
            this.m_exportMPIView.refreshTree(this.m_exportMPIView.m_tv_bin4Export, this.m_exportMPIView.m_bin4ExportRoot);
            this.m_exportMPIView.identifyUnresolvedLinks(this.m_exportMPIView.m_asn4ExportRoot);
            this.m_exportMPIView.refreshTree(ExportMPIView.this.m_tv_asn4Export, ExportMPIView.this.m_asn4ExportRoot);
        }
    }

    public class UpdatePackage
    extends Action {
        private ExportMPIView m_exportMPIView;
        private GroupTreeObject m_pkgGTO;

        public UpdatePackage(ExportMPIView exportMPIView2, GroupTreeObject pkgGTO) {
            super("updatepackage");
            this.m_exportMPIView = null;
            this.m_pkgGTO = null;
            this.setText("Update Package");
            this.setId("updatepackage");
            this.m_exportMPIView = exportMPIView2;
            this.m_pkgGTO = pkgGTO;
            if (this.m_pkgGTO == null) {
                this.setEnabled(false);
            }
        }

        public void run() {
            if (this.m_pkgGTO == null) {
                return;
            }
            this.m_exportMPIView.processAddElements(this.m_exportMPIView.m_tv_bin, this.m_exportMPIView.m_tv_bin4Export, false);
        }
    }
}

