/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views;

import com.blixx.boom.engine.AgentCard;
import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.gui.Activator;
import com.blixx.boom.gui.dialogs.CondVFilterDialog;
import com.blixx.boom.gui.dialogs.CustomerAttributesDialog;
import com.blixx.boom.gui.dialogs.PVDialog;
import com.blixx.boom.gui.dialogs.PatternValidationDialog;
import com.blixx.boom.gui.dialogs.ShowMessageDialog;
import com.blixx.boom.gui.utils.GUIDisplayElements;
import com.blixx.boom.gui.utils.ImageCombo;
import com.blixx.boom.gui.utils.PatternValidator;
import com.blixx.boom.gui.views.CondVFilterTableProvider;
import com.blixx.boom.gui.views.FilterCondList;
import com.blixx.boom.gui.views.FilterPolicyTab;
import com.blixx.boom.gui.views.MonitorPolicyTab;
import com.blixx.boom.gui.views.PolicyView;
import com.blixx.boom.gui.views.Proposals;
import com.blixx.log.RTLogger;
import com.blixx.shared.Interval;
import com.blixx.shared.MsgCondition;
import com.blixx.shared.MsgPolicy;
import com.blixx.shared.PatternB;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.bindings.keys.ParseException;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.SimpleContentProposalProvider;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchPartSite;

public class FilterCondDetails
implements ModifyListener,
SelectionListener,
MouseListener {
    public static final String[] PROPOSALS_DEFAULT = new String[]{"<$AGENT_HOST>", "<$AGENT_ID>", "<$AGENT_IP>", "<$APPLICATION>", "<$GROUP>", "<$HOST>", "<$OBJECT>", "<$OPTIONS>", "<$ORIG_APPLICATION>", "<$ORIG_GROUP>", "<$ORIG_OBJECT>", "<$ORIG_TEXT>", "<$SEVERITY>", "<$TIME>"};
    private List<String> m_toVfilter = null;
    private static FilterCondDetails m_instance = null;
    public MsgPolicy m_policy = null;
    public FilterPolicyTab m_policyTab;
    public static FilterCondDetails m_filterCondDetails = null;
    public FilterCondList m_conditionList;
    public MsgCondition m_condition;
    public GUIDisplayElements m_guiElements;
    public boolean m_init = true;
    public Composite m_parent = null;
    public boolean m_dataChanged = true;
    public TableViewer m_condVFilter_tv = null;
    public CondVFilterTableProvider m_condVFilter_tableProvider = null;
    public static String COND_DESCRIPTION = "c_description";
    public static String COND_ADVICE = "advice";
    public static String COND_INSTRUCTION = "c_instruction";
    public static String COND_OBJKEY = "objkey";
    public static String COND_CLOSE_MASK = "close_mask";
    public static String COND_INDICATION_GRP = "indication_grp";
    public static String COND_APPLICATION = "application";
    public static String COND_HOST = "host";
    public static String COND_OBJECT = "OBJECT";
    public static String COND_TEXT = "text";
    public static String COND_VFILTER = "VFILTER";
    public static String COND_NEGATION = "negation";
    public static String COND_ACTIONTYPE = "actiontype";
    public static String COND_SET_APPLICATION = "set_application";
    public static String COND_SET_INDICATION_GRP = "set_indication_grp";
    public static String COND_SET_SEVERITY = "set_severity";
    public static String COND_SET_TEXT = "set_text";
    public static String COND_SET_OBJECT = "set_object";
    public static String COND_SET_HOST = "set_host";
    public static String COND_SILENCE_TIME = "silence_time";
    public static String COND_SILENCE_COUNT = "silence_count";
    public static String COND_AUTOACTION = "autoaction";
    public static String COND_AUTOACTION_HOST = "autoactionHost";
    public static String COND_AUTOACTION_TIMEOUT = "autoactionTimeout";
    public static String COND_OPERATORACTION_HOST = "operatoractionHost";
    public static String COND_OPACTION = "opaction";
    public static String BUTTON_VALIDATE = "validate";
    public static String BUTTON_DISPLAY_CA = "Customer Attributes";
    public static String BTN_COND_VFILTER_EDIT = "BTN_COND_VFILTER_EDIT";
    public static String BTN_COND_VFILTER_ADD = "BTN_COND_VFILTER_ADD";
    public static String BTN_COND_VFILTER_DEL = "BTN_COND_VFILTER_DEL";
    public static final String SELECT_TYPE_A = "type_a";
    public static final String SELECT_TYPE_K = "type_k";
    public static final String SELECT_DEDUPL = "dedupl";
    public static final String SELECT_DEDUPL_KEYONLY = "deduplKeyOnly";
    public static final String SELECT_INSERT_CLOSED = "insert_closed";
    public static final String SELECT_CRITICAL = "SELECT_CRITICAL";
    public static final String SELECT_MAJOR = "SELECT_MAJOR";
    public static final String SELECT_MINOR = "SELECT_MINOR";
    public static final String SELECT_WARNING = "SELECT_WARNING";
    public static final String SELECT_NORMAL = "SELECT_NORMAL";
    public static final String SELECT_UNKNOWN = "SELECT_UNKNOWN";
    public Text m_condDescription_Field;
    public Text m_condAdvice_Field;
    public Text m_condInstruction_Field;
    public Text m_condIndicationKey_Field;
    public Text m_condCloseMask_Field;
    public Text m_condIndicationGroup_Field;
    public Text m_condApplicaton_Field;
    public Text m_condHost_Field;
    public Text m_condObject_Field;
    public Text m_condText_Field;
    public Table m_condVFilter_table;
    public Text m_condSeverity_Text;
    public Button m_chUn;
    public Button m_chNo;
    public Button m_chWa;
    public Button m_chMi;
    public Button m_chMa;
    public Button m_chCr;
    public Button m_chType_a;
    public Button m_chType_k;
    public Button m_chDedupl;
    public Button m_chDeduplKeyOnly;
    public Button m_chInsertClosed;
    public Button m_validate_Button;
    public Button m_cAttributes_Button;
    public Button m_condVFilter_add_btn = null;
    public Button m_condVFilter_del_btn = null;
    public Button m_condVFilter_edit_btn = null;
    public Button m_condVFilter_validate_btn = null;
    public ImageCombo m_condActionType_Combo;
    public Text m_condSetApplication_Field;
    public Text m_condSetIndicationGroup_Field;
    public ImageCombo m_condSetSeverity_Combo;
    public Text m_condSetText_Field;
    public Text m_condSetObject_Field;
    public Text m_condSetHost_Field;
    public Text m_condSilenceTime_Field;
    public Text m_condSilenceCount_Field;
    public Text m_condAutoaction_Field;
    public Text m_condOpaction_Field;
    public Text m_condAutoactionTimeOut_Field;
    private Text m_condID;
    public CCombo m_condAutoaction_CC;
    public Text m_condAAStartOnDuplicate;
    public boolean m_isSilenceTimeValid = false;
    public boolean m_isSilenceCountValid = false;
    public boolean m_isTimeoutValid = false;
    public boolean m_isStartOnDupValid = false;
    public boolean m_isSearchTextValid = false;
    private List<String> m_registerMouseClick = new ArrayList<String>();
    private static HashMap<String, Image> m_severityList = new HashMap();
    public static final String DROP_UNMATCHED = "DROP unmatched";
    public static final String DROP_MATCHED = "DROP matched";
    public static final String SEND_UNMATCHED = "SEND unmatched";
    public static final String SEND_MATCHED = "SEND matched";
    private static final String[] m_typeList;
    private static final List<String> TYPES_AS_LIST;
    private static HashMap<String, Image> m_condTypeList_ICONS;
    private SimpleContentProposalProvider m_Proposals4setText;
    private SimpleContentProposalProvider m_Proposals4VFilter;
    public CustomerAttributesDialog m_cad;

    static {
        m_severityList.put("<*>", null);
        m_severityList.put("", null);
        m_severityList.put("critical", BMUI.IMAGE_CRITICAL);
        m_severityList.put("major", BMUI.IMAGE_MAJOR);
        m_severityList.put("minor", BMUI.IMAGE_MINOR);
        m_severityList.put("warning", BMUI.IMAGE_WARNING);
        m_severityList.put("normal", BMUI.IMAGE_NORMAL);
        m_severityList.put("unknown", BMUI.IMAGE_UNKNOWN);
        m_typeList = new String[]{SEND_MATCHED, SEND_UNMATCHED, DROP_MATCHED, DROP_UNMATCHED};
        TYPES_AS_LIST = Arrays.asList(m_typeList);
        m_condTypeList_ICONS = new HashMap();
        m_condTypeList_ICONS.put(SEND_MATCHED, BMUI.IMAGE_ACCEPT_GREEN);
        m_condTypeList_ICONS.put(SEND_UNMATCHED, BMUI.IMAGE_ACCEPT_GREEN);
        m_condTypeList_ICONS.put(DROP_MATCHED, BMUI.IMAGE_STOP);
        m_condTypeList_ICONS.put(DROP_UNMATCHED, BMUI.IMAGE_STOP);
    }

    public static FilterCondDetails getInstance() {
        return m_instance;
    }

    public FilterCondDetails() {
    }

    public FilterCondDetails(MsgPolicy mp, FilterPolicyTab policyTab, Composite parent, FilterCondList cList, MsgCondition c) {
        m_instance = this;
        this.m_parent = parent;
        this.m_policy = mp;
        this.m_policyTab = policyTab;
        this.m_conditionList = cList;
        this.m_condition = c;
        if (this.m_condition == null) {
            this.m_condition = MsgCondition.getNew(1);
            this.m_conditionList.addCondition(null);
        }
        m_filterCondDetails = this;
        this.m_guiElements = new GUIDisplayElements();
        try {
            this.init();
            this.refreshFields();
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            RTLogger.print(5, "Error opening IndicationConditionDetails", e);
        }
        this.m_init = false;
        this.validateSilenceCount();
        this.validateSilenceTime();
        this.validateTimeout();
        this.validateStartOnDup();
        this.validateSearchText(this.m_condition.getTextFilter());
    }

    public void init() {
        Composite comp = new Composite(this.m_parent, 0);
        GridLayout gl = new GridLayout(2, false);
        gl.verticalSpacing = 0;
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        gl.marginTop = 5;
        comp.setLayout((Layout)gl);
        comp.setLayoutData((Object)new GridData(4, 4, false, false));
        this.m_condDescription_Field = this.m_guiElements.addInputFieldSingle(comp, COND_DESCRIPTION, "Description: ", "", 1, 1, 1, 0, 80, this);
        this.m_condID = this.m_guiElements.addTextReadOnly(comp, "ID: ", null, 1, 1, 1, 3, null, null);
        this.m_condAdvice_Field = this.m_guiElements.addInputFieldMultiLineWrap(comp, COND_ADVICE, "Advice: ", "", 1, 1, 87, 80, 1, 3, this);
        this.m_condInstruction_Field = this.m_guiElements.addInputFieldSingle(comp, COND_INSTRUCTION, "Instruction URL: ", "", 1, 1, 1, 6, 80, this);
        SimpleContentProposalProvider instructionsMonitorProvider = new SimpleContentProposalProvider(Proposals.SERVER_INSTRUCTIONS_MONITOR);
        this.setContentAssist((Control)this.m_condInstruction_Field, instructionsMonitorProvider);
        this.m_guiElements.addTextField(comp, null, "", 1, 1, 1, 0, null);
        Composite comp5 = new Composite(comp, 0);
        comp5.setLayout((Layout)new GridLayout(4, false));
        comp5.setLayoutData((Object)new GridData(4, 4, false, false));
        Group radioBtnGroup = new Group(comp5, 0);
        radioBtnGroup.setText("Metric");
        gl = new GridLayout(1, false);
        gl.marginHeight = 0;
        gl.verticalSpacing = 0;
        radioBtnGroup.setLayout((Layout)gl);
        radioBtnGroup.setLayoutData((Object)new GridData(1, 128, false, false));
        this.m_chType_a = this.m_guiElements.addCheckbox((Composite)radioBtnGroup, SELECT_TYPE_A, "Availability Metric", false, 1, 1, 5, this);
        ((GridData)this.m_chType_a.getLayoutData()).verticalAlignment = 128;
        this.m_chType_k = this.m_guiElements.addCheckbox((Composite)radioBtnGroup, SELECT_TYPE_K, "KPI Metric", false, 1, 1, 5, this);
        ((GridData)this.m_chType_k.getLayoutData()).verticalAlignment = 128;
        Group deduplGR = new Group(comp5, 0);
        deduplGR.setText("De-duplication");
        gl = new GridLayout(1, false);
        gl.marginHeight = 0;
        gl.verticalSpacing = 0;
        deduplGR.setLayout((Layout)gl);
        deduplGR.setLayoutData((Object)new GridData(1, 128, false, false));
        deduplGR.setToolTipText("De-duplication can be disabled\nonly for conditions without Close Mask");
        this.m_chDedupl = this.m_guiElements.addCheckbox((Composite)deduplGR, SELECT_DEDUPL, "Detect Duplicates", true, 1, 1, 5, null, this);
        this.m_chDeduplKeyOnly = this.m_guiElements.addCheckbox((Composite)deduplGR, SELECT_DEDUPL_KEYONLY, "De-Duplicate KeyOnly", true, 1, 1, 5, null, this);
        Composite comp0 = new Composite(comp5, 0);
        gl = new GridLayout(1, false);
        gl.marginHeight = 0;
        gl.verticalSpacing = 0;
        comp0.setLayout((Layout)gl);
        comp0.setLayoutData((Object)new GridData(1, 128, false, false));
        this.m_chInsertClosed = this.m_guiElements.addCheckbox(comp0, SELECT_INSERT_CLOSED, "Add As Closed", false, 1, 1, 0, this);
        ((GridData)this.m_chInsertClosed.getLayoutData()).verticalIndent = 10;
        this.m_cAttributes_Button = this.m_guiElements.addButton(comp0, BUTTON_DISPLAY_CA, "", true, 95, 20, 11, this);
        ((GridData)this.m_cAttributes_Button.getLayoutData()).horizontalIndent = 0;
        ((GridData)this.m_cAttributes_Button.getLayoutData()).verticalIndent = 5;
        ((GridData)this.m_cAttributes_Button.getLayoutData()).verticalAlignment = 128;
        Group silenceGR = new Group(comp5, 0);
        silenceGR.setText("");
        gl = new GridLayout(2, false);
        gl.marginHeight = 0;
        gl.verticalSpacing = 0;
        silenceGR.setLayout((Layout)gl);
        silenceGR.setLayoutData((Object)new GridData(1, 128, false, false));
        this.m_condSilenceTime_Field = this.m_guiElements.addInputFieldSingle((Composite)silenceGR, COND_SILENCE_TIME, "Silence Time: ", "", 1, 1, 1, 1, 50, this);
        this.m_condSilenceCount_Field = this.m_guiElements.addInputFieldSingle((Composite)silenceGR, COND_SILENCE_COUNT, "Silence Count: ", "", 1, 1, 1, 1, 50, this);
        this.m_condActionType_Combo = this.m_guiElements.addDropDownWithImage(comp, COND_ACTIONTYPE, "Condition Type: ", m_condTypeList_ICONS, m_typeList, null, null, 1, 1, 1, 6, null);
        this.m_condActionType_Combo.addSelectionListener(this);
        ((GridData)this.m_condActionType_Combo.getLayoutData()).horizontalAlignment = 16384;
        ((GridData)this.m_condActionType_Combo.getLayoutData()).widthHint = 200;
        Composite comp1 = new Composite(this.m_parent, 0);
        gl = new GridLayout(2, false);
        gl.marginHeight = 0;
        gl.verticalSpacing = 0;
        comp1.setLayout((Layout)gl);
        comp1.setLayoutData((Object)new GridData(4, 128, true, false, 2, 1));
        this.m_condIndicationKey_Field = this.m_guiElements.addInputFieldSingle(comp1, COND_OBJKEY, "Indication Key: ", "", 1, 1, 1, 1, 80, this);
        this.m_condIndicationKey_Field.setTextLimit(255);
        this.m_Proposals4setText = new SimpleContentProposalProvider(PROPOSALS_DEFAULT);
        this.setContentAssist((Control)this.m_condIndicationKey_Field, this.m_Proposals4setText);
        this.m_condCloseMask_Field = this.m_guiElements.addInputFieldSingle(comp1, COND_CLOSE_MASK, "Close Mask: ", "", 1, 1, 1, 1, 80, this);
        this.m_condCloseMask_Field.setTextLimit(255);
        this.setContentAssist((Control)this.m_condCloseMask_Field, this.m_Proposals4setText);
        Composite compGroups = new Composite(this.m_parent, 0);
        compGroups.setLayout((Layout)new GridLayout(2, true));
        compGroups.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        Group filterGroup = new Group(compGroups, 64);
        gl = new GridLayout(6, false);
        gl.marginBottom = 5;
        gl.marginRight = 5;
        gl.verticalSpacing = 2;
        filterGroup.setLayout((Layout)gl);
        GridData gd = new GridData(4, 4, true, false, 1, 1);
        gd.verticalIndent = 5;
        gd.widthHint = 365;
        filterGroup.setText("Filter");
        filterGroup.setLayoutData((Object)gd);
        this.m_condApplicaton_Field = this.m_guiElements.addInputFieldSingle((Composite)filterGroup, COND_APPLICATION, "Application: ", "", 5, 1, 1, 1, 55, this);
        this.m_condIndicationGroup_Field = this.m_guiElements.addInputFieldSingle((Composite)filterGroup, COND_INDICATION_GRP, "Indication Group: ", "", 5, 1, 1, 1, 60, this);
        this.m_condObject_Field = this.m_guiElements.addInputFieldSingle((Composite)filterGroup, COND_OBJECT, "Object: ", "", 5, 1, 1, 1, 60, this);
        this.m_condHost_Field = this.m_guiElements.addInputFieldSingle((Composite)filterGroup, COND_HOST, "Host: ", "", 5, 1, 1, 1, 60, this);
        this.m_condSeverity_Text = this.m_guiElements.addTextReadOnly((Composite)filterGroup, "Severity: ", "", 5, 1, 1, 1, null, null);
        String sevText = this.m_condition.getSeverityFilter();
        boolean isAll = sevText.equals("<*>");
        this.m_guiElements.addTextField((Composite)filterGroup, null, "", 1, 1, 1, 0, null);
        this.m_chUn = this.m_guiElements.addCheckbox((Composite)filterGroup, SELECT_UNKNOWN, "unknown", sevText.indexOf("unknown") != -1 | isAll, 1, 1, 5, BMUI.IMAGE_UNKNOWN, this);
        this.m_chNo = this.m_guiElements.addCheckbox((Composite)filterGroup, SELECT_NORMAL, "normal", sevText.indexOf("normal") != -1 | isAll, 1, 1, 5, BMUI.IMAGE_NORMAL, this);
        this.m_chWa = this.m_guiElements.addCheckbox((Composite)filterGroup, SELECT_WARNING, "warning", sevText.indexOf("warning") != -1 | isAll, 3, 1, 5, BMUI.IMAGE_WARNING, this);
        this.m_guiElements.addTextField((Composite)filterGroup, null, "", 1, 1, 1, 1, null);
        this.m_chMi = this.m_guiElements.addCheckbox((Composite)filterGroup, SELECT_MINOR, "minor", sevText.indexOf("minor") != -1 | isAll, 1, 1, 1, BMUI.IMAGE_MINOR, this);
        this.m_chMa = this.m_guiElements.addCheckbox((Composite)filterGroup, SELECT_MAJOR, "major", sevText.indexOf("major") != -1 | isAll, 1, 1, 1, BMUI.IMAGE_MAJOR, this);
        this.m_chCr = this.m_guiElements.addCheckbox((Composite)filterGroup, SELECT_CRITICAL, "critical", sevText.indexOf("critical") != -1 | isAll, 3, 1, 1, BMUI.IMAGE_CRITICAL, this);
        Group overwriteGroup = new Group(compGroups, 0);
        gl = new GridLayout(2, false);
        gl.marginRight = 5;
        gl.verticalSpacing = 0;
        overwriteGroup.setLayout((Layout)gl);
        gd = new GridData(4, 4, true, false, 1, 1);
        gd.verticalIndent = 5;
        gd.horizontalIndent = 10;
        gd.widthHint = 100;
        overwriteGroup.setText("Overwrite Attributes");
        overwriteGroup.setLayoutData((Object)gd);
        this.m_condSetApplication_Field = this.m_guiElements.addInputFieldSingle((Composite)overwriteGroup, COND_SET_APPLICATION, "Set Application: ", "", 1, 1, 1, 3, 80, this);
        this.m_condSetApplication_Field.setTextLimit(255);
        String[] def = new String[]{};
        try {
            PatternB filter = PatternB.getPattern(this.m_condition.getTextFilter());
            LinkedList<String> values = new LinkedList<String>();
            for (String name : filter.getOvVariables()) {
                values.add("<$" + name + ">");
            }
            def = values.toArray(def);
        }
        catch (Throwable throwable) {}
        this.m_condSetApplication_Field.addMouseListener((MouseListener)this);
        this.m_condSetApplication_Field.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                FilterCondDetails.this.m_registerMouseClick.remove(COND_SET_APPLICATION);
                if (FilterCondDetails.this.m_condSetApplication_Field.getText().trim().equals("")) {
                    FilterCondDetails.setFieldToGlobalValue(FilterCondDetails.this.m_condSetApplication_Field, FilterCondDetails.this.m_policy.getSetApplication());
                }
            }

            public void focusGained(FocusEvent e) {
            }
        });
        this.setContentAssist((Control)this.m_condSetApplication_Field, this.m_Proposals4setText);
        this.m_condSetIndicationGroup_Field = this.m_guiElements.addInputFieldSingle((Composite)overwriteGroup, COND_SET_INDICATION_GRP, "Set Group: ", "", 1, 1, 1, 3, 80, this);
        this.m_condSetIndicationGroup_Field.setTextLimit(255);
        this.m_condSetIndicationGroup_Field.addMouseListener((MouseListener)this);
        this.m_condSetIndicationGroup_Field.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                FilterCondDetails.this.m_registerMouseClick.remove(COND_SET_INDICATION_GRP);
                if (FilterCondDetails.this.m_condSetIndicationGroup_Field.getText().trim().equals("")) {
                    FilterCondDetails.setFieldToGlobalValue(FilterCondDetails.this.m_condSetIndicationGroup_Field, FilterCondDetails.this.m_policy.getSetGroup());
                }
            }

            public void focusGained(FocusEvent e) {
            }
        });
        this.setContentAssist((Control)this.m_condSetIndicationGroup_Field, this.m_Proposals4setText);
        this.m_condSetObject_Field = this.m_guiElements.addInputFieldSingle((Composite)overwriteGroup, COND_SET_OBJECT, "Set Object: ", "", 1, 1, 1, 3, 80, this);
        this.m_condSetObject_Field.setTextLimit(255);
        this.setContentAssist((Control)this.m_condSetObject_Field, this.m_Proposals4setText);
        this.m_condSetHost_Field = this.m_guiElements.addInputFieldSingle((Composite)overwriteGroup, COND_SET_HOST, "Set Host: ", "", 1, 1, 1, 3, 80, this);
        this.m_condSetHost_Field.setTextLimit(255);
        this.setContentAssist((Control)this.m_condSetHost_Field, this.m_Proposals4setText);
        this.m_condSetSeverity_Combo = this.m_guiElements.addDropDownWithImage((Composite)overwriteGroup, COND_SET_SEVERITY, "Set Severity: ", this.getSeverityImageList(), this.getSeverityTextList(), null, null, 1, 1, 1, 1, null);
        this.m_condSetSeverity_Combo.addSelectionListener(this);
        ((GridData)this.m_condSetSeverity_Combo.getLayoutData()).horizontalAlignment = 16384;
        ((GridData)this.m_condSetSeverity_Combo.getLayoutData()).widthHint = 100;
        Composite comp2 = new Composite(this.m_parent, 0);
        gl = new GridLayout(6, false);
        gl.verticalSpacing = 0;
        comp2.setLayout((Layout)gl);
        comp2.setLayoutData((Object)new GridData(4, 128, true, false, 2, 1));
        this.m_guiElements.addTextField(comp2, null, "Search Text:     ", 1, 1, 0, 0, BMUI.font_arial8);
        Composite comp4 = new Composite(comp2, 0);
        gl = new GridLayout(2, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        gl.verticalSpacing = 0;
        comp4.setLayout((Layout)gl);
        comp4.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 5, 1));
        this.m_condText_Field = this.m_guiElements.addInputFieldSingle(comp4, COND_TEXT, null, "", 1, 1, 0, 0, 80, this);
        this.m_validate_Button = this.m_guiElements.addButton(comp4, BUTTON_VALIDATE, " Validate Pattern", true, 90, 20, 1, this);
        this.createCondVFilterTable(comp2);
        this.m_condSetText_Field = this.m_guiElements.addInputFieldMultiLineNoWrap(comp2, COND_SET_TEXT, "Set Text: ", "", 5, 1, 50, 60, 1, 15, this);
        this.setContentAssist((Control)this.m_condSetText_Field, this.m_Proposals4setText);
        Collection<AgentCard> collection = Repository.getInstance().getAgentCards();
        String[] arr = new String[collection.size() + 2];
        arr[0] = "";
        arr[1] = "BOOM_SERVER";
        String selected = this.fillArrayAndGetSelected(collection, arr, 2);
        this.m_condAutoaction_Field = this.m_guiElements.addInputFieldSingle(comp2, COND_AUTOACTION, "Auto Action: ", "", 1, 1, 1, 3, 20, this);
        this.m_condAutoaction_Field.setTextLimit(255);
        this.setContentAssist((Control)this.m_condAutoaction_Field, this.m_Proposals4setText);
        this.m_condAutoaction_CC = this.m_guiElements.addDropDownEditable(comp2, COND_AUTOACTION_HOST, "AA Host: ", arr, selected, "select an Agent", 2, 1, 1, 3, null);
        this.m_condAutoaction_CC.addSelectionListener((SelectionListener)this);
        ((GridData)this.m_condAutoaction_CC.getLayoutData()).horizontalAlignment = 4;
        ((GridData)this.m_condAutoaction_CC.getLayoutData()).widthHint = 200;
        this.m_condAutoaction_CC.setVisibleItemCount(10);
        Composite comp3 = new Composite(comp2, 0);
        gl = new GridLayout(4, false);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        gl.verticalSpacing = 0;
        comp3.setLayout((Layout)gl);
        comp3.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.m_condAutoactionTimeOut_Field = this.m_guiElements.addInputFieldSingle(comp3, COND_AUTOACTION_TIMEOUT, "AA Timeout (sec): ", "", 1, 1, 1, 0, 50, this);
        ((GridData)this.m_condAutoactionTimeOut_Field.getLayoutData()).horizontalAlignment = 131072;
        this.m_condAAStartOnDuplicate = this.m_guiElements.addInputFieldSingle(comp3, MonitorPolicyTab.COND_AA_START_ONDUPLICATE, "AA Start on duplicate:   ", "0", 1, 1, 1, 1, 30, this);
        ((GridData)this.m_condAAStartOnDuplicate.getLayoutData()).horizontalAlignment = 16384;
        this.m_condOpaction_Field = this.m_guiElements.addInputFieldSingle(comp2, COND_OPACTION, "Operator Action: ", "", 5, 1, 1, 3, 20, this);
        this.m_condOpaction_Field.setTextLimit(255);
        this.setContentAssist((Control)this.m_condOpaction_Field, this.m_Proposals4setText);
    }

    public void createCondVFilterTable(Composite parent) {
        Group group = new Group(parent, 4);
        group.setText("Match Variables: ");
        GridLayout gl = new GridLayout(2, false);
        gl.verticalSpacing = 2;
        group.setLayout((Layout)gl);
        GridData gd = new GridData(4, 4, true, false, 6, 1);
        gd.verticalIndent = 5;
        group.setLayoutData((Object)gd);
        this.m_condVFilter_table = new Table((Composite)group, 68354);
        this.m_condVFilter_table.setHeaderVisible(true);
        this.m_condVFilter_table.setLinesVisible(true);
        int fontHight = 12;
        try {
            fontHight = (int)(BMUI.font_arial8.getFontData()[0].height + 5.0f);
        }
        catch (Throwable throwable) {}
        gd = new GridData(4, 4, true, false, 1, 3);
        gd.heightHint = fontHight * 3;
        this.m_condVFilter_table.setLayoutData((Object)gd);
        TableColumn col1 = new TableColumn(this.m_condVFilter_table, 16384);
        col1.setText("Variable");
        col1.setWidth(200);
        TableColumn col2 = new TableColumn(this.m_condVFilter_table, 16384);
        col2.setText("Simplified Pattern");
        col2.setWidth(500);
        this.m_condVFilter_table.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (FilterCondDetails.this.m_policyTab.isReadOnly()) {
                    return;
                }
                if (FilterCondDetails.this.m_condVFilter_tv.getSelection().isEmpty()) {
                    FilterCondDetails.this.m_guiElements.enableField(FilterCondDetails.this.m_condVFilter_edit_btn, false);
                    FilterCondDetails.this.m_guiElements.enableField(FilterCondDetails.this.m_condVFilter_del_btn, false);
                } else {
                    FilterCondDetails.this.m_guiElements.enableField(FilterCondDetails.this.m_condVFilter_edit_btn, true);
                    FilterCondDetails.this.m_guiElements.enableField(FilterCondDetails.this.m_condVFilter_del_btn, true);
                }
            }
        });
        this.m_condVFilter_tv = new TableViewer(this.m_condVFilter_table);
        this.m_condVFilter_tableProvider = new CondVFilterTableProvider(this.m_condVFilter_tv, null);
        this.m_condVFilter_tv.setContentProvider((IContentProvider)this.m_condVFilter_tableProvider);
        this.m_condVFilter_tv.setLabelProvider((IBaseLabelProvider)this.m_condVFilter_tableProvider);
        this.m_condVFilter_tv.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                EditCondVFilterAction editAction = new EditCondVFilterAction(FilterCondDetails.this.m_policyTab.isDirty());
                editAction.run();
            }
        });
        this.addContentMenu_CondVFilterTable();
        this.m_condVFilter_add_btn = this.m_guiElements.addButton((Composite)group, BTN_COND_VFILTER_ADD, "Add", !this.m_policyTab.isReadOnly(), 90, 20, 1, this);
        ((GridData)this.m_condVFilter_add_btn.getLayoutData()).horizontalAlignment = 4;
        this.m_condVFilter_edit_btn = this.m_guiElements.addButton((Composite)group, BTN_COND_VFILTER_EDIT, "Edit", false, 90, 20, 1, this);
        ((GridData)this.m_condVFilter_edit_btn.getLayoutData()).horizontalAlignment = 4;
        this.m_condVFilter_del_btn = this.m_guiElements.addButton((Composite)group, BTN_COND_VFILTER_DEL, "Delete", false, 90, 20, 1, this);
        ((GridData)this.m_condVFilter_del_btn.getLayoutData()).horizontalAlignment = 4;
    }

    public void addContentMenu_CondVFilterTable() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(false);
        Menu menu = menuMgr.createContextMenu(this.m_condVFilter_tv.getControl());
        this.m_condVFilter_tv.getControl().setMenu(menu);
        IWorkbenchPartSite site = PolicyView.getInstance().getSite();
        site.registerContextMenu(menuMgr, (ISelectionProvider)this.m_condVFilter_tv);
        menuMgr.setRemoveAllWhenShown(true);
        if (!this.m_policyTab.isReadOnly()) {
            menuMgr.addMenuListener(new IMenuListener(){

                public void menuAboutToShow(IMenuManager manager) {
                    try {
                        manager.add((IAction)new EditCondVFilterAction(FilterCondDetails.this.m_policyTab.isDirty()));
                        manager.add((IAction)new AddCondVFilterAction(FilterCondDetails.this.m_policyTab.isDirty()));
                        manager.add((IAction)new DeleteCondVFilterAction(FilterCondDetails.this.m_policyTab.isDirty()));
                        manager.add((IContributionItem)new Separator());
                        manager.add((IAction)new ValidatePatternAction(PatternValidator.SIMPLIFIED));
                    }
                    catch (RuntimeException runtimeException) {}
                }
            });
        }
    }

    public void refreshCondVFilterTable() {
        int[] selIndices = this.m_condVFilter_tv.getTable().getSelectionIndices();
        this.m_condVFilter_tv.setInput((Object)this.m_condVFilter_tableProvider.getElements(null));
        this.m_condVFilter_tv.getTable().setSelection(selIndices);
        this.m_condVFilter_tv.getTable().select(selIndices);
    }

    public int refreshCondVFilterTable(int selIndex) {
        int count;
        this.m_condVFilter_tv.setInput((Object)this.m_condVFilter_tableProvider.getElements(null));
        if (selIndex > -1 && selIndex >= (count = this.m_condVFilter_tv.getTable().getItemCount())) {
            selIndex = count - 1;
        }
        if (selIndex >= -1) {
            this.m_condVFilter_tv.getTable().setSelection(selIndex);
            this.m_condVFilter_tv.getTable().select(selIndex);
        }
        return selIndex;
    }

    public void setContentAssist(Control ct, SimpleContentProposalProvider provider) {
        char[] autoActivationCharacters = new char[]{};
        try {
            KeyStroke keyStroke = KeyStroke.getInstance((String)"Ctrl+Space");
            new ContentProposalAdapter(ct, (IControlContentAdapter)new TextContentAdapter(), (IContentProposalProvider)provider, keyStroke, autoActivationCharacters);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    public String fillArrayAndGetSelected(Collection<AgentCard> agents, String[] arr, int start) {
        String selected = this.m_condition.getAutoAction_Node();
        Iterator<AgentCard> it = agents.iterator();
        int i = start;
        while (it.hasNext()) {
            AgentCard agentCard = it.next();
            arr[i] = String.valueOf(agentCard.getAgentHost()) + "|" + agentCard.getAgentID();
            if (this.m_condition.getAutoAction_Node().equals(agentCard.getAgentID())) {
                selected = arr[i];
            }
            ++i;
        }
        Arrays.sort(arr);
        return selected;
    }

    public void refreshFields() {
        try {
            this.m_condDescription_Field.setText(this.m_condition.getDescription());
            this.m_condAdvice_Field.setText(this.m_condition.getHelptext());
            if (this.m_condition.getInstructionAction() != null) {
                this.m_condInstruction_Field.setText(this.m_condition.getInstructionAction());
            }
            this.setCAButtonText(this.getCAttributesSize());
            this.m_chType_a.setSelection(false);
            if (this.m_condition.getTypeA() != 0) {
                this.m_chType_a.setSelection(true);
            }
            this.m_chType_k.setSelection(false);
            if (this.m_condition.getTypeK() != 0) {
                this.m_chType_k.setSelection(true);
            }
            this.m_chInsertClosed.setSelection(false);
            if (this.m_condition.getInsertClosed() != 0) {
                this.m_chInsertClosed.setSelection(true);
            }
            this.m_chDedupl.setSelection(this.m_condition.isDedupl());
            this.m_chDeduplKeyOnly.setSelection(this.m_condition.isDeduplKeyOnly());
            this.m_condIndicationKey_Field.setText(this.m_condition.getKey());
            this.m_condCloseMask_Field.setText(this.m_condition.getCloseMask());
            if (this.m_condition.getCloseMask() != null && this.m_condition.getCloseMask().trim().length() > 0 && !this.m_condition.isDedupl() && !this.m_condition.isDeduplKeyOnly()) {
                this.m_chDedupl.setSelection(true);
                this.m_condition.setDedupl(true);
            }
            this.m_condIndicationGroup_Field.setText(this.m_condition.getGroupFilter());
            this.m_condApplicaton_Field.setText(this.m_condition.getApplicationFilter());
            this.m_condHost_Field.setText(this.m_condition.getNodeFilter());
            this.m_condObject_Field.setText(this.m_condition.getObjectFilter());
            this.m_condText_Field.setText(this.m_condition.getTextFilter());
            if (this.m_condition.getVfilterAsInPolicy() != null) {
                this.m_condVFilter_tableProvider.init(this.m_condition.getVfilterAsInPolicy());
                this.refreshCondVFilterTable();
            } else {
                this.m_condVFilter_tableProvider.init("");
                this.refreshCondVFilterTable();
            }
            this.m_condSeverity_Text.setText(this.m_condition.getSeverityFilter());
            Collection<AgentCard> al = Repository.getInstance().getAgentCards();
            String[] arr = new String[al.size() + 2];
            arr[0] = "";
            arr[1] = "BOOM_SERVER";
            String selected = this.fillArrayAndGetSelected(al, arr, 2);
            int i = 0;
            while (i < arr.length) {
                if (arr[i].endsWith(selected)) {
                    this.m_condAutoaction_CC.select(i);
                    break;
                }
                ++i;
            }
            String sevText = this.m_condition.getSeverityFilter();
            boolean isAll = sevText.equals("<*>");
            this.m_chUn.setSelection(sevText.indexOf("unknown") != -1 | isAll);
            this.m_chNo.setSelection(sevText.indexOf("normal") != -1 | isAll);
            this.m_chWa.setSelection(sevText.indexOf("warning") != -1 | isAll);
            this.m_chMi.setSelection(sevText.indexOf("minor") != -1 | isAll);
            this.m_chMa.setSelection(sevText.indexOf("major") != -1 | isAll);
            this.m_chCr.setSelection(sevText.indexOf("critical") != -1 | isAll);
            String setApplication = this.m_condition.getSetApplication();
            if (setApplication == null || setApplication.equals("")) {
                this.m_condition.setSetApplication("");
                this.m_condSetApplication_Field.removeModifyListener((ModifyListener)this);
                this.m_condSetApplication_Field.setText(this.m_policy.getSetApplication());
                this.m_condSetApplication_Field.setForeground(BMUI.color_darkGrey2);
                this.m_condSetApplication_Field.addModifyListener((ModifyListener)this);
            } else {
                this.m_condSetApplication_Field.setText(setApplication);
                this.m_condSetApplication_Field.setForeground(BMUI.color_black);
            }
            String setGroup = this.m_condition.getSetGroup();
            if (setGroup == null || setGroup.equals("")) {
                this.m_condition.setSetGroup("");
                this.m_condSetIndicationGroup_Field.removeModifyListener((ModifyListener)this);
                this.m_condSetIndicationGroup_Field.setText(this.m_policy.getSetGroup());
                this.m_condSetIndicationGroup_Field.setForeground(BMUI.color_darkGrey2);
                this.m_condSetIndicationGroup_Field.addModifyListener((ModifyListener)this);
            } else {
                this.m_condSetIndicationGroup_Field.setText(setGroup);
                this.m_condSetIndicationGroup_Field.setForeground(BMUI.color_black);
            }
            this.m_condSetSeverity_Combo.select(this.getSeverityTestListPosition(this.m_condition.getSetSeverity()));
            if (this.m_condition.getSetText() == null) {
                this.m_condition.setSetText("");
            }
            if (this.m_condition.getSetObject() == null) {
                this.m_condition.setSetObject("");
            }
            if (this.m_condition.getSetNode() == null) {
                this.m_condition.setSetNode("");
            }
            this.m_condSetText_Field.setText(this.m_condition.getSetText());
            this.m_condSetObject_Field.setText(this.m_condition.getSetObject());
            this.m_condSetHost_Field.setText(this.m_condition.getSetNode());
            this.m_condSilenceTime_Field.setText(String.valueOf(Integer.toString(this.m_condition.getSuppressInterval() / 60)) + "m");
            this.m_condSilenceCount_Field.setText(Integer.toString(this.m_condition.getSuppressCount()));
            this.m_condAutoaction_Field.setText(this.m_condition.getAutoAction());
            this.m_condAutoaction_CC.setText(this.m_condition.getAutoAction_Node());
            if (this.m_condition.getActionType() == null || this.m_condition.getActionType().isEmpty()) {
                this.m_condition.setActionType("SEND");
            }
            if (this.m_condition.getActionType().equalsIgnoreCase("STOP")) {
                if (!this.m_condition.getExpected()) {
                    this.m_condActionType_Combo.select(TYPES_AS_LIST.indexOf(DROP_UNMATCHED));
                } else {
                    this.m_condActionType_Combo.select(TYPES_AS_LIST.indexOf(DROP_MATCHED));
                }
            } else if (!this.m_condition.getExpected()) {
                this.m_condActionType_Combo.select(TYPES_AS_LIST.indexOf(SEND_UNMATCHED));
            } else {
                this.m_condActionType_Combo.select(TYPES_AS_LIST.indexOf(SEND_MATCHED));
            }
            this.m_condAutoactionTimeOut_Field.setText("" + this.m_condition.getAutoActionTimeout());
            this.m_condAAStartOnDuplicate.setText("" + this.m_condition.getAutoActionOnDuplicate());
            this.m_condOpaction_Field.setText(this.m_condition.getOpAction());
            this.m_condID.setText(this.m_condition.getConditionId());
            this.refreshProposals();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private void refreshProposals() {
        LinkedList<String> values = new LinkedList<String>(Arrays.asList(PROPOSALS_DEFAULT));
        LinkedList<String> fromPattern = new LinkedList<String>();
        try {
            String pattern = this.m_condition.getTextFilter();
            PatternB p = PatternB.getPattern(pattern);
            if (p.getOvVariables().size() > 0) {
                for (String name : p.getOvVariables()) {
                    fromPattern.add("<$" + name + ">");
                }
            } else {
                int groups = p.getJavaPattern().split("\\((?!\\?)").length;
                if (groups > 1) {
                    int i = 1;
                    while (i < groups) {
                        fromPattern.add("<$var" + i + ">");
                        ++i;
                    }
                }
            }
            this.m_toVfilter = new LinkedList<String>();
            this.m_toVfilter.addAll(fromPattern);
            Collections.sort(this.m_toVfilter);
            this.m_Proposals4VFilter.setProposals(this.m_toVfilter.toArray(new String[0]));
            try {
                pattern = null;
                String[] aa = this.m_condition.getVfilterAsInPolicy().split("\\s+");
                if (aa.length > 1) {
                    pattern = this.m_condition.getVfilterAsInPolicy().substring(aa[0].length());
                }
                p = PatternB.getPattern(pattern);
                for (String name : p.getOvVariables()) {
                    fromPattern.add("<$" + name + ">");
                }
            }
            catch (Throwable throwable) {}
            if ("SNMPTrapd".equals(this.m_condition.getApplicationFilter())) {
                values.add("<$A>");
                values.add("<$e>");
                values.add("<$G>");
                values.add("<$S>");
                values.add("<$C>");
                values.add("<$o>");
                values.add("<$#>");
            }
            Collections.sort(fromPattern);
            values.addAll(fromPattern);
            Collections.sort(values);
        }
        catch (Throwable throwable) {}
        values.addAll(fromPattern);
        this.m_Proposals4setText.setProposals(values.toArray(new String[0]));
    }

    private Integer getCAttributesSize() {
        int size = 0;
        ArrayList<String> caList = this.m_condition.clone().getCustomAttributes();
        int i = 0;
        while (i < caList.size()) {
            if (((String)caList.get(i)).trim().length() > 0) {
                ++size;
            }
            ++i;
        }
        return size;
    }

    private void setCAButtonText(int count) {
        this.m_cAttributes_Button.setText("Custom Attributes (" + count + ")");
    }

    private HashMap<String, Image> getSeverityImageList() {
        return m_severityList;
    }

    private int getSeverityTestListPosition(String sev) {
        int res = 0;
        if (sev == null) {
            sev = "";
        }
        int i = 1;
        while (i < this.getSeverityTextList().length) {
            if (this.getSeverityTextList()[i].equalsIgnoreCase(sev)) {
                return i;
            }
            ++i;
        }
        return res;
    }

    private String[] getSeverityTextList() {
        return FilterPolicyTab.SEVERITY_LIST;
    }

    public void setCondition(MsgCondition c) {
        boolean isDirty = this.m_policyTab.isDirty();
        this.m_condition = c;
        this.refreshFields();
        this.m_policyTab.setDirty(isDirty);
    }

    public MsgCondition getCondition() {
        return this.m_condition;
    }

    public void setPattern(String patternNew) {
        this.m_condText_Field.setText(patternNew);
    }

    public boolean validateAll() {
        return this.m_isSilenceTimeValid && this.m_isSilenceCountValid && this.m_isTimeoutValid && this.m_isStartOnDupValid && this.m_isSearchTextValid;
    }

    public void validateSilenceTime() {
        int parsed;
        this.m_isSilenceTimeValid = false;
        String silenceInterval = this.m_condSilenceTime_Field.getText().trim();
        if (this.m_condition.getSuppressInterval() < 0) {
            this.m_condition.setSuppressInterval(0);
        }
        try {
            parsed = Integer.parseInt(silenceInterval);
            if (parsed > 0) {
                this.m_condition.setSuppressInterval(parsed * 60);
                this.m_condSilenceTime_Field.setBackground(BMUI.defaultBackground);
                this.m_isSilenceTimeValid = true;
                return;
            }
        }
        catch (NumberFormatException numberFormatException) {}
        try {
            parsed = Interval.parseInterval(silenceInterval.toLowerCase(), 0).getIntervalSeconds();
            if (parsed >= 0) {
                this.m_condition.setSuppressInterval(parsed);
                this.m_condSilenceTime_Field.setBackground(BMUI.defaultBackground);
                this.m_isSilenceTimeValid = true;
            } else {
                this.m_condSilenceTime_Field.setBackground(BMUI.color_critical);
            }
        }
        catch (NumberFormatException numberFormatException) {}
    }

    public void validateSilenceCount() {
        this.m_isSilenceCountValid = false;
        String silenceCount = this.m_condSilenceCount_Field.getText().trim();
        try {
            int sCount = Integer.valueOf(silenceCount);
            this.m_condition.setSuppressCount(sCount);
            this.m_condSilenceCount_Field.setBackground(BMUI.defaultBackground);
            this.m_isSilenceCountValid = true;
        }
        catch (Throwable throwable) {
            this.m_condSilenceCount_Field.setBackground(BMUI.color_critical);
        }
    }

    public void validateTimeout() {
        this.m_isTimeoutValid = false;
        String value = this.m_condAutoactionTimeOut_Field.getText().trim();
        try {
            int timeout = Integer.parseInt(value);
            this.m_condition.setAutoActionTimeout(timeout);
            this.m_condAutoactionTimeOut_Field.setBackground(BMUI.defaultBackground);
            this.m_isTimeoutValid = true;
        }
        catch (Throwable throwable) {
            this.m_condAutoactionTimeOut_Field.setBackground(BMUI.color_critical);
        }
    }

    public void validateStartOnDup() {
        this.m_isStartOnDupValid = false;
        String value = this.m_condAAStartOnDuplicate.getText().trim();
        try {
            int index = Integer.parseInt(value);
            this.m_condition.setAutoActionOnDuplicate(index);
            this.m_condAAStartOnDuplicate.setBackground(BMUI.defaultBackground);
            this.m_isStartOnDupValid = true;
        }
        catch (Throwable throwable) {
            this.m_condAAStartOnDuplicate.setBackground(BMUI.color_critical);
        }
    }

    public void validateSearchText(String patternStr) {
        this.m_isSearchTextValid = false;
        try {
            if (patternStr.toLowerCase().startsWith("java=")) {
                new PatternB(patternStr);
                this.m_isSearchTextValid = true;
            } else {
                Pattern.compile(patternStr, 32);
                this.m_isSearchTextValid = true;
            }
        }
        catch (RuntimeException runtimeException) {}
        if (this.m_isSearchTextValid) {
            this.m_condText_Field.setBackground(BMUI.defaultBackground);
        } else {
            this.m_condText_Field.setBackground(BMUI.color_critical);
        }
    }

    public int validateSearchPattern() {
        String pattern = this.m_condText_Field.getText().trim();
        PatternValidationDialog pvd = new PatternValidationDialog(Display.getCurrent().getActiveShell(), pattern, this);
        Window.setDefaultImage((Image)BMUI.IMAGE_PRODUCT);
        pvd.setBlockOnOpen(true);
        return pvd.open();
    }

    public void updateCustomAttributes(List<String> customAttributes) {
        this.m_policyTab.setDirty(true);
        this.m_condition.getCustomAttributes().clear();
        this.m_condition.getCustomAttributes().addAll(customAttributes);
        this.setCAButtonText(this.getCAttributesSize());
    }

    public void reload(MsgCondition c, boolean dataChanged) {
        this.m_dataChanged = dataChanged;
        this.setCondition(c);
        this.m_parent.redraw();
    }

    public void modifyText(ModifyEvent e) {
        if (this.m_init) {
            return;
        }
        String fieldName = "";
        String oldValue = "";
        Object obj = e.getSource();
        if (obj instanceof Text) {
            Text field = (Text)e.getSource();
            fieldName = (String)field.getData();
            String value = field.getText().trim();
            if (fieldName.equals(COND_DESCRIPTION)) {
                oldValue = this.m_condition.getDescription();
                this.m_condition.setDescription(value);
                this.m_conditionList.initList();
                this.m_conditionList.updateTable();
            } else if (fieldName.equals(COND_ADVICE)) {
                oldValue = this.m_condition.getHelptext();
                this.m_condition.setHelptext(value);
            } else if (fieldName.equals(COND_INSTRUCTION)) {
                oldValue = this.m_condition.getInstructionAction();
                this.m_condition.setInstructionAction(value);
            } else if (fieldName.equals(COND_OBJKEY)) {
                oldValue = this.m_condition.getKey();
                this.m_condition.setKey(value);
            } else if (fieldName.equals(COND_CLOSE_MASK)) {
                oldValue = this.m_condition.getCloseMask();
                this.m_condition.setCloseMask(value);
            } else if (fieldName.equals(COND_INDICATION_GRP)) {
                oldValue = this.m_condition.getGroupFilter();
                this.m_condition.setGroupFilter(value);
            } else if (fieldName.equals(COND_APPLICATION)) {
                oldValue = this.m_condition.getApplicationFilter();
                this.m_condition.setApplicationFilter(value);
            } else if (fieldName.equals(COND_HOST)) {
                oldValue = this.m_condition.getNodeFilter();
                this.m_condition.setNodeFilter(value);
            } else if (fieldName.equals(COND_OBJECT)) {
                oldValue = this.m_condition.getObjectFilter();
                this.m_condition.setObjectFilter(value);
            } else if (fieldName.equals(COND_TEXT)) {
                oldValue = this.m_condition.getTextFilter();
                this.m_condition.setTextFilter(value);
                this.validateSearchText(value);
                this.refreshProposals();
            } else if (fieldName.equals(COND_SET_APPLICATION)) {
                oldValue = this.m_condition.getSetApplication();
                if (value == null || value.equals("")) {
                    this.m_condition.setSetApplication("");
                    field.setForeground(BMUI.color_darkGrey2);
                    oldValue = null;
                } else {
                    this.m_condition.setSetApplication(value);
                    field.setForeground(BMUI.color_black);
                }
            } else if (fieldName.equals(COND_SET_INDICATION_GRP)) {
                oldValue = this.m_condition.getSetGroup();
                if (value == null || value.equals("")) {
                    this.m_condition.setSetGroup("");
                    field.setForeground(BMUI.color_darkGrey2);
                    oldValue = null;
                } else {
                    this.m_condition.setSetGroup(value);
                    field.setForeground(BMUI.color_black);
                }
            } else if (fieldName.equals(COND_SET_TEXT)) {
                oldValue = this.m_condition.getSetText();
                this.m_condition.setSetText(value);
            } else if (fieldName.equals(COND_SET_OBJECT)) {
                oldValue = this.m_condition.getSetObject();
                this.m_condition.setSetObject(value);
            } else if (fieldName.equals(COND_SET_HOST)) {
                oldValue = this.m_condition.getSetNode();
                this.m_condition.setSetNode(value);
            } else if (fieldName.equals(COND_SILENCE_TIME)) {
                value = value.trim();
                oldValue = this.m_condition.getSuppressInterval() / 60 + "m";
                this.validateSilenceTime();
            } else if (fieldName.equals(COND_SILENCE_COUNT)) {
                value = value.trim();
                oldValue = "" + this.m_condition.getSuppressCount();
                this.validateSilenceCount();
            } else if (fieldName.equals(COND_AUTOACTION)) {
                oldValue = this.m_condition.getAutoAction();
                this.m_condition.setAutoAction(value);
            } else if (fieldName.equals(COND_AUTOACTION_TIMEOUT)) {
                value = value.trim();
                oldValue = "" + this.m_condition.getAutoActionTimeout();
                this.validateTimeout();
            } else if (fieldName.equals(MonitorPolicyTab.COND_AA_START_ONDUPLICATE)) {
                value = value.trim();
                oldValue = "" + this.m_condition.getAutoActionOnDuplicate();
                this.validateStartOnDup();
            } else if (fieldName.equals(COND_OPACTION)) {
                oldValue = this.m_condition.getOpAction();
                this.m_condition.setOpAction(value);
            }
            if (!this.m_init && !(oldValue == null ? "" : oldValue).replaceAll("\r*\n", "").equals((value == null ? "" : value).replaceAll("\r*\n", ""))) {
                this.m_policyTab.setDirty(true);
            }
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        Object obj = e.getSource();
        boolean origDirtyStatus = this.m_policyTab.isDirty();
        if (obj instanceof Button) {
            Button b = (Button)e.getSource();
            String buttonName = (String)b.getData();
            if (buttonName.equals(BUTTON_VALIDATE)) {
                String oldPattern = this.m_condText_Field.getText().trim();
                this.validateSearchPattern();
                String newPattern = this.m_condText_Field.getText().trim();
                if (!this.m_init) {
                    if (newPattern.equals(oldPattern)) {
                        this.m_policyTab.setDirty(origDirtyStatus);
                    } else {
                        this.m_policyTab.setDirty(true);
                    }
                }
            } else if (buttonName.equals(BUTTON_DISPLAY_CA)) {
                this.m_policyTab.setDirty(origDirtyStatus);
                ArrayList<String> cAttributes = this.m_condition.clone().getCustomAttributes();
                if (this.m_cad == null || this.m_cad.isDisposed()) {
                    this.m_cad = new CustomerAttributesDialog(cAttributes, this.m_policyTab.isReadOnly(), this);
                    this.m_cad.open();
                } else {
                    this.m_cad.shellActivated(new ShellEvent(new Event()));
                }
            } else if (buttonName.equals(SELECT_TYPE_A)) {
                this.m_condition.setTypeA(0);
                if (this.m_chType_a.getSelection()) {
                    this.m_condition.setTypeA(1);
                    this.m_condition.setTypeK(0);
                    this.m_chType_k.setSelection(false);
                } else {
                    this.m_condition.setTypeA(0);
                }
                if (!this.m_init) {
                    this.m_policyTab.setDirty(true);
                }
            } else if (buttonName.equals(SELECT_TYPE_K)) {
                this.m_condition.setTypeK(0);
                if (this.m_chType_k.getSelection()) {
                    this.m_condition.setTypeK(1);
                    this.m_condition.setTypeA(0);
                    this.m_chType_a.setSelection(false);
                } else {
                    this.m_condition.setTypeK(0);
                }
                if (!this.m_init) {
                    this.m_policyTab.setDirty(true);
                }
            } else if (buttonName.equals(SELECT_INSERT_CLOSED)) {
                this.m_condition.setInsertClosed(0);
                if (this.m_chInsertClosed.getSelection()) {
                    this.m_condition.setInsertClosed(1);
                }
                if (!this.m_init) {
                    this.m_conditionList.updateTable();
                    this.m_policyTab.setDirty(true);
                }
            } else if (buttonName.equals(SELECT_DEDUPL)) {
                if (this.m_condition.getCloseMask() != null && this.m_condition.getCloseMask().trim().length() > 0 && this.m_condition.isDedupl()) {
                    e.doit = false;
                    this.m_chDedupl.setSelection(true);
                } else {
                    this.m_condition.setDedupl(this.m_chDedupl.getSelection());
                    if (this.m_condition.isDedupl()) {
                        this.m_chDeduplKeyOnly.setSelection(false);
                        this.m_condition.setDeduplKeyOnly(false);
                    }
                    if (!this.m_init) {
                        this.m_conditionList.updateTable();
                        this.m_policyTab.setDirty(true);
                    }
                }
            } else if (buttonName.equals(SELECT_DEDUPL_KEYONLY)) {
                if (this.m_condition.getCloseMask() != null && this.m_condition.getCloseMask().trim().length() > 0 && this.m_condition.isDeduplKeyOnly()) {
                    e.doit = false;
                    this.m_chDeduplKeyOnly.setSelection(true);
                } else {
                    this.m_condition.setDeduplKeyOnly(this.m_chDeduplKeyOnly.getSelection());
                    if (this.m_condition.isDeduplKeyOnly()) {
                        this.m_chDedupl.setSelection(false);
                        this.m_condition.setDedupl(false);
                    }
                    if (!this.m_init) {
                        this.m_conditionList.updateTable();
                        this.m_policyTab.setDirty(true);
                    }
                }
            } else if (buttonName.equals(SELECT_UNKNOWN) || buttonName.equals(SELECT_NORMAL) || buttonName.equals(SELECT_WARNING) || buttonName.equals(SELECT_MINOR) || buttonName.equals(SELECT_MAJOR) || buttonName.equals(SELECT_CRITICAL)) {
                boolean isAll;
                boolean bl = isAll = this.m_chUn.getSelection() && this.m_chNo.getSelection() && this.m_chWa.getSelection() && this.m_chMi.getSelection() && this.m_chMa.getSelection() && this.m_chCr.getSelection();
                if (isAll) {
                    this.m_condSeverity_Text.setText("");
                    this.m_condition.setSeverityFilter("");
                } else {
                    StringBuffer sb = new StringBuffer();
                    if (this.m_chUn.getSelection()) {
                        if (sb.length() != 0) {
                            sb.append("|");
                        }
                        sb.append("unknown");
                    }
                    if (this.m_chNo.getSelection()) {
                        if (sb.length() != 0) {
                            sb.append("|");
                        }
                        sb.append("normal");
                    }
                    if (this.m_chWa.getSelection()) {
                        if (sb.length() != 0) {
                            sb.append("|");
                        }
                        sb.append("warning");
                    }
                    if (this.m_chMi.getSelection()) {
                        if (sb.length() != 0) {
                            sb.append("|");
                        }
                        sb.append("minor");
                    }
                    if (this.m_chMa.getSelection()) {
                        if (sb.length() != 0) {
                            sb.append("|");
                        }
                        sb.append("major");
                    }
                    if (this.m_chCr.getSelection()) {
                        if (sb.length() != 0) {
                            sb.append("|");
                        }
                        sb.append("critical");
                    }
                    if (sb.indexOf("|") != -1) {
                        sb.insert(0, "<[").append("]>");
                    }
                    this.m_condSeverity_Text.setText(sb.toString());
                    this.m_condition.setSeverityFilter(sb.toString());
                }
                this.m_condSeverity_Text.redraw();
                if (!this.m_init) {
                    this.m_policyTab.setDirty(true);
                }
            } else if (buttonName.equals(BTN_COND_VFILTER_EDIT)) {
                EditCondVFilterAction editAction = new EditCondVFilterAction(origDirtyStatus);
                editAction.run();
            } else if (buttonName.equals(BTN_COND_VFILTER_ADD)) {
                AddCondVFilterAction addAction = new AddCondVFilterAction(origDirtyStatus);
                addAction.run();
            } else if (buttonName.equals(BTN_COND_VFILTER_DEL)) {
                DeleteCondVFilterAction delAction = new DeleteCondVFilterAction(origDirtyStatus);
                delAction.run();
            }
        } else if (obj instanceof CCombo) {
            CCombo combo = (CCombo)e.getSource();
            String comboName = (String)combo.getData();
            if (comboName.equals(COND_NEGATION)) {
                if (combo.getText().toUpperCase().equals("TRUE")) {
                    if (this.m_condition.getExpected() && !this.m_init) {
                        this.m_policyTab.setDirty(true);
                    }
                    this.m_condition.setExpected(false);
                } else if (combo.getText().toUpperCase().equals("FALSE")) {
                    if (!this.m_condition.getExpected() && !this.m_init) {
                        this.m_policyTab.setDirty(true);
                    }
                    this.m_condition.setExpected(true);
                }
            } else if (comboName.equals(COND_AUTOACTION_HOST)) {
                String text = combo.getText().trim();
                String newNode = null;
                newNode = text.indexOf(124) != -1 ? text.substring(text.indexOf(124) + 1) : text;
                if (!this.m_condition.getAutoAction_Node().equals(newNode)) {
                    this.m_condition.setAutoAction_Node(newNode);
                    if (!this.m_init) {
                        this.m_policyTab.setDirty(true);
                    }
                }
            }
        } else if (obj instanceof ImageCombo) {
            ImageCombo iCombo = (ImageCombo)((Object)e.getSource());
            String comboName = (String)iCombo.getData();
            if (comboName.equals(COND_SET_SEVERITY)) {
                String text = iCombo.getText();
                if (this.m_condition.getSetSeverity() == null || !this.m_condition.getSetSeverity().equals(text)) {
                    this.m_condition.setSetSeverity(text);
                    if (!this.m_init) {
                        this.m_policyTab.setDirty(true);
                        this.m_conditionList.updateTable();
                    }
                }
            } else if (comboName.equals(COND_ACTIONTYPE)) {
                String text = iCombo.getText();
                if (!this.m_condition.getActionType().equals(text)) {
                    if (SEND_MATCHED.equals(text)) {
                        this.m_condition.setActionType("SEND");
                        this.m_condition.setExpected(true);
                    } else if (DROP_MATCHED.equals(text)) {
                        this.m_condition.setActionType("STOP");
                        this.m_condition.setExpected(true);
                    } else if (SEND_UNMATCHED.equals(text)) {
                        this.m_condition.setActionType("SEND");
                        this.m_condition.setExpected(false);
                    } else if (DROP_UNMATCHED.equals(text)) {
                        this.m_condition.setActionType("STOP");
                        this.m_condition.setExpected(false);
                    }
                    if (!this.m_init) {
                        this.m_conditionList.updateTable();
                        this.m_policyTab.setDirty(true);
                    }
                }
            }
        }
    }

    public void mouseUp(MouseEvent e) {
        if (e.getSource() instanceof Text) {
            Text field = (Text)e.getSource();
            String name = (String)field.getData();
            if (name.equals(COND_SET_APPLICATION)) {
                if (this.m_condition.getSetApplication() == null || this.m_condition.getSetApplication().equals("")) {
                    this.m_condition.setSetApplication("");
                    if (!this.m_registerMouseClick.contains(COND_SET_APPLICATION)) {
                        this.m_registerMouseClick.add(COND_SET_APPLICATION);
                        field.selectAll();
                    }
                }
            } else if (name.equals(COND_SET_INDICATION_GRP) && (this.m_condition.getSetGroup() == null || this.m_condition.getSetGroup().equals(""))) {
                this.m_condition.setSetGroup("");
                if (!this.m_registerMouseClick.contains(COND_SET_INDICATION_GRP)) {
                    this.m_registerMouseClick.add(COND_SET_INDICATION_GRP);
                    field.selectAll();
                }
            }
        }
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseDown(MouseEvent e) {
    }

    public static void setFieldToGlobalValue(Text field, String value) {
        field.removeModifyListener((ModifyListener)m_filterCondDetails);
        field.setText(value);
        field.addModifyListener((ModifyListener)m_filterCondDetails);
        field.setForeground(BMUI.color_darkGrey2);
    }

    public class AddCondVFilterAction
    extends Action {
        private boolean m_origDirtyStatus;

        public AddCondVFilterAction(boolean origDirtyStatus) {
            super("addcondvfilter");
            this.m_origDirtyStatus = false;
            this.setId("addcondvfilter");
            this.setText("Add");
            this.m_origDirtyStatus = origDirtyStatus;
        }

        public void run() {
            CondVFilterDialog cvfDialog = new CondVFilterDialog(FilterCondDetails.this.m_parent.getShell(), -1, FilterCondDetails.this.m_toVfilter, null, null, this);
            cvfDialog.open();
        }

        public void addCondVFilter(String condVFilter) {
            FilterCondDetails.this.m_condVFilter_tableProvider.addElement(condVFilter);
            int numOfElems = FilterCondDetails.this.m_condVFilter_tv.getTable().getItemCount() - 1;
            FilterCondDetails.this.refreshCondVFilterTable(numOfElems + 1);
            String newVFilter = FilterCondDetails.this.m_condVFilter_tableProvider.getVFilterAsInPolicy();
            if (FilterCondDetails.this.m_condition.getVfilterAsInPolicy() == null || !FilterCondDetails.this.m_condition.getVfilterAsInPolicy().equals(newVFilter)) {
                FilterCondDetails.this.m_condition.setVfilterAsInPolicy(newVFilter);
                if (!FilterCondDetails.this.m_init) {
                    FilterCondDetails.this.m_policyTab.setDirty(true);
                }
            }
        }

        public void resetDirtyStatus() {
            FilterCondDetails.this.m_policyTab.setDirty(this.m_origDirtyStatus);
        }
    }

    public class DeleteCondVFilterAction
    extends Action {
        private boolean m_origDirtyStatus;

        public DeleteCondVFilterAction(boolean origDirtyStatus) {
            super("deletecondvfilter");
            this.m_origDirtyStatus = false;
            this.setId("deletecondvfilter");
            this.setText("Delete");
            this.m_origDirtyStatus = origDirtyStatus;
            ISharedImages sharedImages = Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getWorkbench().getSharedImages();
            this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE"));
            this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE_DISABLED"));
            StructuredSelection ssel = (StructuredSelection)FilterCondDetails.this.m_condVFilter_tv.getSelection();
            if (ssel.isEmpty()) {
                this.setEnabled(false);
            }
        }

        public void run() {
            LinkedList<String> elements = new LinkedList<String>();
            int[] selIndices = FilterCondDetails.this.m_condVFilter_tv.getTable().getSelectionIndices();
            int i = 0;
            while (i < selIndices.length) {
                String elem = FilterCondDetails.this.m_condVFilter_tableProvider.getElement(selIndices[i]);
                if (elem != null) {
                    elements.add(elem);
                }
                ++i;
            }
            ShowMessageDialog md = new ShowMessageDialog(new Shell(Display.getCurrent().getActiveShell()), "   Delete Variables", "Do you want to delete the following Variables/Patterns:", String.valueOf(elements.size()) + " Variables/Patterns to delete!", true, "Delete", elements, "No Variables to delete!");
            md.setBlockOnOpen(true);
            md.open();
            if (md.getReturnCode() == 0) {
                FilterCondDetails.this.m_condVFilter_tableProvider.removeElement();
                FilterCondDetails.this.refreshCondVFilterTable(FilterCondDetails.this.m_condVFilter_tv.getTable().getSelectionIndex());
                String newVFilter = FilterCondDetails.this.m_condVFilter_tableProvider.getVFilterAsInPolicy();
                if (!FilterCondDetails.this.m_condition.getVfilterAsInPolicy().equals(newVFilter)) {
                    FilterCondDetails.this.m_condition.setVfilterAsInPolicy(newVFilter);
                    if (!FilterCondDetails.this.m_init) {
                        FilterCondDetails.this.m_policyTab.setDirty(true);
                    }
                }
            } else {
                FilterCondDetails.this.m_policyTab.setDirty(this.m_origDirtyStatus);
            }
        }
    }

    public class EditCondVFilterAction
    extends Action {
        private StructuredSelection m_ssel;
        private boolean m_origDirtyStatus;
        private int m_selIndex;

        public EditCondVFilterAction(boolean origDirtyStatus) {
            super("editcondvfilter");
            this.m_ssel = null;
            this.m_origDirtyStatus = false;
            this.m_selIndex = 0;
            this.setId("editcondvfilter");
            this.setText("Edit");
            this.m_origDirtyStatus = origDirtyStatus;
            this.m_ssel = (StructuredSelection)FilterCondDetails.this.m_condVFilter_tv.getSelection();
            if (this.m_ssel.isEmpty() || this.m_ssel.size() > 1) {
                this.setEnabled(false);
            }
        }

        public void run() {
            int[] indices = FilterCondDetails.this.m_condVFilter_tv.getTable().getSelectionIndices();
            if (indices.length > 0) {
                this.m_selIndex = indices[0];
                TableItem ti = FilterCondDetails.this.m_condVFilter_tv.getTable().getItem(this.m_selIndex);
                String variable = ti.getText(0);
                String pattern = ti.getText(1);
                CondVFilterDialog cvfDialog = new CondVFilterDialog(FilterCondDetails.this.m_parent.getShell(), this.m_selIndex, FilterCondDetails.this.m_toVfilter, variable, pattern, this);
                cvfDialog.open();
            }
        }

        public void updateTable(int selIndex, String condVFilterOLD, String condVFilterNEW) {
            FilterCondDetails.this.m_condVFilter_tableProvider.updateElement(selIndex, condVFilterOLD, condVFilterNEW);
            this.m_selIndex = FilterCondDetails.this.refreshCondVFilterTable(this.m_selIndex);
            FilterCondDetails.this.m_condVFilter_tv.getTable().setSelection(this.m_selIndex);
            FilterCondDetails.this.m_condVFilter_tv.getTable().select(this.m_selIndex);
            String newVFilter = FilterCondDetails.this.m_condVFilter_tableProvider.getVFilterAsInPolicy();
            if (FilterCondDetails.this.m_condition.getVfilterAsInPolicy() == null || !FilterCondDetails.this.m_condition.getVfilterAsInPolicy().equals(newVFilter)) {
                FilterCondDetails.this.m_condition.setVfilterAsInPolicy(newVFilter);
                if (!FilterCondDetails.this.m_init) {
                    FilterCondDetails.this.m_policyTab.setDirty(true);
                }
            }
        }

        public void resetDirtyStatus() {
            FilterCondDetails.this.m_policyTab.setDirty(this.m_origDirtyStatus);
        }
    }

    public class ValidatePatternAction
    extends Action {
        private String m_type;

        public ValidatePatternAction(String type) {
            super("validatepattern");
            this.m_type = null;
            this.setId("validatepattern");
            this.setText("Validate Pattern");
            this.m_type = type;
            StructuredSelection ssel = (StructuredSelection)FilterCondDetails.this.m_condVFilter_tv.getSelection();
            if (ssel.isEmpty()) {
                this.setEnabled(false);
            }
        }

        public void run() {
            int selIndex = FilterCondDetails.this.m_condVFilter_tv.getTable().getSelectionIndex();
            TableItem ti = FilterCondDetails.this.m_condVFilter_tv.getTable().getItem(selIndex);
            String pattern = ti.getText(1);
            PVDialog pvd = new PVDialog(pattern, this.m_type);
            pvd.open();
        }
    }
}

