/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.gui.utils.GUIDisplayElements;
import com.blixx.boom.gui.views.FilterCondDetails;
import com.blixx.boom.gui.views.FilterPolicyTab;
import com.blixx.shared.MsgCondition;
import com.blixx.shared.MsgConditions;
import com.blixx.shared.MsgPolicy;
import com.blixx.shared.Severity;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.OwnerDrawLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Event;

public class FilterCondList
extends OwnerDrawLabelProvider
implements IStructuredContentProvider {
    public TableViewer m_tableViewer = null;
    public MsgConditions m_conditions = null;
    private MsgPolicy m_policy = null;
    public List<List<Object>> m_condList = new ArrayList<List<Object>>();
    public FilterPolicyTab m_policyTab = null;
    public FilterCondDetails m_conditionDetails = null;
    public static GUIDisplayElements m_guiElements = new GUIDisplayElements();
    public int m_condNo = 0;
    public int m_conds = 0;

    public FilterCondList(TableViewer tv, MsgConditions cs, MsgPolicy p, FilterPolicyTab policyTab) {
        this.m_tableViewer = tv;
        this.m_conditions = cs;
        this.m_policy = p;
        this.m_policyTab = policyTab;
        this.initList();
        this.setOwnerDrawEnabled((ColumnViewer)tv, null, false);
    }

    public void initList() {
        ArrayList<Object> subList = null;
        this.m_condList = new ArrayList<List<Object>>();
        List<MsgCondition> list = this.getCondList();
        int i = 0;
        while (i < list.size()) {
            MsgCondition c = list.get(i);
            subList = new ArrayList<Object>();
            subList.add(i);
            subList.add(c);
            this.m_condList.add(subList);
            ++i;
        }
    }

    public void updateList() {
        this.initList();
        FilterPolicyTab.mapCondPos(this.getCondList());
    }

    public void updateTable() {
        if (this.m_tableViewer.getContentProvider() != null) {
            this.m_tableViewer.setInput((Object)this.getElements(null));
        }
    }

    public void moveOneUp() {
        int ind = this.m_tableViewer.getTable().getSelectionIndex();
        if (ind != 0 && ind > 0) {
            MsgCondition c = this.getCondList().remove(ind);
            this.getCondList().add(ind - 1, c);
            this.updateList();
            this.updateTable();
            this.setTableSelection(ind - 1);
        }
    }

    public void moveOneDown() {
        int count;
        int ind = this.m_tableViewer.getTable().getSelectionIndex();
        if (ind != (count = this.m_condList.size()) - 1 && ind > -1) {
            MsgCondition c = this.getCondList().remove(ind);
            this.getCondList().add(ind + 1, c);
            this.updateList();
            this.updateTable();
            this.setTableSelection(ind + 1);
        }
    }

    public void moveToTop() {
        int ind = this.m_tableViewer.getTable().getSelectionIndex();
        if (ind != 0 && ind > 0) {
            MsgCondition c = this.getCondList().remove(ind);
            this.getCondList().add(0, c);
            this.updateList();
            this.updateTable();
            this.setTableSelection(0);
        }
    }

    public void moveToBottom() {
        int count;
        int ind = this.m_tableViewer.getTable().getSelectionIndex();
        if (ind != (count = this.m_condList.size()) - 1 && ind < count - 1) {
            MsgCondition c = this.getCondList().remove(ind);
            this.getCondList().add(count - 1, c);
            this.updateList();
            this.updateTable();
            this.setTableSelection(count - 1);
        }
    }

    public void addCondition(MsgCondition msgCondition) {
        this.addConditionWithoutRefresh(msgCondition);
        this.refresh();
    }

    public void refresh() {
        this.updateList();
        this.updateTable();
        int count = this.m_policy.getConditions().getConditionList().size();
        this.setTableSelection(count - 1);
        try {
            this.m_conditionDetails.reload((MsgCondition)this.m_policy.getConditions().getConditionList().get(count - 1), true);
        }
        catch (Throwable throwable) {}
    }

    public void addConditionWithoutRefresh(MsgCondition msgCondition) {
        if (msgCondition == null) {
            this.m_policy.getConditions().addNewCondition();
        } else {
            this.m_policy.getConditions().addCondition(msgCondition);
        }
    }

    public void duplicateCondition() {
        int[] sIndices = this.m_tableViewer.getTable().getSelectionIndices();
        int i = 0;
        while (i < sIndices.length) {
            MsgCondition cond = this.getCondList().get(sIndices[i]);
            MsgCondition newCond = cond.clone();
            this.getCondList().add(newCond);
            ++i;
        }
        this.refresh();
    }

    public void deleteCondition() {
        List<MsgCondition> condList = this.getCondList();
        ArrayList<MsgCondition> selection = new ArrayList<MsgCondition>();
        int[] sIndices = this.m_tableViewer.getTable().getSelectionIndices();
        if (sIndices.length == 0) {
            return;
        }
        int i = 0;
        while (i < sIndices.length) {
            selection.add(condList.get(sIndices[i]));
            ++i;
        }
        condList.removeAll(selection);
        int newSelection = sIndices[0];
        if (condList.size() != 0 && condList.size() <= newSelection) {
            --newSelection;
        }
        this.updateList();
        this.updateTable();
        this.setTableSelection(newSelection);
        try {
            this.m_conditionDetails.reload((MsgCondition)this.m_policy.getConditions().getConditionList().get(newSelection), true);
        }
        catch (Throwable throwable) {}
    }

    public void setTableSelection(int index) {
        if (this.m_tableViewer.getTable().getItemCount() == 0) {
            this.addCondition(null);
            return;
        }
        if (index == -1 && this.m_policyTab.m_selectedCond == null && this.m_policyTab.m_selectedCondUUID == null) {
            this.m_tableViewer.getTable().select(0);
            this.m_tableViewer.getTable().setSelection(0);
            if (this.m_policy.getConditions().getConditionList().size() > 0) {
                this.m_policyTab.m_selectedCond = (MsgCondition)this.m_policy.getConditions().getConditionList().get(0);
                this.m_policyTab.m_selectedCondUUID = this.m_policyTab.m_selectedCond.getConditionId();
            }
        } else if (index != -1) {
            this.m_tableViewer.getTable().select(index);
            this.m_tableViewer.getTable().setSelection(index);
            try {
                this.m_policyTab.m_selectedCond = (MsgCondition)this.m_policy.getConditions().getConditionList().get(index);
            }
            catch (Throwable throwable) {}
            this.m_policyTab.m_selectedCondUUID = this.m_policyTab.m_selectedCond.getConditionId();
        } else if (this.m_policyTab.m_selectedCond != null) {
            this.m_policyTab.m_selectedCondUUID = this.m_policyTab.m_selectedCond.getConditionId();
            int pos = this.m_policy.getConditions().getConditionNumber(this.m_policyTab.m_selectedCondUUID);
            if (pos != -1) {
                this.m_tableViewer.getTable().select(pos);
                this.m_tableViewer.getTable().setSelection(pos);
            }
        } else if (this.m_policyTab.m_selectedCondUUID != null) {
            this.m_policyTab.m_selectedCond = (MsgCondition)this.m_policyTab.m_conditionList.m_conditions.getCondition(this.m_policyTab.m_selectedCondUUID);
            int pos = this.m_policy.getConditions().getConditionNumber(this.m_policyTab.m_selectedCondUUID);
            if (pos != -1) {
                this.m_tableViewer.getTable().select(pos);
                this.m_tableViewer.getTable().setSelection(pos);
            }
        }
        this.m_tableViewer.refresh();
    }

    public void setConditionDetails(FilterCondDetails condDetails) {
        this.m_conditionDetails = condDetails;
    }

    public Object[] getElements(Object inputElement) {
        return this.m_condList.toArray();
    }

    public List<MsgCondition> getCondList() {
        return this.m_conditions.getConditionList();
    }

    public int getRowIndex(String condID) {
        int rowIndex = -1;
        List<MsgCondition> condList = this.getCondList();
        int i = 0;
        while (i < condList.size()) {
            MsgCondition cond = condList.get(i);
            if (cond.getConditionId().equals(condID)) {
                rowIndex = i;
                break;
            }
            ++i;
        }
        return rowIndex;
    }

    public void checkButtonStatus() {
        if (this.m_policyTab.isReadOnly() || this.m_tableViewer.getTable() == null || this.m_tableViewer.getTable().isDisposed()) {
            return;
        }
        int count = this.m_condList.size();
        if (count == 0) {
            m_guiElements.enableField(this.m_policyTab.m_up_Button, false);
            m_guiElements.enableField(this.m_policyTab.m_down_Button, false);
            m_guiElements.enableField(this.m_policyTab.m_top_Button, false);
            m_guiElements.enableField(this.m_policyTab.m_bottom_Button, false);
            m_guiElements.enableField(this.m_policyTab.m_copy_Button, false);
            m_guiElements.enableField(this.m_policyTab.m_delete_Button, false);
            m_guiElements.enableField(this.m_policyTab.m_add_Button, true);
        } else if (count == 1) {
            m_guiElements.enableField(this.m_policyTab.m_up_Button, false);
            m_guiElements.enableField(this.m_policyTab.m_down_Button, false);
            m_guiElements.enableField(this.m_policyTab.m_top_Button, false);
            m_guiElements.enableField(this.m_policyTab.m_bottom_Button, false);
            m_guiElements.enableField(this.m_policyTab.m_copy_Button, true);
            m_guiElements.enableField(this.m_policyTab.m_delete_Button, false);
            m_guiElements.enableField(this.m_policyTab.m_add_Button, true);
        } else if (count > 1) {
            int[] sIndices = this.m_tableViewer.getTable().getSelectionIndices();
            if (sIndices.length == 0) {
                m_guiElements.enableField(this.m_policyTab.m_up_Button, false);
                m_guiElements.enableField(this.m_policyTab.m_down_Button, false);
                m_guiElements.enableField(this.m_policyTab.m_top_Button, false);
                m_guiElements.enableField(this.m_policyTab.m_bottom_Button, false);
                m_guiElements.enableField(this.m_policyTab.m_copy_Button, false);
                m_guiElements.enableField(this.m_policyTab.m_delete_Button, false);
                m_guiElements.enableField(this.m_policyTab.m_add_Button, true);
            } else if (sIndices.length > 1) {
                m_guiElements.enableField(this.m_policyTab.m_up_Button, false);
                m_guiElements.enableField(this.m_policyTab.m_down_Button, false);
                m_guiElements.enableField(this.m_policyTab.m_top_Button, false);
                m_guiElements.enableField(this.m_policyTab.m_bottom_Button, false);
                m_guiElements.enableField(this.m_policyTab.m_copy_Button, true);
                m_guiElements.enableField(this.m_policyTab.m_delete_Button, true);
                m_guiElements.enableField(this.m_policyTab.m_add_Button, true);
            } else if (sIndices.length == 1) {
                int selIndex = sIndices[0];
                if (selIndex == 0) {
                    m_guiElements.enableField(this.m_policyTab.m_up_Button, false);
                    m_guiElements.enableField(this.m_policyTab.m_down_Button, true);
                    m_guiElements.enableField(this.m_policyTab.m_top_Button, false);
                    m_guiElements.enableField(this.m_policyTab.m_bottom_Button, true);
                    m_guiElements.enableField(this.m_policyTab.m_copy_Button, true);
                    m_guiElements.enableField(this.m_policyTab.m_delete_Button, true);
                    m_guiElements.enableField(this.m_policyTab.m_add_Button, true);
                } else if (selIndex == count - 1) {
                    m_guiElements.enableField(this.m_policyTab.m_up_Button, true);
                    m_guiElements.enableField(this.m_policyTab.m_down_Button, false);
                    m_guiElements.enableField(this.m_policyTab.m_top_Button, true);
                    m_guiElements.enableField(this.m_policyTab.m_bottom_Button, false);
                    m_guiElements.enableField(this.m_policyTab.m_copy_Button, true);
                    m_guiElements.enableField(this.m_policyTab.m_delete_Button, true);
                    m_guiElements.enableField(this.m_policyTab.m_add_Button, true);
                } else if (selIndex > 0) {
                    m_guiElements.enableField(this.m_policyTab.m_up_Button, true);
                    m_guiElements.enableField(this.m_policyTab.m_down_Button, true);
                    m_guiElements.enableField(this.m_policyTab.m_top_Button, true);
                    m_guiElements.enableField(this.m_policyTab.m_bottom_Button, true);
                    m_guiElements.enableField(this.m_policyTab.m_copy_Button, true);
                    m_guiElements.enableField(this.m_policyTab.m_delete_Button, true);
                    m_guiElements.enableField(this.m_policyTab.m_add_Button, true);
                }
            }
        }
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    protected void measure(Event event, Object element) {
    }

    protected void paint(Event event, Object element) {
    }

    public void update(ViewerCell cell) {
        String cellText = "";
        ArrayList cList = (ArrayList)cell.getElement();
        MsgCondition condition = (MsgCondition)cList.get(1);
        int colIndex = cell.getColumnIndex();
        switch (colIndex) {
            case 0: {
                break;
            }
            case 1: {
                if (condition.getActionType().equalsIgnoreCase("STOP")) {
                    cell.setImage(BMUI.IMAGE_STOP);
                    break;
                }
                if (condition.getInsertClosed() != 0) {
                    cell.setImage(BMUI.IMAGE_INSERT_CLOSED);
                    break;
                }
                cell.setImage(BMUI.IMAGE_TRANSPARENT_12x12);
                break;
            }
            case 2: {
                cellText = condition.getDescription();
                String seqnr = FilterPolicyTab.mapCondPos(null).get(condition.getConditionId()).toString();
                cell.setText("(" + seqnr + ") " + cellText);
                int currRowIndex = this.getRowIndex(condition.getConditionId());
                int selRowIndex = this.m_tableViewer.getTable().getSelectionIndex();
                Color sevColor = BMUI.color_white;
                if (currRowIndex == selRowIndex) {
                    cell.setBackground(BMUI.color_selected);
                    break;
                }
                String sev = condition.getSetSeverity();
                if (sev != null && !sev.equals("") && !sev.equals("<*>")) {
                    sevColor = BMUI.getColor(Severity.getSeverity(condition.getSetSeverity()));
                }
                cell.setBackground(sevColor);
            }
        }
        super.update(cell);
    }
}

