/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.gui.Activator;
import com.blixx.boom.gui.dialogs.MonprogDialog;
import com.blixx.boom.gui.dialogs.NameValidatorPolicyName;
import com.blixx.boom.gui.dialogs.PVDialog;
import com.blixx.boom.gui.dialogs.PolicySchedulerDialog;
import com.blixx.boom.gui.dialogs.ShowMessageBox;
import com.blixx.boom.gui.dialogs.ShowMultilineDialog;
import com.blixx.boom.gui.policies.PolicyManager;
import com.blixx.boom.gui.utils.IntervalHelpListener;
import com.blixx.boom.gui.utils.PatternValidator;
import com.blixx.boom.gui.views.AbstractPolicyTab;
import com.blixx.boom.gui.views.ConditionOverviewManager;
import com.blixx.boom.gui.views.FilterCondDetails;
import com.blixx.boom.gui.views.FilterCondList;
import com.blixx.boom.gui.views.MonitorPolicyTab;
import com.blixx.boom.gui.views.MonprogTableProvider;
import com.blixx.boom.gui.views.PolicyCompareTab;
import com.blixx.boom.gui.views.PolicyView;
import com.blixx.boom.gui.views.actions.AddDefaultContentMenuAction;
import com.blixx.boom.gui.views.dnd.DNDCopyMsgConditionAction;
import com.blixx.boom.gui.views.dnd.DNDPasteMsgConditionsAction;
import com.blixx.boom.gui.views.dnd.DNDShare;
import com.blixx.ctrl.sc.in.ScUpdatePolicy;
import com.blixx.log.RTLogger;
import com.blixx.shared.AbstractCondition;
import com.blixx.shared.Cryptor;
import com.blixx.shared.Interval;
import com.blixx.shared.MsgCondition;
import com.blixx.shared.MsgConditions;
import com.blixx.shared.MsgPolicy;
import com.blixx.shared.PolicyFactory;
import com.blixx.shared.exceptions.ConfigException;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.GroupTreeObjectLast;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.ControlEditor;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.TableCursor;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.forms.widgets.Section;

public class FilterPolicyTab
extends AbstractPolicyTab<MsgPolicy>
implements ModifyListener,
SelectionListener,
DisposeListener {
    private Composite m_parentComp = null;
    private Composite m_sectionTriggerComp = null;
    private Composite m_monprogComp = null;
    private Section m_triggerSection = null;
    private Composite compInDetailsCTab = null;
    private Composite m_overviewTableComp = null;
    private ScrolledComposite m_sc = null;
    private Table m_condListTable = null;
    private TableViewer m_tv_condList = null;
    public FilterCondList m_conditionList = null;
    public FilterCondDetails m_conditionDetails = null;
    public MsgCondition m_selectedCond = null;
    public Button m_editLogfileMon_Button = null;
    public Button m_addLogfileMon_Button = null;
    public Button m_delLogfileMon_Button = null;
    public Text m_application_Field = null;
    public Text m_msgGrp_Field = null;
    public Text m_Desc_Field = null;
    public Text m_policyDescritpion = null;
    private CCombo m_monitorType_Combo = null;
    private Text m_interval_field = null;
    public Button m_compare = null;
    private Text m_call_Field = null;
    public Button m_openMonCall_btn = null;
    public Text m_monName = null;
    public Text m_monPath = null;
    public StyledText m_splitRecords = null;
    public boolean m_isMonprogSectionValid = true;
    private static String APPLICATION = "APPLICATION";
    private static String MSG_GROUP = "MSG_GROUP";
    private static String DESCRIPTION = "description";
    private static String MONITOR_PATH = "monitor_path";
    private static String SPLIT_RECRORDS = "split_records";
    private static String SILENCE_TIME = "silence_time";
    private static String SILENCE_COUNT = "silence_count";
    public static String BUTTON_EDIT_LOGFILEMONITOR = "Edit Logfile Monitor";
    public static String BUTTON_ADD_LOGFILE_TRANSACTION_MONITOR = "Add Logfile Monitor";
    public static String BUTTON_DELETE_LOGFILE_TRANSACTION_MONITOR = "Delete Logfile Monitor";
    public static String BUTTON_OPEN_MONITOR_CALL = "BUTTON_OPEN_MONITOR_CALL";
    public boolean m_isIntervalValid = true;
    private CTabFolder m_condFolder = null;
    private CTabItem m_condDetailsCTab = null;
    private TableCursor m_cursor = null;
    private ControlEditor m_editor = null;
    private Text m_tableCellText = null;
    private CCombo m_tableCellCombo = null;
    private List<String> m_registerMouseClick = new ArrayList<String>();
    private String m_callTypeInCombo = "";
    private Table m_monprogTable = null;
    private TableViewer m_monprog_tv = null;
    private MonprogTableProvider m_monprogManager = null;
    public static final String VIRTUAL_POLICYNAME = "*****";
    public Text m_searchPath_Label = null;
    public static LinkedHashMap<String, Integer> m_map = null;
    public static String[] CALLTYPE_LIST = new String[]{"", MonprogTableProvider.JAVA, MonprogTableProvider.NAGIN, MonprogTableProvider.LOGFILE_MONITOR, MonprogTableProvider.LOGFILE_TRANSACTION_MONITOR, MonprogTableProvider.LOGFILE_TRANSACTION_MONITOR_MULITLINE, MonprogTableProvider.LOGFILE_MONITOR_MPATH, MonprogTableProvider.LOGFILE_TRANSACTION_MONITOR_MPATH, MonprogTableProvider.LOGFILE_TRANSACTION_MONITOR_MULITLINE_MPATH};
    public static int COL_INDEX_SET_APPLICATION = 14;
    public static int COL_INDEX_SET_GROUP = 15;
    public static int COL_INDEX_TEXT = 20;

    public FilterPolicyTab(CTabFolder parent, int style, int index, TreeViewer treeViewer, MsgPolicy mp, String treePath, String selectedCondUUID, boolean _isNew) {
        super(parent, style, index, treeViewer, mp, treePath, selectedCondUUID, _isNew);
        this.internalRestore(selectedCondUUID);
    }

    public FilterPolicyTab(String slaveServer, CTabFolder parent, int style, int index, TreeViewer treeViewer, MsgPolicy mp, String treePath, String selectedCondUUID, boolean _isNew) {
        super(parent, style, index, treeViewer, mp, treePath, selectedCondUUID, _isNew);
        String name = "(" + slaveServer + ") " + this.getPolicy().getName();
        this.setText(name);
        this.setData("SLAVE_SERVER", slaveServer);
        this.processReadOnly();
        this.internalRestore(selectedCondUUID);
    }

    @Override
    public String getPolicyType() {
        return BMUI.type_msg;
    }

    @Override
    public MsgPolicy getPolicy() {
        return (MsgPolicy)this.m_policy;
    }

    @Override
    public void internalRestore(String selectedCondUUID) {
        if (selectedCondUUID != null && this.getPolicy().getConditions().getConditionNumber(selectedCondUUID) >= 0) {
            this.m_selectedCondUUID = selectedCondUUID;
        }
        this.m_compositeInCtab = new Composite((Composite)this.m_policyFolder, 0);
        this.m_compositeInCtab.setLayout((Layout)new GridLayout());
        this.m_sc = new ScrolledComposite(this.m_compositeInCtab, 2816);
        this.m_sc.setAlwaysShowScrollBars(false);
        this.m_sc.setExpandHorizontal(true);
        this.m_sc.setExpandVertical(true);
        this.m_sc.setLayout((Layout)new GridLayout(1, false));
        this.m_sc.setLayoutData((Object)new GridData(4, 4, true, true));
        this.m_parentComp = new Composite((Composite)this.m_sc, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 1;
        gridLayout.marginHeight = 1;
        gridLayout.marginBottom = 5;
        this.m_parentComp.setLayout((Layout)gridLayout);
        this.m_parentComp.setLayoutData((Object)new GridData(4, 4, true, true));
        this.m_up_Button = null;
        this.m_down_Button = null;
        this.m_top_Button = null;
        this.m_bottom_Button = null;
        this.m_copy_Button = null;
        this.m_delete_Button = null;
        this.m_add_Button = null;
        this.createGeneralSection(this.m_parentComp);
        this.createTriggerSection(this.m_parentComp);
        this.createConditionSection(this.m_parentComp);
        this.createLowButtons(this.m_compositeInCtab);
        if (!this.isReadOnly() && (this.isNew() || this.isDirty)) {
            this.setDirty(true);
        }
        this.m_sc.setContent((Control)this.m_parentComp);
        this.m_sc.setMinSize(this.m_parentComp.computeSize(-1, -1, true));
        this.m_sc.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                if (FilterPolicyTab.this.m_sc != null) {
                    ScrollBar sbX;
                    ScrollBar sbY = FilterPolicyTab.this.m_sc.getVerticalBar();
                    if (sbY != null) {
                        sbY.setPageIncrement((int)((double)((FilterPolicyTab)FilterPolicyTab.this).m_sc.getSize().y * 0.8));
                        sbY.setIncrement(20);
                    }
                    if ((sbX = FilterPolicyTab.this.m_sc.getHorizontalBar()) != null) {
                        sbX.setPageIncrement((int)((double)((FilterPolicyTab)FilterPolicyTab.this).m_sc.getSize().x * 0.8));
                        sbX.setIncrement(100);
                    }
                }
            }
        });
        this.setControl((Control)this.m_compositeInCtab);
        try {
            this.validateMonprogValues();
        }
        catch (Exception exception) {}
        this.m_init = false;
        this.m_conditionList.checkButtonStatus();
        if (this.isReadOnly()) {
            this.processReadOnly();
        }
    }

    protected Section createGeneralSection(Composite parent) {
        Section section = BMUI.getFormToolkit(Display.getCurrent()).createSection(parent, 4096);
        Composite sectionClient = BMUI.getFormToolkit(Display.getCurrent()).createComposite((Composite)section, 0);
        GridLayout gl = new GridLayout(2, false);
        gl.marginHeight = 0;
        gl.marginRight = 8;
        gl.marginBottom = 5;
        sectionClient.setLayout((Layout)gl);
        this.createPolicyVersionAndActivateIfPart(sectionClient, this.getPolicyType());
        Composite compLeft = new Composite(sectionClient, 0);
        GridData ll1 = new GridData(1, 128, false, false);
        ll1.widthHint = 500;
        compLeft.setLayoutData((Object)ll1);
        gl = new GridLayout(2, false);
        gl.verticalSpacing = 0;
        gl.marginHeight = 0;
        gl.marginBottom = 5;
        gl.marginTop = 5;
        compLeft.setLayout((Layout)gl);
        this.m_application_Field = this.m_gui.addInputFieldSingle(compLeft, APPLICATION, "Set Application: ", this.getPolicy().getSetApplication(), 1, 1, 1, 1, 100, this);
        this.m_msgGrp_Field = this.m_gui.addInputFieldSingle(compLeft, MSG_GROUP, "Set Group: ", this.getPolicy().getSetGroup(), 1, 1, 1, 1, 100, this);
        Composite compRight = new Composite(sectionClient, 0);
        compRight.setLayoutData((Object)new GridData(4, 128, true, false));
        gl = new GridLayout(2, false);
        gl.verticalSpacing = 0;
        gl.marginHeight = 0;
        gl.marginBottom = 5;
        gl.marginTop = 5;
        compRight.setLayout((Layout)gl);
        this.m_Desc_Field = this.m_gui.addInputFieldMultiLineWrap(compRight, DESCRIPTION, "Description: ", this.getPolicy().getDescription(), 1, 1, 70, 40, 3, 1, this);
        section.setClient((Control)sectionClient);
        section.setLayoutData((Object)new GridData(768));
        return section;
    }

    protected void createTriggerSection(Composite parent) {
        int expanded = 32;
        if (this.getPolicy().getCallType() != null && this.getPolicy().getCallType().length() > 0) {
            expanded = 64;
        }
        this.m_triggerSection = BMUI.getFormToolkit(Display.getCurrent()).createSection(parent, expanded | 2 | 0x200);
        this.m_triggerSection.setText("Nagin Trigger/LogFileMonitor Details");
        this.m_sectionTriggerComp = BMUI.getFormToolkit(Display.getCurrent()).createComposite((Composite)this.m_triggerSection, 64);
        GridLayout gdLayout = new GridLayout(4, false);
        gdLayout.marginHeight = 0;
        gdLayout.marginWidth = 0;
        gdLayout.marginBottom = 5;
        gdLayout.marginTop = 5;
        gdLayout.verticalSpacing = 0;
        this.m_sectionTriggerComp.setLayout((Layout)gdLayout);
        Composite compLeft = new Composite(this.m_sectionTriggerComp, 64);
        gdLayout = new GridLayout(3, false);
        gdLayout.marginHeight = 0;
        gdLayout.marginWidth = 0;
        gdLayout.verticalSpacing = 0;
        gdLayout.marginRight = 10;
        compLeft.setLayout((Layout)gdLayout);
        compLeft.setLayoutData((Object)new GridData(1, 128, false, false, 1, 1));
        String[] callParams = this.getPolicy().getMonprog().split("\n");
        if (callParams.length > 0) {
            this.m_callTypeInCombo = MonprogTableProvider.getCallType4Combo(this.getPolicyType(), this.getPolicy().getCallType(), callParams[0]);
        }
        this.m_monitorType_Combo = this.m_gui.addDropDown(compLeft, MonitorPolicyTab.CALLTYPE, "Monitor Type: ", CALLTYPE_LIST, this.m_callTypeInCombo, "", 2, 1, 1, 1, this);
        this.m_interval_field = this.m_gui.addInputFieldSingle(compLeft, MonitorPolicyTab.INTERVAL, "Interval: ", this.getPolicy().getIntervalStr(), 1, 1, 1, 1, 40, this);
        this.checkInterval(this.m_interval_field);
        Label helpIcon = new Label(compLeft, 0);
        helpIcon.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        helpIcon.setImage(BMUI.IMAGE_HELP);
        helpIcon.addListener(4, (Listener)new IntervalHelpListener());
        new Composite(compLeft, 0);
        Composite m_searchPathComp = new Composite(compLeft, 0);
        GridLayout gl = new GridLayout(1, false);
        gl.marginWidth = 0;
        m_searchPathComp.setLayout((Layout)gl);
        m_searchPathComp.setLayoutData((Object)new GridData(4, 4, false, true, 1, 1));
        this.m_searchPath_Label = this.m_gui.addTextReadOnlyMulitLineNoBorder(m_searchPathComp, null, "", 1, 1, 0, 0, BMUI.font_arial7_bold);
        this.m_searchPath_Label.setForeground(BMUI.color_selected);
        this.m_searchPath_Label.setLayoutData((Object)new GridData(0x1000000, 128, false, false));
        this.m_searchPath_Label.setVisible(false);
        this.createMonprogSection(callParams);
        this.m_triggerSection.setClient((Control)this.m_sectionTriggerComp);
        this.m_triggerSection.setLayoutData((Object)new GridData(768));
    }

    public void createMonprogSection(String[] callParams) {
        if (this.m_monprogComp == null || this.m_monprogComp.isDisposed()) {
            this.m_monprogComp = new Composite(this.m_sectionTriggerComp, 64);
            GridLayout gl = new GridLayout(4, false);
            gl.marginHeight = 0;
            gl.marginWidth = 0;
            gl.verticalSpacing = 0;
            this.m_monprogComp.setLayout((Layout)gl);
            this.m_monprogComp.setLayoutData((Object)new GridData(4, 128, true, false));
        } else {
            Control[] controls = this.m_monprogComp.getChildren();
            int i = 0;
            while (i < controls.length) {
                controls[i].dispose();
                ++i;
            }
        }
        if (this.m_callTypeInCombo.equals(MonprogTableProvider.JAVA)) {
            this.m_monName = this.m_gui.addInputFieldSingle(this.m_monprogComp, MonitorPolicyTab.MONPROG_JAVA_Name, "Monitor Name: ", this.getMonitorName(), 3, 1, 0, 0, 60, this);
            this.m_call_Field = this.m_gui.addInputFieldMultiLineNoWrap(this.m_monprogComp, MonitorPolicyTab.MONPROG_JAVA_CALL, "Monitor Call: ", this.getJAVACall(), 3, 1, 60, 80, 0, 1, this);
            this.addContentMenuToMonitorParameters(this.m_call_Field, true);
            this.m_gui.addTextField(this.m_monprogComp, null, "", 1, 1, 0, 0, null);
            this.m_openMonCall_btn = this.m_gui.addButton(this.m_monprogComp, BUTTON_OPEN_MONITOR_CALL, " >> More ", true, this);
        } else if (this.m_callTypeInCombo.equals(MonprogTableProvider.NAGIN) || this.m_callTypeInCombo.equals("")) {
            this.m_call_Field = this.m_gui.addInputFieldMultiLineNoWrap(this.m_monprogComp, MonitorPolicyTab.MONPROG_CALL, "Monitor Call: ", this.getPolicy().getMonprog(), 3, 1, 60, 80, 0, 1, this);
            this.addContentMenuToMonitorParameters(this.m_call_Field, true);
            this.m_gui.addTextField(this.m_monprogComp, null, "", 1, 1, 0, 0, null);
            this.m_openMonCall_btn = this.m_gui.addButton(this.m_monprogComp, BUTTON_OPEN_MONITOR_CALL, " >> More ", true, this);
        } else if (this.m_callTypeInCombo.endsWith(MonprogTableProvider.LOGFILE_MONITOR)) {
            this.m_gui.addTextField(this.m_monprogComp, "Monitor Name: ", this.getMonitorName(), 3, 1, 1, 1, BMUI.font_arial8_bold);
            this.m_monPath = this.m_gui.addInputFieldSingle(this.m_monprogComp, MONITOR_PATH, "Path/File Mask: ", this.getMonitorPath(), 3, 1, 1, 3, 40, this);
            this.createMonitorTable();
        } else if (this.m_callTypeInCombo.endsWith(MonprogTableProvider.LOGFILE_TRANSACTION_MONITOR)) {
            this.m_gui.addTextField(this.m_monprogComp, "Monitor Name: ", this.getMonitorName(), 3, 1, 1, 1, BMUI.font_arial8_bold);
            this.m_monPath = this.m_gui.addInputFieldSingle(this.m_monprogComp, MONITOR_PATH, "Path/File Mask: ", this.getMonitorPath(), 3, 1, 1, 3, 40, this);
            this.createMonitorTable();
        } else if (this.m_callTypeInCombo.endsWith(MonprogTableProvider.LOGFILE_TRANSACTION_MONITOR_MULITLINE)) {
            this.m_gui.addTextField(this.m_monprogComp, "Monitor Name: ", this.getMonitorName(), 3, 1, 1, 1, BMUI.font_arial8_bold);
            this.m_monPath = this.m_gui.addInputFieldSingle(this.m_monprogComp, MONITOR_PATH, "Path/File Mask: ", this.getMonitorPath(), 3, 1, 1, 3, 40, this);
            this.m_gui.addTextField(this.m_monprogComp, null, "Split Records: ", 1, 1, 0, 0, null);
            this.m_splitRecords = this.m_gui.addStyledText(this.m_monprogComp, null, SPLIT_RECRORDS, this.getSplitRecordsPattern(), 3, 1, 1, 3, this);
            this.m_splitRecords.setToolTipText("Allows to split multi-line log records based on the specified pattern.\nA line of the logfile matched with this pattern will indicate a start of a record");
            AbstractPolicyTab.addContentMenu4PatternField((Widget)this.m_splitRecords, false, Display.getCurrent().getActiveShell());
            this.createMonitorTable();
        }
        this.updateSearchPathLabel();
    }

    public void updateSearchPathLabel() {
        String msg = SEARCH_LOCAL_PATH;
        String tooltip = SEARCH_LOCAL_PATH_TOOLTIP;
        if (this.getPolicy().getMonprog().startsWith("#")) {
            msg = SEARCH_GLOBAL_PATH;
            tooltip = SEARCH_GLOBAL_PATH_TOOLTIP;
        }
        this.m_searchPath_Label.setText(msg);
        this.m_searchPath_Label.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.m_searchPath_Label.setToolTipText(tooltip);
        this.m_searchPath_Label.setVisible(MonprogTableProvider.NAGIN.equals(this.m_callTypeInCombo));
    }

    public void createMonitorTable() {
        TableColumn col1;
        Composite compTable = new Composite(this.m_monprogComp, 0);
        GridLayout gl = new GridLayout(1, false);
        gl.verticalSpacing = 0;
        gl.horizontalSpacing = 0;
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        compTable.setLayout((Layout)gl);
        GridData gd = new GridData(4, 4, true, true, 4, 1);
        gd.heightHint = 105;
        gd.widthHint = 200;
        compTable.setLayoutData((Object)gd);
        this.m_monprogTable = new Table(compTable, 68352);
        this.m_monprogTable.setHeaderVisible(true);
        this.m_monprogTable.setLinesVisible(true);
        gd = new GridData(4, 4, true, true);
        gd.verticalIndent = 5;
        this.m_monprogTable.setLayoutData((Object)gd);
        String[] columnNames = null;
        if (this.m_callTypeInCombo.endsWith(MonprogTableProvider.LOGFILE_MONITOR)) {
            columnNames = new String[]{"Description", "Value"};
            col1 = new TableColumn(this.m_monprogTable, 16384);
            col1.setWidth(200);
            col1.setText(columnNames[0]);
            TableColumn col2 = new TableColumn(this.m_monprogTable, 16384);
            col2.setWidth(200);
            col2.setText(columnNames[1]);
        } else if (this.m_callTypeInCombo.endsWith(MonprogTableProvider.LOGFILE_TRANSACTION_MONITOR) || this.m_callTypeInCombo.endsWith(MonprogTableProvider.LOGFILE_TRANSACTION_MONITOR_MULITLINE)) {
            columnNames = new String[]{"Start Pattern", "Finish Pattern", "Fail Pattern", "Timeout (Sec)"};
            col1 = new TableColumn(this.m_monprogTable, 16384);
            col1.setWidth(180);
            col1.setText(columnNames[0]);
            TableColumn col2 = new TableColumn(this.m_monprogTable, 16384);
            col2.setWidth(180);
            col2.setText(columnNames[1]);
            TableColumn col3 = new TableColumn(this.m_monprogTable, 16384);
            col3.setWidth(180);
            col3.setText(columnNames[2]);
            TableColumn col4 = new TableColumn(this.m_monprogTable, 16384);
            col4.setWidth(80);
            col4.setText(columnNames[3]);
        }
        this.m_gui.maximizeTableColumn(compTable, this.m_monprogTable, this.m_monprogTable.getColumnCount() - 1);
        this.m_monprog_tv = new TableViewer(this.m_monprogTable);
        this.m_monprog_tv.setUseHashlookup(true);
        this.m_monprog_tv.setColumnProperties(columnNames);
        this.m_monprogManager = new MonprogTableProvider(this.m_monprog_tv, this.m_callTypeInCombo, null, this.getPolicy());
        this.m_monprog_tv.setContentProvider((IContentProvider)this.m_monprogManager);
        this.m_monprog_tv.setLabelProvider((IBaseLabelProvider)this.m_monprogManager);
        this.m_monprog_tv.setInput((Object)this.m_monprogManager.getElements(null));
        this.addContentMenuMonprogTable();
        this.m_monprogTable.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (FilterPolicyTab.this.isReadOnly()) {
                    return;
                }
                FilterPolicyTab.this.m_gui.enableField(FilterPolicyTab.this.m_editLogfileMon_Button, true);
                FilterPolicyTab.this.m_gui.enableField(FilterPolicyTab.this.m_delLogfileMon_Button, true);
            }
        });
        this.m_monprogTable.addListener(4, new Listener(){

            public void handleEvent(Event e) {
                if (FilterPolicyTab.this.isReadOnly()) {
                    return;
                }
                if (FilterPolicyTab.this.m_monprogTable.getItem(new Point(e.x, e.y)) == null) {
                    FilterPolicyTab.this.m_monprogTable.deselectAll();
                    FilterPolicyTab.this.m_gui.enableField(FilterPolicyTab.this.m_editLogfileMon_Button, false);
                    FilterPolicyTab.this.m_gui.enableField(FilterPolicyTab.this.m_delLogfileMon_Button, false);
                }
            }
        });
        this.m_monprog_tv.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                EditLogfileMonitorAction editAction = new EditLogfileMonitorAction(FilterPolicyTab.this.isReadOnly());
                editAction.run();
            }
        });
        Composite btn_comp = new Composite(this.m_monprogComp, 64);
        gl = new GridLayout(3, true);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        gl.marginTop = 5;
        gl.verticalSpacing = 0;
        btn_comp.setLayout((Layout)gl);
        btn_comp.setLayoutData((Object)new GridData(4, 128, true, false, 2, 1));
        if (this.m_callTypeInCombo.endsWith(MonprogTableProvider.LOGFILE_MONITOR)) {
            this.m_editLogfileMon_Button = this.m_gui.addButton(btn_comp, BUTTON_EDIT_LOGFILEMONITOR, "  Edit  ", true, 35, 20, 1, this);
            this.m_editLogfileMon_Button.setLayoutData((Object)new GridData(4, 128, false, false, 3, 1));
        } else if (this.m_callTypeInCombo.endsWith(MonprogTableProvider.LOGFILE_TRANSACTION_MONITOR) || this.m_callTypeInCombo.endsWith(MonprogTableProvider.LOGFILE_TRANSACTION_MONITOR_MULITLINE)) {
            this.m_editLogfileMon_Button = this.m_gui.addButton(btn_comp, BUTTON_EDIT_LOGFILEMONITOR, "  Edit  ", false, 35, 20, 1, this);
            this.m_editLogfileMon_Button.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
            this.m_addLogfileMon_Button = this.m_gui.addButton(btn_comp, BUTTON_ADD_LOGFILE_TRANSACTION_MONITOR, "  Add  ", true, 35, 20, 1, this);
            this.m_addLogfileMon_Button.setLayoutData((Object)new GridData(4, 128, false, false));
            this.m_delLogfileMon_Button = this.m_gui.addButton(btn_comp, BUTTON_DELETE_LOGFILE_TRANSACTION_MONITOR, " Delete  ", false, 35, 20, 1, this);
            this.m_delLogfileMon_Button.setLayoutData((Object)new GridData(4, 128, false, false));
        }
    }

    public void addContentMenuMonprogTable() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(false);
        Menu menu = menuMgr.createContextMenu(this.m_monprog_tv.getControl());
        this.m_monprog_tv.getControl().setMenu(menu);
        IWorkbenchPartSite site = PolicyView.getInstance().getSite();
        site.registerContextMenu(menuMgr, (ISelectionProvider)this.m_monprog_tv);
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                try {
                    manager.add((IAction)new EditLogfileMonitorAction(FilterPolicyTab.this.isReadOnly()));
                    if (FilterPolicyTab.this.m_callTypeInCombo.endsWith(MonprogTableProvider.LOGFILE_TRANSACTION_MONITOR) || FilterPolicyTab.this.m_callTypeInCombo.endsWith(MonprogTableProvider.LOGFILE_TRANSACTION_MONITOR_MULITLINE)) {
                        manager.add((IAction)new AddLogfileMonitorAction(FilterPolicyTab.this.isReadOnly()));
                        manager.add((IAction)new DeleteLogfileMonitorAction(FilterPolicyTab.this.isReadOnly()));
                    }
                }
                catch (RuntimeException runtimeException) {}
            }
        });
    }

    public void refreshMonprogSection() {
        this.createMonprogSection(null);
        this.m_triggerSection.setClient((Control)this.m_sectionTriggerComp);
        this.m_sc.setContent((Control)this.m_parentComp);
        this.m_sc.setMinSize(this.m_parentComp.computeSize(-1, -1, true));
    }

    public void refreshMonprogTable() {
        this.m_monprogManager.setConfig(this.m_callTypeInCombo, this.getPolicy());
        this.m_monprog_tv.setInput((Object)this.m_monprogManager.getElements(null));
        this.m_monprog_tv.refresh(true, true);
    }

    public void checkMonprogButtonStatus() {
        if (this.m_monprog_tv.getTable().getItemCount() == 0 || this.m_monprog_tv.getSelection().isEmpty()) {
            this.m_gui.enableField(this.m_editLogfileMon_Button, false);
            this.m_gui.enableField(this.m_delLogfileMon_Button, false);
        } else {
            this.m_gui.enableField(this.m_editLogfileMon_Button, true);
            this.m_gui.enableField(this.m_delLogfileMon_Button, true);
        }
    }

    public void addContentMenuToMonitorParameters(final Text field, final boolean activateEncoding) {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        Menu menu = menuMgr.createContextMenu((Control)field);
        field.setMenu(menu);
        PolicyView.getInstance().getSite().registerContextMenu(menuMgr, null);
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                try {
                    if (activateEncoding) {
                        manager.add((IAction)new Action(){

                            public String getText() {
                                return "Encode";
                            }

                            public void run() {
                                String sel = field.getSelectionText();
                                String enc = Cryptor.encrypt(sel);
                                enc = "<$BOOMMON_ONINIT($$" + enc + ")>";
                                field.cut();
                                field.insert(enc);
                            }
                        });
                    }
                    manager.add((IAction)new Action(){

                        public String getText() {
                            return "Pattern Validation";
                        }

                        public ImageDescriptor getImageDescriptor() {
                            return BMUI.IMAGE_DESCRIPTOR_ACCEPT_GREEN;
                        }

                        public void run() {
                            String sel = field.getText();
                            PVDialog pvd = new PVDialog(sel, PatternValidator.JAVA);
                            pvd.open();
                        }
                    });
                    manager.add((IContributionItem)new Separator());
                    manager.add((IAction)new AddDefaultContentMenuAction(field, 1, true));
                    manager.add((IAction)new AddDefaultContentMenuAction(field, 2, true));
                    manager.add((IAction)new AddDefaultContentMenuAction(field, 3, true));
                    manager.add((IAction)new AddDefaultContentMenuAction(field, 4, true));
                    manager.add((IContributionItem)new Separator());
                    manager.add((IAction)new AddDefaultContentMenuAction(field, 5, true));
                    manager.add((IContributionItem)new Separator());
                }
                catch (RuntimeException e) {
                    RTLogger.print(5, "Error creating context menu", e);
                }
            }
        });
    }

    protected Section createConditionSection(Composite parent) {
        Section section = BMUI.getFormToolkit(Display.getCurrent()).createSection(parent, 576);
        section.setText("Conditions");
        Composite mainComp = BMUI.getFormToolkit(Display.getCurrent()).createComposite((Composite)section, 64);
        GridLayout gdLayout = new GridLayout(2, false);
        gdLayout.horizontalSpacing = 2;
        gdLayout.marginHeight = 0;
        gdLayout.marginWidth = 0;
        mainComp.setLayout((Layout)gdLayout);
        this.m_condFolder = new CTabFolder(mainComp, 768);
        this.m_condFolder.setSimple(true);
        this.m_condFolder.setBorderVisible(true);
        this.m_condFolder.setBackground(BMUI.color_unknown);
        this.m_condFolder.setLayout((Layout)new GridLayout(1, false));
        this.m_condFolder.setLayoutData((Object)new GridData(4, 4, true, true));
        this.m_condFolder.addSelectionListener((SelectionListener)this);
        FilterPolicyTab.mapCondPos(this.getPolicy().getConditions().getConditionList());
        this.createDetailsCTab(this.m_condFolder);
        this.createOverviewCTab(this.m_condFolder);
        this.setCondViewSelection(null);
        section.setClient((Control)mainComp);
        section.setLayoutData((Object)new GridData(768));
        return section;
    }

    public static LinkedHashMap<String, Integer> mapCondPos(List<MsgCondition> condList) {
        if (condList != null) {
            m_map = new LinkedHashMap();
            Iterator<MsgCondition> it = condList.iterator();
            int count = 1;
            while (it.hasNext()) {
                MsgCondition msgCond = it.next();
                m_map.put(msgCond.getConditionId(), count);
                ++count;
            }
        }
        return m_map;
    }

    public void createDetailsCTab(CTabFolder parent) {
        this.m_condDetailsCTab = new CTabItem(parent, 0);
        this.m_condDetailsCTab.setText(DETAILS);
        this.m_condDetailsCTab.setData((Object)DETAILS);
        this.compInDetailsCTab = new Composite((Composite)parent, 0);
        GridLayout gdLayout = new GridLayout(2, false);
        gdLayout.horizontalSpacing = 2;
        gdLayout.marginHeight = 0;
        gdLayout.marginWidth = 0;
        gdLayout.marginRight = 5;
        this.compInDetailsCTab.setLayout((Layout)gdLayout);
        this.compInDetailsCTab.setLayoutData((Object)new GridData(4, 4, false, true, 1, 1));
        this.m_condDetailsCTab.setControl((Control)this.compInDetailsCTab);
        Composite compLeft = new Composite(this.compInDetailsCTab, 0);
        gdLayout = new GridLayout(4, false);
        gdLayout.marginTop = 1;
        gdLayout.marginBottom = 10;
        gdLayout.marginRight = 15;
        compLeft.setLayout((Layout)gdLayout);
        compLeft.setLayoutData((Object)new GridData(1, 4, false, false, 1, 4));
        this.createConditionList(compLeft);
        this.m_top_Button = this.m_gui.addButton(compLeft, BUTTON_TOP, BUTTON_TOP, !this.isReadOnly(), 35, 20, 1, this);
        this.m_top_Button.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        this.m_up_Button = this.m_gui.addButton(compLeft, BUTTON_UP, " Up ", !this.isReadOnly(), 35, 20, 1, this);
        this.m_up_Button.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        this.m_down_Button = this.m_gui.addButton(compLeft, BUTTON_DOWN, " Down ", !this.isReadOnly(), 35, 20, 1, this);
        this.m_down_Button.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        this.m_bottom_Button = this.m_gui.addButton(compLeft, BUTTON_BOTTOM, BUTTON_BOTTOM, !this.isReadOnly(), 35, 20, 1, this);
        this.m_bottom_Button.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        Composite comp = new Composite(compLeft, 0);
        GridLayout gl = new GridLayout(3, true);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        gl.horizontalSpacing = 3;
        comp.setLayout((Layout)gl);
        comp.setLayoutData((Object)new GridData(4, 128, true, false, 3, 1));
        this.m_add_Button = this.m_gui.addButton(comp, BUTTON_ADD, " Add ", !this.isReadOnly(), 53, 20, 1, this);
        this.m_add_Button.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        this.m_copy_Button = this.m_gui.addButton(comp, BUTTON_COPY, "Duplicate", !this.isReadOnly(), 53, 20, 1, this);
        this.m_copy_Button.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        this.m_delete_Button = this.m_gui.addButton(comp, BUTTON_DELETE, " Delete ", !this.isReadOnly(), 53, 20, 1, this);
        this.m_delete_Button.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        this.m_gui.addTextField(compLeft, null, "", 1, 1, 1, 0, null);
        if (this.m_selectedCond == null && this.m_selectedCondUUID == null) {
            try {
                this.m_selectedCond = this.m_conditionList.getCondList().get(0);
                this.m_selectedCondUUID = this.m_selectedCond.getConditionId();
            }
            catch (Throwable throwable) {}
        } else if (this.m_selectedCond != null) {
            this.m_selectedCondUUID = this.m_selectedCond.getConditionId();
        } else if (this.m_selectedCondUUID != null) {
            this.m_selectedCond = (MsgCondition)this.m_conditionList.m_conditions.getCondition(this.m_selectedCondUUID);
        }
        this.m_conditionDetails = new FilterCondDetails(this.getPolicy(), this, this.compInDetailsCTab, this.m_conditionList, this.m_selectedCond);
        this.m_conditionList.setConditionDetails(this.m_conditionDetails);
    }

    public void createOverviewCTab(CTabFolder parent) {
        CTabItem cTab = new CTabItem(parent, 0);
        cTab.setText(OVERVIEW);
        cTab.setData((Object)OVERVIEW);
        this.m_overviewTableComp = new Composite((Composite)parent, 0);
        this.m_overviewTableComp.setLayout((Layout)new GridLayout(1, false));
        this.m_overviewTableComp.setLayoutData((Object)new GridData(4, 4, true, true));
        cTab.setControl((Control)this.m_overviewTableComp);
        this.createOverviewTable();
    }

    public void createOverviewTable() {
        this.m_overviewTable = new Table(this.m_overviewTableComp, 66304);
        this.m_overviewTable.setHeaderVisible(true);
        this.m_overviewTable.setLinesVisible(true);
        String[] columnNames = new String[]{"Type", "Description", "AV", "KPI", "Duplicates", "De-Dup KeyOnly", "Closed", "Indication Key", "Close Mask", "Application", "Group", "Object", "Host", "Severity", "Set Application", "Set Group", "Set Object", "Set Host", "Set Severity", "Search Text", "Text", "Silence Time", "Silence Count", "Auto Action", "AA Host", "AA Timeout", "OP Action", "Negation", "CondType"};
        ArrayList<TableColumn> columns = new ArrayList<TableColumn>();
        TableColumn col = null;
        int i = 0;
        while (i < columnNames.length) {
            col = new TableColumn(this.m_overviewTable, 16384);
            col.setText(columnNames[i]);
            col.pack();
            columns.add(col);
            ++i;
        }
        ((TableColumn)columns.get(0)).setWidth(20);
        ((TableColumn)columns.get(1)).setWidth(150);
        ((TableColumn)columns.get(2)).setWidth(28);
        ((TableColumn)columns.get(3)).setWidth(28);
        ((TableColumn)columns.get(4)).setWidth(28);
        ((TableColumn)columns.get(5)).setWidth(28);
        ((TableColumn)columns.get(6)).setWidth(28);
        ((TableColumn)columns.get(7)).setWidth(100);
        ((TableColumn)columns.get(13)).setWidth(100);
        ((TableColumn)columns.get(17)).setWidth(85);
        ((TableColumn)columns.get(19)).setWidth(100);
        ((TableColumn)columns.get(COL_INDEX_TEXT)).setWidth(150);
        this.m_overview_tv = new TableViewer(this.m_overviewTable);
        this.m_overview_tv.setUseHashlookup(true);
        this.m_overview_tv.setColumnProperties(columnNames);
        this.m_condManager = new ConditionOverviewManager(this.m_overview_tv, this.getPolicy().getConditions(), this);
        this.m_overview_tv.setContentProvider((IContentProvider)this.m_condManager);
        this.m_overview_tv.setLabelProvider((IBaseLabelProvider)this.m_condManager);
        this.m_overview_tv.setInput((Object)this.m_condManager.getElements(null));
        this.setOverviewTableLayoutData();
        this.m_cursor = new TableCursor(this.m_overviewTable, 0);
        if (!this.isReadOnly()) {
            this.m_editor = new ControlEditor((Composite)this.m_cursor);
            this.m_editor.grabHorizontal = true;
            this.m_editor.grabVertical = true;
            this.addListenersToTable();
            this.addListenersToCursor();
        }
    }

    public void setOverviewTableLayoutData() {
        int m = 0;
        try {
            m = this.compInDetailsCTab.getClientArea().height;
        }
        catch (Exception exception) {}
        int min = 150;
        int max = m > 0 ? m : 850;
        int hight = 0;
        try {
            hight = this.m_overviewTable.getHeaderHeight() + this.m_overviewTable.getItemCount() * this.m_overviewTable.getItemHeight();
        }
        catch (Throwable throwable) {}
        int tableHight = min;
        if (hight > min && hight <= max) {
            tableHight = hight;
        } else if (hight > max) {
            tableHight = max;
        }
        GridData gd = new GridData(4, 4, true, false);
        gd.heightHint = tableHight;
        gd.widthHint = 500;
        this.m_overviewTable.setLayoutData((Object)gd);
        this.m_overviewTableComp.layout(true);
    }

    public void setOverviewTableSelection() {
        int selIndex = this.m_conditionList.getRowIndex(this.m_selectedCondUUID);
        this.m_overviewTable.setSelection(selIndex);
    }

    public void reloadOverviewTable() {
        this.m_overview_tv.refresh(true);
        this.setOverviewTableLayoutData();
        this.setOverviewTableSelection();
    }

    public void createConditionList(Composite parent) {
        this.m_condListTable = new Table(parent, 68354);
        this.m_condListTable.setHeaderVisible(false);
        this.m_condListTable.setLinesVisible(false);
        GridData gdData = new GridData(1808);
        gdData.horizontalSpan = 3;
        gdData.verticalSpan = 4;
        gdData.widthHint = 200;
        gdData.heightHint = 140;
        this.m_condListTable.setLayoutData((Object)gdData);
        TableColumn col1 = new TableColumn(this.m_condListTable, 16384);
        col1.setWidth(5);
        TableColumn col2 = new TableColumn(this.m_condListTable, 16384);
        col2.setWidth(20);
        TableColumn col3 = new TableColumn(this.m_condListTable, 16384);
        col3.setWidth(250);
        this.m_tv_condList = new TableViewer(this.m_condListTable);
        this.m_conditionList = new FilterCondList(this.m_tv_condList, this.getPolicy().getConditions(), this.getPolicy(), this);
        this.m_tv_condList.setContentProvider((IContentProvider)this.m_conditionList);
        this.m_tv_condList.setLabelProvider((IBaseLabelProvider)this.m_conditionList);
        this.m_tv_condList.setInput((Object)this.m_conditionList.getElements(null));
        this.m_tv_condList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSource() instanceof TableViewer) {
                    int[] sIndices = ((TableViewer)event.getSource()).getTable().getSelectionIndices();
                    if (sIndices.length == 1) {
                        int sIndex = sIndices[0];
                        boolean wasDirty = FilterPolicyTab.this.isDirty();
                        AbstractCondition cond = null;
                        try {
                            cond = (MsgCondition)FilterPolicyTab.this.getPolicy().getConditions().getConditionList().get(sIndex);
                        }
                        catch (Throwable throwable) {}
                        if (cond != null && !cond.getConditionId().equals(FilterPolicyTab.this.m_selectedCond.getConditionId())) {
                            FilterPolicyTab.this.m_selectedCond = cond;
                            FilterPolicyTab.this.m_selectedCondUUID = FilterPolicyTab.this.m_selectedCond.getConditionId();
                            FilterPolicyTab.this.m_conditionDetails.reload(FilterPolicyTab.this.m_selectedCond, false);
                            if (wasDirty != FilterPolicyTab.this.isDirty) {
                                FilterPolicyTab.this.setDirty(wasDirty);
                            }
                        }
                    } else {
                        int cfr_ignored_0 = sIndices.length;
                    }
                    FilterPolicyTab.this.m_conditionList.checkButtonStatus();
                }
            }
        });
        this.m_condListTable.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                if (e.stateMask == 262144) {
                    if (e.keyCode == 99) {
                        DNDCopyMsgConditionAction copyAction = new DNDCopyMsgConditionAction(DNDShare.DND_COPY_MSG_CONDITION_INTERN, (StructuredViewer)FilterPolicyTab.this.m_tv_condList, false, FilterPolicyTab.this.m_systemClipboard);
                        copyAction.run();
                    } else if (e.keyCode == 118) {
                        DNDPasteMsgConditionsAction pasteAction = new DNDPasteMsgConditionsAction(FilterPolicyTab.this.m_tab, FilterPolicyTab.this.m_conditionList, FilterPolicyTab.this.isReadOnly(), FilterPolicyTab.this.m_systemClipboard);
                        pasteAction.run();
                    }
                } else if (e.stateMask == 0 && e.keyCode == 127) {
                    DeleteConditionAction delAction = new DeleteConditionAction(FilterPolicyTab.this.isReadOnly());
                    delAction.run();
                }
            }
        });
        this.m_condListTable.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                Table table = (Table)e.getSource();
                TableItem item = table.getItem(new Point(e.x, e.y));
                if (item == null) {
                    table.deselectAll();
                }
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        List<MsgCondition> list = this.m_conditionList.getCondList();
        if (list != null && list.size() > 0) {
            MsgConditions conditions = this.getPolicy().getConditions();
            if (this.m_selectedCond != null) {
                this.m_conditionList.setTableSelection(conditions.getConditionNumber(this.m_selectedCondUUID));
            } else if (this.m_selectedCondUUID != null) {
                this.m_selectedCond = (MsgCondition)conditions.getCondition(this.m_selectedCondUUID);
                this.m_conditionList.setTableSelection(conditions.getConditionNumber(this.m_selectedCondUUID));
            } else {
                this.m_conditionList.setTableSelection(0);
            }
        } else {
            this.m_conditionList.setTableSelection(-1);
        }
        this.createContentMenu();
    }

    public void createContentMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(false);
        Menu menu = menuMgr.createContextMenu(this.m_tv_condList.getControl());
        this.m_tv_condList.getControl().setMenu(menu);
        PolicyView.getInstance().getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.m_tv_condList);
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                try {
                    StructuredSelection ssel = (StructuredSelection)FilterPolicyTab.this.m_tv_condList.getSelection();
                    manager.add((IAction)new AddConditionAction(FilterPolicyTab.this.isReadOnly()));
                    manager.add((IContributionItem)new Separator());
                    if (!ssel.isEmpty()) {
                        manager.add((IAction)new DuplicateConditionAction(FilterPolicyTab.this.isReadOnly()));
                        manager.add((IAction)new DNDCopyMsgConditionAction(DNDShare.DND_COPY_MSG_CONDITION_INTERN, (StructuredViewer)FilterPolicyTab.this.m_tv_condList, false, FilterPolicyTab.this.m_systemClipboard));
                    }
                    manager.add((IAction)new DNDPasteMsgConditionsAction(FilterPolicyTab.this.m_tab, FilterPolicyTab.this.m_conditionList, FilterPolicyTab.this.isReadOnly(), FilterPolicyTab.this.m_systemClipboard));
                    manager.add((IContributionItem)new Separator());
                    if (!ssel.isEmpty()) {
                        manager.add((IAction)new DeleteConditionAction(FilterPolicyTab.this.isReadOnly()));
                        manager.add((IContributionItem)new Separator());
                        manager.add((IAction)new MoveConditionAction(MOVE_TOP, FilterPolicyTab.this.m_conditionList, FilterPolicyTab.this.isReadOnly()));
                        manager.add((IAction)new MoveConditionAction(MOVE_UP, FilterPolicyTab.this.m_conditionList, FilterPolicyTab.this.isReadOnly()));
                        manager.add((IAction)new MoveConditionAction(MOVE_DOWN, FilterPolicyTab.this.m_conditionList, FilterPolicyTab.this.isReadOnly()));
                        manager.add((IAction)new MoveConditionAction(MOVE_BOTTOM, FilterPolicyTab.this.m_conditionList, FilterPolicyTab.this.isReadOnly()));
                    }
                }
                catch (RuntimeException runtimeException) {}
            }
        });
    }

    public void setConditionListSelection(String conditionUUID) {
        if (conditionUUID == null || conditionUUID.equals(this.m_selectedCondUUID)) {
            return;
        }
        MsgConditions cs = this.getPolicy().getConditions();
        this.m_conditionList.m_conditionDetails.reload((MsgCondition)cs.getCondition(conditionUUID), false);
        this.m_conditionList.setTableSelection(cs.getConditionNumber(conditionUUID));
    }

    public void setCondViewSelection(String view) {
        if (view == null) {
            view = this.m_selectedCondTab;
        }
        if (view.equals(DETAILS)) {
            this.m_selectedCondTab = DETAILS;
            this.m_condFolder.setSelection(0);
        } else if (view.equals(OVERVIEW)) {
            this.m_selectedCondTab = OVERVIEW;
            this.m_condFolder.setSelection(1);
        }
    }

    public String[] getMonprogValues() {
        String sub = this.getPolicy().getMonprog();
        int count = 0;
        while (sub.endsWith("\n")) {
            sub = sub.substring(0, sub.length() - 1);
            ++count;
        }
        String[] split = this.getPolicy().getMonprog().split("\n");
        String[] monprogNew = new String[split.length + count];
        int i = 0;
        while (i < monprogNew.length) {
            try {
                monprogNew[i] = split[i];
            }
            catch (Exception exception) {
                monprogNew[i] = "";
            }
            ++i;
        }
        return monprogNew;
    }

    public void setPolicyMonProg(String[] params) {
        if (params == null) {
            return;
        }
        String monprog = "";
        int i = 0;
        while (i < params.length) {
            String value = params[i];
            value = MonprogTableProvider.removeLineBreak(value);
            monprog = String.valueOf(monprog) + "\n" + value;
            ++i;
        }
        if (monprog.startsWith("\n")) {
            monprog = monprog.substring(1);
        }
        this.getPolicy().setMonprog(monprog);
    }

    public String getMonitorName() {
        String[] params = this.getMonprogValues();
        String name = "";
        try {
            name = params[0];
            name = MonprogTableProvider.removeLineBreak(name);
        }
        catch (Exception exception) {}
        return name;
    }

    public void setMonitorName(String name) {
        String[] params = this.getMonprogValues();
        if (params.length == 0) {
            params = new String[]{"", ""};
        }
        params[0] = name;
        this.setPolicyMonProg(params);
    }

    public String getJAVACall() {
        String[] params = this.getMonprogValues();
        String call = "";
        int i = 1;
        while (i < params.length) {
            call = String.valueOf(call) + "\n" + params[i];
            ++i;
        }
        if (call.startsWith("\n")) {
            call = call.substring(1);
        }
        return call;
    }

    public void setJAVACall(String call) {
        String name;
        String[] params = this.getMonprogValues();
        if (params.length == 0) {
            params = new String[]{"", ""};
        }
        if ((name = params[0]).endsWith("\r\n")) {
            this.getPolicy().setMonprog(String.valueOf(name) + call);
        } else {
            name = MonprogTableProvider.removeLineBreak2(name);
            name = MonprogTableProvider.removeLineBreak(name);
            this.getPolicy().setMonprog(String.valueOf(name) + "\r\n" + call);
        }
    }

    public String getNewMonitorName() {
        String name = "";
        if (this.m_callTypeInCombo.equals(MonprogTableProvider.LOGFILE_MONITOR)) {
            name = MonprogTableProvider.LOGFILE_MONITOR_NAME;
        } else if (this.m_callTypeInCombo.equals(MonprogTableProvider.LOGFILE_TRANSACTION_MONITOR)) {
            name = MonprogTableProvider.LOGFILE_TRANSACTION_MONITOR_NAME;
        } else if (this.m_callTypeInCombo.equals(MonprogTableProvider.LOGFILE_TRANSACTION_MONITOR_MULITLINE)) {
            name = MonprogTableProvider.LOGFILE_TRANSACTION_MONITOR_MULTILINE_NAME;
        } else if (this.m_callTypeInCombo.equals(MonprogTableProvider.LOGFILE_MONITOR_MPATH)) {
            name = MonprogTableProvider.LOGFILE_MONITOR_NAME_MPATH;
        } else if (this.m_callTypeInCombo.equals(MonprogTableProvider.LOGFILE_TRANSACTION_MONITOR_MPATH)) {
            name = MonprogTableProvider.LOGFILE_TRANSACTION_MONITOR_NAME_MPATH;
        } else if (this.m_callTypeInCombo.equals(MonprogTableProvider.LOGFILE_TRANSACTION_MONITOR_MULITLINE_MPATH)) {
            name = MonprogTableProvider.LOGFILE_TRANSACTION_MONITOR_MULTILINE_NAME_MPATH;
        }
        return name;
    }

    public String getMonitorPath() {
        String[] params = this.getMonprogValues();
        String path = "";
        try {
            path = params[1];
            path = MonprogTableProvider.removeLineBreak(path);
        }
        catch (Exception exception) {}
        return path;
    }

    public void setMonitorPath(String path) {
        String[] params = this.getMonprogValues();
        if (params.length >= 2) {
            params[1] = String.valueOf(path) + "\r";
            this.setPolicyMonProg(params);
        } else {
            String[] newParams = new String[]{"", ""};
            String monName = "";
            try {
                monName = params[0];
            }
            catch (Exception exception) {}
            newParams[0] = monName;
            newParams[1] = String.valueOf(path) + "\r";
            this.setPolicyMonProg(newParams);
        }
    }

    public String getSplitRecordsPattern() {
        String[] params = this.getMonprogValues();
        String path = "";
        try {
            path = params[2];
            path = MonprogTableProvider.removeLineBreak(path);
        }
        catch (Exception exception) {
            path = "";
        }
        return path;
    }

    public void setSplitRecordsPattern(String splitRecords) {
        String[] params = this.getMonprogValues();
        if (params.length >= 3) {
            params[2] = splitRecords;
            this.setPolicyMonProg(params);
        } else {
            String[] newParams = new String[3];
            newParams[0] = MonprogTableProvider.LOGFILE_TRANSACTION_MONITOR_MULTILINE_NAME;
            try {
                newParams[1] = params[1];
            }
            catch (Exception exception) {
                newParams[1] = "";
            }
            try {
                newParams[2] = params[2];
            }
            catch (Exception exception) {
                newParams[2] = "";
            }
            this.setPolicyMonProg(newParams);
        }
    }

    @Override
    protected void processReadOnly() {
        super.processReadOnly();
        this.setEditableFalse((Widget)this.m_policyName_Field);
        this.setEditableFalse((Widget)this.m_policyDescritpion);
        this.setEditableFalse((Widget)this.m_saveWithNewerVersion_check);
        this.setEditableFalse((Widget)this.m_application_Field);
        this.setEditableFalse((Widget)this.m_msgGrp_Field);
        this.setEditableFalse((Widget)this.m_Desc_Field);
        this.setEditableFalse((Widget)this.m_activateIFVarName_Field);
        this.setEditableFalse((Widget)this.m_activateIFPattern_Field);
        this.setEditableFalse((Widget)this.m_monitorType_Combo);
        this.setEditableFalse((Widget)this.m_interval_field);
        this.setEditableFalse((Widget)this.m_call_Field);
        this.setEditableFalse((Widget)this.m_monName);
        this.setEditableFalse((Widget)this.m_monPath);
        this.setEditableFalse((Widget)this.m_splitRecords);
        this.setEditableFalse((Widget)this.m_addLogfileMon_Button);
        this.setEditableFalse((Widget)this.m_editLogfileMon_Button);
        this.setEditableFalse((Widget)this.m_delLogfileMon_Button);
        this.setEditableFalse((Widget)this.m_up_Button);
        this.setEditableFalse((Widget)this.m_down_Button);
        this.setEditableFalse((Widget)this.m_top_Button);
        this.setEditableFalse((Widget)this.m_bottom_Button);
        this.setEditableFalse((Widget)this.m_add_Button);
        this.setEditableFalse((Widget)this.m_copy_Button);
        this.setEditableFalse((Widget)this.m_delete_Button);
        this.setEditableFalse((Widget)this.m_openMonCall_btn);
        if (this.m_conditionDetails != null) {
            this.setEditableFalse((Widget)this.m_conditionDetails.m_condDescription_Field);
            this.setEditableFalse((Widget)this.m_conditionDetails.m_condAdvice_Field);
            this.setEditableFalse((Widget)this.m_conditionDetails.m_condInstruction_Field);
            this.setEditableFalse((Widget)this.m_conditionDetails.m_chType_a);
            this.setEditableFalse((Widget)this.m_conditionDetails.m_chType_k);
            this.setEditableFalse((Widget)this.m_conditionDetails.m_chInsertClosed);
            this.setEditableFalse((Widget)this.m_conditionDetails.m_chDedupl);
            this.setEditableFalse((Widget)this.m_conditionDetails.m_chDeduplKeyOnly);
            this.setEditableFalse((Widget)this.m_conditionDetails.m_condIndicationKey_Field);
            this.setEditableFalse((Widget)this.m_conditionDetails.m_condCloseMask_Field);
            this.setEditableFalse((Widget)this.m_conditionDetails.m_condApplicaton_Field);
            this.setEditableFalse((Widget)this.m_conditionDetails.m_condIndicationGroup_Field);
            this.setEditableFalse((Widget)this.m_conditionDetails.m_condObject_Field);
            this.setEditableFalse((Widget)this.m_conditionDetails.m_condHost_Field);
            this.setEditableFalse((Widget)this.m_conditionDetails.m_condSeverity_Text);
            this.setEditableFalse((Widget)this.m_conditionDetails.m_chUn);
            this.setEditableFalse((Widget)this.m_conditionDetails.m_chNo);
            this.setEditableFalse((Widget)this.m_conditionDetails.m_chWa);
            this.setEditableFalse((Widget)this.m_conditionDetails.m_chMi);
            this.setEditableFalse((Widget)this.m_conditionDetails.m_chMa);
            this.setEditableFalse((Widget)this.m_conditionDetails.m_chCr);
            this.setEditableFalse((Widget)this.m_conditionDetails.m_condSetApplication_Field);
            this.setEditableFalse((Widget)this.m_conditionDetails.m_condSetIndicationGroup_Field);
            this.setEditableFalse((Widget)this.m_conditionDetails.m_condSetObject_Field);
            this.setEditableFalse((Widget)this.m_conditionDetails.m_condSetHost_Field);
            this.setEditableFalse((Widget)this.m_conditionDetails.m_condSetSeverity_Combo);
            this.setEditableFalse((Widget)this.m_conditionDetails.m_condText_Field);
            this.setEditableFalse((Widget)this.m_conditionDetails.m_validate_Button);
            this.setEditableFalse((Widget)this.m_conditionDetails.m_condSetText_Field);
            this.setEditableFalse((Widget)this.m_conditionDetails.m_condSilenceTime_Field);
            this.setEditableFalse((Widget)this.m_conditionDetails.m_condSilenceCount_Field);
            this.setEditableFalse((Widget)this.m_conditionDetails.m_condActionType_Combo);
            this.setEditableFalse((Widget)this.m_conditionDetails.m_condAutoaction_Field);
            this.setEditableFalse((Widget)this.m_conditionDetails.m_condAutoaction_CC);
            this.setEditableFalse((Widget)this.m_conditionDetails.m_condAutoactionTimeOut_Field);
            this.setEditableFalse((Widget)this.m_conditionDetails.m_condAAStartOnDuplicate);
            this.setEditableFalse((Widget)this.m_conditionDetails.m_condOpaction_Field);
        }
    }

    public void validateMonprogValues() {
        boolean isMonprogValid = true;
        int countFalse = 0;
        if (this.m_callTypeInCombo != null && this.m_callTypeInCombo.length() > 0) {
            if (this.m_callTypeInCombo.equals(MonprogTableProvider.JAVA)) {
                if (this.m_monName != null && !this.m_monName.isDisposed()) {
                    if (this.m_monName.getText().trim().equals("")) {
                        this.m_monName.setBackground(BMUI.color_light_red);
                        ++countFalse;
                    } else {
                        this.m_monName.setBackground(BMUI.defaultBackground);
                    }
                }
                if (this.m_call_Field != null && !this.m_call_Field.isDisposed()) {
                    if (this.m_call_Field.getText().trim().equals("")) {
                        this.m_call_Field.setBackground(BMUI.color_light_red);
                        ++countFalse;
                    } else {
                        this.m_call_Field.setBackground(BMUI.defaultBackground);
                    }
                }
            } else if (this.m_callTypeInCombo.equals(MonprogTableProvider.NAGIN)) {
                if (this.m_call_Field != null && !this.m_call_Field.isDisposed()) {
                    if (this.m_call_Field.getText().trim().equals("")) {
                        this.m_call_Field.setBackground(BMUI.color_light_red);
                        ++countFalse;
                    } else {
                        this.m_call_Field.setBackground(BMUI.defaultBackground);
                    }
                }
            } else if (this.m_callTypeInCombo.equals(MonprogTableProvider.LOGFILE_MONITOR) || this.m_callTypeInCombo.equals(MonprogTableProvider.LOGFILE_TRANSACTION_MONITOR) || this.m_callTypeInCombo.equals(MonprogTableProvider.LOGFILE_MONITOR_MPATH) || this.m_callTypeInCombo.equals(MonprogTableProvider.LOGFILE_TRANSACTION_MONITOR_MPATH)) {
                if (this.m_monPath != null && !this.m_monPath.isDisposed()) {
                    if (this.m_monPath.getText().trim().equals("")) {
                        this.m_monPath.setBackground(BMUI.color_light_red);
                        ++countFalse;
                    } else {
                        this.m_monPath.setBackground(BMUI.defaultBackground);
                    }
                }
                if (this.m_monprogManager != null) {
                    isMonprogValid = this.m_monprogManager.isMonprogValid();
                }
            } else if (this.m_callTypeInCombo.equals(MonprogTableProvider.LOGFILE_TRANSACTION_MONITOR_MULITLINE) || this.m_callTypeInCombo.equals(MonprogTableProvider.LOGFILE_TRANSACTION_MONITOR_MULITLINE_MPATH)) {
                if (this.m_monPath != null && !this.m_monPath.isDisposed()) {
                    if (this.m_monPath.getText().trim().equals("")) {
                        this.m_monPath.setBackground(BMUI.color_light_red);
                        ++countFalse;
                    } else {
                        this.m_monPath.setBackground(BMUI.defaultBackground);
                    }
                }
                if (this.m_splitRecords != null && !this.m_splitRecords.isDisposed()) {
                    boolean isSplitRecordsValid = AbstractPolicyTab.validatePattern(this.m_splitRecords);
                    if (this.m_splitRecords.getText().trim().equals("") || !isSplitRecordsValid) {
                        this.m_splitRecords.setBackground(BMUI.color_light_red);
                        ++countFalse;
                    } else {
                        this.m_splitRecords.setBackground(BMUI.defaultBackground);
                    }
                }
                if (this.m_monprogManager != null) {
                    isMonprogValid = this.m_monprogManager.isMonprogValid();
                }
            }
        }
        this.checkInterval(this.m_interval_field);
        boolean isCondDetailsValid = this.m_conditionDetails.validateAll();
        if (!(countFalse <= 0 && this.m_isPolicyNameValid && this.m_isIntervalValid && isMonprogValid && isCondDetailsValid)) {
            this.m_isMonprogSectionValid = false;
            this.m_gui.enableField(this.m_save_Button, false);
        } else {
            this.m_isMonprogSectionValid = true;
            if (this.isDirty) {
                this.m_gui.enableField(this.m_save_Button, true);
            }
        }
    }

    public boolean isMonprogSectionValid() {
        return this.m_isMonprogSectionValid;
    }

    public MsgPolicy save_batch(boolean closeTab) {
        if (this.isReadOnly()) {
            return null;
        }
        if (this.m_policyName_Field != null && !this.m_policyName_Field.isDisposed() && !this.m_isPolicyNameValid) {
            this.m_policyName_Field.setBackground(BMUI.color_critical);
            new ShowMessageBox("Save Indication Policy", "Invalid Policy Name!", 1);
            return null;
        }
        if (this.getPolicy().getCallType() == null || this.getPolicy().getCallType().equals("")) {
            this.getPolicy().setCallType("");
            this.getPolicy().setIntervalStr("");
        } else if (this.getPolicy().getIntervalStr().isEmpty()) {
            this.getPolicy().setIntervalStr("1m");
        }
        this.validateSearchTextBeforeSave();
        if (!this.isDirty()) {
            if (closeTab && !this.m_tab.isDisposed()) {
                this.m_tab.dispose();
            }
            return this.getPolicy();
        }
        if (!this.m_isIntervalValid && !this.getPolicy().getCallType().isEmpty()) {
            int interval = Interval.parseInterval(this.getPolicy().getIntervalStr(), 60).getIntervalSeconds();
            this.getPolicy().setIntervalStr(String.valueOf(interval / 60) + "m");
            if (!closeTab && !this.m_interval_field.isDisposed()) {
                this.m_interval_field.setText(this.getPolicy().getIntervalStr());
            }
        }
        if (!this.checkPolicyVersion(this.getPolicyType())) {
            return null;
        }
        this.setActivateIF();
        this.checkLogFileMonitors();
        return this.getPolicy();
    }

    public void save(boolean closeTab) {
        if (this.isReadOnly()) {
            new ShowMessageBox("Insufficient rights", "Not enough permissions to change this Policy!", 1);
            return;
        }
        if (this.m_policyName_Field != null && !this.m_policyName_Field.isDisposed() && !this.m_isPolicyNameValid) {
            new ShowMessageBox("Save Indication Policy", "Invalid Policy Name!", 1);
            this.m_policyName_Field.setBackground(BMUI.color_critical);
            return;
        }
        if (this.getPolicy().getCallType() == null || this.getPolicy().getCallType().equals("")) {
            this.getPolicy().setCallType("");
            this.getPolicy().setIntervalStr("");
        } else if (this.getPolicy().getIntervalStr().isEmpty()) {
            this.getPolicy().setIntervalStr("1m");
        }
        this.validateSearchTextBeforeSave();
        if (this.isDirty()) {
            if (!this.m_isIntervalValid && !this.getPolicy().getCallType().isEmpty()) {
                int interval = Interval.parseInterval(this.getPolicy().getIntervalStr(), 60).getIntervalSeconds();
                this.getPolicy().setIntervalStr(String.valueOf(interval / 60) + "m");
                if (!closeTab && !this.m_interval_field.isDisposed()) {
                    this.m_interval_field.setText(this.getPolicy().getIntervalStr());
                }
            }
            if (this.checkPolicyVersion(this.getPolicyType())) {
                String fileName = String.valueOf(this.getPolicy().getName()) + BMUI.file_extension_msg;
                String oldPolicyVersion = this.getPolicy().getVersion();
                this.setActivateIF();
                PolicyFactory pf = new PolicyFactory();
                pf.storePolicy(Repository.getUserPoliciesDirectory(), this.getPolicy());
                String filePath = String.valueOf(Repository.getUserPoliciesDirectory()) + fileName;
                ScUpdatePolicy sc = new ScUpdatePolicy(Repository.getInstance(), this.getPolicy().getName(), this.getPolicyType(), filePath, this.m_treePath);
                sc.setData("CLOSE", closeTab);
                sc.setData("OLDVERSION", oldPolicyVersion);
                sc.addCmdPostProcess(this);
                sc.addCmdPostProcess(PolicyManager.getInstance());
                sc.start();
            }
        } else if (closeTab && !this.m_tab.isDisposed()) {
            this.m_tab.dispose();
        }
    }

    public void validateSearchTextBeforeSave() {
        List condList = this.getPolicy().getConditions().getConditionList();
        int i = 0;
        while (i < condList.size()) {
            MsgCondition cond = (MsgCondition)condList.get(i);
            if (cond.getTextFilter() == null || cond.getTextFilter().isEmpty()) {
                cond.setTextFilter("<*>");
            }
            ++i;
        }
    }

    private void checkLogFileMonitors() {
        if (this.m_callTypeInCombo.endsWith(MonprogTableProvider.LOGFILE_MONITOR)) {
            String[] monprog = this.getMonprogValues();
            if (monprog.length != 6) {
                String[] monprogNew = new String[6];
                int i = 0;
                while (i < monprogNew.length) {
                    try {
                        monprogNew[i] = monprog[i];
                    }
                    catch (Exception exception) {
                        monprogNew[i] = "";
                    }
                    ++i;
                }
                this.setPolicyMonProg(monprogNew);
            }
        } else if (this.m_callTypeInCombo.endsWith(MonprogTableProvider.LOGFILE_TRANSACTION_MONITOR) || this.m_callTypeInCombo.endsWith(MonprogTableProvider.LOGFILE_TRANSACTION_MONITOR_MULITLINE)) {
            this.cleanTransactionMonprog();
        }
    }

    public void cleanTransactionMonprog() {
        String[] monprog = this.getMonprogValues();
        int monprogLength = monprog.length;
        int fixElems = 0;
        String monName = "";
        if (this.m_callTypeInCombo.equals(MonprogTableProvider.LOGFILE_TRANSACTION_MONITOR)) {
            fixElems = 2;
            monName = MonprogTableProvider.LOGFILE_TRANSACTION_MONITOR_NAME;
        } else if (this.m_callTypeInCombo.equals(MonprogTableProvider.LOGFILE_TRANSACTION_MONITOR_MULITLINE)) {
            fixElems = 3;
            monName = MonprogTableProvider.LOGFILE_TRANSACTION_MONITOR_MULTILINE_NAME;
        } else if (this.m_callTypeInCombo.equals(MonprogTableProvider.LOGFILE_TRANSACTION_MONITOR_MPATH)) {
            fixElems = 2;
            monName = MonprogTableProvider.LOGFILE_TRANSACTION_MONITOR_NAME_MPATH;
        } else if (this.m_callTypeInCombo.equals(MonprogTableProvider.LOGFILE_TRANSACTION_MONITOR_MULITLINE_MPATH)) {
            fixElems = 3;
            monName = MonprogTableProvider.LOGFILE_TRANSACTION_MONITOR_MULTILINE_NAME_MPATH;
        } else {
            return;
        }
        int max = fixElems + 4;
        if (monprogLength != fixElems) {
            if (monprogLength < fixElems) {
                String[] monprogNew = new String[fixElems];
                monprogNew[0] = monName;
                try {
                    monprogNew[1] = monprog[1];
                }
                catch (Exception exception) {
                    monprogNew[1] = "";
                }
                try {
                    monprogNew[2] = monprog[2];
                }
                catch (Exception exception) {
                    monprogNew[2] = "";
                }
                this.setPolicyMonProg(monprogNew);
                this.refreshMonprogTable();
            } else if (monprogLength < max) {
                int emptyCount = 0;
                int i = fixElems;
                while (i < monprogLength) {
                    if (monprog[i].trim().isEmpty()) {
                        ++emptyCount;
                    }
                    ++i;
                }
                if (monprogLength - fixElems == emptyCount) {
                    String[] monprogNew = new String[fixElems];
                    monprogNew[0] = monName;
                    try {
                        monprogNew[1] = monprog[1];
                    }
                    catch (Exception exception) {
                        monprogNew[1] = "";
                    }
                    try {
                        monprogNew[2] = monprog[2];
                    }
                    catch (Exception exception) {
                        monprogNew[2] = "";
                    }
                    this.setPolicyMonProg(monprogNew);
                    this.refreshMonprogTable();
                }
            } else {
                String[] monprogNew = null;
                int startIndex = -1;
                while ((startIndex = this.detectEmptyLine(monprog, fixElems)) > -1) {
                    monprogNew = new String[monprog.length - 4];
                    int index = 0;
                    int i = 0;
                    while (i < monprog.length) {
                        if (i < startIndex || i >= startIndex + 4) {
                            try {
                                monprogNew[index] = monprog[i];
                            }
                            catch (Exception exception) {}
                            ++index;
                        }
                        ++i;
                    }
                    monprog = monprogNew;
                }
                this.setPolicyMonProg(monprog);
                this.refreshMonprogTable();
            }
        }
    }

    public int detectEmptyLine(String[] monprog, int fixElems) {
        String value = null;
        int i = fixElems;
        while (i < monprog.length) {
            int countEmpty = 0;
            int countElements = 0;
            int startIndex = i;
            int ii = 0;
            while (ii < 4) {
                try {
                    value = monprog[i];
                    if (value.trim().isEmpty()) {
                        ++countEmpty;
                    }
                    ++countElements;
                    ++i;
                }
                catch (Exception exception) {
                    break;
                }
                ++ii;
            }
            if (countElements == countEmpty) {
                return startIndex;
            }
            --i;
            ++i;
        }
        return -1;
    }

    public void modifyText(ModifyEvent e) {
        if (this.isReadOnly()) {
            return;
        }
        String fieldName = "";
        String oldValue = "";
        Object obj = e.getSource();
        if (obj instanceof Text) {
            String value;
            block53: {
                Text field = (Text)obj;
                fieldName = (String)field.getData();
                value = field.getText().trim();
                if (fieldName.equals(POLICYNAME)) {
                    oldValue = this.getPolicy().getName();
                    this.m_tab.setText(value);
                    this.getPolicy().setName(value);
                    NameValidatorPolicyName validation = new NameValidatorPolicyName();
                    String validatorError = validation.isValid(this.m_policyName_Field.getText().trim());
                    boolean bl = this.m_isPolicyNameValid = validatorError == null;
                    if (this.m_isPolicyNameValid) {
                        this.m_policyName_Field.setBackground(BMUI.defaultBackground);
                    } else if (value.equals(this.getPolicyNameUnsubmitted())) {
                        this.m_isPolicyNameValid = true;
                        this.m_policyName_Field.setBackground(BMUI.defaultBackground);
                    } else {
                        this.m_policyName_Field.setBackground(BMUI.color_critical);
                    }
                    this.m_policyName_Field.setToolTipText(validatorError);
                    PolicyManager.getInstance().updateUnsubmitted(this.m_pNameUnsubmitted_orig, value, this.getPolicyType());
                } else if (fieldName.equals(DESCRIPTION)) {
                    oldValue = this.getPolicy().getDescription();
                    this.getPolicy().setDescription(value);
                } else if (fieldName.equals(SILENCE_TIME)) {
                    value = value.trim();
                    oldValue = this.getPolicy().getSuppressTime() / 60 + "m";
                    String silenceInterval = value;
                    if ((silenceInterval = silenceInterval.toLowerCase()).indexOf(109) == -1 && silenceInterval.indexOf(104) == -1 && silenceInterval.indexOf(100) == -1) {
                        silenceInterval = String.valueOf(silenceInterval) + "m";
                    }
                    try {
                        int parsed = Interval.parseInterval(this.getPolicy().getIntervalStr(), 0).getIntervalSeconds();
                        if (parsed >= 0) {
                            this.getPolicy().setSuppressTime(parsed);
                            break block53;
                        }
                        field.setText(oldValue);
                    }
                    catch (ConfigException configException) {
                        field.setText(oldValue);
                    }
                } else if (fieldName.equals(SILENCE_COUNT)) {
                    value = value.trim();
                    oldValue = "" + this.getPolicy().getSuppressCount();
                    try {
                        this.getPolicy().setSuppressCount(Integer.valueOf(value));
                    }
                    catch (Throwable throwable) {
                        if (value.isEmpty()) {
                            field.setText("0");
                            break block53;
                        }
                        field.setText(oldValue);
                    }
                } else if (fieldName.equals(MonitorPolicyTab.INTERVAL)) {
                    value = value.trim();
                    oldValue = this.getPolicy().getIntervalStr();
                    this.getPolicy().setIntervalStr(value);
                } else if (fieldName.equals(MONITOR_PATH)) {
                    oldValue = this.getMonitorPath();
                    this.setMonitorPath(value);
                } else if (fieldName.equals(MonitorPolicyTab.MONPROG_CALL)) {
                    oldValue = this.getPolicy().getMonprog();
                    this.getPolicy().setMonprog(value);
                    this.updateSearchPathLabel();
                } else if (fieldName.equals(MonitorPolicyTab.MONPROG_JAVA_Name)) {
                    oldValue = this.getMonitorName();
                    this.setMonitorName(value);
                } else if (fieldName.equals(MonitorPolicyTab.MONPROG_JAVA_CALL)) {
                    oldValue = this.getJAVACall();
                    this.setJAVACall(value);
                } else if (fieldName.equals("ENABLED_IF_VAR")) {
                    oldValue = this.getPolicy().getEnabledIfVariable();
                    if (value.length() > 0) {
                        this.m_gui.enableField(this.m_activateIFPattern_Field, true);
                        AbstractPolicyTab.validatePattern(this.m_activateIFPattern_Field);
                    } else {
                        this.m_gui.enableField(this.m_activateIFPattern_Field, false);
                    }
                    this.setActivateIF();
                } else if (fieldName.equals(APPLICATION)) {
                    oldValue = this.getPolicy().getSetApplication();
                    this.getPolicy().setSetApplication(value);
                    String sel = (String)this.m_condFolder.getSelection().getData();
                    if (sel.equals(DETAILS)) {
                        this.m_conditionDetails.refreshFields();
                    } else if (sel.equals(OVERVIEW)) {
                        this.reloadOverviewTable();
                    }
                } else if (fieldName.equals(MSG_GROUP)) {
                    oldValue = this.getPolicy().getSetGroup();
                    this.getPolicy().setSetGroup(value);
                    String sel = (String)this.m_condFolder.getSelection().getData();
                    if (sel.equals(DETAILS)) {
                        this.m_conditionDetails.refreshFields();
                    } else if (sel.equals(OVERVIEW)) {
                        this.reloadOverviewTable();
                    }
                }
            }
            if (!(oldValue != null && oldValue.equals(value) || this.m_init)) {
                this.setDirty(true);
            }
        } else if (obj instanceof StyledText) {
            StyledText styledText = (StyledText)obj;
            fieldName = (String)styledText.getData();
            String value = styledText.getText().trim();
            if (fieldName.equals(SPLIT_RECRORDS)) {
                if (AbstractPolicyTab.validatePattern(this.m_splitRecords)) {
                    this.setSplitRecordsPattern(value);
                }
            } else if (fieldName.equals("ENABLED_IF_PATTERN")) {
                try {
                    styledText.setBackground(BMUI.defaultBackground);
                    AbstractPolicyTab.validatePattern(styledText);
                    this.setActivateIF();
                }
                catch (Throwable throwable) {
                    styledText.setBackground(BMUI.color_critical);
                }
            }
            this.setDirty(true);
        }
    }

    public void validatePolicyName(String newName) {
        NameValidatorPolicyName validation = new NameValidatorPolicyName();
        String validatorError = validation.isValid(this.m_policyName_Field.getText().trim());
        boolean bl = this.m_isPolicyNameValid = validatorError == null;
        if (this.m_isPolicyNameValid) {
            this.m_policyName_Field.setBackground(BMUI.defaultBackground);
        } else if (newName.equals(this.getPolicyNameUnsubmitted())) {
            this.m_isPolicyNameValid = true;
            this.m_policyName_Field.setBackground(BMUI.defaultBackground);
        } else {
            this.m_policyName_Field.setBackground(BMUI.color_critical);
        }
        this.m_policyName_Field.setToolTipText(validatorError);
        this.setDirty(true);
    }

    public void checkInterval(Text field) {
        String interval = field.getText().trim();
        boolean isValid = false;
        if (this.getPolicy().getCallType().equals("") && interval.equals("")) {
            field.setBackground(BMUI.defaultBackground);
            this.m_isIntervalValid = true;
            return;
        }
        try {
            int i = Integer.parseInt(interval);
            if (i > 0) {
                interval = String.valueOf(interval) + "m";
                isValid = true;
            }
        }
        catch (NumberFormatException numberFormatException) {}
        if (!isValid) {
            try {
                if (Interval.checkInterval(interval, 60) || Interval.checkInterval(interval, 0) && interval.toLowerCase().startsWith("sec:")) {
                    isValid = true;
                }
            }
            catch (Throwable throwable) {}
        }
        this.m_isIntervalValid = isValid;
        if (isValid) {
            this.getPolicy().setIntervalStr(interval);
            field.setBackground(BMUI.defaultBackground);
        } else {
            field.setBackground(BMUI.color_light_red);
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        Object obj = e.getSource();
        if (obj instanceof Button) {
            Button b = (Button)obj;
            String name = (String)b.getData();
            if (name.equals(BUTTON_SAVE)) {
                this.save(false);
            } else if (name.equalsIgnoreCase(BUTTON_UNDO)) {
                this.setDirty(false);
                PolicyView.reOpenTab(this.getText(), this.getText(), this.getPolicyType(), (String)this.getData(TREE_PATH), this.m_selectedCondTab);
            } else if (name.equals(BUTTON_EDIT_LOGFILEMONITOR)) {
                EditLogfileMonitorAction editAction = new EditLogfileMonitorAction(this.isReadOnly());
                editAction.run();
            } else if (name.equals(BUTTON_ADD_LOGFILE_TRANSACTION_MONITOR)) {
                AddLogfileMonitorAction addAction = new AddLogfileMonitorAction(this.isReadOnly());
                addAction.run();
            } else if (name.equals(BUTTON_DELETE_LOGFILE_TRANSACTION_MONITOR)) {
                DeleteLogfileMonitorAction deleteAction = new DeleteLogfileMonitorAction(this.isReadOnly());
                deleteAction.run();
            } else if (name.equals(BUTTON_UP)) {
                this.setDirty(true);
                MoveConditionAction moveUpAction = new MoveConditionAction(MOVE_UP, this.m_conditionList, this.isReadOnly());
                moveUpAction.run();
            } else if (name.equalsIgnoreCase(BUTTON_DOWN)) {
                this.setDirty(true);
                MoveConditionAction moveDownAction = new MoveConditionAction(MOVE_DOWN, this.m_conditionList, this.isReadOnly());
                moveDownAction.run();
            } else if (name.equals(BUTTON_TOP)) {
                this.setDirty(true);
                MoveConditionAction moveToTopAction = new MoveConditionAction(MOVE_TOP, this.m_conditionList, this.isReadOnly());
                moveToTopAction.run();
            } else if (name.equalsIgnoreCase(BUTTON_BOTTOM)) {
                this.setDirty(true);
                MoveConditionAction moveToBottomAction = new MoveConditionAction(MOVE_BOTTOM, this.m_conditionList, this.isReadOnly());
                moveToBottomAction.run();
            } else if (name.equals(BUTTON_ADD)) {
                this.setDirty(true);
                AddConditionAction addConditionAction = new AddConditionAction(this.isReadOnly());
                addConditionAction.run();
            } else if (name.equals(BUTTON_COPY)) {
                this.setDirty(true);
                DuplicateConditionAction dupConditionAction = new DuplicateConditionAction(this.isReadOnly());
                dupConditionAction.run();
            } else if (name.equals(BUTTON_DELETE)) {
                this.setDirty(true);
                DeleteConditionAction delAction = new DeleteConditionAction(this.isReadOnly());
                delAction.run();
            } else if (name.equals("POLICY_VERSIONS_ACTION")) {
                String dir = Repository.getUserPoliciesDirectory();
                String file = String.valueOf(dir) + this.getPolicy().getName() + BMUI.file_extension_msg;
                File tmpPolicy = new File(String.valueOf(file) + BMUI.file_extension_tmp);
                PolicyFactory pf = new PolicyFactory();
                pf.storePolicy(this.getPolicy(), tmpPolicy);
                String version = this.m_policyVersion_FieldDD.getItem(this.m_policyVersion_FieldDD.getSelectionIndex());
                String ext = null;
                ext = version.equals(NEWER_VERSION_AVAILABLE) ? String.valueOf(this.getPolicyType()) + BMUI.file_extension_xml : String.valueOf(this.getPolicyType()) + BMUI.file_extension_xml + "." + version;
                File fileP = Repository.getInstance().fetchFile(this.getPolicy().getName(), ext);
                if (fileP == null) {
                    new ShowMessageBox("Fetching file Error", "Failed getting policy version from the server: " + this.getPolicy().getName(), 1);
                    return;
                }
                try {
                    MsgPolicy verP = pf.initMsgPolicy(fileP);
                    pf.storePolicy(verP, fileP);
                }
                catch (Throwable throwable) {}
                PolicyCompareTab compare = new PolicyCompareTab(this.getPolicy(), this.m_policyFolder.getShell(), tmpPolicy, fileP, this.getPolicy().getName(), this.getPolicy().getVersion(), version, this.isReadOnly());
                try {
                    compare.open();
                }
                catch (RuntimeException runtimeException) {}
            } else if (name.equals(BUTTON_SCHEDULER)) {
                PolicySchedulerDialog dialog = new PolicySchedulerDialog(Display.getCurrent().getActiveShell(), this.getPolicy(), this.isReadOnly());
                dialog.setBlockOnOpen(true);
                dialog.open();
                if (dialog.getReturnCode() == 0) {
                    this.setDirty(true);
                    this.getPolicy().setDeactivationTimes(dialog.m_deactivation_str);
                }
            } else if (name.equals(BUTTON_OPEN_MONITOR_CALL)) {
                ShowMultilineDialog dialog;
                int value;
                if (this.m_callTypeInCombo.equals(MonprogTableProvider.JAVA)) {
                    ShowMultilineDialog dialog2 = new ShowMultilineDialog(Display.getCurrent().getActiveShell(), "  Monitor Call", null, this.m_call_Field.getText(), BMUI.text_save, BMUI.text_cancel);
                    int value2 = dialog2.open();
                    if (value2 == 0) {
                        this.m_call_Field.setText(dialog2.getResult());
                    }
                } else if ((this.m_callTypeInCombo.equals(MonprogTableProvider.NAGIN) || this.m_callTypeInCombo.equals("")) && (value = (dialog = new ShowMultilineDialog(Display.getCurrent().getActiveShell(), "  Monitor Call", null, this.m_call_Field.getText(), BMUI.text_save, BMUI.text_cancel)).open()) == 0) {
                    this.m_call_Field.setText(dialog.getResult());
                }
            }
            this.m_conditionList.checkButtonStatus();
        } else if (obj instanceof CCombo) {
            CCombo combo = (CCombo)obj;
            String name = (String)combo.getData();
            if (name.equals(MonitorPolicyTab.CALLTYPE)) {
                String text = combo.getText();
                if (this.getPolicy().getCallType() == null) {
                    this.getPolicy().setCallType("");
                    this.m_interval_field.setText("5m");
                }
                if (!text.equals(this.m_callTypeInCombo)) {
                    this.m_callTypeInCombo = text;
                    if (text.endsWith(MonprogTableProvider.LOGFILE_MONITOR) || text.endsWith(MonprogTableProvider.LOGFILE_TRANSACTION_MONITOR) || text.endsWith(MonprogTableProvider.LOGFILE_TRANSACTION_MONITOR_MULITLINE)) {
                        this.getPolicy().setCallType(MonprogTableProvider.JAVA);
                        String monName = this.getNewMonitorName();
                        this.setMonitorName(monName);
                    } else {
                        this.getPolicy().setCallType(text);
                    }
                    this.refreshMonprogSection();
                    if (!this.m_init) {
                        this.setDirty(true);
                        if (this.getPolicy().getCallType().isEmpty()) {
                            this.m_interval_field.setText("");
                        }
                    }
                }
            }
        } else if (obj instanceof CTabFolder) {
            CTabFolder folder = (CTabFolder)obj;
            CTabItem cTabItem = folder.getSelection();
            String name = (String)cTabItem.getData();
            if (name.equals(DETAILS)) {
                this.m_selectedCondTab = DETAILS;
                this.m_conditionDetails.refreshFields();
                if (this.m_condManager.isDirty()) {
                    this.setDirty(true);
                }
                this.resizeScrollable();
            } else if (name.equals(OVERVIEW)) {
                this.m_selectedCondTab = OVERVIEW;
                this.m_condManager.setDirty(false);
                this.reloadOverviewTable();
                this.resizeScrollable();
            }
        }
    }

    public void widgetDisposed(DisposeEvent e) {
        Object obj = e.getSource();
        if (obj instanceof CTabItem) {
            CTabItem tab = (CTabItem)obj;
            String name = (String)tab.getData("POLICY_NAME");
            if (((Boolean)tab.getData(DIRTY_STATUS)).booleanValue()) {
                this.save(true);
            }
            this.m_pView.getTabList().remove(name);
            if (this.isNew()) {
                try {
                    GroupTreeObjectLast removedEl;
                    String path = (String)tab.getData(TREE_PATH);
                    GroupTreeObject root = (GroupTreeObject)this.m_treeViewer.getInput();
                    GroupTreeObject parent = root.searchPath(path, BMUI.type_folder);
                    if (parent != null && (removedEl = (GroupTreeObjectLast)parent.getChild(name, this.getPolicyType())) != null) {
                        parent.removeElement(removedEl);
                    }
                    PolicyManager.getInstance().removeUnsubmitted(this.m_pNameUnsubmitted_orig, this.getPolicyType());
                    Object[] expanded = this.m_treeViewer.getExpandedElements();
                    this.m_treeViewer.refresh();
                    int index = 0;
                    while (index < expanded.length) {
                        this.m_treeViewer.setExpandedState(expanded[index], true);
                        ++index;
                    }
                }
                catch (Throwable throwable) {}
            }
            try {
                this.getControl().dispose();
            }
            catch (Throwable throwable) {}
            try {
                this.dispose();
            }
            catch (Throwable throwable) {}
        }
    }

    public void addListenersToTable() {
        this.m_overviewTable.addMouseListener(new MouseListener(){

            public void mouseDown(MouseEvent e) {
                if (FilterPolicyTab.this.m_cursor == null || FilterPolicyTab.this.m_condManager == null) {
                    return;
                }
                if (e.button == 1) {
                    TableItem item = FilterPolicyTab.this.m_overviewTable.getItem(new Point(5, e.y));
                    if (item == null) {
                        return;
                    }
                    int column = FilterPolicyTab.this.m_cursor.getColumn();
                    if (FilterPolicyTab.this.m_condManager.hasCheckbox(FilterPolicyTab.this.getPolicyType(), column)) {
                        FilterPolicyTab.this.m_condManager.changeTableCheckboxSelection(FilterPolicyTab.this.m_cursor, column, item);
                    }
                }
            }

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
    }

    public void addListenersToCursor() {
        this.m_cursor.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                if (e.button == 1) {
                    if (FilterPolicyTab.this.m_cursor == null || FilterPolicyTab.this.m_condManager == null) {
                        return;
                    }
                    int column = FilterPolicyTab.this.m_cursor.getColumn();
                    TableItem item = FilterPolicyTab.this.m_cursor.getRow();
                    if (item == null) {
                        return;
                    }
                    if (FilterPolicyTab.this.m_condManager.hasCheckbox(FilterPolicyTab.this.getPolicyType(), column)) {
                        FilterPolicyTab.this.m_condManager.changeTableCheckboxSelection(FilterPolicyTab.this.m_cursor, column, item);
                    }
                }
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        this.m_cursor.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (FilterPolicyTab.this.m_cursor == null || FilterPolicyTab.this.m_condManager == null) {
                    return;
                }
                int column = FilterPolicyTab.this.m_cursor.getColumn();
                TableItem cRow = FilterPolicyTab.this.m_cursor.getRow();
                int tRowIndex = FilterPolicyTab.this.m_overviewTable.getSelectionIndex();
                TableItem tRow = FilterPolicyTab.this.m_overviewTable.getItem(tRowIndex);
                if (tRow == null) {
                    return;
                }
                if (column == 0 || FilterPolicyTab.this.m_condManager.hasCheckbox(FilterPolicyTab.this.getPolicyType(), column)) {
                    if (!cRow.equals(tRow)) {
                        FilterPolicyTab.this.m_cursor.setSelection(tRow, column);
                    }
                } else {
                    FilterPolicyTab.this.m_overviewTable.setSelection(new TableItem[]{cRow});
                    FilterPolicyTab.this.m_condManager.makeCellEditable(FilterPolicyTab.this.m_cursor, FilterPolicyTab.this.m_editor, cRow, tRowIndex, column);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.m_cursor.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (FilterPolicyTab.this.m_cursor == null || FilterPolicyTab.this.m_condManager == null) {
                    return;
                }
                TableItem row = FilterPolicyTab.this.m_cursor.getRow();
                int currColumn = FilterPolicyTab.this.m_cursor.getColumn();
                if (e.detail == 16) {
                    boolean moved = FilterPolicyTab.this.m_condManager.moveToNextCell(FilterPolicyTab.this.m_cursor, FilterPolicyTab.this.m_editor, currColumn);
                    if (moved) {
                        e.doit = false;
                    }
                } else if (e.detail == 8) {
                    boolean moved = FilterPolicyTab.this.m_condManager.moveToPreviousCell(FilterPolicyTab.this.m_cursor, FilterPolicyTab.this.m_editor, currColumn);
                    if (moved) {
                        e.doit = false;
                    }
                } else if (e.character == '\r') {
                    if (FilterPolicyTab.this.m_condManager.hasCheckbox(FilterPolicyTab.this.getPolicyType(), currColumn)) {
                        FilterPolicyTab.this.m_condManager.changeTableCheckboxSelection(FilterPolicyTab.this.m_cursor, currColumn, row);
                    }
                } else if (!(e.keyCode != 0x1000002 && e.keyCode != 0x1000001 || currColumn != 0 && !FilterPolicyTab.this.m_condManager.hasCheckbox(FilterPolicyTab.this.getPolicyType(), currColumn))) {
                    int nextRowIndex = -1;
                    if (e.keyCode == 0x1000002) {
                        nextRowIndex = FilterPolicyTab.this.m_condManager.getNextRow();
                    } else if (e.keyCode == 0x1000001) {
                        nextRowIndex = FilterPolicyTab.this.m_condManager.getPreviousRow();
                    }
                    if (nextRowIndex != -1) {
                        FilterPolicyTab.this.m_condManager.moveToCell(FilterPolicyTab.this.m_cursor, nextRowIndex, currColumn);
                        e.doit = false;
                    }
                }
            }
        });
        this.m_cursor.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                if (FilterPolicyTab.this.m_cursor == null) {
                    return;
                }
                int colIndex = FilterPolicyTab.this.m_cursor.getColumn();
                TableItem row = FilterPolicyTab.this.m_cursor.getRow();
                if (colIndex == COL_INDEX_TEXT && e.stateMask == 262144) {
                    if (e.keyCode == 99) {
                        DNDCopyTextAction copyAction = new DNDCopyTextAction(row.getText(colIndex), FilterPolicyTab.this.isReadOnly());
                        copyAction.run();
                    } else if (e.keyCode == 118) {
                        row.setText("");
                        DNDPasteTextAction pasteAction = new DNDPasteTextAction(row, colIndex, FilterPolicyTab.this.isReadOnly());
                        pasteAction.run();
                    }
                }
            }
        });
    }

    public void addListenersToCellCombo() {
        this.m_tableCellCombo.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                if (FilterPolicyTab.this.m_tableCellCombo == null || FilterPolicyTab.this.m_tableCellCombo.isDisposed() || FilterPolicyTab.this.m_cursor == null || FilterPolicyTab.this.m_condManager == null) {
                    return;
                }
                int column = FilterPolicyTab.this.m_cursor.getColumn();
                TableItem row = FilterPolicyTab.this.m_cursor.getRow();
                MsgCondition condition = (MsgCondition)row.getData();
                boolean modified = FilterPolicyTab.this.m_condManager.updateCondition(condition, column, FilterPolicyTab.this.m_tableCellCombo.getText(), FilterPolicyTab.this.m_tableCellCombo, row);
                if (modified) {
                    row.setText(column, FilterPolicyTab.this.m_tableCellCombo.getText());
                    FilterPolicyTab.this.m_condManager.setDirty(true);
                    FilterPolicyTab.this.setDirty(true);
                }
                FilterPolicyTab.this.m_tableCellCombo.dispose();
            }
        });
        this.m_tableCellCombo.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (FilterPolicyTab.this.m_tableCellCombo == null || FilterPolicyTab.this.m_tableCellCombo.isDisposed() || FilterPolicyTab.this.m_cursor == null || FilterPolicyTab.this.m_condManager == null) {
                    return;
                }
                int column = FilterPolicyTab.this.m_cursor.getColumn();
                TableItem row = FilterPolicyTab.this.m_cursor.getRow();
                MsgCondition condition = (MsgCondition)row.getData();
                String newValue = FilterPolicyTab.this.m_tableCellCombo.getText();
                if (e.detail == 16) {
                    boolean modified = FilterPolicyTab.this.m_condManager.updateCondition(condition, column, newValue, FilterPolicyTab.this.m_tableCellCombo, row);
                    if (modified) {
                        row.setText(column, FilterPolicyTab.this.m_tableCellCombo.getText());
                        FilterPolicyTab.this.m_condManager.setDirty(true);
                        FilterPolicyTab.this.setDirty(true);
                    }
                    FilterPolicyTab.this.m_tableCellCombo.dispose();
                    boolean moved = FilterPolicyTab.this.m_condManager.moveToNextCell(FilterPolicyTab.this.m_cursor, FilterPolicyTab.this.m_editor, column);
                    if (moved) {
                        e.doit = false;
                    }
                    FilterPolicyTab.this.m_tableCellCombo.dispose();
                } else if (e.detail == 8) {
                    boolean modified = FilterPolicyTab.this.m_condManager.updateCondition(condition, column, newValue, FilterPolicyTab.this.m_tableCellCombo, row);
                    if (modified) {
                        row.setText(column, FilterPolicyTab.this.m_tableCellCombo.getText());
                        FilterPolicyTab.this.m_condManager.setDirty(true);
                        FilterPolicyTab.this.setDirty(true);
                    }
                    FilterPolicyTab.this.m_tableCellCombo.dispose();
                    boolean moved = FilterPolicyTab.this.m_condManager.moveToPreviousCell(FilterPolicyTab.this.m_cursor, FilterPolicyTab.this.m_editor, column);
                    if (moved) {
                        e.doit = false;
                    }
                    FilterPolicyTab.this.m_tableCellCombo.dispose();
                } else if (e.character == '\r' || e.keyCode == 0x1000002 || e.keyCode == 0x1000001) {
                    int nextRowIndex = -1;
                    if (e.keyCode == 0x1000002 || e.character == '\r') {
                        nextRowIndex = FilterPolicyTab.this.m_condManager.getNextRow();
                    } else if (e.keyCode == 0x1000001) {
                        nextRowIndex = FilterPolicyTab.this.m_condManager.getPreviousRow();
                    }
                    if (nextRowIndex != -1) {
                        boolean modified = FilterPolicyTab.this.m_condManager.updateCondition(condition, column, newValue, FilterPolicyTab.this.m_tableCellCombo, row);
                        if (modified) {
                            row.setText(column, FilterPolicyTab.this.m_tableCellCombo.getText());
                            FilterPolicyTab.this.m_condManager.setDirty(true);
                            FilterPolicyTab.this.setDirty(true);
                        }
                        FilterPolicyTab.this.m_tableCellCombo.dispose();
                        TableItem nextRow = FilterPolicyTab.this.m_condManager.moveToCell(FilterPolicyTab.this.m_cursor, nextRowIndex, column);
                        FilterPolicyTab.this.m_condManager.makeCellEditable(FilterPolicyTab.this.m_cursor, FilterPolicyTab.this.m_editor, nextRow, nextRowIndex, column);
                    }
                }
            }
        });
    }

    public void addListenersToCellText() {
        this.m_tableCellText.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                if (FilterPolicyTab.this.m_tableCellText == null || FilterPolicyTab.this.m_tableCellText.isDisposed() || FilterPolicyTab.this.m_cursor == null || FilterPolicyTab.this.m_condManager == null) {
                    return;
                }
                int currColumn = FilterPolicyTab.this.m_cursor.getColumn();
                if (currColumn == 0 || FilterPolicyTab.this.m_condManager.hasCheckbox(FilterPolicyTab.this.getPolicyType(), currColumn)) {
                    return;
                }
                TableItem row = FilterPolicyTab.this.m_cursor.getRow();
                MsgCondition condition = (MsgCondition)row.getData();
                String newValue = FilterPolicyTab.this.m_tableCellText.getText().trim();
                if (currColumn == COL_INDEX_SET_APPLICATION) {
                    FilterPolicyTab.this.m_registerMouseClick.remove(currColumn + "_" + condition.getConditionId());
                    if (condition.getSetApplication() == null || condition.getSetApplication().equals("")) {
                        condition.setSetApplication("");
                        row.setText(currColumn, FilterPolicyTab.this.getPolicy().getSetApplication());
                        row.setForeground(currColumn, BMUI.color_darkGrey2);
                    } else {
                        row.setText(currColumn, newValue);
                        row.setForeground(currColumn, BMUI.color_black);
                    }
                } else if (currColumn == COL_INDEX_SET_GROUP) {
                    FilterPolicyTab.this.m_registerMouseClick.remove(currColumn + "_" + condition.getConditionId());
                    if (condition.getSetGroup() == null || condition.getSetGroup().equals("")) {
                        condition.setSetGroup("");
                        row.setText(currColumn, FilterPolicyTab.this.getPolicy().getSetGroup());
                        row.setForeground(currColumn, BMUI.color_darkGrey2);
                    } else {
                        row.setText(currColumn, newValue);
                        row.setForeground(currColumn, BMUI.color_black);
                    }
                } else {
                    row.setText(currColumn, newValue);
                    row.setForeground(currColumn, BMUI.color_black);
                }
                FilterPolicyTab.this.m_tableCellText.dispose();
            }
        });
        this.m_tableCellText.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
                if (FilterPolicyTab.this.m_cursor == null || FilterPolicyTab.this.m_tableCellText == null || FilterPolicyTab.this.m_tableCellText.isDisposed()) {
                    return;
                }
                int column = FilterPolicyTab.this.m_cursor.getColumn();
                if (column == COL_INDEX_SET_APPLICATION) {
                    TableItem row = FilterPolicyTab.this.m_cursor.getRow();
                    MsgCondition condition = (MsgCondition)row.getData();
                    if (condition.getSetApplication() == null || condition.getSetApplication().equals("")) {
                        condition.setSetApplication("");
                        String id = column + "_" + condition.getConditionId();
                        if (!FilterPolicyTab.this.m_registerMouseClick.contains(id)) {
                            FilterPolicyTab.this.m_registerMouseClick.add(id);
                            FilterPolicyTab.this.m_tableCellText.selectAll();
                        }
                    }
                } else if (column == COL_INDEX_SET_GROUP) {
                    TableItem row = FilterPolicyTab.this.m_cursor.getRow();
                    MsgCondition condition = (MsgCondition)row.getData();
                    if (condition.getSetGroup() == null || condition.getSetGroup().equals("")) {
                        condition.setSetGroup("");
                        String id = column + "_" + condition.getConditionId();
                        if (!FilterPolicyTab.this.m_registerMouseClick.contains(id)) {
                            FilterPolicyTab.this.m_registerMouseClick.add(id);
                            FilterPolicyTab.this.m_tableCellText.selectAll();
                        }
                    }
                } else {
                    FilterPolicyTab.this.m_tableCellText.selectAll();
                }
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        this.m_tableCellText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String newValue;
                if (FilterPolicyTab.this.m_tableCellText == null || FilterPolicyTab.this.m_tableCellText.isDisposed() || FilterPolicyTab.this.m_cursor == null || FilterPolicyTab.this.m_condManager == null) {
                    return;
                }
                int column = FilterPolicyTab.this.m_cursor.getColumn();
                if (column == 0 || FilterPolicyTab.this.m_condManager.hasCheckbox(BMUI.type_mon, column)) {
                    return;
                }
                TableItem row = FilterPolicyTab.this.m_cursor.getRow();
                MsgCondition condition = (MsgCondition)row.getData();
                boolean modified = FilterPolicyTab.this.m_condManager.updateCondition(condition, column, newValue = FilterPolicyTab.this.m_tableCellText.getText().trim(), FilterPolicyTab.this.m_tableCellText, row);
                if (modified) {
                    if (column == COL_INDEX_SET_APPLICATION || column == COL_INDEX_SET_GROUP) {
                        FilterPolicyTab.this.m_tableCellText.setForeground(BMUI.color_black);
                    }
                    FilterPolicyTab.this.m_condManager.setDirty(true);
                    FilterPolicyTab.this.setDirty(true);
                }
            }
        });
        this.m_tableCellText.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (FilterPolicyTab.this.m_cursor == null || FilterPolicyTab.this.m_condManager == null) {
                    return;
                }
                int currColumn = FilterPolicyTab.this.m_cursor.getColumn();
                if (e.detail == 16) {
                    FilterPolicyTab.this.leaveCell();
                    boolean moved = FilterPolicyTab.this.m_condManager.moveToNextCell(FilterPolicyTab.this.m_cursor, FilterPolicyTab.this.m_editor, currColumn);
                    if (moved) {
                        e.doit = false;
                    }
                } else if (e.detail == 8) {
                    FilterPolicyTab.this.leaveCell();
                    boolean moved = FilterPolicyTab.this.m_condManager.moveToPreviousCell(FilterPolicyTab.this.m_cursor, FilterPolicyTab.this.m_editor, currColumn);
                    if (moved) {
                        e.doit = false;
                    }
                } else if (e.character == '\r' || e.keyCode == 0x1000002 || e.keyCode == 0x1000001) {
                    int nextRowIndex = -1;
                    if (e.keyCode == 0x1000002 || e.character == '\r') {
                        nextRowIndex = FilterPolicyTab.this.m_condManager.getNextRow();
                    } else if (e.keyCode == 0x1000001) {
                        nextRowIndex = FilterPolicyTab.this.m_condManager.getPreviousRow();
                    }
                    if (nextRowIndex != -1) {
                        FilterPolicyTab.this.leaveCell();
                        TableItem nextRow = FilterPolicyTab.this.m_condManager.moveToCell(FilterPolicyTab.this.m_cursor, nextRowIndex, currColumn);
                        FilterPolicyTab.this.m_condManager.makeCellEditable(FilterPolicyTab.this.m_cursor, FilterPolicyTab.this.m_editor, nextRow, nextRowIndex, currColumn);
                    }
                }
            }
        });
    }

    public void leaveCell() {
        if (this.m_cursor == null || this.m_condManager == null) {
            return;
        }
        int column = this.m_cursor.getColumn();
        if (column == 0 || this.m_condManager.hasCheckbox(BMUI.type_mon, column)) {
            return;
        }
        if (this.m_tableCellText == null || this.m_tableCellText.isDisposed()) {
            return;
        }
        TableItem row = this.m_cursor.getRow();
        MsgCondition condition = (MsgCondition)row.getData();
        String newValue = this.m_tableCellText.getText().trim();
        if (column == COL_INDEX_SET_APPLICATION) {
            this.m_registerMouseClick.remove(column + "_" + condition.getConditionId());
            if (condition.getSetApplication() == null || condition.getSetApplication().equals("")) {
                condition.setSetApplication("");
                row.setText(column, this.getPolicy().getSetApplication());
                row.setForeground(column, BMUI.color_darkGrey2);
            } else {
                row.setText(column, newValue);
                row.setForeground(column, BMUI.color_black);
            }
        } else if (column == COL_INDEX_SET_GROUP) {
            this.m_registerMouseClick.remove(column + "_" + condition.getConditionId());
            if (condition.getSetGroup() == null || condition.getSetGroup().equals("")) {
                condition.setSetGroup("");
                row.setText(column, this.getPolicy().getSetGroup());
                row.setForeground(column, BMUI.color_darkGrey2);
            } else {
                row.setText(column, newValue);
                row.setForeground(column, BMUI.color_black);
            }
        } else {
            row.setText(column, newValue);
        }
        this.m_tableCellText.dispose();
    }

    public int getColumnIndex(Table t, int position) {
        int colIndex = -1;
        int start = 0;
        int end = 0;
        LinkedHashMap<Integer, Integer> m = new LinkedHashMap<Integer, Integer>();
        TableColumn[] colList = t.getColumns();
        int index = 0;
        while (index < t.getColumnCount()) {
            m.put(index, colList[index].getWidth());
            ++index;
        }
        index = 0;
        while (index < m.size()) {
            if (index > 0) {
                start += Integer.valueOf(((Integer)m.get(index - 1)).toString()).intValue();
            }
            end = start + Integer.valueOf(((Integer)m.get(index)).toString());
            if (position >= start && position <= end) {
                colIndex = index;
                break;
            }
            ++index;
        }
        return colIndex;
    }

    public void setEditableCell(Object newEditableTableCell) {
        if (newEditableTableCell instanceof CCombo) {
            this.m_tableCellCombo = (CCombo)newEditableTableCell;
        } else {
            this.m_tableCellText = (Text)newEditableTableCell;
        }
    }

    @Override
    public void setDirty(boolean b) {
        if (this.isReadOnly()) {
            return;
        }
        super.setDirty(b);
        try {
            this.validateMonprogValues();
        }
        catch (Exception exception) {}
    }

    public void resizeScrollable() {
        this.m_sc.setMinSize(this.m_parentComp.computeSize(-1, -1, true));
    }

    public class AddConditionAction
    extends Action {
        public AddConditionAction(boolean isReadOnly) {
            super("addcondition");
            this.setId("addcondition");
            this.setText("New Condition");
            if (isReadOnly) {
                this.setEnabled(false);
            }
        }

        public void run() {
            if (!this.isEnabled()) {
                return;
            }
            FilterPolicyTab.this.m_conditionList.addCondition(null);
            FilterPolicyTab.this.setDirty(true);
        }
    }

    public class AddLogfileMonitorAction
    extends Action {
        public AddLogfileMonitorAction(boolean isReadOnly) {
            super("addlogfilemonitor");
            this.setId("addlogfilemonitor");
            this.setText("Add");
            if (isReadOnly) {
                this.setEnabled(false);
                return;
            }
        }

        public void run() {
            if (!this.isEnabled()) {
                return;
            }
            MonprogDialog dialog = new MonprogDialog(Display.getCurrent().getActiveShell(), FilterPolicyTab.this.m_callTypeInCombo, FilterPolicyTab.this.getMonprogValues(), -1, true, FilterPolicyTab.this.isReadOnly());
            dialog.setBlockOnOpen(true);
            int res = dialog.open();
            if (res == 0) {
                FilterPolicyTab.this.setPolicyMonProg(dialog.getMonProg());
                FilterPolicyTab.this.refreshMonprogTable();
                FilterPolicyTab.this.m_monprog_tv.getTable().setSelection(FilterPolicyTab.this.m_monprog_tv.getTable().getItemCount() - 1);
                FilterPolicyTab.this.checkMonprogButtonStatus();
                FilterPolicyTab.this.setDirty(true);
            }
        }
    }

    public class DNDCopyTextAction
    extends Action {
        private String m_props;

        public DNDCopyTextAction(String value, boolean isReadOnly) {
            super("DNDCopyTextAction");
            this.m_props = null;
            IWorkbenchWindow window = Activator.getDefault().getWorkbench().getActiveWorkbenchWindow();
            ISharedImages sharedImages = window.getWorkbench().getSharedImages();
            this.setText("Copy");
            this.setId("dndcopytextaction");
            this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY"));
            this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY_DISABLED"));
            if (value == null || isReadOnly) {
                this.setEnabled(false);
                return;
            }
            this.m_props = value;
        }

        public void run() {
            if (!this.isEnabled() || this.m_props == null) {
                return;
            }
            FilterPolicyTab.this.m_systemClipboard.clearContents();
            try {
                FilterPolicyTab.this.m_systemClipboard.setContents(new Object[]{this.m_props}, new Transfer[]{TextTransfer.getInstance()});
            }
            catch (Exception e) {
                RTLogger.print(5, "Error: cannot add text to the system clipboard", e);
            }
        }
    }

    public class DNDPasteTextAction
    extends Action {
        private String m_value;
        private int m_colIndex;
        private TableItem m_row;

        public DNDPasteTextAction(TableItem row, int colIndex, boolean isReadOnly) {
            String[] arr;
            super("DNDPasteTextAction");
            this.m_value = null;
            this.m_colIndex = -1;
            this.m_row = null;
            this.setText("Paste");
            this.setId("dndpastetextaction");
            if (isReadOnly || row == null || colIndex == -1) {
                this.setEnabled(false);
                return;
            }
            this.m_row = row;
            this.m_colIndex = colIndex;
            String props = (String)FilterPolicyTab.this.m_systemClipboard.getContents((Transfer)TextTransfer.getInstance());
            if (props != null && (arr = props.split(";")) != null && arr.length == 1) {
                this.m_value = arr[0];
            }
            if (this.m_value == null) {
                this.setEnabled(false);
                return;
            }
        }

        public void run() {
            if (!this.isEnabled() || this.m_value == null || this.m_colIndex == -1) {
                return;
            }
            boolean modified = FilterPolicyTab.this.m_condManager.updateCondition(this.m_row.getData(), this.m_colIndex, this.m_value, null, this.m_row);
            if (modified) {
                this.m_row.setText(this.m_colIndex, this.m_value);
                FilterPolicyTab.this.m_condManager.setDirty(true);
                FilterPolicyTab.this.setDirty(true);
                FilterPolicyTab.this.m_overview_tv.refresh(true);
                RTLogger.print(5, "DNDPaste text to FilterConditionOverviewTable " + this.m_value);
            }
        }
    }

    public class DeleteConditionAction
    extends Action {
        public DeleteConditionAction(boolean isReadOnly) {
            super("deletecondition");
            this.setId("deletecondition");
            this.setText("Delete Condition");
            ISharedImages sharedImages = Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getWorkbench().getSharedImages();
            this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE"));
            this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE_DISABLED"));
            if (isReadOnly) {
                this.setEnabled(false);
            }
            int itemCount = FilterPolicyTab.this.m_tv_condList.getTable().getItemCount();
            int selCount = FilterPolicyTab.this.m_tv_condList.getTable().getSelectionIndices().length;
            if (itemCount == 1 || selCount == 0) {
                this.setEnabled(false);
            }
        }

        public void run() {
            if (!this.isEnabled()) {
                return;
            }
            FilterPolicyTab.this.m_conditionList.deleteCondition();
            FilterPolicyTab.this.setDirty(true);
        }
    }

    public class DeleteLogfileMonitorAction
    extends Action {
        private int m_selIndex;

        public DeleteLogfileMonitorAction(boolean isReadOnly) {
            super("deletelogfilemonitor");
            this.m_selIndex = -1;
            this.setId("deletelogfilemonitor");
            this.setText("Delete");
            if (isReadOnly) {
                this.setEnabled(false);
                return;
            }
            this.m_selIndex = FilterPolicyTab.this.m_monprog_tv.getTable().getSelectionIndex();
            if (this.m_selIndex == -1) {
                FilterPolicyTab.this.m_gui.enableField(FilterPolicyTab.this.m_delLogfileMon_Button, false);
                this.setEnabled(false);
                return;
            }
        }

        public void run() {
            if (!this.isEnabled()) {
                return;
            }
            String[] monprog_new = FilterPolicyTab.this.m_monprogManager.deleteOPMMonitor(this.m_selIndex, FilterPolicyTab.this.m_callTypeInCombo);
            if (monprog_new != null) {
                FilterPolicyTab.this.setPolicyMonProg(monprog_new);
                FilterPolicyTab.this.refreshMonprogTable();
                FilterPolicyTab.this.m_monprog_tv.getTable().setSelection(0);
                FilterPolicyTab.this.checkMonprogButtonStatus();
                FilterPolicyTab.this.setDirty(true);
            }
        }
    }

    public class DuplicateConditionAction
    extends Action {
        public DuplicateConditionAction(boolean isReadOnly) {
            super("duplicatecondition");
            this.setId("duplicatecondition");
            this.setText("Duplicate Condition");
            ISharedImages sharedImages = Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getWorkbench().getSharedImages();
            this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY"));
            this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY_DISABLED"));
            int selCount = FilterPolicyTab.this.m_tv_condList.getTable().getSelectionIndices().length;
            if (isReadOnly || selCount == 0) {
                this.setEnabled(false);
            }
        }

        public void run() {
            if (!this.isEnabled()) {
                return;
            }
            FilterPolicyTab.this.m_conditionList.duplicateCondition();
            FilterPolicyTab.this.setDirty(true);
        }
    }

    public class EditLogfileMonitorAction
    extends Action {
        private int m_selIndex;

        public EditLogfileMonitorAction(boolean isReadOnly) {
            super("editlogfilemonitor");
            this.m_selIndex = -1;
            this.setId("editlogfilemonitor");
            this.setText("Edit");
            if (isReadOnly) {
                this.setEnabled(false);
                return;
            }
            if (FilterPolicyTab.this.m_callTypeInCombo.endsWith(MonprogTableProvider.LOGFILE_TRANSACTION_MONITOR) || FilterPolicyTab.this.m_callTypeInCombo.endsWith(MonprogTableProvider.LOGFILE_TRANSACTION_MONITOR_MULITLINE)) {
                this.m_selIndex = FilterPolicyTab.this.m_monprog_tv.getTable().getSelectionIndex();
                if (this.m_selIndex == -1) {
                    FilterPolicyTab.this.m_gui.enableField(FilterPolicyTab.this.m_editLogfileMon_Button, false);
                    this.setEnabled(false);
                    return;
                }
            }
        }

        public void run() {
            if (!this.isEnabled()) {
                return;
            }
            MonprogDialog dialog = new MonprogDialog(Display.getCurrent().getActiveShell(), FilterPolicyTab.this.m_callTypeInCombo, FilterPolicyTab.this.getMonprogValues(), this.m_selIndex, false, FilterPolicyTab.this.isReadOnly());
            dialog.setBlockOnOpen(true);
            int res = dialog.open();
            if (res == 0) {
                FilterPolicyTab.this.setPolicyMonProg(dialog.getMonProg());
                FilterPolicyTab.this.refreshMonprogTable();
                FilterPolicyTab.this.m_monprog_tv.getTable().select(this.m_selIndex);
                FilterPolicyTab.this.m_monprog_tv.getTable().setSelection(this.m_selIndex);
                FilterPolicyTab.this.checkMonprogButtonStatus();
                FilterPolicyTab.this.setDirty(true);
            }
        }
    }

    public class MoveConditionAction
    extends Action {
        private String m_type;
        private FilterCondList m_condList;

        public MoveConditionAction(String type, FilterCondList condList, boolean isReadOnly) {
            super("movecondition");
            this.m_type = null;
            this.m_condList = null;
            this.setId("movecondition");
            this.setText("Move");
            this.m_type = type;
            this.m_condList = condList;
            TableViewer tv = condList.m_tableViewer;
            if (this.m_type == null || this.m_condList == null || tv == null) {
                this.setEnabled(false);
                return;
            }
            this.setText(type);
            int[] selIndices = tv.getTable().getSelectionIndices();
            if (selIndices.length > 1 || isReadOnly) {
                this.setEnabled(false);
                return;
            }
            if (type.equals(MOVE_UP) || type.equals(MOVE_TOP)) {
                if (selIndices.length == 1 && selIndices[0] == 0) {
                    this.setEnabled(false);
                    return;
                }
            } else if (type.equals(MOVE_DOWN) || type.equals(MOVE_BOTTOM)) {
                int count = this.m_condList.getCondList().size();
                if (selIndices.length == 1 && selIndices[0] == count - 1) {
                    this.setEnabled(false);
                    return;
                }
            }
        }

        public void run() {
            if (!this.isEnabled()) {
                return;
            }
            if (this.m_type.equals(MOVE_UP)) {
                this.m_condList.moveOneUp();
            } else if (this.m_type.equals(MOVE_DOWN)) {
                this.m_condList.moveOneDown();
            } else if (this.m_type.equals(MOVE_TOP)) {
                this.m_condList.moveToTop();
            } else if (this.m_type.equals(MOVE_BOTTOM)) {
                this.m_condList.moveToBottom();
            }
            FilterPolicyTab.this.setDirty(true);
        }
    }
}

