/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views;

import com.blixx.log.RTLogger;
import com.blixx.shared.ext.ForwardFilter;
import com.blixx.shared.ext.NodeGroupForwardFilter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;

public class FilterProvider
implements IStructuredContentProvider,
ITableLabelProvider {
    Map<Integer, ForwardFilter> m_filters = new LinkedHashMap<Integer, ForwardFilter>();
    private int m_highestNumber = 0;

    public FilterProvider(List<ForwardFilter> filters) {
        this.setFilters(filters);
    }

    public void setFilters(List<ForwardFilter> filters) {
        this.m_filters.clear();
        if (filters != null) {
            int i = 0;
            while (i < filters.size()) {
                ForwardFilter ff = filters.get(i);
                if (ff.getNumber() > this.m_highestNumber) {
                    this.m_highestNumber = ff.getNumber();
                }
                this.m_filters.put(ff.getNumber(), ff);
                ++i;
            }
        }
    }

    public void addFFilters(List<ForwardFilter> list) {
        int i = 0;
        while (i < list.size()) {
            ForwardFilter ff = list.get(i);
            Properties p = ff.getProperties();
            if (!this.m_filters.containsKey(ff.getNumber())) {
                RTLogger.print(5, "Add new Server Policy Filter " + p.getProperty("NAME"));
                ++this.m_highestNumber;
            } else {
                RTLogger.print(5, "Update Server Policy Filter " + p.getProperty("NAME"));
            }
            this.m_filters.put(ff.getNumber(), ff);
            ++i;
        }
    }

    public void removeFFilters(List<ForwardFilter> list) {
        int i = 0;
        while (i < list.size()) {
            ForwardFilter ff = list.get(i);
            if (this.m_filters.containsKey(ff.getNumber())) {
                this.m_filters.remove(ff.getNumber());
                Properties p = ff.getProperties();
                RTLogger.print(5, "Delete Server Policy Filter " + p.getProperty("NAME"));
            }
            ++i;
        }
    }

    public ForwardFilter getFilter(int number) {
        return this.m_filters.get(number);
    }

    public ForwardFilter getFilter(String name) {
        ForwardFilter res = null;
        for (ForwardFilter forwardFilter : this.m_filters.values()) {
            if (!forwardFilter.getName().equals(name)) continue;
            res = forwardFilter;
            break;
        }
        return res;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (element == null) {
            return "";
        }
        switch (columnIndex) {
            case 0: {
                return ((ForwardFilter)element).getName();
            }
            case 1: {
                return ForwardFilter.getAttributeName(((ForwardFilter)element).getType());
            }
            case 2: {
                if (element instanceof NodeGroupForwardFilter) {
                    return ((NodeGroupForwardFilter)element).getPath();
                }
                return ((ForwardFilter)element).getPatternB();
            }
        }
        return null;
    }

    public Object[] getElements(Object inputElement) {
        return this.m_filters.values().toArray(new ForwardFilter[0]);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public List<ForwardFilter> getFilters() {
        ArrayList<ForwardFilter> filters = new ArrayList<ForwardFilter>();
        filters.addAll(this.m_filters.values());
        return filters;
    }

    public int getHighestNumber() {
        return this.m_highestNumber;
    }
}

