/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.GActionsRepository;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.gui.dialogs.NameValidatorFile;
import com.blixx.boom.gui.policies.ViewContentProvider;
import com.blixx.boom.gui.utils.GUIDisplayElements;
import com.blixx.boom.gui.utils.STreeViewer;
import com.blixx.boom.gui.views.ImportMPIView;
import com.blixx.boom.gui.views.actions.ExpandCollapseAction;
import com.blixx.log.RTLogger;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.GroupTreeObjectLast;
import com.blixx.shared.utils.ITreeObject;
import com.blixx.shared.utils.TreeObject;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class ImportMPIActionSection
extends Section
implements IExpansionListener,
SelectionListener,
ISelectionChangedListener {
    private ImportMPIActionSection m_actionSection = null;
    private ImportMPIView m_importMPIView = null;
    private GroupTreeObject m_existingActTree = null;
    private String m_importDir = null;
    private GroupTreeObject m_actRoot = null;
    private GroupTreeObject m_act4ImportRoot = null;
    private TreeViewer m_tv_act = null;
    private TreeViewer m_tv_act4Import = null;
    private ContentProviderActImportTree m_treeContentProvider_final = null;
    private GUIDisplayElements m_gui = null;
    private FormToolkit m_toolkit = null;
    private Composite m_sectionClient = null;
    private Text m_actFooter = null;
    private Text m_act4ImportFooter = null;
    private int m_totalImportConflicts = 0;
    public HashMap<String, List<com.blixx.shared.Action>> m_allActionGrps = new HashMap();
    public Map<String, GroupTreeObject> m_allIncomingElements = new HashMap<String, GroupTreeObject>();
    public Map<String, GroupTreeObject> m_actGrpNew = new HashMap<String, GroupTreeObject>();
    public Map<String, GroupTreeObject> m_actGrpExistWithoutConflict = new HashMap<String, GroupTreeObject>();
    public Map<String, GroupTreeObject> m_actGrpExistWithConflict = new HashMap<String, GroupTreeObject>();
    public Map<String, GroupTreeObjectLast> m_actNew = new HashMap<String, GroupTreeObjectLast>();
    public Map<String, GroupTreeObjectLast> m_actExist = new HashMap<String, GroupTreeObjectLast>();
    public Map<String, GroupTreeObjectLast> m_actNotInImport_butExistOnSrv = new HashMap<String, GroupTreeObjectLast>();
    public Map<String, String> m_actGrpNewAfterRename = new HashMap<String, String>();
    public Map<String, GroupTreeObject> m_actGrp2Overwrite = new HashMap<String, GroupTreeObject>();
    public Map<String, GroupTreeObject> m_actGrpsMerge = new HashMap<String, GroupTreeObject>();
    public Map<String, GroupTreeObjectLast> m_actNewAfterRename = new HashMap<String, GroupTreeObjectLast>();
    public Map<String, GroupTreeObject> m_elemetsSkipImport = new HashMap<String, GroupTreeObject>();
    public static String RESET_ACTION_GRP = "RESET_ACTION_GRP";
    private static String ADD_BTN = "ADD_BTN";
    private static String REMOVE_BTN = "REMOVE_BTN";
    private static String RENAME_BTN = "RENAME_BTN";
    private static String ADD_PREFIX_BTN = "ADD_PREFIX_BTN";
    private static String ADD_SUFFIX_BTN = "ADD_SUFFIX_BTN";
    private static String MERGE_BTN = "MERGE_BTN";
    private static String OVERWRITE_BTN = "OVERWRITE_BTN";
    private static String RESET_TREE_BTN = "RESET_TREE_BTN";
    private static String REMOVE_FROM_IMPORT_BTN = "REMOVE_FROM_IMPORT_BTN";
    private Button m_add_btn = null;
    private Button m_remove_btn = null;
    private Button m_rename_btn = null;
    private Button m_addPrefix_btn = null;
    private Button m_addSuffix_btn = null;
    private Button m_merge_btn = null;
    private Button m_overwrite_btn = null;
    private Button m_resetTree_btn = null;
    private Button m_removeFromImport_btn = null;
    Listener paintListenerActTree = new Listener(){

        public void handleEvent(Event event) {
            Widget obj = event.item;
            if (obj instanceof TreeItem) {
                TreeItem ti = (TreeItem)event.item;
                Object o = ti.getData();
                boolean cfr_ignored_0 = o instanceof GroupTreeObjectLast;
            }
        }
    };
    Listener paintListenerActImportTree = new Listener(){

        public void handleEvent(Event event) {
            Widget obj = event.item;
            if (obj instanceof TreeItem) {
                TreeItem ti = (TreeItem)event.item;
                Object o = ti.getData();
                Image icon = null;
                if (o instanceof GroupTreeObjectLast) {
                    GroupTreeObjectLast gtol = (GroupTreeObjectLast)o;
                    icon = ImportMPIActionSection.this.get2ndIcon(gtol, ImportMPIView.ACT_4IMPORT);
                } else if (o instanceof GroupTreeObject) {
                    GroupTreeObject gto = (GroupTreeObject)o;
                    icon = ImportMPIActionSection.this.get2ndIcon(gto, ImportMPIView.ACT_4IMPORT);
                }
                if (icon != null) {
                    switch (event.type) {
                        case 41: {
                            Rectangle rect = icon.getBounds();
                            event.width += rect.width;
                            event.height = Math.max(event.height, rect.height + 2);
                            break;
                        }
                        case 42: {
                            int x = event.x + event.width;
                            Rectangle rect = icon.getBounds();
                            int offset = Math.max(0, (event.height - rect.height) / 2);
                            event.gc.drawImage(icon, x, event.y + offset);
                        }
                    }
                }
            }
        }
    };

    public ImportMPIActionSection(Composite parent, ImportMPIView importMPIView) {
        super(parent, 578);
        this.setText("Actions");
        this.setLayoutData(new GridData(4, 128, true, false));
        this.m_actionSection = this;
        this.m_importMPIView = importMPIView;
    }

    public void initSection() {
        this.m_gui = new GUIDisplayElements();
        this.m_toolkit = BMUI.getFormToolkit(Display.getCurrent());
        this.m_sectionClient = this.m_toolkit.createComposite((Composite)this.m_actionSection, 0);
        this.m_sectionClient.setLayout((Layout)new GridLayout(2, false));
        this.m_sectionClient.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite treeComp = new Composite(this.m_sectionClient, 0);
        GridLayout gl = new GridLayout(3, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        treeComp.setLayout((Layout)gl);
        treeComp.setLayoutData((Object)new GridData(4, 4, true, true));
        Group importTree_grp = new Group(treeComp, 32);
        importTree_grp.setText("Actions");
        importTree_grp.setLayout((Layout)new GridLayout(1, false));
        importTree_grp.setLayoutData((Object)new GridData(4, 4, true, true));
        this.m_tv_act = new STreeViewer((Composite)importTree_grp, 268438274);
        this.m_tv_act.setData(ImportMPIView.TREE_VIEWER_TYPE, (Object)ImportMPIView.ACT);
        this.m_tv_act.getTree().setLayoutData((Object)ImportMPIView.m_sectionTree_gd);
        this.m_tv_act.setUseHashlookup(true);
        this.m_tv_act.setContentProvider((IContentProvider)new ViewContentProvider());
        this.m_tv_act.setLabelProvider((IBaseLabelProvider)new StyledLabelProviderActTree(this));
        this.m_tv_act.setInput((Object)this.m_actRoot);
        this.m_tv_act.addSelectionChangedListener((ISelectionChangedListener)this);
        this.m_tv_act.getTree().addListener(41, this.paintListenerActTree);
        this.m_tv_act.getTree().addListener(42, this.paintListenerActTree);
        this.createXMLTree_CM();
        this.m_actFooter = this.m_gui.addTextReadOnlyNoBorder((Composite)importTree_grp, null, "", 1, 1, 1, 1, BMUI.font_arial8);
        this.updateTreeFooter(this.m_tv_act);
        Composite btn1Comp = new Composite(treeComp, 0);
        gl = new GridLayout(1, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        btn1Comp.setLayout((Layout)gl);
        btn1Comp.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        this.m_add_btn = this.m_gui.addButton(btn1Comp, ADD_BTN, " >> ", false, this);
        this.m_remove_btn = this.m_gui.addButton(btn1Comp, REMOVE_BTN, " << ", false, this);
        Group finalTree_grp = new Group(treeComp, 32);
        finalTree_grp.setText("Preview");
        finalTree_grp.setLayout((Layout)new GridLayout(1, false));
        finalTree_grp.setLayoutData((Object)new GridData(4, 4, true, true));
        this.m_tv_act4Import = new STreeViewer((Composite)finalTree_grp, 268438274);
        this.m_tv_act4Import.setData(ImportMPIView.TREE_VIEWER_TYPE, (Object)ImportMPIView.ACT_4IMPORT);
        this.m_tv_act4Import.getTree().setLayoutData((Object)ImportMPIView.m_sectionTree_gd);
        this.m_tv_act4Import.setUseHashlookup(true);
        this.m_treeContentProvider_final = new ContentProviderActImportTree();
        this.m_tv_act4Import.setContentProvider((IContentProvider)this.m_treeContentProvider_final);
        this.m_tv_act4Import.setLabelProvider((IBaseLabelProvider)new StyledLabelProviderActImportTree(this));
        this.m_tv_act4Import.setInput((Object)this.m_act4ImportRoot);
        this.m_tv_act4Import.addSelectionChangedListener((ISelectionChangedListener)this);
        this.m_tv_act4Import.getTree().addListener(41, this.paintListenerActImportTree);
        this.m_tv_act4Import.getTree().addListener(42, this.paintListenerActImportTree);
        this.createFinalTree_CM();
        this.m_act4ImportFooter = this.m_gui.addTextReadOnlyNoBorder((Composite)finalTree_grp, null, "", 1, 1, 1, 1, BMUI.font_arial8);
        this.updateTreeFooter(this.m_tv_act4Import);
        Composite btnComp = new Composite(this.m_sectionClient, 0);
        btnComp.setLayout((Layout)new GridLayout(1, false));
        btnComp.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.m_rename_btn = this.m_gui.addButton(btnComp, RENAME_BTN, "Rename", false, this);
        this.m_rename_btn.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.m_addPrefix_btn = this.m_gui.addButton(btnComp, ADD_PREFIX_BTN, "Add Prefix", false, this);
        this.m_addPrefix_btn.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.m_addSuffix_btn = this.m_gui.addButton(btnComp, ADD_SUFFIX_BTN, "Add Suffix", false, this);
        this.m_addSuffix_btn.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.m_merge_btn = this.m_gui.addButton(btnComp, MERGE_BTN, "Merge", false, this);
        this.m_merge_btn.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.m_overwrite_btn = this.m_gui.addButton(btnComp, OVERWRITE_BTN, "Overwrite", false, this);
        this.m_overwrite_btn.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.m_resetTree_btn = this.m_gui.addButton(btnComp, RESET_TREE_BTN, "Reset Tree", false, this);
        this.m_resetTree_btn.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.m_removeFromImport_btn = this.m_gui.addButton(btnComp, REMOVE_FROM_IMPORT_BTN, "Remove", false, this);
        this.m_removeFromImport_btn.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.setClient((Control)this.m_sectionClient);
        this.addExpansionListener(this);
    }

    public void updateSection(String importDir, boolean resetAction) {
        if (!this.isEnabled()) {
            return;
        }
        this.m_allActionGrps.clear();
        this.m_allIncomingElements.clear();
        this.m_actGrpNew.clear();
        this.m_actGrpExistWithoutConflict.clear();
        this.m_actGrpExistWithConflict.clear();
        this.m_actNew.clear();
        this.m_actExist.clear();
        this.m_actGrpNewAfterRename.clear();
        this.m_actNotInImport_butExistOnSrv.clear();
        this.m_actGrp2Overwrite.clear();
        this.m_actGrpsMerge.clear();
        this.m_actNewAfterRename.clear();
        this.m_elemetsSkipImport.clear();
        this.m_importDir = importDir;
        this.loadActions();
        if (this.m_actRoot != null) {
            try {
                this.m_act4ImportRoot = this.m_actRoot.clone();
                this.processClonedTree();
                this.checkConflicts();
            }
            catch (CloneNotSupportedException e) {
                this.m_act4ImportRoot = null;
                RTLogger.print(5, "ImportMPI: Error cloning import tree", e);
            }
        }
        int expLevel = 1;
        if (resetAction) {
            expLevel = -1;
        }
        this.refreshTree(this.m_tv_act, this.m_actRoot, 1, false);
        this.refreshTree(this.m_tv_act4Import, this.m_act4ImportRoot, expLevel, true);
        if (this.m_actRoot == null || this.m_actRoot.getElements().size() == 0) {
            this.setExpanded(false);
        } else {
            this.setExpanded(true);
        }
    }

    private void loadActions() {
        String actionsDir;
        File actDir;
        this.m_actRoot = null;
        this.m_act4ImportRoot = null;
        if (!this.m_importDir.endsWith(File.separator)) {
            this.m_importDir = String.valueOf(this.m_importDir) + File.separator;
        }
        if ((actDir = new File(actionsDir = String.valueOf(this.m_importDir) + "actions")) != null && actDir.isDirectory()) {
            this.m_actRoot = new GroupTreeObject(new TreeObject("Actions", BMUI.type_folder, null));
            File[] fileList = actDir.listFiles();
            int i = 0;
            while (i < fileList.length) {
                if (fileList[i].getName().endsWith(BMUI.file_extension_act)) {
                    String filename = fileList[i].getName();
                    String groupName = filename.replace(BMUI.file_extension_act, "");
                    GroupTreeObject actGrpGtoIN = new GroupTreeObject(new TreeObject(groupName, BMUI.type_folder, null));
                    this.m_actRoot.addElementNoSorting(actGrpGtoIN);
                    this.m_allIncomingElements.put(actGrpGtoIN.getPath(), actGrpGtoIN);
                    List<com.blixx.shared.Action> actions = null;
                    GActionsRepository GA = Repository.getInstance().m_actionRepository;
                    try {
                        actions = GA.loadActions(fileList[i]);
                        if (actions != null && actions.size() > 0) {
                            this.m_allActionGrps.put(actGrpGtoIN.getName(), actions);
                        }
                    }
                    catch (Throwable throwable) {}
                    if (actions != null && actions.size() > 0) {
                        int j = 0;
                        while (j < actions.size()) {
                            com.blixx.shared.Action a = actions.get(j);
                            TreeObject to = new TreeObject(a.m_label, BMUI.type_act, a);
                            GroupTreeObjectLast actGtolIN = null;
                            actGtolIN = a.m_serverAction ? new GroupTreeObjectLast(to, null, "IMAGE_ACTION_SERVER") : new GroupTreeObjectLast(to, null, "IMAGE_ACTION");
                            actGrpGtoIN.addElementNoSorting(actGtolIN);
                            this.m_allIncomingElements.put(actGtolIN.getPath(), actGtolIN);
                            ++j;
                        }
                    }
                }
                ++i;
            }
            this.m_actRoot.sortElementsRecursive();
        } else {
            actionsDir = null;
            RTLogger.print(1, "No conf directory found");
        }
    }

    private void processClonedTree() {
        List<GroupTreeObject> elements = this.m_act4ImportRoot.getAllElements();
        for (GroupTreeObject gto : elements) {
            GroupTreeObject orig = this.m_actRoot.searchPath(gto.getPath(), gto.getType());
            if (orig == null) continue;
            gto.getTreeObject().setObject(orig.getPath());
        }
    }

    public void checkConflicts() {
        this.m_existingActTree = Repository.getInstance().m_actionRepository.getTree();
        for (String inActName : this.m_allIncomingElements.keySet()) {
            GroupTreeObject obj = this.m_allIncomingElements.get(inActName);
            if (obj == null || obj instanceof GroupTreeObjectLast || !(obj instanceof GroupTreeObject)) continue;
            GroupTreeObject inGto = obj;
            GroupTreeObject existGto = this.m_existingActTree.searchPath(inGto.getPath(), inGto.getType());
            if (existGto == null) {
                this.m_actGrpNew.put(inGto.getName(), inGto);
                continue;
            }
            boolean hasConflict = false;
            List<GroupTreeObject> list = inGto.getAllElements();
            for (GroupTreeObject o : list) {
                if (!(o instanceof GroupTreeObjectLast)) continue;
                GroupTreeObjectLast inGtol = (GroupTreeObjectLast)o;
                GroupTreeObject existGtol = this.m_existingActTree.searchPath(inGtol.getPath(), inGtol.getType());
                if (existGtol == null) {
                    this.m_actNew.put(inGtol.getPath(), inGtol);
                    hasConflict = true;
                    continue;
                }
                this.m_actExist.put(inGtol.getPath(), inGtol);
            }
            List<GroupTreeObject> list2 = existGto.getAllElements();
            for (GroupTreeObject o : list2) {
                GroupTreeObjectLast existGtol;
                if (!(o instanceof GroupTreeObjectLast) || inGto.searchPath((existGtol = (GroupTreeObjectLast)o).getPath(), existGtol.getType()) != null) continue;
                this.m_actNotInImport_butExistOnSrv.put(existGtol.getPath(), existGtol);
                this.m_importMPIView.addElement2Tree(this.m_act4ImportRoot, existGtol, existGtol.getParentPath());
                hasConflict = true;
            }
            if (hasConflict) {
                this.m_actGrpExistWithConflict.put(inGto.getName(), inGto);
                continue;
            }
            this.m_actGrpExistWithoutConflict.put(inGto.getName(), inGto);
        }
    }

    public void clearSection() {
        this.m_importDir = null;
        this.m_actRoot = null;
        this.refreshTree(this.m_tv_act, this.m_actRoot, 0, false);
        this.refreshTree(this.m_tv_act4Import, this.m_act4ImportRoot, 0, true);
    }

    public void updateTreeFooter(TreeViewer tv) {
        StringBuffer sb = new StringBuffer();
        String type = (String)tv.getData(ImportMPIView.TREE_VIEWER_TYPE);
        if (type.equalsIgnoreCase(ImportMPIView.ACT)) {
            int totalActGrps = 0;
            int totalActions = 0;
            if (this.m_actRoot != null) {
                List<GroupTreeObject> actionGrps = this.m_actRoot.getElements();
                totalActGrps = actionGrps.size();
                totalActions = GroupTreeObject.collectElements(this.m_actRoot).size();
            }
            sb.append("Groups (").append(totalActGrps).append(")").append("  Actions (").append(totalActions).append(")");
            this.m_actFooter.setText(sb.toString());
            this.m_actFooter.pack(true);
        } else if (type.equalsIgnoreCase(ImportMPIView.ACT_4IMPORT)) {
            int totalActGrps = 0;
            int totalActions = 0;
            this.m_totalImportConflicts = 0;
            if (this.m_act4ImportRoot != null) {
                List<GroupTreeObject> list = this.m_act4ImportRoot.getElements();
                totalActGrps = list.size();
                for (GroupTreeObject actGrpGto : list) {
                    if (!this.hasConflict(actGrpGto)) continue;
                    ++this.m_totalImportConflicts;
                }
                totalActions = GroupTreeObject.collectElements(this.m_act4ImportRoot).size();
            }
            sb.append("Groups (").append(totalActGrps).append(")").append("  Actions (").append(totalActions).append(")").append("  Groups with Conflicts(").append(this.m_totalImportConflicts).append(")");
            this.m_act4ImportFooter.setText(sb.toString());
            this.m_act4ImportFooter.pack(true);
        }
    }

    public GroupTreeObject getOriginalElement(GroupTreeObject gto) {
        if (gto == null) {
            return null;
        }
        GroupTreeObject origGTO = null;
        ITreeObject to = gto.getTreeObject();
        if (to != null) {
            Object o = to.getObject();
            if (o instanceof GroupTreeObject) {
                origGTO = (GroupTreeObject)o;
            } else if (o instanceof String) {
                String origPath = (String)o;
                if (this.m_actRoot != null) {
                    origGTO = this.m_actRoot.searchPath(origPath, gto.getType());
                }
            }
        }
        return origGTO;
    }

    public GroupTreeObject cloneElement(GroupTreeObject gto) {
        if (gto == null) {
            return null;
        }
        GroupTreeObject clone = null;
        try {
            clone = gto.clone();
            clone.getTreeObject().setObject(gto.getPath());
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        return clone;
    }

    private GroupTreeObject getParentActGrp(GroupTreeObject gto) {
        if (gto == null) {
            return null;
        }
        String type = gto.getType();
        GroupTreeObject gto2 = gto;
        while (type.equals(BMUI.type_act)) {
            GroupTreeObject parent = gto2.getParent();
            if (parent == null) break;
            type = parent.getType();
            gto2 = parent;
        }
        return gto2;
    }

    public boolean hasInitialConflict(GroupTreeObject actGrpGto) {
        boolean hasConflict = false;
        if (this.doesRelActGrpExistWithConflict(actGrpGto)) {
            hasConflict = true;
        }
        return hasConflict;
    }

    public boolean hasConflict(GroupTreeObject actGrpGto) {
        boolean hasConflict = false;
        if (this.hasInitialConflict(actGrpGto) && !this.doOverwriteActionGrp(actGrpGto) && !this.doMergeActionGrp(actGrpGto) && !this.isActGrpNewAfterRename(actGrpGto)) {
            hasConflict = true;
        }
        return hasConflict;
    }

    public boolean isActionNew(GroupTreeObjectLast gtol) {
        if (gtol == null) {
            return false;
        }
        boolean isNew = false;
        GroupTreeObject origGTOL = this.getOriginalElement(gtol);
        if (origGTOL != null && this.m_actNew.containsKey(origGTOL.getPath())) {
            isNew = true;
        }
        return isNew;
    }

    public boolean doesActionExist(GroupTreeObjectLast gtol) {
        if (gtol == null) {
            return false;
        }
        boolean isNew = false;
        GroupTreeObject origGTOL = this.getOriginalElement(gtol);
        if (origGTOL != null && this.m_actExist.containsKey(origGTOL.getPath())) {
            isNew = true;
        }
        return isNew;
    }

    public boolean isRelActGrpNew(GroupTreeObject gto) {
        if (gto == null) {
            return false;
        }
        boolean isNew = false;
        GroupTreeObject actGrpGto = null;
        actGrpGto = gto.getType().equals(BMUI.type_act) ? this.getParentActGrp(gto) : gto;
        if (actGrpGto != null) {
            String currBinPath = actGrpGto.getPath();
            GroupTreeObject origGTO = this.getOriginalElement(actGrpGto);
            if (origGTO != null) {
                if (!currBinPath.equals(origGTO.getPath())) {
                    isNew = true;
                } else if (this.m_actGrpNew.containsKey(origGTO.getName())) {
                    isNew = true;
                }
            }
        }
        return isNew;
    }

    public boolean doesRelActGrpExistWithConflict(GroupTreeObject gto) {
        GroupTreeObject origGTO;
        if (gto == null) {
            return false;
        }
        boolean belongToNew = false;
        GroupTreeObject actGrpGto = this.getParentActGrp(gto);
        if (actGrpGto != null && (origGTO = this.getOriginalElement(actGrpGto)) != null) {
            belongToNew = this.m_actGrpExistWithConflict.containsKey(origGTO.getName());
        }
        return belongToNew;
    }

    public boolean doesRelActGrpExistWithoutConflict(GroupTreeObject gto) {
        GroupTreeObject origGTO;
        if (gto == null) {
            return false;
        }
        boolean belongToNew = false;
        GroupTreeObject actGrpGto = this.getParentActGrp(gto);
        if (actGrpGto != null && (origGTO = this.getOriginalElement(actGrpGto)) != null) {
            belongToNew = this.m_actGrpExistWithoutConflict.containsKey(origGTO.getName());
        }
        return belongToNew;
    }

    public boolean doesActExistButMissingInImport(GroupTreeObjectLast actGtol) {
        GroupTreeObjectLast actGtolOnSrv;
        if (actGtol == null) {
            return false;
        }
        return this.m_actNotInImport_butExistOnSrv.containsKey(actGtol.getPath()) && (actGtolOnSrv = this.m_actNotInImport_butExistOnSrv.get(actGtol.getPath())) != null && actGtol.getPath().equals(actGtolOnSrv.getPath());
    }

    public boolean doOverwriteActionGrp(GroupTreeObject gto) {
        GroupTreeObject origGTO;
        if (gto == null) {
            return false;
        }
        boolean overwrite = false;
        GroupTreeObject actGrpGto = this.getParentActGrp(gto);
        if (actGrpGto != null && (origGTO = this.getOriginalElement(gto)) != null) {
            overwrite = this.m_actGrp2Overwrite.containsKey(origGTO.getName());
        }
        return overwrite;
    }

    public boolean doMergeActionGrp(GroupTreeObject gto) {
        GroupTreeObject origGTO;
        if (gto == null) {
            return false;
        }
        boolean overwrite = false;
        GroupTreeObject actGrpGto = this.getParentActGrp(gto);
        if (actGrpGto != null && (origGTO = this.getOriginalElement(gto)) != null) {
            overwrite = this.m_actGrpsMerge.containsKey(origGTO.getName());
        }
        return overwrite;
    }

    public boolean isActGrpNewAfterRename(GroupTreeObject gto) {
        GroupTreeObject origGTO;
        if (gto == null) {
            return false;
        }
        boolean isNew = false;
        GroupTreeObject actGrpGto = this.getParentActGrp(gto);
        if (actGrpGto != null && (origGTO = this.getOriginalElement(gto)) != null) {
            isNew = this.m_actGrpNewAfterRename.containsKey(origGTO.getName());
        }
        return isNew;
    }

    public Image get2ndIcon(GroupTreeObject gto, String treeType) {
        if (gto == null || treeType == null) {
            return null;
        }
        if (!treeType.equals(ImportMPIView.ACT) && treeType.equals(ImportMPIView.ACT_4IMPORT)) {
            if (gto.getType().equals(BMUI.type_act)) {
                GroupTreeObject actGrpGto;
                if (this.doesActExistButMissingInImport((GroupTreeObjectLast)gto)) {
                    return BMUI.IMAGE_ARROW_LEFT_BLUE;
                }
                if (!this.isRelActGrpNew(gto) && !this.doesRelActGrpExistWithoutConflict(gto) && this.doesRelActGrpExistWithConflict(gto) && !this.doOverwriteActionGrp(actGrpGto = this.getParentActGrp(gto))) {
                    this.doMergeActionGrp(actGrpGto);
                }
            } else if (!this.isRelActGrpNew(gto) && !this.doesRelActGrpExistWithoutConflict(gto) && this.doesRelActGrpExistWithConflict(gto) && !this.doOverwriteActionGrp(gto) && this.doMergeActionGrp(gto)) {
                return BMUI.IMAGE_MERGE;
            }
        }
        return null;
    }

    public void renameElements(Map<GroupTreeObject, String> elements, String value, String type) {
        for (GroupTreeObject gto : elements.keySet()) {
            if (type.equals(ImportMPIView.PREFIX)) {
                gto.setName(String.valueOf(value) + gto.getName());
            } else if (type.equals(ImportMPIView.SUFFIX)) {
                gto.setName(String.valueOf(gto.getName()) + value);
            } else if (type.equals(ImportMPIView.RENAME)) {
                gto.setName(value);
            }
            GroupTreeObject origGto = this.getOriginalElement(gto);
            if (origGto == null) continue;
            this.removeFromHashMaps(origGto);
            if (gto instanceof GroupTreeObjectLast) {
                this.m_actNewAfterRename.put(origGto.getPath(), (GroupTreeObjectLast)origGto);
                continue;
            }
            String newName = gto.getName();
            this.m_actGrpNewAfterRename.put(origGto.getName(), newName);
            for (String actPath : this.m_actNotInImport_butExistOnSrv.keySet()) {
                GroupTreeObjectLast actSrvGto = this.m_actNotInImport_butExistOnSrv.get(actPath);
                if (!actSrvGto.getParent().getName().equals(origGto.getName())) continue;
                this.m_importMPIView.removeElementFromTree(this.m_act4ImportRoot, actSrvGto.getName(), actSrvGto.getType());
            }
        }
        this.refreshTree(this.m_tv_act4Import, this.m_act4ImportRoot, -1, true);
    }

    public void overwriteActionGrp(Map<String, GroupTreeObject> actGrps) {
        for (String actGrpName : actGrps.keySet()) {
            GroupTreeObject origGTO;
            GroupTreeObject gto = actGrps.get(actGrpName);
            if (gto.getType().equals(BMUI.type_act) || (origGTO = this.getOriginalElement(gto)) == null) continue;
            this.removeFromHashMaps(origGTO);
            this.m_actGrp2Overwrite.put(origGTO.getName(), origGTO);
            for (String actPath : this.m_actNotInImport_butExistOnSrv.keySet()) {
                GroupTreeObjectLast actSrvGto = this.m_actNotInImport_butExistOnSrv.get(actPath);
                if (!actSrvGto.getParent().getName().equals(gto.getName())) continue;
                this.m_importMPIView.removeElementFromTree(this.m_act4ImportRoot, actSrvGto.getName(), actSrvGto.getType());
            }
        }
        this.refreshTree(this.m_tv_act4Import, this.m_act4ImportRoot, -1, true);
    }

    public void mergeActionGrp(Map<String, GroupTreeObject> actGrps) {
        for (String actGrpName : actGrps.keySet()) {
            GroupTreeObject origGTO;
            GroupTreeObject actGrpGTO = actGrps.get(actGrpName);
            if (actGrpGTO.getType().equals(BMUI.type_act) || (origGTO = this.getOriginalElement(actGrpGTO)) == null) continue;
            this.removeFromHashMaps(origGTO);
            this.m_actGrpsMerge.put(origGTO.getName(), origGTO);
        }
        this.refreshTree(this.m_tv_act4Import, this.m_act4ImportRoot, -1, true);
    }

    public void resetActGroups(Map<String, GroupTreeObject> actGrps) {
        for (GroupTreeObject gto : actGrps.values()) {
            GroupTreeObject origGTO = this.getOriginalElement(gto);
            if (origGTO == null) continue;
            this.removeFromHashMaps(origGTO);
            this.removeFromHashMaps(origGTO.getAllElements());
            GroupTreeObject parent = gto.getParent();
            parent.removeElement(gto);
            GroupTreeObject clone = this.cloneElement(origGTO);
            parent.addElement(clone);
            for (GroupTreeObjectLast existAction : this.m_actNotInImport_butExistOnSrv.values()) {
                if (!existAction.getParent().getName().equals(origGTO.getName())) continue;
                this.m_importMPIView.addElement2Tree(this.m_act4ImportRoot, existAction, existAction.getParentPath());
            }
        }
        this.refreshTree(this.m_tv_act4Import, this.m_act4ImportRoot, -1, true);
    }

    public void removeFromImport(Map<GroupTreeObject, String> elements) {
        for (GroupTreeObject gto : elements.keySet()) {
            GroupTreeObject gtoExist = this.m_act4ImportRoot.searchPath(gto.getPath(), gto.getType());
            if (gtoExist == null) continue;
            gtoExist.getParent().removeElement(gtoExist);
            GroupTreeObject origGTO = this.getOriginalElement(gto);
            if (origGTO == null) continue;
            this.removeFromHashMaps(origGTO);
            this.m_elemetsSkipImport.put(origGTO.getPath(), origGTO);
        }
        this.refreshTree(this.m_tv_act4Import, this.m_act4ImportRoot, -1, true);
    }

    public void addToImport(Map<GroupTreeObject, String> elements) {
        HashMap<String, GroupTreeObject> actGrps = new HashMap<String, GroupTreeObject>();
        for (GroupTreeObject origGTO : elements.keySet()) {
            GroupTreeObject newAddedGTO;
            this.removeFromHashMaps(origGTO);
            this.removeFromHashMaps(origGTO.getAllElements());
            this.m_importMPIView.addElement2Tree(this.m_act4ImportRoot, origGTO, origGTO.getParentPath());
            if (origGTO instanceof GroupTreeObjectLast || (newAddedGTO = this.m_act4ImportRoot.searchPath(origGTO.getPath(), origGTO.getType())) == null) continue;
            actGrps.put(newAddedGTO.getName(), newAddedGTO);
        }
        this.resetActGroups(actGrps);
        this.refreshTree(this.m_tv_act4Import, this.m_act4ImportRoot, -1, true);
    }

    public void removeFromHashMaps(List<GroupTreeObject> origGTOList) {
        for (GroupTreeObject origGTO : origGTOList) {
            this.removeFromHashMaps(origGTO);
        }
    }

    public void removeFromHashMaps(GroupTreeObject origGTO) {
        if (origGTO == null) {
            return;
        }
        String origName = origGTO.getName();
        String origPath = origGTO.getPath();
        if (this.m_elemetsSkipImport.containsKey(origPath)) {
            this.m_elemetsSkipImport.remove(origPath);
        }
        if (this.m_actGrpsMerge.containsKey(origName)) {
            this.m_actGrpsMerge.remove(origName);
        }
        if (this.m_actGrp2Overwrite.containsKey(origName)) {
            this.m_actGrp2Overwrite.remove(origName);
        }
        if (this.m_actGrpNewAfterRename.containsKey(origName)) {
            this.m_actGrpNewAfterRename.remove(origName);
        }
        if (this.m_actNewAfterRename.containsKey(origPath)) {
            this.m_actNewAfterRename.remove(origPath);
        }
    }

    public void refreshTree(TreeViewer tv, GroupTreeObject root, int expLevel, boolean removeEmptyFolders) {
        this.m_importMPIView.refreshTree(tv, root, expLevel);
        if (removeEmptyFolders && root != null) {
            GroupTreeObject.cleanEmptyGroups(root, root);
        }
        this.updateTreeFooter(tv);
        this.m_importMPIView.updateImportButtonStatus();
    }

    public void createXMLTree_CM() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        Menu menu = menuMgr.createContextMenu(this.m_tv_act.getControl());
        this.m_tv_act.getControl().setMenu(menu);
        ImportMPIView.m_instance.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.m_tv_act);
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                try {
                    manager.add((IAction)new AddToImportAction(ImportMPIActionSection.this.m_tv_act, ImportMPIActionSection.this.m_actRoot, ImportMPIActionSection.this.m_actionSection));
                    manager.add((IContributionItem)new Separator());
                    manager.add((IAction)new ExpandCollapseAction(ImportMPIActionSection.this.m_tv_act, "ExpandAll"));
                    manager.add((IAction)new ExpandCollapseAction(ImportMPIActionSection.this.m_tv_act, "CollapseAll"));
                    manager.add((IContributionItem)new Separator());
                    manager.add((IAction)new ExpandCollapseAction(ImportMPIActionSection.this.m_tv_act, "ExpandSubTree"));
                    manager.add((IAction)new ExpandCollapseAction(ImportMPIActionSection.this.m_tv_act, "CollagpseSubTree"));
                }
                catch (RuntimeException e) {
                    RTLogger.print(5, "ImportMPI: Error creating context menu of import tree", e);
                }
            }
        });
    }

    public void createFinalTree_CM() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        Menu menu = menuMgr.createContextMenu(this.m_tv_act4Import.getControl());
        this.m_tv_act4Import.getControl().setMenu(menu);
        ImportMPIView.m_instance.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.m_tv_act4Import);
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                try {
                    StructuredSelection ssel = (StructuredSelection)ImportMPIActionSection.this.m_tv_act4Import.getSelection();
                    if (!ssel.isEmpty()) {
                        Object o = ssel.getFirstElement();
                        if (((GroupTreeObject)o).getType().equals(BMUI.type_act)) {
                            manager.add((IAction)new ResetElementsAction(ImportMPIActionSection.this.m_tv_act4Import, ImportMPIActionSection.this.m_act4ImportRoot, ImportMPIActionSection.this.m_actionSection, ImportMPIView.RESET_TREE));
                        } else {
                            manager.add((IAction)new RenameAction(ImportMPIActionSection.this.m_tv_act4Import, ImportMPIActionSection.this.m_actionSection, ImportMPIView.RENAME));
                            manager.add((IAction)new RenameAction(ImportMPIActionSection.this.m_tv_act4Import, ImportMPIActionSection.this.m_actionSection, ImportMPIView.PREFIX));
                            manager.add((IAction)new RenameAction(ImportMPIActionSection.this.m_tv_act4Import, ImportMPIActionSection.this.m_actionSection, ImportMPIView.SUFFIX));
                            manager.add((IContributionItem)new Separator());
                            manager.add((IAction)new OverwriteAction(ImportMPIActionSection.this.m_tv_act4Import, ImportMPIActionSection.this.m_actionSection));
                            manager.add((IAction)new MergeAction(ImportMPIActionSection.this.m_tv_act4Import, ImportMPIActionSection.this.m_actionSection));
                            manager.add((IContributionItem)new Separator());
                            manager.add((IAction)new ResetElementsAction(ImportMPIActionSection.this.m_tv_act4Import, ImportMPIActionSection.this.m_act4ImportRoot, ImportMPIActionSection.this.m_actionSection, ImportMPIView.RESET_TREE));
                            manager.add((IContributionItem)new Separator());
                            manager.add((IAction)new RemoveFromImportAction(ImportMPIActionSection.this.m_tv_act4Import, ImportMPIActionSection.this.m_act4ImportRoot, ImportMPIActionSection.this.m_actionSection));
                        }
                    } else {
                        manager.add((IAction)new ResetElementsAction(ImportMPIActionSection.this.m_tv_act4Import, ImportMPIActionSection.this.m_act4ImportRoot, ImportMPIActionSection.this.m_actionSection, ImportMPIView.RESET_TREE));
                    }
                    manager.add((IContributionItem)new Separator());
                    manager.add((IAction)new ExpandCollapseAction(ImportMPIActionSection.this.m_tv_act4Import, "ExpandAll"));
                    manager.add((IAction)new ExpandCollapseAction(ImportMPIActionSection.this.m_tv_act4Import, "CollapseAll"));
                    manager.add((IContributionItem)new Separator());
                    manager.add((IAction)new ExpandCollapseAction(ImportMPIActionSection.this.m_tv_act4Import, "ExpandSubTree"));
                    manager.add((IAction)new ExpandCollapseAction(ImportMPIActionSection.this.m_tv_act4Import, "CollagpseSubTree"));
                }
                catch (RuntimeException e) {
                    RTLogger.print(5, "ImportMPI: Error creating context menu of import tree", e);
                }
            }
        });
    }

    public Map<String, String> getActGrps2Rename() {
        return this.m_actGrpNewAfterRename;
    }

    public List<GroupTreeObject> getActGrps4Import() {
        ArrayList<GroupTreeObject> list = new ArrayList<GroupTreeObject>();
        try {
            List<Object> tmp = new ArrayList();
            tmp = this.m_act4ImportRoot.getElements();
            for (GroupTreeObject groupTreeObject : tmp) {
                if (!this.isRelActGrpNew(groupTreeObject) && !this.isActGrpNewAfterRename(groupTreeObject) && !this.doOverwriteActionGrp(groupTreeObject) && !this.doMergeActionGrp(groupTreeObject)) continue;
                list.add(groupTreeObject);
            }
        }
        catch (Exception exception) {}
        return list;
    }

    public List<com.blixx.shared.Action> getActions4Import(GroupTreeObject actGrpGto) {
        List<Object> allIncommingActions = new ArrayList();
        ArrayList<com.blixx.shared.Action> actions4Import = new ArrayList<com.blixx.shared.Action>();
        GroupTreeObject origGTO = this.getOriginalElement(actGrpGto);
        if (origGTO != null) {
            allIncommingActions = this.m_allActionGrps.get(origGTO.getName());
            for (com.blixx.shared.Action action : allIncommingActions) {
                if (actGrpGto.findElement(action.m_label, BMUI.type_act) == null) continue;
                actions4Import.add(action);
            }
        }
        return actions4Import;
    }

    public int getTotalImportConflicts() {
        return this.m_totalImportConflicts;
    }

    public void expansionStateChanged(ExpansionEvent e) {
    }

    public void expansionStateChanging(ExpansionEvent e) {
    }

    public void selectionChanged(SelectionChangedEvent event) {
        Object obj = event.getSource();
        if (obj instanceof TreeViewer) {
            TreeViewer tv = (TreeViewer)obj;
            String type = (String)tv.getData(ImportMPIView.TREE_VIEWER_TYPE);
            if (type.equals(ImportMPIView.ACT)) {
                AddToImportAction action = new AddToImportAction(this.m_tv_act, this.m_actRoot, this.m_actionSection);
                this.m_gui.enableField(this.m_add_btn, action.isEnabled());
            } else if (type.equals(ImportMPIView.ACT_4IMPORT)) {
                RenameAction action1 = new RenameAction(this.m_tv_act4Import, this.m_actionSection, ImportMPIView.RENAME);
                this.m_rename_btn.setText(action1.getText());
                this.m_gui.enableField(this.m_rename_btn, action1.isEnabled());
                RenameAction action2 = new RenameAction(this.m_tv_act4Import, this.m_actionSection, ImportMPIView.PREFIX);
                this.m_addPrefix_btn.setText(action2.getText());
                this.m_gui.enableField(this.m_addPrefix_btn, action2.isEnabled());
                RenameAction action3 = new RenameAction(this.m_tv_act4Import, this.m_actionSection, ImportMPIView.SUFFIX);
                this.m_addSuffix_btn.setText(action3.getText());
                this.m_gui.enableField(this.m_addSuffix_btn, action3.isEnabled());
                MergeAction action4 = new MergeAction(this.m_tv_act4Import, this.m_actionSection);
                this.m_merge_btn.setText(action4.getText());
                this.m_gui.enableField(this.m_merge_btn, action4.isEnabled());
                OverwriteAction action5 = new OverwriteAction(this.m_tv_act4Import, this.m_actionSection);
                this.m_overwrite_btn.setText(action5.getText());
                this.m_gui.enableField(this.m_overwrite_btn, action5.isEnabled());
                ResetElementsAction action7 = new ResetElementsAction(this.m_tv_act4Import, this.m_act4ImportRoot, this.m_actionSection, ImportMPIView.RESET_TREE);
                this.m_resetTree_btn.setText(action7.getText());
                this.m_gui.enableField(this.m_resetTree_btn, action7.isEnabled());
                RemoveFromImportAction action8 = new RemoveFromImportAction(this.m_tv_act4Import, this.m_act4ImportRoot, this.m_actionSection);
                this.m_gui.enableField(this.m_removeFromImport_btn, action8.isEnabled());
                this.m_gui.enableField(this.m_remove_btn, action8.isEnabled());
            }
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        Object obj = e.getSource();
        if (obj instanceof Button) {
            Button btn = (Button)obj;
            String name = (String)btn.getData();
            if (name.equals(ADD_BTN)) {
                AddToImportAction action = new AddToImportAction(this.m_tv_act, this.m_actRoot, this.m_actionSection);
                action.run();
            } else if (name.equals(RENAME_BTN)) {
                RenameAction action = new RenameAction(this.m_tv_act4Import, this.m_actionSection, ImportMPIView.RENAME);
                action.run();
            } else if (name.equals(ADD_PREFIX_BTN)) {
                RenameAction action = new RenameAction(this.m_tv_act4Import, this.m_actionSection, ImportMPIView.PREFIX);
                action.run();
            } else if (name.equals(ADD_SUFFIX_BTN)) {
                RenameAction action = new RenameAction(this.m_tv_act4Import, this.m_actionSection, ImportMPIView.SUFFIX);
                action.run();
            } else if (name.equals(MERGE_BTN)) {
                MergeAction action = new MergeAction(this.m_tv_act4Import, this.m_actionSection);
                action.run();
            } else if (name.equals(OVERWRITE_BTN)) {
                OverwriteAction action = new OverwriteAction(this.m_tv_act4Import, this.m_actionSection);
                action.run();
            } else if (name.equals(RESET_TREE_BTN)) {
                ResetElementsAction action = new ResetElementsAction(this.m_tv_act4Import, this.m_act4ImportRoot, this.m_actionSection, ImportMPIView.RESET_TREE);
                action.run();
            } else if (name.equals(REMOVE_FROM_IMPORT_BTN) || name.equals(REMOVE_BTN)) {
                RemoveFromImportAction action = new RemoveFromImportAction(this.m_tv_act4Import, this.m_act4ImportRoot, this.m_actionSection);
                action.run();
            }
        }
    }

    public class AddToImportAction
    extends Action {
        private ImportMPIActionSection m_section;
        private Map<GroupTreeObject, String> m_elements;

        public AddToImportAction(TreeViewer tv, GroupTreeObject root, ImportMPIActionSection section) {
            super("addtoimportaction");
            this.m_section = null;
            this.m_elements = new HashMap<GroupTreeObject, String>();
            this.setId("addtoimportaction");
            this.setText("Add To Import");
            this.m_section = section;
            if (tv == null || this.m_section == null) {
                this.setEnabled(false);
                return;
            }
            StructuredSelection sel = (StructuredSelection)tv.getSelection();
            if (sel.size() > 0) {
                ArrayList<GroupTreeObject> map = new ArrayList<GroupTreeObject>();
                for (Object selected : sel) {
                    if (selected instanceof GroupTreeObjectLast) {
                        map.add((GroupTreeObjectLast)selected);
                        continue;
                    }
                    if (!(selected instanceof GroupTreeObject)) continue;
                    map.add((GroupTreeObject)selected);
                    map.addAll(((GroupTreeObject)selected).getAllGTOLs());
                }
                int i = 0;
                while (i < map.size()) {
                    this.m_elements.put((GroupTreeObject)map.get(i), null);
                    ++i;
                }
            }
            if (this.m_elements.size() == 0) {
                this.setEnabled(false);
            }
        }

        public void run() {
            if (!this.isEnabled()) {
                return;
            }
            if (this.m_section == null || this.m_elements.size() == 0) {
                return;
            }
            this.m_section.addToImport(this.m_elements);
        }
    }

    class ContentProviderActImportTree
    extends ViewContentProvider {
        @Override
        public Object[] getElements(Object obj) {
            Object[] oList = this.getChildren(obj);
            return oList;
        }
    }

    public class MergeAction
    extends Action {
        private ImportMPIActionSection m_section;
        private Map<String, GroupTreeObject> m_elements;

        public MergeAction(TreeViewer tv, ImportMPIActionSection section) {
            super("mergeaction");
            this.m_section = null;
            this.m_elements = new HashMap<String, GroupTreeObject>();
            this.setId("mergeaction");
            this.setText("Merge");
            this.m_section = section;
            if (tv == null || this.m_section == null) {
                this.setEnabled(false);
                return;
            }
            StructuredSelection sel = (StructuredSelection)tv.getSelection();
            if (!sel.isEmpty() && sel.size() > 0) {
                for (Object selected : sel) {
                    GroupTreeObject gto;
                    if (selected instanceof GroupTreeObjectLast || !(selected instanceof GroupTreeObject) || !this.m_section.doesRelActGrpExistWithConflict(gto = (GroupTreeObject)selected) || this.m_section.doMergeActionGrp(gto)) continue;
                    this.m_elements.put(gto.getName(), gto);
                }
            }
            if (this.m_elements.size() == 0) {
                this.setEnabled(false);
            }
        }

        public void run() {
            if (!this.isEnabled()) {
                return;
            }
            if (this.m_section == null || this.m_elements.size() == 0) {
                return;
            }
            this.m_section.resetActGroups(this.m_elements);
            this.m_section.mergeActionGrp(this.m_elements);
        }
    }

    public class OverwriteAction
    extends Action {
        private ImportMPIActionSection m_section;
        private Map<String, GroupTreeObject> m_elements;

        public OverwriteAction(TreeViewer tv, ImportMPIActionSection section) {
            super("overwriteaction");
            this.m_section = null;
            this.m_elements = new HashMap<String, GroupTreeObject>();
            this.setId("overwriteaction");
            this.setText("Overwrite");
            this.m_section = section;
            if (tv == null || this.m_section == null) {
                this.setEnabled(false);
                return;
            }
            StructuredSelection sel = (StructuredSelection)tv.getSelection();
            if (!sel.isEmpty() && sel.size() > 0) {
                for (Object selected : sel) {
                    GroupTreeObject gto = (GroupTreeObject)selected;
                    if (gto instanceof GroupTreeObjectLast || !(gto instanceof GroupTreeObject) || !this.m_section.doesRelActGrpExistWithConflict(gto) || this.m_section.doOverwriteActionGrp(gto)) continue;
                    this.m_elements.put(gto.getName(), gto);
                }
            }
            if (this.m_elements.size() == 0) {
                this.setEnabled(false);
            }
        }

        public void run() {
            if (!this.isEnabled()) {
                return;
            }
            if (this.m_section == null || this.m_elements.size() == 0) {
                return;
            }
            this.m_section.resetActGroups(this.m_elements);
            this.m_section.overwriteActionGrp(this.m_elements);
        }
    }

    public class RemoveFromImportAction
    extends Action {
        private ImportMPIActionSection m_section;
        private Map<GroupTreeObject, String> m_elements;

        public RemoveFromImportAction(TreeViewer tv, GroupTreeObject root, ImportMPIActionSection section) {
            super("skipimport");
            this.m_section = null;
            this.m_elements = new HashMap<GroupTreeObject, String>();
            this.setId("skipimport");
            this.setText("Remove");
            this.m_section = section;
            if (root == null || this.m_section == null) {
                this.setEnabled(false);
                return;
            }
            StructuredSelection sel = (StructuredSelection)tv.getSelection();
            if (sel.size() > 0) {
                ArrayList<GroupTreeObject> map = new ArrayList<GroupTreeObject>();
                for (Object selected : sel) {
                    if (selected instanceof GroupTreeObjectLast) {
                        if (this.m_section.doesActExistButMissingInImport((GroupTreeObjectLast)selected)) continue;
                        map.add((GroupTreeObjectLast)selected);
                        continue;
                    }
                    if (!(selected instanceof GroupTreeObject)) continue;
                    map.add((GroupTreeObject)selected);
                    map.addAll(((GroupTreeObject)selected).getAllGTOLs());
                }
                int i = 0;
                while (i < map.size()) {
                    this.m_elements.put((GroupTreeObject)map.get(i), null);
                    ++i;
                }
            }
            if (this.m_elements.size() == 0) {
                this.setEnabled(false);
            }
        }

        public void run() {
            if (!this.isEnabled()) {
                return;
            }
            if (this.m_section == null || this.m_elements.size() == 0) {
                return;
            }
            this.m_section.removeFromImport(this.m_elements);
        }
    }

    public class RenameAction
    extends Action {
        private TreeViewer m_tv;
        private ImportMPIActionSection m_section;
        private String m_title;
        private String m_type;
        private Map<GroupTreeObject, String> m_elements;

        public RenameAction(TreeViewer tv, ImportMPIActionSection section, String type) {
            super("renameaction");
            this.m_tv = null;
            this.m_section = null;
            this.m_title = null;
            this.m_type = null;
            this.m_elements = new HashMap<GroupTreeObject, String>();
            this.setId("renameaction");
            this.m_tv = tv;
            this.m_section = section;
            this.m_type = type;
            if (this.m_tv == null || this.m_section == null || type == null) {
                this.setEnabled(false);
            }
            if (this.m_type.equals(ImportMPIView.PREFIX)) {
                this.m_title = "Add Prefix";
            } else if (this.m_type.equals(ImportMPIView.SUFFIX)) {
                this.m_title = "Add Suffix";
            } else if (this.m_type.equals(ImportMPIView.RENAME)) {
                this.m_title = "Rename";
            } else {
                this.setText("Rename");
                this.setEnabled(false);
                return;
            }
            this.setText(this.m_title);
            StructuredSelection sel = (StructuredSelection)tv.getSelection();
            if (!sel.isEmpty()) {
                if (type.equals(ImportMPIView.RENAME)) {
                    GroupTreeObject gto;
                    Object obj;
                    if (sel.size() == 1 && !((obj = sel.getFirstElement()) instanceof GroupTreeObjectLast) && obj instanceof GroupTreeObject && !(gto = (GroupTreeObject)obj).getType().equals(BMUI.type_act)) {
                        this.m_elements.put((GroupTreeObject)obj, null);
                    }
                } else {
                    for (Object obj : sel) {
                        GroupTreeObject gto;
                        if (obj instanceof GroupTreeObjectLast || !(obj instanceof GroupTreeObject) || (gto = (GroupTreeObject)obj).getType().equals(BMUI.type_act)) continue;
                        this.m_elements.put((GroupTreeObject)obj, null);
                    }
                }
            }
            if (this.m_elements.size() == 0) {
                this.setEnabled(false);
            }
        }

        public void run() {
            String value;
            if (!this.isEnabled()) {
                return;
            }
            if (this.m_tv == null || this.m_section == null || this.m_elements.size() == 0) {
                return;
            }
            String title = null;
            String msg = null;
            String initalValue = "";
            if (this.m_type.equals(ImportMPIView.PREFIX)) {
                title = "Add Prefix";
                msg = "Prefix: ";
            } else if (this.m_type.equals(ImportMPIView.SUFFIX)) {
                title = "Add Suffix";
                msg = "Suffix: ";
            } else if (this.m_type.equals(ImportMPIView.RENAME)) {
                GroupTreeObject gto = this.m_elements.keySet().iterator().next();
                initalValue = gto.getName();
                title = "  Rename Action Grp";
            }
            InputDialog id = new InputDialog(this.m_tv.getControl().getShell(), "  " + title, msg, initalValue, (IInputValidator)new NameValidatorFile());
            id.setBlockOnOpen(true);
            InputDialog.setDefaultImage((Image)BMUI.IMAGE_PRODUCT);
            int res = id.open();
            if (res == 0 && (value = id.getValue()) != null && value.length() != 0) {
                if (this.m_type.equals(ImportMPIView.RENAME)) {
                    GroupTreeObject gto2Rename = this.m_elements.keySet().iterator().next();
                    HashMap<GroupTreeObject, String> elem = new HashMap<GroupTreeObject, String>();
                    elem.put(gto2Rename, null);
                    this.m_section.renameElements(elem, value, ImportMPIView.RENAME);
                } else if (this.m_type.equals(ImportMPIView.PREFIX) || this.m_type.equals(ImportMPIView.SUFFIX)) {
                    HashMap<GroupTreeObject, String> elem = new HashMap<GroupTreeObject, String>();
                    Iterator<GroupTreeObject> it = this.m_elements.keySet().iterator();
                    while (it.hasNext()) {
                        elem.put(it.next(), null);
                    }
                    this.m_section.renameElements(elem, value, this.m_type);
                }
            }
        }
    }

    public class ResetElementsAction
    extends Action {
        private ImportMPIActionSection m_section;
        private String m_type;
        private Map<String, GroupTreeObject> m_elements;

        public ResetElementsAction(TreeViewer tv, GroupTreeObject root, ImportMPIActionSection section, String type) {
            super("clearelements");
            this.m_section = null;
            this.m_type = null;
            this.m_elements = new HashMap<String, GroupTreeObject>();
            this.setId("clearelements");
            this.m_section = section;
            this.m_type = type;
            this.setText("Reset Group");
            if (tv == null || root == null || section == null || type == null) {
                this.setEnabled(false);
                return;
            }
            StructuredSelection sel = (StructuredSelection)tv.getSelection();
            if (!this.m_type.equals(ImportMPIView.RESET_TREE)) {
                if (this.m_type.equals(RESET_ACTION_GRP)) {
                    this.setText("Reset Group");
                    if (sel.size() > 0) {
                        for (Object selected : sel) {
                            if (selected instanceof GroupTreeObjectLast || !(selected instanceof GroupTreeObject)) continue;
                            GroupTreeObject gto = (GroupTreeObject)selected;
                            this.m_elements.put(gto.getPath(), gto);
                        }
                    }
                    if (this.m_elements.size() == 0) {
                        this.setEnabled(false);
                    } else if (this.m_elements.size() > 1) {
                        this.setText("Reset Groups");
                    }
                    return;
                }
                this.setText("Reset");
                this.setEnabled(false);
                return;
            }
            this.setText("Reset Tree");
        }

        public void run() {
            if (!this.isEnabled()) {
                return;
            }
            if (this.m_type.equals(ImportMPIView.RESET_TREE)) {
                this.m_section.updateSection(ImportMPIActionSection.this.m_importDir, true);
            } else if (this.m_type.equals(RESET_ACTION_GRP)) {
                this.m_section.resetActGroups(this.m_elements);
            }
        }
    }

    class StyledLabelProviderActImportTree
    extends StyledCellLabelProvider {
        ImportMPIActionSection m_actSection = null;

        public StyledLabelProviderActImportTree(ImportMPIActionSection section) {
            this.m_actSection = section;
        }

        public void update(ViewerCell cell) {
            Object element = cell.getElement();
            Image defaultIcon = BMUI.IMAGE_FOLDER_DEFAULT;
            Image icon = null;
            cell.setBackground(null);
            if (element instanceof GroupTreeObjectLast) {
                GroupTreeObjectLast actGtol = (GroupTreeObjectLast)element;
                cell.setText(actGtol.getName());
                icon = BMUI.IMAGE_MAP.get(actGtol.getIcon());
                GroupTreeObject actGrpGto = this.m_actSection.getParentActGrp(actGtol);
                if (!this.m_actSection.doesActExistButMissingInImport(actGtol)) {
                    if (ImportMPIActionSection.this.isRelActGrpNew(actGrpGto)) {
                        cell.setForeground(BMUI.color_green);
                    } else if (this.m_actSection.doesRelActGrpExistWithoutConflict(actGrpGto)) {
                        cell.setForeground(BMUI.color_darkGrey2);
                    } else if (this.m_actSection.doesRelActGrpExistWithConflict(actGrpGto)) {
                        if (this.m_actSection.doOverwriteActionGrp(actGrpGto)) {
                            cell.setForeground(BMUI.color_selected);
                        } else if (!this.m_actSection.doMergeActionGrp(actGrpGto)) {
                            if (this.m_actSection.isActionNew(actGtol)) {
                                cell.setForeground(BMUI.color_green);
                            } else if (ImportMPIActionSection.this.m_actionSection.doesActionExist(actGtol)) {
                                cell.setForeground(BMUI.color_darkGrey2);
                            }
                        }
                    }
                }
            } else if (element instanceof GroupTreeObject) {
                GroupTreeObject actGrpGto = (GroupTreeObject)element;
                cell.setText(actGrpGto.getName());
                String type = actGrpGto.getType();
                if (type != null) {
                    icon = BMUI.IMAGE_MAP.get(type);
                }
                if (this.m_actSection.isRelActGrpNew(actGrpGto)) {
                    cell.setForeground(BMUI.color_green);
                } else if (this.m_actSection.doesRelActGrpExistWithoutConflict(actGrpGto)) {
                    cell.setForeground(BMUI.color_darkGrey2);
                } else if (this.m_actSection.doesRelActGrpExistWithConflict(actGrpGto)) {
                    if (this.m_actSection.doOverwriteActionGrp(actGrpGto)) {
                        cell.setForeground(BMUI.color_selected);
                    } else if (!this.m_actSection.doMergeActionGrp(actGrpGto)) {
                        cell.setForeground(BMUI.color_critical);
                    }
                }
            }
            if (icon == null) {
                icon = defaultIcon;
            }
            cell.setImage(icon);
            super.update(cell);
        }
    }

    class StyledLabelProviderActTree
    extends StyledCellLabelProvider {
        ImportMPIActionSection m_actSection = null;

        public StyledLabelProviderActTree(ImportMPIActionSection section) {
            this.m_actSection = section;
        }

        public void update(ViewerCell cell) {
            Object element = cell.getElement();
            Image defaultIcon = BMUI.IMAGE_FOLDER_DEFAULT;
            Image icon = null;
            if (element instanceof GroupTreeObjectLast) {
                GroupTreeObjectLast gtol = (GroupTreeObjectLast)element;
                cell.setText(gtol.getName());
                icon = BMUI.IMAGE_MAP.get(gtol.getIcon());
            } else if (element instanceof GroupTreeObject) {
                GroupTreeObject gto = (GroupTreeObject)element;
                cell.setText(gto.getName());
                String type = gto.getTreeObject().getType();
                if (type != null) {
                    icon = BMUI.IMAGE_MAP.get(type);
                }
            }
            if (icon == null) {
                icon = defaultIcon;
            }
            cell.setImage(icon);
            super.update(cell);
        }
    }
}

