/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.gui.dialogs.NameValidatorHostGroup;
import com.blixx.boom.gui.dialogs.ShowMessageBox;
import com.blixx.boom.gui.policies.PolicyManager;
import com.blixx.boom.gui.policies.ViewContentProvider;
import com.blixx.boom.gui.utils.GUIDisplayElements;
import com.blixx.boom.gui.utils.STreeViewer;
import com.blixx.boom.gui.utils.XMLTree;
import com.blixx.boom.gui.views.FancyToolTipSupport;
import com.blixx.boom.gui.views.ImportMPIView;
import com.blixx.boom.gui.views.actions.ExpandCollapseAction;
import com.blixx.log.RTLogger;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.GroupTreeObjectLast;
import com.blixx.shared.utils.ITreeObject;
import com.blixx.shared.utils.TreeObject;
import java.io.File;
import java.io.FileInputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class ImportMPIAsnSection
extends Section
implements IExpansionListener,
SelectionListener,
ISelectionChangedListener {
    private ImportMPIAsnSection m_asnSection = null;
    private ImportMPIView m_importMPIView = null;
    private String m_polDir = null;
    private File m_asnGrpFile = null;
    private GroupTreeObject m_existingAsnTree = null;
    private GroupTreeObject m_existingPolicyTree = null;
    private GroupTreeObject m_asnRoot = null;
    private GroupTreeObject m_asn4ImportRoot = null;
    private TreeViewer m_tv_asn = null;
    private TreeViewer m_tv_asn4Import = null;
    private ContentProviderAsnImportTree m_treeContentProvider_final = null;
    private GUIDisplayElements m_gui = null;
    private FormToolkit m_toolkit = null;
    private Composite m_sectionClient = null;
    private Group m_importTree_grp = null;
    private Group m_finalTree_grp = null;
    private Text m_asnFooter = null;
    private Text m_asn4ImportFooter = null;
    public Map<String, GroupTreeObject> m_allAsnGroups = new HashMap<String, GroupTreeObject>();
    public Map<String, GroupTreeObject> m_asnGroupsNew = new HashMap<String, GroupTreeObject>();
    public Map<String, GroupTreeObject> m_asnGroupsExistWithoutConflict = new HashMap<String, GroupTreeObject>();
    public Map<String, GroupTreeObject> m_asnGroupsExistWithConflict = new HashMap<String, GroupTreeObject>();
    public Map<String, GroupTreeObject> m_allAsnElems = new HashMap<String, GroupTreeObject>();
    public Map<String, GroupTreeObject> m_asnElementsNew = new HashMap<String, GroupTreeObject>();
    public Map<String, GroupTreeObject> m_asnElemsExist = new HashMap<String, GroupTreeObject>();
    public Map<String, List<GroupTreeObjectLast>> m_asnElemsFoundWithDifferentPath = new HashMap<String, List<GroupTreeObjectLast>>();
    public Map<String, GroupTreeObject> m_asnElemsNotInImport_butExistOnSrv = new HashMap<String, GroupTreeObject>();
    public Map<String, GroupTreeObjectLast> m_asnElemsWithBrokenLink_removed = new HashMap<String, GroupTreeObjectLast>();
    public Map<String, GroupTreeObjectLast> m_asnElemsWithBrokenLink_toImport = new HashMap<String, GroupTreeObjectLast>();
    public Map<String, GroupTreeObject> m_asnGrpNewAfterRename = new HashMap<String, GroupTreeObject>();
    public Map<String, GroupTreeObject> m_asnGrpsMerge = new HashMap<String, GroupTreeObject>();
    public Map<String, GroupTreeObject> m_elementsSkipImport = new HashMap<String, GroupTreeObject>();
    public static String RESET_ACTION_GRP = "RESET_ASN_GRP";
    private static String ADD_BTN = "ADD_BTN";
    private static String REMOVE_BTN = "REMOVE_BTN";
    private static String RENAME_BTN = "RENAME_BTN";
    private static String ADD_PREFIX_BTN = "ADD_PREFIX_BTN";
    private static String ADD_SUFFIX_BTN = "ADD_SUFFIX_BTN";
    private static String MERGE_BTN = "MERGE_BTN";
    private static String RESET_TREE_BTN = "RESET_TREE_BTN";
    private static String REMOVE_FROM_IMPORT_BTN = "REMOVE_FROM_IMPORT_BTN";
    private static String RESOLVE_BTN = "SOLVE_BTN";
    private Button m_add_btn = null;
    private Button m_remove_btn = null;
    private Button m_rename_btn = null;
    private Button m_addPrefix_btn = null;
    private Button m_addSuffix_btn = null;
    private Button m_merge_btn = null;
    private Button m_resetTree_btn = null;
    private Button m_removeFromImport_btn = null;
    private Button m_resolve_btn = null;
    Listener paintListenerAsnTree = new Listener(){

        public void handleEvent(Event event) {
            GroupTreeObjectLast gtol;
            Image icon;
            TreeItem ti;
            Object o;
            Widget obj = event.item;
            if (obj instanceof TreeItem && (o = (ti = (TreeItem)event.item).getData()) instanceof GroupTreeObjectLast && (icon = ImportMPIAsnSection.this.getIcon(gtol = (GroupTreeObjectLast)o, ImportMPIView.ASN)) != null) {
                switch (event.type) {
                    case 41: {
                        Rectangle rect = icon.getBounds();
                        event.width += rect.width;
                        event.height = Math.max(event.height, rect.height + 2);
                        break;
                    }
                    case 42: {
                        int x = event.x + event.width;
                        Rectangle rect = icon.getBounds();
                        int offset = Math.max(0, (event.height - rect.height) / 2);
                        event.gc.drawImage(icon, x, event.y + offset);
                    }
                }
            }
        }
    };
    Listener paintListenerAsnImportTree = new Listener(){

        public void handleEvent(Event event) {
            Widget obj = event.item;
            if (obj instanceof TreeItem) {
                TreeItem ti = (TreeItem)event.item;
                Object o = ti.getData();
                Image icon = null;
                if (o instanceof GroupTreeObject) {
                    GroupTreeObject gto = (GroupTreeObject)o;
                    if (gto.getType().equals(BMUI.type_toplevel)) {
                        return;
                    }
                    icon = ImportMPIAsnSection.this.getIcon(gto, ImportMPIView.ASN_4IMPORT);
                }
                if (icon != null) {
                    switch (event.type) {
                        case 41: {
                            Rectangle rect = icon.getBounds();
                            event.width += rect.width;
                            event.height = Math.max(event.height, rect.height + 2);
                            break;
                        }
                        case 42: {
                            int x = event.x + event.width;
                            Rectangle rect = icon.getBounds();
                            int offset = Math.max(0, (event.height - rect.height) / 2);
                            event.gc.drawImage(icon, x, event.y + offset);
                        }
                    }
                }
            }
        }
    };

    public ImportMPIAsnSection(Composite parent, ImportMPIView importMPIView) {
        super(parent, 578);
        this.setText("Assignments");
        this.setLayoutData(new GridData(4, 128, true, false));
        this.m_asnSection = this;
        this.m_importMPIView = importMPIView;
    }

    public void initSection() {
        this.m_gui = new GUIDisplayElements();
        this.m_toolkit = BMUI.getFormToolkit(Display.getCurrent());
        this.m_sectionClient = this.m_toolkit.createComposite((Composite)this.m_asnSection, 0);
        this.m_sectionClient.setLayout((Layout)new GridLayout(2, false));
        this.m_sectionClient.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite treeComp = new Composite(this.m_sectionClient, 0);
        GridLayout gl = new GridLayout(3, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        treeComp.setLayout((Layout)gl);
        treeComp.setLayoutData((Object)new GridData(4, 4, true, true));
        this.m_importTree_grp = new Group(treeComp, 32);
        this.m_importTree_grp.setText("assignmentGroups.xml");
        this.m_importTree_grp.setLayout((Layout)new GridLayout(1, false));
        this.m_importTree_grp.setLayoutData((Object)new GridData(4, 4, true, true));
        this.m_tv_asn = new STreeViewer((Composite)this.m_importTree_grp, 268438274);
        this.m_tv_asn.setData(ImportMPIView.TREE_VIEWER_TYPE, (Object)ImportMPIView.ASN);
        this.m_tv_asn.getTree().setLayoutData((Object)ImportMPIView.m_sectionTree_gd);
        this.m_tv_asn.setUseHashlookup(true);
        this.m_tv_asn.setContentProvider((IContentProvider)new ViewContentProvider());
        this.m_tv_asn.setLabelProvider((IBaseLabelProvider)new StyledLabelProviderAsnTree(this, this.m_tv_asn));
        this.m_tv_asn.setInput((Object)this.m_asnRoot);
        this.m_tv_asn.addSelectionChangedListener((ISelectionChangedListener)this);
        this.m_tv_asn.getTree().addListener(41, this.paintListenerAsnTree);
        this.m_tv_asn.getTree().addListener(42, this.paintListenerAsnTree);
        this.createXMLTree_CM();
        FancyToolTipSupport.enableFor((ColumnViewer)this.m_tv_asn, 2);
        this.m_tv_asn.getTree().setToolTipText("");
        this.m_asnFooter = this.m_gui.addTextReadOnlyNoBorder((Composite)this.m_importTree_grp, null, "", 1, 1, 1, 1, BMUI.font_arial8);
        this.updateTreeFooter(this.m_tv_asn);
        Composite btn1Comp = new Composite(treeComp, 0);
        gl = new GridLayout(1, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        btn1Comp.setLayout((Layout)gl);
        btn1Comp.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        this.m_add_btn = this.m_gui.addButton(btn1Comp, ADD_BTN, " >> ", false, this);
        this.m_remove_btn = this.m_gui.addButton(btn1Comp, REMOVE_BTN, " << ", false, this);
        this.m_finalTree_grp = new Group(treeComp, 32);
        this.m_finalTree_grp.setText("Preview");
        this.m_finalTree_grp.setLayout((Layout)new GridLayout(1, false));
        this.m_finalTree_grp.setLayoutData((Object)new GridData(4, 4, true, true));
        this.m_tv_asn4Import = new STreeViewer((Composite)this.m_finalTree_grp, 268438274);
        this.m_tv_asn4Import.setData(ImportMPIView.TREE_VIEWER_TYPE, (Object)ImportMPIView.ASN_4IMPORT);
        this.m_tv_asn4Import.getTree().setLayoutData((Object)ImportMPIView.m_sectionTree_gd);
        this.m_tv_asn4Import.setUseHashlookup(true);
        this.m_treeContentProvider_final = new ContentProviderAsnImportTree();
        this.m_tv_asn4Import.setContentProvider((IContentProvider)this.m_treeContentProvider_final);
        this.m_tv_asn4Import.setLabelProvider((IBaseLabelProvider)new StyledLabelProviderAsnImportTree(this));
        this.m_tv_asn4Import.setInput((Object)this.m_asn4ImportRoot);
        this.m_tv_asn4Import.addSelectionChangedListener((ISelectionChangedListener)this);
        this.m_tv_asn4Import.getTree().addListener(41, this.paintListenerAsnImportTree);
        this.m_tv_asn4Import.getTree().addListener(42, this.paintListenerAsnImportTree);
        this.createFinalTree_CM();
        FancyToolTipSupport.enableFor((ColumnViewer)this.m_tv_asn4Import, 2);
        this.m_tv_asn4Import.getTree().setToolTipText("");
        this.m_asn4ImportFooter = this.m_gui.addTextReadOnlyNoBorder((Composite)this.m_finalTree_grp, null, "", 1, 1, 1, 1, BMUI.font_arial8);
        this.updateTreeFooter(this.m_tv_asn4Import);
        Composite btnComp = new Composite(this.m_sectionClient, 0);
        btnComp.setLayout((Layout)new GridLayout(1, false));
        btnComp.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.m_rename_btn = this.m_gui.addButton(btnComp, RENAME_BTN, "Rename", false, this);
        this.m_rename_btn.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.m_addPrefix_btn = this.m_gui.addButton(btnComp, ADD_PREFIX_BTN, "Add Prefix", false, this);
        this.m_addPrefix_btn.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.m_addSuffix_btn = this.m_gui.addButton(btnComp, ADD_SUFFIX_BTN, "Add Suffix", false, this);
        this.m_addSuffix_btn.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.m_merge_btn = this.m_gui.addButton(btnComp, MERGE_BTN, "Merge", false, this);
        this.m_merge_btn.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.m_resetTree_btn = this.m_gui.addButton(btnComp, RESET_TREE_BTN, "Reset Tree", false, this);
        this.m_resetTree_btn.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.m_removeFromImport_btn = this.m_gui.addButton(btnComp, REMOVE_FROM_IMPORT_BTN, "Remove", false, this);
        this.m_removeFromImport_btn.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.m_resolve_btn = this.m_gui.addButton(btnComp, RESOLVE_BTN, "Resolve Links", false, this);
        this.m_resolve_btn.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.setClient((Control)this.m_sectionClient);
        this.addExpansionListener(this);
    }

    public void updateSection(String polDir, boolean resetAction) {
        if (!this.isEnabled()) {
            return;
        }
        this.m_allAsnGroups.clear();
        this.m_asnGroupsNew.clear();
        this.m_asnGroupsExistWithoutConflict.clear();
        this.m_asnGroupsExistWithConflict.clear();
        this.m_allAsnElems.clear();
        this.m_asnElemsExist.clear();
        this.m_asnElemsNotInImport_butExistOnSrv.clear();
        this.m_asnElementsNew.clear();
        this.m_asnElemsFoundWithDifferentPath.clear();
        this.m_asnElemsWithBrokenLink_removed.clear();
        this.m_asnElemsWithBrokenLink_toImport.clear();
        this.m_asnGrpNewAfterRename.clear();
        this.m_asnGrpsMerge.clear();
        this.m_elementsSkipImport.clear();
        this.m_polDir = polDir;
        this.m_importMPIView.updateProgressBar("Reading Aggignment groups", 0, 4);
        this.loadAsnGrpXMLFile();
        if (this.m_asnRoot != null) {
            try {
                this.m_importMPIView.updateProgressBar("Reading Aggignment groups", 1, 4);
                this.identifyBrokenLinks();
                this.m_asn4ImportRoot = this.m_asnRoot.clone();
                this.m_importMPIView.updateProgressBar("Reading Aggignment groups", 2, 4);
                this.processClonedTree();
                this.m_importMPIView.updateProgressBar("Reading Aggignment groups", 3, 4);
                this.checkConflicts();
            }
            catch (CloneNotSupportedException e) {
                this.m_asn4ImportRoot = null;
                RTLogger.print(5, "ImportMPI: Error cloning import tree", e);
            }
        }
        int expLevel = 2;
        if (resetAction) {
            expLevel = -1;
        }
        this.m_importMPIView.updateProgressBar("Reading Aggignment groups", 4, 4);
        this.refreshTree(this.m_tv_asn, this.m_asnRoot, 2);
        this.refreshTree(this.m_tv_asn4Import, this.m_asn4ImportRoot, expLevel);
        if (this.m_asnRoot == null || this.m_asnRoot.getElements().size() == 0) {
            this.setExpanded(false);
        } else {
            this.setExpanded(true);
        }
    }

    public void clearSection() {
        this.m_asnRoot = null;
        this.m_asn4ImportRoot = null;
        this.refreshTree(this.m_tv_asn, this.m_asnRoot, 0);
        this.refreshTree(this.m_tv_asn4Import, this.m_asn4ImportRoot, 0);
    }

    private void loadAsnGrpXMLFile() {
        this.m_asnRoot = null;
        this.m_asn4ImportRoot = null;
        this.m_existingAsnTree = PolicyManager.getInstance().getAsnTree();
        if (this.m_polDir != null) {
            String asnGrpXMLFileName = String.valueOf(this.m_polDir) + File.separator + "assignmentGroups.xml";
            this.m_asnGrpFile = new File(asnGrpXMLFileName);
            if (!this.m_asnGrpFile.exists()) {
                RTLogger.print(5, "assignmentGroups.xml not found - no Assignments to import ");
                new ShowMessageBox("  MPI Import", "No Assignments (assignmentGroups.xml) found to import: : \n" + this.m_polDir, 2);
            } else {
                try {
                    XMLTree xt = new XMLTree();
                    FileInputStream fis = new FileInputStream(this.m_asnGrpFile);
                    this.m_asnRoot = xt.parseXML(fis, true);
                    fis.close();
                }
                catch (Throwable e) {
                    this.m_asnGrpFile = null;
                    RTLogger.print(5, "Error parsing assignmentGroups.xml", e);
                }
            }
        }
    }

    private void identifyBrokenLinks() {
        GroupTreeObject polRoot = this.m_importMPIView.getPolSection().getPolRoot();
        GroupTreeObject binRoot = this.m_importMPIView.getBinSection().getBinRoot();
        List<Object> elements = new ArrayList();
        elements = this.m_asnRoot.getAllElements();
        int i = 0;
        while (i < elements.size()) {
            GroupTreeObject gto2 = (GroupTreeObject)elements.get(i);
            if (gto2 instanceof GroupTreeObjectLast) {
                GroupTreeObjectLast gtol = (GroupTreeObjectLast)gto2;
                String type = gtol.getTreeObject().getType();
                if (type.equals(BMUI.type_mon) || type.equals(BMUI.type_msg)) {
                    if (polRoot != null && polRoot.findElement(gtol.getName(), type) != null) {
                        gtol.setLinkOK(true);
                        if (type.equals(BMUI.type_mon)) {
                            gtol.setIcon("IMAGE_MON_LNK");
                        } else {
                            gtol.setIcon("IMAGE_MSG_LNK");
                        }
                    } else {
                        gtol.setLinkOK(false);
                        if (type.equals(BMUI.type_mon)) {
                            gtol.setIcon("IMAGE_MON_LNK_BROKEN");
                        } else {
                            gtol.setIcon("IMAGE_MSG_LNK__BROKEN");
                        }
                    }
                } else if (type.equals(BMUI.type_assignment_bin)) {
                    if (binRoot != null && binRoot.findFirstGroupByName(gtol.getName()) != null) {
                        gtol.setLinkOK(true);
                        gtol.setIcon("IMAGE_PKG_LNK");
                    } else {
                        gtol.setLinkOK(false);
                        gtol.setIcon("IMAGE_PKG_LNK_BROKEN");
                    }
                }
            }
            ++i;
        }
    }

    public int getBrokenLinksCount(GroupTreeObject root) {
        LinkedList<GroupTreeObjectLast> brokenLinkedPaths = new LinkedList<GroupTreeObjectLast>();
        if (root != null && root.hasElements().booleanValue()) {
            List<GroupTreeObject> elements = root.getAllElements();
            for (GroupTreeObject o : elements) {
                GroupTreeObjectLast gtol;
                if (!(o instanceof GroupTreeObjectLast) || (gtol = (GroupTreeObjectLast)o).isLinkOK()) continue;
                brokenLinkedPaths.add(gtol);
            }
        }
        return brokenLinkedPaths.size();
    }

    private void processClonedTree() {
        List<GroupTreeObject> elements = this.m_asn4ImportRoot.getAllElements();
        for (GroupTreeObject gto : elements) {
            GroupTreeObject orig = this.m_asnRoot.searchPath(gto.getPath(), gto.getType());
            if (orig == null) continue;
            gto.getTreeObject().setObject(orig.getPath());
        }
    }

    private void checkConflicts() {
        this.m_existingPolicyTree = this.m_importMPIView.getExistingPolTree();
        GroupTreeObject inR = this.m_asnRoot.getFirstChild("Assignments");
        List<GroupTreeObject> asnGrpsListNew = inR.getElements();
        int i = 0;
        while (i < asnGrpsListNew.size()) {
            GroupTreeObject asnGrpNew = asnGrpsListNew.get(i);
            String asnGrpNewName = asnGrpNew.getName();
            this.m_allAsnGroups.put(asnGrpNewName, asnGrpNew);
            this.checkIncomingAsnGroup(asnGrpNew);
            this.checkExistingAsnGroup(asnGrpNew);
            ++i;
        }
        GroupTreeObject asn = this.m_asnRoot.getFirstChild("Assignments");
        List<GroupTreeObject> asnGrpsNew = asn.getElements();
        int i2 = 0;
        while (i2 < asnGrpsNew.size()) {
            List<GroupTreeObject> allChild = asnGrpsNew.get(i2).getAllElements();
            for (GroupTreeObject gto : allChild) {
                GroupTreeObjectLast gtol;
                String type = gto.getType();
                if (type.equals(BMUI.type_mon) || type.equals(BMUI.type_msg)) {
                    gtol = (GroupTreeObjectLast)gto;
                    String linkName = gtol.getName();
                    String linkedPath = gtol.getLinkedPath();
                    if (this.m_importMPIView.getPolSection().doesLinkedPathExistInXML(linkedPath, type)) continue;
                    if (this.m_existingPolicyTree.searchPath(linkedPath, type) == null) {
                        this.m_asnElemsWithBrokenLink_removed.put(gtol.getPath(), gtol);
                        this.m_importMPIView.removeElementFromTree(this.m_asn4ImportRoot, linkName, gtol.getType());
                        continue;
                    }
                    this.m_asnElemsWithBrokenLink_toImport.put(gtol.getPath(), gtol);
                    continue;
                }
                if (!gto.getTreeObject().getType().equals(BMUI.type_assignment_bin)) continue;
                gtol = (GroupTreeObjectLast)gto;
                String binName = gtol.getName();
                if (this.m_importMPIView.getBinSection().isLinkedBinaryPartOfImport(binName)) continue;
                this.m_asnElemsWithBrokenLink_toImport.put(gtol.getPath(), gtol);
            }
            ++i2;
        }
    }

    private void checkIncomingAsnGroup(GroupTreeObject asnGrpNew) {
        String asnGrpName = asnGrpNew.getName();
        boolean existWithAllElements = true;
        GroupTreeObject asnGrpExist = this.m_existingAsnTree.getFirstChild("Assignments").getChild(asnGrpName, BMUI.type_assignment_pol);
        if (asnGrpExist == null) {
            this.m_asnGroupsNew.put(asnGrpName, asnGrpNew);
            for (GroupTreeObject gtoIN : asnGrpNew.getAllElements()) {
                if (!(gtoIN instanceof GroupTreeObjectLast)) continue;
                this.m_allAsnElems.put(gtoIN.getPath(), gtoIN);
            }
        } else {
            HashMap tmp = new HashMap();
            for (GroupTreeObject gtoIN : asnGrpNew.getAllElements()) {
                if (!(gtoIN instanceof GroupTreeObjectLast)) continue;
                this.m_allAsnElems.put(gtoIN.getPath(), gtoIN);
                String newName = gtoIN.getName();
                String newPath = gtoIN.getPath();
                String newType = gtoIN.getType();
                GroupTreeObject gtoFound = this.m_existingAsnTree.searchPath(newPath, newType);
                if (gtoFound != null) {
                    this.m_asnElemsExist.put(newPath, gtoIN);
                } else {
                    this.m_asnElementsNew.put(newPath, gtoIN);
                    existWithAllElements = false;
                }
                ArrayList<GroupTreeObjectLast> foundLinks = new ArrayList<GroupTreeObjectLast>();
                List<GroupTreeObject> list = asnGrpExist.getAllElements();
                for (GroupTreeObject gto : list) {
                    GroupTreeObjectLast gtolExist;
                    if (!(gto instanceof GroupTreeObjectLast) || !newName.equals((gtolExist = (GroupTreeObjectLast)gto).getName()) || !newType.equals(gtolExist.getType()) || newPath.equals(gtolExist.getPath())) continue;
                    foundLinks.add(gtolExist);
                }
                if (foundLinks.size() <= 0) continue;
                tmp.put(newPath, foundLinks);
            }
            if (existWithAllElements) {
                this.m_asnGroupsExistWithoutConflict.put(asnGrpName, asnGrpNew);
            } else {
                this.m_asnGroupsExistWithConflict.put(asnGrpName, asnGrpNew);
                if (tmp.size() > 0) {
                    this.m_asnElemsFoundWithDifferentPath.putAll(tmp);
                }
            }
        }
    }

    private void cleanStatus(GroupTreeObject asnGrpNew) {
        this.m_asnGroupsNew.remove(asnGrpNew.getName());
        this.m_asnGroupsExistWithoutConflict.remove(asnGrpNew.getName());
        this.m_asnGroupsExistWithConflict.remove(asnGrpNew.getName());
        this.m_asnGrpsMerge.remove(asnGrpNew.getName());
        String path = String.valueOf(asnGrpNew.getPath()) + '/';
        this.cleanStartedWith(path, this.m_allAsnElems.keySet());
        this.cleanStartedWith(path, this.m_asnElemsExist.keySet());
        this.cleanStartedWith(path, this.m_asnElementsNew.keySet());
        this.cleanStartedWith(path, this.m_asnElemsFoundWithDifferentPath.keySet());
        this.cleanStartedWith(path, this.m_asnElemsWithBrokenLink_toImport.keySet());
        this.cleanStartedWith(path, this.m_asnElemsWithBrokenLink_removed.keySet());
    }

    private void cleanStartedWith(String path, Collection<String> keySet) {
        Iterator<String> it0 = keySet.iterator();
        while (it0.hasNext()) {
            String elPath = it0.next();
            if (!elPath.startsWith(path)) continue;
            it0.remove();
        }
    }

    private void checkExistingAsnGroup(GroupTreeObject asnGrpNew) {
        String name = asnGrpNew.getName();
        GroupTreeObject asnGrpExist = this.m_existingAsnTree.getFirstChild("Assignments").getChild(name, BMUI.type_assignment_pol);
        if (asnGrpExist != null) {
            List<GroupTreeObject> list = asnGrpExist.getAllElements();
            for (GroupTreeObject gto : list) {
                GroupTreeObject gtoNew;
                if (gto instanceof GroupTreeObjectLast) {
                    GroupTreeObjectLast gtolExist = (GroupTreeObjectLast)gto;
                    GroupTreeObject gtoNew2 = asnGrpNew.searchPath(gtolExist.getPath(), gtolExist.getType());
                    if (gtoNew2 != null) continue;
                    this.m_asnElemsNotInImport_butExistOnSrv.put(gtolExist.getPath(), gtolExist);
                    this.m_importMPIView.addElement2Tree(this.m_asn4ImportRoot, gtolExist, gtolExist.getParentPath());
                    continue;
                }
                if (!(gto instanceof GroupTreeObject) || (gtoNew = asnGrpNew.searchPath(gto.getPath(), gto.getType())) != null) continue;
                this.m_asnElemsNotInImport_butExistOnSrv.put(gto.getPath(), gto);
                this.m_importMPIView.addElement2Tree(this.m_asn4ImportRoot, gto, gto.getParentPath());
            }
        }
    }

    public void updateTreeFooter(TreeViewer tv) {
        StringBuffer sb = new StringBuffer();
        String type = (String)tv.getData(ImportMPIView.TREE_VIEWER_TYPE);
        if (type.equalsIgnoreCase(ImportMPIView.ASN)) {
            int totalLinks = 0;
            int totalAsnGrps = 0;
            int conflicts = 0;
            if (this.m_asnRoot != null) {
                for (GroupTreeObject elem : this.m_asnRoot.getAllElements()) {
                    if (!(elem instanceof GroupTreeObjectLast)) continue;
                    ++totalLinks;
                }
                totalAsnGrps = this.m_allAsnGroups.size();
                conflicts = this.getNumberOfConflicts(tv, this.m_asnRoot);
            }
            sb.append("Groups (").append(totalAsnGrps).append(")").append("  Links (").append(totalLinks).append(")").append("  Invalid Links (").append(conflicts).append(")");
            this.m_asnFooter.setText(sb.toString());
            this.m_asnFooter.pack(true);
        } else if (type.equalsIgnoreCase(ImportMPIView.ASN_4IMPORT)) {
            int totalLinks = 0;
            int totalAsnGrps = 0;
            int conflicts = 0;
            int brokenLinks = 0;
            if (this.m_asn4ImportRoot != null) {
                for (GroupTreeObject elem : this.m_asn4ImportRoot.getAllElements()) {
                    GroupTreeObjectLast gtol;
                    GroupTreeObject origGTO;
                    if (!(elem instanceof GroupTreeObjectLast) || (origGTO = this.getOriginalElementFromImportTree(gtol = (GroupTreeObjectLast)elem)) == null || this.m_asnElemsNotInImport_butExistOnSrv.containsKey(origGTO.getPath()) && this.m_asnElemsNotInImport_butExistOnSrv.containsKey(origGTO.getPath())) continue;
                    ++totalLinks;
                }
                brokenLinks = this.getNumberOfMissingLinkedElemsInImportTree(this.m_asn4ImportRoot);
                if (this.m_asn4ImportRoot.getFirstChild("Assignments") != null) {
                    totalAsnGrps = this.m_asn4ImportRoot.getFirstChild("Assignments").getElements().size();
                }
                conflicts = this.getNumberOfConflicts(tv, this.m_asn4ImportRoot);
            }
            sb.append("Groups (").append(totalAsnGrps).append(")").append("  Links (").append(totalLinks).append(")").append("  Group with Conflicts (").append(conflicts).append(")").append("  Broken Links (").append(brokenLinks).append(")");
            this.m_asn4ImportFooter.setText(sb.toString());
            this.m_asn4ImportFooter.pack(true);
        }
    }

    public int getNumberOfConflicts(TreeViewer tv, GroupTreeObject gto) {
        int count;
        block4: {
            String type;
            block3: {
                count = 0;
                if (tv == null || gto == null || gto instanceof GroupTreeObjectLast) {
                    return count;
                }
                type = (String)tv.getData(ImportMPIView.TREE_VIEWER_TYPE);
                if (!type.equals(ImportMPIView.ASN)) break block3;
                List<GroupTreeObject> list = gto.getAllElements();
                for (GroupTreeObject elem : list) {
                    GroupTreeObjectLast gtol;
                    if (!(elem instanceof GroupTreeObjectLast) || !this.isLinkRemovedFromImport(gtol = (GroupTreeObjectLast)elem)) continue;
                    ++count;
                }
                break block4;
            }
            if (!type.equals(ImportMPIView.ASN_4IMPORT)) break block4;
            List<GroupTreeObject> list = gto.getAllElements();
            for (GroupTreeObject elem : list) {
                if (elem instanceof GroupTreeObjectLast || !this.hasAsnGrpConflict(elem)) continue;
                ++count;
            }
        }
        return count;
    }

    public int getNumOfImportConflicts() {
        return this.getNumberOfConflicts(this.m_tv_asn4Import, this.m_asn4ImportRoot);
    }

    public int getNumberOfInvalidLinks(GroupTreeObject gto) {
        int count = 0;
        if (gto == null || gto instanceof GroupTreeObjectLast) {
            return count;
        }
        List<GroupTreeObject> list = gto.getAllElements();
        for (GroupTreeObject elem : list) {
            GroupTreeObjectLast gtol;
            if (!(elem instanceof GroupTreeObjectLast) || !this.isLinkRemovedFromImport(gtol = (GroupTreeObjectLast)elem)) continue;
            ++count;
        }
        return count;
    }

    public int getNumberOfBrokenLinks(GroupTreeObject gto) {
        int count = 0;
        if (gto == null || gto instanceof GroupTreeObjectLast) {
            return count;
        }
        List<GroupTreeObject> list = gto.getAllElements();
        for (GroupTreeObject elem : list) {
            GroupTreeObjectLast gtol;
            if (!(elem instanceof GroupTreeObjectLast) || !this.isLinkBroken(gtol = (GroupTreeObjectLast)elem)) continue;
            ++count;
        }
        return count;
    }

    public int getNumberOfMissingLinkedElemsInImportTree(GroupTreeObject gto) {
        int count = 0;
        if (gto == null) {
            return count;
        }
        List<GroupTreeObjectLast> list = GroupTreeObject.collectElements(gto);
        for (GroupTreeObjectLast gtol : list) {
            if (this.m_asnElemsNotInImport_butExistOnSrv.containsKey(gtol.getPath()) || gtol == null || !(gtol instanceof GroupTreeObjectLast)) continue;
            if (gtol.getType().equals(BMUI.type_mon) || gtol.getType().equals(BMUI.type_msg)) {
                gtol.getLinkedPath();
                if (this.m_importMPIView.getPolSection().isLinkedPolicyPartOfImportTree(gtol)) continue;
                ++count;
                continue;
            }
            if (!gtol.getType().equals(BMUI.type_assignment_bin)) continue;
            String linkedPath = gtol.getLinkedPath();
            if (this.m_importMPIView.getBinSection().isLinkedBinaryPartOfImportTree(gtol.getName(), linkedPath)) continue;
            ++count;
        }
        return count;
    }

    public boolean hasAsnGrpConflict(GroupTreeObject gto) {
        boolean hasConflict = false;
        if (!(gto instanceof GroupTreeObjectLast) && gto.getType().equals(BMUI.type_assignment_pol) && !this.m_asnSection.doesElemBelongToNewAsnGroup(gto) && !this.m_asnSection.doesElemExistWithAllElements(gto) && !this.m_asnSection.doMergeAsnGrp(gto) && this.m_asnSection.doesElemBelongToAsnGrpWithConflicts(gto)) {
            hasConflict = true;
        }
        return hasConflict;
    }

    public boolean doesElemBelongToNewAsnGroup(GroupTreeObject gto) {
        boolean isNew = false;
        GroupTreeObject asnGrp = this.getParentAsnGrp(gto);
        if (asnGrp != null) {
            String currAsnGrpPath = asnGrp.getPath();
            GroupTreeObject gtoOrig = this.getOriginalElementFromImportTree(asnGrp);
            if (gtoOrig != null) {
                if (!currAsnGrpPath.equals(gtoOrig.getPath())) {
                    isNew = true;
                } else if (this.m_asnGroupsNew.containsKey(asnGrp.getName())) {
                    isNew = true;
                }
            }
        }
        return isNew;
    }

    public boolean doesElemBelongToAsnGrpWithConflicts(GroupTreeObject gto) {
        GroupTreeObject gtoOrig;
        boolean doesBelong = false;
        GroupTreeObject asnGrp = this.getParentAsnGrp(gto);
        if (asnGrp != null && (gtoOrig = this.getOriginalElementFromImportTree(asnGrp)) != null) {
            doesBelong = this.m_asnGroupsExistWithConflict.containsKey(gtoOrig.getName());
        }
        return doesBelong;
    }

    public boolean doesElemExistWithAllElements(GroupTreeObject gto) {
        GroupTreeObject gtoOrig;
        boolean belongToNew = false;
        GroupTreeObject asnGrp = this.getParentAsnGrp(gto);
        if (asnGrp != null && (gtoOrig = this.getOriginalElementFromImportTree(asnGrp)) != null) {
            belongToNew = this.m_asnGroupsExistWithoutConflict.containsKey(gtoOrig.getName());
        }
        return belongToNew;
    }

    public boolean isLinkRemovedFromImport(GroupTreeObjectLast gtol) {
        return this.m_asnElemsWithBrokenLink_removed.containsKey(gtol.getPath());
    }

    public boolean isLinkBroken(GroupTreeObjectLast gtol) {
        return this.m_asnElemsWithBrokenLink_toImport.containsKey(gtol.getPath());
    }

    public boolean isNewLink(GroupTreeObjectLast gtol) {
        return this.m_asnElementsNew.containsKey(gtol.getPath());
    }

    public boolean doesLinkExistButMissingInImport(GroupTreeObject gto) {
        GroupTreeObject gtolSrv;
        return this.m_asnElemsNotInImport_butExistOnSrv.containsKey(gto.getPath()) && (gtolSrv = this.m_asnElemsNotInImport_butExistOnSrv.get(gto.getPath())) != null && gto.getPath().equals(gtolSrv.getPath());
    }

    public boolean doMergeAsnGrp(GroupTreeObject gto) {
        GroupTreeObject origGTO;
        if (gto == null) {
            return false;
        }
        boolean merge = false;
        GroupTreeObject asnGrpGto = this.getParentAsnGrp(gto);
        if (asnGrpGto != null && (origGTO = this.getOriginalElementFromImportTree(asnGrpGto)) != null) {
            merge = this.m_asnGrpsMerge.containsKey(origGTO.getName());
        }
        return merge;
    }

    public GroupTreeObject getOriginalElementFromImportTree(GroupTreeObject gto) {
        GroupTreeObject origGTO = null;
        ITreeObject to = gto.getTreeObject();
        if (to != null) {
            Object o = to.getObject();
            if (o instanceof GroupTreeObject) {
                origGTO = (GroupTreeObject)o;
            } else if (o instanceof String) {
                String origPath = (String)o;
                origGTO = this.m_asnRoot.searchPath(origPath, gto.getType());
            }
        }
        return origGTO;
    }

    public GroupTreeObject cloneElement(GroupTreeObject gto) {
        GroupTreeObject clone = null;
        try {
            clone = gto.clone();
            clone.getTreeObject().setObject(gto.getPath());
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        return clone;
    }

    private GroupTreeObject getParentAsnGrp(GroupTreeObject gto) {
        GroupTreeObject gto2 = gto;
        if (gto != null) {
            String type = gto.getType();
            while (!type.equals(BMUI.type_assignment_pol)) {
                GroupTreeObject parent = gto2.getParent();
                if (parent == null) break;
                type = parent.getType();
                gto2 = parent;
            }
        }
        return gto2;
    }

    public Image getIcon(GroupTreeObject gto, String treeType) {
        if (this.doesLinkExistButMissingInImport(gto)) {
            return BMUI.IMAGE_ARROW_LEFT_BLUE;
        }
        if (treeType.equals(ImportMPIView.ASN)) {
            GroupTreeObjectLast gtol;
            if (gto instanceof GroupTreeObjectLast && this.isLinkRemovedFromImport(gtol = (GroupTreeObjectLast)gto)) {
                return BMUI.IMAGE_CANCEL_ROUND;
            }
        } else if (treeType.equals(ImportMPIView.ASN_4IMPORT)) {
            if (gto instanceof GroupTreeObjectLast) {
                GroupTreeObjectLast gtol = (GroupTreeObjectLast)gto;
                GroupTreeObject orig = this.getOriginalElementFromImportTree(gtol);
                if (orig != null && orig instanceof GroupTreeObjectLast) {
                    GroupTreeObjectLast origGTOL = (GroupTreeObjectLast)orig;
                    if (origGTOL.getType().equals(BMUI.type_mon) || origGTOL.getType().equals(BMUI.type_msg)) {
                        if (!this.m_importMPIView.getPolSection().isLinkedPolicyPartOfImportTree(gtol)) {
                            return BMUI.IMAGE_BROKEN_LINK;
                        }
                        System.out.println();
                    } else if (origGTOL.getType().equals(BMUI.type_assignment_bin) && !this.m_importMPIView.getBinSection().isLinkedBinaryPartOfImportTree(origGTOL.getName(), gtol.getLinkedPath())) {
                        return BMUI.IMAGE_BROKEN_LINK;
                    }
                }
            } else if (gto.getType().equals(BMUI.type_assignment_pol)) {
                if (this.doMergeAsnGrp(gto)) {
                    return BMUI.IMAGE_MERGE;
                }
            } else if (this.doesLinkExistButMissingInImport(gto)) {
                return BMUI.IMAGE_ARROW_LEFT_BLUE;
            }
        }
        return null;
    }

    public int getTotalImportConflicts() {
        return this.getNumberOfConflicts(this.m_tv_asn4Import, this.m_asn4ImportRoot);
    }

    public void renameElements(Map<GroupTreeObject, String> elements, String value, String type) {
        for (GroupTreeObject gto : elements.keySet()) {
            if (type.equals(ImportMPIView.PREFIX)) {
                gto.setName(String.valueOf(value) + gto.getName());
            } else if (type.equals(ImportMPIView.SUFFIX)) {
                gto.setName(String.valueOf(gto.getName()) + value);
            } else if (type.equals(ImportMPIView.RENAME)) {
                gto.setName(value);
            }
            GroupTreeObject origGTO = this.getOriginalElementFromImportTree(gto);
            if (origGTO == null) continue;
            this.removeFromHashMaps(origGTO);
            this.m_asnGrpNewAfterRename.put(origGTO.getName(), origGTO);
        }
        this.refreshTree(this.m_tv_asn4Import, this.m_asn4ImportRoot, -1);
    }

    public void renamePolicies(Map<String, String> old2newNames, GroupTreeObject rootPoliciyTree) {
        if (this.m_asn4ImportRoot == null) {
            return;
        }
        LinkedList<GroupTreeObject> listAffectedAsnGroups = new LinkedList<GroupTreeObject>();
        for (GroupTreeObject gto : this.m_asn4ImportRoot.getAllElements()) {
            String name;
            GroupTreeObject origGTO;
            GroupTreeObjectLast gtol;
            if (!(gto instanceof GroupTreeObjectLast) || this.m_asnElemsNotInImport_butExistOnSrv.containsKey((gtol = (GroupTreeObjectLast)gto).getPath()) || !BMUI.type_mon.equals(gtol.getType()) && !BMUI.type_msg.equals(gtol.getType()) || (origGTO = this.getOriginalElementFromImportTree(gtol)) == null || !old2newNames.containsKey(name = origGTO.getName())) continue;
            String type = gtol.getType();
            String newName = old2newNames.get(name);
            GroupTreeObjectLast gto_new = rootPoliciyTree.findElement(newName, type);
            if (gto_new == null) continue;
            gtol.setName(newName);
            gtol.setLinkedPath(gto_new.getPath());
            GroupTreeObject asnGroup4thisElement = this.getParentAsnGrp(gtol);
            if (asnGroup4thisElement == null || listAffectedAsnGroups.contains(asnGroup4thisElement)) continue;
            listAffectedAsnGroups.add(asnGroup4thisElement);
        }
        for (GroupTreeObject affectedAsnGroup : listAffectedAsnGroups) {
            this.cleanStatus(affectedAsnGroup);
            this.checkIncomingAsnGroup(affectedAsnGroup);
            this.checkExistingAsnGroup(affectedAsnGroup);
        }
        this.refreshTree(this.m_tv_asn4Import, this.m_asn4ImportRoot, -1);
    }

    public void renameBinaries(Map<String, String> old2newNames, GroupTreeObject binPkgTree) {
        if (this.m_asn4ImportRoot == null) {
            return;
        }
        LinkedList<GroupTreeObject> listAffectedAsnGroups = new LinkedList<GroupTreeObject>();
        for (GroupTreeObject gto : this.m_asn4ImportRoot.getAllElements()) {
            String name;
            GroupTreeObject origGTO;
            GroupTreeObjectLast gtol;
            if (!(gto instanceof GroupTreeObjectLast) || this.m_asnElemsNotInImport_butExistOnSrv.containsKey((gtol = (GroupTreeObjectLast)gto).getPath()) || !BMUI.type_assignment_bin.equals(gtol.getType()) || (origGTO = this.getOriginalElementFromImportTree(gtol)) == null || !old2newNames.containsKey(name = origGTO.getName())) continue;
            String type = gtol.getType();
            String newName = old2newNames.get(name);
            GroupTreeObject gto_new = binPkgTree.searchPath("/root/Packages/" + newName, type);
            if (gto_new == null) continue;
            gtol.setName(newName);
            gtol.setLinkedPath(gto_new.getPath());
            GroupTreeObject asnGroup4thisElement = this.getParentAsnGrp(gtol);
            if (asnGroup4thisElement == null || listAffectedAsnGroups.contains(asnGroup4thisElement)) continue;
            listAffectedAsnGroups.add(asnGroup4thisElement);
        }
        for (GroupTreeObject affectedAsnGroup : listAffectedAsnGroups) {
            this.cleanStatus(affectedAsnGroup);
            this.checkIncomingAsnGroup(affectedAsnGroup);
            this.checkExistingAsnGroup(affectedAsnGroup);
        }
        this.refreshTree(this.m_tv_asn4Import, this.m_asn4ImportRoot, -1);
    }

    public void resolveBrokenLinks(Map<GroupTreeObjectLast, String> elements) {
        this.m_importMPIView.getPolSection().resolveBrokenLinks(elements);
        this.m_importMPIView.getBinSection().resolveBrokenLinks(elements);
        this.refreshTree(this.m_tv_asn4Import, this.m_asn4ImportRoot, -1);
    }

    public void removeFromImport(Map<GroupTreeObject, String> elements) {
        for (GroupTreeObject gto : elements.keySet()) {
            String currPath = gto.getPath();
            GroupTreeObject gtoExist = this.m_asn4ImportRoot.searchPath(currPath, gto.getType());
            if (gtoExist == null || this.m_asnElemsNotInImport_butExistOnSrv.containsKey(gto.getPath())) continue;
            gtoExist.getParent().removeElement(gtoExist);
            GroupTreeObject origGTO = this.getOriginalElementFromImportTree(gto);
            if (origGTO == null) continue;
            this.removeFromHashMaps(origGTO);
            this.m_elementsSkipImport.put(origGTO.getPath(), origGTO);
        }
        this.refreshTree(this.m_tv_asn4Import, this.m_asn4ImportRoot, -1);
    }

    public void mergeAsnGrp(Map<String, GroupTreeObject> elements) {
        for (GroupTreeObject gto : elements.values()) {
            GroupTreeObject origGTO = this.getOriginalElementFromImportTree(gto);
            if (origGTO == null) continue;
            this.removeFromHashMaps(origGTO);
            this.m_asnGrpsMerge.put(origGTO.getName(), origGTO);
        }
        this.refreshTree(this.m_tv_asn4Import, this.m_asn4ImportRoot, -1);
    }

    public void addToImport(Map<GroupTreeObject, String> elements) {
        HashMap<String, GroupTreeObject> asnGrps = new HashMap<String, GroupTreeObject>();
        for (GroupTreeObject origGTO : elements.keySet()) {
            GroupTreeObject newAddedGTO;
            if (!origGTO.getType().equals(BMUI.type_assignment_pol)) continue;
            this.removeFromHashMaps(origGTO);
            this.removeFromHashMaps(origGTO.getAllElements());
            if (!this.m_asn4ImportRoot.hasElements().booleanValue()) {
                this.m_asn4ImportRoot.addElement(new GroupTreeObject(new TreeObject("Assignments", BMUI.type_toplevel, null)));
            }
            this.m_importMPIView.addElement2Tree(this.m_asn4ImportRoot, origGTO, origGTO.getParentPath());
            if (origGTO instanceof GroupTreeObjectLast || (newAddedGTO = this.m_asn4ImportRoot.searchPath(origGTO.getPath(), origGTO.getType())) == null) continue;
            asnGrps.put(newAddedGTO.getName(), newAddedGTO);
        }
        this.resetAsnGroups(asnGrps);
        for (GroupTreeObject origGTO : elements.keySet()) {
            if (origGTO.getType().equals(BMUI.type_assignment_pol)) continue;
            this.removeFromHashMaps(origGTO);
            this.removeFromHashMaps(origGTO.getAllElements());
            if (!this.m_asn4ImportRoot.hasElements().booleanValue()) {
                this.m_asn4ImportRoot.addElement(new GroupTreeObject(new TreeObject("Assignments", BMUI.type_toplevel, null)));
            }
            this.m_importMPIView.addElement2Tree(this.m_asn4ImportRoot, origGTO, origGTO.getParentPath());
        }
        this.refreshTree(this.m_tv_asn4Import, this.m_asn4ImportRoot, -1);
    }

    public void resetAsnGroups(Map<String, GroupTreeObject> elements) {
        for (GroupTreeObject gto : elements.values()) {
            GroupTreeObject origGTO = this.getOriginalElementFromImportTree(gto);
            if (origGTO == null) continue;
            this.removeFromHashMaps(origGTO);
            this.removeFromHashMaps(origGTO.getAllElements());
            GroupTreeObject parent = gto.getParent();
            parent.removeElement(gto);
            GroupTreeObject clone = this.cloneElement(origGTO);
            parent.addElement(clone);
            this.checkExistingAsnGroup(origGTO);
        }
        this.refreshTree(this.m_tv_asn4Import, this.m_asn4ImportRoot, -1);
    }

    public void removeFromHashMaps(List<GroupTreeObject> origGTOList) {
        for (GroupTreeObject origGTO : origGTOList) {
            this.removeFromHashMaps(origGTO);
        }
    }

    public void removeFromHashMaps(GroupTreeObject origGTO) {
        if (origGTO == null) {
            return;
        }
        String origName = origGTO.getName();
        String origPath = origGTO.getPath();
        if (this.m_elementsSkipImport.containsKey(origPath)) {
            this.m_elementsSkipImport.remove(origPath);
        }
        if (this.m_asnGrpsMerge.containsKey(origName)) {
            this.m_asnGrpsMerge.remove(origName);
        }
        if (this.m_asnGrpNewAfterRename.containsKey(origName)) {
            this.m_asnGrpNewAfterRename.remove(origName);
        }
    }

    public void refreshTree(TreeViewer tv, GroupTreeObject root, int expLevel) {
        this.m_importMPIView.refreshTree(tv, root, expLevel);
        this.updateTreeFooter(tv);
        this.m_importMPIView.updateImportButtonStatus();
    }

    public void refreshTree(String treeType) {
        if (!this.isEnabled()) {
            return;
        }
        if (treeType.equals(ImportMPIView.ASN)) {
            this.refreshTree(this.m_tv_asn, this.m_asnRoot, -1);
        } else if (treeType.equals(ImportMPIView.ASN_4IMPORT)) {
            this.refreshTree(this.m_tv_asn4Import, this.m_asn4ImportRoot, -1);
        }
    }

    public void createXMLTree_CM() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        Menu menu = menuMgr.createContextMenu(this.m_tv_asn.getControl());
        this.m_tv_asn.getControl().setMenu(menu);
        ImportMPIView.m_instance.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.m_tv_asn);
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                try {
                    StructuredSelection ssel = (StructuredSelection)ImportMPIAsnSection.this.m_tv_asn.getSelection();
                    if (!ssel.isEmpty()) {
                        String type = ((GroupTreeObject)ssel.getFirstElement()).getType();
                        manager.add((IAction)new AddToImportAction(ImportMPIAsnSection.this.m_tv_asn, ImportMPIAsnSection.this.m_asnRoot, ImportMPIAsnSection.this.m_asnSection));
                        manager.add((IContributionItem)new Separator());
                        manager.add((IAction)new ExpandCollapseAction(ImportMPIAsnSection.this.m_tv_asn, "ExpandAll"));
                        manager.add((IAction)new ExpandCollapseAction(ImportMPIAsnSection.this.m_tv_asn, "CollapseAll"));
                        if (!type.equals(BMUI.type_toplevel)) {
                            manager.add((IContributionItem)new Separator());
                            manager.add((IAction)new ExpandCollapseAction(ImportMPIAsnSection.this.m_tv_asn, "ExpandSubTree"));
                            manager.add((IAction)new ExpandCollapseAction(ImportMPIAsnSection.this.m_tv_asn, "CollagpseSubTree"));
                        }
                    } else {
                        manager.add((IAction)new ExpandCollapseAction(ImportMPIAsnSection.this.m_tv_asn, "ExpandAll"));
                        manager.add((IAction)new ExpandCollapseAction(ImportMPIAsnSection.this.m_tv_asn, "CollapseAll"));
                    }
                }
                catch (RuntimeException e) {
                    RTLogger.print(5, "ImportMPI: Error creating context menu of import tree", e);
                }
            }
        });
    }

    public void createFinalTree_CM() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        Menu menu = menuMgr.createContextMenu(this.m_tv_asn4Import.getControl());
        this.m_tv_asn4Import.getControl().setMenu(menu);
        ImportMPIView.m_instance.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.m_tv_asn4Import);
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                try {
                    GroupTreeObject gtoFirst;
                    StructuredSelection ssel = (StructuredSelection)ImportMPIAsnSection.this.m_tv_asn4Import.getSelection();
                    if (!ssel.isEmpty()) {
                        gtoFirst = (GroupTreeObject)ssel.getFirstElement();
                        if (gtoFirst.getType().equals(BMUI.type_toplevel)) {
                            manager.add((IAction)new RenameAction(ImportMPIAsnSection.this.m_tv_asn4Import, ImportMPIAsnSection.this.m_asnSection, ImportMPIView.PREFIX));
                            manager.add((IAction)new RenameAction(ImportMPIAsnSection.this.m_tv_asn4Import, ImportMPIAsnSection.this.m_asnSection, ImportMPIView.SUFFIX));
                            manager.add((IContributionItem)new Separator());
                            manager.add((IAction)new MergeAction(ImportMPIAsnSection.this.m_tv_asn4Import, ImportMPIAsnSection.this.m_asnSection));
                            manager.add((IContributionItem)new Separator());
                            manager.add((IAction)new ResetElementsAction(ImportMPIAsnSection.this.m_tv_asn4Import, ImportMPIAsnSection.this.m_asn4ImportRoot, ImportMPIAsnSection.this.m_asnSection, ImportMPIView.RESET_TREE));
                            manager.add((IContributionItem)new Separator());
                            manager.add((IAction)new RemoveFromImportAction(ImportMPIAsnSection.this.m_tv_asn4Import, ImportMPIAsnSection.this.m_asn4ImportRoot, ImportMPIAsnSection.this.m_asnSection));
                            manager.add((IAction)new ResolveBrokenLinksAction(ImportMPIAsnSection.this.m_tv_asn4Import, ImportMPIAsnSection.this.m_asn4ImportRoot, ImportMPIAsnSection.this.m_asnSection));
                        } else {
                            manager.add((IAction)new RenameAction(ImportMPIAsnSection.this.m_tv_asn4Import, ImportMPIAsnSection.this.m_asnSection, ImportMPIView.RENAME));
                            manager.add((IAction)new RenameAction(ImportMPIAsnSection.this.m_tv_asn4Import, ImportMPIAsnSection.this.m_asnSection, ImportMPIView.PREFIX));
                            manager.add((IAction)new RenameAction(ImportMPIAsnSection.this.m_tv_asn4Import, ImportMPIAsnSection.this.m_asnSection, ImportMPIView.SUFFIX));
                            manager.add((IContributionItem)new Separator());
                            manager.add((IAction)new MergeAction(ImportMPIAsnSection.this.m_tv_asn4Import, ImportMPIAsnSection.this.m_asnSection));
                            manager.add((IContributionItem)new Separator());
                            int countAsnGrps = 0;
                            int countLinksAndFolders = 0;
                            for (GroupTreeObject gto : ssel) {
                                String type = gto.getType();
                                if (type.equals(BMUI.type_toplevel)) {
                                    countLinksAndFolders = 0;
                                    countAsnGrps = 0;
                                    break;
                                }
                                if (type.equals(BMUI.type_assignment_pol)) {
                                    ++countAsnGrps;
                                    continue;
                                }
                                if (!type.equals(BMUI.type_folder) && !type.equals(BMUI.type_mon) && !type.equals(BMUI.type_msg)) continue;
                                ++countLinksAndFolders;
                            }
                            if (countAsnGrps > 0) {
                                // empty if block
                            }
                            manager.add((IAction)new ResetElementsAction(ImportMPIAsnSection.this.m_tv_asn4Import, ImportMPIAsnSection.this.m_asn4ImportRoot, ImportMPIAsnSection.this.m_asnSection, ImportMPIView.RESET_TREE));
                            manager.add((IContributionItem)new Separator());
                            manager.add((IAction)new RemoveFromImportAction(ImportMPIAsnSection.this.m_tv_asn4Import, ImportMPIAsnSection.this.m_asn4ImportRoot, ImportMPIAsnSection.this.m_asnSection));
                            manager.add((IAction)new ResolveBrokenLinksAction(ImportMPIAsnSection.this.m_tv_asn4Import, ImportMPIAsnSection.this.m_asn4ImportRoot, ImportMPIAsnSection.this.m_asnSection));
                        }
                    } else {
                        manager.add((IAction)new ResetElementsAction(ImportMPIAsnSection.this.m_tv_asn4Import, ImportMPIAsnSection.this.m_asn4ImportRoot, ImportMPIAsnSection.this.m_asnSection, ImportMPIView.RESET_TREE));
                    }
                    manager.add((IContributionItem)new Separator());
                    manager.add((IAction)new ExpandCollapseAction(ImportMPIAsnSection.this.m_tv_asn4Import, "ExpandAll"));
                    manager.add((IAction)new ExpandCollapseAction(ImportMPIAsnSection.this.m_tv_asn4Import, "CollapseAll"));
                    if (!ssel.isEmpty() && !(gtoFirst = (GroupTreeObject)ssel.getFirstElement()).getType().equals(BMUI.type_toplevel)) {
                        manager.add((IContributionItem)new Separator());
                        manager.add((IAction)new ExpandCollapseAction(ImportMPIAsnSection.this.m_tv_asn4Import, "ExpandSubTree"));
                        manager.add((IAction)new ExpandCollapseAction(ImportMPIAsnSection.this.m_tv_asn4Import, "CollagpseSubTree"));
                    }
                }
                catch (RuntimeException e) {
                    RTLogger.print(5, "ImportMPI: Error creating context menu of import tree", e);
                }
            }
        });
    }

    public Map<String, GroupTreeObject> getAsnGrps2Merge() {
        HashMap<String, GroupTreeObject> asnGrps2Merge = new HashMap<String, GroupTreeObject>();
        if (this.m_asn4ImportRoot != null && this.m_asn4ImportRoot.hasElements().booleanValue()) {
            List<GroupTreeObject> elems = this.m_asn4ImportRoot.getAllElements();
            for (GroupTreeObject gto : elems) {
                GroupTreeObject origGTO;
                if (!gto.getType().equals(BMUI.type_assignment_pol) || (origGTO = this.getOriginalElementFromImportTree(gto)) == null || !this.m_asnGrpsMerge.containsKey(origGTO.getName())) continue;
                asnGrps2Merge.put(gto.getName(), gto);
            }
        }
        return asnGrps2Merge;
    }

    public Map<String, GroupTreeObject> getAsnGrpsNew() {
        HashMap<String, GroupTreeObject> allNewAsnGrps = new HashMap<String, GroupTreeObject>();
        if (this.m_asn4ImportRoot != null && this.m_asn4ImportRoot.hasElements().booleanValue()) {
            List<GroupTreeObject> elems = this.m_asn4ImportRoot.getFirstChild("Assignments").getElements();
            for (GroupTreeObject gto : elems) {
                GroupTreeObject origGTO;
                if (!gto.getType().equals(BMUI.type_assignment_pol) || (origGTO = this.getOriginalElementFromImportTree(gto)) == null || this.m_elementsSkipImport.containsKey(origGTO.getName())) continue;
                if (this.m_asnGrpNewAfterRename.containsKey(origGTO.getName())) {
                    allNewAsnGrps.put(gto.getName(), gto);
                    continue;
                }
                if (!this.m_asnGroupsNew.containsKey(origGTO.getName())) continue;
                allNewAsnGrps.put(gto.getName(), gto);
            }
        }
        return allNewAsnGrps;
    }

    public void expansionStateChanged(ExpansionEvent e) {
    }

    public void expansionStateChanging(ExpansionEvent e) {
    }

    public void selectionChanged(SelectionChangedEvent event) {
        Object obj = event.getSource();
        if (obj instanceof TreeViewer) {
            TreeViewer tv = (TreeViewer)obj;
            String type = (String)tv.getData(ImportMPIView.TREE_VIEWER_TYPE);
            if (type.equals(ImportMPIView.ASN)) {
                AddToImportAction action = new AddToImportAction(this.m_tv_asn, this.m_asnRoot, this.m_asnSection);
                this.m_gui.enableField(this.m_add_btn, action.isEnabled());
            } else if (type.equals(ImportMPIView.ASN_4IMPORT)) {
                RenameAction action1 = new RenameAction(this.m_tv_asn4Import, this.m_asnSection, ImportMPIView.RENAME);
                this.m_rename_btn.setText(action1.getText());
                this.m_gui.enableField(this.m_rename_btn, action1.isEnabled());
                RenameAction action2 = new RenameAction(this.m_tv_asn4Import, this.m_asnSection, ImportMPIView.PREFIX);
                this.m_addPrefix_btn.setText(action2.getText());
                this.m_gui.enableField(this.m_addPrefix_btn, action2.isEnabled());
                RenameAction action3 = new RenameAction(this.m_tv_asn4Import, this.m_asnSection, ImportMPIView.SUFFIX);
                this.m_addSuffix_btn.setText(action3.getText());
                this.m_gui.enableField(this.m_addSuffix_btn, action3.isEnabled());
                MergeAction action4 = new MergeAction(this.m_tv_asn4Import, this.m_asnSection);
                this.m_merge_btn.setText(action4.getText());
                this.m_gui.enableField(this.m_merge_btn, action4.isEnabled());
                ResetElementsAction action6 = new ResetElementsAction(this.m_tv_asn4Import, this.m_asn4ImportRoot, this.m_asnSection, ImportMPIView.RESET_TREE);
                this.m_resetTree_btn.setText(action6.getText());
                this.m_gui.enableField(this.m_resetTree_btn, action6.isEnabled());
                RemoveFromImportAction action7 = new RemoveFromImportAction(this.m_tv_asn4Import, this.m_asn4ImportRoot, this.m_asnSection);
                this.m_gui.enableField(this.m_removeFromImport_btn, action7.isEnabled());
                this.m_gui.enableField(this.m_remove_btn, action7.isEnabled());
                ResolveBrokenLinksAction action8 = new ResolveBrokenLinksAction(this.m_tv_asn4Import, this.m_asn4ImportRoot, this.m_asnSection);
                this.m_gui.enableField(this.m_resolve_btn, action8.isEnabled());
            }
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        Object obj = e.getSource();
        if (obj instanceof Button) {
            Button btn = (Button)obj;
            String name = (String)btn.getData();
            if (name.equals(ADD_BTN)) {
                AddToImportAction action = new AddToImportAction(this.m_tv_asn, this.m_asnRoot, this.m_asnSection);
                action.run();
            } else if (name.equals(RENAME_BTN)) {
                RenameAction action = new RenameAction(this.m_tv_asn4Import, this.m_asnSection, ImportMPIView.RENAME);
                action.run();
            } else if (name.equals(ADD_PREFIX_BTN)) {
                RenameAction action = new RenameAction(this.m_tv_asn4Import, this.m_asnSection, ImportMPIView.PREFIX);
                action.run();
            } else if (name.equals(ADD_SUFFIX_BTN)) {
                RenameAction action = new RenameAction(this.m_tv_asn4Import, this.m_asnSection, ImportMPIView.SUFFIX);
                action.run();
            } else if (name.equals(MERGE_BTN)) {
                MergeAction action = new MergeAction(this.m_tv_asn4Import, this.m_asnSection);
                action.run();
            } else if (name.equals(RESET_TREE_BTN)) {
                ResetElementsAction action = new ResetElementsAction(this.m_tv_asn4Import, this.m_asn4ImportRoot, this.m_asnSection, ImportMPIView.RESET_TREE);
                action.run();
            } else if (name.equals(REMOVE_FROM_IMPORT_BTN) || name.equals(REMOVE_BTN)) {
                RemoveFromImportAction action = new RemoveFromImportAction(this.m_tv_asn4Import, this.m_asn4ImportRoot, this.m_asnSection);
                action.run();
            } else if (name.equals(RESOLVE_BTN)) {
                ResolveBrokenLinksAction action = new ResolveBrokenLinksAction(this.m_tv_asn4Import, this.m_asn4ImportRoot, this.m_asnSection);
                action.run();
            }
        }
    }

    public class AddToImportAction
    extends Action {
        private ImportMPIAsnSection m_section;
        private Map<GroupTreeObject, String> m_elements;

        public AddToImportAction(TreeViewer tv, GroupTreeObject root, ImportMPIAsnSection section) {
            super("addtoimportaction");
            this.m_section = null;
            this.m_elements = new HashMap<GroupTreeObject, String>();
            this.setId("addtoimportaction");
            this.setText("Add To Import");
            this.m_section = section;
            if (tv == null || this.m_section == null) {
                this.setEnabled(false);
                return;
            }
            StructuredSelection sel = (StructuredSelection)tv.getSelection();
            if (sel.size() > 0) {
                ArrayList<GroupTreeObject> map = new ArrayList<GroupTreeObject>();
                for (Object selected : sel) {
                    if (selected instanceof GroupTreeObjectLast) {
                        map.add((GroupTreeObjectLast)selected);
                        continue;
                    }
                    if (!(selected instanceof GroupTreeObject)) continue;
                    GroupTreeObject selectedGTO = (GroupTreeObject)selected;
                    if (selectedGTO.getType().equals(BMUI.type_toplevel)) {
                        map.clear();
                        map.addAll(selectedGTO.getAllElements());
                        break;
                    }
                    map.add(selectedGTO);
                    map.addAll(selectedGTO.getAllElements());
                }
                int i = 0;
                while (i < map.size()) {
                    GroupTreeObject gto = (GroupTreeObject)map.get(i);
                    this.m_elements.put(gto, gto.getName());
                    ++i;
                }
            }
            if (this.m_elements.size() == 0) {
                this.setEnabled(false);
            }
        }

        public void run() {
            if (!this.isEnabled()) {
                return;
            }
            if (this.m_section == null || this.m_elements.size() == 0) {
                return;
            }
            this.m_section.addToImport(this.m_elements);
        }
    }

    class ContentProviderAsnImportTree
    extends ViewContentProvider {
        @Override
        public Object[] getElements(Object obj) {
            Object[] oList = this.getChildren(obj);
            return oList;
        }
    }

    public class MergeAction
    extends Action {
        private ImportMPIAsnSection m_section;
        private Map<String, GroupTreeObject> m_elements;

        public MergeAction(TreeViewer tv, ImportMPIAsnSection section) {
            super("mergeasngroup");
            this.m_section = null;
            this.m_elements = new HashMap<String, GroupTreeObject>();
            this.setId("mergeasngroup");
            this.setText("Merge");
            this.m_section = section;
            if (this.m_section == null) {
                this.setEnabled(false);
                return;
            }
            StructuredSelection sel = (StructuredSelection)tv.getSelection();
            if (sel.size() > 0) {
                for (Object selected : sel) {
                    GroupTreeObject asnGrp;
                    if (!(selected instanceof GroupTreeObject)) continue;
                    GroupTreeObject gto = (GroupTreeObject)selected;
                    if (gto.getType().equals(BMUI.type_toplevel)) {
                        GroupTreeObject toplevel = gto;
                        List<GroupTreeObject> list = toplevel.getElements();
                        int i = 0;
                        while (i < list.size()) {
                            GroupTreeObject asnGrp2 = list.get(i);
                            if (this.m_section.hasAsnGrpConflict(asnGrp2)) {
                                this.m_elements.put(asnGrp2.getName(), asnGrp2);
                            }
                            ++i;
                        }
                        break;
                    }
                    if (!gto.getType().equals(BMUI.type_assignment_pol) || !this.m_section.hasAsnGrpConflict(asnGrp = gto)) continue;
                    this.m_elements.put(asnGrp.getName(), asnGrp);
                }
            }
            if (this.m_elements.size() == 0) {
                this.setEnabled(false);
            }
        }

        public void run() {
            if (!this.isEnabled()) {
                return;
            }
            if (this.m_section == null || this.m_elements.size() == 0) {
                return;
            }
            this.m_section.mergeAsnGrp(this.m_elements);
        }
    }

    public class RemoveFromImportAction
    extends Action {
        private ImportMPIAsnSection m_section;
        private Map<GroupTreeObject, String> m_elements;

        public RemoveFromImportAction(TreeViewer tv, GroupTreeObject root, ImportMPIAsnSection section) {
            super("skipimport");
            this.m_section = null;
            this.m_elements = new HashMap<GroupTreeObject, String>();
            this.setId("skipimport");
            this.setText("Remove");
            this.m_section = section;
            if (root == null || this.m_section == null) {
                this.setEnabled(false);
                return;
            }
            StructuredSelection sel = (StructuredSelection)tv.getSelection();
            if (sel.size() > 0) {
                ArrayList<GroupTreeObject> map = new ArrayList<GroupTreeObject>();
                for (Object selected : sel) {
                    if (selected instanceof GroupTreeObjectLast) {
                        map.add((GroupTreeObjectLast)selected);
                        continue;
                    }
                    if (!(selected instanceof GroupTreeObject)) continue;
                    map.add((GroupTreeObject)selected);
                    map.addAll(((GroupTreeObject)selected).getAllGTOLs());
                }
                int i = 0;
                while (i < map.size()) {
                    this.m_elements.put((GroupTreeObject)map.get(i), null);
                    ++i;
                }
            }
            if (this.m_elements.size() == 0) {
                this.setEnabled(false);
            }
        }

        public void run() {
            if (!this.isEnabled()) {
                return;
            }
            if (this.m_section == null || this.m_elements.size() == 0) {
                return;
            }
            this.m_section.removeFromImport(this.m_elements);
        }
    }

    public class RenameAction
    extends Action {
        private TreeViewer m_tv;
        private ImportMPIAsnSection m_section;
        private String m_title;
        private String m_type;
        private Map<GroupTreeObject, String> m_elements;

        public RenameAction(TreeViewer tv, ImportMPIAsnSection section, String type) {
            super("renameaction");
            this.m_tv = null;
            this.m_section = null;
            this.m_title = null;
            this.m_type = null;
            this.m_elements = new HashMap<GroupTreeObject, String>();
            this.setId("renameaction");
            this.m_tv = tv;
            this.m_section = section;
            this.m_type = type;
            if (this.m_tv == null || this.m_section == null || type == null) {
                this.setEnabled(false);
            }
            if (this.m_type.equals(ImportMPIView.PREFIX)) {
                this.m_title = "Add Prefix";
            } else if (this.m_type.equals(ImportMPIView.SUFFIX)) {
                this.m_title = "Add Suffix";
            } else if (this.m_type.equals(ImportMPIView.RENAME)) {
                this.m_title = "Rename";
            } else {
                this.setText("Rename");
                this.setEnabled(false);
                return;
            }
            this.setText(this.m_title);
            StructuredSelection sel = (StructuredSelection)tv.getSelection();
            if (!sel.isEmpty()) {
                if (type.equals(ImportMPIView.RENAME)) {
                    Object obj;
                    if (sel.size() == 1 && (obj = sel.getFirstElement()) instanceof GroupTreeObject && ((GroupTreeObject)obj).getType().equals(BMUI.type_assignment_pol)) {
                        this.m_elements.put((GroupTreeObject)obj, null);
                    }
                } else {
                    for (Object obj : sel) {
                        if (!(obj instanceof GroupTreeObject)) continue;
                        if (((GroupTreeObject)obj).getType().equals(BMUI.type_toplevel)) {
                            GroupTreeObject toplevel = (GroupTreeObject)obj;
                            List<GroupTreeObject> list = toplevel.getElements();
                            int i = 0;
                            while (i < list.size()) {
                                this.m_elements.put(list.get(i), null);
                                ++i;
                            }
                            break;
                        }
                        if (!((GroupTreeObject)obj).getType().equals(BMUI.type_assignment_pol)) continue;
                        this.m_elements.put((GroupTreeObject)obj, null);
                    }
                }
            }
            if (this.m_elements.size() == 0) {
                this.setEnabled(false);
            }
        }

        public void run() {
            String value;
            if (!this.isEnabled()) {
                return;
            }
            if (this.m_tv == null || this.m_section == null || this.m_elements.size() == 0) {
                return;
            }
            String title = null;
            String msg = null;
            String initalValue = "";
            if (this.m_type.equals(ImportMPIView.PREFIX)) {
                title = "Add Prefix";
                msg = "Prefix: ";
            } else if (this.m_type.equals(ImportMPIView.SUFFIX)) {
                title = "Add Suffix";
                msg = "Suffix: ";
            } else if (this.m_type.equals(ImportMPIView.RENAME)) {
                GroupTreeObject gto = this.m_elements.keySet().iterator().next();
                initalValue = gto.getName();
                String type = gto.getType();
                if (type.equals(BMUI.type_assignment_pol)) {
                    title = "  Rename Assignment Group";
                    msg = "Please enter a new Assignment Group Name: ";
                } else if (type.equals(BMUI.type_mon) || type.equals(BMUI.type_msg)) {
                    title = "  Rename Assignment Link";
                    msg = "Please enter a new Assignment Link Name: ";
                } else {
                    title = "  Rename Folder";
                    msg = "Please enter a new Folder Name: ";
                }
            }
            InputDialog id = new InputDialog(this.m_tv.getControl().getShell(), "  " + title, msg, initalValue, (IInputValidator)new NameValidatorHostGroup());
            id.setBlockOnOpen(true);
            InputDialog.setDefaultImage((Image)BMUI.IMAGE_PRODUCT);
            int res = id.open();
            if (res == 0 && (value = id.getValue()) != null && value.length() != 0) {
                if (this.m_type.equals(ImportMPIView.RENAME)) {
                    GroupTreeObject gto2Rename = this.m_elements.keySet().iterator().next();
                    String parentPath = gto2Rename.getParentPath();
                    GroupTreeObject gtoFound = this.m_section.m_existingAsnTree.searchPath(String.valueOf(parentPath) + "/" + value, gto2Rename.getType());
                    if (gtoFound == null) {
                        gtoFound = this.m_section.m_asn4ImportRoot.searchPath(String.valueOf(parentPath) + "/" + value, gto2Rename.getType());
                    }
                    if (gtoFound != null) {
                        new ShowMessageBox("  Rename ", "An element with this name does already exist!", 2);
                        this.run();
                    } else {
                        HashMap<GroupTreeObject, String> elem = new HashMap<GroupTreeObject, String>();
                        elem.put(gto2Rename, null);
                        this.m_section.renameElements(elem, value, ImportMPIView.RENAME);
                    }
                } else if (this.m_type.equals(ImportMPIView.PREFIX) || this.m_type.equals(ImportMPIView.SUFFIX)) {
                    HashMap<GroupTreeObject, String> elem = new HashMap<GroupTreeObject, String>();
                    StringBuffer sb = new StringBuffer();
                    for (GroupTreeObject gto2Rename : this.m_elements.keySet()) {
                        if (this.m_section.m_asnElemsNotInImport_butExistOnSrv.containsKey(gto2Rename.getPath())) continue;
                        String parentPath = gto2Rename.getParentPath();
                        String newName = String.valueOf(value) + gto2Rename.getName();
                        if (this.m_type.equals(ImportMPIView.SUFFIX)) {
                            newName = String.valueOf(gto2Rename.getName()) + value;
                        }
                        String path = String.valueOf(parentPath) + "/" + newName;
                        GroupTreeObject gtoFound = this.m_section.m_existingAsnTree.searchPath(path, gto2Rename.getType());
                        if (gtoFound != null) {
                            sb.append(path).append("\n");
                            continue;
                        }
                        elem.put(gto2Rename, null);
                    }
                    if (sb.length() > 0) {
                        new ShowMessageBox("  Rename ", "The following elements do already exist:\n" + sb.toString(), 2);
                        this.run();
                    }
                    this.m_section.renameElements(elem, value, this.m_type);
                }
            }
        }
    }

    public class ResetElementsAction
    extends Action {
        private ImportMPIAsnSection m_section;
        private String m_type;
        private Map<String, GroupTreeObject> m_elements;

        public ResetElementsAction(TreeViewer tv, GroupTreeObject root, ImportMPIAsnSection section, String type) {
            super("clearelements");
            this.m_section = null;
            this.m_type = null;
            this.m_elements = new HashMap<String, GroupTreeObject>();
            this.setId("clearelements");
            this.m_section = section;
            this.m_type = type;
            this.setText("Reset");
            if (tv == null || root == null || section == null || type == null) {
                this.setEnabled(false);
                return;
            }
            if (!this.m_type.equals(ImportMPIView.RESET_TREE)) {
                if (this.m_type.equals(RESET_ACTION_GRP)) {
                    this.setText("Reset Group");
                    StructuredSelection sel = (StructuredSelection)tv.getSelection();
                    if (sel.size() > 0) {
                        for (Object selected : sel) {
                            GroupTreeObject asnGto;
                            String gtoType;
                            if (selected instanceof GroupTreeObjectLast || !(gtoType = (asnGto = (GroupTreeObject)selected).getType()).equals(BMUI.type_assignment_pol)) continue;
                            this.m_elements.put(asnGto.getPath(), asnGto);
                        }
                    }
                    if (this.m_elements.size() == 0) {
                        this.setEnabled(false);
                    } else if (this.m_elements.size() > 1) {
                        this.setText("Reset Groups");
                    }
                    return;
                }
                this.setText("Reset");
                this.setEnabled(false);
                return;
            }
            this.setText("Reset Tree");
        }

        public void run() {
            if (!this.isEnabled()) {
                return;
            }
            if (this.m_type.equals(ImportMPIView.RESET_TREE)) {
                ImportMPIAsnSection.this.m_importMPIView.updateAsnSection(true);
            } else if (this.m_type.equals(RESET_ACTION_GRP)) {
                this.m_section.resetAsnGroups(this.m_elements);
            }
        }
    }

    public class ResolveBrokenLinksAction
    extends Action {
        private ImportMPIAsnSection m_section;
        private Map<GroupTreeObjectLast, String> m_elements;
        private Set<GroupTreeObject> m_asnGroups;

        public ResolveBrokenLinksAction(TreeViewer tv, GroupTreeObject root, ImportMPIAsnSection section) {
            super("resolveaction");
            this.m_section = null;
            this.m_elements = new HashMap<GroupTreeObjectLast, String>();
            this.m_asnGroups = new HashSet<GroupTreeObject>();
            this.setId("resolveaction");
            this.setText("Resolve Links");
            this.m_section = section;
            if (this.m_section == null) {
                this.setEnabled(false);
                return;
            }
            StructuredSelection sel = (StructuredSelection)tv.getSelection();
            if (sel.size() > 0) {
                ArrayList<GroupTreeObjectLast> map = new ArrayList<GroupTreeObjectLast>();
                for (Object selected : sel) {
                    if (selected instanceof GroupTreeObjectLast) {
                        map.add((GroupTreeObjectLast)selected);
                        continue;
                    }
                    if (!(selected instanceof GroupTreeObject)) continue;
                    GroupTreeObject gto = (GroupTreeObject)selected;
                    List<GroupTreeObject> asngroups = gto.getRoot().findGroups(null, BMUI.type_assignment_pol);
                    if (asngroups != null) {
                        this.m_asnGroups.addAll(asngroups);
                    }
                    if (gto.getType().equals(BMUI.type_toplevel)) {
                        map.clear();
                        map.addAll(GroupTreeObject.collectElements(gto));
                        break;
                    }
                    map.addAll(GroupTreeObject.collectElements(gto));
                }
                int i = 0;
                while (i < map.size()) {
                    GroupTreeObjectLast gtol = (GroupTreeObjectLast)map.get(i);
                    this.m_elements.put(gtol, gtol.getName());
                    ++i;
                }
            }
            if (this.m_elements.size() == 0) {
                this.setEnabled(false);
            }
        }

        public void run() {
            if (!this.isEnabled()) {
                return;
            }
            if (this.m_section == null || this.m_elements.size() == 0) {
                return;
            }
            for (GroupTreeObject pga : this.m_asnGroups) {
                ImportMPIAsnSection.this.cleanStatus(pga);
            }
            this.m_section.resolveBrokenLinks(this.m_elements);
        }
    }

    class StyledLabelProviderAsnImportTree
    extends StyledCellLabelProvider {
        ImportMPIAsnSection m_asnSection = null;

        public StyledLabelProviderAsnImportTree(ImportMPIAsnSection section) {
            this.m_asnSection = section;
        }

        public void update(ViewerCell cell) {
            Object element = cell.getElement();
            Image defaultIcon = BMUI.IMAGE_FOLDER_DEFAULT;
            Image icon = null;
            cell.setBackground(null);
            if (element instanceof GroupTreeObjectLast) {
                GroupTreeObjectLast gtol = (GroupTreeObjectLast)element;
                cell.setText(gtol.getName());
                icon = BMUI.IMAGE_MAP.get(gtol.getIcon());
                if (this.m_asnSection.doesElemBelongToNewAsnGroup(gtol)) {
                    cell.setForeground(BMUI.color_green);
                } else if (this.m_asnSection.doesElemExistWithAllElements(gtol)) {
                    cell.setForeground(BMUI.color_darkGrey2);
                } else if (this.m_asnSection.doesLinkExistButMissingInImport(gtol)) {
                    cell.setForeground(BMUI.color_darkGrey2);
                } else if (this.m_asnSection.isNewLink(gtol)) {
                    cell.setForeground(BMUI.color_green);
                } else {
                    cell.setForeground(BMUI.color_darkGrey2);
                }
            } else if (element instanceof GroupTreeObject) {
                GroupTreeObject gto = (GroupTreeObject)element;
                StyledString styledString = new StyledString();
                styledString.append(gto.getName());
                int count = ImportMPIAsnSection.this.getNumberOfMissingLinkedElemsInImportTree(gto);
                if (gto.getType().equals(BMUI.type_toplevel)) {
                    StyledString.Styler styler = StyledString.createColorRegistryStyler((String)ImportMPIView.COLOR_GREY, null);
                    String decoration = MessageFormat.format("  [{0}]", "" + count);
                    styledString.append(decoration, styler);
                }
                cell.setText(styledString.toString());
                cell.setStyleRanges(styledString.getStyleRanges());
                String type = gto.getTreeObject().getType();
                if (type != null) {
                    icon = BMUI.IMAGE_MAP.get(type);
                }
                if (!gto.getType().equals(BMUI.type_toplevel)) {
                    if (this.m_asnSection.doesLinkExistButMissingInImport(gto)) {
                        cell.setForeground(BMUI.color_darkGrey2);
                    } else if (this.m_asnSection.doesElemBelongToNewAsnGroup(gto)) {
                        cell.setForeground(BMUI.color_green);
                    } else if (this.m_asnSection.doesElemExistWithAllElements(gto)) {
                        cell.setForeground(BMUI.color_darkGrey2);
                    } else if (!this.m_asnSection.doMergeAsnGrp(gto) && this.m_asnSection.doesElemBelongToAsnGrpWithConflicts(gto)) {
                        cell.setForeground(BMUI.color_critical);
                    }
                }
            }
            if (icon == null) {
                icon = defaultIcon;
            }
            cell.setImage(icon);
            super.update(cell);
        }

        public String getToolTipText(Object element) {
            StringBuffer sbTT = new StringBuffer();
            sbTT.append("<html>").append("<head><style type=\"text/css\">").append("body { margin-left:5px; margin-right:5px; margin-top:5px; margin-bottom:5px }").append("</style></head>").append("<body bgcolor='#FFFFE1'>");
            if (element instanceof GroupTreeObjectLast) {
                GroupTreeObjectLast gtol = (GroupTreeObjectLast)element;
                sbTT.append("<font face='Arial' size='1' color='#000000'>").append("<p style='margin-bottom:5px'>").append(gtol.getName()).append("</p>");
                if (this.m_asnSection.doesElemBelongToNewAsnGroup(gtol)) {
                    sbTT.append("<b>").append("Link belongs to a new AsnGroup.").append("</b>");
                } else if (this.m_asnSection.doesElemExistWithAllElements(gtol)) {
                    sbTT.append("<b>").append("This Link is part of an AsnGroup that does exist with all elements.").append("<br>").append("Related AsnGroup will not be imported!").append("</b>");
                } else if (this.m_asnSection.doesLinkExistButMissingInImport(gtol)) {
                    sbTT.append("<b>").append("(FYI) This Link exists on the server").append("<br>").append("but is NOT part of the incoming AsnGroup.").append("</b>");
                } else if (this.m_asnSection.isNewLink(gtol)) {
                    sbTT.append("<b>").append("New incoming Link.").append("</b>");
                } else {
                    sbTT.append("<b>").append("This Link exists already on the server and will not be imported.").append("<br>").append("-> We cannot overwrite existing Links!").append("</b>");
                }
                sbTT.append("</font>");
            } else if (element instanceof GroupTreeObject) {
                GroupTreeObject gto = (GroupTreeObject)element;
                if (gto.getType().equals(BMUI.type_assignment_pol)) {
                    sbTT.append("<font face='Arial' size='1' color='#000000'>").append("<p style='margin-bottom:5px'>").append(gto.getName()).append("</p>");
                    if (this.m_asnSection.doesElemBelongToNewAsnGroup(gto)) {
                        sbTT.append("<b>").append("New incoming AsnGroup.").append("</b>");
                    } else if (this.m_asnSection.doesElemExistWithAllElements(gto)) {
                        sbTT.append("<b>").append("Skip Import! AsnGroup exists with all elements.").append("</b>");
                    } else if (this.m_asnSection.doMergeAsnGrp(gto)) {
                        sbTT.append("<b>").append("AsnGroup will be merged.").append("</b>");
                    } else if (this.m_asnSection.doesElemBelongToAsnGrpWithConflicts(gto)) {
                        sbTT.append("<b>").append("AsnGroup has some conflicts inside!").append("</b>");
                    }
                    sbTT.append("</font>");
                } else {
                    sbTT.append("<font face='Arial' size='1' color='#000000'>").append(gto.getName()).append("</font>");
                }
            }
            sbTT.append("</body></html>");
            return sbTT.toString();
        }

        public Point getToolTipShift(Object object) {
            return new Point(3, 3);
        }

        public int getToolTipDisplayDelayTime(Object object) {
            return 50;
        }

        public int getToolTipTimeDisplayed(Object object) {
            return 9999999;
        }
    }

    class StyledLabelProviderAsnTree
    extends StyledCellLabelProvider {
        private ImportMPIAsnSection m_asnSection = null;
        private TreeViewer m_tv = null;

        public StyledLabelProviderAsnTree(ImportMPIAsnSection section, TreeViewer tv) {
            this.m_asnSection = section;
            this.m_tv = tv;
        }

        public void update(ViewerCell cell) {
            Object element = cell.getElement();
            Image defaultIcon = BMUI.IMAGE_FOLDER_DEFAULT;
            Image icon = null;
            if (element instanceof GroupTreeObjectLast) {
                GroupTreeObjectLast gtol = (GroupTreeObjectLast)element;
                cell.setText(gtol.getName());
                icon = BMUI.IMAGE_MAP.get(gtol.getIcon());
                if (this.m_asnSection.isLinkRemovedFromImport(gtol)) {
                    cell.setForeground(BMUI.color_critical);
                }
            } else if (element instanceof GroupTreeObject) {
                GroupTreeObject gto = (GroupTreeObject)element;
                String type = gto.getTreeObject().getType();
                if (type != null) {
                    icon = BMUI.IMAGE_MAP.get(type);
                }
                StyledString styledString = new StyledString();
                styledString.append(gto.getName());
                int count = this.m_asnSection.getNumberOfInvalidLinks(gto);
                StyledString.Styler styler = StyledString.createColorRegistryStyler((String)ImportMPIView.COLOR_GREY, null);
                String decoration = MessageFormat.format("  [{0}]", "" + count);
                styledString.append(decoration, styler);
                cell.setText(styledString.toString());
                cell.setStyleRanges(styledString.getStyleRanges());
            }
            if (icon == null) {
                icon = defaultIcon;
            }
            cell.setImage(icon);
            super.update(cell);
        }

        public String getToolTipText(Object element) {
            StringBuffer sbTT = new StringBuffer();
            sbTT.append("<html>").append("<head><style type=\"text/css\">").append("body { margin-left:5px; margin-right:5px; margin-top:5px; margin-bottom:5px }").append("</style></head>").append("<body bgcolor='#FFFFE1'>");
            if (element instanceof GroupTreeObjectLast) {
                GroupTreeObjectLast gtol = (GroupTreeObjectLast)element;
                String name = "";
                if (gtol.getType().equals(BMUI.type_mon) || gtol.getType().equals(BMUI.type_msg)) {
                    name = "Policy";
                } else if (gtol.getType().equals(BMUI.type_assignment_bin)) {
                    name = "Binary";
                }
                if (this.m_asnSection.isLinkBroken(gtol)) {
                    sbTT.append("<table border='0' cellspacing='0' cellpadding='0'>").append("<tr valign='top'><td nowrap colspan='2'>").append("<font face='Arial' size='1' color='#000000'>").append("<p style='margin-bottom:5px'>").append(gtol.getName()).append("</p>").append("</font></td></tr>").append("<tr valign='top'><td nowrap><font face='Arial' size='1' color='#000000'>").append("Warning:&nbsp;&nbsp;").append("</font></td>").append("<td nowrap ><font face='Arial' size='1' color='#000000'><b>").append("Broken Link<br>").append(name).append(" is missing in import, but does exist on the Server. <br>").append(name).append(" link can be imported!").append("</b></font></td></tr>").append("</table>");
                } else if (this.m_asnSection.isLinkRemovedFromImport(gtol)) {
                    sbTT.append("<table border='0' cellspacing='0' cellpadding='0'>").append("<tr valign='top'><td nowrap colspan='2'>").append("<font face='Arial' size='1' color='#000000'>").append("<p style='margin-bottom:5px'>").append(gtol.getName()).append("</p>").append("</font></td></tr>").append("<tr valign='top'><td nowrap><font face='Arial' size='1' color='#000000'>").append("Conflict:&nbsp;&nbsp;").append("</font></td>").append("<td nowrap ><font face='Arial' size='1' color='#000000'><b>").append("Invalid Link <br>").append(name).append(" is missing in import and does not exist on the server. <br>").append(name).append(" link CANNOT be imported!").append("</b></font></td></tr>").append("</table>");
                } else {
                    sbTT.append("<font face='Arial' size='1' color='#000000'>").append(gtol.getName()).append("</font");
                }
            } else if (element instanceof GroupTreeObject) {
                GroupTreeObject gto = (GroupTreeObject)element;
                int broken = this.m_asnSection.getNumberOfBrokenLinks(gto);
                int invalid = this.m_asnSection.getNumberOfInvalidLinks(gto);
                if (broken > 0 || invalid > 0) {
                    sbTT.append("<table border='0' cellspacing='0' cellpadding='0'>").append("<tr valign='top'><td nowrap colspan='2'>").append("<font face='Arial' size='1' color='#000000'>").append("<p style='margin-bottom:5px'>").append(gto.getName()).append("</p>").append("</font></td></tr>").append("<tr valign='top'><td nowrap><font face='Arial' size='1' color='#000000'>").append("Conflict:&nbsp;&nbsp;").append("</font></td>").append("<td nowrap ><font face='Arial' size='1' color='#000000'><b>").append(invalid).append(" invalid links").append("</b></font></td></tr>").append("<tr valign='top'><td nowrap><font face='Arial' size='1' color='#000000'>").append("Warning:").append("</font></td>").append("<td nowrap ><font face='Arial' size='1' color='#000000'><b>").append(broken).append(" broken links").append("</b></font></td></tr>").append("</table>");
                } else {
                    sbTT.append("<font face='Arial' size='1' color='#000000'>").append(gto.getName()).append("</font>");
                }
            }
            sbTT.append("</body></html>");
            return sbTT.toString();
        }

        public Point getToolTipShift(Object object) {
            return new Point(3, 3);
        }

        public int getToolTipDisplayDelayTime(Object object) {
            return 50;
        }

        public int getToolTipTimeDisplayed(Object object) {
            return 9999999;
        }
    }
}

