/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.engine.UIJob;
import com.blixx.boom.gui.dialogs.NameValidatorFile;
import com.blixx.boom.gui.dialogs.ShowMessageBox;
import com.blixx.boom.gui.policies.ViewContentProvider;
import com.blixx.boom.gui.utils.GUIDisplayElements;
import com.blixx.boom.gui.utils.STreeViewer;
import com.blixx.boom.gui.views.FancyToolTipSupport;
import com.blixx.boom.gui.views.ImportMPIView;
import com.blixx.boom.gui.views.actions.ExpandCollapseAction;
import com.blixx.ctrl.sc.ICmdPostProcess;
import com.blixx.ctrl.sc.ServerClient;
import com.blixx.ctrl.sc.in.ScGetBinaryTreeMD5;
import com.blixx.ctrl.sc.in.ScValidateCmd;
import com.blixx.log.RTLogger;
import com.blixx.shared.utils.FileSyncUtils;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.GroupTreeObjectLast;
import com.blixx.shared.utils.ITreeObject;
import com.blixx.shared.utils.MD5;
import com.blixx.shared.utils.ShabalUtils;
import com.blixx.shared.utils.TreeObject;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class ImportMPIBinarySection
extends Section
implements IExpansionListener,
SelectionListener,
ISelectionChangedListener,
ICmdPostProcess {
    private ImportMPIBinarySection m_binSection = null;
    private ImportMPIView m_importMPIView = null;
    private GroupTreeObject m_existingBinTree = null;
    private String m_packagesDir = null;
    public GroupTreeObject m_binRoot = null;
    private GroupTreeObject m_bin4ImportRoot = null;
    private TreeViewer m_tv_bin = null;
    private TreeViewer m_tv_bin4Import = null;
    private ContentProviderBinImportTree m_treeContentProvider_final = null;
    private String m_importDir = null;
    private GUIDisplayElements m_gui = null;
    private FormToolkit m_toolkit = null;
    private Composite m_sectionClient = null;
    private Text m_binFooter = null;
    private Text m_bin4ImportFooter = null;
    private int m_totalImportConflicts = 0;
    public HashMap<String, GroupTreeObject> m_allIncomingBinaries = new HashMap();
    public Map<String, GroupTreeObject> m_binNew = new HashMap<String, GroupTreeObject>();
    public Map<String, GroupTreeObject> m_binExist = new HashMap<String, GroupTreeObject>();
    public Map<String, String> m_binNewAfterRename = new HashMap<String, String>();
    public Map<String, GroupTreeObject> m_binSkipImport = new HashMap<String, GroupTreeObject>();
    public Map<String, GroupTreeObject> m_bin2Overwrite = new HashMap<String, GroupTreeObject>();
    private Map<String, String> m_equalByContent = new HashMap<String, String>();
    public static String RESET_BINARY = "RESET_BINARY";
    private static String ADD_BTN = "ADD_BTN";
    private static String REMOVE_BTN = "REMOVE_BTN";
    private static String RENAME_BTN = "RENAME_BTN";
    private static String ADD_PREFIX_BTN = "ADD_PREFIX_BTN";
    private static String ADD_SUFFIX_BTN = "ADD_SUFFIX_BTN";
    private static String OVERWRITE_BTN = "OVERWRITE_BTN";
    private static String RESET_TREE_BTN = "RESET_TREE_BTN";
    private static String REMOVE_FROM_IMPORT_BTN = "REMOVE_FROM_IMPORT_BTN";
    private static String CONTENT_COMPARE_BTN = "CONTENT_COMPARE_BTN";
    private Button m_add_btn = null;
    private Button m_remove_btn = null;
    private Button m_rename_btn = null;
    private Button m_addPrefix_btn = null;
    private Button m_addSuffix_btn = null;
    private Button m_overwrite_btn = null;
    private Button m_resetTree_btn = null;
    private Button m_removeFromImport_btn = null;
    private Button m_contentCompare_btn = null;
    Listener paintListenerBinTree = new Listener(){

        public void handleEvent(Event event) {
            GroupTreeObjectLast gtol;
            Image icon;
            TreeItem ti;
            Object o;
            Widget obj = event.item;
            if (obj instanceof TreeItem && (o = (ti = (TreeItem)event.item).getData()) instanceof GroupTreeObjectLast && (icon = ImportMPIBinarySection.this.getIcon(gtol = (GroupTreeObjectLast)o, ImportMPIView.BIN)) != null) {
                switch (event.type) {
                    case 41: {
                        Rectangle rect = icon.getBounds();
                        event.width += rect.width;
                        event.height = Math.max(event.height, rect.height + 2);
                        break;
                    }
                    case 42: {
                        int x = event.x + event.width;
                        Rectangle rect = icon.getBounds();
                        int offset = Math.max(0, (event.height - rect.height) / 2);
                        event.gc.drawImage(icon, x, event.y + offset);
                    }
                }
            }
        }
    };
    Listener paintListenerBinImportTree = new Listener(){

        public void handleEvent(Event event) {
            Widget obj = event.item;
            if (obj instanceof TreeItem) {
                TreeItem ti = (TreeItem)event.item;
                Object o = ti.getData();
                Image icon = null;
                if (o instanceof GroupTreeObjectLast) {
                    GroupTreeObjectLast gtol = (GroupTreeObjectLast)o;
                    icon = ImportMPIBinarySection.this.getIcon(gtol, ImportMPIView.BIN_4IMPORT);
                } else if (o instanceof GroupTreeObject) {
                    GroupTreeObject gto = (GroupTreeObject)o;
                    icon = ImportMPIBinarySection.this.getIcon(gto, ImportMPIView.BIN_4IMPORT);
                }
                if (icon != null) {
                    switch (event.type) {
                        case 41: {
                            Rectangle rect = icon.getBounds();
                            event.width += rect.width;
                            event.height = Math.max(event.height, rect.height + 2);
                            break;
                        }
                        case 42: {
                            int x = event.x + event.width;
                            Rectangle rect = icon.getBounds();
                            int offset = Math.max(0, (event.height - rect.height) / 2);
                            event.gc.drawImage(icon, x, event.y + offset);
                        }
                    }
                }
            }
        }
    };

    public ImportMPIBinarySection(Composite parent, ImportMPIView importMPIView) {
        super(parent, 578);
        this.setText("Binaries");
        this.setLayoutData(new GridData(4, 128, true, false));
        this.m_binSection = this;
        this.m_importMPIView = importMPIView;
    }

    public void initSection() {
        this.m_gui = new GUIDisplayElements();
        this.m_toolkit = BMUI.getFormToolkit(Display.getCurrent());
        this.m_sectionClient = this.m_toolkit.createComposite((Composite)this.m_binSection, 0);
        this.m_sectionClient.setLayout((Layout)new GridLayout(2, false));
        this.m_sectionClient.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite treeComp = new Composite(this.m_sectionClient, 0);
        GridLayout gl = new GridLayout(3, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        treeComp.setLayout((Layout)gl);
        treeComp.setLayoutData((Object)new GridData(4, 4, true, true));
        Group importTree_grp = new Group(treeComp, 32);
        importTree_grp.setText("Binaries");
        importTree_grp.setLayout((Layout)new GridLayout(1, false));
        importTree_grp.setLayoutData((Object)new GridData(4, 4, true, true));
        this.m_tv_bin = new STreeViewer((Composite)importTree_grp, 268438274);
        this.m_tv_bin.setData(ImportMPIView.TREE_VIEWER_TYPE, (Object)ImportMPIView.BIN);
        this.m_tv_bin.getTree().setLayoutData((Object)ImportMPIView.m_sectionTree_gd);
        this.m_tv_bin.setUseHashlookup(true);
        this.m_tv_bin.setContentProvider((IContentProvider)new ViewContentProvider());
        this.m_tv_bin.setLabelProvider((IBaseLabelProvider)new StyledLabelProviderBinTree(this));
        this.m_tv_bin.setInput((Object)this.m_binRoot);
        this.m_tv_bin.addSelectionChangedListener((ISelectionChangedListener)this);
        this.m_tv_bin.getTree().addListener(41, this.paintListenerBinTree);
        this.m_tv_bin.getTree().addListener(42, this.paintListenerBinTree);
        this.createXMLTree_CM();
        this.m_binFooter = this.m_gui.addTextReadOnlyNoBorder((Composite)importTree_grp, null, "", 1, 1, 1, 1, BMUI.font_arial8);
        this.updateTreeFooter(this.m_tv_bin);
        Composite btn1Comp = new Composite(treeComp, 0);
        gl = new GridLayout(1, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        btn1Comp.setLayout((Layout)gl);
        btn1Comp.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        this.m_add_btn = this.m_gui.addButton(btn1Comp, ADD_BTN, " >> ", false, this);
        this.m_remove_btn = this.m_gui.addButton(btn1Comp, REMOVE_BTN, " << ", false, this);
        Group finalTree_grp = new Group(treeComp, 32);
        finalTree_grp.setText("Preview");
        finalTree_grp.setLayout((Layout)new GridLayout(1, false));
        finalTree_grp.setLayoutData((Object)new GridData(4, 4, true, true));
        this.m_tv_bin4Import = new STreeViewer((Composite)finalTree_grp, 268438274);
        this.m_tv_bin4Import.setData(ImportMPIView.TREE_VIEWER_TYPE, (Object)ImportMPIView.BIN_4IMPORT);
        this.m_tv_bin4Import.getTree().setLayoutData((Object)ImportMPIView.m_sectionTree_gd);
        this.m_tv_bin4Import.setUseHashlookup(true);
        this.m_treeContentProvider_final = new ContentProviderBinImportTree();
        this.m_tv_bin4Import.setContentProvider((IContentProvider)this.m_treeContentProvider_final);
        this.m_tv_bin4Import.setLabelProvider((IBaseLabelProvider)new StyledLabelProviderBinImportTree(this));
        this.m_tv_bin4Import.setInput((Object)this.m_bin4ImportRoot);
        this.m_tv_bin4Import.addSelectionChangedListener((ISelectionChangedListener)this);
        this.m_tv_bin4Import.getTree().addListener(41, this.paintListenerBinImportTree);
        this.m_tv_bin4Import.getTree().addListener(42, this.paintListenerBinImportTree);
        this.createFinalTree_CM();
        FancyToolTipSupport.enableFor((ColumnViewer)this.m_tv_bin4Import, 2);
        this.m_tv_bin4Import.getTree().setToolTipText("");
        this.m_bin4ImportFooter = this.m_gui.addTextReadOnlyNoBorder((Composite)finalTree_grp, null, "", 1, 1, 1, 1, BMUI.font_arial8);
        this.updateTreeFooter(this.m_tv_bin4Import);
        Composite btnComp = new Composite(this.m_sectionClient, 0);
        btnComp.setLayout((Layout)new GridLayout(1, false));
        btnComp.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.m_rename_btn = this.m_gui.addButton(btnComp, RENAME_BTN, "Rename", false, this);
        this.m_rename_btn.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.m_addPrefix_btn = this.m_gui.addButton(btnComp, ADD_PREFIX_BTN, "Add Prefix", false, this);
        this.m_addPrefix_btn.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.m_addSuffix_btn = this.m_gui.addButton(btnComp, ADD_SUFFIX_BTN, "Add Suffix", false, this);
        this.m_addSuffix_btn.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.m_overwrite_btn = this.m_gui.addButton(btnComp, OVERWRITE_BTN, "Overwrite", false, this);
        this.m_overwrite_btn.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.m_resetTree_btn = this.m_gui.addButton(btnComp, RESET_TREE_BTN, "Reset Tree", false, this);
        this.m_resetTree_btn.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.m_removeFromImport_btn = this.m_gui.addButton(btnComp, REMOVE_FROM_IMPORT_BTN, "Remove", false, this);
        this.m_removeFromImport_btn.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.m_contentCompare_btn = this.m_gui.addButton(btnComp, CONTENT_COMPARE_BTN, "Compare with server", false, this);
        this.m_contentCompare_btn.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.setClient((Control)this.m_sectionClient);
        this.addExpansionListener(this);
    }

    public void updateSection(String importDir, boolean resetAction) {
        if (!this.isEnabled()) {
            return;
        }
        this.m_allIncomingBinaries.clear();
        this.m_binNew.clear();
        this.m_binNewAfterRename.clear();
        this.m_binExist.clear();
        this.m_bin2Overwrite.clear();
        this.m_binSkipImport.clear();
        this.m_equalByContent.clear();
        this.m_importDir = importDir;
        this.loadBinaries();
        if (this.m_binRoot != null) {
            try {
                this.m_bin4ImportRoot = this.m_binRoot.clone();
                this.processClonedTree();
                this.checkConflicts();
                ContentCompare cc = new ContentCompare(this);
                cc.run();
                this.m_contentCompare_btn.setEnabled(false);
            }
            catch (CloneNotSupportedException e) {
                this.m_bin4ImportRoot = null;
                RTLogger.print(5, "ImportMPI: Error cloning import tree", e);
            }
        }
        int expLevel = 2;
        if (resetAction) {
            expLevel = -1;
        }
        this.refreshTree(this.m_tv_bin, this.m_binRoot, 2);
        this.refreshTree(this.m_tv_bin4Import, this.m_bin4ImportRoot, expLevel);
        if (this.m_binRoot == null || this.m_binRoot.getElements().size() == 0) {
            this.setExpanded(false);
        } else {
            this.setExpanded(true);
        }
    }

    private void processClonedTree() {
        List<GroupTreeObject> elements = this.m_bin4ImportRoot.getAllElements();
        for (GroupTreeObject gto : elements) {
            GroupTreeObject orig = this.m_binRoot.searchPath(gto.getPath(), gto.getType());
            if (orig == null) continue;
            gto.getTreeObject().setObject(orig.getPath());
        }
    }

    private void loadBinaries() {
        File[] binList;
        this.m_binRoot = null;
        this.m_bin4ImportRoot = null;
        if (!this.m_importDir.endsWith(File.separator)) {
            this.m_importDir = String.valueOf(this.m_importDir) + File.separator;
        }
        this.m_packagesDir = String.valueOf(this.m_importDir) + "packages";
        File pkgDir = new File(this.m_packagesDir);
        if (pkgDir.exists() && pkgDir.isDirectory() && (binList = pkgDir.listFiles()) != null && binList.length != 0) {
            GroupTreeObject toplevelGTO;
            this.m_importMPIView.updateProgressBar("Reading Binaries", 0, binList.length);
            if (this.m_binRoot == null) {
                this.m_binRoot = new GroupTreeObject(new TreeObject("root", BMUI.type_folder, null));
                this.m_binRoot.addElement(new GroupTreeObject(new TreeObject("Packages", BMUI.type_toplevel, null)));
            }
            if ((toplevelGTO = this.m_binRoot.getFirstChild("Packages")) == null) {
                toplevelGTO = new GroupTreeObject(new TreeObject("Packages", BMUI.type_folder, null));
                this.m_binRoot.addElement(toplevelGTO);
            }
            int i = 0;
            while (i < binList.length) {
                File binary = binList[i];
                if (binary.isDirectory()) {
                    GroupTreeObject binGTO = new GroupTreeObject(new TreeObject(binary.getName(), BMUI.type_assignment_bin, null));
                    File[] binElems = binary.listFiles();
                    if (binElems != null && binElems.length > 0) {
                        this.loadBinaryElements(binElems, binGTO);
                    }
                    this.m_allIncomingBinaries.put(binGTO.getName(), binGTO);
                    toplevelGTO.addElement(binGTO);
                    try {
                        MD5 digest = new MD5();
                        FileSyncUtils.updateDigestRecursively(digest, binary);
                        String crc = ShabalUtils.getHex(digest);
                        binGTO.setAttribute("MD5", crc);
                    }
                    catch (Throwable throwable) {}
                }
                this.m_importMPIView.updateProgressBar("Reading Binaries", i, binList.length);
                ++i;
            }
        }
    }

    public void loadBinaryElements(File[] elements, GroupTreeObject parentGTO) {
        int i = 0;
        while (i < elements.length) {
            File[] elems;
            File elem = elements[i];
            if (elem.isFile()) {
                GroupTreeObjectLast fileGTOL = new GroupTreeObjectLast(new TreeObject(elem.getName(), BMUI.type_file, null), null, null);
                parentGTO.addElement(fileGTOL);
            } else if (elem.isDirectory() && (elems = elem.listFiles()) != null && elems.length > 0) {
                GroupTreeObject folder = new GroupTreeObject(new TreeObject(elem.getName(), BMUI.type_folder, null));
                parentGTO.addElement(folder);
                this.loadBinaryElements(elems, folder);
            }
            ++i;
        }
    }

    public void checkConflicts() {
        this.m_existingBinTree = Repository.getInstance().getBinaryTree();
        for (GroupTreeObject inBinGto : this.m_allIncomingBinaries.values()) {
            GroupTreeObject existBinary = this.m_existingBinTree.searchPath(inBinGto.getPath(), BMUI.type_assignment_bin);
            if (existBinary == null) {
                this.m_binNew.put(inBinGto.getName(), inBinGto);
                continue;
            }
            this.m_binExist.put(inBinGto.getName(), inBinGto);
        }
    }

    public void clearSection() {
        this.m_binRoot = null;
        this.m_bin4ImportRoot = null;
        this.refreshTree(this.m_tv_bin, this.m_binRoot, 0);
        this.refreshTree(this.m_tv_bin4Import, this.m_bin4ImportRoot, 0);
    }

    public void updateTreeFooter(TreeViewer tv) {
        StringBuffer sb = new StringBuffer();
        String type = (String)tv.getData(ImportMPIView.TREE_VIEWER_TYPE);
        if (type.equalsIgnoreCase(ImportMPIView.BIN)) {
            GroupTreeObject toplevelGTO;
            int totalBinGrps = 0;
            if (this.m_binRoot != null && (toplevelGTO = this.m_binRoot.getFirstChild("Packages")) != null) {
                List<GroupTreeObject> packages = toplevelGTO.getElements();
                totalBinGrps = packages.size();
            }
            sb.append("Binaries (").append(totalBinGrps).append(")");
            this.m_binFooter.setText(sb.toString());
            this.m_binFooter.pack(true);
        } else if (type.equalsIgnoreCase(ImportMPIView.BIN_4IMPORT)) {
            GroupTreeObject toplevelGTO;
            int totalBinGrps = 0;
            this.m_totalImportConflicts = 0;
            if (this.m_bin4ImportRoot != null && (toplevelGTO = this.m_bin4ImportRoot.getFirstChild("Packages")) != null) {
                List<GroupTreeObject> packages = toplevelGTO.getElements();
                totalBinGrps = packages.size();
                for (GroupTreeObject binGto : packages) {
                    if (!this.hasConflict(binGto)) continue;
                    ++this.m_totalImportConflicts;
                }
            }
            sb.append("Binaries (").append(totalBinGrps).append(")").append("  Conflicts (").append(this.m_totalImportConflicts).append(")");
            this.m_bin4ImportFooter.setText(sb.toString());
            this.m_bin4ImportFooter.pack(true);
        }
    }

    public GroupTreeObject getOriginalElement(GroupTreeObject gto) {
        if (gto == null) {
            return null;
        }
        GroupTreeObject origGTO = null;
        ITreeObject to = gto.getTreeObject();
        if (to != null) {
            Object o = to.getObject();
            if (o instanceof GroupTreeObject) {
                origGTO = (GroupTreeObject)o;
            } else if (o instanceof String) {
                String origPath = (String)o;
                origGTO = this.m_binRoot.searchPath(origPath, gto.getType());
            }
        }
        return origGTO;
    }

    public GroupTreeObject cloneElement(GroupTreeObject gto) {
        if (gto == null) {
            return null;
        }
        GroupTreeObject clone = null;
        try {
            clone = gto.clone();
            clone.getTreeObject().setObject(gto.getPath());
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        return clone;
    }

    private GroupTreeObject getParentBinary(GroupTreeObject gto) {
        if (gto == null) {
            return null;
        }
        String type = gto.getType();
        GroupTreeObject gto2 = gto;
        while (!type.equals(BMUI.type_assignment_bin)) {
            GroupTreeObject parent = gto2.getParent();
            if (parent == null) break;
            type = parent.getType();
            gto2 = parent;
        }
        return gto2;
    }

    public boolean hasInitialConflict(GroupTreeObject binGto) {
        boolean hasConflict = false;
        if (this.doesElemBelongToExistingBinary(binGto)) {
            hasConflict = true;
        }
        return hasConflict;
    }

    public boolean hasConflict(GroupTreeObject binGto) {
        GroupTreeObject origGTO;
        boolean hasConflict = false;
        if (this.hasInitialConflict(binGto) && (origGTO = this.getOriginalElement(binGto)) != null && !this.m_equalByContent.containsKey(binGto.getName()) && !this.doOverwriteBinary(binGto) && !this.m_binNewAfterRename.containsKey(origGTO.getName())) {
            hasConflict = true;
        }
        return hasConflict;
    }

    public boolean isLinkedBinaryPartOfImport(String binName) {
        return this.m_allIncomingBinaries.containsKey(binName);
    }

    public boolean isLinkedBinaryPartOfImportTree(String originalBinName, String currentBinPath) {
        GroupTreeObject binOrig;
        if (this.m_allIncomingBinaries.containsKey(originalBinName) && (binOrig = this.m_allIncomingBinaries.get(originalBinName)) != null && this.m_bin4ImportRoot != null) {
            GroupTreeObject gtoExist = this.m_bin4ImportRoot.searchPath(currentBinPath, BMUI.type_assignment_bin);
            if (gtoExist == null && this.m_binNewAfterRename.containsKey(originalBinName)) {
                String newName = this.m_binNewAfterRename.get(originalBinName);
                try {
                    gtoExist = this.m_bin4ImportRoot.getFirstChild("Packages").getFirstChild(newName);
                }
                catch (Exception exception) {}
            }
            if (gtoExist != null) {
                return true;
            }
        }
        return false;
    }

    public boolean doesBinaryPackageExistOnServer(String binPkgName) {
        GroupTreeObjectLast gtoFound = this.m_existingBinTree.findElement(binPkgName, BMUI.type_assignment_bin);
        return gtoFound != null;
    }

    public boolean doesElemBelongToNewBinary(GroupTreeObject gto) {
        if (gto == null) {
            return false;
        }
        boolean isNew = false;
        GroupTreeObject binGto = this.getParentBinary(gto);
        if (binGto != null) {
            String currBinPath = binGto.getPath();
            GroupTreeObject gtoOrig = this.getOriginalElement(binGto);
            if (gtoOrig != null) {
                if (!currBinPath.equals(gtoOrig.getPath())) {
                    isNew = true;
                } else if (this.m_binNew.containsKey(gtoOrig.getName())) {
                    isNew = true;
                }
            }
        }
        return isNew;
    }

    public boolean doesElemBelongToExistingBinary(GroupTreeObject gto) {
        GroupTreeObject origGto;
        if (gto == null) {
            return false;
        }
        boolean belongToExist = false;
        GroupTreeObject binGto = this.getParentBinary(gto);
        if (binGto != null && (origGto = this.getOriginalElement(binGto)) != null) {
            belongToExist = this.m_binExist.containsKey(origGto.getName());
        }
        return belongToExist;
    }

    public boolean doOverwriteBinary(GroupTreeObject gto) {
        GroupTreeObject origGto;
        if (gto == null) {
            return false;
        }
        boolean overwrite = false;
        GroupTreeObject binGto = this.getParentBinary(gto);
        if (binGto != null && (origGto = this.getOriginalElement(binGto)) != null) {
            overwrite = this.m_bin2Overwrite.containsKey(origGto.getName());
        }
        return overwrite;
    }

    public Image getIcon(GroupTreeObject gto, String treeType) {
        if (gto == null || treeType == null) {
            return null;
        }
        if (!treeType.equals(ImportMPIView.BIN) && treeType.equals(ImportMPIView.BIN_4IMPORT) && gto.getType().equals(BMUI.type_assignment_bin) && !this.doesElemBelongToNewBinary(gto) && this.doesElemBelongToExistingBinary(gto)) {
            this.doOverwriteBinary(gto);
        }
        return null;
    }

    public int getTotalImportConflicts() {
        return this.m_totalImportConflicts;
    }

    public void resolveBrokenLinks(Map<GroupTreeObjectLast, String> elements) {
        for (GroupTreeObjectLast link2Resolve : elements.keySet()) {
            GroupTreeObject gtoExist;
            GroupTreeObject binOrig;
            String binPath = link2Resolve.getLinkedPath();
            String binName = link2Resolve.getName();
            String type = link2Resolve.getType();
            if (!type.equals(BMUI.type_assignment_bin) || !this.m_allIncomingBinaries.containsKey(binName) || (binOrig = this.m_allIncomingBinaries.get(binName)) == null || (gtoExist = this.m_bin4ImportRoot.searchPath(binPath, type)) != null || this.m_binNewAfterRename.containsKey(binOrig.getName())) continue;
            this.m_importMPIView.addElement2Tree(this.m_bin4ImportRoot, binOrig, binOrig.getParentPath());
        }
        this.refreshTree(this.m_tv_bin4Import, this.m_bin4ImportRoot, -1);
    }

    public void renameElements(Map<GroupTreeObject, String> elements, String value, String type) {
        for (GroupTreeObject gto : elements.keySet()) {
            if (type.equals(ImportMPIView.PREFIX)) {
                gto.setName(String.valueOf(value) + gto.getName());
            } else if (type.equals(ImportMPIView.SUFFIX)) {
                gto.setName(String.valueOf(gto.getName()) + value);
            } else if (type.equals(ImportMPIView.RENAME)) {
                gto.setName(value);
            }
            GroupTreeObject origGto = this.getOriginalElement(gto);
            if (origGto == null) continue;
            this.removeFromHashMaps(origGto);
            String newName = gto.getName();
            this.m_binNewAfterRename.put(origGto.getName(), newName);
        }
        this.refreshTree(this.m_tv_bin4Import, this.m_bin4ImportRoot, -1);
    }

    public void overwriteBinaries(Map<String, GroupTreeObject> binaries) {
        for (String binName : binaries.keySet()) {
            GroupTreeObject origGTO;
            GroupTreeObject binGTO = binaries.get(binName);
            if (!binGTO.getType().equals(BMUI.type_assignment_bin) || (origGTO = this.getOriginalElement(binGTO)) == null) continue;
            this.removeFromHashMaps(origGTO);
            this.m_bin2Overwrite.put(origGTO.getName(), origGTO);
        }
        this.refreshTree(this.m_tv_bin4Import, this.m_bin4ImportRoot, -1);
    }

    public void removeFromImport(Map<GroupTreeObject, String> elements) {
        for (GroupTreeObject gto : elements.keySet()) {
            GroupTreeObject gtoExist;
            if (gto instanceof GroupTreeObjectLast || (gtoExist = this.m_bin4ImportRoot.searchPath(gto.getPath(), gto.getType())) == null) continue;
            gtoExist.getParent().removeElement(gtoExist);
            GroupTreeObject origGTO = this.getOriginalElement(gto);
            if (origGTO == null) continue;
            this.removeFromHashMaps(origGTO);
            this.m_binSkipImport.put(origGTO.getName(), origGTO);
        }
        this.refreshTree(this.m_tv_bin4Import, this.m_bin4ImportRoot, -1);
    }

    public void resetBinGroups(Map<String, GroupTreeObject> elements) {
        for (GroupTreeObject currBinGto : elements.values()) {
            GroupTreeObject origBinGto = this.getOriginalElement(currBinGto);
            if (origBinGto == null) continue;
            this.removeFromHashMaps(origBinGto);
            GroupTreeObject parent = currBinGto.getParent();
            parent.removeElement(currBinGto);
            GroupTreeObject clone = this.cloneElement(origBinGto);
            parent.addElement(clone);
        }
        this.refreshTree(this.m_tv_bin4Import, this.m_bin4ImportRoot, -1);
    }

    public void addToImport(Map<GroupTreeObject, String> elements) {
        for (GroupTreeObject origGTO : elements.keySet()) {
            this.removeFromHashMaps(origGTO);
            if (!this.m_bin4ImportRoot.hasElements().booleanValue()) {
                this.m_bin4ImportRoot.addElement(new GroupTreeObject(new TreeObject("Packages", BMUI.type_toplevel, null)));
            }
            this.m_importMPIView.addElement2Tree(this.m_bin4ImportRoot, origGTO, origGTO.getParentPath());
        }
        this.refreshTree(this.m_tv_bin4Import, this.m_bin4ImportRoot, -1);
    }

    public void removeFromHashMaps(GroupTreeObject origGTO) {
        if (origGTO == null) {
            return;
        }
        String origName = origGTO.getName();
        if (this.m_binSkipImport.containsKey(origName)) {
            this.m_binSkipImport.remove(origName);
        }
        if (this.m_bin2Overwrite.containsKey(origName)) {
            this.m_bin2Overwrite.remove(origName);
        }
        if (this.m_binNewAfterRename.containsKey(origName)) {
            this.m_binNewAfterRename.remove(origName);
        }
    }

    public void refreshTree(TreeViewer tv, GroupTreeObject root, int expLevel) {
        this.m_importMPIView.refreshTree(tv, root, expLevel);
        this.updateTreeFooter(tv);
        this.m_importMPIView.updateImportButtonStatus();
    }

    public void createXMLTree_CM() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        Menu menu = menuMgr.createContextMenu(this.m_tv_bin.getControl());
        this.m_tv_bin.getControl().setMenu(menu);
        ImportMPIView.m_instance.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.m_tv_bin);
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                try {
                    StructuredSelection ssel = (StructuredSelection)ImportMPIBinarySection.this.m_tv_bin.getSelection();
                    if (!ssel.isEmpty()) {
                        String type = ((GroupTreeObject)ssel.getFirstElement()).getType();
                        manager.add((IAction)new AddToImportAction(ImportMPIBinarySection.this.m_tv_bin, ImportMPIBinarySection.this.m_binRoot, ImportMPIBinarySection.this.m_binSection));
                        manager.add((IContributionItem)new Separator());
                        manager.add((IAction)new ExpandCollapseAction(ImportMPIBinarySection.this.m_tv_bin, "ExpandAll"));
                        manager.add((IAction)new ExpandCollapseAction(ImportMPIBinarySection.this.m_tv_bin, "CollapseAll"));
                        if (!type.equals(BMUI.type_toplevel)) {
                            manager.add((IContributionItem)new Separator());
                            manager.add((IAction)new ExpandCollapseAction(ImportMPIBinarySection.this.m_tv_bin, "ExpandSubTree"));
                            manager.add((IAction)new ExpandCollapseAction(ImportMPIBinarySection.this.m_tv_bin, "CollagpseSubTree"));
                        }
                    } else {
                        manager.add((IAction)new ExpandCollapseAction(ImportMPIBinarySection.this.m_tv_bin, "ExpandAll"));
                        manager.add((IAction)new ExpandCollapseAction(ImportMPIBinarySection.this.m_tv_bin, "CollapseAll"));
                    }
                }
                catch (RuntimeException e) {
                    RTLogger.print(5, "ImportMPI: Error creating context menu of import tree", e);
                }
            }
        });
    }

    public void createFinalTree_CM() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        Menu menu = menuMgr.createContextMenu(this.m_tv_bin4Import.getControl());
        this.m_tv_bin4Import.getControl().setMenu(menu);
        ImportMPIView.m_instance.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.m_tv_bin4Import);
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                try {
                    StructuredSelection ssel = (StructuredSelection)ImportMPIBinarySection.this.m_tv_bin4Import.getSelection();
                    if (!ssel.isEmpty()) {
                        Object o = ssel.getFirstElement();
                        if (((GroupTreeObject)o).getType().equals(BMUI.type_toplevel)) {
                            manager.add((IAction)new RenameAction(ImportMPIBinarySection.this.m_tv_bin4Import, ImportMPIBinarySection.this.m_binSection, ImportMPIView.PREFIX));
                            manager.add((IAction)new RenameAction(ImportMPIBinarySection.this.m_tv_bin4Import, ImportMPIBinarySection.this.m_binSection, ImportMPIView.SUFFIX));
                            manager.add((IAction)new OverwriteAction(ImportMPIBinarySection.this.m_tv_bin4Import, ImportMPIBinarySection.this.m_binSection));
                            manager.add((IContributionItem)new Separator());
                            manager.add((IAction)new ResetElementsAction(ImportMPIBinarySection.this.m_tv_bin4Import, ImportMPIBinarySection.this.m_bin4ImportRoot, ImportMPIBinarySection.this.m_binSection, ImportMPIView.RESET_TREE));
                            manager.add((IContributionItem)new Separator());
                            manager.add((IAction)new RemoveFromImportAction(ImportMPIBinarySection.this.m_tv_bin4Import, ImportMPIBinarySection.this.m_bin4ImportRoot, ImportMPIBinarySection.this.m_binSection));
                        } else if (((GroupTreeObject)o).getType().equals(BMUI.type_assignment_bin)) {
                            manager.add((IAction)new RenameAction(ImportMPIBinarySection.this.m_tv_bin4Import, ImportMPIBinarySection.this.m_binSection, ImportMPIView.RENAME));
                            manager.add((IAction)new RenameAction(ImportMPIBinarySection.this.m_tv_bin4Import, ImportMPIBinarySection.this.m_binSection, ImportMPIView.PREFIX));
                            manager.add((IAction)new RenameAction(ImportMPIBinarySection.this.m_tv_bin4Import, ImportMPIBinarySection.this.m_binSection, ImportMPIView.SUFFIX));
                            manager.add((IAction)new OverwriteAction(ImportMPIBinarySection.this.m_tv_bin4Import, ImportMPIBinarySection.this.m_binSection));
                            manager.add((IContributionItem)new Separator());
                            manager.add((IAction)new ResetElementsAction(ImportMPIBinarySection.this.m_tv_bin4Import, ImportMPIBinarySection.this.m_bin4ImportRoot, ImportMPIBinarySection.this.m_binSection, ImportMPIView.RESET_TREE));
                            manager.add((IContributionItem)new Separator());
                            manager.add((IAction)new RemoveFromImportAction(ImportMPIBinarySection.this.m_tv_bin4Import, ImportMPIBinarySection.this.m_bin4ImportRoot, ImportMPIBinarySection.this.m_binSection));
                        } else {
                            manager.add((IAction)new ResetElementsAction(ImportMPIBinarySection.this.m_tv_bin4Import, ImportMPIBinarySection.this.m_bin4ImportRoot, ImportMPIBinarySection.this.m_binSection, ImportMPIView.RESET_TREE));
                        }
                    } else {
                        manager.add((IAction)new ResetElementsAction(ImportMPIBinarySection.this.m_tv_bin4Import, ImportMPIBinarySection.this.m_bin4ImportRoot, ImportMPIBinarySection.this.m_binSection, ImportMPIView.RESET_TREE));
                    }
                    manager.add((IContributionItem)new Separator());
                    manager.add((IAction)new ExpandCollapseAction(ImportMPIBinarySection.this.m_tv_bin4Import, "ExpandAll"));
                    manager.add((IAction)new ExpandCollapseAction(ImportMPIBinarySection.this.m_tv_bin4Import, "CollapseAll"));
                    manager.add((IContributionItem)new Separator());
                    manager.add((IAction)new ExpandCollapseAction(ImportMPIBinarySection.this.m_tv_bin4Import, "ExpandSubTree"));
                    manager.add((IAction)new ExpandCollapseAction(ImportMPIBinarySection.this.m_tv_bin4Import, "CollagpseSubTree"));
                }
                catch (RuntimeException e) {
                    RTLogger.print(5, "ImportMPI: Error creating context menu of import tree", e);
                }
            }
        });
    }

    public GroupTreeObject getBinRoot() {
        return this.m_binRoot;
    }

    public List<GroupTreeObject> getBinaries4Import() {
        List<GroupTreeObject> list = new ArrayList<GroupTreeObject>();
        try {
            list = this.m_bin4ImportRoot.getFirstChild("Packages").getElements();
        }
        catch (Exception exception) {}
        return list;
    }

    public Map<String, GroupTreeObject> getBinariesNew() {
        return this.m_binNew;
    }

    public Map<String, String> getBinaries2Rename() {
        return this.m_binNewAfterRename;
    }

    public Map<String, GroupTreeObject> getBinaries2Overwrite() {
        return this.m_bin2Overwrite;
    }

    public void expansionStateChanged(ExpansionEvent e) {
    }

    public void expansionStateChanging(ExpansionEvent e) {
    }

    public void selectionChanged(SelectionChangedEvent event) {
        Object obj = event.getSource();
        if (obj instanceof TreeViewer) {
            TreeViewer tv = (TreeViewer)obj;
            String type = (String)tv.getData(ImportMPIView.TREE_VIEWER_TYPE);
            if (type.equals(ImportMPIView.BIN)) {
                AddToImportAction action = new AddToImportAction(this.m_tv_bin, this.m_binRoot, this.m_binSection);
                this.m_gui.enableField(this.m_add_btn, action.isEnabled());
            } else if (type.equals(ImportMPIView.BIN_4IMPORT)) {
                RenameAction action1 = new RenameAction(this.m_tv_bin4Import, this.m_binSection, ImportMPIView.RENAME);
                this.m_rename_btn.setText(action1.getText());
                this.m_gui.enableField(this.m_rename_btn, action1.isEnabled());
                RenameAction action2 = new RenameAction(this.m_tv_bin4Import, this.m_binSection, ImportMPIView.PREFIX);
                this.m_addPrefix_btn.setText(action2.getText());
                this.m_gui.enableField(this.m_addPrefix_btn, action2.isEnabled());
                RenameAction action3 = new RenameAction(this.m_tv_bin4Import, this.m_binSection, ImportMPIView.SUFFIX);
                this.m_addSuffix_btn.setText(action3.getText());
                this.m_gui.enableField(this.m_addSuffix_btn, action3.isEnabled());
                OverwriteAction action4 = new OverwriteAction(this.m_tv_bin4Import, this.m_binSection);
                this.m_overwrite_btn.setText(action4.getText());
                this.m_gui.enableField(this.m_overwrite_btn, action4.isEnabled());
                ResetElementsAction action6 = new ResetElementsAction(this.m_tv_bin4Import, this.m_bin4ImportRoot, this.m_binSection, ImportMPIView.RESET_TREE);
                this.m_resetTree_btn.setText(action6.getText());
                this.m_gui.enableField(this.m_resetTree_btn, action6.isEnabled());
                RemoveFromImportAction action7 = new RemoveFromImportAction(this.m_tv_bin4Import, this.m_bin4ImportRoot, this.m_binSection);
                this.m_gui.enableField(this.m_removeFromImport_btn, action7.isEnabled());
                this.m_gui.enableField(this.m_remove_btn, action7.isEnabled());
                ContentCompare action8 = new ContentCompare(this.m_binSection);
                this.m_gui.enableField(this.m_contentCompare_btn, action8.isEnabled());
            }
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        Object obj = e.getSource();
        if (obj instanceof Button) {
            Button btn = (Button)obj;
            String name = (String)btn.getData();
            if (name.equals(ADD_BTN)) {
                AddToImportAction action = new AddToImportAction(this.m_tv_bin, this.m_binRoot, this.m_binSection);
                action.run();
            } else if (name.equals(RENAME_BTN)) {
                RenameAction action = new RenameAction(this.m_tv_bin4Import, this.m_binSection, ImportMPIView.RENAME);
                action.run();
            } else if (name.equals(ADD_PREFIX_BTN)) {
                RenameAction action = new RenameAction(this.m_tv_bin4Import, this.m_binSection, ImportMPIView.PREFIX);
                action.run();
            } else if (name.equals(ADD_SUFFIX_BTN)) {
                RenameAction action = new RenameAction(this.m_tv_bin4Import, this.m_binSection, ImportMPIView.SUFFIX);
                action.run();
            } else if (name.equals(OVERWRITE_BTN)) {
                OverwriteAction action = new OverwriteAction(this.m_tv_bin4Import, this.m_binSection);
                action.run();
            } else if (name.equals(RESET_TREE_BTN)) {
                ResetElementsAction action = new ResetElementsAction(this.m_tv_bin4Import, this.m_bin4ImportRoot, this.m_binSection, ImportMPIView.RESET_TREE);
                action.run();
            } else if (name.equals(REMOVE_FROM_IMPORT_BTN) || name.equals(REMOVE_BTN)) {
                RemoveFromImportAction action = new RemoveFromImportAction(this.m_tv_bin4Import, this.m_bin4ImportRoot, this.m_binSection);
                action.run();
            } else if (name.equals(CONTENT_COMPARE_BTN)) {
                ContentCompare action = new ContentCompare(this.m_binSection);
                action.run();
                this.m_contentCompare_btn.setEnabled(false);
            }
        }
    }

    public boolean isBinaryEqualByContent(String binGTOname) {
        return this.m_equalByContent.containsKey(binGTOname);
    }

    public void postProcess(ServerClient sc) {
        if (sc instanceof ScGetBinaryTreeMD5) {
            ScGetBinaryTreeMD5 scpmd5 = (ScGetBinaryTreeMD5)sc;
            if (scpmd5.isSuccess()) {
                GroupTreeObject serverTree = scpmd5.getResultObject();
                List<GroupTreeObject> gtols = this.m_bin4ImportRoot.findElementsByType(BMUI.type_assignment_bin);
                for (GroupTreeObject gto : gtols) {
                    GroupTreeObject gtolImport;
                    String md5Import = gto.getAttribute("MD5");
                    String md5Server = "-";
                    List<GroupTreeObject> policies = serverTree.findElements(gto.getName(), gto.getType());
                    if (policies.size() <= 0 || (md5Server = (gtolImport = policies.get(0)).getAttribute("MD5")) == null || !md5Server.equals(md5Import)) continue;
                    this.m_equalByContent.put(gto.getName(), md5Import);
                }
                UIJob uj = new UIJob(null){

                    @Override
                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        try {
                            ImportMPIBinarySection.this.refreshTree(ImportMPIBinarySection.this.m_tv_bin4Import, ImportMPIBinarySection.this.m_bin4ImportRoot, -1);
                        }
                        finally {
                            ImportMPIBinarySection.this.m_contentCompare_btn.setEnabled(true);
                        }
                        return Status.OK_STATUS;
                    }
                };
                Repository.getUIJobManager().schedule(uj);
            } else {
                String error = "";
                if (sc.getLastException() != null && (error = sc.getLastException().getMessage()) == null) {
                    error = sc.getResultObject() != null && sc.getResultObject() instanceof String ? "" + sc.getResultObject() : "";
                }
                new ShowMessageBox("Error", "Error gettting data from the server", 1);
            }
        }
    }

    public class AddToImportAction
    extends Action {
        private ImportMPIBinarySection m_section;
        private Map<GroupTreeObject, String> m_elements;

        public AddToImportAction(TreeViewer tv, GroupTreeObject root, ImportMPIBinarySection section) {
            super("addtoimportaction");
            this.m_section = null;
            this.m_elements = new HashMap<GroupTreeObject, String>();
            this.setId("addtoimportaction");
            this.setText("Add To Import");
            this.m_section = section;
            if (tv == null || this.m_section == null) {
                this.setEnabled(false);
                return;
            }
            StructuredSelection sel = (StructuredSelection)tv.getSelection();
            if (sel.size() > 0) {
                for (Object selected : sel) {
                    if (selected instanceof GroupTreeObjectLast || !(selected instanceof GroupTreeObject)) continue;
                    GroupTreeObject gto = (GroupTreeObject)selected;
                    if (gto.getType().equals(BMUI.type_toplevel)) {
                        this.m_elements.clear();
                        List<GroupTreeObject> list = gto.getElements();
                        for (GroupTreeObject binGTO : list) {
                            this.m_elements.put(binGTO, binGTO.getName());
                        }
                        break;
                    }
                    if (!gto.getType().equals(BMUI.type_assignment_bin)) continue;
                    this.m_elements.put(gto, gto.getName());
                }
            }
            if (this.m_elements.size() == 0) {
                this.setEnabled(false);
            }
        }

        public void run() {
            if (!this.isEnabled()) {
                return;
            }
            if (this.m_section == null || this.m_elements.size() == 0) {
                return;
            }
            this.m_section.addToImport(this.m_elements);
            ImportMPIBinarySection.this.m_importMPIView.getAsnSection().refreshTree(ImportMPIView.ASN_4IMPORT);
        }
    }

    public class ContentCompare
    extends Action {
        private ImportMPIBinarySection m_section;

        public ContentCompare(ImportMPIBinarySection section) {
            super("compareBcontentaction");
            this.m_section = null;
            this.setId("compareBcontentaction");
            this.setText("Compare Content");
            this.m_section = section;
            ScValidateCmd sc = new ScValidateCmd(Repository.getInstance(), "GET_BINARYTREE_MD5");
            sc.run();
            if (!sc.isSuccess()) {
                this.setEnabled(false);
                this.setToolTipText("Server does ot support this feature");
            }
        }

        public void run() {
            if (!this.isEnabled()) {
                return;
            }
            ScGetBinaryTreeMD5 sc = new ScGetBinaryTreeMD5(Repository.getInstance());
            sc.addCmdPostProcess(this.m_section);
            sc.setTimeout(300000);
            sc.start();
        }
    }

    class ContentProviderBinImportTree
    extends ViewContentProvider {
        @Override
        public Object[] getElements(Object obj) {
            Object[] oList = this.getChildren(obj);
            return oList;
        }
    }

    public class OverwriteAction
    extends Action {
        private ImportMPIBinarySection m_section;
        private Map<String, GroupTreeObject> m_elements;

        public OverwriteAction(TreeViewer tv, ImportMPIBinarySection section) {
            super("overwriteaction");
            this.m_section = null;
            this.m_elements = new HashMap<String, GroupTreeObject>();
            this.setId("overwriteaction");
            this.setText("Overwrite");
            this.m_section = section;
            if (tv == null || this.m_section == null) {
                this.setEnabled(false);
                return;
            }
            StructuredSelection sel = (StructuredSelection)tv.getSelection();
            if (!sel.isEmpty() && sel.size() > 0) {
                for (Object selected : sel) {
                    if (selected instanceof GroupTreeObjectLast || !(selected instanceof GroupTreeObject)) continue;
                    GroupTreeObject gto = (GroupTreeObject)selected;
                    if (gto.getType().equals(BMUI.type_toplevel)) {
                        this.m_elements.clear();
                        List<GroupTreeObject> list = gto.getElements();
                        for (GroupTreeObject binGTO : list) {
                            if (!this.m_section.hasInitialConflict(binGTO) || this.m_section.doOverwriteBinary(binGTO)) continue;
                            this.m_elements.put(binGTO.getName(), binGTO);
                        }
                        continue;
                    }
                    if (!gto.getType().equals(BMUI.type_assignment_bin) || !this.m_section.hasInitialConflict(gto) || this.m_section.doOverwriteBinary(gto)) continue;
                    this.m_elements.put(gto.getName(), gto);
                }
            }
            if (this.m_elements.size() == 0) {
                this.setEnabled(false);
            }
        }

        public void run() {
            if (!this.isEnabled()) {
                return;
            }
            if (this.m_section == null || this.m_elements.size() == 0) {
                return;
            }
            this.m_section.resetBinGroups(this.m_elements);
            this.m_section.overwriteBinaries(this.m_elements);
        }
    }

    public class RemoveFromImportAction
    extends Action {
        private ImportMPIBinarySection m_section;
        private Map<GroupTreeObject, String> m_elements;

        public RemoveFromImportAction(TreeViewer tv, GroupTreeObject root, ImportMPIBinarySection section) {
            super("skipimport");
            this.m_section = null;
            this.m_elements = new HashMap<GroupTreeObject, String>();
            this.setId("skipimport");
            this.setText("Remove");
            this.m_section = section;
            if (root == null || this.m_section == null) {
                this.setEnabled(false);
                return;
            }
            StructuredSelection sel = (StructuredSelection)tv.getSelection();
            if (sel.size() > 0) {
                for (Object selected : sel) {
                    if (selected instanceof GroupTreeObjectLast || !(selected instanceof GroupTreeObject)) continue;
                    GroupTreeObject gto = (GroupTreeObject)selected;
                    if (gto.getType().equals(BMUI.type_toplevel)) {
                        this.m_elements.clear();
                        List<GroupTreeObject> list = gto.getElements();
                        for (GroupTreeObject binGTO : list) {
                            this.m_elements.put(binGTO, binGTO.getName());
                        }
                        break;
                    }
                    if (!gto.getType().equals(BMUI.type_assignment_bin)) continue;
                    this.m_elements.put(gto, gto.getName());
                }
            }
            if (this.m_elements.size() == 0) {
                this.setEnabled(false);
            }
        }

        public void run() {
            if (!this.isEnabled()) {
                return;
            }
            if (this.m_section == null || this.m_elements.size() == 0) {
                return;
            }
            this.m_section.removeFromImport(this.m_elements);
            ImportMPIBinarySection.this.m_importMPIView.getAsnSection().refreshTree(ImportMPIView.ASN_4IMPORT);
        }
    }

    public class RenameAction
    extends Action {
        private TreeViewer m_tv;
        private ImportMPIBinarySection m_section;
        private String m_title;
        private String m_type;
        private Map<GroupTreeObject, String> m_elements;

        public RenameAction(TreeViewer tv, ImportMPIBinarySection section, String type) {
            super("renameaction");
            this.m_tv = null;
            this.m_section = null;
            this.m_title = null;
            this.m_type = null;
            this.m_elements = new HashMap<GroupTreeObject, String>();
            this.setId("renameaction");
            this.m_tv = tv;
            this.m_section = section;
            this.m_type = type;
            if (this.m_tv == null || this.m_section == null || type == null) {
                this.setEnabled(false);
            }
            if (this.m_type.equals(ImportMPIView.PREFIX)) {
                this.m_title = "Add Prefix";
            } else if (this.m_type.equals(ImportMPIView.SUFFIX)) {
                this.m_title = "Add Suffix";
            } else if (this.m_type.equals(ImportMPIView.RENAME)) {
                this.m_title = "Rename";
            } else {
                this.setText("Rename");
                this.setEnabled(false);
                return;
            }
            this.setText(this.m_title);
            StructuredSelection sel = (StructuredSelection)tv.getSelection();
            if (!sel.isEmpty()) {
                if (type.equals(ImportMPIView.RENAME)) {
                    Object obj;
                    if (sel.size() == 1 && (obj = sel.getFirstElement()) instanceof GroupTreeObject && ((GroupTreeObject)obj).getType().equals(BMUI.type_assignment_bin)) {
                        this.m_elements.put((GroupTreeObject)obj, null);
                    }
                } else {
                    for (Object obj : sel) {
                        if (!(obj instanceof GroupTreeObject)) continue;
                        if (((GroupTreeObject)obj).getType().equals(BMUI.type_toplevel)) {
                            GroupTreeObject toplevel = (GroupTreeObject)obj;
                            List<GroupTreeObject> list = toplevel.getElements();
                            int i = 0;
                            while (i < list.size()) {
                                this.m_elements.put(list.get(i), null);
                                ++i;
                            }
                            break;
                        }
                        if (!((GroupTreeObject)obj).getType().equals(BMUI.type_assignment_bin)) continue;
                        this.m_elements.put((GroupTreeObject)obj, null);
                    }
                }
            }
            if (this.m_elements.size() == 0) {
                this.setEnabled(false);
            }
        }

        public void run() {
            String value;
            if (!this.isEnabled()) {
                return;
            }
            if (this.m_tv == null || this.m_section == null || this.m_elements.size() == 0) {
                return;
            }
            String title = null;
            String msg = null;
            String initalValue = "";
            if (this.m_type.equals(ImportMPIView.PREFIX)) {
                title = "Add Prefix";
                msg = "Prefix: ";
            } else if (this.m_type.equals(ImportMPIView.SUFFIX)) {
                title = "Add Suffix";
                msg = "Suffix: ";
            } else if (this.m_type.equals(ImportMPIView.RENAME)) {
                GroupTreeObject gto = this.m_elements.keySet().iterator().next();
                initalValue = gto.getName();
                String type = gto.getType();
                if (type.equals(BMUI.type_assignment_bin)) {
                    title = "  Rename Binary ";
                    msg = "Please enter a new Binary Name: ";
                } else if (type.equals(BMUI.type_file)) {
                    title = "  Rename File";
                    msg = "Please enter a new File Name: ";
                } else if (type.equals(BMUI.type_folder) || type.equals("")) {
                    title = "  Rename Folder";
                    msg = "Please enter a new Folder Name: ";
                }
            }
            InputDialog id = new InputDialog(this.m_tv.getControl().getShell(), "  " + title, msg, initalValue, (IInputValidator)new NameValidatorFile());
            id.setBlockOnOpen(true);
            InputDialog.setDefaultImage((Image)BMUI.IMAGE_PRODUCT);
            int res = id.open();
            if (res == 0 && (value = id.getValue()) != null && value.length() != 0) {
                if (this.m_type.equals(ImportMPIView.RENAME)) {
                    GroupTreeObject gto2Rename = this.m_elements.keySet().iterator().next();
                    String parentPath = gto2Rename.getParentPath();
                    GroupTreeObject gtoFound = this.m_section.m_existingBinTree.searchPath(String.valueOf(parentPath) + "/" + value, gto2Rename.getType());
                    if (gtoFound == null) {
                        gtoFound = this.m_section.m_bin4ImportRoot.searchPath(String.valueOf(parentPath) + "/" + value, gto2Rename.getType());
                    }
                    if (gtoFound != null) {
                        new ShowMessageBox("  Rename ", "An element with this name does already exist!", 2);
                        this.run();
                    } else {
                        HashMap<GroupTreeObject, String> elem = new HashMap<GroupTreeObject, String>();
                        elem.put(gto2Rename, null);
                        this.m_section.renameElements(elem, value, ImportMPIView.RENAME);
                        ImportMPIBinarySection.this.m_importMPIView.getAsnSection().renameBinaries(ImportMPIBinarySection.this.m_binNewAfterRename, ImportMPIBinarySection.this.m_bin4ImportRoot);
                    }
                } else if (this.m_type.equals(ImportMPIView.PREFIX) || this.m_type.equals(ImportMPIView.SUFFIX)) {
                    HashMap<GroupTreeObject, String> elem = new HashMap<GroupTreeObject, String>();
                    StringBuffer sb = new StringBuffer();
                    for (GroupTreeObject gto2Rename : this.m_elements.keySet()) {
                        String parentPath = gto2Rename.getParentPath();
                        String newName = String.valueOf(value) + gto2Rename.getName();
                        if (this.m_type.equals(ImportMPIView.SUFFIX)) {
                            newName = String.valueOf(gto2Rename.getName()) + value;
                        }
                        String path = String.valueOf(parentPath) + "/" + newName;
                        GroupTreeObject gtoFound = this.m_section.m_existingBinTree.searchPath(path, gto2Rename.getType());
                        if (gtoFound == null) {
                            gtoFound = this.m_section.m_bin4ImportRoot.searchPath(String.valueOf(parentPath) + "/" + value, gto2Rename.getType());
                        }
                        if (gtoFound != null) {
                            sb.append(path).append("\n");
                            continue;
                        }
                        elem.put(gto2Rename, null);
                    }
                    if (sb.length() > 0) {
                        new ShowMessageBox("  Rename ", "The following elements do already exist:\n" + sb.toString(), 2);
                        this.run();
                    }
                    this.m_section.renameElements(elem, value, this.m_type);
                    ImportMPIBinarySection.this.m_importMPIView.getAsnSection().renameBinaries(ImportMPIBinarySection.this.m_binNewAfterRename, ImportMPIBinarySection.this.m_bin4ImportRoot);
                }
            }
        }
    }

    public class ResetElementsAction
    extends Action {
        private ImportMPIBinarySection m_section;
        private String m_type;
        private Map<String, GroupTreeObject> m_elements;

        public ResetElementsAction(TreeViewer tv, GroupTreeObject root, ImportMPIBinarySection section, String type) {
            super("clearelements");
            this.m_section = null;
            this.m_type = null;
            this.m_elements = new HashMap<String, GroupTreeObject>();
            this.setId("clearelements");
            this.m_section = section;
            this.m_type = type;
            this.setText("Reset");
            if (tv == null || root == null || section == null || type == null) {
                this.setEnabled(false);
                return;
            }
            StructuredSelection sel = (StructuredSelection)tv.getSelection();
            if (this.m_type.equals(ImportMPIView.RESET_TREE)) {
                this.setText("Reset Tree");
                return;
            }
            if (this.m_type.equals(RESET_BINARY)) {
                this.setText("Reset Binary");
                if (sel.size() > 0) {
                    for (Object selected : sel) {
                        GroupTreeObject gto;
                        if (selected instanceof GroupTreeObjectLast || !(selected instanceof GroupTreeObject) || !(gto = (GroupTreeObject)selected).getType().equals(BMUI.type_assignment_bin)) continue;
                        this.m_elements.put(gto.getPath(), gto);
                    }
                }
                if (this.m_elements.size() == 0) {
                    this.setEnabled(false);
                } else if (this.m_elements.size() > 1) {
                    this.setText("Reset Binaries");
                }
                return;
            }
            this.setText("Reset");
            this.setEnabled(false);
        }

        public void run() {
            if (!this.isEnabled()) {
                return;
            }
            if (this.m_type.equals(ImportMPIView.RESET_TREE)) {
                this.m_section.updateSection(ImportMPIBinarySection.this.m_importDir, true);
            } else if (this.m_type.equals(RESET_BINARY)) {
                this.m_section.resetBinGroups(this.m_elements);
            }
            ImportMPIBinarySection.this.m_importMPIView.getAsnSection().refreshTree(ImportMPIView.ASN_4IMPORT);
        }
    }

    class StyledLabelProviderBinImportTree
    extends StyledCellLabelProvider {
        ImportMPIBinarySection m_section = null;

        public StyledLabelProviderBinImportTree(ImportMPIBinarySection section) {
            this.m_section = section;
        }

        public void update(ViewerCell cell) {
            Object element = cell.getElement();
            Image defaultIcon = BMUI.IMAGE_FOLDER_DEFAULT;
            Image icon = null;
            cell.setBackground(null);
            if (element instanceof GroupTreeObjectLast) {
                GroupTreeObjectLast fileGtol = (GroupTreeObjectLast)element;
                String fileName = fileGtol.getName();
                cell.setText(fileName);
                String imageKey = "IMG_OBJ_FILE";
                icon = PlatformUI.getWorkbench().getSharedImages().getImage(imageKey);
                GroupTreeObject binGto = ImportMPIBinarySection.this.getParentBinary(fileGtol);
                if (binGto != null) {
                    if (this.m_section.doesElemBelongToNewBinary(binGto)) {
                        cell.setForeground(BMUI.color_green);
                    } else if (this.m_section.doesElemBelongToExistingBinary(binGto)) {
                        if (this.m_section.isBinaryEqualByContent(binGto.getName())) {
                            cell.setForeground(BMUI.color_darkGrey2);
                        } else if (this.m_section.doOverwriteBinary(binGto)) {
                            cell.setForeground(BMUI.color_selected);
                        } else {
                            cell.setForeground(BMUI.color_critical);
                        }
                    }
                }
            } else if (element instanceof GroupTreeObject) {
                GroupTreeObject gto = (GroupTreeObject)element;
                String name = gto.getName();
                cell.setText(name);
                String type = gto.getType();
                if (type != null) {
                    icon = BMUI.IMAGE_MAP.get(type);
                    if (!type.equals(BMUI.type_toplevel)) {
                        if (this.m_section.doesElemBelongToNewBinary(gto)) {
                            cell.setForeground(BMUI.color_green);
                        } else if (this.m_section.doesElemBelongToExistingBinary(gto)) {
                            if (this.m_section.isBinaryEqualByContent(gto.getName())) {
                                cell.setForeground(BMUI.color_darkGrey2);
                            } else if (this.m_section.doOverwriteBinary(gto)) {
                                cell.setForeground(BMUI.color_selected);
                            } else {
                                cell.setForeground(BMUI.color_critical);
                            }
                        }
                    }
                }
            }
            if (icon == null) {
                icon = defaultIcon;
            }
            cell.setImage(icon);
            super.update(cell);
        }

        public String getToolTipText(Object element) {
            GroupTreeObject gto;
            StringBuffer sbTT = new StringBuffer();
            sbTT.append("<html>").append("<head><style type=\"text/css\">").append("body { margin-left:5px; margin-right:5px; margin-top:5px; margin-bottom:5px }").append("</style></head>").append("<body bgcolor='#FFFFE1'>");
            sbTT.append("<p><font face='Arial' size='1' color='#000000'>");
            if (element instanceof GroupTreeObject && BMUI.type_assignment_bin.equals((gto = (GroupTreeObject)element).getType())) {
                if (ImportMPIBinarySection.this.isBinaryEqualByContent(gto.getName())) {
                    sbTT.append("The content of the binaries are equal with server.<br>This binary will be skipped during import!");
                } else if (ImportMPIBinarySection.this.doOverwriteBinary(gto)) {
                    sbTT.append("The incoming binary package will overwrite data on the server.");
                } else {
                    sbTT.append("Please resolve conflict.");
                }
            }
            sbTT.append("</font></p>");
            sbTT.append("</body></html>");
            return sbTT.toString();
        }
    }

    class StyledLabelProviderBinTree
    extends StyledCellLabelProvider {
        ImportMPIBinarySection m_section = null;

        public StyledLabelProviderBinTree(ImportMPIBinarySection section) {
            this.m_section = section;
        }

        public void update(ViewerCell cell) {
            Object element = cell.getElement();
            Image defaultIcon = BMUI.IMAGE_FOLDER_DEFAULT;
            Image icon = null;
            if (element instanceof GroupTreeObjectLast) {
                GroupTreeObjectLast gtol = (GroupTreeObjectLast)element;
                cell.setText(gtol.getName());
                String imageKey = "IMG_OBJ_FILE";
                icon = PlatformUI.getWorkbench().getSharedImages().getImage(imageKey);
            } else if (element instanceof GroupTreeObject) {
                GroupTreeObject gto = (GroupTreeObject)element;
                cell.setText(gto.getName());
                String type = gto.getType();
                if (type != null) {
                    icon = BMUI.IMAGE_MAP.get(type);
                }
            }
            if (icon == null) {
                icon = defaultIcon;
            }
            cell.setImage(icon);
            super.update(cell);
        }
    }
}

