/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.gui.policies.ViewContentProvider;
import com.blixx.boom.gui.utils.GUIDisplayElements;
import com.blixx.boom.gui.utils.STreeViewer;
import com.blixx.boom.gui.utils.XMLTree;
import com.blixx.boom.gui.views.ImportMPIView;
import com.blixx.boom.gui.views.actions.ExpandCollapseAction;
import com.blixx.log.RTLogger;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.GroupTreeObjectLast;
import com.blixx.shared.utils.TreeObject;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class ImportMPINodeGroupsSection
extends Section
implements IExpansionListener,
SelectionListener,
ISelectionChangedListener {
    private ImportMPINodeGroupsSection m_nodSection = null;
    private ImportMPIView m_importMPIView = null;
    private String m_importType = ImportMPIView.IMPORT_MPI;
    private GroupTreeObject m_existingNodeGrpTree = null;
    private GroupTreeObject m_nodRoot = null;
    private GroupTreeObject m_nod4ImportRoot = null;
    private TreeViewer m_tv_nod = null;
    private TreeViewer m_tv_nod4Import = null;
    private ContentProviderNodImportTree m_treeContentProvider_final = null;
    private Text m_nodFooter = null;
    private Text m_nod4ImportFooter = null;
    private int m_totalImportConflicts = 0;
    private GUIDisplayElements m_gui = null;
    private FormToolkit m_toolkit = null;
    private Composite m_sectionClient = null;
    public HashMap<String, GroupTreeObject> m_allIncomingNodGrp = new HashMap();
    public Map<String, GroupTreeObject> m_nodGrpNew = new HashMap<String, GroupTreeObject>();
    public Map<String, GroupTreeObject> m_nodGrpExist = new HashMap<String, GroupTreeObject>();
    public Map<String, GroupTreeObject> m_nodGrpSkipImport = new HashMap<String, GroupTreeObject>();
    public Map<String, GroupTreeObject> m_nodGrp2Merge = new HashMap<String, GroupTreeObject>();
    private static String ADD_BTN = "ADD_BTN";
    private static String REMOVE_BTN = "REMOVE_BTN";
    public static String RESET_NODE_GRP = "RESET_NODE_GRP";
    private static String REMOVE_FROM_IMPORT_BTN = "REMOVE_FROM_IMPORT_BTN";
    private static String RESET_TREE_BTN = "RESET_TREE_BTN";
    private Button m_add_btn = null;
    private Button m_remove_btn = null;
    private Button m_removeFromImport_btn = null;
    private Button m_resetTree_btn = null;
    private String m_lastNodeGroupFilePath = null;
    Listener paintListenerNodTree = new Listener(){

        public void handleEvent(Event event) {
            GroupTreeObjectLast gtol;
            Image icon;
            TreeItem ti;
            Object o;
            Widget obj = event.item;
            if (obj instanceof TreeItem && (o = (ti = (TreeItem)event.item).getData()) instanceof GroupTreeObjectLast && (icon = ImportMPINodeGroupsSection.this.getIcon(gtol = (GroupTreeObjectLast)o, ImportMPIView.NOD)) != null) {
                switch (event.type) {
                    case 41: {
                        Rectangle rect = icon.getBounds();
                        event.width += rect.width;
                        event.height = Math.max(event.height, rect.height + 2);
                        break;
                    }
                    case 42: {
                        int x = event.x + event.width;
                        Rectangle rect = icon.getBounds();
                        int offset = Math.max(0, (event.height - rect.height) / 2);
                        event.gc.drawImage(icon, x, event.y + offset);
                    }
                }
            }
        }
    };
    Listener paintListenerNodImportTree = new Listener(){

        public void handleEvent(Event event) {
            GroupTreeObject gto;
            Image icon;
            TreeItem ti;
            Object o;
            Widget obj = event.item;
            if (obj instanceof TreeItem && !((o = (ti = (TreeItem)event.item).getData()) instanceof GroupTreeObjectLast) && o instanceof GroupTreeObject && (icon = ImportMPINodeGroupsSection.this.getIcon(gto = (GroupTreeObject)o, ImportMPIView.NOD_4IMPORT)) != null) {
                switch (event.type) {
                    case 41: {
                        Rectangle rect = icon.getBounds();
                        event.width += rect.width;
                        event.height = Math.max(event.height, rect.height + 2);
                        break;
                    }
                    case 42: {
                        int x = event.x + event.width;
                        Rectangle rect = icon.getBounds();
                        int offset = Math.max(0, (event.height - rect.height) / 2);
                        event.gc.drawImage(icon, x, event.y + offset);
                    }
                }
            }
        }
    };

    public ImportMPINodeGroupsSection(Composite parent, ImportMPIView importMPIView) {
        super(parent, 578);
        this.setText("Node Groups");
        this.setLayoutData(new GridData(4, 128, true, false));
        this.m_nodSection = this;
        this.m_importMPIView = importMPIView;
    }

    public void initSection() {
        this.m_gui = new GUIDisplayElements();
        this.m_toolkit = BMUI.getFormToolkit(Display.getCurrent());
        this.m_sectionClient = this.m_toolkit.createComposite((Composite)this.m_nodSection, 0);
        this.m_sectionClient.setLayout((Layout)new GridLayout(2, false));
        this.m_sectionClient.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite treeComp = new Composite(this.m_sectionClient, 0);
        GridLayout gl = new GridLayout(3, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        treeComp.setLayout((Layout)gl);
        treeComp.setLayoutData((Object)new GridData(4, 4, true, true));
        Group importTree_grp = new Group(treeComp, 32);
        importTree_grp.setText("nodeGroups.xml");
        importTree_grp.setLayout((Layout)new GridLayout(1, false));
        importTree_grp.setLayoutData((Object)new GridData(4, 4, true, true));
        this.m_tv_nod = new STreeViewer((Composite)importTree_grp, 268438274);
        this.m_tv_nod.setData(ImportMPIView.TREE_VIEWER_TYPE, (Object)ImportMPIView.NOD);
        this.m_tv_nod.getTree().setLayoutData((Object)ImportMPIView.m_sectionTree_gd);
        this.m_tv_nod.setUseHashlookup(true);
        this.m_tv_nod.setContentProvider((IContentProvider)new ViewContentProvider());
        this.m_tv_nod.setLabelProvider((IBaseLabelProvider)new StyledLabelProviderNodTree(this));
        this.m_tv_nod.setInput((Object)this.m_nodRoot);
        this.m_tv_nod.addSelectionChangedListener((ISelectionChangedListener)this);
        this.m_tv_nod.getTree().addListener(41, this.paintListenerNodTree);
        this.m_tv_nod.getTree().addListener(42, this.paintListenerNodTree);
        this.createXMLTree_CM();
        this.m_nodFooter = this.m_gui.addTextReadOnlyNoBorder((Composite)importTree_grp, null, "", 1, 1, 1, 1, BMUI.font_arial8);
        this.updateTreeFooter(this.m_tv_nod);
        Composite btn1Comp = new Composite(treeComp, 0);
        gl = new GridLayout(1, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        btn1Comp.setLayout((Layout)gl);
        btn1Comp.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        this.m_add_btn = this.m_gui.addButton(btn1Comp, ADD_BTN, " >> ", false, this);
        this.m_remove_btn = this.m_gui.addButton(btn1Comp, REMOVE_BTN, " << ", false, this);
        Group finalTree_grp = new Group(treeComp, 32);
        finalTree_grp.setText("Preview");
        finalTree_grp.setLayout((Layout)new GridLayout(1, false));
        GridData gd = new GridData(4, 4, true, true);
        gd.horizontalIndent = 10;
        finalTree_grp.setLayoutData((Object)gd);
        this.m_tv_nod4Import = new STreeViewer((Composite)finalTree_grp, 268438274);
        this.m_tv_nod4Import.setData(ImportMPIView.TREE_VIEWER_TYPE, (Object)ImportMPIView.NOD_4IMPORT);
        this.m_tv_nod4Import.getTree().setLayoutData((Object)ImportMPIView.m_sectionTree_gd);
        this.m_tv_nod4Import.setUseHashlookup(true);
        this.m_treeContentProvider_final = new ContentProviderNodImportTree();
        this.m_tv_nod4Import.setContentProvider((IContentProvider)this.m_treeContentProvider_final);
        this.m_tv_nod4Import.setLabelProvider((IBaseLabelProvider)new StyledLabelProviderNodImportTree(this));
        this.m_tv_nod4Import.setInput((Object)this.m_nod4ImportRoot);
        this.m_tv_nod4Import.addSelectionChangedListener((ISelectionChangedListener)this);
        this.m_tv_nod4Import.getTree().addListener(41, this.paintListenerNodImportTree);
        this.m_tv_nod4Import.getTree().addListener(42, this.paintListenerNodImportTree);
        this.createFinalTree_CM();
        this.m_nod4ImportFooter = this.m_gui.addTextReadOnlyNoBorder((Composite)finalTree_grp, null, "", 1, 1, 1, 1, BMUI.font_arial8);
        this.updateTreeFooter(this.m_tv_nod4Import);
        Composite btnComp = new Composite(this.m_sectionClient, 0);
        btnComp.setLayout((Layout)new GridLayout(1, false));
        btnComp.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.m_resetTree_btn = this.m_gui.addButton(btnComp, RESET_TREE_BTN, "Reset Tree", false, this);
        this.m_resetTree_btn.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.m_removeFromImport_btn = this.m_gui.addButton(btnComp, REMOVE_FROM_IMPORT_BTN, "Remove", false, this);
        this.m_removeFromImport_btn.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.setClient((Control)this.m_sectionClient);
        this.addExpansionListener(this);
    }

    public void updateSection(String nodeGroupsFilePath, boolean keepExpElems, String importType) {
        if (!this.isEnabled()) {
            return;
        }
        this.m_lastNodeGroupFilePath = nodeGroupsFilePath;
        if (nodeGroupsFilePath == null) {
            return;
        }
        this.m_importType = importType;
        this.m_allIncomingNodGrp.clear();
        this.m_nodGrpExist.clear();
        this.m_nodGrpNew.clear();
        this.m_nodGrp2Merge.clear();
        this.m_nodGrpSkipImport.clear();
        this.loadNodeGroups(nodeGroupsFilePath);
        if (this.m_nodRoot != null) {
            try {
                this.m_nod4ImportRoot = this.m_nodRoot.clone();
                ImportMPIView.IMPORT_OTHER.equals(this.m_importType);
                this.checkConflicts();
            }
            catch (CloneNotSupportedException e) {
                this.m_nod4ImportRoot = null;
                RTLogger.print(5, "ImportMPI: Error cloning import tree", e);
            }
        }
        int expLevel = 2;
        if (keepExpElems) {
            expLevel = -1;
        }
        this.refreshTree(this.m_tv_nod, this.m_nodRoot, expLevel);
        this.refreshTree(this.m_tv_nod4Import, this.m_nod4ImportRoot, expLevel);
        if (this.m_nodRoot == null || this.m_nodRoot.getElements().size() == 0) {
            this.setExpanded(false);
        } else {
            this.setExpanded(true);
        }
    }

    private void loadNodeGroups(String nodeGroupsFilePath) {
        this.m_nodRoot = null;
        this.m_nod4ImportRoot = null;
        try {
            XMLTree xt = new XMLTree();
            FileInputStream fis = new FileInputStream(nodeGroupsFilePath);
            this.m_nodRoot = xt.parseXML(fis, true);
            fis.close();
        }
        catch (Throwable throwable) {}
    }

    private void checkConflicts() {
        this.m_existingNodeGrpTree = Repository.getInstance().getAgentTree();
        GroupTreeObject nodeRoot = this.m_nodRoot.findFirstGroupByName("_Groups");
        if (nodeRoot != null) {
            List<GroupTreeObject> nodeGroups = nodeRoot.getElements();
            int i = 0;
            while (i < nodeGroups.size()) {
                GroupTreeObject inGto = nodeGroups.get(i);
                this.m_allIncomingNodGrp.put(inGto.getName(), inGto);
                String inNGName = inGto.getName();
                GroupTreeObject nodGrpExist = this.m_existingNodeGrpTree.searchPath(inGto.getPath(), inGto.getType());
                if (nodGrpExist == null) {
                    this.m_nodGrpNew.put(inNGName, inGto);
                } else {
                    this.m_nodGrpExist.put(inGto.getName(), inGto);
                    this.m_nodGrp2Merge.put(inGto.getName(), inGto);
                }
                ++i;
            }
        }
    }

    public void clearSection() {
        this.m_nodRoot = null;
        this.m_nod4ImportRoot = null;
        this.refreshTree(this.m_tv_nod, this.m_nodRoot, 0);
        this.refreshTree(this.m_tv_nod4Import, this.m_nod4ImportRoot, 0);
    }

    public void updateTreeFooter(TreeViewer tv) {
        int totalNodeGrps = 0;
        StringBuffer sb = new StringBuffer();
        String type = (String)tv.getData(ImportMPIView.TREE_VIEWER_TYPE);
        if (type.equalsIgnoreCase(ImportMPIView.NOD)) {
            GroupTreeObject toplevelGTO;
            if (this.m_nodRoot != null && (toplevelGTO = this.m_nodRoot.getChild("_Groups", BMUI.type_folder)) != null) {
                List<GroupTreeObject> nodeGrps = toplevelGTO.getElements();
                totalNodeGrps = nodeGrps.size();
            }
            sb.append("Groups (").append(totalNodeGrps).append(")");
            this.m_nodFooter.setText(sb.toString());
            this.m_nodFooter.pack(true);
        } else if (type.equalsIgnoreCase(ImportMPIView.NOD_4IMPORT)) {
            GroupTreeObject toplevelGTO;
            this.m_totalImportConflicts = 0;
            if (this.m_nod4ImportRoot != null && (toplevelGTO = this.m_nod4ImportRoot.getChild("_Groups", BMUI.type_folder)) != null) {
                List<GroupTreeObject> list = toplevelGTO.getElements();
                totalNodeGrps = list.size();
            }
            sb.append("Groups (").append(totalNodeGrps).append(")").append("  Conflicts (").append(this.m_totalImportConflicts).append(")");
            this.m_nod4ImportFooter.setText(sb.toString());
            this.m_nod4ImportFooter.pack(true);
        }
    }

    public GroupTreeObject getOriginalElement(GroupTreeObject gto) {
        if (gto == null) {
            return null;
        }
        GroupTreeObject origGTO = this.m_nodRoot.searchPath(gto.getPath(), gto.getType());
        return origGTO;
    }

    public GroupTreeObject cloneElement(GroupTreeObject gto) {
        if (gto == null) {
            return null;
        }
        GroupTreeObject clone = null;
        try {
            clone = gto.clone();
            clone.getTreeObject().setObject(gto.getPath());
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        return clone;
    }

    private GroupTreeObject getParentNodeGrp(GroupTreeObject gto) {
        GroupTreeObject gto2;
        block6: {
            if (gto == null) {
                return null;
            }
            gto2 = null;
            if (this.isNodeGroup(gto)) {
                return gto;
            }
            try {
                gto2 = gto;
                GroupTreeObject parent = gto2.getParent();
                if (parent == null) break block6;
                while (!gto2.getParent().getName().equals("_Groups")) {
                    parent = gto2.getParent();
                    if (parent != null) {
                        gto2 = parent;
                        continue;
                    }
                    break;
                }
            }
            catch (Exception exception) {
                gto2 = null;
            }
        }
        return gto2;
    }

    public boolean hasInitialConflict(GroupTreeObject nodeGrpGTO) {
        boolean hasConflict = false;
        if (this.doesElemBelongToExistingNodeGrp(nodeGrpGTO)) {
            hasConflict = true;
        }
        return hasConflict;
    }

    public boolean hasConflict(GroupTreeObject nodeGrpGTO) {
        boolean hasConflict = false;
        return hasConflict;
    }

    public boolean doesElemBelongToExistingNodGrp(GroupTreeObject gto) {
        if (gto == null) {
            return false;
        }
        boolean isNew = false;
        GroupTreeObject nodGrpGto = null;
        nodGrpGto = this.getParentNodeGrp(gto);
        if (nodGrpGto != null) {
            String nodGrpPath = nodGrpGto.getPath();
            GroupTreeObject gtoOrig = this.getOriginalElement(nodGrpGto);
            if (gtoOrig != null) {
                if (!nodGrpPath.equals(gtoOrig.getPath())) {
                    isNew = true;
                } else if (this.m_nodGrpExist.containsKey(gtoOrig.getName())) {
                    isNew = true;
                }
            }
        }
        return isNew;
    }

    private boolean isNodeGroup(GroupTreeObject gto) {
        boolean isNG = false;
        if (gto != null && gto.getParent() != null && gto.getParent().getName().equals("_Groups")) {
            isNG = true;
        }
        return isNG;
    }

    public boolean doesElemBelongToNewNodeGrp(GroupTreeObject gto) {
        if (gto == null) {
            return false;
        }
        boolean isNew = false;
        GroupTreeObject nodGrpGto = null;
        nodGrpGto = this.getParentNodeGrp(gto);
        if (nodGrpGto != null) {
            String nodGrpPath = nodGrpGto.getPath();
            GroupTreeObject gtoOrig = this.getOriginalElement(nodGrpGto);
            if (gtoOrig != null) {
                if (!nodGrpPath.equals(gtoOrig.getPath())) {
                    isNew = true;
                } else if (this.m_nodGrpNew.containsKey(gtoOrig.getName())) {
                    isNew = true;
                }
            }
        }
        return isNew;
    }

    public boolean doesElemBelongToExistingNodeGrp(GroupTreeObject gto) {
        if (gto == null) {
            return false;
        }
        boolean belongToExist = false;
        GroupTreeObject nodGrpGto = gto;
        GroupTreeObject origGto = this.getOriginalElement(nodGrpGto);
        if (origGto != null) {
            belongToExist = this.m_nodGrpExist.containsKey(origGto.getName());
        }
        return belongToExist;
    }

    public boolean doMergeNodeGroup(GroupTreeObject gto) {
        GroupTreeObject origNodGrpGto;
        if (gto == null) {
            return false;
        }
        boolean merge = false;
        GroupTreeObject nodGrpGto = this.getParentNodeGrp(gto);
        if (nodGrpGto != null && (origNodGrpGto = this.getOriginalElement(nodGrpGto)) != null) {
            merge = this.m_nodGrp2Merge.containsKey(origNodGrpGto.getName());
        }
        return merge;
    }

    public Image getIcon(GroupTreeObject gto, String treeType) {
        if (gto == null || treeType == null) {
            return null;
        }
        if (!treeType.equals(ImportMPIView.NOD) && treeType.equals(ImportMPIView.NOD_4IMPORT) && !this.doesElemBelongToNewNodeGrp(gto) && !BMUI.type_toplevel.equals(gto.getType())) {
            return BMUI.IMAGE_MERGE;
        }
        return null;
    }

    public void mergeNodeGroups(Map<GroupTreeObject, String> elements) {
        for (GroupTreeObject gto : elements.keySet()) {
            GroupTreeObject origGto;
            if (gto instanceof GroupTreeObjectLast || (origGto = this.getOriginalElement(gto)) == null) continue;
            this.removeFromHashMaps(origGto, true);
            this.m_nodGrp2Merge.put(origGto.getName(), origGto);
        }
        this.refreshTree(this.m_tv_nod4Import, this.m_nod4ImportRoot, -1);
    }

    public void removeFromImport(Map<GroupTreeObject, String> elements) {
        for (GroupTreeObject gto : elements.keySet()) {
            GroupTreeObject gtoExist = this.m_nod4ImportRoot.searchPath(gto.getPath(), gto.getType());
            if (gtoExist == null) continue;
            gtoExist.getParent().removeElement(gtoExist);
            this.removeFromHashMaps(gto, false);
            GroupTreeObject origGTO = this.getOriginalElement(gto);
            if (origGTO == null) continue;
            this.m_nodGrpSkipImport.put(origGTO.getName(), origGTO);
        }
        this.refreshTree(this.m_tv_nod4Import, this.m_nod4ImportRoot, -1);
    }

    public void resetNodeGroups(Map<String, GroupTreeObject> elements) {
        for (GroupTreeObject gto : elements.values()) {
            GroupTreeObject origGTO = this.getOriginalElement(gto);
            if (origGTO == null) continue;
            this.removeFromHashMaps(gto, false);
            GroupTreeObject parent = gto.getParent();
            parent.removeElement(gto);
            GroupTreeObject clone = this.cloneElement(origGTO);
            parent.addElement(clone);
        }
        this.refreshTree(this.m_tv_nod4Import, this.m_nod4ImportRoot, -1);
    }

    public void addToImport(Map<GroupTreeObject, String> elements) {
        for (GroupTreeObject origGTO : elements.keySet()) {
            if (origGTO instanceof GroupTreeObjectLast) continue;
            this.removeFromHashMaps(origGTO, true);
            this.removeFromHashMaps(origGTO.getAllElements(), true);
            if (!this.m_nod4ImportRoot.hasElements().booleanValue()) {
                this.m_nod4ImportRoot.addElement(new GroupTreeObject(new TreeObject("_Groups", BMUI.type_toplevel, null)));
            }
            this.m_importMPIView.addElement2Tree(this.m_nod4ImportRoot, origGTO, origGTO.getParentPath());
        }
        for (GroupTreeObject origGTO : elements.keySet()) {
            if (!(origGTO instanceof GroupTreeObjectLast)) continue;
            this.removeFromHashMaps(origGTO, true);
            if (!this.m_nod4ImportRoot.hasElements().booleanValue()) {
                this.m_nod4ImportRoot.addElement(new GroupTreeObject(new TreeObject("_Groups", BMUI.type_toplevel, null)));
            }
            this.m_importMPIView.addElement2Tree(this.m_nod4ImportRoot, origGTO, origGTO.getParentPath());
        }
        this.refreshTree(this.m_tv_nod4Import, this.m_nod4ImportRoot, 2);
    }

    public void removeFromHashMaps(List<GroupTreeObject> origGTOList, boolean origElems) {
        for (GroupTreeObject gto : origGTOList) {
            this.removeFromHashMaps(gto, origElems);
        }
    }

    public void removeFromHashMaps(GroupTreeObject gto, boolean origElems) {
        if (gto == null) {
            return;
        }
        String currName = gto.getName();
        String origName = null;
        GroupTreeObject origGTO = null;
        if (origElems) {
            origGTO = gto;
            origName = currName;
        } else {
            origGTO = this.getOriginalElement(gto);
            if (origGTO != null) {
                origName = origGTO.getName();
            }
        }
        if (this.m_nodGrpSkipImport.containsKey(origName)) {
            this.m_nodGrpSkipImport.remove(origName);
        }
        if (this.m_nodGrp2Merge.containsKey(origName)) {
            this.m_nodGrp2Merge.remove(origName);
        }
    }

    public GroupTreeObject moveElement(GroupTreeObject root, String name, String type, String newParentPath) {
        GroupTreeObject movedGTO = null;
        GroupTreeObjectLast gtolExist = root.findElement(name, type);
        if (gtolExist == null) {
            return null;
        }
        if (gtolExist.getParentPath() != null && gtolExist.getParentPath().equals(newParentPath)) {
            return gtolExist;
        }
        movedGTO = this.m_importMPIView.addElement2Tree(root, gtolExist, newParentPath);
        this.m_importMPIView.removeElementFromTree(gtolExist);
        return movedGTO;
    }

    public void refreshTree(TreeViewer tv, GroupTreeObject root, int expLevel) {
        this.m_importMPIView.refreshTree(tv, root, expLevel);
        this.updateTreeFooter(tv);
        this.m_importMPIView.updateImportButtonStatus();
    }

    public int getTotalImportConflicts() {
        return this.m_totalImportConflicts;
    }

    public void createXMLTree_CM() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        Menu menu = menuMgr.createContextMenu(this.m_tv_nod.getControl());
        this.m_tv_nod.getControl().setMenu(menu);
        ImportMPIView.m_instance.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.m_tv_nod);
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                try {
                    StructuredSelection ssel = (StructuredSelection)ImportMPINodeGroupsSection.this.m_tv_nod.getSelection();
                    if (!ssel.isEmpty()) {
                        GroupTreeObject firstGTO = (GroupTreeObject)ssel.getFirstElement();
                        manager.add((IAction)new AddToImportAction(ImportMPINodeGroupsSection.this.m_tv_nod, ImportMPINodeGroupsSection.this.m_nodRoot, ImportMPINodeGroupsSection.this.m_nodSection));
                        manager.add((IContributionItem)new Separator());
                        manager.add((IAction)new ExpandCollapseAction(ImportMPINodeGroupsSection.this.m_tv_nod, "ExpandAll"));
                        manager.add((IAction)new ExpandCollapseAction(ImportMPINodeGroupsSection.this.m_tv_nod, "CollapseAll"));
                        if (!firstGTO.getName().equals("_Groups")) {
                            manager.add((IContributionItem)new Separator());
                            manager.add((IAction)new ExpandCollapseAction(ImportMPINodeGroupsSection.this.m_tv_nod, "ExpandSubTree"));
                            manager.add((IAction)new ExpandCollapseAction(ImportMPINodeGroupsSection.this.m_tv_nod, "CollagpseSubTree"));
                        }
                    } else {
                        manager.add((IAction)new ExpandCollapseAction(ImportMPINodeGroupsSection.this.m_tv_nod, "ExpandAll"));
                        manager.add((IAction)new ExpandCollapseAction(ImportMPINodeGroupsSection.this.m_tv_nod, "CollapseAll"));
                    }
                }
                catch (RuntimeException e) {
                    RTLogger.print(5, "ImportMPI: Error creating context menu of import tree", e);
                }
            }
        });
    }

    public void createFinalTree_CM() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        Menu menu = menuMgr.createContextMenu(this.m_tv_nod4Import.getControl());
        this.m_tv_nod4Import.getControl().setMenu(menu);
        ImportMPIView.m_instance.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.m_tv_nod4Import);
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                try {
                    StructuredSelection ssel = (StructuredSelection)ImportMPINodeGroupsSection.this.m_tv_nod4Import.getSelection();
                    if (!ssel.isEmpty()) {
                        GroupTreeObject firstGTO = (GroupTreeObject)ssel.getFirstElement();
                        if (!(firstGTO instanceof GroupTreeObjectLast)) {
                            manager.add((IAction)new MergeAction(ImportMPINodeGroupsSection.this.m_tv_nod4Import, ImportMPINodeGroupsSection.this.m_nodSection));
                            manager.add((IContributionItem)new Separator());
                        }
                        manager.add((IAction)new ResetElementsAction(ImportMPINodeGroupsSection.this.m_tv_nod4Import, ImportMPINodeGroupsSection.this.m_nodSection, ImportMPIView.RESET_TREE));
                        manager.add((IContributionItem)new Separator());
                        manager.add((IAction)new ExpandCollapseAction(ImportMPINodeGroupsSection.this.m_tv_nod4Import, "ExpandAll"));
                        manager.add((IAction)new ExpandCollapseAction(ImportMPINodeGroupsSection.this.m_tv_nod4Import, "CollapseAll"));
                        if (!firstGTO.getName().equals("_Groups") && !(firstGTO instanceof GroupTreeObjectLast)) {
                            manager.add((IContributionItem)new Separator());
                            manager.add((IAction)new ExpandCollapseAction(ImportMPINodeGroupsSection.this.m_tv_nod4Import, "ExpandSubTree"));
                            manager.add((IAction)new ExpandCollapseAction(ImportMPINodeGroupsSection.this.m_tv_nod4Import, "CollagpseSubTree"));
                        }
                    } else {
                        manager.add((IAction)new ExpandCollapseAction(ImportMPINodeGroupsSection.this.m_tv_nod4Import, "ExpandAll"));
                        manager.add((IAction)new ExpandCollapseAction(ImportMPINodeGroupsSection.this.m_tv_nod4Import, "CollapseAll"));
                    }
                }
                catch (RuntimeException e) {
                    RTLogger.print(5, "ImportMPI: Error creating context menu of import tree", e);
                }
            }
        });
    }

    public List<GroupTreeObject> getNodeGrps4Import() {
        List<GroupTreeObject> nodeGrps = new ArrayList<GroupTreeObject>();
        try {
            nodeGrps = this.m_nod4ImportRoot.getChild("_Groups", BMUI.type_folder).clone().getElements();
        }
        catch (Exception exception) {}
        return nodeGrps;
    }

    public Map<String, GroupTreeObject> getNodeGrps2Merge() {
        return this.m_nodGrp2Merge;
    }

    public void expansionStateChanged(ExpansionEvent e) {
    }

    public void expansionStateChanging(ExpansionEvent e) {
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        Object obj = e.getSource();
        if (obj instanceof Button) {
            Button btn = (Button)obj;
            String name = (String)btn.getData();
            if (name.equals(ADD_BTN)) {
                AddToImportAction action = new AddToImportAction(this.m_tv_nod, this.m_nodRoot, this.m_nodSection);
                action.run();
            } else if (name.equals(RESET_TREE_BTN)) {
                ResetElementsAction action = new ResetElementsAction(this.m_tv_nod4Import, this.m_nodSection, ImportMPIView.RESET_TREE);
                action.run();
            } else if (name.equals(REMOVE_FROM_IMPORT_BTN) || name.equals(REMOVE_BTN)) {
                RemoveFromImportAction action = new RemoveFromImportAction(this.m_tv_nod4Import, this.m_nod4ImportRoot, this.m_nodSection);
                action.run();
            }
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        Object obj = event.getSource();
        if (obj instanceof TreeViewer) {
            TreeViewer tv = (TreeViewer)obj;
            String type = (String)tv.getData(ImportMPIView.TREE_VIEWER_TYPE);
            if (type.equals(ImportMPIView.NOD)) {
                AddToImportAction action = new AddToImportAction(this.m_tv_nod, this.m_nodRoot, this.m_nodSection);
                this.m_gui.enableField(this.m_add_btn, action.isEnabled());
            } else if (type.equals(ImportMPIView.NOD_4IMPORT)) {
                ResetElementsAction action3 = new ResetElementsAction(this.m_tv_nod4Import, this.m_nodSection, ImportMPIView.RESET_TREE);
                this.m_resetTree_btn.setText(action3.getText());
                this.m_gui.enableField(this.m_resetTree_btn, action3.isEnabled());
                RemoveFromImportAction action4 = new RemoveFromImportAction(this.m_tv_nod4Import, this.m_nod4ImportRoot, this.m_nodSection);
                this.m_gui.enableField(this.m_removeFromImport_btn, action4.isEnabled());
                this.m_gui.enableField(this.m_remove_btn, action4.isEnabled());
            }
        }
    }

    public class AddToImportAction
    extends Action {
        private ImportMPINodeGroupsSection m_section;
        private Map<GroupTreeObject, String> m_elements;

        public AddToImportAction(TreeViewer tv, GroupTreeObject root, ImportMPINodeGroupsSection section) {
            super("addtoimportaction");
            this.m_section = null;
            this.m_elements = new HashMap<GroupTreeObject, String>();
            this.setId("addtoimportaction");
            this.setText("Add To Import");
            this.m_section = section;
            if (tv == null || this.m_section == null) {
                this.setEnabled(false);
                return;
            }
            StructuredSelection sel = (StructuredSelection)tv.getSelection();
            if (sel.size() > 0) {
                GroupTreeObject gto;
                ArrayList<GroupTreeObject> map = new ArrayList<GroupTreeObject>();
                for (Object selected : sel) {
                    if (selected instanceof GroupTreeObjectLast) {
                        map.add((GroupTreeObjectLast)selected);
                        continue;
                    }
                    if (!(selected instanceof GroupTreeObject)) continue;
                    gto = (GroupTreeObject)selected;
                    map.add(gto);
                    map.addAll(gto.getAllElements());
                }
                int i = 0;
                while (i < map.size()) {
                    gto = (GroupTreeObject)map.get(i);
                    this.m_elements.put(gto, gto.getName());
                    ++i;
                }
            }
            if (this.m_elements.size() == 0) {
                this.setEnabled(false);
            }
        }

        public void run() {
            if (!this.isEnabled()) {
                return;
            }
            if (this.m_section == null || this.m_elements.size() == 0) {
                return;
            }
            this.m_section.addToImport(this.m_elements);
        }
    }

    class ContentProviderNodImportTree
    extends ViewContentProvider {
        @Override
        public Object[] getElements(Object obj) {
            Object[] oList = this.getChildren(obj);
            return oList;
        }
    }

    public class MergeAction
    extends Action {
        private ImportMPINodeGroupsSection m_section;
        private Map<GroupTreeObject, String> m_elements;

        public MergeAction(TreeViewer tv, ImportMPINodeGroupsSection section) {
            super("mergeaction");
            this.m_section = null;
            this.m_elements = new HashMap<GroupTreeObject, String>();
            this.setId("mergeaction");
            this.setText("Merge");
            this.m_section = section;
            if (tv == null || this.m_section == null) {
                this.setEnabled(false);
                return;
            }
            StructuredSelection sel = (StructuredSelection)tv.getSelection();
            if (sel.size() > 0) {
                for (Object selected : sel) {
                    if (selected instanceof GroupTreeObjectLast || !(selected instanceof GroupTreeObject)) continue;
                    GroupTreeObject gto = (GroupTreeObject)selected;
                    if (gto.getName().equals("_Groups")) {
                        this.m_elements.clear();
                        List<GroupTreeObject> list = gto.getElements();
                        for (GroupTreeObject nodGrp : list) {
                            if (!this.m_section.hasInitialConflict(nodGrp) || this.m_section.doMergeNodeGroup(nodGrp)) continue;
                            this.m_elements.put(nodGrp, nodGrp.getName());
                        }
                        break;
                    }
                    if (!gto.getParent().getName().equals("_Groups") || !this.m_section.hasInitialConflict(gto) || this.m_section.doMergeNodeGroup(gto)) continue;
                    this.m_elements.put(gto, gto.getName());
                }
            }
            if (this.m_elements.size() == 0) {
                this.setEnabled(false);
            }
        }

        public void run() {
            if (!this.isEnabled()) {
                return;
            }
            if (this.m_section == null || this.m_elements.size() == 0) {
                return;
            }
            this.m_section.mergeNodeGroups(this.m_elements);
        }
    }

    public class RemoveFromImportAction
    extends Action {
        private ImportMPINodeGroupsSection m_section;
        private Map<GroupTreeObject, String> m_elements;

        public RemoveFromImportAction(TreeViewer tv, GroupTreeObject root, ImportMPINodeGroupsSection section) {
            super("skipimport");
            this.m_section = null;
            this.m_elements = new HashMap<GroupTreeObject, String>();
            this.setId("skipimport");
            this.setText("Remove");
            this.m_section = section;
            if (root == null || this.m_section == null) {
                this.setEnabled(false);
                return;
            }
            StructuredSelection sel = (StructuredSelection)tv.getSelection();
            if (sel.size() > 0) {
                for (Object selected : sel) {
                    if (selected instanceof GroupTreeObjectLast) {
                        GroupTreeObjectLast gtol = (GroupTreeObjectLast)selected;
                        this.m_elements.put(gtol, gtol.getName());
                        continue;
                    }
                    if (!(selected instanceof GroupTreeObject)) continue;
                    GroupTreeObject gto = (GroupTreeObject)selected;
                    this.m_elements.put(gto, gto.getName());
                }
            }
            if (this.m_elements.size() == 0) {
                this.setEnabled(false);
            }
        }

        public void run() {
            if (!this.isEnabled()) {
                return;
            }
            if (this.m_section == null || this.m_elements.size() == 0) {
                return;
            }
            this.m_section.removeFromImport(this.m_elements);
        }
    }

    public class ResetElementsAction
    extends Action {
        private ImportMPINodeGroupsSection m_section;
        private String m_type;
        private Map<String, GroupTreeObject> m_elements;

        public ResetElementsAction(TreeViewer tv, ImportMPINodeGroupsSection section, String type) {
            super("clearelements");
            this.m_section = null;
            this.m_type = null;
            this.m_elements = new HashMap<String, GroupTreeObject>();
            this.setId("clearelements");
            this.m_section = section;
            this.m_type = type;
            this.setText("Reset");
            if (tv == null || section == null || type == null) {
                this.setEnabled(false);
                return;
            }
            StructuredSelection sel = (StructuredSelection)tv.getSelection();
            if (!this.m_type.equals(ImportMPIView.RESET_TREE)) {
                if (this.m_type.equals(RESET_NODE_GRP)) {
                    this.setText("Reset Group");
                    if (sel.size() > 0) {
                        for (Object selected : sel) {
                            GroupTreeObject gto;
                            if (selected instanceof GroupTreeObjectLast || !(selected instanceof GroupTreeObject) || (gto = (GroupTreeObject)selected).getName().equals("_Groups") || !gto.getParent().getName().equals("_Groups")) continue;
                            this.m_elements.put(gto.getName(), gto);
                        }
                    }
                    if (this.m_elements.size() == 0) {
                        this.setEnabled(false);
                    } else if (this.m_elements.size() > 1) {
                        this.setText("Reset Groups");
                    }
                    return;
                }
                this.setText("Reset");
                this.setEnabled(false);
                return;
            }
            this.setText("Reset Tree");
        }

        public void run() {
            if (!this.isEnabled()) {
                return;
            }
            if (this.m_type.equals(ImportMPIView.RESET_TREE)) {
                this.m_section.updateSection(ImportMPINodeGroupsSection.this.m_lastNodeGroupFilePath, true, ImportMPINodeGroupsSection.this.m_importType);
            } else if (this.m_type.equals(RESET_NODE_GRP)) {
                this.m_section.resetNodeGroups(this.m_elements);
            }
        }
    }

    class StyledLabelProviderNodImportTree
    extends StyledCellLabelProvider {
        ImportMPINodeGroupsSection m_section = null;

        public StyledLabelProviderNodImportTree(ImportMPINodeGroupsSection section) {
            this.m_section = section;
        }

        public void update(ViewerCell cell) {
            Object element = cell.getElement();
            Image defaultIcon = BMUI.IMAGE_FOLDER_DEFAULT;
            Image icon = null;
            cell.setBackground(null);
            if (element instanceof GroupTreeObjectLast) {
                GroupTreeObjectLast gtol = (GroupTreeObjectLast)element;
                cell.setText(gtol.getName());
                icon = BMUI.IMAGE_MAP.get(gtol.getIcon());
                if (icon == null) {
                    icon = BMUI.IMAGE_MAP.get(gtol.getType());
                }
            } else if (element instanceof GroupTreeObject) {
                GroupTreeObject gto = (GroupTreeObject)element;
                cell.setText(gto.getName());
                String type = gto.getTreeObject().getType();
                if (type != null) {
                    icon = BMUI.IMAGE_MAP.get(type);
                }
                if (!gto.getName().equals("_Groups")) {
                    if (this.m_section.doesElemBelongToNewNodeGrp(gto)) {
                        cell.setForeground(BMUI.color_green);
                    } else {
                        this.m_section.doesElemBelongToExistingNodeGrp(gto);
                    }
                }
            }
            if (icon == null) {
                icon = defaultIcon;
            }
            cell.setImage(icon);
            super.update(cell);
        }
    }

    class StyledLabelProviderNodTree
    extends StyledCellLabelProvider {
        ImportMPINodeGroupsSection m_section = null;

        public StyledLabelProviderNodTree(ImportMPINodeGroupsSection section) {
            this.m_section = section;
        }

        public void update(ViewerCell cell) {
            Object element = cell.getElement();
            Image defaultIcon = BMUI.IMAGE_FOLDER_DEFAULT;
            Image icon = null;
            if (element instanceof GroupTreeObjectLast) {
                GroupTreeObjectLast gtol = (GroupTreeObjectLast)element;
                cell.setText(gtol.getName());
                icon = BMUI.IMAGE_MAP.get(gtol.getIcon());
                if (icon == null) {
                    icon = BMUI.IMAGE_MAP.get(gtol.getType());
                }
            } else if (element instanceof GroupTreeObject) {
                GroupTreeObject gto = (GroupTreeObject)element;
                cell.setText(gto.getName());
                String type = gto.getTreeObject().getType();
                if (type != null) {
                    icon = BMUI.IMAGE_MAP.get(type);
                }
            }
            if (icon == null) {
                icon = defaultIcon;
            }
            cell.setImage(icon);
            super.update(cell);
        }
    }
}

