/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.engine.UIJob;
import com.blixx.boom.gui.dialogs.PolicyRenamingDialog;
import com.blixx.boom.gui.dialogs.ShowMessageBox;
import com.blixx.boom.gui.policies.ViewContentProvider;
import com.blixx.boom.gui.utils.GUIDisplayElements;
import com.blixx.boom.gui.utils.STreeViewer;
import com.blixx.boom.gui.views.FancyToolTipSupport;
import com.blixx.boom.gui.views.ImportMPIView;
import com.blixx.boom.gui.views.PolicyCompareTab;
import com.blixx.boom.gui.views.actions.ExpandCollapseAction;
import com.blixx.boom.gui.views.actions.PolicyRenamingAction;
import com.blixx.ctrl.sc.ICmdPostProcess;
import com.blixx.ctrl.sc.ServerClient;
import com.blixx.ctrl.sc.in.ScGetPolicyTreeMD5;
import com.blixx.ctrl.sc.in.ScValidateCmd;
import com.blixx.log.RTLogger;
import com.blixx.shared.AbstractPolicy;
import com.blixx.shared.PolicyFactory;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.GroupTreeObjectLast;
import com.blixx.shared.utils.ITreeObject;
import com.blixx.shared.utils.TreeObject;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class ImportMPIPolicySection
extends Section
implements IExpansionListener,
SelectionListener,
ISelectionChangedListener,
ICmdPostProcess {
    public static final String MD5 = "MD5";
    private ImportMPIView m_importMPIView = null;
    private ImportMPIPolicySection m_section = null;
    private File m_polGrpFile = null;
    private GroupTreeObject m_existingPolicyTree = null;
    private String m_importType = null;
    private TreeViewer m_tv_pol = null;
    private TreeViewer m_tv_pol4Import = null;
    private GroupTreeObject m_polRoot = null;
    private GroupTreeObject m_pol4ImportRoot = null;
    private ContentProviderPolImportTree m_treeContentProvider_final = null;
    private GUIDisplayElements m_gui = null;
    private FormToolkit m_toolkit = null;
    private Group m_importTree_grp = null;
    private Group m_finalTree_grp = null;
    private Text m_polFooter = null;
    private Text m_pol4ImportFooter = null;
    private int m_totalImportConflicts = 0;
    private HashMap<String, GroupTreeObjectLast> m_allPolicies = new HashMap();
    private List<String> m_missingImportFiles = new ArrayList<String>();
    private List<String> m_missingImportAndSrvFiles = new ArrayList<String>();
    private Map<String, String> m_policyExistsWithSamePath = new HashMap<String, String>();
    private Map<String, String> m_policyExistsWithDifferentPath = new HashMap<String, String>();
    private Map<String, String> m_policiesWithNewVersions = new HashMap<String, String>();
    private Map<String, String> m_policyUseSrvPath = new HashMap<String, String>();
    private Map<String, String> m_policyUseXMLPath = new HashMap<String, String>();
    private Map<String, String> m_policiesToRename = new HashMap<String, String>();
    private Map<String, String> m_policiesToRenameREVERSE = new HashMap<String, String>();
    private Map<String, GroupTreeObjectLast> m_skipImport = new HashMap<String, GroupTreeObjectLast>();
    private Map<String, GroupTreeObjectLast> m_finalPolicies = new HashMap<String, GroupTreeObjectLast>();
    private Map<String, String> m_equalByContent = new HashMap<String, String>();
    private static String USE_SRV_PATH = "USE_SRV_PATH";
    private static String USE_XML_PATH = "USE_XML_PATH";
    private static String RESET_POLICY = "RESET_POLICY";
    private static String ADD_BTN = "ADD_BTN";
    private static String REMOVE_BTN = "REMOVE_BTN";
    private static String RENAME_BTN = "RENAME_BTN";
    private static String INCREASE_VERSION_BTN = "INCREASE_VERSION_BTN";
    private static String USE_XML_PATH_BTN = "USE_EXISTING_PATH_BTN";
    private static String USE_SRV_PATH_BTN = "USE_SRV_PATH_BTN";
    private static String RESET_TREE_BTN = "RESET_TREE_BTN";
    private static String REMOVE_FROM_IMPORT_BTN = "REMOVE_FROM_IMPORT_BTN";
    private static String CONTENT_COMPARE_BTN = "CONTENT_COMPARE_BTN";
    private Button m_add_btn = null;
    private Button m_remove_btn = null;
    private Button m_rename_btn = null;
    private Button m_increaseVersion_btn = null;
    private Button m_useXMLPath_btn = null;
    private Button m_useSrvPath_btn = null;
    private Button m_resetTree_btn = null;
    private Button m_removeFromImport_btn = null;
    private Button m_contentCompare_btn = null;
    Listener paintListenerPolTree = new Listener(){

        public void handleEvent(Event event) {
            TreeItem ti;
            Object o;
            Widget obj = event.item;
            if (obj instanceof TreeItem && (o = (ti = (TreeItem)event.item).getData()) instanceof GroupTreeObjectLast) {
                GroupTreeObjectLast gtol = (GroupTreeObjectLast)o;
                Image icon = null;
                if (!ImportMPIPolicySection.this.doesAnyFileExist(gtol)) {
                    icon = BMUI.IMAGE_CANCEL_ROUND;
                }
                if (icon != null) {
                    switch (event.type) {
                        case 41: {
                            Rectangle rect = icon.getBounds();
                            event.width += rect.width;
                            event.height = Math.max(event.height, rect.height + 2);
                            break;
                        }
                        case 42: {
                            int x = event.x + event.width;
                            Rectangle rect = icon.getBounds();
                            int offset = Math.max(0, (event.height - rect.height) / 2);
                            event.gc.drawImage(icon, x, event.y + offset);
                        }
                    }
                }
            }
        }
    };
    Listener paintListenerPolImportTree = new Listener(){

        public void handleEvent(Event event) {
            TreeItem ti;
            Object o;
            Widget obj = event.item;
            if (obj instanceof TreeItem && (o = (ti = (TreeItem)event.item).getData()) instanceof GroupTreeObjectLast) {
                GroupTreeObjectLast gtol = (GroupTreeObjectLast)o;
                Image conflictIcon = ImportMPIPolicySection.this.getInitialConflictIcon(gtol, false);
                List solvedIconList = ImportMPIPolicySection.this.getSolvedIcon(gtol, false);
                int width = 0;
                int hight = 0;
                if (conflictIcon != null) {
                    width += conflictIcon.getBounds().width;
                    hight = conflictIcon.getBounds().height;
                }
                if (conflictIcon != null && solvedIconList.size() > 0) {
                    int i = 0;
                    while (i < solvedIconList.size()) {
                        Image solvedIcon = (Image)solvedIconList.get(i);
                        width += 5;
                        width += solvedIcon.getBounds().width;
                        int h = solvedIcon.getBounds().height;
                        if (h > hight) {
                            hight = h;
                        }
                        ++i;
                    }
                }
                Rectangle rect = new Rectangle(0, 0, width, hight);
                switch (event.type) {
                    case 41: {
                        event.width += rect.width;
                        event.height = Math.max(event.height, rect.height + 2);
                        break;
                    }
                    case 42: {
                        int x = event.x + event.width;
                        int offset = Math.max(0, (event.height - rect.height) / 2);
                        int hIndent = 0;
                        if (conflictIcon != null) {
                            event.gc.drawImage(conflictIcon, x, event.y + offset);
                            hIndent = conflictIcon.getBounds().width + 5;
                        }
                        if (solvedIconList.size() <= 0) break;
                        int i = 0;
                        while (i < solvedIconList.size()) {
                            Image solvedIcon = (Image)solvedIconList.get(i);
                            event.gc.drawImage(solvedIcon, x + hIndent, event.y + offset);
                            hIndent += solvedIcon.getBounds().width + 5;
                            ++i;
                        }
                        break;
                    }
                }
            }
        }
    };

    public ImportMPIPolicySection(Composite parent, ImportMPIView importMPIView) {
        super(parent, 578);
        this.setText("Policies");
        this.setLayoutData(new GridData(4, 128, true, false));
        this.m_section = this;
        this.m_importMPIView = importMPIView;
    }

    public void initSection() {
        this.m_gui = new GUIDisplayElements();
        this.m_toolkit = BMUI.getFormToolkit(Display.getCurrent());
        Composite sectionClient = this.m_toolkit.createComposite((Composite)this.m_section, 0);
        sectionClient.setLayout((Layout)new GridLayout(2, false));
        sectionClient.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite treeComp = new Composite(sectionClient, 0);
        GridLayout gl = new GridLayout(3, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        treeComp.setLayout((Layout)gl);
        treeComp.setLayoutData((Object)new GridData(4, 4, true, true));
        this.m_importTree_grp = new Group(treeComp, 32);
        this.m_importTree_grp.setText("policyGroups.xml");
        this.m_importTree_grp.setLayout((Layout)new GridLayout(1, false));
        this.m_importTree_grp.setLayoutData((Object)new GridData(4, 4, true, true));
        this.m_tv_pol = new STreeViewer((Composite)this.m_importTree_grp, 268438274);
        this.m_tv_pol.setData(ImportMPIView.TREE_VIEWER_TYPE, (Object)ImportMPIView.POLICY);
        this.m_tv_pol.getTree().setLayoutData((Object)ImportMPIView.m_sectionTree_gd);
        this.m_tv_pol.setUseHashlookup(true);
        this.m_tv_pol.setContentProvider((IContentProvider)new ViewContentProvider());
        this.m_tv_pol.setLabelProvider((IBaseLabelProvider)new StyledLabelProviderPolTree(this, this.m_tv_pol));
        this.m_tv_pol.setInput((Object)this.m_polRoot);
        this.m_tv_pol.addSelectionChangedListener((ISelectionChangedListener)this);
        this.m_tv_pol.getTree().addListener(41, this.paintListenerPolTree);
        this.m_tv_pol.getTree().addListener(42, this.paintListenerPolTree);
        this.createXMLTree_CM();
        FancyToolTipSupport.enableFor((ColumnViewer)this.m_tv_pol, 2);
        this.m_tv_pol.getTree().setToolTipText("");
        this.m_polFooter = this.m_gui.addTextReadOnlyNoBorder((Composite)this.m_importTree_grp, null, "", 1, 1, 1, 1, BMUI.font_arial8);
        this.updateTreeFooter(this.m_tv_pol);
        Composite btn1Comp = new Composite(treeComp, 0);
        gl = new GridLayout(1, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        btn1Comp.setLayout((Layout)gl);
        btn1Comp.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        this.m_add_btn = this.m_gui.addButton(btn1Comp, ADD_BTN, " >> ", false, this);
        this.m_remove_btn = this.m_gui.addButton(btn1Comp, REMOVE_BTN, " << ", false, this);
        this.m_finalTree_grp = new Group(treeComp, 32);
        this.m_finalTree_grp.setText("Preview");
        this.m_finalTree_grp.setLayout((Layout)new GridLayout(1, false));
        GridData gd = new GridData(4, 4, true, true);
        gd.horizontalIndent = 10;
        this.m_finalTree_grp.setLayoutData((Object)gd);
        this.m_tv_pol4Import = new STreeViewer((Composite)this.m_finalTree_grp, 268438274);
        this.m_tv_pol4Import.setData(ImportMPIView.TREE_VIEWER_TYPE, (Object)ImportMPIView.POLICY_4IMPORT);
        this.m_tv_pol4Import.getTree().setLayoutData((Object)ImportMPIView.m_sectionTree_gd);
        this.m_tv_pol4Import.setUseHashlookup(true);
        this.m_treeContentProvider_final = new ContentProviderPolImportTree();
        this.m_tv_pol4Import.setContentProvider((IContentProvider)this.m_treeContentProvider_final);
        this.m_tv_pol4Import.setLabelProvider((IBaseLabelProvider)new StyledLabelProviderPolImportTree(this, this.m_tv_pol4Import));
        this.m_tv_pol4Import.setInput((Object)this.m_pol4ImportRoot);
        this.m_tv_pol4Import.addSelectionChangedListener((ISelectionChangedListener)this);
        this.m_tv_pol4Import.getTree().addListener(41, this.paintListenerPolImportTree);
        this.m_tv_pol4Import.getTree().addListener(42, this.paintListenerPolImportTree);
        this.m_tv_pol4Import.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                StructuredSelection ss = (StructuredSelection)event.getSelection();
                GroupTreeObject g = (GroupTreeObject)ss.getFirstElement();
                if (g != null && (BMUI.type_mon.equals(g.getType()) || BMUI.type_msg.equals(g.getType()))) {
                    try {
                        PolicyFactory pf = new PolicyFactory();
                        File impFile = pf.getPolicyFile(((ImportMPIPolicySection)ImportMPIPolicySection.this).m_importMPIView.m_policiesDir, g.getName(), g.getType());
                        File downloaded = Repository.getInstance().fetchFile(g.getName(), g.getType());
                        if (downloaded == null) {
                            new ShowMessageBox("Error", "Error getting policy from the server", 1);
                            return;
                        }
                        PolicyCompareTab pct = new PolicyCompareTab(ImportMPIPolicySection.this.getShell(), impFile, downloaded, "Import version", "Server version", true);
                        pct.open();
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        this.createFinalTree_CM();
        FancyToolTipSupport.enableFor((ColumnViewer)this.m_tv_pol4Import, 2);
        this.m_tv_pol4Import.getTree().setToolTipText("");
        this.m_pol4ImportFooter = this.m_gui.addTextReadOnlyNoBorder((Composite)this.m_finalTree_grp, null, "", 1, 1, 1, 1, BMUI.font_arial8);
        this.updateTreeFooter(this.m_tv_pol4Import);
        Composite btnComp = new Composite(sectionClient, 0);
        btnComp.setLayout((Layout)new GridLayout(1, false));
        btnComp.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.m_rename_btn = this.m_gui.addButton(btnComp, RENAME_BTN, "Rename", false, this);
        this.m_rename_btn.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.m_increaseVersion_btn = this.m_gui.addButton(btnComp, INCREASE_VERSION_BTN, "Increase Version", false, this);
        this.m_increaseVersion_btn.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.m_useXMLPath_btn = this.m_gui.addButton(btnComp, USE_XML_PATH_BTN, "Use XML Path", false, this);
        this.m_useXMLPath_btn.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.m_useSrvPath_btn = this.m_gui.addButton(btnComp, USE_SRV_PATH_BTN, "Use Server Path", false, this);
        this.m_useSrvPath_btn.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.m_resetTree_btn = this.m_gui.addButton(btnComp, RESET_TREE_BTN, "Reset Tree", false, this);
        this.m_resetTree_btn.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.m_removeFromImport_btn = this.m_gui.addButton(btnComp, REMOVE_FROM_IMPORT_BTN, "Remove", false, this);
        this.m_removeFromImport_btn.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.m_contentCompare_btn = this.m_gui.addButton(btnComp, CONTENT_COMPARE_BTN, "Compare with server", false, this);
        this.m_contentCompare_btn.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.setClient((Control)sectionClient);
        this.addExpansionListener(this);
    }

    public void updateSection(File polGrpFile, List<GroupTreeObjectLast> policies, GroupTreeObject importROOT) {
        File policyFile;
        String md5;
        if (!this.isEnabled()) {
            return;
        }
        this.m_allPolicies.clear();
        this.m_missingImportFiles.clear();
        this.m_missingImportAndSrvFiles.clear();
        this.m_policyExistsWithSamePath.clear();
        this.m_policyExistsWithDifferentPath.clear();
        this.m_policiesToRename.clear();
        this.m_policiesToRenameREVERSE.clear();
        this.m_policiesWithNewVersions.clear();
        this.m_policyUseSrvPath.clear();
        this.m_policyUseXMLPath.clear();
        this.m_skipImport.clear();
        this.m_finalPolicies.clear();
        this.m_equalByContent.clear();
        this.m_importType = this.m_importMPIView.getImportType();
        this.m_polGrpFile = polGrpFile;
        this.m_polRoot = importROOT;
        for (GroupTreeObject gto : this.m_polRoot.findElementsByType(BMUI.type_mon)) {
            if (gto == null || (md5 = AbstractPolicy.doChecksum(policyFile = new PolicyFactory().getPolicyFile(this.m_importMPIView.m_policiesDir, gto.getName(), gto.getType()))) == null || md5.length() <= 0) continue;
            gto.setAttribute(MD5, md5);
        }
        for (GroupTreeObject gto : this.m_polRoot.findElementsByType(BMUI.type_msg)) {
            if (gto == null || (md5 = AbstractPolicy.doChecksum(policyFile = new PolicyFactory().getPolicyFile(this.m_importMPIView.m_policiesDir, gto.getName(), gto.getType()))) == null || md5.length() <= 0) continue;
            gto.setAttribute(MD5, md5);
        }
        this.m_pol4ImportRoot = null;
        int i = 0;
        while (i < policies.size()) {
            GroupTreeObjectLast gtol = policies.get(i);
            this.m_allPolicies.put(gtol.getName(), gtol);
            ++i;
        }
        if (this.m_polRoot != null) {
            this.cloneTree();
            this.checkConflicts();
            ContentCompare cc = new ContentCompare(this);
            cc.run();
        }
        this.refreshTree(this.m_tv_pol, this.m_polRoot, 3);
        this.refreshTree(this.m_tv_pol4Import, this.m_pol4ImportRoot, 3);
        if (this.m_polRoot == null || this.m_polRoot.getElements().size() == 0) {
            this.setExpanded(false);
        } else {
            this.setExpanded(true);
        }
    }

    public void clearSection() {
        this.m_polRoot = null;
        this.m_pol4ImportRoot = null;
        this.m_allPolicies.clear();
        this.refreshTree(this.m_tv_pol, this.m_polRoot, 0);
        this.refreshTree(this.m_tv_pol4Import, this.m_pol4ImportRoot, 0);
        this.updateTreeFooter(this.m_tv_pol);
        this.updateTreeFooter(this.m_tv_pol4Import);
    }

    private void cloneTree() {
        try {
            this.m_pol4ImportRoot = this.m_polRoot.clone();
            List<GroupTreeObject> elements = this.m_pol4ImportRoot.getAllElements();
            this.m_importMPIView.updateProgressBar("Analyzing policies", 0, elements.size());
            int progress = 0;
            for (GroupTreeObject gto : elements) {
                GroupTreeObject orig = this.m_polRoot.searchPath(gto.getPath(), gto.getType());
                if (orig != null) {
                    ITreeObject to = gto.getTreeObject();
                    TreeObject toNew = new TreeObject(to.getName(), to.getType(), orig.getPath());
                    gto.setTreeObject(toNew);
                }
                this.m_importMPIView.updateProgressBar("Analyzing policies", ++progress, elements.size());
            }
        }
        catch (CloneNotSupportedException e) {
            this.m_pol4ImportRoot = null;
            RTLogger.print(5, "ImportMPI: Error cloning import tree", e);
        }
    }

    private void checkConflicts() {
        block9: {
            block8: {
                this.m_existingPolicyTree = this.m_importMPIView.getExistingPolTree();
                if (!this.m_importType.equals(ImportMPIView.IMPORT_OTHER)) break block8;
                Iterator<GroupTreeObjectLast> it = this.m_allPolicies.values().iterator();
                while (it.hasNext()) {
                    String polGrpFileDir = this.m_polGrpFile.getParent();
                    GroupTreeObjectLast gtolNew = it.next();
                    String name = gtolNew.getName();
                    String type = gtolNew.getType();
                    String filename = String.valueOf(name) + "." + type + ".xml";
                    GroupTreeObjectLast gtolExist = this.m_existingPolicyTree.findElement(name, type);
                    File f = new File(polGrpFileDir, filename);
                    if (!f.exists() || !f.canRead()) {
                        GroupTreeObjectLast gtol = this.m_pol4ImportRoot.findElement(name, type);
                        if (gtol != null) {
                            gtol.getParent().removeElement(gtol);
                        }
                        if ((gtol = this.m_polRoot.findElement(name, type)) == null) continue;
                        gtol.getParent().removeElement(gtol);
                        continue;
                    }
                    if (gtolExist == null) continue;
                    String newPath = gtolNew.getPath();
                    String srvPath = gtolExist.getPath();
                    String srvParentPath = gtolExist.getParentPath();
                    if (newPath.equals(srvPath)) {
                        this.m_policyExistsWithSamePath.put(name, srvParentPath);
                        continue;
                    }
                    this.m_policyExistsWithDifferentPath.put(name, srvParentPath);
                    GroupTreeObjectLast gtol2Move = this.m_pol4ImportRoot.findElement(name, type);
                    this.m_importMPIView.moveElement(this.m_pol4ImportRoot, gtol2Move, srvParentPath);
                }
                break block9;
            }
            if (!this.m_importType.equals(ImportMPIView.IMPORT_MPI)) break block9;
            String polGrpFileDir = this.m_polGrpFile.getParent();
            for (GroupTreeObjectLast gtolNew : this.m_allPolicies.values()) {
                String name = gtolNew.getName();
                String type = gtolNew.getType();
                String filename = String.valueOf(name) + "." + type + ".xml";
                GroupTreeObjectLast gtolExist = this.m_existingPolicyTree.findElement(name, type);
                File f = new File(polGrpFileDir, filename);
                if (!f.exists() || !f.canRead()) {
                    if (gtolExist == null) {
                        this.m_missingImportAndSrvFiles.add(name);
                        GroupTreeObjectLast gtol = this.m_pol4ImportRoot.findElement(name, type);
                        if (gtol == null) continue;
                        gtol.getParent().removeElement(gtol);
                        continue;
                    }
                    this.m_missingImportFiles.add(name);
                }
                if (gtolExist == null) continue;
                String newPath = gtolNew.getPath();
                String srvPath = gtolExist.getPath();
                String srvParentPath = gtolExist.getParentPath();
                if (newPath.equals(srvPath)) {
                    this.m_policyExistsWithSamePath.put(name, srvParentPath);
                    continue;
                }
                this.m_policyExistsWithDifferentPath.put(name, srvParentPath);
                GroupTreeObjectLast gtol2Move = this.m_pol4ImportRoot.findElement(name, type);
                this.m_importMPIView.moveElement(this.m_pol4ImportRoot, gtol2Move, srvParentPath);
            }
        }
    }

    private void updateTreeFooter(TreeViewer tv) {
        StringBuffer sb = new StringBuffer();
        String type = (String)tv.getData(ImportMPIView.TREE_VIEWER_TYPE);
        if (type.equalsIgnoreCase(ImportMPIView.POLICY)) {
            int total = this.m_allPolicies.size();
            int conflicts = 0;
            if (this.m_polRoot != null) {
                conflicts = this.getNumberOfConflicts(tv, this.m_polRoot);
            }
            sb.append("Policies (").append(total).append(")").append("  Conflicts (").append(conflicts).append(")");
            this.m_polFooter.setText(sb.toString());
            this.m_polFooter.pack(true);
        } else if (type.equalsIgnoreCase(ImportMPIView.POLICY_4IMPORT)) {
            this.m_totalImportConflicts = 0;
            int conflicts = 0;
            if (this.m_pol4ImportRoot != null) {
                Iterator<GroupTreeObject> it = this.m_pol4ImportRoot.getAllElements().iterator();
                while (it.hasNext()) {
                    if (!(it.next() instanceof GroupTreeObjectLast)) continue;
                    ++this.m_totalImportConflicts;
                }
                conflicts = this.getNumberOfConflicts(tv, this.m_pol4ImportRoot);
            }
            sb.append("Policies (").append(this.m_totalImportConflicts).append(")").append("  Conflicts (").append(conflicts).append(")");
            this.m_pol4ImportFooter.setText(sb.toString());
            this.m_pol4ImportFooter.pack(true);
        }
    }

    private boolean doesImportFileExist(GroupTreeObject gto) {
        boolean fileExist = true;
        String origName = gto.getName();
        GroupTreeObject origGTO = this.getOriginalElement(gto);
        if (origGTO != null) {
            origName = origGTO.getName();
        }
        if (this.m_missingImportFiles.contains(origName) || this.m_missingImportAndSrvFiles.contains(origName)) {
            fileExist = false;
        }
        return fileExist;
    }

    private boolean doesAnyFileExist(GroupTreeObject gto) {
        boolean fileExist = true;
        String origName = gto.getName();
        GroupTreeObject origGTO = this.getOriginalElement(gto);
        if (origGTO != null) {
            origName = origGTO.getName();
        }
        if (this.m_missingImportAndSrvFiles.contains(origName)) {
            fileExist = false;
        }
        return fileExist;
    }

    public boolean doesLinkedPathExistInXML(String path, String type) {
        if (this.m_polRoot == null) {
            return false;
        }
        GroupTreeObject foundGTO = this.m_polRoot.searchPath(path, type);
        return foundGTO != null && this.doesImportFileExist(foundGTO);
    }

    public boolean isLinkedPolicyPartOfImport(String origName, String type, String linkedPath) {
        if (this.m_polRoot == null) {
            return false;
        }
        GroupTreeObjectLast foundGTO = this.m_polRoot.findElement(origName, type);
        return foundGTO != null && !this.m_missingImportAndSrvFiles.contains(origName);
    }

    public boolean isLinkedPolicyPartOfImportTree(GroupTreeObjectLast gtol) {
        if (this.m_pol4ImportRoot == null) {
            return false;
        }
        GroupTreeObjectLast gtolFound = this.m_pol4ImportRoot.findElement(gtol.getName(), gtol.getType());
        return gtolFound != null;
    }

    public void resolveBrokenLinks(Map<GroupTreeObjectLast, String> elements) {
        if (this.m_polRoot == null) {
            return;
        }
        for (GroupTreeObjectLast link2Resolve : elements.keySet()) {
            GroupTreeObject origGTOL;
            GroupTreeObject gtolExist;
            String type;
            String linkedPath = link2Resolve.getLinkedPath();
            if (!this.doesLinkedPathExistInXML(linkedPath, type = link2Resolve.getType()) || (gtolExist = this.m_pol4ImportRoot.searchPath(linkedPath, type)) != null || (origGTOL = this.m_polRoot.searchPath(linkedPath, type)) == null || this.m_policiesToRename.containsKey(origGTOL.getName())) continue;
            this.m_importMPIView.addElement2Tree(this.m_pol4ImportRoot, origGTOL, origGTOL.getParentPath());
        }
        this.refreshTree(this.m_tv_pol4Import, this.m_pol4ImportRoot, -1);
    }

    private List<String> getAllMissingFiles() {
        List<String> allMissingFiles = this.m_missingImportFiles;
        allMissingFiles.addAll(this.m_missingImportAndSrvFiles);
        return allMissingFiles;
    }

    private boolean doesElementExistOnServer(GroupTreeObject gto) {
        GroupTreeObject gtoFound = this.m_existingPolicyTree.searchPath(gto.getPath(), gto.getType());
        return gtoFound != null;
    }

    public boolean doesPolicyExistOnServer(String name, String type) {
        GroupTreeObjectLast gtoFound = this.m_existingPolicyTree.findElement(name, type);
        return gtoFound != null;
    }

    private boolean hasPathConflict(GroupTreeObject gto) {
        String origName;
        GroupTreeObject origGTO = this.getOriginalElement(gto);
        return origGTO != null && this.m_policyExistsWithDifferentPath.containsKey(origName = origGTO.getName());
    }

    private boolean hasPathConflictSolved(GroupTreeObject gto) {
        String origName;
        GroupTreeObject origGTO = this.getOriginalElement(gto);
        return origGTO != null && (this.m_policyUseSrvPath.containsKey(origName = origGTO.getName()) || this.m_policyUseXMLPath.containsKey(origName) || this.m_policiesToRename.containsKey(origName));
    }

    private boolean hasRenamed(GroupTreeObject gto) {
        String origName;
        GroupTreeObject origGTO = this.getOriginalElement(gto);
        return origGTO != null && this.m_policiesToRename.containsKey(origName = origGTO.getName());
    }

    private boolean hasInitialConflict(GroupTreeObject binGto) {
        String origName;
        boolean hasConflict = false;
        GroupTreeObject origGTOL = this.getOriginalElement(binGto);
        if (origGTOL != null && (this.m_policyExistsWithSamePath.containsKey(origName = origGTOL.getName()) && !this.isPolicyEqualByContent(origName) || this.m_policyExistsWithDifferentPath.containsKey(origName))) {
            hasConflict = true;
        }
        return hasConflict;
    }

    private boolean hasConflict(GroupTreeObjectLast gtol) {
        List<Image> list;
        GroupTreeObject origGTO;
        boolean hasConflict = false;
        if (this.hasInitialConflict(gtol) && (origGTO = this.getOriginalElement(gtol)) != null && ((list = this.getSolvedIcon((GroupTreeObjectLast)origGTO, true)) == null || list.size() == 0)) {
            hasConflict = true;
        }
        return hasConflict;
    }

    public int getTotalImportConflicts() {
        return this.getNumberOfConflicts(this.m_tv_pol4Import, this.m_pol4ImportRoot);
    }

    private int getNumberOfConflicts(TreeViewer tv, GroupTreeObject gto) {
        int count;
        block4: {
            String type;
            block3: {
                count = 0;
                if (tv == null || gto == null) {
                    return count;
                }
                type = (String)tv.getData(ImportMPIView.TREE_VIEWER_TYPE);
                if (!type.equals(ImportMPIView.POLICY)) break block3;
                List<GroupTreeObject> list = gto.getAllElements();
                for (GroupTreeObject elem : list) {
                    GroupTreeObjectLast gtol;
                    String name;
                    if (!(elem instanceof GroupTreeObjectLast) || !this.m_missingImportFiles.contains(name = (gtol = (GroupTreeObjectLast)elem).getName()) && !this.m_missingImportAndSrvFiles.contains(name)) continue;
                    ++count;
                }
                break block4;
            }
            if (!type.equals(ImportMPIView.POLICY_4IMPORT)) break block4;
            List<GroupTreeObject> list = gto.getAllElements();
            for (GroupTreeObject elem : list) {
                if (!(elem instanceof GroupTreeObjectLast) || !this.hasConflict((GroupTreeObjectLast)elem)) continue;
                ++count;
            }
        }
        return count;
    }

    private Image getInitialConflictIcon(GroupTreeObject gtol, boolean origElems) {
        Image icon = null;
        GroupTreeObject origGTO = null;
        String origName = null;
        if (origElems) {
            origGTO = gtol;
            origName = gtol.getName();
        } else {
            origGTO = this.getOriginalElement(gtol);
            if (origGTO != null) {
                origName = origGTO.getName();
            }
        }
        if (origName.length() < 1 || origName.startsWith(".")) {
            icon = BMUI.IMAGE_CANCEL_ROUND;
        } else if (this.m_missingImportAndSrvFiles.contains(origName)) {
            icon = BMUI.IMAGE_CANCEL_ROUND;
        } else if (this.m_policyExistsWithSamePath.containsKey(origName)) {
            icon = BMUI.IMAGE_FOLDER;
        } else if (this.m_policyExistsWithDifferentPath.containsKey(origName)) {
            icon = BMUI.IMAGE_FOLDER_RED;
        }
        return icon;
    }

    private List<Image> getSolvedIcon(GroupTreeObjectLast gtol, boolean origElems) {
        ArrayList<Image> iconList = new ArrayList<Image>();
        GroupTreeObject origGTO = null;
        String origName = null;
        if (origElems) {
            origGTO = gtol;
            origName = gtol.getName();
        } else {
            origGTO = this.getOriginalElement(gtol);
            if (origGTO != null) {
                origName = origGTO.getName();
            }
        }
        if (this.m_policiesWithNewVersions.containsValue(origName)) {
            iconList.add(BMUI.IMAGE_IMPORT_NEW_VERSION);
        }
        if (this.m_policyUseXMLPath.containsKey(origName)) {
            iconList.add(BMUI.IMAGE_IMPORT_MOVED);
        }
        if (this.m_policyUseSrvPath.containsKey(origName)) {
            iconList.add(BMUI.IMAGE_IMPORT_MOVED);
        }
        if (this.m_policiesToRename.containsKey(origName)) {
            iconList.add(BMUI.IMAGE_IMPORT_RENAMED);
        }
        return iconList;
    }

    public GroupTreeObject getOriginalElement(GroupTreeObject gto) {
        ITreeObject to;
        if (this.m_polRoot == null) {
            return null;
        }
        GroupTreeObject origGTO = null;
        if (gto != null && (to = gto.getTreeObject()) != null) {
            Object o = to.getObject();
            if (o != null && o instanceof GroupTreeObject) {
                origGTO = (GroupTreeObject)o;
            } else if (o != null && o instanceof String) {
                String origPath = (String)o;
                origGTO = this.m_polRoot.searchPath(origPath, gto.getType());
            }
        }
        return origGTO;
    }

    private String getInitConflictToolTipMsg(GroupTreeObjectLast gtol) {
        StringBuffer msg = new StringBuffer();
        GroupTreeObject origGTOL = this.getOriginalElement(gtol);
        if (origGTOL != null) {
            String origName = origGTOL.getName();
            if (this.m_policyExistsWithSamePath.containsKey(origName)) {
                msg.append("Policy does exist!").append("<br>");
            } else if (this.m_policyExistsWithDifferentPath.containsKey(origName)) {
                String xmlPath = this.getXMLPath(origGTOL);
                String srvParentPath = this.m_policyExistsWithDifferentPath.get(origName);
                srvParentPath = srvParentPath.replaceFirst("/root/", "");
                msg.append("Path Conflict! Policy does exit with a different path.").append("<br>").append("Incoming:&nbsp;" + xmlPath).append("<br>").append("Server:&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;").append(srvParentPath).append("/").append(origName);
            }
            if (this.m_missingImportFiles.contains(origName)) {
                msg.append("<br>").append("Info: Missing Import File!");
            }
        }
        if (msg.length() == 0) {
            return null;
        }
        return msg.toString();
    }

    private String getSolvedToolTipMsg(GroupTreeObjectLast gtol) {
        String msg = "none";
        GroupTreeObject origGTOL = this.getOriginalElement(gtol);
        if (origGTOL != null) {
            String origName = origGTOL.getName();
            if (this.m_policiesWithNewVersions.containsValue(origName)) {
                msg = "Import with new Version";
            }
            if (this.m_policyUseXMLPath.containsKey(origName)) {
                msg = "none".equals(msg) ? "Server Policy will be moved to the incoming Path!" : String.valueOf(msg) + "<br>Server Policy will be moved to the incoming Path!";
            }
            if (this.m_policyUseSrvPath.containsKey(origName)) {
                msg = "none".equals(msg) ? "Keep Server Path<br>" + this.m_policyUseSrvPath.get(origName) : String.valueOf(msg) + "<br>Keep Server Path<br>" + this.m_policyUseSrvPath.get(origName);
            }
            if (this.m_policiesToRename.containsKey(origName)) {
                msg = "none".equals(msg) ? "Renamed to<br>" + gtol.getName() : "<br>Renamed to<br>" + gtol.getName();
            }
            if (this.isPolicyEqualByContent(origName)) {
                msg = "none".equals(msg) ? "The content of the policies are equal with server." : String.valueOf(msg) + "<br>The content of the policies are equal with server.";
            }
        }
        return msg;
    }

    private String getXMLPath(GroupTreeObject origGTO) {
        String xmlPath = "";
        GroupTreeObjectLast gtoFound = this.m_polRoot.findElement(origGTO.getName(), origGTO.getType());
        if (gtoFound != null) {
            xmlPath = gtoFound.getPath();
            xmlPath = xmlPath.replaceFirst("/root/", "");
        }
        return xmlPath;
    }

    private void removeFromHashMaps(List<GroupTreeObject> origGTOList, boolean origElems) {
        for (GroupTreeObject origGTO : origGTOList) {
            this.removeFromHashMaps(origGTO, origElems);
        }
    }

    private void removeFromHashMaps(GroupTreeObject currGTO, boolean origElems) {
        String currName = currGTO.getName();
        String origName = null;
        GroupTreeObject origGTO = null;
        if (origElems) {
            origGTO = currGTO;
            origName = currName;
        } else {
            origGTO = this.getOriginalElement(currGTO);
            if (origGTO != null) {
                origName = origGTO.getName();
            }
        }
        if (this.m_policiesToRenameREVERSE.containsKey(currName)) {
            this.m_policiesToRenameREVERSE.remove(currName);
        } else {
            origName = currName;
        }
        if (this.m_policiesToRename.containsKey(origName)) {
            this.m_policiesToRename.remove(origName);
        }
        if (this.m_policiesWithNewVersions.containsKey(origName)) {
            this.m_policiesWithNewVersions.remove(origName);
        }
        if (this.m_policyUseSrvPath.containsKey(origName)) {
            this.m_policyUseSrvPath.remove(origName);
        }
        if (this.m_policyUseXMLPath.containsKey(origName)) {
            this.m_policyUseXMLPath.remove(origName);
            GroupTreeObjectLast srvGTOL = this.m_existingPolicyTree.findElement(origName, currGTO.getType());
            if (srvGTOL != null && currGTO instanceof GroupTreeObjectLast && this.m_pol4ImportRoot.findElement(currGTO.getName(), currGTO.getType()) != null) {
                this.m_importMPIView.moveElement(this.m_pol4ImportRoot, (GroupTreeObjectLast)currGTO, srvGTOL.getParentPath());
                this.m_policyUseSrvPath.put(origName, srvGTOL.getParentPath());
            }
        }
        if (this.m_skipImport.containsKey(origName)) {
            this.m_skipImport.remove(origName);
        }
    }

    private void renamePolicies(HashMap<String, GroupTreeObjectLast> elements) {
        Set<String> keys = elements.keySet();
        for (String nameNew : keys) {
            GroupTreeObject existingGTO;
            GroupTreeObjectLast currGtol = elements.get(nameNew);
            String currName = currGtol.getName();
            GroupTreeObject origGTO = this.getOriginalElement(currGtol);
            if (origGTO == null) continue;
            String origName = origGTO.getName();
            boolean hasRenamed = false;
            if (!currName.equals(origName)) {
                hasRenamed = true;
            }
            if (currName.equalsIgnoreCase(nameNew) || (existingGTO = this.m_pol4ImportRoot.searchPath(currGtol.getPath(), currGtol.getType())) == null) continue;
            existingGTO.setName(nameNew);
            if (this.m_policiesWithNewVersions.containsKey(currName)) {
                this.m_policiesWithNewVersions.remove(currName);
            }
            if (hasRenamed) {
                if (this.m_policiesToRename.containsKey(origName)) {
                    this.m_policiesToRename.remove(origName);
                }
                this.m_policiesToRenameREVERSE.remove(currName);
            }
            this.m_policiesToRename.put(origName, nameNew);
            this.m_policiesToRenameREVERSE.put(nameNew, origName);
        }
        this.refreshTree(this.m_tv_pol4Import, this.m_pol4ImportRoot, -1);
    }

    private void updatingVersions(Map<String, GroupTreeObjectLast> elements) {
        for (String currName : elements.keySet()) {
            if (!this.isPolicyEqualByContent(currName)) {
                GroupTreeObject origGTOL;
                GroupTreeObject currGtol = elements.get(currName);
                if (this.m_policiesWithNewVersions.containsKey(currName) || (origGTOL = this.getOriginalElement(currGtol)) == null) continue;
                String origName = origGTOL.getName();
                this.m_policiesWithNewVersions.put(origName, currName);
                continue;
            }
            this.m_policiesWithNewVersions.remove(currName);
        }
        this.refreshTree(this.m_tv_pol4Import, this.m_pol4ImportRoot, -1);
    }

    public boolean updatePath() {
        return this.m_policyUseXMLPath.size() > 0;
    }

    private void useXMLPath(Map<String, GroupTreeObjectLast> elements) {
        if (elements != null) {
            for (String name : elements.keySet()) {
                String origName;
                GroupTreeObjectLast gtolSelected = elements.get(name);
                GroupTreeObject origGTO = this.getOriginalElement(gtolSelected);
                if (origGTO == null || !this.m_policyExistsWithDifferentPath.containsKey(origName = origGTO.getName())) continue;
                if (this.m_policyUseSrvPath.containsKey(origName)) {
                    this.m_policyUseSrvPath.remove(origName);
                }
                if (this.m_policyUseXMLPath.containsKey(origName)) {
                    this.m_policyUseXMLPath.remove(origName);
                }
                this.m_policyUseXMLPath.put(origName, origGTO.getPath());
                this.m_importMPIView.moveElement(this.m_pol4ImportRoot, gtolSelected, origGTO.getParentPath());
            }
        } else {
            for (String origName : this.m_policyExistsWithDifferentPath.keySet()) {
                GroupTreeObjectLast origGTOL;
                GroupTreeObjectLast gtol = this.m_allPolicies.get(origName);
                if (gtol == null) continue;
                if (this.m_policyExistsWithDifferentPath.containsKey(origName)) {
                    this.m_policyExistsWithDifferentPath.remove(origName);
                }
                if (this.m_policyUseSrvPath.containsKey(origName)) {
                    this.m_policyUseSrvPath.remove(origName);
                }
                if (this.m_policyUseXMLPath.containsKey(origName)) {
                    this.m_policyUseXMLPath.remove(origName);
                }
                if ((origGTOL = this.m_polRoot.findElement(origName, gtol.getType())) == null) continue;
                String xmlPath = origGTOL.getPath();
                this.m_policyUseXMLPath.put(origName, xmlPath);
                this.m_importMPIView.moveElement(this.m_pol4ImportRoot, gtol, origGTOL.getParentPath());
            }
        }
        this.updatingVersions(elements);
    }

    public void useSRVPath(Map<String, GroupTreeObjectLast> elements) {
        if (elements != null) {
            for (String currName : elements.keySet()) {
                GroupTreeObjectLast srvGTOL;
                String origName;
                GroupTreeObjectLast gtolSelected = elements.get(currName);
                String type = gtolSelected.getType();
                GroupTreeObject origGTO = this.getOriginalElement(gtolSelected);
                if (origGTO == null || !this.m_policyExistsWithDifferentPath.containsKey(origName = origGTO.getName()) || (srvGTOL = this.m_existingPolicyTree.findElement(origName, type)) == null) continue;
                if (this.m_policyUseXMLPath.containsKey(origName)) {
                    this.m_policyUseXMLPath.remove(origName);
                }
                if (this.m_policyUseSrvPath.containsKey(origName)) {
                    this.m_policyUseSrvPath.remove(origName);
                }
                this.m_policyUseSrvPath.put(origName, srvGTOL.getPath());
                this.m_importMPIView.moveElement(this.m_pol4ImportRoot, gtolSelected, srvGTOL.getParentPath());
            }
        }
        this.updatingVersions(elements);
    }

    public void removePoliciesFromImport(Map<String, GroupTreeObjectLast> policies) {
        for (GroupTreeObjectLast gtol : policies.values()) {
            GroupTreeObject origGTOL;
            boolean hasRenamed = this.hasRenamed(gtol);
            GroupTreeObjectLast gtoExist = this.m_pol4ImportRoot.findElement(gtol.getName(), gtol.getType());
            if (gtoExist == null) continue;
            gtoExist.getParent().removeElement(gtoExist);
            this.removeFromHashMaps(gtol, false);
            if (hasRenamed && (gtoExist = this.m_pol4ImportRoot.findElement(gtol.getName(), gtol.getType())) != null) {
                gtoExist.getParent().removeElement(gtoExist);
            }
            if ((origGTOL = this.getOriginalElement(gtol)) == null) continue;
            this.m_skipImport.put(origGTOL.getName(), null);
        }
        this.refreshTree(this.m_tv_pol4Import, this.m_pol4ImportRoot, -1);
    }

    public void removePoliciesFromImport2(Map<String, GroupTreeObjectLast> policies) {
        for (GroupTreeObjectLast gtol : policies.values()) {
            GroupTreeObject origGTOL;
            GroupTreeObjectLast gtoExist = this.m_pol4ImportRoot.findElement(gtol.getName(), gtol.getType());
            if (gtoExist == null) continue;
            gtoExist.getParent().removeElement(gtoExist);
            this.removeFromHashMaps(gtol, false);
            gtoExist = this.m_pol4ImportRoot.findElement(gtol.getName(), gtol.getType());
            if (gtoExist != null) {
                gtoExist.getParent().removeElement(gtoExist);
            }
            if ((origGTOL = this.getOriginalElement(gtol)) == null) continue;
            this.m_skipImport.put(origGTOL.getName(), null);
        }
        this.refreshTree(this.m_tv_pol4Import, this.m_pol4ImportRoot, -1);
    }

    public void resetElements(Map<GroupTreeObject, String> elements) {
        HashMap<String, GroupTreeObjectLast> m_elems2reset = new HashMap<String, GroupTreeObjectLast>();
        HashMap<GroupTreeObject, String> m_elems2reset_reverse = new HashMap<GroupTreeObject, String>();
        for (GroupTreeObject gto : elements.keySet()) {
            if (gto instanceof GroupTreeObjectLast) continue;
            m_elems2reset_reverse.put(gto, gto.getName());
            ArrayList<GroupTreeObjectLast> map = new ArrayList<GroupTreeObjectLast>();
            map.addAll(GroupTreeObject.collectElements(gto));
            int i = 0;
            while (i < map.size()) {
                GroupTreeObjectLast gtol = (GroupTreeObjectLast)map.get(i);
                m_elems2reset.put(gtol.getName(), gtol);
                m_elems2reset_reverse.put(gtol, gtol.getName());
                ++i;
            }
            this.removePoliciesFromImport(m_elems2reset);
            this.addToImport(m_elems2reset_reverse);
        }
    }

    public void addToImport(Map<GroupTreeObject, String> elements) {
        for (GroupTreeObject origGTO : elements.keySet()) {
            if (origGTO instanceof GroupTreeObjectLast) continue;
            this.removeFromHashMaps(origGTO.getAllElements(), true);
            if (!this.m_pol4ImportRoot.hasElements().booleanValue()) {
                this.m_pol4ImportRoot.addElement(new GroupTreeObject(new TreeObject("Policies", BMUI.type_toplevel, null)));
            }
            this.m_importMPIView.addElement2Tree(this.m_pol4ImportRoot, origGTO, origGTO.getParentPath());
            List<GroupTreeObject> subElements = origGTO.getAllElements();
            for (GroupTreeObject gto : subElements) {
                GroupTreeObjectLast gtolFound;
                GroupTreeObjectLast gtol;
                if (!(gto instanceof GroupTreeObjectLast) || this.doesAnyFileExist(gtol = (GroupTreeObjectLast)gto) || (gtolFound = this.m_pol4ImportRoot.findElement(gtol.getName(), gtol.getType())) == null) continue;
                gtolFound.getParent().removeElement(gtolFound);
            }
            for (String name : this.m_policyExistsWithDifferentPath.keySet()) {
                String parentSrvPath = this.m_policyExistsWithDifferentPath.get(name);
                if (!origGTO.getPath().equals(parentSrvPath)) continue;
                GroupTreeObjectLast gtolOrig = this.m_polRoot.findElement(name, BMUI.type_mon);
                GroupTreeObjectLast gtolCurr = this.m_pol4ImportRoot.findElement(name, BMUI.type_mon);
                if (gtolOrig == null) {
                    gtolOrig = this.m_polRoot.findElement(name, BMUI.type_msg);
                    gtolCurr = this.m_pol4ImportRoot.findElement(name, BMUI.type_msg);
                }
                if (gtolOrig != null) {
                    this.removeFromHashMaps(gtolOrig, true);
                }
                if (gtolCurr == null) continue;
                gtolCurr.getParent().removeElement(gtolCurr);
            }
        }
        for (GroupTreeObject origGTO : elements.keySet()) {
            if (!(origGTO instanceof GroupTreeObjectLast)) continue;
            GroupTreeObjectLast origGTOL = (GroupTreeObjectLast)origGTO;
            this.removeFromHashMaps(origGTOL, true);
            if (!this.doesAnyFileExist(origGTOL)) continue;
            if (this.m_policyExistsWithDifferentPath.containsKey(origGTOL.getName())) {
                String srvPath = this.m_policyExistsWithDifferentPath.get(origGTOL.getName());
                this.m_importMPIView.addElement2Tree(this.m_pol4ImportRoot, origGTOL, srvPath);
                continue;
            }
            this.m_importMPIView.addElement2Tree(this.m_pol4ImportRoot, origGTOL, origGTOL.getParentPath());
        }
        this.refreshTree(this.m_tv_pol4Import, this.m_pol4ImportRoot, -1);
    }

    public void refreshTree(TreeViewer tv, GroupTreeObject root, int expLevel) {
        this.m_importMPIView.refreshTree(tv, root, expLevel);
        this.updateTreeFooter(tv);
        this.m_importMPIView.updateImportButtonStatus();
    }

    public Map<String, GroupTreeObjectLast> getFinalPolicies() {
        this.m_finalPolicies.clear();
        if (this.m_pol4ImportRoot == null) {
            return this.m_finalPolicies;
        }
        List<GroupTreeObjectLast> elements = this.m_pol4ImportRoot.getAllGTOLs();
        int i = 0;
        while (i < elements.size()) {
            GroupTreeObjectLast gtol = elements.get(i);
            if (this.doesImportFileExist(gtol)) {
                this.m_finalPolicies.put(gtol.getName(), gtol);
            }
            ++i;
        }
        return this.m_finalPolicies;
    }

    public Map<String, String> getPoliciesToRename() {
        return this.m_policiesToRename;
    }

    public Map<String, String> getPoliciesToRenameReverse() {
        return this.m_policiesToRenameREVERSE;
    }

    public Map<String, String> getPoliciesPathsToRename() {
        return this.m_policyUseXMLPath;
    }

    public Map<String, String> getPoliciesWithNewVersions() {
        return this.m_policiesWithNewVersions;
    }

    public void createXMLTree_CM() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        Menu menu = menuMgr.createContextMenu(this.m_tv_pol.getControl());
        this.m_tv_pol.getControl().setMenu(menu);
        ImportMPIView.m_instance.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.m_tv_pol);
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                try {
                    StructuredSelection ssel = (StructuredSelection)ImportMPIPolicySection.this.m_tv_pol.getSelection();
                    if (!ssel.isEmpty()) {
                        GroupTreeObject firstGTO = (GroupTreeObject)ssel.getFirstElement();
                        if (!firstGTO.getName().equals("Policies")) {
                            manager.add((IAction)new AddToImportAction(ImportMPIPolicySection.this.m_tv_pol, ImportMPIPolicySection.this.m_polRoot, ImportMPIPolicySection.this.m_section));
                            manager.add((IContributionItem)new Separator());
                        }
                        manager.add((IAction)new ExpandCollapseAction(ImportMPIPolicySection.this.m_tv_pol, "ExpandAll"));
                        manager.add((IAction)new ExpandCollapseAction(ImportMPIPolicySection.this.m_tv_pol, "CollapseAll"));
                        if (!firstGTO.getName().equals("Policies")) {
                            manager.add((IContributionItem)new Separator());
                            manager.add((IAction)new ExpandCollapseAction(ImportMPIPolicySection.this.m_tv_pol, "ExpandSubTree"));
                            manager.add((IAction)new ExpandCollapseAction(ImportMPIPolicySection.this.m_tv_pol, "CollagpseSubTree"));
                        }
                    } else {
                        manager.add((IAction)new ExpandCollapseAction(ImportMPIPolicySection.this.m_tv_pol, "ExpandAll"));
                        manager.add((IAction)new ExpandCollapseAction(ImportMPIPolicySection.this.m_tv_pol, "CollapseAll"));
                    }
                }
                catch (RuntimeException e) {
                    RTLogger.print(5, "ImportMPI: Error creating context menu of import tree", e);
                }
            }
        });
    }

    public void createFinalTree_CM() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        Menu menu = menuMgr.createContextMenu(this.m_tv_pol4Import.getControl());
        this.m_tv_pol4Import.getControl().setMenu(menu);
        ImportMPIView.m_instance.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.m_tv_pol4Import);
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                try {
                    StructuredSelection ssel = (StructuredSelection)ImportMPIPolicySection.this.m_tv_pol4Import.getSelection();
                    if (!ssel.isEmpty()) {
                        Object o = ssel.getFirstElement();
                        if (((GroupTreeObject)o).getType().equals(BMUI.type_toplevel)) {
                            manager.add((IAction)new ResetElementsAction(ImportMPIPolicySection.this.m_tv_pol4Import, ImportMPIPolicySection.this.m_pol4ImportRoot, ImportMPIPolicySection.this.m_section, ImportMPIView.RESET_TREE));
                        } else {
                            manager.add((IAction)new RenamePolicyAction(ImportMPIPolicySection.this.m_section.getShell(), ImportMPIPolicySection.this.m_tv_pol4Import, ImportMPIPolicySection.this.m_section));
                            manager.add((IAction)new IncreaseVersionAction(ImportMPIPolicySection.this.m_tv_pol4Import, ImportMPIPolicySection.this.m_pol4ImportRoot, ImportMPIPolicySection.this.m_section));
                            manager.add((IContributionItem)new Separator());
                            manager.add((IAction)new UpdatePathAction(ImportMPIPolicySection.this.m_tv_pol4Import, ImportMPIPolicySection.this.m_pol4ImportRoot, ImportMPIPolicySection.this.m_section, USE_SRV_PATH));
                            manager.add((IAction)new UpdatePathAction(ImportMPIPolicySection.this.m_tv_pol4Import, ImportMPIPolicySection.this.m_pol4ImportRoot, ImportMPIPolicySection.this.m_section, USE_XML_PATH));
                            manager.add((IContributionItem)new Separator());
                            manager.add((IAction)new ResetElementsAction(ImportMPIPolicySection.this.m_tv_pol4Import, ImportMPIPolicySection.this.m_pol4ImportRoot, ImportMPIPolicySection.this.m_section, ImportMPIView.RESET_TREE));
                            manager.add((IContributionItem)new Separator());
                            manager.add((IAction)new RemoveFromImportAction(ImportMPIPolicySection.this.m_tv_pol4Import, ImportMPIPolicySection.this.m_pol4ImportRoot, ImportMPIPolicySection.this.m_section));
                        }
                    } else {
                        manager.add((IAction)new ResetElementsAction(ImportMPIPolicySection.this.m_tv_pol4Import, ImportMPIPolicySection.this.m_pol4ImportRoot, ImportMPIPolicySection.this.m_section, ImportMPIView.RESET_TREE));
                    }
                    manager.add((IContributionItem)new Separator());
                    manager.add((IAction)new ExpandCollapseAction(ImportMPIPolicySection.this.m_tv_pol4Import, "ExpandAll"));
                    manager.add((IAction)new ExpandCollapseAction(ImportMPIPolicySection.this.m_tv_pol4Import, "CollapseAll"));
                    manager.add((IContributionItem)new Separator());
                    manager.add((IAction)new ExpandCollapseAction(ImportMPIPolicySection.this.m_tv_pol4Import, "ExpandSubTree"));
                    manager.add((IAction)new ExpandCollapseAction(ImportMPIPolicySection.this.m_tv_pol4Import, "CollagpseSubTree"));
                }
                catch (RuntimeException e) {
                    RTLogger.print(5, "ImportMPI: Error creating context menu of import tree", e);
                }
            }
        });
    }

    public void expansionStateChanged(ExpansionEvent e) {
    }

    public void expansionStateChanging(ExpansionEvent e) {
    }

    public void selectionChanged(SelectionChangedEvent event) {
        Object obj = event.getSource();
        if (obj instanceof TreeViewer) {
            TreeViewer tv = (TreeViewer)obj;
            String type = (String)tv.getData(ImportMPIView.TREE_VIEWER_TYPE);
            if (type.equals(ImportMPIView.POLICY)) {
                AddToImportAction action = new AddToImportAction(this.m_tv_pol, this.m_polRoot, this.m_section);
                this.m_gui.enableField(this.m_add_btn, action.isEnabled());
            } else if (type.equals(ImportMPIView.POLICY_4IMPORT)) {
                RenamePolicyAction action1 = new RenamePolicyAction(this.m_section.getShell(), this.m_tv_pol4Import, this.m_section);
                this.m_rename_btn.setText(action1.getText());
                this.m_gui.enableField(this.m_rename_btn, action1.isEnabled());
                IncreaseVersionAction action2 = new IncreaseVersionAction(this.m_tv_pol4Import, this.m_pol4ImportRoot, this.m_section);
                this.m_increaseVersion_btn.setText(action2.getText());
                this.m_gui.enableField(this.m_increaseVersion_btn, action2.isEnabled());
                UpdatePathAction action3 = new UpdatePathAction(this.m_tv_pol4Import, this.m_pol4ImportRoot, this.m_section, USE_SRV_PATH);
                this.m_useSrvPath_btn.setText(action3.getText());
                this.m_gui.enableField(this.m_useSrvPath_btn, action3.isEnabled());
                UpdatePathAction action4 = new UpdatePathAction(this.m_tv_pol4Import, this.m_pol4ImportRoot, this.m_section, USE_XML_PATH);
                this.m_useXMLPath_btn.setText(action4.getText());
                this.m_gui.enableField(this.m_useXMLPath_btn, action4.isEnabled());
                ResetElementsAction action6 = new ResetElementsAction(this.m_tv_pol4Import, this.m_pol4ImportRoot, this.m_section, ImportMPIView.RESET_TREE);
                this.m_resetTree_btn.setText(action6.getText());
                this.m_gui.enableField(this.m_resetTree_btn, action6.isEnabled());
                RemoveFromImportAction action7 = new RemoveFromImportAction(this.m_tv_pol4Import, this.m_pol4ImportRoot, this.m_section);
                this.m_gui.enableField(this.m_removeFromImport_btn, action7.isEnabled());
                this.m_gui.enableField(this.m_remove_btn, action7.isEnabled());
                ContentCompare action8 = new ContentCompare(this.m_section);
                this.m_gui.enableField(this.m_contentCompare_btn, action8.isEnabled());
            }
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        Object obj = e.getSource();
        if (obj instanceof Button) {
            Button btn = (Button)obj;
            String name = (String)btn.getData();
            if (name.equals(ADD_BTN)) {
                AddToImportAction action = new AddToImportAction(this.m_tv_pol, this.m_polRoot, this.m_section);
                action.run();
            } else if (name.equals(RENAME_BTN)) {
                RenamePolicyAction action = new RenamePolicyAction(this.m_section.getShell(), this.m_tv_pol4Import, this.m_section);
                action.run();
            } else if (name.equals(INCREASE_VERSION_BTN)) {
                IncreaseVersionAction action = new IncreaseVersionAction(this.m_tv_pol4Import, this.m_pol4ImportRoot, this.m_section);
                action.run();
            } else if (name.equals(USE_XML_PATH_BTN)) {
                UpdatePathAction action = new UpdatePathAction(this.m_tv_pol4Import, this.m_pol4ImportRoot, this.m_section, USE_XML_PATH);
                action.run();
            } else if (name.equals(USE_SRV_PATH_BTN)) {
                UpdatePathAction action = new UpdatePathAction(this.m_tv_pol4Import, this.m_pol4ImportRoot, this.m_section, USE_SRV_PATH);
                action.run();
            } else if (name.equals(RESET_TREE_BTN)) {
                ResetElementsAction action = new ResetElementsAction(this.m_tv_pol4Import, this.m_pol4ImportRoot, this.m_section, ImportMPIView.RESET_TREE);
                action.run();
            } else if (name.equals(REMOVE_FROM_IMPORT_BTN) || name.equals(REMOVE_BTN)) {
                RemoveFromImportAction action = new RemoveFromImportAction(this.m_tv_pol4Import, this.m_pol4ImportRoot, this.m_section);
                action.run();
            } else if (name.equals(CONTENT_COMPARE_BTN)) {
                ContentCompare action = new ContentCompare(this.m_section);
                action.run();
                this.m_contentCompare_btn.setEnabled(false);
            }
        }
    }

    public void postProcess(ServerClient sc) {
        if (sc instanceof ScGetPolicyTreeMD5) {
            ScGetPolicyTreeMD5 scpmd5 = (ScGetPolicyTreeMD5)sc;
            if (scpmd5.isSuccess()) {
                GroupTreeObject serverTree = scpmd5.getResultObject();
                List<GroupTreeObjectLast> gtols = this.m_pol4ImportRoot.getAllGTOLs();
                for (GroupTreeObjectLast gtol : gtols) {
                    GroupTreeObject gtolImport;
                    String md5Import = gtol.getAttribute(MD5);
                    String md5Server = "-";
                    List<GroupTreeObject> policies = serverTree.findElements(gtol.getName(), gtol.getType());
                    if (policies.size() <= 0 || (md5Server = (gtolImport = policies.get(0)).getAttribute(MD5)) == null || !md5Server.equals(md5Import)) continue;
                    this.m_policiesWithNewVersions.remove(gtol.getName());
                    this.m_equalByContent.put(gtol.getName(), md5Import);
                }
                UIJob uj = new UIJob(null){

                    @Override
                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        try {
                            ImportMPIPolicySection.this.refreshTree(ImportMPIPolicySection.this.m_tv_pol4Import, ImportMPIPolicySection.this.m_pol4ImportRoot, -1);
                        }
                        finally {
                            ImportMPIPolicySection.this.m_contentCompare_btn.setEnabled(true);
                        }
                        return Status.OK_STATUS;
                    }
                };
                Repository.getUIJobManager().schedule(uj);
            } else {
                String error = "";
                if (sc.getLastException() != null && (error = sc.getLastException().getMessage()) == null) {
                    error = sc.getResultObject() != null && sc.getResultObject() instanceof String ? "" + sc.getResultObject() : "";
                }
                new ShowMessageBox("Error", "Error gettting data from the server", 1);
            }
        }
    }

    public GroupTreeObject getPolRoot() {
        return this.m_polRoot;
    }

    public GroupTreeObject getPol4ImportRoot() {
        return this.m_pol4ImportRoot;
    }

    public boolean isPolicyEqualByContent(String policyName) {
        return this.m_equalByContent.containsKey(policyName);
    }

    public class AddToImportAction
    extends Action {
        private ImportMPIPolicySection m_section;
        private Map<GroupTreeObject, String> m_elements;

        public AddToImportAction(TreeViewer tv, GroupTreeObject root, ImportMPIPolicySection section) {
            super("addtoimportaction");
            this.m_section = null;
            this.m_elements = new HashMap<GroupTreeObject, String>();
            this.setId("addtoimportaction");
            this.setText("Add To Import");
            this.m_section = section;
            if (tv == null || this.m_section == null) {
                this.setEnabled(false);
                return;
            }
            StructuredSelection sel = (StructuredSelection)tv.getSelection();
            if (sel.size() > 0) {
                ArrayList<GroupTreeObject> map = new ArrayList<GroupTreeObject>();
                for (Object selected : sel) {
                    if (selected instanceof GroupTreeObjectLast) {
                        map.add((GroupTreeObjectLast)selected);
                        continue;
                    }
                    if (!(selected instanceof GroupTreeObject)) continue;
                    map.add((GroupTreeObject)selected);
                    map.addAll(((GroupTreeObject)selected).getAllGTOLs());
                }
                int i = 0;
                while (i < map.size()) {
                    this.m_elements.put((GroupTreeObject)map.get(i), null);
                    ++i;
                }
            }
            if (this.m_elements.size() == 0) {
                this.setEnabled(false);
            }
        }

        public void run() {
            if (!this.isEnabled()) {
                return;
            }
            if (this.m_section == null || this.m_elements.size() == 0) {
                return;
            }
            this.m_section.addToImport(this.m_elements);
            ImportMPIPolicySection.this.m_importMPIView.getAsnSection().refreshTree(ImportMPIView.ASN_4IMPORT);
        }
    }

    public class ContentCompare
    extends Action {
        private ImportMPIPolicySection m_section;

        public ContentCompare(ImportMPIPolicySection section) {
            super("comparecontentaction");
            this.m_section = null;
            this.setId("comparecontentaction");
            this.setText("Compare Content");
            this.m_section = section;
            ScValidateCmd sc = new ScValidateCmd(Repository.getInstance(), "GET_POLICYTREE_MD5");
            sc.run();
            if (!sc.isSuccess()) {
                this.setEnabled(false);
                this.setToolTipText("Server does ot support this feature");
            }
        }

        public void run() {
            if (!this.isEnabled()) {
                return;
            }
            ScGetPolicyTreeMD5 sc = new ScGetPolicyTreeMD5(Repository.getInstance());
            sc.addCmdPostProcess(this.m_section);
            sc.start();
        }
    }

    class ContentProviderPolImportTree
    extends ViewContentProvider {
        @Override
        public Object[] getElements(Object obj) {
            Object[] oList = this.getChildren(obj);
            return oList;
        }
    }

    public class IncreaseVersionAction
    extends Action {
        private ImportMPIPolicySection m_section;
        private Map<String, GroupTreeObjectLast> m_elements;

        public IncreaseVersionAction(TreeViewer tv, GroupTreeObject root, ImportMPIPolicySection section) {
            super("increaseversion");
            this.m_section = null;
            this.m_elements = new HashMap<String, GroupTreeObjectLast>();
            this.setText("Increase Version");
            this.setId("increaseversion");
            this.m_section = section;
            if (tv == null || this.m_section == null) {
                this.setEnabled(false);
                return;
            }
            StructuredSelection sel = (StructuredSelection)tv.getSelection();
            if (sel.size() > 0) {
                Iterator it = sel.iterator();
                ArrayList<GroupTreeObjectLast> map = new ArrayList<GroupTreeObjectLast>();
                while (it.hasNext()) {
                    Object selected = it.next();
                    if (!(selected instanceof GroupTreeObject)) continue;
                    GroupTreeObject gto = (GroupTreeObject)selected;
                    if (gto.isGroup()) {
                        map.addAll(gto.getAllGTOLs());
                        continue;
                    }
                    map.add((GroupTreeObjectLast)gto);
                }
                int i = 0;
                while (i < map.size()) {
                    List list;
                    GroupTreeObjectLast gtol = (GroupTreeObjectLast)map.get(i);
                    if (this.m_section.doesAnyFileExist(gtol) && this.m_section.hasInitialConflict(gtol) && !this.m_section.hasPathConflict(gtol) && ((list = this.m_section.getSolvedIcon(gtol, false)) == null || list.size() == 0)) {
                        this.m_elements.put(gtol.getName(), gtol);
                    }
                    ++i;
                }
            }
            if (this.m_elements.size() == 0) {
                this.setEnabled(false);
            }
        }

        public void run() {
            if (!this.isEnabled()) {
                return;
            }
            this.m_section.updatingVersions(this.m_elements);
        }
    }

    public class RemoveFromImportAction
    extends Action {
        private TreeViewer m_tv;
        private GroupTreeObject m_root;
        private ImportMPIPolicySection m_section;
        private Map<String, GroupTreeObjectLast> m_elements;
        private List<GroupTreeObject> m_remove;

        public RemoveFromImportAction(TreeViewer tv, GroupTreeObject root, ImportMPIPolicySection section) {
            super("skipimport");
            this.m_tv = null;
            this.m_root = null;
            this.m_section = null;
            this.m_elements = new HashMap<String, GroupTreeObjectLast>();
            this.m_remove = new LinkedList<GroupTreeObject>();
            this.setId("skipimport");
            this.setText("Remove");
            this.m_tv = tv;
            this.m_root = root;
            this.m_section = section;
            if (this.m_tv == null || this.m_root == null || this.m_section == null) {
                this.setEnabled(false);
                return;
            }
            StructuredSelection sel = (StructuredSelection)tv.getSelection();
            if (sel.size() > 0) {
                Iterator it = sel.iterator();
                LinkedList<GroupTreeObjectLast> map = new LinkedList<GroupTreeObjectLast>();
                while (it.hasNext()) {
                    Object selected = it.next();
                    if (selected instanceof GroupTreeObject) {
                        GroupTreeObject gto = (GroupTreeObject)selected;
                        if (gto.isGroup()) {
                            map.addAll(gto.getAllGTOLs());
                        } else {
                            map.add((GroupTreeObjectLast)gto);
                        }
                    }
                    if (!(selected instanceof GroupTreeObject)) continue;
                    this.m_remove.add((GroupTreeObject)selected);
                }
                int i = 0;
                while (i < map.size()) {
                    GroupTreeObjectLast gtol = (GroupTreeObjectLast)map.get(i);
                    this.m_elements.put(gtol.getName(), gtol);
                    ++i;
                }
            }
            if (this.m_remove.size() == 0 && this.m_elements.size() == 0) {
                this.setEnabled(false);
            }
        }

        public void run() {
            if (!this.isEnabled()) {
                return;
            }
            if (this.m_tv == null || this.m_root == null || this.m_section == null) {
                return;
            }
            if (this.m_elements.size() > 0) {
                this.m_section.removePoliciesFromImport(this.m_elements);
            }
            for (GroupTreeObject gto : this.m_remove) {
                try {
                    gto.getParent().removeElement(gto);
                }
                catch (Throwable throwable) {}
            }
            ImportMPIPolicySection.this.refreshTree(ImportMPIPolicySection.this.m_tv_pol4Import, ImportMPIPolicySection.this.m_pol4ImportRoot, -1);
            ImportMPIPolicySection.this.m_importMPIView.getAsnSection().refreshTree(ImportMPIView.ASN_4IMPORT);
        }
    }

    class RenamePolicyAction
    extends Action {
        private Shell m_parentShell;
        private ImportMPIPolicySection m_section;
        private PolicyRenamingDialog m_dialog;
        private HashMap<String, GroupTreeObjectLast> m_elements;

        public RenamePolicyAction(Shell parentShell, TreeViewer tv, ImportMPIPolicySection section) {
            super("renamingpolicies");
            this.m_parentShell = null;
            this.m_section = null;
            this.m_dialog = null;
            this.m_elements = new HashMap();
            this.setId("renamingpolicies");
            this.m_parentShell = parentShell;
            this.m_section = section;
            this.setText("Rename");
            if (Repository.getInstance().getRights(1001) < 3) {
                this.setEnabled(false);
            } else {
                GroupTreeObject cfr_ignored_0 = (GroupTreeObject)tv.getInput();
                ArrayList<GroupTreeObjectLast> elements = new ArrayList<GroupTreeObjectLast>();
                StructuredSelection sel = (StructuredSelection)tv.getSelection();
                if (sel.size() > 0) {
                    for (Object selected : sel) {
                        if (!(selected instanceof GroupTreeObject)) continue;
                        GroupTreeObject gto = (GroupTreeObject)selected;
                        if (gto.isGroup()) {
                            elements.addAll(gto.getAllGTOLs());
                            continue;
                        }
                        elements.add((GroupTreeObjectLast)gto);
                    }
                    int i = 0;
                    while (i < elements.size()) {
                        GroupTreeObjectLast gtol = (GroupTreeObjectLast)elements.get(i);
                        if (this.m_section.doesAnyFileExist(gtol)) {
                            this.m_elements.put(gtol.getName(), gtol);
                        }
                        ++i;
                    }
                }
                if (this.m_elements.size() == 0) {
                    this.setEnabled(false);
                }
            }
        }

        public void run() {
            if (!this.isEnabled()) {
                return;
            }
            if (PolicyRenamingAction.checkUnsavedPolicies(this.m_parentShell, this.m_elements)) {
                this.m_dialog = new PolicyRenamingDialog(this.m_parentShell, this.m_elements, PolicyRenamingDialog.IMPORT_POLICY);
                this.m_dialog.setBlockOnOpen(true);
                this.m_dialog.open();
                if (this.m_dialog.getReturnCode() == 0) {
                    HashMap<String, GroupTreeObjectLast> elements = this.m_dialog.getElements();
                    if (this.doRename()) {
                        this.m_section.renamePolicies(elements);
                        ImportMPIPolicySection.this.m_importMPIView.getAsnSection().renamePolicies(ImportMPIPolicySection.this.m_policiesToRename, ImportMPIPolicySection.this.m_pol4ImportRoot);
                    }
                }
            }
        }

        public boolean doRename() {
            boolean b = false;
            if (this.m_dialog.m_prefix.length() > 0 || this.m_dialog.m_suffix.length() > 0) {
                b = true;
            } else if (this.m_dialog.m_find.length() > 0 || this.m_dialog.m_replace.length() > 0) {
                b = true;
            }
            return b;
        }
    }

    public class ResetElementsAction
    extends Action {
        private ImportMPIPolicySection m_section;
        private String m_type;
        private Map<GroupTreeObject, String> m_elements;

        public ResetElementsAction(TreeViewer tv, GroupTreeObject root, ImportMPIPolicySection section, String type) {
            super("clearelements");
            this.m_section = null;
            this.m_type = null;
            this.m_elements = new HashMap<GroupTreeObject, String>();
            this.setId("clearelements");
            this.m_section = section;
            this.m_type = type;
            if (tv == null || root == null || this.m_section == null) {
                this.setEnabled(false);
                if (this.m_type.equals(ImportMPIView.RESET_TREE)) {
                    this.setText("Reset Tree");
                } else if (this.m_type.equals(RESET_POLICY)) {
                    this.setText("Reset Element");
                }
                return;
            }
            if (this.m_type.equals(ImportMPIView.RESET_TREE)) {
                this.setText("Reset Tree");
            } else if (this.m_type.equals(RESET_POLICY)) {
                this.setText("Reset Element");
                StructuredSelection sel = (StructuredSelection)tv.getSelection();
                if (sel.size() > 0) {
                    Iterator it = sel.iterator();
                    ArrayList<GroupTreeObjectLast> map = new ArrayList<GroupTreeObjectLast>();
                    while (it.hasNext()) {
                        Object selected = it.next();
                        if (!(selected instanceof GroupTreeObject)) continue;
                        GroupTreeObject gto = (GroupTreeObject)selected;
                        if (gto.isGroup()) {
                            map.addAll(gto.getAllGTOLs());
                            continue;
                        }
                        map.add((GroupTreeObjectLast)gto);
                    }
                    int i = 0;
                    while (i < map.size()) {
                        List list;
                        GroupTreeObjectLast gtol = (GroupTreeObjectLast)map.get(i);
                        if (this.m_section.doesAnyFileExist(gtol) && (list = this.m_section.getSolvedIcon(gtol, false)) != null && list.size() > 0) {
                            this.m_elements.put(gtol, gtol.getName());
                        }
                        ++i;
                    }
                }
                if (this.m_elements.size() == 0) {
                    this.setEnabled(false);
                } else if (this.m_elements.size() > 1) {
                    this.setText("Reset Elements");
                }
            } else {
                this.setText("Reset");
                this.setEnabled(false);
                return;
            }
        }

        public void run() {
            if (!this.isEnabled()) {
                return;
            }
            if (this.m_type.equals(ImportMPIView.RESET_TREE)) {
                ImportMPIPolicySection.this.m_importMPIView.updatePolSection();
            } else if (this.m_type.equals(RESET_POLICY)) {
                this.m_section.resetElements(this.m_elements);
            }
            ImportMPIPolicySection.this.m_importMPIView.getAsnSection().refreshTree(ImportMPIView.ASN_4IMPORT);
        }
    }

    class StyledLabelProviderPolImportTree
    extends StyledCellLabelProvider {
        private ImportMPIPolicySection m_polSection = null;
        private TreeViewer m_tv = null;

        public StyledLabelProviderPolImportTree(ImportMPIPolicySection section, TreeViewer tv) {
            this.m_polSection = section;
            this.m_tv = tv;
        }

        public void update(ViewerCell cell) {
            Object element = cell.getElement();
            if (element instanceof GroupTreeObjectLast) {
                GroupTreeObjectLast gtol = (GroupTreeObjectLast)element;
                cell.setText(gtol.getName());
                Image image = BMUI.IMAGE_MAP.get(gtol.getIcon());
                if (image == null) {
                    image = BMUI.IMAGE_MAP.get(gtol.getType());
                }
                cell.setImage(image);
                if (ImportMPIPolicySection.this.m_section.hasPathConflict(gtol)) {
                    if (ImportMPIPolicySection.this.m_section.hasPathConflictSolved(gtol)) {
                        if (ImportMPIPolicySection.this.hasRenamed(gtol)) {
                            cell.setForeground(BMUI.color_green);
                        } else if (ImportMPIPolicySection.this.isPolicyEqualByContent(gtol.getName())) {
                            cell.setForeground(BMUI.color_darkGrey2);
                        } else {
                            cell.setForeground(BMUI.color_green);
                        }
                    } else {
                        cell.setForeground(BMUI.color_critical);
                    }
                } else {
                    List list = ImportMPIPolicySection.this.m_section.getSolvedIcon(gtol, false);
                    if (list != null && list.size() > 0) {
                        cell.setForeground(BMUI.color_green);
                    } else if (this.m_polSection.hasConflict(gtol)) {
                        cell.setForeground(BMUI.color_critical);
                    } else if (ImportMPIPolicySection.this.isPolicyEqualByContent(gtol.getName())) {
                        cell.setForeground(BMUI.color_darkGrey2);
                    } else {
                        cell.setForeground(BMUI.color_green);
                    }
                }
            } else if (element instanceof GroupTreeObject) {
                GroupTreeObject gto = (GroupTreeObject)element;
                StyledString styledString = new StyledString();
                styledString.append(gto.getName());
                int count = this.m_polSection.getNumberOfConflicts(this.m_tv, gto);
                StyledString.Styler styler = StyledString.createColorRegistryStyler((String)ImportMPIView.COLOR_GREY, null);
                String decoration = MessageFormat.format("  [{0}]", "" + count);
                styledString.append(decoration, styler);
                cell.setText(styledString.toString());
                cell.setStyleRanges(styledString.getStyleRanges());
                cell.setImage(BMUI.IMAGE_FOLDER_DEFAULT);
                if (!ImportMPIPolicySection.this.doesElementExistOnServer(gto)) {
                    cell.setForeground(BMUI.color_green);
                }
            }
            super.update(cell);
        }

        public String getToolTipText(Object element) {
            StringBuffer sbTT = new StringBuffer();
            sbTT.append("<html>").append("<head><style type=\"text/css\">").append("body { margin-left:5px; margin-right:5px; margin-top:5px; margin-bottom:5px }").append("</style></head>").append("<body bgcolor='#FFFFE1'>");
            if (element instanceof GroupTreeObjectLast) {
                GroupTreeObjectLast gtol = (GroupTreeObjectLast)element;
                String initConflict_msg = this.m_polSection.getInitConflictToolTipMsg(gtol);
                String solvedConflict_msg = this.m_polSection.getSolvedToolTipMsg(gtol);
                sbTT.append("<table border='0' cellspacing='0' cellpadding='0'>");
                if (initConflict_msg != null) {
                    sbTT.append("<tr valign='top'><td nowrap colspan='2'><font face='Arial' size='1' color='#000000'>").append("<p style='margin-bottom:5px'>").append(gtol.getName()).append("</p>").append("</font></td></tr>").append("<tr valign='top'><td nowrap>").append("<font face='Arial' size='1' color='#000000'>Conflict:&nbsp;&nbsp;</font>").append("<td nowrap><font face='Arial' size='1' color='#000000'><b>").append(initConflict_msg);
                    sbTT.append("</b></font></td></tr>");
                    sbTT.append("<tr valign='top'><td nowrap><font face='Arial' size='1' color='#000000'>").append("Solution:&nbsp;&nbsp;").append("</font></td>");
                    if (solvedConflict_msg != null) {
                        sbTT.append("<td nowrap><font face='Arial' size='1' color='#000000'><b>").append(solvedConflict_msg).append("</b></font></td></tr>");
                    } else {
                        sbTT.append("<td nowrap><font face='Arial' size='1' color='#000000'><b>").append("").append("</b></font></td></tr>");
                    }
                } else {
                    sbTT.append("<tr valign='top' rowspan=2><td nowrap><font face='Arial' size='1' color='#000000'>").append("<p style='margin-bottom:5px'>").append(gtol.getName()).append("</p>").append("<b>").append("No Conflict, ").append(solvedConflict_msg).append("</b>").append("</font></td></tr>");
                }
                sbTT.append("</table>");
            } else if (element instanceof GroupTreeObject) {
                GroupTreeObject gto = (GroupTreeObject)element;
                sbTT.append("<font face='Arial' size='1' color='#000000'>").append("<p style='margin-bottom:5px'>").append(gto.getName()).append("</p>").append(this.m_polSection.getNumberOfConflicts(this.m_tv, gto)).append(" Conflicts").append("</font>");
            }
            sbTT.append("</body></html>");
            return sbTT.toString();
        }

        public Point getToolTipShift(Object object) {
            return new Point(3, 3);
        }

        public int getToolTipDisplayDelayTime(Object object) {
            return 50;
        }

        public int getToolTipTimeDisplayed(Object object) {
            return 9999999;
        }
    }

    class StyledLabelProviderPolTree
    extends StyledCellLabelProvider {
        private ImportMPIPolicySection m_polSection = null;
        private TreeViewer m_tv = null;

        public StyledLabelProviderPolTree(ImportMPIPolicySection section, TreeViewer tv) {
            this.m_polSection = section;
            this.m_tv = tv;
        }

        public void update(ViewerCell cell) {
            Object element = cell.getElement();
            if (element instanceof GroupTreeObjectLast) {
                GroupTreeObjectLast gtol = (GroupTreeObjectLast)element;
                cell.setText(gtol.getName());
                Image image = BMUI.IMAGE_MAP.get(gtol.getIcon());
                if (image == null) {
                    image = BMUI.IMAGE_MAP.get(gtol.getType());
                }
                cell.setImage(image);
                if (!this.m_polSection.doesImportFileExist(gtol)) {
                    cell.setForeground(BMUI.color_critical);
                }
            } else if (element instanceof GroupTreeObject) {
                GroupTreeObject gto = (GroupTreeObject)element;
                StyledString styledString = new StyledString();
                styledString.append(gto.getName());
                int count = this.m_polSection.getNumberOfConflicts(this.m_tv, gto);
                StyledString.Styler styler = StyledString.createColorRegistryStyler((String)ImportMPIView.COLOR_GREY, null);
                String decoration = MessageFormat.format("  [{0}]", "" + count);
                styledString.append(decoration, styler);
                cell.setText(styledString.toString());
                cell.setStyleRanges(styledString.getStyleRanges());
                cell.setImage(BMUI.IMAGE_FOLDER_DEFAULT);
            }
            super.update(cell);
        }

        public String getToolTipText(Object element) {
            StringBuffer sbTT = new StringBuffer();
            sbTT.append("<html>").append("<head><style type=\"text/css\">").append("body { margin-left:5px; margin-right:5px; margin-top:5px; margin-bottom:5px }").append("</style></head>").append("<body bgcolor='#FFFFE1'>");
            if (element instanceof GroupTreeObjectLast) {
                GroupTreeObjectLast gtol = (GroupTreeObjectLast)element;
                if (this.m_polSection.doesImportFileExist(gtol) || this.m_polSection.doesAnyFileExist(gtol)) {
                    sbTT.append("<font face='Arial' size='1' color='#000000'>").append(gtol.getName()).append("</font");
                } else {
                    sbTT.append("<table border='0' cellspacing='0' cellpadding='0'>").append("<tr valign='top'><td nowrap colspan='2'>").append("<font face='Arial' size='1' color='#000000'>").append("<p style='margin-bottom:5px'>").append(gtol.getName()).append("</p>").append("</font></td></tr>").append("<tr valign='top'><td nowrap><font face='Arial' size='1' color='#000000'>").append("Conflict:&nbsp;&nbsp;").append("</font></td>").append("<td nowrap ><font face='Arial' size='1' color='#000000'><b>").append("Import and Server Files are missing!").append("</b></font></td></tr>").append("</table>");
                }
            } else if (element instanceof GroupTreeObject) {
                GroupTreeObject gto = (GroupTreeObject)element;
                sbTT.append("<font face='Arial' size='1' color='#000000'>").append("<p style='margin-bottom:5px'>").append(gto.getName()).append("</p>").append(this.m_polSection.getNumberOfConflicts(this.m_tv, gto)).append(" Conflicts").append("</font>");
            }
            sbTT.append("</body></html>");
            return sbTT.toString();
        }

        public Point getToolTipShift(Object object) {
            return new Point(3, 3);
        }

        public int getToolTipDisplayDelayTime(Object object) {
            return 50;
        }

        public int getToolTipTimeDisplayed(Object object) {
            return 9999999;
        }
    }

    public class UpdatePathAction
    extends Action {
        private TreeViewer m_tv;
        private GroupTreeObject m_root;
        private ImportMPIPolicySection m_section;
        private String m_type;
        private Map<String, GroupTreeObjectLast> m_elements;

        public UpdatePathAction(TreeViewer tv, GroupTreeObject root, ImportMPIPolicySection section, String type) {
            super("updatepathaction");
            this.m_tv = null;
            this.m_root = null;
            this.m_section = null;
            this.m_type = null;
            this.m_elements = new HashMap<String, GroupTreeObjectLast>();
            this.setId("updatepathaction");
            this.m_tv = tv;
            this.m_root = root;
            this.m_section = section;
            this.m_type = type;
            String title = "Use Server Path";
            if (USE_XML_PATH.equals(this.m_type)) {
                title = "Use XML Path";
            }
            this.setText(title);
            if (this.m_tv == null || this.m_root == null || this.m_section == null || this.m_type == null) {
                this.setEnabled(false);
                return;
            }
            StructuredSelection sel = (StructuredSelection)tv.getSelection();
            if (sel.size() > 0) {
                Iterator it = sel.iterator();
                ArrayList<GroupTreeObjectLast> map = new ArrayList<GroupTreeObjectLast>();
                while (it.hasNext()) {
                    Object selected = it.next();
                    if (!(selected instanceof GroupTreeObject)) continue;
                    GroupTreeObject gto = (GroupTreeObject)selected;
                    if (gto.isGroup()) {
                        map.addAll(gto.getAllGTOLs());
                        continue;
                    }
                    map.add((GroupTreeObjectLast)gto);
                }
                int i = 0;
                while (i < map.size()) {
                    GroupTreeObjectLast gtol = (GroupTreeObjectLast)map.get(i);
                    if (!this.m_section.hasPathConflict(gtol) || this.m_section.hasPathConflictSolved(gtol)) {
                        this.setEnabled(false);
                        return;
                    }
                    this.m_elements.put(gtol.getName(), gtol);
                    ++i;
                }
            }
            if (this.m_elements.size() == 0) {
                this.setEnabled(false);
            }
        }

        public void run() {
            if (!this.isEnabled()) {
                return;
            }
            if (this.m_tv == null || this.m_root == null || this.m_section == null) {
                return;
            }
            if (USE_XML_PATH.equals(this.m_type)) {
                this.m_section.useXMLPath(this.m_elements);
            } else if (USE_SRV_PATH.equals(this.m_type)) {
                this.m_section.useSRVPath(this.m_elements);
            }
            ImportMPIPolicySection.this.refreshTree(this.m_tv, this.m_root, -1);
        }
    }
}

