/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.GActionsRepository;
import com.blixx.boom.engine.GuiClient;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.engine.ServerClient;
import com.blixx.boom.engine.ServerClientBatch;
import com.blixx.boom.gui.dialogs.ImportMPIErrorDialog;
import com.blixx.boom.gui.dialogs.ProgressDialog;
import com.blixx.boom.gui.dialogs.ShowMessageBox;
import com.blixx.boom.gui.dialogs.ShowMessageDialog;
import com.blixx.boom.gui.policies.PolicyManager;
import com.blixx.boom.gui.utils.GUIDisplayElements;
import com.blixx.boom.gui.utils.XMLTree;
import com.blixx.boom.gui.views.BinariesListView;
import com.blixx.boom.gui.views.ImportMPIActionSection;
import com.blixx.boom.gui.views.ImportMPIAsnSection;
import com.blixx.boom.gui.views.ImportMPIBinarySection;
import com.blixx.boom.gui.views.ImportMPINodeGroupsSection;
import com.blixx.boom.gui.views.ImportMPIPolicySection;
import com.blixx.boom.gui.views.actions.UpdateServer;
import com.blixx.boom.omu.PolicyConvereter;
import com.blixx.ctrl.sc.in.ScAddNodeGroup;
import com.blixx.log.RTLogger;
import com.blixx.shared.AbstractPolicy;
import com.blixx.shared.Action;
import com.blixx.shared.BM;
import com.blixx.shared.Condition;
import com.blixx.shared.Conditions;
import com.blixx.shared.IODataStream;
import com.blixx.shared.MsgCondition;
import com.blixx.shared.MsgConditions;
import com.blixx.shared.MsgPolicy;
import com.blixx.shared.Policy;
import com.blixx.shared.PolicyFactory;
import com.blixx.shared.sc.CMDS;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.GroupTreeObjectLast;
import com.blixx.shared.utils.TreeObject;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.part.ViewPart;

public class ImportMPIView
extends ViewPart
implements DisposeListener,
SelectionListener,
ModifyListener,
IExpansionListener {
    public static final String ID = "com.blixx.boom.gui.views.importmpiview";
    public static ImportMPIView m_instance = null;
    private static String m_lastDirSelected = null;
    private String[] m_importOthersFileNames = null;
    private PolicyManager m_policyManager = null;
    private GroupTreeObject m_existingPolicyTree = null;
    private File m_polGrpFile = null;
    private GUIDisplayElements m_gui = null;
    private Composite m_parent = null;
    private Composite m_compInView = null;
    private ScrolledComposite m_sc = null;
    private Composite m_mainComp = null;
    private ImportMPIPolicySection m_polSection = null;
    private ImportMPIAsnSection m_asnSection = null;
    private ImportMPIActionSection m_actSection = null;
    private ImportMPINodeGroupsSection m_nodSection = null;
    private ImportMPIBinarySection m_binSection = null;
    private Group m_importTypeGrp = null;
    private Composite m_importComp = null;
    private CCombo m_importTypes_cbo = null;
    private Text m_importDirectory_field = null;
    private Button m_loadDir_btn = null;
    private Button m_reloadDir_btn = null;
    private Button m_import_btn = null;
    private ProgressDialog pd = null;
    public static GridData m_sectionTree_gd = new GridData(4, 4, true, true);
    private static String IMPORT_TYPES_CBO;
    private static String IMPORT_DIR_FIELD;
    private static String LOAD_DIR_BTN;
    private static String RELOAD_DIR_BTN;
    private static String IMPORT_BTN;
    public static String TREE_VIEWER_TYPE;
    public static String POLICY;
    public static String POLICY_4IMPORT;
    public static String ASN;
    public static String ASN_4IMPORT;
    public static String BIN;
    public static String BIN_4IMPORT;
    public static String ACT;
    public static String ACT_4IMPORT;
    public static String NOD;
    public static String NOD_4IMPORT;
    public static String PREFIX;
    public static String SUFFIX;
    public static String RENAME;
    public static String RESET_TREE;
    public String m_policiesDir = null;
    public String m_policyGroupsFile = null;
    public String m_assignmentGroupsFile = null;
    public String m_nodeGroupsFile = null;
    public String m_actionsDir = null;
    public String m_packagesDir = null;
    public String m_nodegroupsDir = null;
    public String m_nodeGroupsFile_tmp = null;
    private GroupTreeObject m_polRoot = null;
    List<GroupTreeObjectLast> m_policies = null;
    public Map<String, String> m_policiesToRename = new HashMap<String, String>();
    public Map<String, String> m_policiesPathesToRename = new HashMap<String, String>();
    public static String IMPORT_MPI;
    public static String IMPORT_OTHER;
    private static String[] m_importTypes;
    public static String MON;
    public static String MSG;
    public static String MATCH_TRUE;
    public static String MATCH_FALSE;
    private static Map<String, Image> m_imageList;
    public static String COLOR_GREY;
    public static String COLOR_RED;

    static {
        ImportMPIView.m_sectionTree_gd.heightHint = 200;
        ImportMPIView.m_sectionTree_gd.widthHint = 150;
        IMPORT_TYPES_CBO = "IMPORT_TYPE_CBO";
        IMPORT_DIR_FIELD = "IMPORT_DIR_FIELD";
        LOAD_DIR_BTN = "LOAD_DIR_BTN";
        RELOAD_DIR_BTN = "RELOAD_DIR_BTN";
        IMPORT_BTN = "IMPORT_BTN";
        TREE_VIEWER_TYPE = "TREE_VIEWER_TYPE";
        POLICY = "POLICY";
        POLICY_4IMPORT = "POLICY_4IMPORT";
        ASN = "ASN";
        ASN_4IMPORT = "ASN_4IMPORT";
        BIN = "BIN";
        BIN_4IMPORT = "BIN_4IMPORT";
        ACT = "ACT";
        ACT_4IMPORT = "ACT_4IMPORT";
        NOD = "NOD";
        NOD_4IMPORT = "NOD_4IMPORT";
        PREFIX = "PREFIX";
        SUFFIX = "SUFFIX";
        RENAME = "RENAME";
        RESET_TREE = "RESET_TREE";
        IMPORT_MPI = "Import MPI";
        IMPORT_OTHER = "Import Other";
        m_importTypes = new String[2];
        ImportMPIView.m_importTypes[0] = IMPORT_MPI;
        ImportMPIView.m_importTypes[1] = IMPORT_OTHER;
        MON = "mon";
        MSG = "msg";
        MATCH_TRUE = "match_true";
        MATCH_FALSE = "match_false";
        m_imageList = new HashMap<String, Image>();
        try {
            m_imageList.put(MATCH_TRUE, BMUI.IMAGE_ACCEPT_GREEN);
            m_imageList.put(MATCH_FALSE, BMUI.IMAGE_CANCEL_ROUND);
            m_imageList.put(MON, BMUI.IMAGE_MON);
            m_imageList.put(MSG, BMUI.IMAGE_MSG);
        }
        catch (RuntimeException e) {
            RTLogger.print(5, "Error loading image", e);
        }
        COLOR_GREY = "COLOR_GREY";
        COLOR_RED = "COLOR_RED";
        JFaceResources.getColorRegistry().put(COLOR_GREY, BMUI.color_darkGrey2.getRGB());
        JFaceResources.getColorRegistry().put(COLOR_RED, BMUI.color_major.getRGB());
    }

    public ImportMPIView() {
        m_instance = this;
        this.setTitleImage(BMUI.IMAGE_IMPORT);
        this.m_policyManager = PolicyManager.getInstance();
        this.m_existingPolicyTree = this.m_policyManager.getPolicyTree();
        this.m_gui = new GUIDisplayElements();
    }

    public static ImportMPIView getInstance() {
        return m_instance;
    }

    public void createPartControl(Composite parent) {
        this.m_parent = parent;
        this.m_parent.setLayout((Layout)new GridLayout(1, false));
        this.m_compInView = new Composite(parent, 0);
        GridLayout gl = new GridLayout(1, false);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        this.m_compInView.setLayout((Layout)gl);
        this.m_compInView.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createGeneralSection(this.m_compInView);
        this.m_sc = new ScrolledComposite(this.m_compInView, 768);
        this.m_sc.setAlwaysShowScrollBars(false);
        this.m_sc.setExpandHorizontal(true);
        this.m_sc.setExpandVertical(true);
        this.m_sc.setLayout((Layout)new GridLayout());
        this.m_sc.setLayoutData((Object)new GridData(4, 4, true, true));
        this.m_sc.addListener(37, new Listener(){

            public void handleEvent(Event event) {
                ScrolledComposite sc = (ScrolledComposite)event.widget;
                sc.getVerticalBar().setIncrement(event.count * 4);
            }
        });
        this.m_mainComp = new Composite((Composite)this.m_sc, 0);
        gl = new GridLayout(1, false);
        gl.marginBottom = 10;
        gl.marginWidth = 10;
        this.m_mainComp.setLayout((Layout)gl);
        this.m_mainComp.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createPolicySection(this.m_mainComp);
        this.createAssignmentSection(this.m_mainComp);
        this.createBinarySection(this.m_mainComp);
        this.createActionSection(this.m_mainComp);
        this.createNodeGroupSection(this.m_mainComp);
        if (!this.isUserPermitted()) {
            this.m_gui.enableField(this.m_importTypes_cbo, false);
            this.m_gui.enableField(this.m_importDirectory_field, false);
            this.m_gui.enableField(this.m_loadDir_btn, false);
            this.m_gui.enableField(this.m_reloadDir_btn, false);
        }
        this.m_sc.setContent((Control)this.m_mainComp);
        this.onSectionChangeSize();
        this.m_import_btn = this.m_gui.addButton(this.m_parent, IMPORT_BTN, " Start Import ", false, this);
        this.m_import_btn.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
    }

    public boolean isUserPermitted() {
        return this.isPolImportAllowed() || this.isBinImportAllowed() || this.isActImportAllowed() || this.isNodImportAllowed();
    }

    private boolean isPolImportAllowed() {
        return Repository.getInstance().getRights(1001) > 2;
    }

    private boolean isBinImportAllowed() {
        return Repository.getInstance().getRights(1006) > 2;
    }

    private boolean isAsnImportAllowed() {
        return Repository.getInstance().getRights(1001) > 2 && Repository.getInstance().getRights(1006) > 2 && Repository.getInstance().getRights(1008) > 2;
    }

    private boolean isActImportAllowed() {
        return Repository.getInstance().getRights(1007) > 2;
    }

    private boolean isNodImportAllowed() {
        return Repository.getInstance().getRights(1002) > 2;
    }

    public void createGeneralSection(Composite parent) {
        Composite generalComp = new Composite(parent, 0);
        GridLayout gl = new GridLayout(1, false);
        gl.verticalSpacing = 10;
        generalComp.setLayout((Layout)gl);
        generalComp.setLayoutData((Object)new GridData(4, 128, false, false));
        this.m_importTypeGrp = new Group(generalComp, 0);
        this.m_importTypeGrp.setText("Import Type");
        this.m_importTypeGrp.setLayout((Layout)new GridLayout(2, false));
        this.m_importTypeGrp.setLayoutData((Object)new GridData(4, 4, true, false));
        this.m_importTypes_cbo = this.m_gui.addDropDown((Composite)this.m_importTypeGrp, IMPORT_TYPES_CBO, "Type: ", m_importTypes, m_importTypes[0], null, 1, 1, 1, 5, null);
        ((GridData)this.m_importTypes_cbo.getLayoutData()).horizontalAlignment = 1;
        ((GridData)this.m_importTypes_cbo.getLayoutData()).grabExcessHorizontalSpace = false;
        this.m_importComp = new Composite((Composite)this.m_importTypeGrp, 0);
        gl = new GridLayout(3, false);
        gl.marginWidth = 1;
        this.m_importComp.setLayout((Layout)gl);
        this.m_importComp.setLayoutData((Object)new GridData(4, 128, true, false, 2, 1));
        this.createImportComposite(IMPORT_MPI, true);
        Composite btnComp = new Composite(generalComp, 0);
        gl = new GridLayout(1, false);
        gl.marginWidth = 0;
        btnComp.setLayout((Layout)gl);
        btnComp.setLayoutData((Object)new GridData(16384, 128, false, false, 2, 1));
        this.m_reloadDir_btn = this.m_gui.addButton(btnComp, RELOAD_DIR_BTN, " Reload Directory", false, this);
        this.m_reloadDir_btn.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
    }

    public void createImportComposite(String type, boolean init) {
        if (type.equals(IMPORT_MPI)) {
            this.clearComposite(this.m_importComp);
            this.m_importDirectory_field = this.m_gui.addInputFieldSingle(this.m_importComp, IMPORT_DIR_FIELD, "Import Directory: ", "", 1, 1, 1, 1, 60, this);
            this.m_loadDir_btn = this.m_gui.addButton(this.m_importComp, LOAD_DIR_BTN, " Load Directory ", true, this);
        } else if (type.equals(IMPORT_OTHER)) {
            this.clearComposite(this.m_importComp);
            this.m_importDirectory_field = this.m_gui.addInputFieldSingle(this.m_importComp, IMPORT_DIR_FIELD, "Import Directory", "", 1, 1, 1, 1, 60, this);
            this.m_loadDir_btn = this.m_gui.addButton(this.m_importComp, LOAD_DIR_BTN, " Load Directory ", true, this);
        } else {
            return;
        }
        if (!init && m_lastDirSelected != null && m_lastDirSelected.length() > 0) {
            this.m_gui.enableField(this.m_loadDir_btn, true);
            this.m_loadDir_btn.setToolTipText(m_lastDirSelected);
        }
        this.m_importComp.layout(true);
        this.m_importComp.pack(true);
        this.m_importTypeGrp.layout(true);
        this.m_importTypeGrp.setLayoutData((Object)new GridData(4, 4, true, false));
    }

    public void createPolicySection(Composite parent) {
        this.m_polSection = new ImportMPIPolicySection(parent, m_instance);
        this.m_polSection.setFont(BMUI.font_arial8_bold);
        if (this.isPolImportAllowed()) {
            this.m_polSection.initSection();
            this.m_polSection.setToggleColor(BMUI.color_selected);
            this.m_polSection.setTitleBarForeground(BMUI.color_selected);
            this.m_polSection.addExpansionListener(this);
        } else {
            this.m_polSection.setExpanded(false);
            this.m_polSection.setEnabled(false);
        }
    }

    public void createAssignmentSection(Composite parent) {
        this.m_asnSection = new ImportMPIAsnSection(parent, m_instance);
        this.m_asnSection.setFont(BMUI.font_arial8_bold);
        if (this.isAsnImportAllowed()) {
            this.m_asnSection.initSection();
            this.m_asnSection.setToggleColor(BMUI.color_selected);
            this.m_asnSection.setTitleBarForeground(BMUI.color_selected);
            this.m_asnSection.addExpansionListener(this);
        } else {
            this.m_asnSection.setExpanded(false);
            this.m_asnSection.setEnabled(false);
        }
    }

    public void createBinarySection(Composite parent) {
        this.m_binSection = new ImportMPIBinarySection(parent, m_instance);
        this.m_binSection.setFont(BMUI.font_arial8_bold);
        if (this.isBinImportAllowed()) {
            this.m_binSection.initSection();
            this.m_binSection.setToggleColor(BMUI.color_selected);
            this.m_binSection.setTitleBarForeground(BMUI.color_selected);
            this.m_binSection.addExpansionListener(this);
        } else {
            this.m_binSection.setExpanded(false);
            this.m_binSection.setEnabled(false);
        }
    }

    public void createActionSection(Composite parent) {
        this.m_actSection = new ImportMPIActionSection(parent, m_instance);
        this.m_actSection.setFont(BMUI.font_arial8_bold);
        if (this.isActImportAllowed()) {
            this.m_actSection.initSection();
            this.m_actSection.setToggleColor(BMUI.color_selected);
            this.m_actSection.setTitleBarForeground(BMUI.color_selected);
            this.m_actSection.addExpansionListener(this);
        } else {
            this.m_actSection.setExpanded(false);
            this.m_actSection.setEnabled(false);
        }
    }

    public void createNodeGroupSection(Composite parent) {
        this.m_nodSection = new ImportMPINodeGroupsSection(parent, m_instance);
        this.m_nodSection.setFont(BMUI.font_arial8_bold);
        if (this.isNodImportAllowed()) {
            this.m_nodSection.initSection();
            this.m_nodSection.setToggleColor(BMUI.color_selected);
            this.m_nodSection.setTitleBarForeground(BMUI.color_selected);
            this.m_nodSection.addExpansionListener(this);
        } else {
            this.m_nodSection.setExpanded(false);
            this.m_nodSection.setEnabled(false);
        }
    }

    public void browseAndLoadDirectory(String importType, boolean load) {
        if (importType.equals(IMPORT_MPI)) {
            DirectoryDialog fd = new DirectoryDialog(Display.getCurrent().getActiveShell());
            if (m_lastDirSelected != null) {
                fd.setFilterPath(m_lastDirSelected);
            }
            fd.setText("   Select MPI's Directory");
            fd.setMessage("Select a directory");
            String dirName = fd.open();
            if (dirName != null && dirName.length() > 0) {
                m_lastDirSelected = dirName;
                this.m_importDirectory_field.setText(m_lastDirSelected);
                if (load) {
                    this.loadMPIDirectory(m_lastDirSelected);
                }
            }
        } else if (importType.equals(IMPORT_OTHER)) {
            DirectoryDialog fd = new DirectoryDialog(Display.getCurrent().getActiveShell());
            if (m_lastDirSelected != null) {
                fd.setFilterPath(m_lastDirSelected);
            }
            fd.setText("   Select OMU Export Directory");
            fd.setMessage("Select a directory");
            String dirName = fd.open();
            if (dirName != null && dirName.length() > 0) {
                m_lastDirSelected = dirName;
                this.m_importDirectory_field.setText(m_lastDirSelected);
                if (load) {
                    this.loadOthersDirectory(m_lastDirSelected);
                }
            }
        }
        if (this.m_importDirectory_field.getText().length() > 0) {
            this.m_gui.enableField(this.m_reloadDir_btn, true);
        }
    }

    public void loadMPIDirectory(String dirName) {
        if (dirName == null) {
            return;
        }
        this.clearSections();
        if (!dirName.endsWith(File.separator)) {
            dirName = String.valueOf(dirName) + File.separator;
        }
        this.m_policyGroupsFile = String.valueOf(dirName) + File.separator + "policyGroups.xml";
        File pg = new File(this.m_policyGroupsFile);
        if (pg.exists()) {
            this.m_polGrpFile = pg;
            this.m_policiesDir = dirName;
            this.loadPolGrpsXmlFile(true);
            this.m_gui.enableField(this.m_loadDir_btn, true);
            if (m_lastDirSelected != null) {
                this.m_reloadDir_btn.setToolTipText(m_lastDirSelected);
                if (this.m_importDirectory_field.getText().trim().equals("")) {
                    this.m_importDirectory_field.setText(m_lastDirSelected);
                }
            }
        } else {
            this.m_policies = new ArrayList<GroupTreeObjectLast>(0);
            this.m_polRoot = null;
            this.m_policiesDir = String.valueOf(dirName) + "policies";
            this.m_policyGroupsFile = String.valueOf(this.m_policiesDir) + File.separator + "policyGroups.xml";
            this.m_actionsDir = String.valueOf(dirName) + "actions";
            this.m_packagesDir = String.valueOf(dirName) + "packages";
            this.m_nodegroupsDir = String.valueOf(dirName) + "nodes";
            this.m_nodeGroupsFile = String.valueOf(this.m_nodegroupsDir) + File.separator + "nodeGroups.xml";
            this.m_nodeGroupsFile_tmp = String.valueOf(Repository.getUserTmpDirectory()) + File.separator + "nodeGroups4Import_tmp.xml";
            File pgDir = new File(this.m_policiesDir);
            if (pgDir.exists() && pgDir.isDirectory()) {
                File[] list = pgDir.listFiles();
                if (list == null || list.length == 0) {
                    RTLogger.print(5, "MPI Import: empty directory, no policies found to import");
                    new ShowMessageBox("  MPI Import", "No Policies found in \n" + this.m_policiesDir, 2);
                } else {
                    pg = new File(this.m_policyGroupsFile);
                    if (!pg.exists()) {
                        RTLogger.print(5, "MPI Import: policyGroups.xml does not exist!");
                        new ShowMessageBox("  MPI Import", "policyGroups.xml does not exist in \n" + this.m_policiesDir, 2);
                    } else {
                        this.m_polGrpFile = pg;
                        this.loadPolGrpsXmlFile(true);
                        this.m_gui.enableField(this.m_loadDir_btn, true);
                        if (m_lastDirSelected != null) {
                            this.m_loadDir_btn.setToolTipText(m_lastDirSelected);
                            if (this.m_importDirectory_field.getText().trim().equals("")) {
                                this.m_importDirectory_field.setText(m_lastDirSelected);
                            }
                        }
                    }
                }
            } else {
                RTLogger.print(5, "MPI Import: policies directory does not exist!");
                new ShowMessageBox("  MPI Import", "Missing Policy Directory: \n" + this.m_policiesDir, 2);
            }
        }
        this.checkEnabledStatus();
        this.updateSections(m_lastDirSelected, IMPORT_MPI);
    }

    /*
     * Exception decompiling
     */
    public void loadOthersDirectory(String dirName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK], 7[TRYBLOCK]], but top level block is 62[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void storeAndCheck(String tempDir, GroupTreeObject dummy, PolicyConvereter pc, String spiName) throws Throwable {
        block7: {
            PolicyFactory pfactory = new PolicyFactory();
            AbstractPolicy ap = this.createPolicy(pc, spiName);
            String filename = pfactory.storePolicy(String.valueOf(tempDir) + "policies/", ap);
            if (ap instanceof Policy) {
                try {
                    PolicyManager.getInstance().getMonitorPolicyThrowEx(new File(filename));
                    this.addToDummyIfNecessary(dummy, ap);
                }
                catch (Throwable e) {
                    ShowMessageDialog sd = new ShowMessageDialog(Display.getCurrent().getActiveShell(), "Checking policy", "Can't convert Policy " + ap.getName(), e.getMessage(), "", false, "Close", 200);
                    sd.setImage(BMUI.IMAGE_BOX_CRITICAL);
                    sd.open();
                    GroupTreeObjectLast gtol = this.m_polRoot.findElement(ap.getName(), BMUI.type_mon);
                    if (gtol != null) {
                        gtol.getParent().removeElement(gtol);
                    }
                    break block7;
                }
            }
            if (ap instanceof MsgPolicy) {
                try {
                    PolicyManager.getInstance().getMessagePolicyThrowEx(new File(filename));
                    this.addToDummyIfNecessary(dummy, ap);
                }
                catch (Throwable e) {
                    ShowMessageDialog sd = new ShowMessageDialog(Display.getCurrent().getActiveShell(), "Checking policy", "Can't convert Policy " + ap.getName(), e.getMessage(), "", false, "Close", 200);
                    sd.open();
                    GroupTreeObjectLast gtol = this.m_polRoot.findElement(ap.getName(), BMUI.type_msg);
                    if (gtol == null) break block7;
                    gtol.getParent().removeElement(gtol);
                }
            }
        }
    }

    private void addToDummyIfNecessary(GroupTreeObject dummy, AbstractPolicy ap) {
        if (ap instanceof MsgPolicy) {
            if (this.m_polRoot.findElement(ap.getName(), BMUI.type_msg) == null) {
                dummy.addElement(new GroupTreeObjectLast(new TreeObject(ap.getName(), BMUI.type_msg, null), null, null));
            }
        } else if (ap instanceof Policy && this.m_polRoot.findElement(ap.getName(), BMUI.type_mon) == null) {
            dummy.addElement(new GroupTreeObjectLast(new TreeObject(ap.getName(), BMUI.type_mon, null), null, null));
        }
    }

    private AbstractPolicy createPolicy(PolicyConvereter pc, String spiName) {
        AbstractPolicy ap = null;
        MsgPolicy mp = pc.createMsgPolicy(spiName);
        if (mp.getName() != null) {
            MsgConditions mcs = pc.createMsgConditions(mp);
            if (mcs.getConditionList().size() == 0) {
                MsgCondition mc = MsgCondition.getNew(0);
                mc.setStopEvaluation(true);
                mcs.addCondition(mc);
            }
            mp.setConditions(mcs);
            ap = mp;
        } else {
            Policy p = pc.createPolicy(spiName);
            Conditions cnds = pc.createConditions(p);
            if (cnds.getConditionList().size() == 0) {
                Condition c = Condition.getNew(0);
                if (p.getType().equals("MAXTHRESHOLD")) {
                    c.setThreshold(1.0);
                    c.setReset(1.0);
                } else {
                    c.setThreshold(-1.0);
                    c.setReset(-1.0);
                }
                c.setHelptext("Imported trigger policy. This condition will never match.");
                c.setSetText("Trigger policy <$NAME>");
                cnds.addCondition(c);
            }
            p.setConditions(cnds);
            ap = p;
        }
        return ap;
    }

    public void loadPolGrpsXmlFile(boolean doUpdateSections) {
        this.m_policies = new ArrayList<GroupTreeObjectLast>(0);
        this.m_polRoot = null;
        XMLTree m_xt = new XMLTree();
        FileInputStream io = null;
        try {
            io = new FileInputStream(this.m_polGrpFile);
            this.m_polRoot = m_xt.parseXML(io, true);
            this.m_policies = this.m_polRoot.getAllGTOLs();
            if (this.m_policies.size() == 0) {
                RTLogger.print(4, "No Policies to import, policyGroups.xml file is empty.");
            }
            this.m_importDirectory_field.setText(m_lastDirSelected);
        }
        catch (FileNotFoundException fileNotFoundException) {
            new ShowMessageBox("  MPI Import", "Cannot find policyGroups.xml File!", 1);
        }
        catch (Throwable throwable) {
            new ShowMessageBox("  MPI Import", "Cannot parse policyGroups.xml File!", 1);
        }
    }

    public void checkEnabledStatus() {
        if (this.getImportType().equals(IMPORT_MPI)) {
            this.m_asnSection.setEnabled(this.isAsnImportAllowed());
            this.m_binSection.setEnabled(this.isBinImportAllowed());
            this.m_actSection.setEnabled(this.isActImportAllowed());
            this.m_nodSection.setEnabled(this.isNodImportAllowed());
            this.m_asnSection.setExpanded(this.isAsnImportAllowed());
            this.m_binSection.setExpanded(this.isBinImportAllowed());
            this.m_actSection.setExpanded(this.isActImportAllowed());
            this.m_nodSection.setExpanded(this.isNodImportAllowed());
        } else if (this.getImportType().equals(IMPORT_OTHER)) {
            this.m_asnSection.setExpanded(true);
            this.m_binSection.setExpanded(false);
            this.m_actSection.setExpanded(false);
            this.m_nodSection.setExpanded(true);
            this.m_asnSection.setEnabled(true);
            this.m_binSection.setEnabled(false);
            this.m_actSection.setEnabled(false);
            this.m_nodSection.setEnabled(true);
        }
    }

    public void updateSections(String importRootDir, String importType) {
        try {
            if (this.pd == null || this.pd.getShell() == null || this.pd.getShell().isDisposed()) {
                this.pd = new ProgressDialog("Import MPI", "Reading data", 1, 5);
            }
            this.pd.setBlockOnOpen(false);
            this.pd.open();
            this.updatePolSection();
            this.updateBinSection();
            this.updateAsnSection(false);
            this.updateProgressBar("Reading Actions", 1, 2);
            this.updateActSection();
            this.updateProgressBar("Reading Actions", 2, 2);
            String ngXml = importRootDir;
            if (!ngXml.endsWith("/") && !importRootDir.endsWith("\\")) {
                ngXml = String.valueOf(ngXml) + File.separator;
            }
            ngXml = String.valueOf(ngXml) + "nodes/nodeGroups.xml";
            this.updateProgressBar("Reading Node groups", 1, 2);
            this.updateNodSection(ngXml, importType);
            this.updateProgressBar("Reading Node groups", 2, 2);
            this.onSectionChangeSize();
        }
        catch (Throwable throwable) {
            try {
                this.pd.close();
            }
            catch (Throwable throwable2) {}
            throw throwable;
        }
        try {
            this.pd.close();
        }
        catch (Throwable throwable) {}
    }

    public void updateProgressBar(String text, int progress, int max) {
        try {
            if (this.pd.getMaximum() != max) {
                this.pd.setMaximum(max);
            }
            this.pd.setProgress(text, progress);
        }
        catch (Throwable throwable) {}
    }

    public void onSectionChangeSize() {
        this.m_sc.setMinSize(this.m_mainComp.computeSize(-1, -1, true));
    }

    public void startImport() {
        GuiClient.m_ignorePending = true;
        String importType = this.getImportType();
        RTLogger.print(5, "START IMPORT (" + importType + ") ***");
        try {
            if (importType.equals(IMPORT_MPI)) {
                try {
                    boolean success = this.importPolicies();
                    if (!success) {
                        RTLogger.print(5, "FINISHED IMPORT (" + importType + ") - STOPPED BY USER");
                        new ShowMessageBox("  " + importType, "Canceled " + this.getImportType() + "!", 2);
                        return;
                    }
                }
                catch (Exception e) {
                    RTLogger.print(2, "Import MPI: Error during Policy import.", e);
                    new ShowMessageBox("  Import MPI", "Error during Policy import", 2);
                }
                try {
                    this.importBinaries();
                }
                catch (Exception e) {
                    RTLogger.print(2, "Import MPI: Error during Binary import.", e);
                    new ShowMessageBox("  Import MPI", "Error during Binary import", 2);
                }
                try {
                    this.importActions();
                }
                catch (Exception e) {
                    RTLogger.print(2, "Import MPI: Error during Action import.", e);
                    new ShowMessageBox("  Import MPI", "Error during Action import", 2);
                }
                try {
                    this.importNodeGroups();
                }
                catch (Exception e) {
                    RTLogger.print(2, "Import MPI: Error during NodeGroups import.", e);
                    new ShowMessageBox("  Import MPI", "Error during NodeGroups import", 2);
                }
            } else if (this.getImportType().equals(IMPORT_OTHER)) {
                try {
                    boolean success = this.importPolicies();
                    if (!success) {
                        RTLogger.print(5, "FINISHED IMPORT (" + importType + ") - STOPPED BY USER");
                        new ShowMessageBox("  " + importType, "Canceled " + this.getImportType() + "!", 2);
                        return;
                    }
                }
                catch (Exception e) {
                    RTLogger.print(2, "Import Other: Error during Policy import.", e);
                    new ShowMessageBox("  Import Other", "Error during Policy import", 2);
                }
                try {
                    this.importNodeGroups();
                }
                catch (Exception e) {
                    RTLogger.print(2, "Import Other: Error during NodeGroups import.", e);
                    new ShowMessageBox("  Import Other", "Error during NodeGroups import", 2);
                }
            }
            if (Repository.getInstance().getRights(1006) > 1) {
                BinariesListView.getInstance().refreshTree(true);
            }
            Repository.getInstance().fetchPolicies(true);
            try {
                this.importAssignments();
            }
            catch (Exception e) {
                RTLogger.print(2, String.valueOf(importType) + ": Error during Assignment import.", e);
                new ShowMessageBox("  " + importType, "Error during Assignment import", 2);
            }
            Repository.getInstance().fetchAssignments(true);
            Repository.getInstance().getAllAssignments().startServerClient(0L, Repository.getInstance());
            GuiClient.m_ignorePending = false;
            RTLogger.print(5, "FINISHED IMPORT (" + importType + ") ***");
            new ShowMessageBox("  " + importType, "Finished " + this.getImportType() + "!", 2);
        }
        catch (RuntimeException e) {
            RTLogger.print(2, "  " + importType + " failed.", e);
            new ShowMessageBox("  " + importType, "Error " + e.getMessage(), 1);
        }
        Event e = new Event();
        e.widget = this.m_reloadDir_btn;
        SelectionEvent se = new SelectionEvent(e);
        this.widgetSelected(se);
    }

    /*
     * Exception decompiling
     */
    private boolean importPolicies() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 17[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void importBinaries() {
        if (!this.isBinImportAllowed()) {
            return;
        }
        List<GroupTreeObject> allBinaries = this.m_binSection.getBinaries4Import();
        Map<String, GroupTreeObject> packagesNew = this.m_binSection.getBinariesNew();
        Map<String, String> packagesNewAfterRename = this.m_binSection.getBinaries2Rename();
        Map<String, GroupTreeObject> packages2Overwrite = this.m_binSection.getBinaries2Overwrite();
        if (allBinaries == null) return;
        if (allBinaries.size() <= 0) return;
        Iterator<GroupTreeObject> it = allBinaries.iterator();
        ProgressDialog pd = new ProgressDialog("Uploading files", "", 0, allBinaries.size());
        pd.setBlockOnOpen(false);
        pd.open();
        int progress = 0;
        ServerClientBatch scBatch = new ServerClientBatch("BATCH");
        scBatch.openSocket();
        try {
            while (it.hasNext()) {
                GroupTreeObject origBin;
                GroupTreeObject binGto = it.next();
                String packageName = binGto.getName();
                if (this.m_binSection.isBinaryEqualByContent(packageName)) {
                    pd.setProgress("Skip Package: " + packageName, ++progress);
                    RTLogger.print(5, "Equal content detected. Binary package skipped: " + packageName);
                    continue;
                }
                String origPath = (String)binGto.getTreeObject().getObject();
                if (origPath == null || (origBin = this.m_binSection.m_binRoot.searchPath(origPath, BMUI.type_assignment_bin)) == null) continue;
                String origName = origBin.getName();
                if (packagesNew.containsKey(origName) || packagesNewAfterRename.containsKey(origName)) {
                    pd.setProgress("Create Package: " + packageName, ++progress);
                    String path = "srv/packages/" + packageName;
                    this.createPackage(scBatch, packageName, path);
                } else if (packages2Overwrite.containsKey(origName)) {
                    pd.setProgress("Overwrite Package: " + packageName, ++progress);
                    this.deleteFiles(scBatch, origName);
                }
                try {
                    this.uploadFiles(scBatch, origName, packageName, pd);
                }
                catch (Throwable throwable) {}
            }
        }
        catch (Throwable throwable) {
            try {
                scBatch.close();
            }
            catch (Throwable throwable2) {}
            try {
                pd.close();
                throw throwable;
            }
            catch (Throwable throwable3) {}
            throw throwable;
        }
        try {
            scBatch.close();
        }
        catch (Throwable throwable) {}
        try {
            pd.close();
            return;
        }
        catch (Throwable throwable) {}
    }

    private void importActions() {
        if (!this.isActImportAllowed()) {
            return;
        }
        List<GroupTreeObject> allActions = this.m_actSection.getActGrps4Import();
        if (allActions.size() > 0) {
            ServerClientBatch scBatch = new ServerClientBatch("BATCH");
            scBatch.openSocket();
            UpdateServer usrv = new UpdateServer();
            ProgressDialog pd = new ProgressDialog("Import Actions", "", 0, allActions.size());
            pd.setBlockOnOpen(false);
            pd.open();
            int count = 0;
            try {
                for (GroupTreeObject actGrpGto : allActions) {
                    List<Action> actions;
                    String actGrpName;
                    String finGroupName = actGrpName = actGrpGto.getName();
                    boolean doImportActGRP = true;
                    boolean merge = this.m_actSection.doMergeActionGrp(actGrpGto);
                    boolean overwrite = this.m_actSection.doOverwriteActionGrp(actGrpGto);
                    GActionsRepository GA = Repository.getInstance().m_actionRepository;
                    if (GA.isActionGroupExist(actGrpName)) {
                        String[] arr;
                        if (merge) {
                            List<Action> newActList = this.m_actSection.getActions4Import(actGrpGto);
                            if (newActList == null) continue;
                            for (Action newAct : newActList) {
                                String newActName = newAct.m_label;
                                if (!this.doesActionExist(GA, actGrpName, newActName)) {
                                    pd.setProgress("Import Action " + newAct, ++count);
                                    ServerClient sc = Repository.getInstance().m_actionRepository.saveAction(newAct, actGrpName);
                                    if (sc.isSuccess()) {
                                        RTLogger.print(3, "UPDATEACTION OK: " + sc.getResultObject());
                                    } else {
                                        RTLogger.print(3, "UPDATEACTION Error: " + sc.getResultObject());
                                    }
                                }
                                doImportActGRP = false;
                            }
                        } else if (overwrite) {
                            arr = new String[]{actGrpName};
                            boolean isSuccess = usrv.syncWithActionServer(CMDS.ACTION_DEL, arr);
                            if (!isSuccess) {
                                RTLogger.print(1, "IMPORT MPI error overwriting existing action group " + actGrpName);
                            }
                            doImportActGRP = true;
                        } else {
                            finGroupName = this.checkActionGroupName(actGrpName);
                            pd.setProgress("Import Action Group" + finGroupName, ++count);
                            arr = new String[]{finGroupName};
                            boolean isSuccess = usrv.syncWithActionServer(scBatch, CMDS.ACTION_ADD, arr);
                            if (!isSuccess) {
                                RTLogger.print(1, "IMPORT MPI error adding action group " + actGrpName);
                            }
                            doImportActGRP = true;
                        }
                    }
                    if (!doImportActGRP || (actions = this.m_actSection.getActions4Import(actGrpGto)) == null) continue;
                    for (Action a : actions) {
                        pd.setProgress("Processing action: \"" + finGroupName + "/" + a.m_label + "\"", count);
                        scBatch.setCommand("UPDATEACTION", finGroupName, new IODataStream[]{a});
                        Object res = scBatch.runBatch();
                        if (scBatch.isSuccess()) {
                            RTLogger.print(3, "Action Import OK: " + a.m_label + " Group:" + finGroupName);
                            continue;
                        }
                        RTLogger.print(3, "UPDATEACTION Error: " + res);
                    }
                }
            }
            catch (Throwable throwable) {
                try {
                    scBatch.close();
                }
                catch (Throwable throwable2) {}
                try {
                    pd.close();
                }
                catch (Throwable throwable3) {}
                throw throwable;
            }
            try {
                scBatch.close();
            }
            catch (Throwable throwable) {}
            try {
                pd.close();
            }
            catch (Throwable throwable) {}
        }
    }

    private void importAssignments() {
        if (!this.isAsnImportAllowed()) {
            return;
        }
        Map<String, GroupTreeObject> asnGrpsNew = this.m_asnSection.getAsnGrpsNew();
        Map<String, GroupTreeObject> asnGrps2Merge = this.m_asnSection.getAsnGrps2Merge();
        int count = asnGrps2Merge.size() + asnGrpsNew.size();
        if (count == 0) {
            return;
        }
        ProgressDialog pd = new ProgressDialog("Import Assignments", "", 0, count);
        pd.setBlockOnOpen(false);
        pd.open();
        int processingNumber = 0;
        ServerClientBatch scBatch = new ServerClientBatch("BATCH");
        scBatch.openSocket();
        UpdateServer usrv = new UpdateServer();
        try {
            for (GroupTreeObject asnGrp : asnGrpsNew.values()) {
                pd.setProgress("Add new Assignment: " + asnGrp.getName(), ++processingNumber);
                boolean isSuccess = this.addAsnElement(usrv, scBatch, asnGrp);
                if (!isSuccess) continue;
                List<GroupTreeObject> elems2Add = asnGrp.getAllElements();
                for (GroupTreeObject gto : elems2Add) {
                    gto = this.checkLinkedPath(gto, pd, processingNumber);
                    isSuccess = this.addAsnElement(usrv, scBatch, gto);
                }
            }
            for (GroupTreeObject asnGrp : asnGrps2Merge.values()) {
                pd.setProgress("Merge Assignment: " + asnGrp.getName(), ++processingNumber);
                List<GroupTreeObject> elems2Merge = asnGrp.getAllElements();
                for (GroupTreeObject gto : elems2Merge) {
                    if (this.doesAsnElementExist(gto)) continue;
                    gto = this.checkLinkedPath(gto, pd, processingNumber);
                    this.addAsnElement(usrv, scBatch, gto);
                }
            }
        }
        catch (Throwable throwable) {
            try {
                scBatch.close();
            }
            catch (Throwable throwable2) {}
            try {
                pd.close();
            }
            catch (Throwable throwable3) {}
            throw throwable;
        }
        try {
            scBatch.close();
        }
        catch (Throwable throwable) {}
        try {
            pd.close();
        }
        catch (Throwable throwable) {}
    }

    private void renameAssignmentElements(GroupTreeObject asn) {
        for (String oldName : this.m_policiesToRename.keySet()) {
            String newPath;
            String lp;
            String newName = this.m_policiesToRename.get(oldName);
            GroupTreeObjectLast gtol = asn.findElement(oldName, BMUI.type_mon);
            String oldLinkedPath = null;
            if (gtol != null) {
                oldLinkedPath = gtol.getLinkedPath();
                gtol.setName(newName);
                lp = gtol.getLinkedPath();
                gtol.setLinkedPath(String.valueOf(lp.substring(0, lp.length() - oldName.length())) + newName);
            } else {
                gtol = asn.findElement(oldName, BMUI.type_msg);
                if (gtol != null) {
                    oldLinkedPath = gtol.getLinkedPath();
                    gtol.setName(newName);
                    lp = gtol.getLinkedPath();
                    gtol.setLinkedPath(String.valueOf(lp.substring(0, lp.length() - oldName.length())) + newName);
                }
            }
            if (gtol == null || oldLinkedPath == null || (newPath = this.m_policiesPathesToRename.get(oldLinkedPath)) == null) continue;
            gtol.setLinkedPath(newPath);
        }
        for (String oldPathName : this.m_policiesPathesToRename.keySet()) {
            String newPath = this.m_policiesPathesToRename.get(oldPathName);
            List<GroupTreeObjectLast> list = asn.findLinksByName(oldPathName);
            if (list.size() <= 0) continue;
            int i = 0;
            while (i < list.size()) {
                GroupTreeObjectLast gtol = list.get(i);
                gtol.setLinkedPath(newPath);
                ++i;
            }
        }
    }

    private void importNodeGroups() {
        List<GroupTreeObject> allNodeGroups4Import = this.m_nodSection.getNodeGrps4Import();
        Map<String, GroupTreeObject> nodGrps2Merge = this.m_nodSection.getNodeGrps2Merge();
        if (allNodeGroups4Import.size() == 0) {
            return;
        }
        allNodeGroups4Import.addAll(nodGrps2Merge.values());
        ProgressDialog pd = new ProgressDialog("Import Nodegroups", "", 0, allNodeGroups4Import.size());
        pd.setBlockOnOpen(false);
        pd.open();
        try {
            pd.setProgress("Merging NodeGroups", 0);
            int i = 0;
            while (i < allNodeGroups4Import.size()) {
                GroupTreeObject gto = allNodeGroups4Import.get(i);
                if (!(gto instanceof GroupTreeObjectLast)) {
                    String path = gto.getPath();
                    if (path.startsWith(BM.GTO_PATH_SEPARATOR)) {
                        if (path.startsWith("/_Groups")) {
                            path = "/root" + path;
                        }
                        ScAddNodeGroup scAddNodeGroup = new ScAddNodeGroup(Repository.getInstance(), path);
                        scAddNodeGroup.run();
                        pd.setProgress("Merging NodeGroups", i + 1);
                    } else {
                        pd.setProgress("Merging NodeGroups", i + 1);
                    }
                } else {
                    pd.setProgress("Merging NodeGroups", i + 1);
                }
                ++i;
            }
        }
        catch (Throwable throwable) {
            try {
                pd.close();
            }
            catch (Throwable throwable2) {}
            throw throwable;
        }
        try {
            pd.close();
        }
        catch (Throwable throwable) {}
    }

    public boolean doCancelImport(String polType, String msg) {
        boolean doCancel = false;
        String title = this.getImportType();
        ImportMPIErrorDialog dialog = new ImportMPIErrorDialog(this.m_parent.getShell(), polType, title, msg);
        dialog.setBlockOnOpen(true);
        dialog.open();
        int returnCode = dialog.getReturnCode();
        if (returnCode == 1) {
            doCancel = true;
        }
        return doCancel;
    }

    public boolean doesAsnElementExist(GroupTreeObject gto) {
        boolean doesExist = false;
        GroupTreeObject existingAsnTree = PolicyManager.getInstance().getAsnTree();
        if (existingAsnTree.searchPath(gto.getPath(), gto.getType()) != null) {
            doesExist = true;
        }
        return doesExist;
    }

    public boolean addAsnElement(UpdateServer usrv, ServerClientBatch scBatch, GroupTreeObject gto) {
        boolean isSuccess = false;
        if (gto instanceof GroupTreeObjectLast) {
            GroupTreeObjectLast gtol = (GroupTreeObjectLast)gto;
            isSuccess = usrv.syncAsnWithServer(scBatch, gtol.getLinkedPath(), gtol.getParentPath(), CMDS.ACTION_ADDLINK_noDeploy, gtol.getType());
            if (!isSuccess) {
                new ShowMessageBox("Import Error", "Assignment element " + gtol.getName() + " creation failed.\nWill be skipped.", 1);
            }
        } else {
            String type = gto.getType();
            if (type.equals(BMUI.type_assignment_pol)) {
                isSuccess = usrv.syncAsnWithServer(scBatch, gto.getParentPath(), gto.getName(), CMDS.ACTION_ADD, type);
            } else {
                isSuccess = usrv.syncAsnWithServer(scBatch, gto.getParentPath(), gto.getName(), CMDS.ACTION_ADD, gto.getType());
                if (!isSuccess) {
                    new ShowMessageBox("Import Error", "Assignment folder " + gto.getName() + " creation failed.\nWill be skipped.", 1);
                }
            }
        }
        return isSuccess;
    }

    private GroupTreeObject checkLinkedPath(GroupTreeObject gto, ProgressDialog pd, int processingNumber) {
        Map<String, String> packagesToRename = this.m_binSection.getBinaries2Rename();
        pd.setProgress("Processing Assignment: " + gto.getPath().replace("/root/Assignments/", ""), processingNumber);
        if (gto instanceof GroupTreeObjectLast) {
            GroupTreeObjectLast gtol = (GroupTreeObjectLast)gto;
            String type = gtol.getTreeObject().getType();
            if (type.equals(BMUI.type_assignment_bin)) {
                if (packagesToRename.containsKey(gtol.getName())) {
                    String newPackageName = packagesToRename.get(gtol.getName());
                    String lpath = gtol.getLinkedPath();
                    gtol.setName(newPackageName);
                    gtol.setLinkedPath(String.valueOf(lpath.substring(0, lpath.lastIndexOf(47) + 1)) + newPackageName);
                }
            } else {
                GroupTreeObject polRoot = PolicyManager.getInstance().getPolicyTree();
                GroupTreeObjectLast existingPol = polRoot.findElement(gtol.getName(), gtol.getType());
                if (existingPol != null && !existingPol.getPath().equals(gtol.getLinkedPath())) {
                    gtol.setLinkedPath(existingPol.getPath());
                }
            }
        }
        return gto;
    }

    private boolean doesActionExist(GActionsRepository GA, String actionGroup, String newActionName) {
        boolean doesExist = false;
        GroupTreeObject actGTO = GA.getTree().getFirstChild(actionGroup);
        GroupTreeObject foundGTO = actGTO.getChild(newActionName, BMUI.type_act);
        if (foundGTO != null) {
            doesExist = true;
        }
        return doesExist;
    }

    private String checkActionGroupName(String groupName) {
        int n = 1;
        String finGroupName = groupName;
        GActionsRepository GA = Repository.getInstance().m_actionRepository;
        while (GA.isActionGroupExist(finGroupName)) {
            finGroupName = String.valueOf(groupName) + "(" + n + ")";
            ++n;
        }
        return finGroupName;
    }

    private void deleteFiles(ServerClientBatch scBatch, String packageName) {
        GroupTreeObject m_binTree = Repository.getInstance().getBinaryTree();
        GroupTreeObject pkgGTO = m_binTree.findFirstGroup(packageName, BMUI.type_assignment_bin);
        ArrayList<String> toDelete = new ArrayList<String>();
        this.collectPathes(pkgGTO, toDelete);
        for (String path : toDelete) {
            path = path.replace("/root/Packages", "srv/packages");
            scBatch.setCommand("DELETE_FILE", path, new String[0]);
            scBatch.runBatch();
            if (scBatch.isSuccess()) {
                RTLogger.print(5, "IMPORT File deleted. " + path);
                continue;
            }
            RTLogger.print(5, "IMPORT Error deleting file: " + path);
        }
    }

    private void collectPathes(GroupTreeObject pkgGTO, ArrayList<String> toDelete) {
        List<GroupTreeObject> al = pkgGTO.getElements();
        for (GroupTreeObject gto : al) {
            toDelete.add(0, gto.getPath());
            if (!gto.hasElements().booleanValue()) continue;
            this.collectPathes(gto, toDelete);
        }
    }

    private void createPackage(ServerClientBatch scBatch, String packageName, String path) {
        scBatch.setCommand("CREATE_FOLDER", path, new String[0]);
        scBatch.runBatch();
        if (!scBatch.isSuccess()) {
            RTLogger.print(5, "IMPORT Error creating Folder: " + path);
            throw new RuntimeException("IMPORT Error creating package: " + packageName);
        }
        RTLogger.print(5, "IMPORT Folder created. " + path);
    }

    private void uploadFiles(ServerClientBatch scBatch, String packageName, String newPackageName, ProgressDialog pd) {
        File pkDir = new File(String.valueOf(this.m_packagesDir) + File.separator + packageName);
        String path = "srv/packages/" + packageName + "/";
        if (newPackageName != null) {
            path = "srv/packages/" + newPackageName + "/";
        }
        this.uploadSingle(scBatch, pkDir, path, pd);
    }

    private void uploadSingle(ServerClientBatch scBatch, File pkDir, String pathEndedWithSlash, ProgressDialog pd) {
        if (pkDir.isDirectory()) {
            File[] list = pkDir.listFiles();
            pd.setMaximum(list.length);
            int i = 0;
            while (i < list.length) {
                String pathCurr = String.valueOf(pathEndedWithSlash) + list[i].getName();
                if (list[i].isDirectory()) {
                    pd.setProgress("Processing package folder: " + pathCurr, pd.getCurrent());
                    scBatch.setCommand("CREATE_FOLDER", pathCurr, new String[0]);
                    scBatch.runBatch();
                    if (!scBatch.isSuccess()) {
                        RTLogger.print(5, "IMPORT Error creating Folder: " + pathCurr);
                        throw new RuntimeException("IMPORT Error creating Folder: " + pathCurr);
                    }
                    RTLogger.print(5, "IMPORT Folder created. " + pathCurr);
                    File[] subFiles = list[i].listFiles();
                    int j = 0;
                    while (j < subFiles.length) {
                        this.uploadSingle(scBatch, subFiles[j], String.valueOf(pathCurr) + "/", pd);
                        ++j;
                    }
                } else {
                    try {
                        pd.setProgress("Processing package file: " + pathCurr, pd.getCurrent());
                        scBatch.setCommand("PUT_FILE", pathCurr, new String[]{list[i].getCanonicalPath()});
                        scBatch.runBatch();
                        if (scBatch.isSuccess()) {
                            RTLogger.print(5, "IMPORT File created. " + pathCurr);
                        } else {
                            RTLogger.print(5, "IMPORT Error creating File: " + pathCurr);
                        }
                    }
                    catch (IOException iOException) {}
                }
                ++i;
            }
        } else {
            try {
                String pathCurr = String.valueOf(pathEndedWithSlash) + pkDir.getName();
                pd.setProgress("Processing package file: " + pathCurr, pd.getCurrent());
                scBatch.setCommand("PUT_FILE", pathCurr, new String[]{pkDir.getCanonicalPath()});
                scBatch.runBatch();
                if (scBatch.isSuccess()) {
                    RTLogger.print(5, "IMPORT File created. " + pathCurr);
                } else {
                    RTLogger.print(5, "IMPORT Error creating File: " + pathCurr);
                }
            }
            catch (IOException iOException) {}
        }
    }

    public ScrolledComposite getScrolledComposite() {
        return this.m_sc;
    }

    public void refreshScrolledComposite() {
        this.onSectionChangeSize();
    }

    private void clearComposite(Composite comp) {
        if (comp != null && !comp.isDisposed()) {
            Control[] controls = comp.getChildren();
            int i = 0;
            while (i < controls.length) {
                controls[i].dispose();
                ++i;
            }
        }
    }

    public void updatePolSection() {
        if (this.m_polSection.isEnabled()) {
            this.m_polSection.clearSection();
            if (this.m_policies != null && this.m_policies.size() > 0) {
                this.m_polSection.updateSection(this.m_polGrpFile, this.m_policies, this.m_polRoot);
            } else if (this.m_polSection.isEnabled()) {
                this.m_polSection.setExpanded(false);
            }
        }
    }

    public void updateAsnSection(boolean resetAction) {
        if (this.m_asnSection.isEnabled()) {
            this.m_asnSection.updateSection(this.m_policiesDir, resetAction);
        }
    }

    public void updateBinSection() {
        if (this.m_binSection.isEnabled()) {
            this.m_binSection.updateSection(m_lastDirSelected, false);
        }
    }

    public void updateActSection() {
        if (this.m_actSection.isEnabled()) {
            this.m_actSection.updateSection(m_lastDirSelected, false);
        }
    }

    public void updateNodSection(String nodeGroupsFilePath, String importType) {
        if (this.m_nodSection.isEnabled()) {
            this.m_nodSection.updateSection(nodeGroupsFilePath, false, importType);
        }
    }

    public void clearSections() {
        if (this.m_polSection.isEnabled()) {
            this.m_polSection.clearSection();
        }
        if (this.m_asnSection.isEnabled()) {
            this.m_asnSection.clearSection();
        }
        if (this.m_binSection.isEnabled()) {
            this.m_binSection.clearSection();
        }
        if (this.m_actSection.isEnabled()) {
            this.m_actSection.clearSection();
        }
        if (this.m_nodSection.isEnabled()) {
            this.m_nodSection.clearSection();
        }
    }

    public void refreshTree(TreeViewer tv, GroupTreeObject root, int expLevel) {
        if (tv == null) {
            return;
        }
        Object[] expanded = tv.getExpandedElements();
        tv.setInput((Object)root);
        if (expLevel > -1) {
            tv.expandToLevel(expLevel);
        } else if (expanded == null) {
            tv.expandToLevel(2);
        } else {
            int i = 0;
            while (i < expanded.length) {
                tv.setExpandedState(expanded[i], true);
                ++i;
            }
        }
        tv.refresh();
    }

    public GroupTreeObject addElement2Tree(GroupTreeObject root, GroupTreeObject gto, String newParentPath) {
        GroupTreeObject parentGTO = null;
        GroupTreeObject existingGTO = null;
        GroupTreeObject clone = null;
        existingGTO = root.searchPath(gto.getPath(), gto.getType());
        if (existingGTO != null) {
            parentGTO = existingGTO.getParent();
            parentGTO.removeElement(existingGTO);
        }
        if (parentGTO == null && (parentGTO = root.searchPath(gto.getParentPath(), gto.getParent().getType())) == null) {
            parentGTO = GroupTreeObject.createPath(newParentPath, root);
            parentGTO.setType(gto.getParent().getType());
        }
        try {
            clone = gto.clone();
            if (clone != null) {
                clone.getTreeObject().setObject(gto.getPath());
                this.setOriginalPath(clone, gto);
                try {
                    parentGTO.addElement(clone);
                }
                catch (Exception exception) {}
            }
        }
        catch (CloneNotSupportedException e) {
            RTLogger.print(5, "Error cloning element " + gto.getName(), e);
        }
        return clone;
    }

    private void setOriginalPath(GroupTreeObject clone, GroupTreeObject original) {
        if (original.hasElements().booleanValue()) {
            for (GroupTreeObject child : original.getElements()) {
                GroupTreeObject originalChild = original.getChild(child.getName(), child.getType());
                child.getTreeObject().setObject(originalChild.getPath());
                if (!child.hasElements().booleanValue()) continue;
                this.setOriginalPath(child, originalChild);
            }
        }
    }

    public void removeElementFromTree(GroupTreeObject root, String name, String type) {
        GroupTreeObjectLast gtolExist = root.findElement(name, type);
        if (gtolExist != null) {
            gtolExist.getParent().removeElement(gtolExist);
        }
    }

    public void removeElementFromTree(GroupTreeObject gto) {
        gto.getParent().removeElement(gto);
    }

    public GroupTreeObjectLast moveElement(GroupTreeObject root, GroupTreeObjectLast gto, String newParentPath) {
        if (gto != null) {
            if (root.findElement(gto.getName(), gto.getType()) == null) {
                return null;
            }
            gto.getParent().removeElement(gto);
            GroupTreeObject newParent = root.searchPath(newParentPath, BMUI.type_folder);
            if (newParent == null) {
                newParent = GroupTreeObject.createPath(newParentPath, root);
                newParent.setType(gto.getParent().getType());
            }
            if (newParent != null && newParent.findElement(gto.getName(), gto.getType()) == null) {
                newParent.addElement(gto);
            }
        }
        return gto;
    }

    public ImportMPIPolicySection getPolSection() {
        return this.m_polSection;
    }

    public ImportMPIAsnSection getAsnSection() {
        return this.m_asnSection;
    }

    public ImportMPIBinarySection getBinSection() {
        return this.m_binSection;
    }

    public void setFocus() {
    }

    public String getImportType() {
        return this.m_importTypes_cbo.getText();
    }

    public GroupTreeObject getExistingPolTree() {
        return this.m_existingPolicyTree;
    }

    public File getPolGrpFile() {
        return this.m_polGrpFile;
    }

    public void updateImportButtonStatus() {
        int conflicts = 0;
        if (this.m_polSection.isEnabled()) {
            conflicts += this.m_polSection.getTotalImportConflicts();
        }
        if (this.m_asnSection.isEnabled()) {
            conflicts += this.m_asnSection.getTotalImportConflicts();
        }
        if (this.m_binSection.isEnabled()) {
            conflicts += this.m_binSection.getTotalImportConflicts();
        }
        if (this.m_actSection.isEnabled()) {
            conflicts += this.m_actSection.getTotalImportConflicts();
        }
        if (this.m_nodSection.isEnabled()) {
            conflicts += this.m_nodSection.getTotalImportConflicts();
        }
        this.m_import_btn.setEnabled(conflicts == 0);
    }

    public void widgetDisposed(DisposeEvent e) {
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        Object obj = e.getSource();
        if (obj instanceof Button) {
            Button btn = (Button)obj;
            String name = (String)btn.getData();
            if (name.equals(LOAD_DIR_BTN)) {
                if (this.m_importTypes_cbo.getText().equals(IMPORT_MPI)) {
                    this.browseAndLoadDirectory(IMPORT_MPI, true);
                } else if (this.m_importTypes_cbo.getText().equals(IMPORT_OTHER)) {
                    this.browseAndLoadDirectory(IMPORT_OTHER, true);
                }
            } else if (name.equals(RELOAD_DIR_BTN)) {
                if (this.m_importTypes_cbo.getText().equals(IMPORT_MPI)) {
                    this.loadMPIDirectory(m_lastDirSelected);
                } else if (this.m_importTypes_cbo.getText().equals(IMPORT_OTHER)) {
                    this.loadOthersDirectory(m_lastDirSelected);
                }
            } else if (name.equals(IMPORT_BTN)) {
                this.startImport();
            }
        }
    }

    public void modifyText(ModifyEvent e) {
        Object obj = e.getSource();
        if (obj instanceof Text) {
            Text text = (Text)obj;
            String name = (String)text.getData();
            String value = text.getText().trim();
            if (name.equals(IMPORT_DIR_FIELD)) {
                this.m_loadDir_btn.setToolTipText(value);
            }
        }
    }

    public void expansionStateChanged(ExpansionEvent e) {
        this.refreshScrolledComposite();
    }

    public void expansionStateChanging(ExpansionEvent e) {
    }
}

