/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.EventBrowserProvider;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.gui.views.MaintenanceView;
import com.blixx.boom.gui.views.MessageBrowserTab;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class MaintenanceViewFolder
extends CTabFolder {
    private MaintenanceView m_msgView;
    private Composite m_parent = null;
    private static String CLOSE = "Close";
    private static String CLOSE_OTHER = "Close Other";
    private static String CLOSE_ALL = "Close All";

    public MaintenanceViewFolder(MaintenanceView view, Composite parent, int style) {
        super(parent, style);
        this.m_msgView = view;
        this.m_parent = parent;
        this.setSimple(false);
        this.setMinimizeVisible(false);
        this.setMaximizeVisible(false);
        this.setBorderVisible(false);
        this.setUnselectedCloseVisible(true);
        this.createContentMenu();
        this.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (e.item instanceof MessageBrowserTab) {
                    MessageBrowserTab mtb = (MessageBrowserTab)e.item;
                    mtb.tableViewer.setInput(mtb.getEventProvider().getElements(null));
                    mtb.createSummary();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    public void createContentMenu() {
        final Menu m = new Menu((Control)this);
        final MaintenanceViewFolder mThis = this;
        MenuItem miOutage = new MenuItem(m, -1);
        miOutage.setText("Add Tab");
        miOutage.setData((Object)"ADD_MAINTENANCE_TAB");
        miOutage.setImage(BMUI.IMAGE_INDICATIONS_MAINTENANCE);
        miOutage.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                MessageBrowserTab mtb = new MessageBrowserTab(mThis.m_msgView.getSite(), mThis, 64, mThis.getItemCount(), null, true, new EventBrowserProvider(Repository.getOuEventProvider()), Repository.getOuEventsSummary(), MessageBrowserTab.DEFAULT_TAB, null);
                mThis.setSelection(mtb);
            }
        });
        miOutage.setEnabled(Repository.getInstance().isOutageSupported());
        MenuItem mi_sep = new MenuItem(m, 2);
        mi_sep.setData((Object)"");
        MenuItem mi_close = new MenuItem(m, -1);
        mi_close.setText(CLOSE);
        mi_close.setData((Object)CLOSE);
        mi_close.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                CTabItem msgTab = mThis.getSelection();
                if (msgTab.getStyle() == 64) {
                    msgTab.dispose();
                }
            }
        });
        MenuItem mi_closeOther = new MenuItem(m, -1);
        mi_closeOther.setText(CLOSE_OTHER);
        mi_closeOther.setData((Object)CLOSE_OTHER);
        mi_closeOther.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                CTabItem currentTab = mThis.getSelection();
                CTabItem[] tabs = mThis.getItems();
                int i = 0;
                while (i < tabs.length) {
                    MessageBrowserTab msgTab;
                    if (!currentTab.equals(tabs[i]) && (msgTab = (MessageBrowserTab)tabs[i]).getStyle() == 64) {
                        msgTab.dispose();
                    }
                    ++i;
                }
            }
        });
        MenuItem mi_closeAll = new MenuItem(m, -1);
        mi_closeAll.setText(CLOSE_ALL);
        mi_closeAll.setData((Object)CLOSE_ALL);
        mi_closeAll.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                CTabItem[] tabs = mThis.getItems();
                int i = 0;
                while (i < tabs.length) {
                    MessageBrowserTab msgTab = (MessageBrowserTab)tabs[i];
                    if (msgTab.getStyle() == 64) {
                        msgTab.dispose();
                    }
                    ++i;
                }
            }
        });
        m.addMenuListener(new MenuListener(){

            public void menuHidden(MenuEvent e) {
            }

            public void menuShown(MenuEvent e) {
                int index;
                Menu menu = m;
                MenuItem[] mi = menu.getItems();
                MaintenanceViewFolder msgViewFolder = mThis;
                int count = msgViewFolder.getItemCount();
                if (count == 0) {
                    index = 0;
                    while (index < mi.length) {
                        if (mi[index].getData().equals(CLOSE) || mi[index].getData().equals(CLOSE_OTHER) || mi[index].getData().equals(CLOSE_ALL)) {
                            mi[index].setEnabled(false);
                        }
                        ++index;
                    }
                } else if (count == 1) {
                    index = 0;
                    while (index < mi.length) {
                        if (mi[index].getData().equals(CLOSE)) {
                            mi[index].setEnabled(true);
                        } else if (mi[index].getData().equals(CLOSE_OTHER) || mi[index].getData().equals(CLOSE_ALL)) {
                            mi[index].setEnabled(false);
                        }
                        ++index;
                    }
                } else if (count > 1) {
                    index = 0;
                    while (index < mi.length) {
                        mi[index].setEnabled(true);
                        ++index;
                    }
                }
                CTabItem tab = msgViewFolder.getSelection();
                int index2 = 0;
                while (index2 < mi.length) {
                    String action = (String)mi[index2].getData();
                    if (count > 0 && action.equals(CLOSE)) {
                        if (tab.getStyle() == 64) {
                            mi[index2].setEnabled(true);
                        } else {
                            mi[index2].setEnabled(false);
                        }
                    }
                    ++index2;
                }
            }
        });
        this.setMenu(m);
    }

    public MaintenanceView getView() {
        return this.m_msgView;
    }

    public void setSelection(CTabItem item) {
        super.setSelection(item);
    }
}

