/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views;

import com.blixx.boom.engine.AgentCard;
import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.EventBrowserProvider;
import com.blixx.boom.engine.EventFilter;
import com.blixx.boom.engine.EventSorter;
import com.blixx.boom.engine.EventStorage;
import com.blixx.boom.engine.EventStorageUtils;
import com.blixx.boom.engine.IEventsSummary;
import com.blixx.boom.engine.ITableBrowserProvider;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.engine.ServerClient;
import com.blixx.boom.engine.ServiceDashBoard;
import com.blixx.boom.gui.dialogs.MessageDetailsDialog;
import com.blixx.boom.gui.dialogs.ShowHideColumnsDialog;
import com.blixx.boom.gui.settings.BrowserLabelManager;
import com.blixx.boom.gui.settings.PredefinedTab;
import com.blixx.boom.gui.settings.UISettings;
import com.blixx.boom.gui.utils.MessageBrowserTableFilter;
import com.blixx.boom.gui.utils.QuickFilterComposite;
import com.blixx.boom.gui.views.BTableViewer;
import com.blixx.boom.gui.views.MessagesView;
import com.blixx.boom.gui.views.MessagesViewFolder;
import com.blixx.boom.gui.views.PolicyView;
import com.blixx.boom.gui.views.actions.AcknowledgeAction;
import com.blixx.boom.gui.views.actions.AddIndicationConditionAction;
import com.blixx.boom.gui.views.actions.ArchiveMessagesAction;
import com.blixx.boom.gui.views.actions.DeleteAllFiltersAction;
import com.blixx.boom.gui.views.actions.DisableEnableAllFilters;
import com.blixx.boom.gui.views.actions.ExportIndiCSVAction;
import com.blixx.boom.gui.views.actions.ExportIndicationAction;
import com.blixx.boom.gui.views.actions.FastAndRemoteActions;
import com.blixx.boom.gui.views.actions.LoadActiveIndicationsFiltered;
import com.blixx.boom.gui.views.actions.LoadClosedIndicationsFiltered;
import com.blixx.boom.gui.views.actions.ManageDialogAction;
import com.blixx.boom.gui.views.actions.MonitorHistoryAction;
import com.blixx.boom.gui.views.actions.PushIndi2NotiAction;
import com.blixx.boom.gui.views.actions.ReopenMessagesAction;
import com.blixx.boom.gui.views.actions.ShowAssignedPoliciesAction;
import com.blixx.boom.gui.views.actions.UnloadActiveIndications;
import com.blixx.boom.gui.views.actions.UnloadClosedIndications;
import com.blixx.boom.gui.views.actions.ViewAckMessagesAction;
import com.blixx.boom.gui.views.actions.ViewFilterAction;
import com.blixx.log.RTLogger;
import com.blixx.shared.SEvent;
import com.blixx.shared.SEventFwd;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;

public class MessageBrowserTab
extends CTabItem
implements IDoubleClickListener,
MouseListener {
    public static final String DEF_WIDTH = "def_width";
    protected CTabFolder m_parent = null;
    public BTableViewer tableViewer = null;
    public MessageBrowserTab tab = null;
    public IWorkbenchPartSite site;
    protected EventSorter m_eventSorter;
    private ITableBrowserProvider m_eventStorage;
    private IEventsSummary m_eventsSummary;
    public Composite m_summary;
    public Composite m_summaryComp;
    protected Composite m_top_composite;
    protected Label m_clickUnknown = null;
    protected Label m_clickNormal = null;
    protected Label m_clickWarn = null;
    protected Label m_clickMinor = null;
    protected Label m_clickMajor = null;
    protected Label m_clickCritical = null;
    protected Label m_actual;
    protected Label m_ackn;
    protected Label m_unkn;
    protected Label m_norm;
    protected Label m_warn;
    protected Label m_mino;
    protected Label m_majo;
    protected Label m_crit;
    protected Label m_selCountLabel;
    protected int m_selCount = 0;
    int m_filtered = 0;
    String m_unkn_str = null;
    String m_norm_str = null;
    String m_warn_str = null;
    String m_mino_str = null;
    String m_majo_str = null;
    String m_crit_str = null;
    protected Label m_isLocked_label = null;
    protected static String LOCKED = "Locked";
    protected static String UNLOCKED = "Unlocked";
    protected boolean m_isLocked = false;
    protected boolean m_isLockedManual = false;
    protected boolean m_canSortTable = true;
    protected boolean m_canModifyFilters = true;
    protected boolean m_canSwitch = true;
    protected boolean m_displayNumbers = true;
    protected boolean hasDefault = false;
    protected Color m_backgroundTableOutageActive = BMUI.indiBrowserBkgrActive;
    protected Color m_backgroundTableOutageClosed = BMUI.indiBrowserBkgrClose;
    protected Color m_backgroundTableNormalActive = BMUI.outageBkgrActive;
    protected Color m_backgroundTableNormalClosed = BMUI.outageBkgrClose;
    protected Color m_foregroundTableColor = BMUI.color_black;
    private String m_type = DEFAULT_TAB;
    public static String DEFAULT_TAB = "DEFAULT_TAB";
    public static String PREDEFINED_TAB = "PREDEFINED_TAB";
    public static String USER_TAB = "USER_TAB";
    public static String NEW_TAB = "NEW_TAB";
    public static String SIM_TAB = "SIM_TAB";
    public PredefinedTab m_predefinedOrUserTab = null;
    protected BrowserLabelManager m_browserLabelManager = null;
    public static String COL_DEFAULT_NAME = "COL_DEFAULT_NAME";
    QuickFilterComposite m_quickFilter = null;
    public Listener sortListener = new Listener(){

        public void handleEvent(Event e) {
            if (!UISettings.getInstance().IB_canSortTable()) {
                return;
            }
            if (e.type == 13) {
                TableColumn sortColumn = MessageBrowserTab.this.tableViewer.getTable().getSortColumn();
                TableColumn currentColumn = (TableColumn)e.widget;
                int dir = MessageBrowserTab.this.tableViewer.getTable().getSortDirection();
                if (sortColumn == currentColumn) {
                    dir = dir == 128 ? 1024 : 128;
                } else {
                    MessageBrowserTab.this.tableViewer.getTable().setSortColumn(currentColumn);
                    dir = 128;
                }
                String sortIdentifier = MessageBrowserTab.this.m_browserLabelManager.getName(currentColumn.getText());
                MessageBrowserTab.this.m_eventSorter.setConfig(sortIdentifier, dir);
                MessageBrowserTab.this.tableViewer.getTable().setSortDirection(dir);
                ISelection sel = MessageBrowserTab.this.tableViewer.getSelection();
                if (MessageBrowserTab.this.tableViewer.getSorter() != MessageBrowserTab.this.m_eventSorter) {
                    MessageBrowserTab.this.tableViewer.setSorter(MessageBrowserTab.this.m_eventSorter);
                } else {
                    MessageBrowserTab.this.tableViewer.refresh(true, false);
                }
                MessageBrowserTab.this.tableViewer.setSelection(sel, false);
                UISettings.getInstance().storeAndReload();
            } else if (e.type != 40 && e.type != 36) {
                int cfr_ignored_0 = e.type;
            }
        }
    };

    protected MessageBrowserTab(CTabFolder parent, int style) {
        super(parent, style);
    }

    public MessageBrowserTab(IWorkbenchPartSite siteV, CTabFolder parent, int style, int position, String titleIfnecessary, boolean isActive, ITableBrowserProvider eventStorage, IEventsSummary eventsSummary, String type, PredefinedTab predefinedOrUserTab) {
        super(parent, style);
        this.m_eventsSummary = eventsSummary;
        this.m_eventStorage = eventStorage;
        this.m_eventStorage.setShowActive(isActive);
        this.site = siteV;
        this.m_parent = parent;
        if (titleIfnecessary != null) {
            this.setText(titleIfnecessary);
        } else {
            this.setText("");
        }
        this.m_type = type;
        this.checkTitle();
        this.m_browserLabelManager = Repository.getInstance().getBrowserLabelManager();
        this.m_top_composite = new Composite((Composite)parent, 2048);
        GridLayout gl = new GridLayout(2, false);
        gl.marginWidth = 0;
        gl.horizontalSpacing = 0;
        gl.verticalSpacing = 0;
        this.m_top_composite.setLayout((Layout)gl);
        this.m_top_composite.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite filter_comp = new Composite(this.m_top_composite, 0);
        gl = new GridLayout(1, false);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        gl.horizontalSpacing = 0;
        gl.verticalSpacing = 0;
        gl.marginBottom = 5;
        filter_comp.setLayout((Layout)gl);
        filter_comp.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        this.m_quickFilter = new QuickFilterComposite(filter_comp, (Object)this);
        this.m_eventSorter = new EventSorter("SrvTime", 1024);
        this.createTable(this.m_top_composite);
        this.m_eventStorage.getEventProvider().addTableToRefresh(this.tableViewer);
        this.createSummary();
        this.setControl((Control)this.m_top_composite);
        this.m_predefinedOrUserTab = predefinedOrUserTab;
        this.tab = this;
    }

    public MessageBrowserTab(IWorkbenchPartSite siteV, CTabFolder parent, int style, int position, String titleIfnecessary, boolean isActive, String type, PredefinedTab predefinedOrUserTab) {
        this(siteV, parent, style, position, titleIfnecessary, isActive, new EventBrowserProvider(EventStorage.getInstance()), EventStorage.getInstance(), type, predefinedOrUserTab);
    }

    public void createSummary() {
        this.updateImage();
        if (this.m_summary == null) {
            this.m_summary = new Composite(this.m_top_composite, 0);
            GridLayout gl = new GridLayout(1, false);
            gl.marginHeight = 0;
            gl.marginWidth = 0;
            gl.verticalSpacing = 0;
            gl.marginTop = 5;
            this.m_summary.setLayout((Layout)gl);
            this.m_summary.setLayoutData((Object)new GridData(4, 1024, true, false, 1, 1));
            this.m_summaryComp = new Composite(this.m_summary, 0);
            gl = new GridLayout(26, false);
            gl.marginHeight = 0;
            gl.verticalSpacing = 0;
            this.m_summaryComp.setLayout((Layout)gl);
            this.m_summaryComp.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
            this.m_summaryComp.addControlListener(new ControlListener(){

                public void controlResized(ControlEvent e) {
                    boolean displayNumbers = MessageBrowserTab.this.m_displayNumbers;
                    if (displayNumbers) {
                        MessageBrowserTab.this.checkSummeryWidth();
                        if (!MessageBrowserTab.this.m_displayNumbers) {
                            MessageBrowserTab.this.createSummaryContent();
                        }
                    } else {
                        MessageBrowserTab.this.checkSummeryWidth();
                        if (MessageBrowserTab.this.m_displayNumbers) {
                            MessageBrowserTab.this.createSummaryContent();
                        }
                    }
                }

                public void controlMoved(ControlEvent e) {
                }
            });
            this.checkSummeryWidth();
            this.createSummaryContent();
        } else {
            this.updateMsgNumbers();
            int totalActualMessages = this.m_eventStorage.getTotalActualMessages();
            int totalAcknMessages = this.m_eventStorage.getTotalAcknMessages();
            if (this.m_eventStorage.isShowActive()) {
                this.m_actual.setText(totalActualMessages + "/" + (totalActualMessages - this.m_filtered));
                this.m_ackn.setText("" + totalAcknMessages);
            } else {
                this.m_actual.setText("" + totalActualMessages);
                this.m_ackn.setText(totalAcknMessages + "/" + (totalAcknMessages - this.m_filtered));
            }
            this.m_selCountLabel.setText("Selected: " + this.m_selCount);
            if (this.m_displayNumbers) {
                if (this.m_unkn != null) {
                    this.m_unkn.setText(this.m_unkn_str);
                }
                if (this.m_norm != null) {
                    this.m_norm.setText(this.m_norm_str);
                }
                if (this.m_warn != null) {
                    this.m_warn.setText(this.m_warn_str);
                }
                if (this.m_mino != null) {
                    this.m_mino.setText(this.m_mino_str);
                }
                if (this.m_majo != null) {
                    this.m_majo.setText(this.m_majo_str);
                }
                if (this.m_crit != null) {
                    this.m_crit.setText(this.m_crit_str);
                }
            } else {
                if (this.m_clickUnknown != null) {
                    this.m_clickUnknown.setToolTipText("Unknown " + this.m_unkn_str);
                }
                if (this.m_clickNormal != null) {
                    this.m_clickNormal.setToolTipText("Normal " + this.m_norm_str);
                }
                if (this.m_clickWarn != null) {
                    this.m_clickWarn.setToolTipText("Warning " + this.m_warn_str);
                }
                if (this.m_clickMinor != null) {
                    this.m_clickMinor.setToolTipText("Minor " + this.m_mino_str);
                }
                if (this.m_clickMajor != null) {
                    this.m_clickMajor.setToolTipText("Major " + this.m_majo_str);
                }
                if (this.m_clickCritical != null) {
                    this.m_clickCritical.setToolTipText("Critical " + this.m_crit_str);
                }
            }
        }
        this.m_summaryComp.pack();
        if (this.m_isLocked_label == null) {
            this.m_isLocked_label = this.createImageButton(this.m_top_composite, BMUI.IMAGE_UNLOCKED);
            GridData gd = new GridData(16384, 128, false, false);
            gd.horizontalIndent = 5;
            gd.verticalIndent = 5;
            this.m_isLocked_label.setLayoutData((Object)gd);
            this.m_isLocked_label.setData((Object)UNLOCKED);
            this.m_isLocked_label.setToolTipText("Table is unlocked");
            this.m_isLocked_label.setAlignment(131072);
            this.m_isLocked_label.addMouseListener(new MouseListener(){

                public void mouseDoubleClick(MouseEvent e) {
                    if (e.getSource() instanceof Label) {
                        Label l = (Label)e.getSource();
                        String data = (String)l.getData();
                        if (data.equalsIgnoreCase(LOCKED)) {
                            if (MessageBrowserTab.this.m_selCount < 5000) {
                                MessageBrowserTab.this.setTableLocked(false, true);
                            }
                        } else if (data.equalsIgnoreCase(UNLOCKED)) {
                            MessageBrowserTab.this.setTableLocked(true, true);
                        }
                    }
                }

                public void mouseDown(MouseEvent e) {
                }

                public void mouseUp(MouseEvent e) {
                }
            });
            this.createCM_lock((Control)this.m_isLocked_label);
        }
    }

    public void updateMsgNumbers() {
        int inactive0 = 0;
        int inactive1 = 0;
        int inactive2 = 0;
        int inactive3 = 0;
        int inactive4 = 0;
        int inactive5 = 0;
        this.m_filtered = 0;
        ViewerFilter[] vf = this.tableViewer.getFilters();
        if (vf != null && vf.length > 0) {
            int i = 0;
            while (i < vf.length) {
                if (vf[i] instanceof EventFilter) {
                    EventFilter ef = (EventFilter)vf[i];
                    this.m_filtered += ef.m_filtered;
                    inactive0 += ef.m_inactiveUnknown;
                    inactive1 += ef.m_inactiveNormal;
                    inactive2 += ef.m_inactiveWarning;
                    inactive3 += ef.m_inactiveMinor;
                    inactive4 += ef.m_inactiveMajor;
                    inactive5 += ef.m_inactiveCritical;
                } else if (vf[i] instanceof ServiceDashBoard) {
                    ServiceDashBoard service = (ServiceDashBoard)vf[i];
                    this.m_filtered += service.m_filtered;
                    inactive0 += service.m_inactiveUnknown;
                    inactive1 += service.m_inactiveNormal;
                    inactive2 += service.m_inactiveWarning;
                    inactive3 += service.m_inactiveMinor;
                    inactive4 += service.m_inactiveMajor;
                    inactive5 += service.m_inactiveCritical;
                } else if (vf[i] instanceof MessageBrowserTableFilter) {
                    MessageBrowserTableFilter mbtf = (MessageBrowserTableFilter)vf[i];
                    this.m_filtered += mbtf.m_filtered;
                    inactive0 += mbtf.m_inactiveUnknown;
                    inactive1 += mbtf.m_inactiveNormal;
                    inactive2 += mbtf.m_inactiveWarning;
                    inactive3 += mbtf.m_inactiveMinor;
                    inactive4 += mbtf.m_inactiveMajor;
                    inactive5 += mbtf.m_inactiveCritical;
                }
                ++i;
            }
        }
        int numUnknMessages = this.m_eventStorage.getNumUnknMessages();
        int numNormMessages = this.m_eventStorage.getNumNormMessages();
        int numWarnMessages = this.m_eventStorage.getNumWarnMessages();
        int numMinorMessages = this.m_eventStorage.getNumMinorMessages();
        int numMajorMessages = this.m_eventStorage.getNumMajorMessages();
        int numCritMessages = this.m_eventStorage.getNumCritMessages();
        this.m_selCount = ((StructuredSelection)this.tableViewer.getSelection()).size();
        this.m_unkn_str = numUnknMessages + "/" + (numUnknMessages - inactive0);
        this.m_norm_str = numNormMessages + "/" + (numNormMessages - inactive1);
        this.m_warn_str = numWarnMessages + "/" + (numWarnMessages - inactive2);
        this.m_mino_str = numMinorMessages + "/" + (numMinorMessages - inactive3);
        this.m_majo_str = numMajorMessages + "/" + (numMajorMessages - inactive4);
        this.m_crit_str = numCritMessages + "/" + (numCritMessages - inactive5);
    }

    public void createSummaryContent() {
        if (this.m_summaryComp != null && !this.m_summaryComp.isDisposed()) {
            Control[] controls = this.m_summaryComp.getChildren();
            int i = 0;
            while (i < controls.length) {
                controls[i].dispose();
                ++i;
            }
        }
        this.updateMsgNumbers();
        int totalActualMessages = this.m_eventStorage.getTotalActualMessages();
        int totalAcknMessages = this.m_eventStorage.getTotalAcknMessages();
        if (this.m_eventStorage.isShowActive()) {
            this.createButton(this.m_summaryComp, "Active: ", "active", null);
            this.m_actual = this.createPlainLabel(this.m_summaryComp, totalActualMessages + "/" + (totalActualMessages - this.m_filtered));
            this.createButton(this.m_summaryComp, "Closed: ", "closed", null);
            this.m_ackn = this.createPlainLabel(this.m_summaryComp, "" + totalAcknMessages);
        } else {
            this.createButton(this.m_summaryComp, "Active: ", "active", null);
            this.m_actual = this.createPlainLabel(this.m_summaryComp, "" + totalActualMessages);
            this.createButton(this.m_summaryComp, "Closed: ", "closed", null);
            this.m_ackn = this.createPlainLabel(this.m_summaryComp, totalAcknMessages + "/" + (totalAcknMessages - this.m_filtered));
        }
        this.m_selCountLabel = this.createPlainLabel(this.m_summaryComp, "Selection: " + this.m_selCount);
        this.m_selCountLabel.setLayoutData((Object)new GridData());
        this.m_clickUnknown = this.createImageButton(this.m_summaryComp, BMUI.IMAGE_UNKNOWN);
        this.m_clickUnknown.setToolTipText("Unknown");
        this.m_clickUnknown.setData((Object)"unknown");
        this.m_clickUnknown.addMouseListener((MouseListener)this);
        this.createCM((Control)this.m_clickUnknown, "unknown");
        if (this.m_displayNumbers) {
            this.m_unkn = this.createPlainLabel(this.m_summaryComp, this.m_unkn_str);
        } else {
            this.m_clickUnknown.setToolTipText("Unknown " + this.m_unkn_str);
        }
        this.m_clickNormal = this.createImageButton(this.m_summaryComp, BMUI.IMAGE_NORMAL);
        this.m_clickNormal.setToolTipText("Normal");
        this.m_clickNormal.setData((Object)"normal");
        this.m_clickNormal.addMouseListener((MouseListener)this);
        this.createCM((Control)this.m_clickNormal, "normal");
        if (this.m_displayNumbers) {
            this.m_norm = this.createPlainLabel(this.m_summaryComp, this.m_norm_str);
        } else {
            this.m_clickNormal.setToolTipText("Normal " + this.m_norm_str);
        }
        this.m_clickWarn = this.createImageButton(this.m_summaryComp, BMUI.IMAGE_WARNING);
        this.m_clickWarn.setToolTipText("Warning");
        this.m_clickWarn.setData((Object)"warning");
        this.m_clickWarn.addMouseListener((MouseListener)this);
        this.createCM((Control)this.m_clickWarn, "warning");
        if (this.m_displayNumbers) {
            this.m_warn = this.createPlainLabel(this.m_summaryComp, this.m_warn_str);
        } else {
            this.m_clickWarn.setToolTipText("Warning " + this.m_warn_str);
        }
        this.m_clickMinor = this.createImageButton(this.m_summaryComp, BMUI.IMAGE_MINOR);
        this.m_clickMinor.setToolTipText("Minor");
        this.m_clickMinor.setData((Object)"minor");
        this.m_clickMinor.addMouseListener((MouseListener)this);
        this.createCM((Control)this.m_clickMinor, "minor");
        if (this.m_displayNumbers) {
            this.m_mino = this.createPlainLabel(this.m_summaryComp, this.m_mino_str);
        } else {
            this.m_clickMinor.setToolTipText("Minor " + this.m_mino_str);
        }
        this.m_clickMajor = this.createImageButton(this.m_summaryComp, BMUI.IMAGE_MAJOR);
        this.m_clickMajor.setToolTipText("Major");
        this.m_clickMajor.setData((Object)"major");
        this.m_clickMajor.addMouseListener((MouseListener)this);
        this.createCM((Control)this.m_clickMajor, "major");
        if (this.m_displayNumbers) {
            this.m_majo = this.createPlainLabel(this.m_summaryComp, this.m_majo_str);
        } else {
            this.m_clickMajor.setToolTipText("Major " + this.m_majo_str);
        }
        this.m_clickCritical = this.createImageButton(this.m_summaryComp, BMUI.IMAGE_CRITICAL);
        this.m_clickCritical.setToolTipText("Critical");
        this.m_clickCritical.setData((Object)"critical");
        this.m_clickCritical.addMouseListener((MouseListener)this);
        this.createCM((Control)this.m_clickCritical, "critical");
        if (this.m_displayNumbers) {
            this.m_crit = this.createPlainLabel(this.m_summaryComp, this.m_crit_str);
        } else {
            this.m_clickCritical.setToolTipText("Critical " + this.m_crit_str);
        }
    }

    public void checkSummeryWidth() {
        int CTabFolderWidth = this.getParent().getBounds().width;
        int lockImageWidth = this.calculateImageWidth(this.m_summary);
        int widthAvailable = CTabFolderWidth - lockImageWidth - 50;
        int widthNeeded = this.calculateCompWidth(this.m_summary) + 60;
        this.m_displayNumbers = true;
        if (widthAvailable < widthNeeded) {
            this.m_displayNumbers = false;
        }
    }

    public int calculateImageWidth(Composite parent) {
        int width = 0;
        Label l = this.createImageButton(parent, BMUI.IMAGE_UNLOCKED);
        l.pack();
        width = l.getBounds().width;
        l.dispose();
        return width;
    }

    public int calculateCompWidth(Composite parent) {
        this.updateMsgNumbers();
        int totalActualMessages = this.m_eventStorage.getTotalActualMessages();
        int totalAcknMessages = this.m_eventStorage.getTotalAcknMessages();
        String actual = "";
        String ackn = "";
        actual = totalActualMessages + "/" + (totalActualMessages - this.m_filtered);
        ackn = "" + totalAcknMessages;
        Composite tmpComp = new Composite(parent, 0);
        GridLayout gl = new GridLayout(26, false);
        gl.marginHeight = 0;
        gl.verticalSpacing = 0;
        tmpComp.setLayout((Layout)gl);
        tmpComp.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        this.createButton(tmpComp, "Active: ", "active", null);
        this.createPlainLabel(tmpComp, actual);
        this.createButton(tmpComp, "Closed: ", "closed", null);
        this.createPlainLabel(tmpComp, ackn);
        this.createImageButton(tmpComp, BMUI.IMAGE_UNKNOWN);
        this.createPlainLabel(tmpComp, "Selection: " + this.m_selCount);
        this.createPlainLabel(tmpComp, this.m_unkn_str);
        this.createPlainLabel(tmpComp, this.m_norm_str);
        this.createPlainLabel(tmpComp, this.m_warn_str);
        this.createPlainLabel(tmpComp, this.m_mino_str);
        this.createPlainLabel(tmpComp, this.m_majo_str);
        this.createPlainLabel(tmpComp, this.m_crit_str);
        tmpComp.pack();
        int widthComp = tmpComp.getClientArea().width;
        tmpComp.dispose();
        return widthComp;
    }

    public void createCM(Control ctrl, final String severity) {
        if (this.m_parent instanceof MessagesViewFolder) {
            Menu m = new Menu(ctrl);
            MenuItem mi = new MenuItem(m, -1);
            mi.setText("Open In New Window");
            ctrl.setMenu(m);
            mi.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    MessagesView.showMessagesForSeverity(severity, MessageBrowserTab.this.getEventProvider().isShowActive(), ((MessagesViewFolder)MessageBrowserTab.this.m_parent).getView());
                }
            });
        }
    }

    public void createCM_lock(Control ctrl) {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(false);
        Menu menu = menuMgr.createContextMenu(ctrl);
        ctrl.setMenu(menu);
        this.site.registerContextMenu(menuMgr, (ISelectionProvider)this.tableViewer);
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                try {
                    manager.add((IAction)new LockTableAction());
                }
                catch (RuntimeException runtimeException) {}
            }
        });
    }

    private Label createButton(Composite comp, String text, String data, Image img) {
        if (img != null) {
            Label imgL = new Label(comp, 0);
            imgL.setImage(img);
        }
        Label active2 = new Label(comp, 0);
        active2.setText(text);
        active2.setForeground(BMUI.color_black);
        active2.setData((Object)data);
        active2.addMouseListener((MouseListener)this);
        return active2;
    }

    protected Label createImageButton(Composite comp, Image img) {
        Label imgL = new Label(comp, 0);
        imgL.setImage(img);
        return imgL;
    }

    protected Label createPlainLabel(Composite comp, String text) {
        Label active2 = new Label(comp, 0);
        active2.setText(text);
        Label space = new Label(comp, 0);
        space.setSize(5, 5);
        return active2;
    }

    public void createTable(Composite parent) {
        Map<String, EventFilter> filters;
        int[] arr;
        Map<String, Integer> map;
        Composite comp = new Composite(parent, 0);
        GridLayout gl = new GridLayout(1, false);
        gl.horizontalSpacing = 0;
        gl.verticalSpacing = 0;
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        comp.setLayout((Layout)gl);
        comp.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        Table tbl = new Table(comp, 268503810);
        tbl.setData("TABLE_NAME", (Object)"MessageBrowserTable");
        tbl.setHeaderVisible(true);
        tbl.setLinesVisible(true);
        Map<String, Integer> colWidth = EventStorageUtils.defaultColumnWidth;
        if (!(this.isPredefinedTab() || this.isUserTab() || !this.isDefaultTab() && !this.isNewTab() || (map = UISettings.getInstance().getIB_GlobalColWidth()) == null || map.isEmpty())) {
            colWidth = map;
        }
        TableColumn col1 = new TableColumn(tbl, 16384, 0);
        String name = "Severity";
        col1.setData(COL_DEFAULT_NAME, (Object)name);
        col1.setText(this.m_browserLabelManager.getLabel(name));
        col1.setToolTipText(this.m_browserLabelManager.getToolTipLong(name));
        col1.setWidth(colWidth.get(name).intValue());
        col1.addListener(13, this.sortListener);
        col1.setMoveable(true);
        TableColumn col2 = new TableColumn(tbl, 16384, 1);
        name = "Duplicates";
        col2.setData(COL_DEFAULT_NAME, (Object)name);
        col2.setText(this.m_browserLabelManager.getLabel(name));
        col2.setToolTipText(this.m_browserLabelManager.getToolTipLong(name));
        col2.setWidth(colWidth.get(name).intValue());
        col2.addListener(13, this.sortListener);
        col2.setMoveable(true);
        TableColumn col3 = new TableColumn(tbl, 16384, 2);
        name = "Time";
        col3.setData(COL_DEFAULT_NAME, (Object)name);
        col3.setText(this.m_browserLabelManager.getLabel(name));
        col3.setToolTipText(this.m_browserLabelManager.getToolTipLong(name));
        col3.setWidth(colWidth.get(name).intValue());
        col3.addListener(13, this.sortListener);
        col3.setMoveable(true);
        TableColumn col4 = new TableColumn(tbl, 16384, 3);
        name = "Host";
        col4.setData(COL_DEFAULT_NAME, (Object)name);
        col4.setText(this.m_browserLabelManager.getLabel(name));
        col4.setToolTipText(this.m_browserLabelManager.getToolTipLong(name));
        col4.setWidth(colWidth.get(name).intValue());
        col4.addListener(13, this.sortListener);
        col4.setMoveable(true);
        TableColumn col5 = new TableColumn(tbl, 16384, 4);
        name = "Application";
        col5.setData(COL_DEFAULT_NAME, (Object)name);
        col5.setText(this.m_browserLabelManager.getLabel(name));
        col5.setToolTipText(this.m_browserLabelManager.getToolTipLong(name));
        col5.setWidth(colWidth.get(name).intValue());
        col5.addListener(13, this.sortListener);
        col5.setMoveable(true);
        TableColumn col6 = new TableColumn(tbl, 16384, 5);
        name = "Group";
        col6.setData(COL_DEFAULT_NAME, (Object)name);
        col6.setText(this.m_browserLabelManager.getLabel(name));
        col6.setToolTipText(this.m_browserLabelManager.getToolTipLong(name));
        col6.setWidth(colWidth.get(name).intValue());
        col6.addListener(13, this.sortListener);
        col6.setMoveable(true);
        TableColumn col7 = new TableColumn(tbl, 16384, 6);
        name = "Object";
        col7.setData(COL_DEFAULT_NAME, (Object)name);
        col7.setText(this.m_browserLabelManager.getLabel(name));
        col7.setToolTipText(this.m_browserLabelManager.getToolTipLong(name));
        col7.setWidth(colWidth.get(name).intValue());
        col7.addListener(13, this.sortListener);
        col7.setMoveable(true);
        TableColumn col8 = new TableColumn(tbl, 16384, 7);
        name = "Text";
        col8.setData(COL_DEFAULT_NAME, (Object)name);
        col8.setText(this.m_browserLabelManager.getLabel(name));
        col8.setToolTipText(this.m_browserLabelManager.getToolTipLong(name));
        col8.setWidth(colWidth.get(name).intValue());
        col8.addListener(13, this.sortListener);
        col8.setMoveable(true);
        TableColumn col9 = new TableColumn(tbl, 16384, 8);
        name = "J";
        col9.setData(COL_DEFAULT_NAME, (Object)name);
        col9.setText(this.m_browserLabelManager.getLabel(name));
        col9.setToolTipText(this.m_browserLabelManager.getToolTipLong(name));
        col9.setWidth(colWidth.get(name).intValue());
        col9.addListener(13, this.sortListener);
        col9.setMoveable(true);
        TableColumn col10 = new TableColumn(tbl, 16384, 9);
        name = "AA";
        col10.setData(COL_DEFAULT_NAME, (Object)name);
        col10.setText(this.m_browserLabelManager.getLabel(name));
        col10.setToolTipText(this.m_browserLabelManager.getToolTipLong(name));
        col10.setWidth(colWidth.get(name).intValue());
        col10.addListener(13, this.sortListener);
        col10.setMoveable(true);
        TableColumn col11 = new TableColumn(tbl, 16384, 10);
        name = "!AV";
        col11.setData(COL_DEFAULT_NAME, (Object)name);
        col11.setText(this.m_browserLabelManager.getLabel(name));
        col11.setWidth(colWidth.get(name).intValue());
        col11.setToolTipText(this.m_browserLabelManager.getToolTipLong(name));
        col11.addListener(13, this.sortListener);
        col11.setMoveable(true);
        TableColumn col12 = new TableColumn(tbl, 16384, 11);
        name = "^KPI";
        col12.setData(COL_DEFAULT_NAME, (Object)name);
        col12.setText(this.m_browserLabelManager.getLabel(name));
        col12.setWidth(colWidth.get(name).intValue());
        col12.setToolTipText(this.m_browserLabelManager.getToolTipLong(name));
        col12.addListener(13, this.sortListener);
        col12.setMoveable(true);
        TableColumn col13 = new TableColumn(tbl, 16384, 12);
        name = "Agent";
        col13.setData(COL_DEFAULT_NAME, (Object)name);
        col13.setText(this.m_browserLabelManager.getLabel(name));
        col13.setToolTipText(this.m_browserLabelManager.getToolTipLong(name));
        col13.setWidth(colWidth.get(name).intValue());
        col13.addListener(13, this.sortListener);
        col13.setMoveable(true);
        TableColumn col14 = new TableColumn(tbl, 16384, 13);
        name = "Source";
        col14.setData(COL_DEFAULT_NAME, (Object)name);
        col14.setText(this.m_browserLabelManager.getLabel(name));
        col14.setWidth(colWidth.get(name).intValue());
        col14.setData(DEF_WIDTH, (Object)120);
        col14.setToolTipText(this.m_browserLabelManager.getToolTipLong(name));
        col14.addListener(13, this.sortListener);
        col14.setMoveable(true);
        TableColumn col15 = new TableColumn(tbl, 16384, 14);
        name = "SrvTime";
        col15.setData(COL_DEFAULT_NAME, (Object)name);
        col15.setText(this.m_browserLabelManager.getLabel(name));
        col15.setWidth(colWidth.get(name).intValue());
        col15.setToolTipText(this.m_browserLabelManager.getToolTipLong(name));
        col15.addListener(13, this.sortListener);
        col15.setMoveable(true);
        tbl.setSortColumn(col15);
        TableColumn col16 = new TableColumn(tbl, 16384, 15);
        name = "ID";
        col16.setData(COL_DEFAULT_NAME, (Object)name);
        col16.setText(this.m_browserLabelManager.getLabel(name));
        col16.setWidth(colWidth.get(name).intValue());
        col16.setData(DEF_WIDTH, (Object)120);
        col16.setToolTipText(this.m_browserLabelManager.getToolTipLong(name));
        col16.addListener(13, this.sortListener);
        col16.setMoveable(true);
        int i = 1;
        while (i <= 15) {
            TableColumn tCA = new TableColumn(tbl, 16384);
            name = "CA" + i;
            tCA.setData(COL_DEFAULT_NAME, (Object)name);
            tCA.setText(this.m_browserLabelManager.getLabel(name));
            tCA.setWidth(colWidth.get(name).intValue());
            tCA.setData(DEF_WIDTH, (Object)80);
            tCA.setToolTipText(this.m_browserLabelManager.getToolTipLong(name));
            tCA.addListener(13, this.sortListener);
            tCA.setMoveable(true);
            ++i;
        }
        TableColumn col31 = new TableColumn(tbl, 16384, 31);
        name = "Owned";
        col31.setData(COL_DEFAULT_NAME, (Object)name);
        col31.setText(this.m_browserLabelManager.getLabel(name));
        col31.setToolTipText(this.m_browserLabelManager.getToolTipLong(name));
        col31.setWidth(colWidth.get(name).intValue());
        col31.addListener(13, this.sortListener);
        col31.setMoveable(true);
        TableColumn col32 = new TableColumn(tbl, 16384, 32);
        name = "Notifications";
        col32.setData(COL_DEFAULT_NAME, (Object)name);
        col32.setText(this.m_browserLabelManager.getLabel(name));
        col32.setToolTipText(this.m_browserLabelManager.getToolTipLong(name));
        col32.setWidth(colWidth.get(name).intValue());
        col32.addListener(13, this.sortListener);
        col32.setMoveable(true);
        TableColumn colOPClosed = new TableColumn(tbl, 16384, 33);
        name = "O";
        colOPClosed.setData(COL_DEFAULT_NAME, (Object)name);
        colOPClosed.setText(this.m_browserLabelManager.getLabel(name));
        colOPClosed.setToolTipText(this.m_browserLabelManager.getToolTipLong(name));
        colOPClosed.setWidth(colWidth.get(name).intValue());
        colOPClosed.addListener(13, this.sortListener);
        colOPClosed.setMoveable(true);
        TableColumn col33 = new TableColumn(tbl, 16384, 34);
        name = "Key";
        col33.setData(COL_DEFAULT_NAME, (Object)name);
        col33.setText(this.m_browserLabelManager.getLabel(name));
        col33.setWidth(colWidth.get(name).intValue());
        col33.setToolTipText(this.m_browserLabelManager.getToolTipLong(name));
        col33.addListener(13, this.sortListener);
        col33.setMoveable(true);
        tbl.setSortColumn(col33);
        TableColumn col34 = new TableColumn(tbl, 16384, 35);
        name = "SlaveServerName";
        col34.setData(COL_DEFAULT_NAME, (Object)name);
        col34.setText(this.m_browserLabelManager.getLabel(name));
        col34.setWidth(colWidth.get(name).intValue());
        col34.setToolTipText(this.m_browserLabelManager.getToolTipLong(name));
        col34.addListener(13, this.sortListener);
        col34.setMoveable(true);
        tbl.setSortColumn(col34);
        TableColumn col35 = new TableColumn(tbl, 16384, 36);
        name = "AgentID";
        col35.setData(COL_DEFAULT_NAME, (Object)name);
        col35.setText(this.m_browserLabelManager.getLabel(name));
        col35.setWidth(colWidth.get(name).intValue());
        col35.setToolTipText(this.m_browserLabelManager.getToolTipLong(name));
        col35.addListener(13, this.sortListener);
        col35.setMoveable(true);
        tbl.setSortColumn(col35);
        GridData data0 = new GridData(4, 4, true, true);
        data0.heightHint = 450;
        tbl.setLayoutData((Object)data0);
        this.tableViewer = new BTableViewer(tbl);
        this.tableViewer.setData("VIEWER_TYPE", "");
        this.tableViewer.setSorter(this.m_eventSorter);
        this.tableViewer.setContentProvider((IContentProvider)this.m_eventStorage);
        this.tableViewer.setComparer(this.m_eventSorter);
        this.tableViewer.setUseHashlookup(true);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)this.m_eventStorage);
        this.tableViewer.setInput(this.m_eventStorage.getElements(null));
        this.tableViewer.addDoubleClickListener(this);
        this.tableViewer.setData("SUMMARY", (Object)this);
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StructuredSelection ssel = (StructuredSelection)MessageBrowserTab.this.tableViewer.getSelection();
                int newSelCount = ssel.size();
                if (newSelCount > 5000) {
                    MessageBrowserTab.this.setTableLocked(true, false);
                } else {
                    MessageBrowserTab.this.setTableLocked(false, false);
                }
                if (newSelCount != MessageBrowserTab.this.m_selCount) {
                    MessageBrowserTab.this.m_selCount = newSelCount;
                    MessageBrowserTab.this.m_selCountLabel.setText("Selected: " + MessageBrowserTab.this.m_selCount);
                    MessageBrowserTab.this.m_summaryComp.pack();
                }
            }
        });
        this.m_eventStorage.enable(true);
        int[] colOrder = EventStorageUtils.defaultColumnOrder;
        if (!this.isPredefinedTab() && !this.isUserTab() && (this.isDefaultTab() || this.isNewTab()) && (arr = UISettings.getInstance().getIB_GlobalColOrder()) != null && arr.length == tbl.getColumnCount()) {
            colOrder = arr;
        }
        try {
            tbl.setColumnOrder(colOrder);
        }
        catch (Throwable e) {
            tbl.setColumnOrder(EventStorageUtils.defaultColumnOrder);
            RTLogger.print(4, "", e);
        }
        String sortCol = "SrvTime";
        int sortDir = 1024;
        if (!(this.isSimTab() || this.isPredefinedTab() || this.isUserTab() || !this.isDefaultTab() && !this.isNewTab())) {
            sortCol = UISettings.getInstance().getIB_GlobalSortCol();
            String dir = UISettings.getInstance().getIB_GlobalSortDir();
            if (dir.equalsIgnoreCase(UISettings.UP)) {
                sortDir = 128;
            }
            this.m_eventSorter.setConfig(sortCol, sortDir);
            ViewFilterAction.addSorter(this.tableViewer, this.m_eventSorter);
            this.tableViewer.refresh();
        }
        if (!(this.isSimTab() || this.isPredefinedTab() || this.isUserTab() || !this.isDefaultTab() && !this.isNewTab() || (filters = UISettings.getInstance().getIB_PredefinedGlobalFilters()) == null)) {
            for (EventFilter ef : filters.values()) {
                if (ef.m_tv == null) {
                    ef.m_tv = this.tableViewer;
                }
                ViewFilterAction.addFilter((Object)this, this.tableViewer, ef);
            }
        }
        this.setColors();
        this.createContentMenu();
    }

    public void createContentMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(false);
        Menu menu = menuMgr.createContextMenu(this.tableViewer.getControl());
        this.tableViewer.getControl().setMenu(menu);
        this.tableViewer.getControl().addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                if ((e.character == 'C' || e.character == 'c' || e.character == '\u007f') && (e.stateMask & 0x40000) == 0) {
                    if (Repository.getInstance().getRights(1000) < 3) {
                        return;
                    }
                    StructuredSelection ssel = (StructuredSelection)MessageBrowserTab.this.tableViewer.getSelection();
                    Iterator iter = ssel.iterator();
                    if (MessageBrowserTab.this.m_eventStorage.isShowActive()) {
                        AcknowledgeAction a = new AcknowledgeAction(MessageBrowserTab.this.tableViewer, iter, MessageBrowserTab.this.isOutage());
                        a.run();
                    } else {
                        ArchiveMessagesAction a = new ArchiveMessagesAction(MessageBrowserTab.this.site.getWorkbenchWindow(), MessageBrowserTab.this.tableViewer, iter, MessageBrowserTab.this.isOutage());
                        a.run();
                    }
                } else if ((e.character == 's' || e.character == 'S') && (e.stateMask & 0x40000) == 0) {
                    ViewAckMessagesAction a = new ViewAckMessagesAction(MessageBrowserTab.this.tab, MessageBrowserTab.this.tableViewer, MessageBrowserTab.this.m_eventStorage);
                    a.run();
                } else if (Repository.getInstance().getRights(1000) >= 3 && (e.character == 'o' || e.character == 'O') && (e.stateMask & 0x40000) == 0) {
                    MessageBrowserTab.this.own();
                } else if (Repository.getInstance().getRights(1000) >= 3 && (e.character == 'd' || e.character == 'D') && (e.stateMask & 0x40000) == 0) {
                    MessageBrowserTab.this.disown();
                }
            }
        });
        this.site.registerContextMenu(menuMgr, (ISelectionProvider)this.tableViewer);
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                try {
                    SEventFwd firstElement = null;
                    StructuredSelection ssel = (StructuredSelection)MessageBrowserTab.this.tableViewer.getSelection();
                    if (!ssel.isEmpty() && ssel.getFirstElement() instanceof SEvent) {
                        firstElement = (SEventFwd)ssel.getFirstElement();
                        manager.add((IAction)new OpenIndication(ssel));
                        if (firstElement.getSource().startsWith("Message")) {
                            manager.add((IAction)new AddIndicationConditionAction(ssel));
                        }
                        manager.add((IContributionItem)new Separator());
                        manager.add((IAction)new ExportIndicationAction(ssel));
                        manager.add((IAction)new ExportIndiCSVAction(ssel));
                        manager.add((IContributionItem)new Separator());
                    }
                    if (MessageBrowserTab.this.m_eventStorage != null) {
                        Iterator iter = ssel.iterator();
                        if (!ssel.isEmpty() && firstElement != null) {
                            manager.add((IContributionItem)new Separator());
                            manager.add((IAction)new PushIndi2NotiAction(MessageBrowserTab.this.tableViewer, iter));
                            FastAndRemoteActions fastAndRemoteActions = new FastAndRemoteActions(manager, MessageBrowserTab.this.m_parent.getShell(), MessageBrowserTab.this.tableViewer, firstElement, ssel.size());
                            if (fastAndRemoteActions.selectionContainsRunnableAgents(ssel)) {
                                fastAndRemoteActions.addActions();
                            }
                            manager.add((IContributionItem)new Separator());
                            if (MessageBrowserTab.this.m_eventStorage.isShowActive()) {
                                manager.add((IAction)new AcknowledgeAction(MessageBrowserTab.this.tableViewer, iter, MessageBrowserTab.this.isOutage()));
                                manager.add((IAction)new ArchiveMessagesAction(MessageBrowserTab.this.site.getWorkbenchWindow(), MessageBrowserTab.this.tableViewer, iter, MessageBrowserTab.this.isOutage()));
                            } else {
                                manager.add((IAction)new ArchiveMessagesAction(MessageBrowserTab.this.site.getWorkbenchWindow(), MessageBrowserTab.this.tableViewer, iter, MessageBrowserTab.this.isOutage()));
                                manager.add((IAction)new ReopenMessagesAction(MessageBrowserTab.this.site.getWorkbenchWindow(), MessageBrowserTab.this.tableViewer, iter, MessageBrowserTab.this.isOutage()));
                            }
                            if (firstElement.getMonitor().length() > 1 || firstElement.getTypeA() > 0) {
                                manager.add((IContributionItem)new Separator());
                                manager.add((IAction)new MonitorHistoryAction(iter, 0, MessageBrowserTab.this.m_eventStorage));
                                manager.add((IAction)new MonitorHistoryAction(iter, 1, MessageBrowserTab.this.m_eventStorage));
                            }
                            final SEventFwd se = firstElement;
                            manager.add((IContributionItem)new Separator());
                            manager.add((IAction)new Action(){

                                public ImageDescriptor getImageDescriptor() {
                                    return BMUI.IMAGE_DESCR_NAG;
                                }

                                public boolean isEnabled() {
                                    if (Repository.getInstance().getRights(1001) <= 1) {
                                        return false;
                                    }
                                    return se != null && !se.getSource().equals("BOOM_SERVER");
                                }

                                public String getText() {
                                    String text = "Show Policy/Condition";
                                    if (Repository.getInstance().getRights(1001) < 3) {
                                        text = "Show Policy/Condition (read-only)";
                                    }
                                    return text;
                                }

                                public void run() {
                                    PolicyView.displayPolicyEXT(se);
                                }
                            });
                            AgentCard ac = Repository.getInstance().getAgentCard(se.getT1());
                            manager.add((IAction)new ShowAssignedPoliciesAction(ac));
                            manager.add((IAction)new Action(){

                                public boolean isEnabled() {
                                    int rightToCheck;
                                    int n = rightToCheck = MessageBrowserTab.this.isOutage() ? 2016 : 1000;
                                    return Repository.getInstance().getRights(rightToCheck) >= 3;
                                }

                                public String getText() {
                                    String text = "Own";
                                    return text;
                                }

                                public void run() {
                                    MessageBrowserTab.this.own();
                                }
                            });
                            manager.add((IAction)new Action(){

                                public boolean isEnabled() {
                                    int rightToCheck;
                                    int n = rightToCheck = MessageBrowserTab.this.isOutage() ? 2016 : 1000;
                                    return Repository.getInstance().getRights(rightToCheck) >= 3;
                                }

                                public String getText() {
                                    String text = "Disown";
                                    return text;
                                }

                                public void run() {
                                    MessageBrowserTab.this.disown();
                                }
                            });
                        }
                        manager.add((IContributionItem)new Separator("Switch view"));
                        ViewAckMessagesAction switchAction = new ViewAckMessagesAction(MessageBrowserTab.this.tab, MessageBrowserTab.this.tableViewer, MessageBrowserTab.this.m_eventStorage);
                        manager.add((IAction)switchAction);
                    }
                    manager.add((IContributionItem)new Separator("Filters"));
                    ViewFilterAction newFilterAction = new ViewFilterAction(MessageBrowserTab.this.tab, MessageBrowserTab.this, MessageBrowserTab.this.tableViewer, null, null, false, MessageBrowserTab.this.getText());
                    manager.add((IAction)newFilterAction);
                    Iterator<EventFilter> it = ViewFilterAction.getActiveFiltersIterator(MessageBrowserTab.this.tableViewer);
                    while (it.hasNext()) {
                        EventFilter ef = it.next();
                        ViewFilterAction action = new ViewFilterAction(MessageBrowserTab.this.tab, MessageBrowserTab.this, MessageBrowserTab.this.tableViewer, ef, ef.getLabelOrName(), ef.m_isActive, MessageBrowserTab.this.tab.getText());
                        manager.add((IAction)action);
                    }
                    if (ssel.size() == 1) {
                        final SEventFwd sef = firstElement;
                        Action filterSimilar = new Action("Filter similar Indications"){
                            private EventFilter m_efApp;
                            private EventFilter m_efGrp;
                            private EventFilter m_efObj;
                            {
                                super($anonymous0);
                                this.m_efApp = null;
                                this.m_efGrp = null;
                                this.m_efObj = null;
                            }

                            public void run() {
                                ViewFilterAction.addFilter(null, (this).MessageBrowserTab.this.tableViewer, this.m_efObj);
                                ViewFilterAction.addFilter(null, (this).MessageBrowserTab.this.tableViewer, this.m_efGrp);
                                ViewFilterAction.addFilter((Object)(this).MessageBrowserTab.this.tab, (this).MessageBrowserTab.this.tableViewer, this.m_efApp);
                                UISettings.getInstance().storeAndReload();
                            }

                            public boolean isEnabled() {
                                if (!UISettings.getInstance().IB_canModifyFilters()) {
                                    return false;
                                }
                                if (sef.getApplication().length() > 0) {
                                    this.m_efApp = new EventFilter(null, "Application", sef.getApplication(), false, 4, (this).MessageBrowserTab.this.tableViewer, false, 0, 0);
                                }
                                if (sef.getGroup().length() > 0) {
                                    this.m_efGrp = new EventFilter(null, "Group", sef.getGroup(), false, 4, (this).MessageBrowserTab.this.tableViewer, false, 0, 0);
                                }
                                if (sef.getObject().length() > 0) {
                                    this.m_efObj = new EventFilter(null, "Object", sef.getObject(), false, 4, (this).MessageBrowserTab.this.tableViewer, false, 0, 0);
                                }
                                if (ViewFilterAction.hasFilter((this).MessageBrowserTab.this.tableViewer, this.m_efApp)) {
                                    this.m_efApp = null;
                                }
                                if (ViewFilterAction.hasFilter((this).MessageBrowserTab.this.tableViewer, this.m_efGrp)) {
                                    this.m_efGrp = null;
                                }
                                if (ViewFilterAction.hasFilter((this).MessageBrowserTab.this.tableViewer, this.m_efObj)) {
                                    this.m_efObj = null;
                                }
                                return this.m_efObj != null || this.m_efGrp != null || this.m_efApp != null;
                            }
                        };
                        manager.add((IAction)filterSimilar);
                    }
                    DeleteAllFiltersAction df = new DeleteAllFiltersAction(MessageBrowserTab.this.tab, MessageBrowserTab.this.tableViewer);
                    manager.add((IAction)df);
                    manager.add((IAction)new DisableEnableAllFilters(MessageBrowserTab.this.tab, MessageBrowserTab.this.tableViewer, false));
                    manager.add((IAction)new DisableEnableAllFilters(MessageBrowserTab.this.tab, MessageBrowserTab.this.tableViewer, true));
                    final ArrayList<TableColumn> selectedElements = new ArrayList<TableColumn>();
                    TableColumn[] tableColumnArray = MessageBrowserTab.this.tableViewer.getTable().getColumns();
                    int n = tableColumnArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TableColumn tc = tableColumnArray[n2];
                        if (tc.getWidth() != 0) {
                            selectedElements.add(tc);
                        }
                        ++n2;
                    }
                    final ShowHideColumnsDialog dialog = new ShowHideColumnsDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), MessageBrowserTab.this.tableViewer);
                    dialog.setInitialSelections(selectedElements.toArray());
                    if (!MessageBrowserTab.this.hasDefault) {
                        dialog.setDefaultColumns(selectedElements);
                        MessageBrowserTab.this.hasDefault = true;
                    }
                    manager.add((IAction)new Action(){

                        public boolean isEnabled() {
                            return true;
                        }

                        public boolean isChecked() {
                            return true;
                        }

                        public String getText() {
                            String text = "Show/Hide Columns";
                            return text;
                        }

                        public void run() {
                            dialog.open();
                            Object[] results = dialog.getResult();
                            selectedElements.clear();
                            if (results != null) {
                                int i = 0;
                                while (i < results.length) {
                                    selectedElements.add((TableColumn)results[i]);
                                    ++i;
                                }
                                TableColumn[] tableColumnArray = (this).MessageBrowserTab.this.tableViewer.getTable().getColumns();
                                int n = tableColumnArray.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    TableColumn tc = tableColumnArray[n2];
                                    if (tc.getWidth() != 0 && !selectedElements.contains(tc)) {
                                        tc.setData(MessageBrowserTab.DEF_WIDTH, (Object)tc.getWidth());
                                        tc.setWidth(0);
                                        tc.setResizable(false);
                                    } else if (tc.getWidth() == 0 && selectedElements.contains(tc)) {
                                        Integer w = (Integer)tc.getData(MessageBrowserTab.DEF_WIDTH);
                                        if (w == null) {
                                            tc.setWidth(100);
                                        } else {
                                            tc.setWidth(w.intValue());
                                        }
                                        tc.setResizable(true);
                                    }
                                    ++n2;
                                }
                                UISettings.getInstance().storeAndReload();
                                MessageBrowserTab.this.runQuickFilter();
                            }
                        }
                    });
                    if (BMUI.m_ignoreClosedIndications || BMUI.m_ignoreAllIndications) {
                        if (!MessageBrowserTab.this.m_eventStorage.isShowActive()) {
                            manager.add((IContributionItem)new Separator("Ignore closed indication mode"));
                            manager.add((IAction)new LoadClosedIndicationsFiltered(ViewFilterAction.getFilters(MessageBrowserTab.this.tableViewer)));
                            manager.add((IAction)new UnloadClosedIndications(ViewFilterAction.getFilters(MessageBrowserTab.this.tableViewer)));
                        } else if (BMUI.m_ignoreAllIndications) {
                            manager.add((IContributionItem)new Separator("Ignore All indication mode"));
                            manager.add((IAction)new LoadActiveIndicationsFiltered(ViewFilterAction.getFilters(MessageBrowserTab.this.tableViewer)));
                            manager.add((IAction)new UnloadActiveIndications(ViewFilterAction.getFilters(MessageBrowserTab.this.tableViewer)));
                        }
                    }
                }
                catch (RuntimeException e) {
                    RTLogger.print(4, "", e);
                }
            }
        });
    }

    public boolean isTableLockedManually() {
        return this.m_isLockedManual && this.m_isLocked;
    }

    public void setTableLocked(boolean b, boolean manual) {
        if (this.m_isLockedManual && !manual) {
            return;
        }
        if (this.m_isLocked == b) {
            return;
        }
        this.m_isLocked = b;
        this.m_isLockedManual = this.m_isLocked ? manual : false;
        if (b) {
            this.tableViewer.setBusy(b);
        } else {
            boolean wasBusy = this.tableViewer.isBusy();
            this.tableViewer.setBusy(b);
            if (wasBusy) {
                this.tableViewer.setInput(((IStructuredContentProvider)this.tableViewer.getContentProvider()).getElements(null));
            }
        }
        if (b) {
            this.m_isLocked_label.setImage(BMUI.IMAGE_LOCKED);
            this.m_isLocked_label.setData((Object)LOCKED);
            this.m_isLocked_label.setToolTipText("Table is locked and will not be refreshed!");
        } else {
            this.m_isLocked_label.setImage(BMUI.IMAGE_UNLOCKED);
            this.m_isLocked_label.setData((Object)UNLOCKED);
            this.m_isLocked_label.setToolTipText("Table is unlocked");
        }
    }

    public void updateImage() {
        if (ViewFilterAction.hasActiveFilter(this.tableViewer)) {
            this.setImage(BMUI.IMAGE_FILTERED);
        } else {
            this.setImage(null);
        }
    }

    public boolean isShowing() {
        this.createSummary();
        return super.isShowing();
    }

    public void doubleClick(DoubleClickEvent event) {
        StructuredSelection ssel = (StructuredSelection)event.getSelection();
        if (!ssel.isEmpty()) {
            SEvent se = (SEvent)ssel.getFirstElement();
            OpenIndication action = new OpenIndication(se);
            action.run();
        }
    }

    public ITableBrowserProvider getEventProvider() {
        return this.m_eventStorage;
    }

    public IEventsSummary getEventsSummary() {
        return this.m_eventsSummary;
    }

    public EventSorter getEventSorter() {
        return this.m_eventSorter;
    }

    public BTableViewer getTableViewer() {
        return this.tableViewer;
    }

    public void mouseDoubleClick(MouseEvent e) {
        if (e.getSource() instanceof Label) {
            Label l = (Label)e.getSource();
            String data = (String)l.getData();
            if (this.m_parent instanceof MessagesViewFolder) {
                if (data.equalsIgnoreCase("active")) {
                    if (MessagesView.isTabOpen("[Active]", this.m_parent)) {
                        return;
                    }
                    MessageBrowserTab mtb = new MessageBrowserTab(((MessagesViewFolder)this.m_parent).getView().getSite(), this.m_parent, 64, this.m_parent.getItemCount(), null, true, NEW_TAB, null);
                    this.m_parent.setSelection((CTabItem)mtb);
                } else if (data.equalsIgnoreCase("closed")) {
                    if (MessagesView.isTabOpen("[Closed]", this.m_parent)) {
                        return;
                    }
                    MessageBrowserTab mtb = new MessageBrowserTab(((MessagesViewFolder)this.m_parent).getView().getSite(), this.m_parent, 64, this.m_parent.getItemCount(), null, false, NEW_TAB, null);
                    this.m_parent.setSelection((CTabItem)mtb);
                } else {
                    String title = "(" + data + ")" + "[Active]";
                    if (MessagesView.isTabOpen(title, this.m_parent)) {
                        return;
                    }
                    MessagesView.showMessagesForSeverity(data, this.getEventProvider().isShowActive(), ((MessagesViewFolder)this.m_parent).getView());
                }
            }
        }
    }

    public void mouseDown(MouseEvent e) {
    }

    public void mouseUp(MouseEvent e) {
    }

    public void dispose() {
        MessagesView view;
        String secID;
        if (this.m_eventStorage != null) {
            this.m_eventStorage.getEventProvider().removeTableFromRefresh(this.tableViewer);
            ViewFilterAction.removeFiltersForTable((Object)this, this.tableViewer);
        }
        try {
            this.m_top_composite.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_summary.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_summaryComp.dispose();
        }
        catch (Throwable throwable) {}
        super.dispose();
        CTabItem[] items = this.m_parent.getItems();
        if (items.length == 0 && this.m_parent instanceof MessagesViewFolder && (secID = (view = ((MessagesViewFolder)this.m_parent).m_msgView).getSecondaryID()) != null && secID.equalsIgnoreCase("MsgView2")) {
            MessagesView.m_object = view;
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().hideView((IViewPart)view);
        }
        UISettings.getInstance().storeAndReload();
    }

    public void setDefaultTab() {
        this.m_type = DEFAULT_TAB;
    }

    public void setPredefinedTab() {
        this.m_type = PREDEFINED_TAB;
    }

    public void setUserTab() {
        this.m_type = USER_TAB;
    }

    public void setNewTab() {
        this.m_type = NEW_TAB;
    }

    public boolean isDefaultTab() {
        return this.m_type.equals(DEFAULT_TAB);
    }

    public boolean isPredefinedTab() {
        return this.m_type.equals(PREDEFINED_TAB);
    }

    public boolean isUserTab() {
        return this.m_type.equals(USER_TAB);
    }

    public boolean isNewTab() {
        return this.m_type.equals(NEW_TAB);
    }

    public boolean isSimTab() {
        return this.m_type.equals(SIM_TAB);
    }

    public boolean isOutage() {
        return this.m_eventStorage != null && this.m_eventStorage.getType() == 1;
    }

    public String getType() {
        return this.m_type;
    }

    protected void disown() {
        StructuredSelection selection = (StructuredSelection)this.tableViewer.getSelection();
        if (!selection.isEmpty()) {
            LinkedList<String> list = new LinkedList<String>();
            for (SEvent se : selection) {
                list.add(se.getID());
            }
            String[] ids = list.toArray(new String[0]);
            ServerClient sc = new ServerClient("CMD_DISOWN", Repository.m_user, ids);
            sc.start();
            this.tableViewer.setSelection(null);
        }
    }

    private void own() {
        StructuredSelection selection = (StructuredSelection)this.tableViewer.getSelection();
        if (!selection.isEmpty()) {
            LinkedList<String> list = new LinkedList<String>();
            for (SEvent se : selection) {
                list.add(se.getID());
            }
            String[] ids = list.toArray(new String[0]);
            ServerClient sc = new ServerClient("CMD_OWN", Repository.m_user, ids);
            sc.start();
            this.tableViewer.setSelection(null);
        }
    }

    public void checkTitle() {
        String title = this.getText();
        title = title.replace("[Active]", "");
        title = title.replace("[Closed]", "");
        title = this.m_eventStorage.isShowActive() ? String.valueOf(title) + "[Active]" : String.valueOf(title) + "[Closed]";
        int browserType = this.m_eventStorage.getType();
        if (1 == browserType) {
            this.setFont(BMUI.font_arial8_italic);
        }
        this.setText(title);
    }

    public void setColors() {
        this.m_backgroundTableOutageActive = UISettings.getInstance().getIB_BackgroundColors(1, true);
        this.m_backgroundTableOutageClosed = UISettings.getInstance().getIB_BackgroundColors(1, false);
        this.m_backgroundTableNormalActive = UISettings.getInstance().getIB_BackgroundColors(0, true);
        this.m_backgroundTableNormalClosed = UISettings.getInstance().getIB_BackgroundColors(0, false);
        if (this.tableViewer != null && this.tableViewer.getTable() != null && !this.tableViewer.getTable().isDisposed()) {
            int browserType = this.m_eventStorage.getType();
            boolean showActive = this.m_eventStorage.isShowActive();
            if (1 == browserType) {
                if (showActive) {
                    this.tableViewer.getTable().setBackground(this.m_backgroundTableOutageActive);
                } else {
                    this.tableViewer.getTable().setBackground(this.m_backgroundTableOutageClosed);
                }
            } else if (browserType == 0) {
                if (showActive) {
                    this.tableViewer.getTable().setBackground(this.m_backgroundTableNormalActive);
                } else {
                    this.tableViewer.getTable().setBackground(this.m_backgroundTableNormalClosed);
                }
            }
            this.tableViewer.getTable().setForeground(this.m_foregroundTableColor);
        }
    }

    public void runQuickFilter() {
        this.m_quickFilter.runFilter();
    }

    public class LockTableAction
    extends Action {
        public LockTableAction() {
            super("Lock_Unlock_Table");
            this.setId("Lock_Unlock_Table");
            if (Repository.getInstance().getRights(1000) < 3) {
                this.setEnabled(false);
            }
            if (MessageBrowserTab.this.m_isLocked) {
                this.setText("Unlock Table");
            } else {
                this.setText("Lock Table");
            }
        }

        public void run() {
            if (MessageBrowserTab.this.m_isLocked) {
                if (MessageBrowserTab.this.m_selCount < 5000) {
                    MessageBrowserTab.this.setTableLocked(false, true);
                }
            } else {
                MessageBrowserTab.this.setTableLocked(true, true);
            }
            UISettings.getInstance().storeAndReload();
        }
    }

    private class OpenIndication
    extends Action {
        private List<SEvent> m_elements;

        public OpenIndication(StructuredSelection ssel) {
            super("OpenIndicationAction");
            this.m_elements = new ArrayList<SEvent>();
            this.setId("openIndication");
            this.setText("Open Indication");
            if (ssel.isEmpty() || ssel.size() > 30) {
                this.setEnabled(false);
            } else {
                for (SEvent se : ssel) {
                    this.m_elements.add(se);
                }
            }
            if (this.m_elements.size() == 0) {
                this.setEnabled(false);
            } else if (this.m_elements.size() > 1) {
                this.setText("Open Indications");
            }
        }

        public OpenIndication(SEvent se) {
            this.m_elements = new ArrayList<SEvent>();
            this.setId("openIndicationmsg");
            this.setText("Open Indication");
            if (se == null) {
                this.setEnabled(false);
            } else {
                this.m_elements.add(se);
            }
        }

        public void run() {
            int i = 0;
            while (i < this.m_elements.size()) {
                SEvent se = this.m_elements.get(i);
                MessageDetailsDialog dialog = ManageDialogAction.isIndicationDialogOpen(se.getID());
                if (dialog != null) {
                    dialog.activate();
                } else {
                    MessageDetailsDialog mdd = new MessageDetailsDialog(MessageBrowserTab.this.m_parent.getShell(), se, MessageBrowserTab.this.m_eventStorage);
                    mdd.open();
                    mdd.setTitles();
                }
                ++i;
            }
        }
    }
}

