/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.EventFilter;
import com.blixx.boom.engine.EventSorter;
import com.blixx.boom.engine.EventStorageUtils;
import com.blixx.boom.engine.JobManager;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.engine.UIJob;
import com.blixx.boom.gui.utils.GUIDisplayElements;
import com.blixx.boom.gui.utils.calendar.CalendarDialog;
import com.blixx.boom.gui.utils.calendar.SWTCalListener;
import com.blixx.boom.gui.views.BTableViewer;
import com.blixx.boom.gui.views.MessageBrowserTab;
import com.blixx.ctrl.sc.ICmdPostProcess;
import com.blixx.ctrl.sc.ServerClient;
import com.blixx.ctrl.sc.in.ScGetArchived;
import com.blixx.shared.SEvent;
import com.blixx.shared.utils.ArchiveDetails;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.Section;

public class MessageBrowserTabArch
extends MessageBrowserTab
implements IStructuredContentProvider,
ITableLabelProvider,
SelectionListener {
    public static final String RESET = " Reset Date ";
    private static final String WORKING = "...WORKING...";
    public static final String REFRESH = " Query ";
    public static final String PREVIOUS = " < ";
    public static final String NEXT = " > ";
    public static long DAY = 86400000L;
    public SimpleDateFormat m_sdf = new SimpleDateFormat("yyyy-MM-dd");
    protected Set<SEvent> m_events = new HashSet<SEvent>();
    boolean m_isSupported = true;
    protected long start = System.currentTimeMillis() - DAY;
    protected long finish = System.currentTimeMillis();
    protected int m_days = 7;
    protected Button m_next;
    protected Button m_prev;
    protected Button m_refresh;
    protected Button m_home;
    protected Label m_total;
    protected Text m_intervalDays;
    protected Label m_startLabel;
    protected Label m_finishLabel;
    protected String m_filter = "";
    private Composite m_compRight;
    private int m_restRecords = -1;
    private long m_minStime = -1L;
    protected Label m_restInArchive;
    protected Label mMinStime;
    private Button m_CheckSevUnknown;
    private Button m_CheckSevNormal;
    private Button m_CheckSevWarning;
    private Button m_CheckSevMinor;
    private Button m_CheckSevMajor;
    private Button m_CheckSevCritical;
    private GUIDisplayElements m_gde = new GUIDisplayElements();
    private Text m_hostFilter;
    private Text m_agentFilter;
    private Text m_groupFilter;
    private Text m_applFilter;
    private Text m_objectFilter;
    private Text m_textFilter;

    public MessageBrowserTabArch(IWorkbenchPartSite siteV, CTabFolder parent, int style, int position, String titleIfnecessary, boolean isActive) {
        super(parent, style);
        this.site = siteV;
        this.m_parent = parent;
        this.resetTime();
        this.m_top_composite = new Composite((Composite)parent, 2048);
        this.m_top_composite.setLayout((Layout)new GridLayout(1, false));
        this.m_top_composite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.m_eventSorter = new EventSorter("SrvTime", 1024);
        this.createTable(this.m_top_composite);
        this.tableViewer.getTable().setEnabled(false);
        this.createSummary();
        this.setControl((Control)this.m_top_composite);
        this.setText("[Archived]");
        this.tab = this;
    }

    private void resetTime() {
        this.m_days = 7;
        Calendar cal = Calendar.getInstance();
        cal.set(14, 0);
        cal.set(13, 0);
        cal.set(12, 0);
        cal.set(11, 0);
        cal.add(5, 1);
        this.finish = cal.getTimeInMillis();
        cal.add(5, -1 * this.m_days);
        this.start = cal.getTimeInMillis();
    }

    private void reload() {
        this.m_events.clear();
        this.tableViewer.refresh();
        this.tableViewer.getTable().setEnabled(false);
        if (this.m_total != null) {
            this.m_total.setText(WORKING);
            this.m_total.setForeground(BMUI.color_critical);
            this.m_compRight.pack();
        }
        this.setTimesRed();
        this.m_filter = this.getSeveritySQLWhere();
        if (this.m_hostFilter.getText().length() > 0) {
            this.m_filter = String.valueOf(this.m_filter) + " AND " + EventFilter.getSQLWhere("" + this.m_hostFilter.getData(), 3, this.m_hostFilter.getText());
        }
        if (this.m_agentFilter.getText().length() > 0) {
            this.m_filter = String.valueOf(this.m_filter) + " AND " + EventFilter.getSQLWhere("" + this.m_agentFilter.getData(), 3, this.m_agentFilter.getText());
        }
        if (this.m_groupFilter.getText().length() > 0) {
            this.m_filter = String.valueOf(this.m_filter) + " AND " + EventFilter.getSQLWhere("" + this.m_groupFilter.getData(), 3, this.m_groupFilter.getText());
        }
        if (this.m_applFilter.getText().length() > 0) {
            this.m_filter = String.valueOf(this.m_filter) + " AND " + EventFilter.getSQLWhere("" + this.m_applFilter.getData(), 3, this.m_applFilter.getText());
        }
        if (this.m_objectFilter.getText().length() > 0) {
            this.m_filter = String.valueOf(this.m_filter) + " AND " + EventFilter.getSQLWhere("" + this.m_objectFilter.getData(), 3, this.m_objectFilter.getText());
        }
        if (this.m_textFilter.getText().length() > 0) {
            this.m_filter = String.valueOf(this.m_filter) + " AND " + EventFilter.getSQLWhere("" + this.m_textFilter.getData(), 3, this.m_textFilter.getText());
        }
        final ScGetArchived scGetArchived = new ScGetArchived(Repository.getInstance(), this.start, this.finish, this.m_filter);
        scGetArchived.setTimeout(610000);
        scGetArchived.addCmdPostProcess(new ICmdPostProcess(){

            public void postProcess(final ServerClient sc) {
                if (!sc.isSupported()) {
                    UIJob uijob = new UIJob(Display.getDefault(), "Fetch Archived UI"){

                        @Override
                        public IStatus runInUIThread(IProgressMonitor monitor) {
                            MessageBrowserTabArch.this.setNotSupported();
                            return Status.OK_STATUS;
                        }
                    };
                    Repository.getUIJobManager().schedule(uijob);
                } else {
                    UIJob uijob = new UIJob(Display.getDefault(), "Fetch Archived UI"){

                        @Override
                        public IStatus runInUIThread(IProgressMonitor monitor) {
                            ArchiveDetails ad = ((ScGetArchived)sc).getResultObject();
                            MessageBrowserTabArch.this.processResult(ad, true);
                            return Status.OK_STATUS;
                        }
                    };
                    Repository.getUIJobManager().schedule(uijob);
                }
            }
        });
        JobManager.getInstance().schedule(scGetArchived);
        Job job = new Job("Fetch Archived Progress can be slow job"){

            public IStatus run(IProgressMonitor monitor) {
                int currentSize = 0;
                while (!scGetArchived.isFinished()) {
                    try {
                        ArchiveDetails ad = scGetArchived.getResultObject();
                        if (ad.m_events == null || currentSize == ad.m_events.size()) continue;
                        currentSize = ad.m_events.size();
                        UIJob uijob = new UIJob(Display.getDefault(), "Fetch Archived UI progress"){

                            @Override
                            public IStatus runInUIThread(IProgressMonitor monitor) {
                                ArchiveDetails ad = scGetArchived.getResultObject();
                                MessageBrowserTabArch.this.processResult(ad, false);
                                return Status.OK_STATUS;
                            }
                        };
                        Repository.getUIJobManager().schedule(uijob);
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    catch (Throwable throwable) {}
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
        this.m_summary.setEnabled(false);
    }

    private void setTimesRed() {
        String startDate = this.m_sdf.format(new Date(this.start));
        String finishDate = this.m_sdf.format(new Date(this.finish));
        this.m_startLabel.setForeground(BMUI.color_critical);
        this.m_startLabel.setText(startDate);
        this.m_finishLabel.setForeground(BMUI.color_critical);
        this.m_finishLabel.setText(finishDate);
    }

    @Override
    public void createSummary() {
        if (!this.m_isSupported) {
            return;
        }
        if (this.m_summary == null) {
            this.m_summary = new Composite(this.m_top_composite, 0);
            GridLayout gl = new GridLayout(1, false);
            gl.marginWidth = 0;
            gl.marginHeight = 0;
            this.m_summary.setLayout((Layout)gl);
            this.m_summary.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
            this.m_summaryComp = new Composite(this.m_summary, 0);
            GridLayout summaryLayout = new GridLayout(14, false);
            summaryLayout.marginWidth = 0;
            this.m_summaryComp.setLayout((Layout)summaryLayout);
            this.m_summaryComp.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
            this.m_compRight = new Composite(this.m_summary, 0);
            GridLayout rightLayout = new GridLayout(7, false);
            rightLayout.horizontalSpacing = 10;
            this.m_compRight.setLayout((Layout)rightLayout);
            this.m_compRight.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
            Composite btnComp = new Composite(this.m_summaryComp, 0);
            gl = new GridLayout(2, true);
            btnComp.setLayout((Layout)gl);
            gl.marginWidth = 0;
            gl.marginHeight = 0;
            gl.marginRight = 20;
            btnComp.setLayoutData((Object)new GridData(4, 4, false, false));
            this.m_home = new Button(btnComp, 0);
            this.m_home.setLayoutData((Object)new GridData(4, 4, true, false));
            this.m_home.setText(RESET);
            this.m_home.setData((Object)RESET);
            this.m_home.setToolTipText("Reset to Default");
            this.m_home.addSelectionListener((SelectionListener)this);
            this.m_refresh = new Button(btnComp, 0);
            this.m_refresh.setLayoutData((Object)new GridData(4, 4, true, false));
            this.m_refresh.setText(REFRESH);
            this.m_refresh.setData((Object)REFRESH);
            this.m_refresh.setToolTipText("Reload Indications");
            this.m_refresh.addSelectionListener((SelectionListener)this);
            this.createPlainLabel(this.m_summaryComp, "From:");
            Composite finishComp = new Composite(this.m_summaryComp, 0);
            gl = new GridLayout(3, false);
            gl.marginWidth = 0;
            gl.marginHeight = 0;
            gl.horizontalSpacing = 3;
            gl.marginRight = 15;
            finishComp.setLayout((Layout)gl);
            finishComp.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
            this.m_finishLabel = this.createPlainLabel(finishComp, "");
            this.m_finishLabel.setText("0000-00-00");
            this.m_finishLabel.setForeground(BMUI.color_blue);
            this.m_finishLabel.setToolTipText("From SrvTime and back to...");
            this.m_finishLabel.addListener(4, new Listener(){

                public void handleEvent(Event event) {
                    MessageBrowserTabArch.this.openFinishCalendar();
                }
            });
            Label finishCalIcon = new Label(finishComp, 0);
            finishCalIcon.setImage(BMUI.IMAGE_CALENDAR);
            finishCalIcon.addListener(4, new Listener(){

                public void handleEvent(Event event) {
                    MessageBrowserTabArch.this.openFinishCalendar();
                }
            });
            this.m_prev = new Button(this.m_summaryComp, 0);
            this.m_prev.setText(PREVIOUS);
            this.m_prev.setData((Object)PREVIOUS);
            this.m_prev.addSelectionListener((SelectionListener)this);
            GridData gdt = new GridData();
            gdt.widthHint = 30;
            gdt.horizontalIndent = 5;
            gdt.grabExcessVerticalSpace = true;
            this.m_intervalDays = new Text(this.m_summaryComp, 0);
            this.m_intervalDays.setText("" + this.m_days);
            this.m_intervalDays.setLayoutData((Object)gdt);
            this.m_intervalDays.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    try {
                        MessageBrowserTabArch.this.m_days = Integer.parseInt(MessageBrowserTabArch.this.m_intervalDays.getText());
                        MessageBrowserTabArch.this.start = MessageBrowserTabArch.this.finish - (long)MessageBrowserTabArch.this.m_days * DAY;
                        MessageBrowserTabArch.this.setTimesRed();
                    }
                    catch (NumberFormatException numberFormatException) {
                        MessageBrowserTabArch.this.m_intervalDays.setText("" + MessageBrowserTabArch.this.m_days);
                    }
                }
            });
            this.createPlainLabel(this.m_summaryComp, "days");
            this.m_next = new Button(this.m_summaryComp, 0);
            this.m_next.setText(NEXT);
            this.m_next.setData((Object)NEXT);
            this.m_next.addSelectionListener((SelectionListener)this);
            Label backTo_label = this.createPlainLabel(this.m_summaryComp, "Back to:");
            GridData gd = new GridData();
            gd.horizontalIndent = 15;
            backTo_label.setLayoutData((Object)gd);
            Composite startComp = new Composite(this.m_summaryComp, 0);
            gl = new GridLayout(3, false);
            gl.marginWidth = 0;
            gl.marginHeight = 0;
            gl.horizontalSpacing = 3;
            startComp.setLayout((Layout)gl);
            startComp.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
            this.m_startLabel = this.createPlainLabel(startComp, "");
            this.m_startLabel.setText("0000-00-00");
            this.m_startLabel.setToolTipText("Back to SrvTime");
            this.m_startLabel.setForeground(BMUI.color_blue);
            this.m_startLabel.addListener(4, new Listener(){

                public void handleEvent(Event event) {
                    MessageBrowserTabArch.this.openStartCalendar();
                }
            });
            Label startCalIcon = new Label(startComp, 0);
            startCalIcon.setImage(BMUI.IMAGE_CALENDAR);
            startCalIcon.addListener(4, new Listener(){

                public void handleEvent(Event event) {
                    MessageBrowserTabArch.this.openStartCalendar();
                }
            });
            gdt = new GridData();
            gdt.widthHint = 100;
            this.m_restInArchive = new Label(this.m_compRight, 0);
            this.mMinStime = new Label(this.m_compRight, 0);
            this.mMinStime.setText("Min SrvTime: 0000-00-00");
            gdt = new GridData();
            gdt.widthHint = 150;
            this.m_total = this.createPlainLabel(this.m_compRight, WORKING);
            this.m_selCountLabel = this.createPlainLabel(this.m_compRight, "Selection: " + this.m_selCount);
            gd = new GridData();
            gd.widthHint = -1;
            gd.grabExcessHorizontalSpace = true;
            this.m_selCountLabel.setLayoutData((Object)gd);
            this.m_isLocked_label = this.createImageButton(this.m_compRight, BMUI.IMAGE_UNLOCKED);
            this.m_isLocked_label.setVisible(false);
            Section section = BMUI.getFormToolkit(Display.getCurrent()).createSection(this.m_top_composite, 514);
            section.setLayoutData((Object)new GridData(4, 128, true, false, 6, 1));
            Composite sectionClient = BMUI.getFormToolkit(Display.getCurrent()).createComposite((Composite)section, 64);
            GridLayout gdLayout = new GridLayout(4, false);
            gdLayout.horizontalSpacing = 10;
            sectionClient.setLayout((Layout)gdLayout);
            section.setText("Query Filters");
            section.setClient((Control)sectionClient);
            section.setExpanded(true);
            section.addExpansionListener(new IExpansionListener(){

                public void expansionStateChanged(ExpansionEvent e) {
                    MessageBrowserTabArch.this.m_top_composite.layout(true);
                }

                public void expansionStateChanging(ExpansionEvent e) {
                }
            });
            this.createSeverities(sectionClient);
            this.createTextFilters(sectionClient);
            section.setExpanded(false);
        }
        int filtered = 0;
        ViewerFilter[] vf = this.tableViewer.getFilters();
        if (vf != null && vf.length > 0) {
            int i = 0;
            while (i < vf.length) {
                if (vf[i] instanceof EventFilter) {
                    EventFilter ef = (EventFilter)vf[i];
                    filtered += ef.m_filtered;
                }
                ++i;
            }
        }
        String startDate = this.m_sdf.format(new Date(this.start));
        String finishDate = this.m_sdf.format(new Date(this.finish));
        this.m_restInArchive.setText("Rest: " + this.m_restRecords);
        this.m_restInArchive.setToolTipText("Rest of unreaded records in the Archive older then " + startDate);
        String mintime = this.m_sdf.format(new Date(this.m_minStime));
        this.mMinStime.setText("Min SrvTime: " + mintime);
        this.mMinStime.setToolTipText("Minimum SrvTime found in the Archive: " + mintime);
        this.m_restInArchive.setVisible(this.m_restRecords != -1);
        this.mMinStime.setVisible(this.m_minStime > 0L);
        this.m_startLabel.setForeground(BMUI.color_blue);
        this.m_startLabel.setText(startDate);
        this.m_finishLabel.setForeground(BMUI.color_blue);
        this.m_finishLabel.setText(finishDate);
        this.m_total.setText("Loaded: " + this.m_events.size() + "/" + (this.m_events.size() - filtered));
        this.m_total.setForeground(BMUI.color_black);
        this.m_next.setEnabled(true);
        this.m_prev.setEnabled(this.finish <= System.currentTimeMillis());
        this.m_compRight.pack();
        this.updateImage();
    }

    private void openStartCalendar() {
        CalendarDialog cd = new CalendarDialog(this.m_parent.getShell());
        cd.setDate(new Date(this.start));
        SWTCalListener calendar2 = new SWTCalListener();
        cd.addDateChangedListener(calendar2);
        cd.setBlockOnOpen(true);
        cd.open();
        Calendar cal = calendar2.getCalendar();
        cal.set(14, 0);
        cal.set(13, 0);
        cal.set(12, 0);
        cal.set(11, 0);
        this.start = cal.getTimeInMillis();
        this.m_startLabel.setText(this.m_sdf.format(new Date(this.start)));
        this.m_days = (int)((this.finish - this.start) / DAY);
        this.m_intervalDays.setText("" + this.m_days);
        this.setTimesRed();
    }

    private void openFinishCalendar() {
        CalendarDialog cd = new CalendarDialog(this.m_parent.getShell());
        cd.setDate(new Date(this.finish));
        SWTCalListener calendar2 = new SWTCalListener();
        cd.addDateChangedListener(calendar2);
        cd.setBlockOnOpen(true);
        cd.open();
        Calendar cal = calendar2.getCalendar();
        cal.set(14, 0);
        cal.set(13, 0);
        cal.set(12, 0);
        cal.set(11, 0);
        this.finish = cal.getTimeInMillis();
        this.m_finishLabel.setText(this.m_sdf.format(new Date(this.finish)));
        this.m_days = (int)((this.finish - this.start) / DAY);
        this.m_intervalDays.setText("" + this.m_days);
        this.setTimesRed();
    }

    private void createSeverities(Composite sectionClient) {
        Group m_grp = new Group(sectionClient, 0);
        m_grp.setText(" Select Severity: ");
        GridData gridData = new GridData(1, 1024, true, false);
        gridData.horizontalSpan = 4;
        m_grp.setLayoutData((Object)gridData);
        m_grp.setLayout((Layout)new GridLayout(6, false));
        this.m_CheckSevUnknown = this.m_gde.addCheckbox((Composite)m_grp, "unknown", "unknown", true, 1, 1, 1, BMUI.IMAGE_UNKNOWN, this);
        this.m_CheckSevNormal = this.m_gde.addCheckbox((Composite)m_grp, "normal", "normal", true, 1, 1, 1, BMUI.IMAGE_NORMAL, this);
        this.m_CheckSevWarning = this.m_gde.addCheckbox((Composite)m_grp, "warning", "warning", true, 1, 1, 1, BMUI.IMAGE_WARNING, this);
        this.m_CheckSevMinor = this.m_gde.addCheckbox((Composite)m_grp, "minor", "minor", true, 1, 1, 1, BMUI.IMAGE_MINOR, this);
        this.m_CheckSevMajor = this.m_gde.addCheckbox((Composite)m_grp, "major", "major", true, 1, 1, 1, BMUI.IMAGE_MAJOR, this);
        this.m_CheckSevCritical = this.m_gde.addCheckbox((Composite)m_grp, "critical", "critical", true, 1, 1, 1, BMUI.IMAGE_CRITICAL, this);
    }

    public String getSeveritySQLWhere() {
        StringBuffer sb = new StringBuffer();
        if (this.m_CheckSevCritical.getSelection() && this.m_CheckSevMajor.getSelection() && this.m_CheckSevMinor.getSelection() && this.m_CheckSevNormal.getSelection() && this.m_CheckSevUnknown.getSelection() && this.m_CheckSevWarning.getSelection()) {
            return "";
        }
        sb.append(" AND EVENTS_A.SEVERITY IN (");
        if (this.m_CheckSevCritical.getSelection()) {
            sb.append(5).append(",").append(-1).append(",");
        }
        if (this.m_CheckSevMajor.getSelection()) {
            sb.append(4).append(",").append(-2).append(",");
        }
        if (this.m_CheckSevMinor.getSelection()) {
            sb.append(3).append(",").append(-3).append(",");
        }
        if (this.m_CheckSevNormal.getSelection()) {
            sb.append(1).append(",").append(-5).append(",");
        }
        if (this.m_CheckSevWarning.getSelection()) {
            sb.append(2).append(",").append(-4).append(",");
        }
        if (this.m_CheckSevUnknown.getSelection()) {
            sb.append(0).append(",").append(-6).append(",");
        }
        sb.append(")");
        return sb.toString().replace(",)", ")");
    }

    public void createTextFilters(Composite sectionClient) {
        this.m_hostFilter = this.m_gde.addInputFieldSingle(sectionClient, "Host", "Host contains: ", "", 1, 1, 1, 5, 100, null);
        this.m_agentFilter = this.m_gde.addInputFieldSingle(sectionClient, "Agent", "Agent contains: ", "", 1, 1, 5, 5, 100, null);
        this.m_groupFilter = this.m_gde.addInputFieldSingle(sectionClient, "Group", "Group contains: ", "", 1, 1, 1, 1, 100, null);
        this.m_applFilter = this.m_gde.addInputFieldSingle(sectionClient, "Application", "Application contains: ", "", 1, 1, 5, 1, 100, null);
        this.m_objectFilter = this.m_gde.addInputFieldSingle(sectionClient, "Object", "Object contains: ", "", 1, 1, 1, 1, 100, null);
        this.m_textFilter = this.m_gde.addInputFieldSingle(sectionClient, "Text", "Text contains: ", "", 1, 1, 5, 1, 100, null);
    }

    @Override
    public void createTable(Composite parent) {
        Table tbl = new Table(parent, 268503810);
        tbl.setData("TABLE_NAME", (Object)"MessageBrowserTable");
        TableColumn col1 = new TableColumn(tbl, 16384);
        col1.setText("Severity");
        col1.setToolTipText("Severity");
        col1.setWidth(20);
        col1.addListener(13, this.sortListener);
        col1.setMoveable(true);
        TableColumn col2 = new TableColumn(tbl, 16384);
        col2.setText("Duplicates");
        col2.setToolTipText("Duplicates");
        col2.setWidth(25);
        col2.addListener(13, this.sortListener);
        col2.setMoveable(true);
        TableColumn col3 = new TableColumn(tbl, 16384);
        col3.setText("Time");
        col3.setToolTipText("Time");
        col3.setWidth(115);
        col3.addListener(13, this.sortListener);
        col3.setMoveable(true);
        TableColumn col4 = new TableColumn(tbl, 16384);
        col4.setText("Host");
        col4.setToolTipText("Host");
        col4.setWidth(80);
        col4.addListener(13, this.sortListener);
        col4.setMoveable(true);
        TableColumn col5 = new TableColumn(tbl, 16384);
        col5.setText("Application");
        col5.setToolTipText("Application");
        col5.setWidth(80);
        col5.addListener(13, this.sortListener);
        col5.setMoveable(true);
        TableColumn col6 = new TableColumn(tbl, 16384);
        col6.setText("Group");
        col6.setToolTipText("Group");
        col6.setWidth(80);
        col6.addListener(13, this.sortListener);
        col6.setMoveable(true);
        TableColumn col7 = new TableColumn(tbl, 16384);
        col7.setText("Object");
        col7.setToolTipText("Object");
        col7.setWidth(80);
        col7.addListener(13, this.sortListener);
        col7.setMoveable(true);
        TableColumn col8 = new TableColumn(tbl, 16384);
        col8.setText("Text");
        col8.setToolTipText("Text");
        col8.setWidth(350);
        col8.addListener(13, this.sortListener);
        col8.setMoveable(true);
        TableColumn col9 = new TableColumn(tbl, 16384);
        col9.setText("J");
        col9.setWidth(20);
        col9.setToolTipText("Annotations");
        col9.setMoveable(true);
        TableColumn col10 = new TableColumn(tbl, 16384);
        col10.setText("AA");
        col10.setWidth(20);
        col10.setToolTipText("AutoAction assigned");
        col10.setMoveable(true);
        TableColumn col11 = new TableColumn(tbl, 16384);
        col11.setText("!AV");
        col11.setWidth(20);
        col11.setToolTipText("Availability Metric");
        col11.addListener(13, this.sortListener);
        col11.setMoveable(true);
        TableColumn col12 = new TableColumn(tbl, 16384);
        col12.setText("^KPI");
        col12.setWidth(20);
        col12.setToolTipText("KPI Metric");
        col12.addListener(13, this.sortListener);
        col12.setMoveable(true);
        TableColumn col13 = new TableColumn(tbl, 16384);
        col13.setText("Agent");
        col13.setWidth(80);
        col13.setToolTipText("Agent hostname");
        col13.addListener(13, this.sortListener);
        col13.setMoveable(true);
        TableColumn col14 = new TableColumn(tbl, 16384);
        col14.setText("Source");
        col14.setWidth(0);
        col14.setData("def_width", (Object)120);
        col14.setToolTipText("Source");
        col14.addListener(13, this.sortListener);
        col14.setMoveable(true);
        TableColumn col15 = new TableColumn(tbl, 16384);
        col15.setText("SrvTime");
        col15.setWidth(115);
        col15.setToolTipText("Server Time");
        col15.addListener(13, this.sortListener);
        col15.setMoveable(true);
        tbl.setSortColumn(col15);
        TableColumn col16 = new TableColumn(tbl, 16384);
        col16.setText("ID");
        col16.setWidth(0);
        col16.setData("def_width", (Object)120);
        col16.setToolTipText("ID");
        col16.addListener(13, this.sortListener);
        col16.setMoveable(true);
        int i = 1;
        while (i <= 15) {
            TableColumn tCA = new TableColumn(tbl, 16384);
            tCA.setText("CA" + i);
            tCA.setWidth(0);
            tCA.setData("def_width", (Object)80);
            tCA.setToolTipText("CA" + i);
            tCA.addListener(13, this.sortListener);
            tCA.setMoveable(true);
            ++i;
        }
        tbl.setSortColumn(col15);
        tbl.setHeaderVisible(true);
        tbl.setLinesVisible(true);
        GridData data0 = new GridData(1808);
        data0.heightHint = 450;
        tbl.setLayoutData((Object)data0);
        this.tableViewer = new BTableViewer(tbl);
        this.tableViewer.setData("VIEWER_TYPE", "");
        this.tableViewer.setSorter(this.m_eventSorter);
        this.tableViewer.setContentProvider((IContentProvider)this);
        this.tableViewer.setComparer(this.m_eventSorter);
        this.tableViewer.setUseHashlookup(true);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)this);
        this.tableViewer.setInput(this.m_events.toArray());
        this.tableViewer.addDoubleClickListener(this);
        this.tableViewer.setData("SUMMARY", (Object)this);
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StructuredSelection ssel = (StructuredSelection)MessageBrowserTabArch.this.tableViewer.getSelection();
                int newSelCount = ssel.size();
                if (newSelCount > 5000) {
                    MessageBrowserTabArch.this.setTableLocked(true, false);
                } else {
                    MessageBrowserTabArch.this.setTableLocked(false, false);
                }
                if (newSelCount != MessageBrowserTabArch.this.m_selCount) {
                    MessageBrowserTabArch.this.m_selCount = newSelCount;
                    MessageBrowserTabArch.this.m_selCountLabel.setText("Selected: " + MessageBrowserTabArch.this.m_selCount);
                    MessageBrowserTabArch.this.m_compRight.pack();
                }
            }
        });
        tbl.setBackground(BMUI.color_light_yellow);
        tbl.setForeground(BMUI.color_black);
        this.createContentMenu();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        String text = this.m_intervalDays.getText();
        try {
            this.m_days = Integer.parseInt(text);
            this.start = this.finish - (long)this.m_days * DAY;
            this.setTimesRed();
        }
        catch (NumberFormatException numberFormatException) {
            this.m_intervalDays.setText("" + this.m_days);
        }
        if (e.getSource() instanceof Button) {
            Button b = (Button)e.getSource();
            if (b.getData() == NEXT) {
                this.finish = this.start;
                this.start -= (long)this.m_days * DAY;
                this.setTimesRed();
                this.m_prev.setEnabled(this.finish <= System.currentTimeMillis());
            } else if (b.getData() == PREVIOUS) {
                this.start = this.finish;
                this.finish += (long)this.m_days * DAY;
                this.setTimesRed();
                this.m_prev.setEnabled(this.finish <= System.currentTimeMillis());
            } else if (b.getData() == REFRESH) {
                this.start = this.finish - (long)this.m_days * DAY;
                this.reload();
            } else if (b.getData() == RESET) {
                this.resetTime();
                this.m_intervalDays.setText("" + this.m_days);
                this.setTimesRed();
            }
        }
    }

    public Object[] getElements(Object inputElement) {
        return this.m_events.toArray();
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public Image getColumnImage(Object element, int columnIndex) {
        Image image = null;
        SEvent e = (SEvent)element;
        if (columnIndex == 0) {
            switch (e.getSeverityInt()) {
                case 5: {
                    image = BMUI.IMAGE_CRITICAL;
                    break;
                }
                case 4: {
                    image = BMUI.IMAGE_MAJOR;
                    break;
                }
                case 3: {
                    image = BMUI.IMAGE_MINOR;
                    break;
                }
                case 2: {
                    image = BMUI.IMAGE_WARNING;
                    break;
                }
                case 1: {
                    image = BMUI.IMAGE_NORMAL;
                    break;
                }
                case 0: {
                    image = BMUI.IMAGE_UNKNOWN;
                    break;
                }
                case -1: {
                    image = BMUI.IMAGE_CRITICAL_F;
                    break;
                }
                case -2: {
                    image = BMUI.IMAGE_MAJOR_F;
                    break;
                }
                case -3: {
                    image = BMUI.IMAGE_MINOR_F;
                    break;
                }
                case -4: {
                    image = BMUI.IMAGE_WARNING_F;
                    break;
                }
                case -5: {
                    image = BMUI.IMAGE_NORMAL_F;
                    break;
                }
                case -6: {
                    image = BMUI.IMAGE_UNKNOWN_F;
                    break;
                }
            }
        }
        return image;
    }

    public String getColumnText(Object element, int columnIndex) {
        SEvent e = (SEvent)element;
        String label = EventStorageUtils.getLabel(e, columnIndex);
        return label;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    protected void processResult(ArchiveDetails ad, boolean operationFinished) {
        if (this.isDisposed()) {
            try {
                this.m_events.clear();
                ad.m_events.clear();
                ad.m_events = null;
            }
            catch (Throwable throwable) {}
        } else {
            if (ad == null) {
                this.m_total.setText("Error getting data from the server.");
            } else {
                this.tableViewer.getTable().setEnabled(true);
                this.m_events.addAll(ad.m_events);
                this.tableViewer.refresh();
                if (operationFinished) {
                    this.m_restRecords = ad.m_restRecords;
                    if (ad.m_minStime > 0L) {
                        this.m_minStime = ad.m_minStime;
                    }
                    this.createSummary();
                    this.m_summary.setEnabled(true);
                } else {
                    this.m_total.setText("...WORKING... Loaded: " + this.m_events.size());
                }
            }
            this.m_compRight.pack();
        }
    }

    private void setNotSupported() {
        this.m_isSupported = false;
        Label l = new Label(this.m_top_composite, 0);
        l.setText("Server does not support this action. Please upgrade the server to the latest version.");
        l.setForeground(BMUI.color_critical);
        l.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.m_top_composite.layout(true);
        this.m_top_composite.setEnabled(false);
    }
}

