/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views;

import com.blixx.boom.engine.AgentCard;
import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.EventFilter;
import com.blixx.boom.engine.EventFilterAgentAndHost;
import com.blixx.boom.engine.EventFilterGroup;
import com.blixx.boom.engine.GuiClient;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.engine.ServiceDashBoard;
import com.blixx.boom.engine.UIJob;
import com.blixx.boom.gui.Activator;
import com.blixx.boom.gui.graph.GEventFilter;
import com.blixx.boom.gui.settings.UISettings;
import com.blixx.boom.gui.views.MessageBrowserTab;
import com.blixx.boom.gui.views.MessagesViewFolder;
import com.blixx.boom.gui.views.actions.ViewFilterAction;
import com.blixx.boom.gui.views.dnd.DNDMessageTabItems;
import com.blixx.shared.Severity;
import com.blixx.shared.ext.IServiceStatus;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;

public class MessagesView
extends ViewPart {
    public static final String SECONDARY_ID = "MsgView2";
    public static final String ID = "com.blixx.boom.gui.views.msgview";
    public static MessagesView m_instance = null;
    public MessagesViewFolder m_folder;
    public static MessagesView m_object = null;
    public static String RENAMED = "RENAMED";
    public static String DEFAULT = "DEFAULT";

    public MessagesView() {
        if (m_instance == null) {
            m_instance = this;
        }
    }

    public static MessagesView getInstance() {
        return m_instance;
    }

    public void createPartControl(Composite parent) {
        if (Repository.getInstance().getRights(1000) <= 1) {
            GuiClient.getInstance();
            UIJob uiJob = new UIJob("Close View"){

                @Override
                public IStatus runInUIThread(IProgressMonitor monitor) {
                    MessagesView.this.getSite().getPage().hideView(MessagesView.this.getSite().getPage().findView(MessagesView.ID));
                    try {
                        MessagesView.this.getSite().getPage().hideView(MessagesView.this.getSite().getPage().findViewReference(MessagesView.ID, MessagesView.SECONDARY_ID));
                    }
                    catch (Throwable throwable) {}
                    return Status.OK_STATUS;
                }
            };
            Repository.getUIJobManager().schedule(uiJob);
            return;
        }
        this.m_folder = new MessagesViewFolder(this, parent, 2816);
        if (this.getSecondaryID() != null) {
            if (!UISettings.getInstance().getProfileType().equals(UISettings.SERVER_PROFILE)) {
                new MessageBrowserTab(this.getSite(), this.m_folder, 64, this.m_folder.getItemCount(), null, false, MessageBrowserTab.DEFAULT_TAB, null);
            }
            UISettings.getInstance().createPredifinedIBTabs(this, this.m_folder, UISettings.MSG_VIEW2);
            UISettings.getInstance().createUserIBTabs(this, this.m_folder, UISettings.MSG_VIEW2);
            this.setPartName(String.valueOf(this.getPartName()) + " (2)");
        } else {
            if (!UISettings.getInstance().getProfileType().equals(UISettings.SERVER_PROFILE)) {
                new MessageBrowserTab(this.getSite(), this.m_folder, 64, this.m_folder.getItemCount(), null, true, MessageBrowserTab.DEFAULT_TAB, null);
            }
            UISettings.getInstance().createPredifinedIBTabs(this, this.m_folder, UISettings.MSG_VIEW1);
            UISettings.getInstance().createUserIBTabs(this, this.m_folder, UISettings.MSG_VIEW1);
            if (m_instance != this) {
                m_instance = this;
            }
        }
        if (this.m_folder.getItemCount() > 0) {
            this.m_folder.setSelection(0);
        }
        this.m_folder.setFocus();
        if (UISettings.getInstance().IB_canMoveTab()) {
            DNDMessageTabItems DND = new DNDMessageTabItems(this.m_folder, parent.getShell().getDisplay());
            DND.addDNDSupport();
        }
        this.setTitleImage(BMUI.IMAGE_INDICATIONS);
    }

    public void setFocus() {
    }

    public void dispose() {
        super.dispose();
    }

    public static void showMessagesForSeverity(String severity, boolean isActive, MessagesView view) {
        MessageBrowserTab mtb = new MessageBrowserTab(view.getSite(), view.m_folder, 64, view.m_folder.getItemCount(), "(" + severity + ")", isActive, MessageBrowserTab.NEW_TAB, null);
        EventFilter ef = new EventFilter(null, "Severity", severity, false, 3, mtb.tableViewer, false, 0, 0);
        ViewFilterAction.addFilter((Object)mtb, mtb.tableViewer, ef);
        view.m_folder.setSelection(mtb);
        Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().activate((IWorkbenchPart)view);
        UISettings.getInstance().storeAndReload();
    }

    public static void showMessagesForSource(String policyName, String title, boolean activate) {
        String longTitle = "Source (" + policyName + ")" + "[Active]";
        if (MessagesView.isTabOpen(longTitle, null)) {
            return;
        }
        MessageBrowserTab mtb = new MessageBrowserTab(MessagesView.getInstance().getSite(), MessagesView.getInstance().m_folder, 64, MessagesView.getInstance().m_folder.getItemCount(), "Source (" + policyName + ")", true, MessageBrowserTab.NEW_TAB, null);
        EventFilter ef = new EventFilter(null, "Source", title, false, 1, mtb.tableViewer, false, 0, 0);
        ViewFilterAction.addFilter((Object)mtb, mtb.tableViewer, ef);
        if (activate) {
            MessagesView.getInstance().m_folder.setSelection(mtb);
            Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().activate((IWorkbenchPart)MessagesView.getInstance());
        }
        UISettings.getInstance().storeAndReload();
    }

    public static void showMessagesForHost(AgentCard ac, String title) {
        String longTitle = String.valueOf(title) + "[Active]";
        if (MessagesView.isTabOpen(longTitle, null)) {
            return;
        }
        MessageBrowserTab mtb = new MessageBrowserTab(MessagesView.getInstance().getSite(), MessagesView.getInstance().m_folder, 64, MessagesView.getInstance().m_folder.getItemCount(), title, true, MessageBrowserTab.NEW_TAB, null);
        EventFilter ef = new EventFilter(null, "Agent", ac.getAgentHost(), false, 4, mtb.tableViewer, false, 0, 0);
        ViewFilterAction.addFilter((Object)mtb, mtb.tableViewer, ef);
        MessagesView.getInstance().m_folder.setSelection(mtb);
        Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().activate((IWorkbenchPart)MessagesView.getInstance());
        UISettings.getInstance().storeAndReload();
    }

    public static void showMessagesForAgent(AgentCard ac, String title) {
        String longTitle = String.valueOf(title) + "[Active]";
        if (MessagesView.isTabOpen(longTitle, null)) {
            return;
        }
        MessageBrowserTab mtb = new MessageBrowserTab(MessagesView.getInstance().getSite(), MessagesView.getInstance().m_folder, 64, MessagesView.getInstance().m_folder.getItemCount(), title, true, MessageBrowserTab.NEW_TAB, null);
        EventFilter ef = new EventFilter(null, "AgentID", ac.getAgentID(), false, 4, mtb.tableViewer, false, 0, 0);
        ViewFilterAction.addFilter((Object)mtb, mtb.tableViewer, ef);
        MessagesView.getInstance().m_folder.setSelection(mtb);
        Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().activate((IWorkbenchPart)MessagesView.getInstance());
        UISettings.getInstance().storeAndReload();
    }

    public static void showMessagesForAgentAndHost(AgentCard ac, String title) {
        String longTitle = String.valueOf(title) + "[Active]";
        if (MessagesView.isTabOpen(longTitle, null)) {
            return;
        }
        MessageBrowserTab mtb = new MessageBrowserTab(MessagesView.getInstance().getSite(), MessagesView.getInstance().m_folder, 64, MessagesView.getInstance().m_folder.getItemCount(), title, true, MessageBrowserTab.NEW_TAB, null);
        EventFilterAgentAndHost efAgentHost = new EventFilterAgentAndHost(title, UUID.randomUUID().toString(), Repository.getEventProvider(), mtb.getTableViewer(), ac);
        ViewFilterAction.addFilter((Object)mtb, mtb.getTableViewer(), efAgentHost);
        MessagesView.getInstance().m_folder.setSelection(mtb);
        Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().activate((IWorkbenchPart)MessagesView.getInstance());
        UISettings.getInstance().storeAndReload();
    }

    public static void showMessagesForNodeGroupString(String ngPath, String title) {
        String longTitle = String.valueOf(title) + "[Active]";
        if (MessagesView.isTabOpen(longTitle, null)) {
            return;
        }
        MessageBrowserTab mtb = new MessageBrowserTab(MessagesView.getInstance().getSite(), MessagesView.getInstance().m_folder, 64, MessagesView.getInstance().m_folder.getItemCount(), title, true, MessageBrowserTab.NEW_TAB, null);
        EventFilter ef = new EventFilter(null, "Node group", ngPath, false, 4, mtb.tableViewer, false, 0, 0);
        ViewFilterAction.addFilter((Object)mtb, mtb.tableViewer, ef);
        MessagesView.getInstance().m_folder.setSelection(mtb);
        Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().activate((IWorkbenchPart)MessagesView.getInstance());
        UISettings.getInstance().storeAndReload();
    }

    public static void showMessagesForNodeGroupRecursive(String ngPath, String title) {
        String longTitle = String.valueOf(title) + "[Active]";
        if (MessagesView.isTabOpen(longTitle, null)) {
            return;
        }
        if (!ngPath.endsWith("/")) {
            ngPath = String.valueOf(ngPath) + '/';
        }
        MessageBrowserTab mtb = new MessageBrowserTab(MessagesView.getInstance().getSite(), MessagesView.getInstance().m_folder, 64, MessagesView.getInstance().m_folder.getItemCount(), title, true, MessageBrowserTab.NEW_TAB, null);
        EventFilter ef = new EventFilter(null, "Node group", ngPath, false, 1, mtb.tableViewer, false, 0, 0);
        ViewFilterAction.addFilter((Object)mtb, mtb.tableViewer, ef);
        MessagesView.getInstance().m_folder.setSelection(mtb);
        Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().activate((IWorkbenchPart)MessagesView.getInstance());
        UISettings.getInstance().storeAndReload();
    }

    public static void showMessagesForNodeGroupExtString(String ngPath, String title) {
        String longTitle = String.valueOf(title) + "[Active]";
        if (MessagesView.isTabOpen(longTitle, null)) {
            return;
        }
        MessageBrowserTab mtb = new MessageBrowserTab(MessagesView.getInstance().getSite(), MessagesView.getInstance().m_folder, 64, MessagesView.getInstance().m_folder.getItemCount(), title, true, MessageBrowserTab.NEW_TAB, null);
        EventFilter ef = new EventFilter(null, "Node group [Hosts]", ngPath, false, 4, mtb.tableViewer, false, 0, 0);
        ViewFilterAction.addFilter((Object)mtb, mtb.tableViewer, ef);
        MessagesView.getInstance().m_folder.setSelection(mtb);
        Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().activate((IWorkbenchPart)MessagesView.getInstance());
        UISettings.getInstance().storeAndReload();
    }

    public static void showMessagesForNodeGroupExtRecursive(String ngPath, String title) {
        String longTitle = String.valueOf(title) + "[Active]";
        if (MessagesView.isTabOpen(longTitle, null)) {
            return;
        }
        if (!ngPath.endsWith("/")) {
            ngPath = String.valueOf(ngPath) + '/';
        }
        MessageBrowserTab mtb = new MessageBrowserTab(MessagesView.getInstance().getSite(), MessagesView.getInstance().m_folder, 64, MessagesView.getInstance().m_folder.getItemCount(), title, true, MessageBrowserTab.NEW_TAB, null);
        EventFilter ef = new EventFilter(null, "Node group [Hosts]", ngPath, false, 1, mtb.tableViewer, false, 0, 0);
        ViewFilterAction.addFilter((Object)mtb, mtb.tableViewer, ef);
        MessagesView.getInstance().m_folder.setSelection(mtb);
        Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().activate((IWorkbenchPart)MessagesView.getInstance());
        UISettings.getInstance().storeAndReload();
    }

    public static void showMessagesForSlaveServer(String slaveServer, String title) {
        String longTitle = String.valueOf(title) + "[Active]";
        if (MessagesView.isTabOpen(longTitle, null)) {
            return;
        }
        MessageBrowserTab mtb = new MessageBrowserTab(MessagesView.getInstance().getSite(), MessagesView.getInstance().m_folder, 64, MessagesView.getInstance().m_folder.getItemCount(), title, true, MessageBrowserTab.NEW_TAB, null);
        EventFilter ef = new EventFilter(null, "SlaveServerName", slaveServer, false, 4, mtb.tableViewer, false, 0, 0);
        ViewFilterAction.addFilter((Object)mtb, mtb.tableViewer, ef);
        MessagesView.getInstance().m_folder.setSelection(mtb);
        Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().activate((IWorkbenchPart)MessagesView.getInstance());
        UISettings.getInstance().storeAndReload();
    }

    public static void showMessagesForHost(String host, String title) {
        String longTitle = String.valueOf(title) + "[Active]";
        if (MessagesView.isTabOpen(longTitle, null)) {
            return;
        }
        MessageBrowserTab mtb = new MessageBrowserTab(MessagesView.getInstance().getSite(), MessagesView.getInstance().m_folder, 64, MessagesView.getInstance().m_folder.getItemCount(), title, true, MessageBrowserTab.NEW_TAB, null);
        EventFilter ef = new EventFilter(null, "Host", host, false, 4, mtb.tableViewer, false, 0, 0);
        ViewFilterAction.addFilter((Object)mtb, mtb.tableViewer, ef);
        MessagesView.getInstance().m_folder.setSelection(mtb);
        Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().activate((IWorkbenchPart)MessagesView.getInstance());
        UISettings.getInstance().storeAndReload();
    }

    public String getSecondaryID() {
        return this.getViewSite().getSecondaryId();
    }

    public static void showMessagesForHotSpot(String title, String host, String apps, String msggrp, String obj, String monitor, int typeA, int typeK) {
        EventFilter ef;
        String longTitle = String.valueOf(title) + "[Active]";
        if (MessagesView.isDaBoTabOpen(longTitle, null)) {
            return;
        }
        MessageBrowserTab mtb = new MessageBrowserTab(MessagesView.getInstance().getSite(), MessagesView.getInstance().m_folder, 64, MessagesView.getInstance().m_folder.getItemCount(), title, true, MessageBrowserTab.NEW_TAB, null);
        if (host != null) {
            ef = new EventFilter(null, "Host", host, false, 4, mtb.tableViewer, false, typeA, typeK);
            ViewFilterAction.addFilter((Object)mtb, mtb.tableViewer, ef);
        }
        if (apps != null) {
            ef = new EventFilter(null, "Application", apps, false, 4, mtb.tableViewer, false, typeA, typeK);
            ViewFilterAction.addFilter((Object)mtb, mtb.tableViewer, ef);
        }
        if (msggrp != null) {
            ef = new EventFilter(null, "Group", msggrp, false, 4, mtb.tableViewer, false, typeA, typeK);
            ViewFilterAction.addFilter((Object)mtb, mtb.tableViewer, ef);
        }
        if (obj != null) {
            ef = new EventFilter(null, "Object", obj, false, 4, mtb.tableViewer, false, typeA, typeK);
            ViewFilterAction.addFilter((Object)mtb, mtb.tableViewer, ef);
        }
        if (monitor != null) {
            ef = new EventFilter(null, "Source", ":" + monitor + ":", false, 3, mtb.tableViewer, false, typeA, typeK);
            ViewFilterAction.addFilter((Object)mtb, mtb.tableViewer, ef);
        }
        MessagesView.getInstance().m_folder.setSelection(mtb);
        Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().activate((IWorkbenchPart)MessagesView.getInstance());
        UISettings.getInstance().storeAndReload();
    }

    public static void showMessagesForHosts(String title, List<String> host, String apps, String msggrp, String obj, int severity, String monitor, int typeA, int typeK) {
        EventFilter ef;
        String longTitle = String.valueOf(title) + "[Active]";
        if (MessagesView.isDaBoTabOpen(longTitle, null)) {
            return;
        }
        MessageBrowserTab mtb = new MessageBrowserTab(MessagesView.getInstance().getSite(), MessagesView.getInstance().m_folder, 64, MessagesView.getInstance().m_folder.getItemCount(), title, true, MessageBrowserTab.NEW_TAB, null);
        if (host != null && host.size() > 0) {
            StringBuffer sb = new StringBuffer();
            for (String hostName : host) {
                sb.append(hostName).append('|');
            }
            String hosts = sb.toString();
            if (hosts.endsWith("|")) {
                hosts = hosts.substring(0, hosts.length() - 1);
            }
            EventFilter ef2 = new EventFilter(null, "Host", hosts, false, 3, mtb.tableViewer, false, typeA, typeK);
            ViewFilterAction.addFilter((Object)mtb, mtb.tableViewer, ef2);
        }
        if (apps != null) {
            ef = new EventFilter(null, "Application", apps, true, 4, mtb.tableViewer, false, typeA, typeK);
            ViewFilterAction.addFilter((Object)mtb, mtb.tableViewer, ef);
        }
        if (msggrp != null) {
            ef = new EventFilter(null, "Group", msggrp, true, 4, mtb.tableViewer, false, typeA, typeK);
            ViewFilterAction.addFilter((Object)mtb, mtb.tableViewer, ef);
        }
        if (obj != null) {
            ef = new EventFilter(null, "Object", obj, false, 4, mtb.tableViewer, false, typeA, typeK);
            ViewFilterAction.addFilter((Object)mtb, mtb.tableViewer, ef);
        }
        if (monitor != null) {
            ef = new EventFilter(null, "Source", ":" + monitor + ":", false, 3, mtb.tableViewer, false, typeA, typeK);
            ViewFilterAction.addFilter((Object)mtb, mtb.tableViewer, ef);
        }
        if (severity > 0) {
            if (severity == 2) {
                ef = new EventFilter(null, "Severity", String.valueOf(Severity.getSeverity(1)) + "|" + Severity.getSeverity(2), false, 3, mtb.tableViewer, false, 0, 0);
                ViewFilterAction.addFilter((Object)mtb, mtb.tableViewer, ef);
            } else {
                ef = new EventFilter(null, "Severity", Severity.getSeverity(severity), false, 3, mtb.tableViewer, false, 0, 0);
                ViewFilterAction.addFilter((Object)mtb, mtb.tableViewer, ef);
            }
        }
        MessagesView.getInstance().m_folder.setSelection(mtb);
        Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().activate((IWorkbenchPart)MessagesView.getInstance());
        UISettings.getInstance().storeAndReload();
    }

    public static void showMessages(String title, String host, String apps, String msggrp, String obj, int severity, String monitor, int typeA, int typeK) {
        EventFilter ef;
        String longTitle = String.valueOf(title) + "[Active]";
        if (MessagesView.isDaBoTabOpen(longTitle, null)) {
            return;
        }
        MessageBrowserTab mtb = new MessageBrowserTab(MessagesView.getInstance().getSite(), MessagesView.getInstance().m_folder, 64, MessagesView.getInstance().m_folder.getItemCount(), title, true, MessageBrowserTab.NEW_TAB, null);
        if (host != null) {
            ef = new EventFilter(null, "Host", host, false, 4, mtb.tableViewer, false, typeA, typeK);
            ViewFilterAction.addFilter((Object)mtb, mtb.tableViewer, ef);
        }
        if (apps != null) {
            ef = new EventFilter(null, "Application", apps, true, 4, mtb.tableViewer, false, typeA, typeK);
            ViewFilterAction.addFilter((Object)mtb, mtb.tableViewer, ef);
        }
        if (msggrp != null) {
            ef = new EventFilter(null, "Group", msggrp, true, 4, mtb.tableViewer, false, typeA, typeK);
            ViewFilterAction.addFilter((Object)mtb, mtb.tableViewer, ef);
        }
        if (obj != null) {
            ef = new EventFilter(null, "Object", obj, false, 4, mtb.tableViewer, false, typeA, typeK);
            ViewFilterAction.addFilter((Object)mtb, mtb.tableViewer, ef);
        }
        if (monitor != null) {
            ef = new EventFilter(null, "Source", ":" + monitor + ":", false, 3, mtb.tableViewer, false, typeA, typeK);
            ViewFilterAction.addFilter((Object)mtb, mtb.tableViewer, ef);
        }
        if (severity > 0) {
            if (severity == 2) {
                ef = new EventFilter(null, "Severity", String.valueOf(Severity.getSeverity(1)) + "|" + Severity.getSeverity(2), false, 3, mtb.tableViewer, false, 0, 0);
                ViewFilterAction.addFilter((Object)mtb, mtb.tableViewer, ef);
            } else {
                ef = new EventFilter(null, "Severity", Severity.getSeverity(severity), false, 3, mtb.tableViewer, false, 0, 0);
                ViewFilterAction.addFilter((Object)mtb, mtb.tableViewer, ef);
            }
        }
        MessagesView.getInstance().m_folder.setSelection(mtb);
        Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().activate((IWorkbenchPart)MessagesView.getInstance());
        UISettings.getInstance().storeAndReload();
    }

    public static void showMessages(ServiceDashBoard service) {
        if (MessagesView.isTabOpen(service.getName(), null)) {
            return;
        }
        MessageBrowserTab mtb = new MessageBrowserTab(MessagesView.getInstance().getSite(), MessagesView.getInstance().m_folder, 64, MessagesView.getInstance().m_folder.getItemCount(), service.getName(), true, MessageBrowserTab.NEW_TAB, null);
        service.m_isLocked = true;
        if (service.m_tv == null) {
            service.m_tv = mtb.tableViewer;
        }
        ViewFilterAction.addFilter((Object)mtb, mtb.tableViewer, service);
        MessagesView.getInstance().m_folder.setSelection(mtb);
        Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().activate((IWorkbenchPart)MessagesView.getInstance());
        UISettings.getInstance().storeAndReload();
    }

    public static void showMessages(IServiceStatus iss) {
        if (MessagesView.isTabOpen(iss.toString(), null)) {
            return;
        }
        MessageBrowserTab mtb = new MessageBrowserTab(MessagesView.getInstance().getSite(), MessagesView.getInstance().m_folder, 64, MessagesView.getInstance().m_folder.getItemCount(), iss.toString(), true, MessageBrowserTab.NEW_TAB, null);
        GEventFilter gef = new GEventFilter(iss);
        gef.m_isLocked = true;
        if (gef.m_tv == null) {
            gef.m_tv = mtb.tableViewer;
        }
        ViewFilterAction.addFilter((Object)mtb, mtb.tableViewer, gef);
        MessagesView.getInstance().m_folder.setSelection(mtb);
        Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().activate((IWorkbenchPart)MessagesView.getInstance());
        UISettings.getInstance().storeAndReload();
    }

    public static void showMessages(EventFilterGroup efg) {
        if (MessagesView.isTabOpen(efg.getName(), null)) {
            return;
        }
        MessageBrowserTab mtb = new MessageBrowserTab(MessagesView.getInstance().getSite(), MessagesView.getInstance().m_folder, 64, MessagesView.getInstance().m_folder.getItemCount(), efg.getName(), true, MessageBrowserTab.NEW_TAB, null);
        for (EventFilter ef : efg.getFilters()) {
            ef.m_isLocked = true;
            if (ef.m_tv == null) {
                ef.m_tv = mtb.tableViewer;
            }
            ViewFilterAction.addFilter((Object)mtb, mtb.tableViewer, ef);
        }
        MessagesView.getInstance().m_folder.setSelection(mtb);
        Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().activate((IWorkbenchPart)MessagesView.getInstance());
        UISettings.getInstance().storeAndReload();
    }

    public static void showMessageForID(String indicationID, boolean isMsgActive) {
        if (MessagesView.isTabOpen(indicationID, null)) {
            return;
        }
        MessageBrowserTab mtb = new MessageBrowserTab(MessagesView.getInstance().getSite(), MessagesView.getInstance().m_folder, 64, MessagesView.getInstance().m_folder.getItemCount(), indicationID, isMsgActive, MessageBrowserTab.NEW_TAB, null);
        EventFilter ef = new EventFilter(null, "ID", indicationID, false, 4, mtb.tableViewer, false, 0, 0);
        ViewFilterAction.addFilter((Object)mtb, mtb.tableViewer, ef);
        MessagesView.getInstance().m_folder.setSelection(mtb);
        IWorkbenchPage page = Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
        page.activate((IWorkbenchPart)MessagesView.getInstance());
        page.bringToTop(page.getActivePart());
        UISettings.getInstance().storeAndReload();
    }

    public static boolean isTabOpen(String title, CTabFolder folder) {
        ArrayList<MessageBrowserTab> openTabList = new ArrayList<MessageBrowserTab>();
        ArrayList<MessageBrowserTab> tabsWithoutFilter = new ArrayList<MessageBrowserTab>();
        boolean isOpen = false;
        CTabFolder currentFolder = null;
        currentFolder = folder == null ? MessagesView.m_instance.m_folder : folder;
        CTabItem[] tabList = currentFolder.getItems();
        int i = 0;
        while (i < tabList.length) {
            if (tabList[i] instanceof MessageBrowserTab) {
                MessageBrowserTab tab = (MessageBrowserTab)tabList[i];
                if (tab.isDisposed()) {
                    return false;
                }
                if (tab.getText().startsWith(title)) {
                    openTabList.add(tab);
                }
            }
            ++i;
        }
        int ii = 0;
        while (ii < openTabList.size()) {
            boolean hasUnlockFilter = false;
            MessageBrowserTab cTab = (MessageBrowserTab)((Object)openTabList.get(ii));
            ViewerFilter[] filters = cTab.tableViewer.getFilters();
            int index = 0;
            while (index < filters.length) {
                EventFilter ef = (EventFilter)filters[index];
                if (!ef.m_isLocked) {
                    hasUnlockFilter = true;
                }
                ++index;
            }
            if (!hasUnlockFilter) {
                tabsWithoutFilter.add(cTab);
            }
            ++ii;
        }
        if (tabsWithoutFilter.size() > 0) {
            currentFolder.setSelection((CTabItem)((MessageBrowserTab)((Object)tabsWithoutFilter.get(0))));
            MessagesView currentView = ((MessagesViewFolder)currentFolder).m_msgView;
            Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().activate((IWorkbenchPart)currentView);
            isOpen = true;
        }
        return isOpen;
    }

    public static boolean isDaBoTabOpen(String title, CTabFolder folder) {
        boolean isOpen = false;
        CTabFolder currentFolder = null;
        currentFolder = folder == null ? MessagesView.m_instance.m_folder : folder;
        CTabItem[] tabList = currentFolder.getItems();
        int i = 0;
        while (i < tabList.length) {
            MessageBrowserTab tab;
            if (tabList[i] instanceof MessageBrowserTab && (tab = (MessageBrowserTab)tabList[i]).getText().equals(title)) {
                currentFolder.setSelection((CTabItem)tab);
                MessagesView currentView = ((MessagesViewFolder)currentFolder).m_msgView;
                Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().activate((IWorkbenchPart)currentView);
                isOpen = true;
                break;
            }
            ++i;
        }
        return isOpen;
    }
}

