/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.gui.settings.UISettings;
import com.blixx.boom.gui.views.MessageBrowserTab;
import com.blixx.boom.gui.views.MessageBrowserTabArch;
import com.blixx.boom.gui.views.MessagesView;
import com.blixx.boom.gui.views.actions.AddToPredefinedTabsActions;
import com.blixx.boom.gui.views.actions.RenameTabAction;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class MessagesViewFolder
extends CTabFolder {
    private Composite m_parent = null;
    private MessagesViewFolder m_this = null;
    public MessagesView m_msgView = null;
    private MessagesView m_secondView = null;
    public static final String ADD_INDI_TAB = "Add Tab";
    private static String RENAME = "Rename";
    private static String CLOSE = "Close";
    private static String CLOSE_OTHER = "Close Other";
    private static String CLOSE_ALL = "Close All";

    public MessagesViewFolder(MessagesView msgView, Composite parent, int style) {
        super(parent, style);
        this.m_msgView = msgView;
        this.m_parent = parent;
        this.m_this = this;
        this.setSimple(false);
        this.setMinimizeVisible(false);
        this.setMaximizeVisible(false);
        this.setBorderVisible(false);
        this.setUnselectedCloseVisible(true);
        this.createContentMenu();
        this.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (e.item instanceof MessageBrowserTabArch) {
                    MessageBrowserTabArch mtb = (MessageBrowserTabArch)e.item;
                    mtb.tableViewer.setInput(mtb.getElements(null));
                    mtb.createSummary();
                } else if (e.item instanceof MessageBrowserTab) {
                    MessageBrowserTab mtb = (MessageBrowserTab)e.item;
                    mtb.tableViewer.setInput(mtb.getEventProvider().getElements(null));
                    mtb.createSummary();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    public void createContentMenu() {
        final Menu menu = new Menu((Control)this);
        MenuItem mi = new MenuItem(menu, -1);
        mi.setText(ADD_INDI_TAB);
        mi.setData((Object)ADD_INDI_TAB);
        mi.setImage(BMUI.IMAGE_INDICATIONS);
        mi.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                MessageBrowserTab mtb = new MessageBrowserTab(MessagesViewFolder.this.m_msgView.getSite(), MessagesViewFolder.this.m_this, 64, MessagesViewFolder.this.m_this.getItemCount(), null, true, MessageBrowserTab.NEW_TAB, null);
                MessagesViewFolder.this.m_this.setSelection(mtb);
                UISettings.getInstance().storeAndReload();
            }
        });
        MenuItem mi_sep = new MenuItem(menu, 2);
        mi_sep.setData((Object)"");
        mi = new MenuItem(menu, -1);
        mi.setText("Add Archived Tab");
        mi.setData((Object)"");
        mi.setImage(BMUI.IMAGE_ARCH);
        mi.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                MessageBrowserTabArch mtb = new MessageBrowserTabArch(MessagesViewFolder.this.m_msgView.getSite(), MessagesViewFolder.this.m_this, 64, MessagesViewFolder.this.m_this.getItemCount(), null, true);
                MessagesViewFolder.this.m_this.setSelection(mtb);
            }
        });
        mi.setEnabled(true);
        mi_sep = new MenuItem(menu, 2);
        mi_sep.setData((Object)"");
        MenuItem mi_rename = new MenuItem(menu, -1);
        mi_rename.setText(RENAME);
        mi_rename.setData((Object)RENAME);
        mi_rename.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                CTabItem currentTab = MessagesViewFolder.this.m_this.getSelection();
                RenameTabAction rename = new RenameTabAction(MessagesViewFolder.this.m_this, MessagesViewFolder.this.m_parent.getShell(), currentTab.getText());
                rename.run();
            }
        });
        MenuItem mi_addToPredTabs = new MenuItem(menu, -1);
        mi_addToPredTabs.setText("Add to Predefined Tabs");
        mi_addToPredTabs.setData((Object)"AddToPredefinedTabs");
        mi_addToPredTabs.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                AddToPredefinedTabsActions addToPredTabs = new AddToPredefinedTabsActions(MessagesViewFolder.this.m_this, MessagesViewFolder.this.m_msgView);
                addToPredTabs.run();
            }
        });
        mi_sep = new MenuItem(menu, 2);
        mi_sep.setData((Object)"");
        MenuItem mi_close = new MenuItem(menu, -1);
        mi_close.setText(CLOSE);
        mi_close.setData((Object)CLOSE);
        mi_close.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                CTabItem msgTab = MessagesViewFolder.this.m_this.getSelection();
                if (msgTab.getStyle() == 64) {
                    msgTab.dispose();
                }
            }
        });
        MenuItem mi_closeOther = new MenuItem(menu, -1);
        mi_closeOther.setText(CLOSE_OTHER);
        mi_closeOther.setData((Object)CLOSE_OTHER);
        mi_closeOther.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                CTabItem currentTab = MessagesViewFolder.this.m_this.getSelection();
                CTabItem[] tabs = MessagesViewFolder.this.m_this.getItems();
                int i = 0;
                while (i < tabs.length) {
                    MessageBrowserTab msgTab;
                    if (!currentTab.equals(tabs[i]) && (msgTab = (MessageBrowserTab)tabs[i]).getStyle() == 64) {
                        msgTab.dispose();
                    }
                    ++i;
                }
            }
        });
        MenuItem mi_closeAll = new MenuItem(menu, -1);
        mi_closeAll.setText(CLOSE_ALL);
        mi_closeAll.setData((Object)CLOSE_ALL);
        mi_closeAll.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                CTabItem[] tabs = MessagesViewFolder.this.m_this.getItems();
                int i = 0;
                while (i < tabs.length) {
                    MessageBrowserTab msgTab = (MessageBrowserTab)tabs[i];
                    if (msgTab.getStyle() == 64) {
                        msgTab.dispose();
                    }
                    ++i;
                }
            }
        });
        menu.addMenuListener(new MenuListener(){

            public void menuHidden(MenuEvent e) {
            }

            public void menuShown(MenuEvent e) {
                int index;
                MenuItem[] mi = menu.getItems();
                MessagesViewFolder msgViewFolder = MessagesViewFolder.this.m_this;
                int count = msgViewFolder.getItemCount();
                if (count == 0) {
                    index = 0;
                    while (index < mi.length) {
                        if (mi[index].getData().equals(CLOSE) || mi[index].getData().equals(CLOSE_OTHER) || mi[index].getData().equals(CLOSE_ALL) || mi[index].getData().equals(RENAME)) {
                            mi[index].setEnabled(false);
                        }
                        ++index;
                    }
                } else if (count == 1) {
                    index = 0;
                    while (index < mi.length) {
                        if (mi[index].getData().equals(CLOSE)) {
                            mi[index].setEnabled(true);
                        } else if (mi[index].getData().equals(CLOSE_OTHER) || mi[index].getData().equals(CLOSE_ALL)) {
                            mi[index].setEnabled(false);
                        }
                        ++index;
                    }
                } else if (count > 1) {
                    index = 0;
                    while (index < mi.length) {
                        mi[index].setEnabled(true);
                        ++index;
                    }
                }
                CTabItem tab = msgViewFolder.getSelection();
                int index2 = 0;
                while (index2 < mi.length) {
                    String actionTitle = (String)mi[index2].getData();
                    if (count > 0 && actionTitle.equals(CLOSE)) {
                        if (tab.getStyle() == 64) {
                            mi[index2].setEnabled(true);
                        } else {
                            mi[index2].setEnabled(false);
                        }
                    } else if (actionTitle.equals(MessagesViewFolder.ADD_INDI_TAB)) {
                        String viewID = "com.blixx.boom.gui.views.msgview";
                        if (MessagesViewFolder.this.m_msgView.getSecondaryID() != null) {
                            viewID = "com.blixx.boom.gui.views.msgview:MsgView2";
                        }
                        mi[index2].setEnabled(UISettings.getInstance().IB_canAddNewTab(viewID));
                    } else if (count > 0 && actionTitle.equals(RENAME)) {
                        if (tab instanceof MessageBrowserTab) {
                            mi[index2].setEnabled(!((MessageBrowserTab)tab).isPredefinedTab());
                        }
                    } else if (count > 0 && actionTitle.equals("AddToPredefinedTabs") && tab instanceof MessageBrowserTab) {
                        mi[index2].setEnabled(!((MessageBrowserTab)tab).isPredefinedTab());
                    }
                    ++index2;
                }
            }
        });
        this.setMenu(menu);
    }

    public void setSecondView(MessagesView secondView) {
        this.m_secondView = secondView;
    }

    public MessagesView getSecondView() {
        return this.m_secondView;
    }

    public String getViewSecondaryID() {
        return this.m_msgView.getSecondaryID();
    }

    public MessagesView getView() {
        return this.m_msgView;
    }

    public void setSelection(CTabItem item) {
        super.setSelection(item);
    }
}

