/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views;

import com.blixx.boom.engine.BMUI;
import com.blixx.shared.CFI;
import com.blixx.shared.PatternB;
import com.blixx.shared.Policy;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.OwnerDrawLabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.widgets.Event;

public class MonPerfSubmitProvider
extends OwnerDrawLabelProvider
implements IStructuredContentProvider {
    private final Policy policy;
    private List<PerfMappingRow> rows = new ArrayList<PerfMappingRow>();

    public MonPerfSubmitProvider(Policy policy) {
        this.policy = policy;
        this.getMapping(this.policy);
    }

    private void getMapping(Policy pol) {
        Map<PatternB, CFI> map = pol.getClassMap();
        if (map != null) {
            for (Map.Entry<PatternB, CFI> en : map.entrySet()) {
                this.rows.add(new PerfMappingRow(en.getKey(), en.getValue()));
            }
        }
    }

    public Object[] getElements(Object object) {
        this.rows.clear();
        if (object instanceof Policy) {
            this.getMapping((Policy)object);
        }
        return this.rows.toArray();
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public void update(ViewerCell cell) {
        String value = null;
        if (cell.getElement() instanceof PerfMappingRow) {
            PerfMappingRow row = (PerfMappingRow)cell.getElement();
            int colIndex = cell.getColumnIndex();
            switch (colIndex) {
                case 0: {
                    value = row.cfi.m_class;
                    if (!row.cfi.isValidClassName()) {
                        cell.setBackground(BMUI.color_light_red);
                        break;
                    }
                    cell.setBackground(null);
                    break;
                }
                case 1: {
                    value = row.cfi.m_filed;
                    if (!row.cfi.isValidColumn()) {
                        cell.setBackground(BMUI.color_light_red);
                        break;
                    }
                    cell.setBackground(null);
                    break;
                }
                case 2: {
                    value = row.cfi.m_intervalOrigStr;
                    if (!row.cfi.isValidInterval()) {
                        cell.setBackground(BMUI.color_light_red);
                        break;
                    }
                    cell.setBackground(null);
                    break;
                }
                case 3: {
                    if (row.pattern == null) {
                        cell.setBackground(BMUI.color_light_red);
                        break;
                    }
                    value = row.pattern.getOvPattern();
                    cell.setBackground(null);
                    break;
                }
                default: {
                    value = "unknown column index: " + colIndex;
                }
            }
            cell.setText(value);
        }
    }

    public void dispose() {
    }

    protected void measure(Event event, Object element) {
    }

    protected void paint(Event event, Object element) {
    }

    public PerfMappingRow getPerfMappingRow(int position) {
        return this.rows.get(position);
    }

    public PerfMappingRow deleteRow(int rowNumber) {
        return this.rows.remove(rowNumber);
    }

    public void addRow(PerfMappingRow row) {
        this.rows.add(row);
    }

    public void setRow(int position, PerfMappingRow row) {
        this.rows.set(position, row);
    }

    public void applyCacheToPolicy() {
        this.policy.getClassMap().clear();
        for (PerfMappingRow row : this.rows) {
            this.policy.getClassMap().put(row.pattern, row.cfi);
        }
    }

    public static class PerfMappingRow {
        public final PatternB pattern;
        public final CFI cfi;

        public PerfMappingRow(PatternB pattern, CFI cfi) {
            this.pattern = pattern;
            this.cfi = cfi;
        }
    }
}

