/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.gui.dialogs.CustomerAttributesDialog;
import com.blixx.boom.gui.utils.GUIDisplayElements;
import com.blixx.boom.gui.utils.ImageCombo;
import com.blixx.boom.gui.utils.IntervalHelpListener2;
import com.blixx.boom.gui.views.MonitorCondListProvider;
import com.blixx.boom.gui.views.MonitorPolicyTab;
import com.blixx.boom.gui.views.Proposals;
import com.blixx.log.RTLogger;
import com.blixx.shared.Condition;
import com.blixx.shared.Interval;
import com.blixx.shared.Policy;
import com.blixx.shared.Severity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.bindings.keys.ParseException;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.SimpleContentProposalProvider;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class MonitorCondDetails
implements ModifyListener,
SelectionListener,
MouseListener {
    public static final String[] PROPOSALS_DEFAULT = new String[]{"<$AGENT_HOST>", "<$AGENT_ID>", "<$AGENT_IP>", "<$APPLICATION>", "<$GROUP>", "<$HOST>", "<$OBJECT>", "<$OPTIONS>", "<$ORIG_OBJECT>", "<$SEVERITY>", "<$TIME>", "<$THRESHOLD>", "<$VALUE>"};
    public Policy m_policy = null;
    public MonitorPolicyTab m_policyTab = null;
    public static MonitorCondDetails m_monCondDetails = null;
    public boolean m_init = true;
    public boolean m_dataChanged = true;
    public Composite m_parent = null;
    public MonitorCondListProvider m_condList = null;
    public Condition m_conditionClass;
    public GUIDisplayElements m_guiElements = null;
    public Text m_condName_Field;
    public Text m_condReset_Field;
    public Button m_condIgnoreReset_YesButton;
    public Button m_condIgnoreReset_NoButton;
    public Button m_condSendFirst;
    public Text m_condObject_Field;
    public Text m_condSetNode_Field;
    public Text m_condSetApplication_Field;
    public Text m_condSetObject_Field;
    public Text m_condSetGroup_Field;
    public ImageCombo m_condSeverity_Combo;
    public Text m_condAutoaction_Field;
    public Text m_condOpaction_Field;
    public Text m_condResend_Field;
    public Text m_condSilenceCount_Field;
    public Text m_condAdvice_Field;
    public Text m_condInstruction_Field;
    public Text m_condThreshold_Field;
    public Text m_condCloseMask_Field;
    public Text m_condKey_Field;
    public Text m_condText_Field;
    public CCombo m_condAutoaction_CC;
    public ImageCombo m_condType_Combo;
    public Text m_condAA_TIMEOUT_Field;
    public Button m_cond_chType_a;
    public Button m_cond_chType_k;
    public Button m_chDedupl;
    public Button m_chDeduplKeyOnly;
    public Button m_cond_chInsertClosed;
    public Button m_cond_displayCA;
    private Text m_condID;
    public boolean m_isThresholdValid = false;
    public boolean m_isResetValid = false;
    public boolean m_isSilenceCountValid = false;
    public boolean m_isTimeoutValid = false;
    public boolean m_isStartOnDupValid = false;
    public static String COND_AUTOACTION_HOST = "autoactionHost";
    public static final String SELECT_TYPE_A = "type_a";
    public static final String SELECT_TYPE_K = "type_k";
    public static final String SELECT_DEDUPL = "dedupl";
    public static final String SELECT_DEDUPL_KEYONLY = "deduplKeyOnly";
    public static final String SELECT_INSERT_CLOSED = "insert_closed";
    public static final String BUTTON_DISPLAY_CA = "display_customer_attributes";
    private List<String> m_registerMouseClick = new ArrayList<String>();
    private static HashMap<String, Image> m_severityList = new HashMap();
    private static String[] m_condTypeList_TXT;
    private static HashMap<String, Image> m_condTypeList_ICONS;
    private SimpleContentProposalProvider m_Proposals4setText;
    public CustomerAttributesDialog m_cad;
    public Text m_condAAStartOnDuplicate;
    private Text resetStateInterval;

    static {
        m_severityList.put("critical", BMUI.IMAGE_CRITICAL);
        m_severityList.put("major", BMUI.IMAGE_MAJOR);
        m_severityList.put("minor", BMUI.IMAGE_MINOR);
        m_severityList.put("warning", BMUI.IMAGE_WARNING);
        m_severityList.put("normal", BMUI.IMAGE_NORMAL);
        m_severityList.put("unknown", null);
        m_condTypeList_TXT = new String[]{"SEND", "STOP"};
        m_condTypeList_ICONS = new HashMap();
        m_condTypeList_ICONS.put("SEND", null);
        m_condTypeList_ICONS.put("STOP", BMUI.IMAGE_STOP);
    }

    public MonitorCondDetails(Policy p, MonitorPolicyTab policyTab, Composite parent, MonitorCondListProvider cList, Condition c) {
        this.m_parent = parent;
        this.m_policy = p;
        this.m_policyTab = policyTab;
        this.m_condList = cList;
        this.m_conditionClass = c;
        if (this.m_conditionClass == null) {
            this.m_conditionClass = Condition.getNew(0);
            this.m_condList.addCondition(null);
        }
        m_monCondDetails = this;
        this.m_guiElements = new GUIDisplayElements();
        try {
            this.init();
            this.refreshFields(true);
        }
        catch (RuntimeException e) {
            RTLogger.print(5, "Error opening MonitorConditionDetails", e);
        }
        this.m_init = false;
        this.validateThreshold();
        this.validateReset();
        this.validateSilenceCount();
        this.validateTimeout();
        this.validateStartOnDup();
    }

    public void init() {
        Composite compRight = new Composite(this.m_parent, 0);
        GridLayout gl = new GridLayout(2, false);
        gl.verticalSpacing = 0;
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        gl.marginTop = 5;
        compRight.setLayout((Layout)gl);
        compRight.setLayoutData((Object)new GridData(4, 4, true, false, 6, 1));
        this.m_condName_Field = this.m_guiElements.addInputFieldSingle(compRight, MonitorPolicyTab.COND_NAME, "Name: ", null, 1, 1, 1, 1, 80, this);
        this.m_condID = this.m_guiElements.addTextReadOnly(compRight, "ID: ", null, 1, 1, 1, 1, null, null);
        this.m_condAdvice_Field = this.m_guiElements.addInputFieldMultiLineWrap(compRight, MonitorPolicyTab.COND_ADVICE, "Advice:   ", null, 1, 1, 90, 80, 1, 1, this);
        this.m_condInstruction_Field = this.m_guiElements.addInputFieldSingle(compRight, MonitorPolicyTab.COND_INSTRUCTION, "Instruction URL: ", "", 1, 1, 1, 6, 80, this);
        SimpleContentProposalProvider instructionsMonitorProvider = new SimpleContentProposalProvider(Proposals.SERVER_INSTRUCTIONS_MONITOR);
        this.setContentAssist((Control)this.m_condInstruction_Field, instructionsMonitorProvider);
        this.m_guiElements.addTextField(compRight, null, "", 1, 1, 1, 0, null);
        Composite comp5 = new Composite(compRight, 0);
        comp5.setLayout((Layout)new GridLayout(3, false));
        comp5.setLayoutData((Object)new GridData(4, 4, false, false));
        Group radioBtnGroup = new Group(comp5, 0);
        radioBtnGroup.setText("Metric");
        gl = new GridLayout(1, false);
        gl.marginHeight = 0;
        gl.verticalSpacing = 0;
        radioBtnGroup.setLayout((Layout)gl);
        radioBtnGroup.setLayoutData((Object)new GridData(1, 128, false, false));
        this.m_cond_chType_a = this.m_guiElements.addCheckbox((Composite)radioBtnGroup, SELECT_TYPE_A, "Availability Metric", false, 1, 1, 5, this);
        ((GridData)this.m_cond_chType_a.getLayoutData()).verticalAlignment = 128;
        this.m_cond_chType_k = this.m_guiElements.addCheckbox((Composite)radioBtnGroup, SELECT_TYPE_K, "KPI Metric", false, 1, 1, 5, this);
        ((GridData)this.m_cond_chType_k.getLayoutData()).verticalAlignment = 128;
        Group deduplGR = new Group(comp5, 0);
        deduplGR.setText("De-duplication");
        gl = new GridLayout(1, false);
        gl.marginHeight = 0;
        gl.verticalSpacing = 0;
        deduplGR.setLayout((Layout)gl);
        deduplGR.setLayoutData((Object)new GridData(1, 128, false, false));
        deduplGR.setToolTipText("De-duplication can be disabled\nonly for conditions without Close Mask");
        this.m_chDedupl = this.m_guiElements.addCheckbox((Composite)deduplGR, SELECT_DEDUPL, "Detect Duplicates", true, 1, 1, 5, null, this);
        this.m_chDeduplKeyOnly = this.m_guiElements.addCheckbox((Composite)deduplGR, SELECT_DEDUPL_KEYONLY, "De-Duplicate KeyOnly", true, 1, 1, 5, null, this);
        Composite comp0 = new Composite(comp5, 0);
        gl = new GridLayout(1, false);
        gl.marginHeight = 0;
        gl.verticalSpacing = 0;
        comp0.setLayout((Layout)gl);
        comp0.setLayoutData((Object)new GridData(1, 128, false, false));
        this.m_cond_chInsertClosed = this.m_guiElements.addCheckbox(comp0, SELECT_INSERT_CLOSED, "Add As Closed", false, 1, 1, 0, this);
        ((GridData)this.m_cond_chInsertClosed.getLayoutData()).verticalIndent = 10;
        this.m_cond_displayCA = this.m_guiElements.addButton(comp0, BUTTON_DISPLAY_CA, "", true, 95, 20, 11, this);
        ((GridData)this.m_cond_displayCA.getLayoutData()).horizontalIndent = 0;
        ((GridData)this.m_cond_displayCA.getLayoutData()).verticalIndent = 0;
        ((GridData)this.m_cond_displayCA.getLayoutData()).verticalAlignment = 128;
        Composite compCloseMask = new Composite(this.m_parent, 64);
        gl = new GridLayout(2, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        gl.marginBottom = 5;
        gl.marginLeft = 5;
        gl.verticalSpacing = 0;
        compCloseMask.setLayout((Layout)gl);
        GridData gd = new GridData(256);
        gd.horizontalSpan = 8;
        compCloseMask.setLayoutData((Object)gd);
        this.m_condKey_Field = this.m_guiElements.addInputFieldSingle(compCloseMask, MonitorPolicyTab.COND_KEY, "Indication Key:  ", null, 1, 1, 6, 5, 80, this);
        ((GridData)this.m_condKey_Field.getLayoutData()).horizontalIndent = 21;
        this.m_condKey_Field.addMouseListener((MouseListener)this);
        this.m_condKey_Field.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                MonitorCondDetails.this.m_registerMouseClick.remove(MonitorPolicyTab.COND_KEY);
                if (MonitorCondDetails.this.m_condKey_Field.getText().trim().equals("")) {
                    MonitorCondDetails.setFieldToGlobalValue(MonitorCondDetails.this.m_condKey_Field, MonitorCondDetails.this.m_policy.getKey());
                }
            }

            public void focusGained(FocusEvent e) {
            }
        });
        this.m_Proposals4setText = new SimpleContentProposalProvider(PROPOSALS_DEFAULT);
        this.setContentAssist((Control)this.m_condKey_Field, this.m_Proposals4setText);
        this.m_condCloseMask_Field = this.m_guiElements.addInputFieldSingle(compCloseMask, MonitorPolicyTab.COND_CLOSE_MASK, "Close Mask:  ", null, 1, 1, 6, 5, 80, this);
        ((GridData)this.m_condCloseMask_Field.getLayoutData()).horizontalIndent = 21;
        this.setContentAssist((Control)this.m_condCloseMask_Field, this.m_Proposals4setText);
        Composite comp1 = new Composite(this.m_parent, 0);
        gl = new GridLayout(2, false);
        gl.verticalSpacing = 0;
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        gl.marginBottom = 5;
        gl.marginLeft = 5;
        comp1.setLayout((Layout)gl);
        gd = new GridData(256);
        gd.horizontalSpan = 8;
        comp1.setLayoutData((Object)gd);
        Composite compLeft = new Composite(comp1, 0);
        gl = new GridLayout(5, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        gl.marginLeft = 10;
        gl.marginTop = 10;
        gl.marginRight = 15;
        gl.verticalSpacing = 1;
        compLeft.setLayout((Layout)gl);
        compLeft.setLayoutData((Object)new GridData(4, 128, false, false, 1, 3));
        this.m_condThreshold_Field = this.m_guiElements.addInputFieldSingle(compLeft, MonitorPolicyTab.COND_THRESHOLD, "Threshold:  ", null, 4, 1, 1, 1, 210, this);
        this.m_condReset_Field = this.m_guiElements.addInputFieldSingle(compLeft, MonitorPolicyTab.COND_RESET, "Reset:  ", null, 4, 1, 1, 0, 80, this);
        Label l = this.m_guiElements.addTextField(compLeft, null, "Ignore Reset:  ", 1, 1, 0, 0, null);
        ((GridData)l.getLayoutData()).verticalAlignment = 0x1000000;
        Composite compReset = new Composite(compLeft, 0);
        gl = new GridLayout(2, false);
        gl.verticalSpacing = 0;
        gl.marginWidth = 0;
        gl.marginBottom = 3;
        gl.marginTop = 3;
        gl.marginHeight = 1;
        compReset.setLayout((Layout)gl);
        compReset.setLayoutData((Object)new GridData(4, 128, false, false, 4, 1));
        this.m_condIgnoreReset_YesButton = this.m_guiElements.addRadioButton(compReset, MonitorPolicyTab.COND_IGNORERESET_YES, "YES", false, 1, 1, 1, 3, this);
        this.m_condIgnoreReset_NoButton = this.m_guiElements.addRadioButton(compReset, MonitorPolicyTab.COND_IGNORERESET_NO, "NO", false, 1, 1, 1, 3, this);
        this.m_condSilenceCount_Field = this.m_guiElements.addInputFieldSingle(compLeft, MonitorPolicyTab.COND_DURATION, "Silence Count:     ", null, 1, 1, 1, 1, 60, this);
        ((GridData)this.m_condSilenceCount_Field.getLayoutData()).horizontalAlignment = 16384;
        this.resetStateInterval = this.m_guiElements.addInputFieldSingle(compLeft, MonitorPolicyTab.COND_RESEND, "   Reset Condition State: ", null, 1, 1, 1, 1, 60, this);
        Label helpIcon = new Label(compLeft, 0);
        gd = new GridData(16384, 0x1000000, false, false);
        gd.horizontalIndent = 3;
        helpIcon.setLayoutData((Object)gd);
        helpIcon.setImage(BMUI.IMAGE_HELP);
        helpIcon.addListener(4, (Listener)new IntervalHelpListener2());
        this.resetStateInterval.setToolTipText("Reset state of condition after defined interval\nif threshold remains unchanged will send new indication or reset silence count\nNOTE: Works on boom Agents v5.7 and higher.");
        this.m_condSeverity_Combo = this.m_guiElements.addDropDownWithImage(compLeft, MonitorPolicyTab.COND_SEVERITY, "Severity: ", MonitorCondDetails.getSeverityImageList(), MonitorCondDetails.getSeverityTextList(), null, null, 4, 1, 1, 1, null);
        this.m_condSeverity_Combo.addSelectionListener(this);
        ((GridData)this.m_condSeverity_Combo.getLayoutData()).widthHint = 100;
        ((GridData)this.m_condSeverity_Combo.getLayoutData()).horizontalAlignment = 16384;
        this.m_condSeverity_Combo.setEditable(false);
        this.m_condType_Combo = this.m_guiElements.addDropDownWithImage(compLeft, MonitorPolicyTab.COND_TYPE, "Condition Type: ", m_condTypeList_ICONS, m_condTypeList_TXT, null, null, 4, 1, 1, 1, null);
        this.m_condType_Combo.addSelectionListener(this);
        ((GridData)this.m_condType_Combo.getLayoutData()).widthHint = 100;
        ((GridData)this.m_condType_Combo.getLayoutData()).horizontalAlignment = 16384;
        this.m_condType_Combo.setEditable(false);
        this.m_condOpaction_Field = this.m_guiElements.addInputFieldSingle(compLeft, MonitorPolicyTab.COND_OPACTION, "Operator Action:   ", null, 4, 1, 1, 1, 60, this);
        this.setContentAssist((Control)this.m_condOpaction_Field, this.m_Proposals4setText);
        this.m_condAA_TIMEOUT_Field = this.m_guiElements.addInputFieldSingle(compLeft, MonitorPolicyTab.COND_AUTOACTION_TIMEOUT, "AA Timeout (sec):   ", null, 1, 1, 1, 1, 60, this);
        ((GridData)this.m_condAA_TIMEOUT_Field.getLayoutData()).horizontalAlignment = 16384;
        this.m_condAAStartOnDuplicate = this.m_guiElements.addInputFieldSingle(compLeft, MonitorPolicyTab.COND_AA_START_ONDUPLICATE, "AA Start on duplicate:   ", "0", 2, 1, 1, 1, 30, this);
        ((GridData)this.m_condAAStartOnDuplicate.getLayoutData()).horizontalAlignment = 4;
        Composite compRight2 = new Composite(comp1, 0);
        gl = new GridLayout(2, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        gl.verticalSpacing = 1;
        compRight2.setLayout((Layout)gl);
        compRight2.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        this.m_condObject_Field = this.m_guiElements.addInputFieldSingle(compRight2, MonitorPolicyTab.COND_OBJECT, "Object: ", null, 1, 1, 5, 10, 60, this);
        ((GridData)this.m_condObject_Field.getLayoutData()).verticalIndent = 10;
        Group overwrite_grp = new Group(compRight2, 0);
        gl = new GridLayout(2, false);
        gl.marginRight = 5;
        gl.verticalSpacing = 0;
        overwrite_grp.setLayout((Layout)gl);
        gd = new GridData(4, 128, true, false, 2, 1);
        gd.verticalIndent = 5;
        overwrite_grp.setText("Overwrite Attributes");
        overwrite_grp.setLayoutData((Object)gd);
        this.m_condSetApplication_Field = this.m_guiElements.addInputFieldSingle((Composite)overwrite_grp, MonitorPolicyTab.COND_SET_APPLICATON, "Set Application: ", null, 1, 1, 1, 1, 60, this);
        this.m_condSetApplication_Field.setTextLimit(255);
        this.m_condSetApplication_Field.addMouseListener((MouseListener)this);
        this.m_condSetApplication_Field.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                MonitorCondDetails.this.m_registerMouseClick.remove(MonitorPolicyTab.COND_SET_APPLICATON);
                if (MonitorCondDetails.this.m_condSetApplication_Field.getText().trim().equals("")) {
                    MonitorCondDetails.setFieldToGlobalValue(MonitorCondDetails.this.m_condSetApplication_Field, MonitorCondDetails.this.m_policy.getSetApplication());
                }
            }

            public void focusGained(FocusEvent e) {
            }
        });
        this.setContentAssist((Control)this.m_condSetApplication_Field, this.m_Proposals4setText);
        this.m_condSetGroup_Field = this.m_guiElements.addInputFieldSingle((Composite)overwrite_grp, MonitorPolicyTab.COND_SET_GROUP, "Set Group: ", null, 1, 1, 1, 1, 60, this);
        this.m_condSetGroup_Field.setTextLimit(255);
        this.m_condSetGroup_Field.addMouseListener((MouseListener)this);
        this.m_condSetGroup_Field.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                MonitorCondDetails.this.m_registerMouseClick.remove(MonitorPolicyTab.COND_SET_GROUP);
                if (MonitorCondDetails.this.m_condSetGroup_Field.getText().trim().equals("")) {
                    MonitorCondDetails.setFieldToGlobalValue(MonitorCondDetails.this.m_condSetGroup_Field, MonitorCondDetails.this.m_policy.getSetGroup());
                }
            }

            public void focusGained(FocusEvent e) {
            }
        });
        this.setContentAssist((Control)this.m_condSetGroup_Field, this.m_Proposals4setText);
        this.m_condSetObject_Field = this.m_guiElements.addInputFieldSingle((Composite)overwrite_grp, MonitorPolicyTab.COND_SET_OBJECT, "Set Object: ", null, 1, 1, 1, 1, 60, this);
        this.m_condSetObject_Field.setTextLimit(255);
        this.setContentAssist((Control)this.m_condSetObject_Field, this.m_Proposals4setText);
        this.m_condSetNode_Field = this.m_guiElements.addInputFieldSingle((Composite)overwrite_grp, MonitorPolicyTab.COND_SET_NODE, "Set Host: ", null, 1, 1, 1, 0, 60, this);
        this.m_condSetNode_Field.setTextLimit(255);
        this.setContentAssist((Control)this.m_condSetNode_Field, this.m_Proposals4setText);
        this.m_condAutoaction_Field = this.m_guiElements.addInputFieldSingle(compRight2, MonitorPolicyTab.COND_AUTOACTION, "Auto Action:   ", null, 1, 1, 5, 5, 80, this);
        this.m_condAutoaction_Field.setTextLimit(255);
        this.setContentAssist((Control)this.m_condAutoaction_Field, this.m_Proposals4setText);
        this.m_condAutoaction_CC = this.m_guiElements.addDropDownEditable(compRight2, COND_AUTOACTION_HOST, "AA Host: ", this.m_policyTab.getHostList(), this.m_policyTab.getSelectedHost(this.m_conditionClass), "Select Agent", 1, 1, 5, 1, this);
        this.m_condAutoaction_CC.setVisibleItemCount(10);
        ((GridData)this.m_condAutoaction_CC.getLayoutData()).horizontalAlignment = 4;
        ((GridData)this.m_condAutoaction_CC.getLayoutData()).widthHint = 40;
        Composite compText = new Composite(this.m_parent, 64);
        gl = new GridLayout(2, false);
        gl.marginWidth = 0;
        gl.marginLeft = 10;
        gl.marginBottom = 10;
        gl.verticalSpacing = 0;
        compText.setLayout((Layout)gl);
        compText.setLayoutData((Object)new GridData(4, 128, true, false, 8, 1));
        this.m_condText_Field = this.m_guiElements.addInputFieldMultiLineNoWrap(compText, MonitorPolicyTab.COND_TEXT, "Text: ", null, 1, 1, 40, 300, 5, 1, this);
        this.setContentAssist((Control)this.m_condText_Field, this.m_Proposals4setText);
        this.refreshProposals();
    }

    public void refreshFields(boolean autoValidation) {
        if (!autoValidation) {
            this.m_condReset_Field.removeModifyListener((ModifyListener)this);
            this.m_condThreshold_Field.removeModifyListener((ModifyListener)this);
            this.m_condSilenceCount_Field.removeModifyListener((ModifyListener)this);
            this.resetStateInterval.removeModifyListener((ModifyListener)this);
            this.m_condAA_TIMEOUT_Field.removeModifyListener((ModifyListener)this);
            this.m_condAAStartOnDuplicate.removeModifyListener((ModifyListener)this);
            this.refreshProposals();
        }
        this.m_condName_Field.setText(this.m_conditionClass.getDescription());
        if (this.m_conditionClass.isIgnoreReset()) {
            this.m_condIgnoreReset_YesButton.setSelection(true);
            this.m_condIgnoreReset_NoButton.setSelection(false);
        } else {
            this.m_condIgnoreReset_YesButton.setSelection(false);
            this.m_condIgnoreReset_NoButton.setSelection(true);
        }
        this.m_cond_chType_a.setSelection(false);
        if (this.m_conditionClass.getTypeA() > 0) {
            this.m_cond_chType_a.setSelection(true);
        }
        this.m_cond_chType_k.setSelection(false);
        if (this.m_conditionClass.getTypeK() > 0) {
            this.m_cond_chType_k.setSelection(true);
        }
        this.m_cond_chInsertClosed.setSelection(false);
        if (this.m_conditionClass.getInsertClosed() > 0) {
            this.m_cond_chInsertClosed.setSelection(true);
        }
        this.m_chDedupl.setSelection(this.m_conditionClass.isDedupl());
        this.m_chDeduplKeyOnly.setSelection(this.m_conditionClass.isDeduplKeyOnly());
        this.m_condSeverity_Combo.setText(Severity.getSeverity(this.m_conditionClass.getSetSeverity()));
        this.m_condAdvice_Field.setText(this.m_conditionClass.getHelptext());
        if (this.m_conditionClass.getInstructionAction() != null) {
            this.m_condInstruction_Field.setText(this.m_conditionClass.getInstructionAction());
        }
        this.setCAButtonText(this.getCAttributesSize());
        String msgKey = this.m_conditionClass.getKey();
        if (msgKey == null || msgKey.equals("")) {
            this.m_conditionClass.setKey("");
            this.m_condKey_Field.removeModifyListener((ModifyListener)this);
            this.m_condKey_Field.setText(this.m_policy.getKey());
            this.m_condKey_Field.setForeground(BMUI.color_darkGrey2);
            this.m_condKey_Field.addModifyListener((ModifyListener)this);
        } else {
            this.m_condKey_Field.setText(msgKey);
            this.m_condKey_Field.setForeground(BMUI.color_black);
        }
        this.m_condCloseMask_Field.setText(this.m_conditionClass.getCloseMask());
        if (this.m_conditionClass.getCloseMask() != null && this.m_conditionClass.getCloseMask().trim().length() > 0 && !this.m_conditionClass.isDedupl() && !this.m_conditionClass.isDeduplKeyOnly()) {
            this.m_chDedupl.setSelection(true);
            this.m_conditionClass.setDedupl(true);
        }
        if (!this.m_conditionClass.isIgnoreReset()) {
            this.m_condReset_Field.setText(String.valueOf(this.m_conditionClass.getReset()));
            this.m_condReset_Field.setEnabled(true);
        } else {
            this.m_condReset_Field.setText(String.valueOf(this.m_conditionClass.getThreshold()));
            this.m_condReset_Field.setEnabled(false);
        }
        this.m_condObject_Field.setText(this.m_conditionClass.getObjectFilter());
        this.m_condSetNode_Field.setText(this.m_conditionClass.getSetNode());
        this.m_condSetNode_Field.setTextLimit(255);
        String setAppl = this.m_conditionClass.getSetApplication();
        if (setAppl == null || setAppl.equals("")) {
            this.m_conditionClass.setSetApplication("");
            this.m_condSetApplication_Field.removeModifyListener((ModifyListener)this);
            this.m_condSetApplication_Field.setText(this.m_policy.getSetApplication());
            this.m_condSetApplication_Field.setForeground(BMUI.color_darkGrey2);
            this.m_condSetApplication_Field.addModifyListener((ModifyListener)this);
        } else {
            this.m_condSetApplication_Field.setText(setAppl);
            this.m_condSetApplication_Field.setForeground(BMUI.color_black);
        }
        this.m_condSetObject_Field.setText(this.m_conditionClass.getSetObject());
        String setGroup = this.m_conditionClass.getSetGroup();
        if (setGroup == null || setGroup.equals("")) {
            this.m_conditionClass.setSetGroup("");
            this.m_condSetGroup_Field.removeModifyListener((ModifyListener)this);
            this.m_condSetGroup_Field.setText(this.m_policy.getSetGroup());
            this.m_condSetGroup_Field.setForeground(BMUI.color_darkGrey2);
            this.m_condSetGroup_Field.addModifyListener((ModifyListener)this);
        } else {
            this.m_condSetGroup_Field.setText(setGroup);
            this.m_condSetGroup_Field.setForeground(BMUI.color_black);
        }
        this.m_condAutoaction_Field.setText(this.m_conditionClass.getAutoAction());
        this.m_condAutoaction_Field.setTextLimit(255);
        this.m_condAutoaction_CC.setText(this.m_conditionClass.getAutoAction_Node());
        this.m_condOpaction_Field.setText(this.m_conditionClass.getOpAction());
        this.m_condOpaction_Field.setTextLimit(255);
        this.m_condAA_TIMEOUT_Field.setText("" + this.m_conditionClass.getAutoActionTimeout());
        this.m_condAAStartOnDuplicate.setText("" + this.m_conditionClass.getAutoActionOnDuplicate());
        this.m_condSilenceCount_Field.setText(String.valueOf(this.m_conditionClass.getSilenceCount()));
        this.resetStateInterval.setText(Interval.getSimpleInterval(this.m_conditionClass.getResetStateMinutes() * 60).toString());
        this.m_condThreshold_Field.setText(String.valueOf(this.m_conditionClass.getThreshold()));
        this.m_condText_Field.setText(this.m_conditionClass.getSetText());
        this.m_condID.setText(this.m_conditionClass.getConditionId());
        String[] arr = this.m_policyTab.getHostList();
        String selected = this.m_policyTab.getSelectedHost(this.m_conditionClass);
        int i = 0;
        while (i < arr.length) {
            if (arr[i].endsWith(selected)) {
                this.m_condAutoaction_CC.select(i);
                break;
            }
            ++i;
        }
        if (!this.m_policy.isReset()) {
            this.m_guiElements.enableField(this.m_condReset_Field, false);
            this.m_condReset_Field.setText(this.m_condThreshold_Field.getText());
            this.m_guiElements.enableField(this.m_condIgnoreReset_NoButton, false);
            this.m_guiElements.enableField(this.m_condIgnoreReset_YesButton, false);
        }
        if (this.m_conditionClass.getActionType().equalsIgnoreCase("STOP")) {
            this.m_condType_Combo.select(1);
        } else {
            this.m_condType_Combo.select(0);
        }
        if (!autoValidation) {
            this.validateReset();
            this.validateThreshold();
            this.validateSilenceCount();
            this.validateTimeout();
            this.validateStartOnDup();
            this.m_condReset_Field.addModifyListener((ModifyListener)this);
            this.m_condThreshold_Field.addModifyListener((ModifyListener)this);
            this.m_condSilenceCount_Field.addModifyListener((ModifyListener)this);
            this.resetStateInterval.addModifyListener((ModifyListener)this);
            this.m_condAA_TIMEOUT_Field.addModifyListener((ModifyListener)this);
            this.m_condAAStartOnDuplicate.addModifyListener((ModifyListener)this);
        }
    }

    public Condition getCondition() {
        return this.m_conditionClass;
    }

    public void reload(Condition c, boolean dataChanged) {
        this.m_dataChanged = dataChanged;
        this.m_conditionClass = c;
        this.refreshFields(false);
        this.m_parent.redraw();
    }

    private Integer getCAttributesSize() {
        int size = 0;
        ArrayList<String> caList = this.m_conditionClass.clone().getCustomAttributes();
        int i = 0;
        while (i < caList.size()) {
            if (((String)caList.get(i)).trim().length() > 0) {
                ++size;
            }
            ++i;
        }
        return size;
    }

    private void setCAButtonText(int count) {
        this.m_cond_displayCA.setText("Custom Attributes (" + count + ")");
    }

    public static String[] getSeverityTextList() {
        return MonitorPolicyTab.SEVERITY_LIST;
    }

    public static HashMap<String, Image> getSeverityImageList() {
        return m_severityList;
    }

    public void updateCustomAttributes(List<String> customAttributes) {
        this.m_policyTab.setDirty(true);
        this.m_conditionClass.getCustomAttributes().clear();
        this.m_conditionClass.getCustomAttributes().addAll(customAttributes);
        this.setCAButtonText(this.getCAttributesSize());
    }

    public boolean validateAll() {
        return this.m_isThresholdValid && this.m_isResetValid && this.m_isSilenceCountValid && this.m_isTimeoutValid && this.m_isStartOnDupValid;
    }

    public void validateThreshold() {
        this.m_isThresholdValid = false;
        String value = this.m_condThreshold_Field.getText().trim();
        try {
            double val = Double.parseDouble(value);
            this.m_conditionClass.setThreshold(val);
            this.m_condThreshold_Field.setBackground(BMUI.defaultBackground);
            this.m_isThresholdValid = true;
        }
        catch (NumberFormatException numberFormatException) {
            if (value.isEmpty()) {
                this.m_conditionClass.setThreshold(0.0);
            }
            this.m_condThreshold_Field.setBackground(BMUI.color_critical);
        }
    }

    public void validateReset() {
        this.m_isResetValid = false;
        String value = this.m_condReset_Field.getText().trim();
        try {
            double reset = Double.parseDouble(value);
            if (!this.m_policy.getType().contains("MIN")) {
                this.m_conditionClass.setReset(reset);
                if (reset <= this.m_conditionClass.getThreshold()) {
                    this.m_condReset_Field.setBackground(BMUI.defaultBackground);
                    this.m_isResetValid = true;
                } else {
                    this.m_condReset_Field.setBackground(BMUI.color_critical);
                }
            } else {
                this.m_conditionClass.setReset(reset);
                if (reset >= this.m_conditionClass.getThreshold()) {
                    this.m_condReset_Field.setBackground(BMUI.defaultBackground);
                    this.m_isResetValid = true;
                } else {
                    this.m_condReset_Field.setBackground(BMUI.color_critical);
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            if (value.isEmpty()) {
                this.m_conditionClass.setReset(this.m_conditionClass.getThreshold());
            }
            this.m_condReset_Field.setBackground(BMUI.color_critical);
        }
    }

    public void validateSilenceCount() {
        this.m_isSilenceCountValid = false;
        String value = this.m_condSilenceCount_Field.getText().trim();
        try {
            long silenceCount = Long.parseLong(value);
            this.m_conditionClass.setSilenceCount(silenceCount);
            this.m_condSilenceCount_Field.setBackground(BMUI.defaultBackground);
            this.m_isSilenceCountValid = true;
        }
        catch (NumberFormatException numberFormatException) {
            this.m_condSilenceCount_Field.setBackground(BMUI.color_critical);
        }
    }

    public void validateTimeout() {
        this.m_isTimeoutValid = false;
        String value = this.m_condAA_TIMEOUT_Field.getText().trim();
        try {
            int timeout = Integer.parseInt(value);
            this.m_conditionClass.setAutoActionTimeout(timeout);
            this.m_condAA_TIMEOUT_Field.setBackground(BMUI.defaultBackground);
            this.m_isTimeoutValid = true;
        }
        catch (NumberFormatException numberFormatException) {
            this.m_condAA_TIMEOUT_Field.setBackground(BMUI.color_critical);
        }
    }

    public void validateStartOnDup() {
        this.m_isStartOnDupValid = false;
        String value = this.m_condAAStartOnDuplicate.getText().trim();
        try {
            int index = Integer.parseInt(value);
            this.m_conditionClass.setAutoActionOnDuplicate(index);
            this.m_condAAStartOnDuplicate.setBackground(BMUI.defaultBackground);
            this.m_isStartOnDupValid = true;
        }
        catch (NumberFormatException numberFormatException) {
            this.m_condAAStartOnDuplicate.setBackground(BMUI.color_critical);
        }
    }

    public void modifyText(ModifyEvent e) {
        if (this.m_init) {
            return;
        }
        Object obj = e.getSource();
        String fieldName = "";
        String oldValue = null;
        if (obj instanceof Text) {
            Text field = (Text)obj;
            try {
                fieldName = (String)field.getData();
            }
            catch (Exception exception) {}
            String value = field.getText();
            if (fieldName.equals(MonitorPolicyTab.COND_NAME)) {
                oldValue = this.m_conditionClass.getDescription();
                this.m_conditionClass.setDescription(value);
                this.m_condList.initList();
                this.m_condList.updateTable();
            } else if (fieldName.equals(MonitorPolicyTab.COND_OBJECT)) {
                oldValue = this.m_conditionClass.getObjectFilter();
                this.m_conditionClass.setObjectFilter(value);
            } else if (fieldName.equals(MonitorPolicyTab.COND_SET_NODE)) {
                oldValue = this.m_conditionClass.getSetNode();
                this.m_conditionClass.setSetNode(value);
            } else if (fieldName.equals(MonitorPolicyTab.COND_SET_APPLICATON)) {
                oldValue = this.m_conditionClass.getSetApplication();
                if (value == null || value.equals("")) {
                    this.m_conditionClass.setSetApplication("");
                    field.setForeground(BMUI.color_darkGrey2);
                    oldValue = null;
                } else {
                    this.m_conditionClass.setSetApplication(value);
                    field.setForeground(BMUI.color_black);
                }
            } else if (fieldName.equals(MonitorPolicyTab.COND_SET_OBJECT)) {
                oldValue = this.m_conditionClass.getSetObject();
                this.m_conditionClass.setSetObject(value);
            } else if (fieldName.equals(MonitorPolicyTab.COND_SET_GROUP)) {
                oldValue = this.m_conditionClass.getSetGroup();
                if (value == null || value.equals("")) {
                    this.m_conditionClass.setSetGroup("");
                    field.setForeground(BMUI.color_darkGrey2);
                    oldValue = null;
                } else {
                    this.m_conditionClass.setSetGroup(value);
                    field.setForeground(BMUI.color_black);
                }
            } else if (fieldName.equals(MonitorPolicyTab.COND_AUTOACTION)) {
                oldValue = this.m_conditionClass.getAutoAction();
                this.m_conditionClass.setAutoAction(value);
            } else if (fieldName.equals(MonitorPolicyTab.COND_OPACTION)) {
                oldValue = this.m_conditionClass.getOpAction();
                this.m_conditionClass.setOpAction(value);
            } else if (fieldName.equals(MonitorPolicyTab.COND_AUTOACTION_TIMEOUT)) {
                value = value.trim();
                oldValue = "" + this.m_conditionClass.getAutoActionTimeout();
                this.validateTimeout();
            } else if (fieldName.equals(MonitorPolicyTab.COND_AA_START_ONDUPLICATE)) {
                value = value.trim();
                oldValue = "" + this.m_conditionClass.getAutoActionOnDuplicate();
                this.validateStartOnDup();
            } else if (fieldName.equals(MonitorPolicyTab.COND_RESEND)) {
                try {
                    if (value == null || value.isEmpty()) {
                        this.m_conditionClass.setResetStateMinutes(0);
                    } else {
                        Interval resetInterval = Interval.parseInterval(value = value.trim(), -1);
                        if (resetInterval.getIntervalSeconds() == -1) {
                            throw new Exception("Invalid reset state interval " + value);
                        }
                        this.m_conditionClass.setResetStateMinutes(resetInterval.getIntervalMinutes());
                    }
                    this.resetStateInterval.setBackground(BMUI.defaultBackground);
                }
                catch (Exception exception) {
                    this.resetStateInterval.setBackground(BMUI.color_critical);
                }
            } else if (fieldName.equals(MonitorPolicyTab.COND_DURATION)) {
                value = value.trim();
                oldValue = "" + this.m_conditionClass.getSilenceCount();
                this.validateSilenceCount();
            } else if (fieldName.equals(MonitorPolicyTab.COND_ADVICE)) {
                oldValue = this.m_conditionClass.getHelptext();
                this.m_conditionClass.setHelptext(value);
            } else if (fieldName.equals(MonitorPolicyTab.COND_INSTRUCTION)) {
                oldValue = this.m_conditionClass.getInstructionAction();
                this.m_conditionClass.setInstructionAction(value);
            } else if (fieldName.equals(MonitorPolicyTab.COND_THRESHOLD)) {
                value = value.trim();
                oldValue = "" + this.m_conditionClass.getThreshold();
                this.validateThreshold();
                this.validateReset();
                this.m_condList.initList();
                this.m_condList.updateTable();
            } else if (fieldName.equals(MonitorPolicyTab.COND_KEY)) {
                oldValue = this.m_conditionClass.getKey();
                if (value == null || value.equals("")) {
                    this.m_conditionClass.setKey("");
                    field.setForeground(BMUI.color_darkGrey2);
                    oldValue = null;
                } else {
                    this.m_conditionClass.setKey(value);
                    field.setForeground(BMUI.color_black);
                }
            } else if (fieldName.equals(MonitorPolicyTab.COND_CLOSE_MASK)) {
                oldValue = this.m_conditionClass.getCloseMask();
                this.m_conditionClass.setCloseMask(value);
            } else if (fieldName.equals(MonitorPolicyTab.COND_TEXT)) {
                oldValue = this.m_conditionClass.getSetText();
                this.m_conditionClass.setSetText(value);
            } else if (fieldName.equals(MonitorPolicyTab.COND_RESET)) {
                oldValue = "" + this.m_conditionClass.getReset();
                this.validateReset();
                this.validateThreshold();
            }
            if (!this.m_dataChanged) {
                this.m_dataChanged = true;
            } else if (!this.m_init && !(oldValue == null ? "" : oldValue).replaceAll("\r*\n", "").equals((value == null ? "" : value).replaceAll("\r*\n", ""))) {
                this.m_policyTab.setDirty(true);
            }
        } else if (obj instanceof CCombo) {
            CCombo combo = (CCombo)obj;
            String comboName = (String)combo.getData();
            String value = combo.getText().trim();
            if (comboName.equals(COND_AUTOACTION_HOST)) {
                String newNode = null;
                newNode = value.indexOf(124) != -1 ? value.substring(value.indexOf(124) + 1) : value;
                if (!this.m_conditionClass.getAutoAction_Node().equals(newNode)) {
                    this.m_conditionClass.setAutoAction_Node(newNode);
                    if (!this.m_init) {
                        this.m_policyTab.setDirty(true);
                    }
                }
            }
        }
    }

    public void widgetSelected(SelectionEvent e) {
        String buttonName = "";
        Object obj = e.getSource();
        if (obj instanceof Button) {
            Button b = (Button)obj;
            buttonName = (String)b.getData();
            if (buttonName.equals(MonitorPolicyTab.COND_IGNORERESET_YES) && b.getSelection()) {
                if (!this.m_conditionClass.isIgnoreReset() && !this.m_init) {
                    this.m_condList.updateTable();
                    this.m_policyTab.setDirty(true);
                }
                this.m_conditionClass.setIgnoreReset(true);
                this.m_conditionClass.setReset(this.m_conditionClass.getThreshold());
                this.m_condReset_Field.setText("" + this.m_conditionClass.getReset());
                this.m_condReset_Field.setEnabled(false);
            } else if (buttonName.equals(MonitorPolicyTab.COND_IGNORERESET_NO) && b.getSelection()) {
                if (this.m_conditionClass.isIgnoreReset() && !this.m_init) {
                    this.m_condList.updateTable();
                    this.m_policyTab.setDirty(true);
                }
                this.m_conditionClass.setIgnoreReset(false);
                this.m_condReset_Field.setEnabled(true);
            } else if (buttonName.equals(SELECT_TYPE_A)) {
                this.m_conditionClass.setTypeA(0);
                if (this.m_cond_chType_a.getSelection()) {
                    this.m_conditionClass.setTypeA(1);
                    this.m_conditionClass.setTypeK(0);
                    this.m_cond_chType_k.setSelection(false);
                } else {
                    this.m_conditionClass.setTypeA(0);
                }
                if (!this.m_init) {
                    this.m_condList.updateTable();
                    this.m_policyTab.setDirty(true);
                }
            } else if (buttonName.equals(SELECT_TYPE_K)) {
                this.m_conditionClass.setTypeK(0);
                if (this.m_cond_chType_k.getSelection()) {
                    this.m_conditionClass.setTypeK(1);
                    this.m_conditionClass.setTypeA(0);
                    this.m_cond_chType_a.setSelection(false);
                } else {
                    this.m_conditionClass.setTypeK(0);
                }
                if (!this.m_init) {
                    this.m_condList.updateTable();
                    this.m_policyTab.setDirty(true);
                }
            } else if (buttonName.equals(SELECT_INSERT_CLOSED)) {
                this.m_conditionClass.setInsertClosed(0);
                if (this.m_cond_chInsertClosed.getSelection()) {
                    this.m_conditionClass.setInsertClosed(1);
                }
                if (!this.m_init) {
                    this.m_condList.updateTable();
                    this.m_policyTab.setDirty(true);
                }
            } else if (buttonName.equals(SELECT_DEDUPL)) {
                if (this.m_conditionClass.getCloseMask() != null && this.m_conditionClass.getCloseMask().trim().length() > 0 && this.m_conditionClass.isDedupl()) {
                    e.doit = false;
                    this.m_chDedupl.setSelection(true);
                } else {
                    this.m_conditionClass.setDedupl(this.m_chDedupl.getSelection());
                    if (this.m_conditionClass.isDedupl()) {
                        this.m_chDeduplKeyOnly.setSelection(false);
                        this.m_conditionClass.setDeduplKeyOnly(false);
                    }
                    if (!this.m_init) {
                        this.m_condList.updateTable();
                        this.m_policyTab.setDirty(true);
                    }
                }
            } else if (buttonName.equals(SELECT_DEDUPL_KEYONLY)) {
                if (this.m_conditionClass.getCloseMask() != null && this.m_conditionClass.getCloseMask().trim().length() > 0 && this.m_conditionClass.isDeduplKeyOnly()) {
                    e.doit = false;
                    this.m_chDeduplKeyOnly.setSelection(true);
                } else {
                    this.m_conditionClass.setDeduplKeyOnly(this.m_chDeduplKeyOnly.getSelection());
                    if (this.m_conditionClass.isDeduplKeyOnly()) {
                        this.m_chDedupl.setSelection(false);
                        this.m_conditionClass.setDedupl(false);
                    }
                    if (!this.m_init) {
                        this.m_condList.updateTable();
                        this.m_policyTab.setDirty(true);
                    }
                }
            } else if (buttonName.equals(BUTTON_DISPLAY_CA)) {
                ArrayList<String> cAttributes = this.m_conditionClass.clone().getCustomAttributes();
                if (this.m_cad == null || this.m_cad.isDisposed()) {
                    this.m_cad = new CustomerAttributesDialog(cAttributes, this.m_policyTab.isReadOnly(), this);
                    this.m_cad.open();
                } else {
                    this.m_cad.shellActivated(new ShellEvent(new Event()));
                }
            } else if (buttonName.equals(MonitorPolicyTab.COND_SEND_FIRST)) {
                this.m_conditionClass.setSendFirst(this.m_condSendFirst.getSelection());
                if (!this.m_init) {
                    this.m_condList.updateTable();
                    this.m_policyTab.setDirty(true);
                }
            }
        } else if (obj instanceof ImageCombo) {
            ImageCombo combo = (ImageCombo)((Object)obj);
            String comboName = (String)combo.getData();
            String value = combo.getText().trim();
            if (comboName.equals(MonitorPolicyTab.COND_SEVERITY)) {
                int newSev = Severity.getSeverity(value);
                if (this.m_conditionClass.getSetSeverity() != newSev) {
                    this.m_conditionClass.setSetSeverity(newSev);
                    if (!this.m_init) {
                        this.m_policyTab.setDirty(true);
                        this.m_condList.initList();
                        this.m_condList.updateTable();
                    }
                }
            } else if (comboName.equals(MonitorPolicyTab.COND_TYPE) && !this.m_conditionClass.getActionType().equals(value)) {
                this.m_conditionClass.setActionType(value);
                if (!this.m_init) {
                    this.m_condList.updateTable();
                    this.m_policyTab.setDirty(true);
                }
            }
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void mouseUp(MouseEvent e) {
        if (e.getSource() instanceof Text) {
            Text field = (Text)e.getSource();
            String name = (String)field.getData();
            if (name.equals(MonitorPolicyTab.COND_KEY)) {
                if (this.m_conditionClass.getKey() == null || this.m_conditionClass.getKey().equals("")) {
                    this.m_conditionClass.setKey("");
                    if (!this.m_registerMouseClick.contains(MonitorPolicyTab.COND_KEY)) {
                        this.m_registerMouseClick.add(MonitorPolicyTab.COND_KEY);
                        field.selectAll();
                    }
                }
            } else if (name.equals(MonitorPolicyTab.COND_SET_APPLICATON)) {
                if (this.m_conditionClass.getSetApplication() == null || this.m_conditionClass.getSetApplication().equals("")) {
                    this.m_conditionClass.setSetApplication("");
                    if (!this.m_registerMouseClick.contains(MonitorPolicyTab.COND_SET_APPLICATON)) {
                        this.m_registerMouseClick.add(MonitorPolicyTab.COND_SET_APPLICATON);
                        field.selectAll();
                    }
                }
            } else if (name.equals(MonitorPolicyTab.COND_SET_GROUP) && (this.m_conditionClass.getSetGroup() == null || this.m_conditionClass.getSetGroup().equals(""))) {
                this.m_conditionClass.setSetGroup("");
                if (!this.m_registerMouseClick.contains(MonitorPolicyTab.COND_SET_GROUP)) {
                    this.m_registerMouseClick.add(MonitorPolicyTab.COND_SET_GROUP);
                    field.selectAll();
                }
            }
        }
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseDown(MouseEvent e) {
    }

    public static void setFieldToGlobalValue(Text field, String value) {
        field.removeModifyListener((ModifyListener)m_monCondDetails);
        field.setText(value);
        field.addModifyListener((ModifyListener)m_monCondDetails);
        field.setForeground(BMUI.color_darkGrey2);
    }

    public void setContentAssist(Control ct, SimpleContentProposalProvider provider) {
        char[] autoActivationCharacters = new char[]{};
        try {
            KeyStroke keyStroke = KeyStroke.getInstance((String)"Ctrl+Space");
            new ContentProposalAdapter(ct, (IControlContentAdapter)new TextContentAdapter(), (IContentProposalProvider)provider, keyStroke, autoActivationCharacters);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    private void refreshProposals() {
        String[] props = PROPOSALS_DEFAULT;
        if (this.m_policy != null && ("STDDEV".equals(this.m_policy.getType()) || "STDDEVMIN".equals(this.m_policy.getType()))) {
            TreeSet<String> defaultProposals = new TreeSet<String>(Arrays.asList(props));
            defaultProposals.add("<$DA_AVERAGE>");
            defaultProposals.add("<$DA_COUNT>");
            defaultProposals.add("<$DA_STDDEV>");
            defaultProposals.add("<$ORIG_VALUE>");
            props = defaultProposals.toArray(new String[0]);
        }
        this.m_Proposals4setText.setProposals(props);
    }
}

