/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.gui.utils.GUIDisplayElements;
import com.blixx.boom.gui.views.MonitorCondDetails;
import com.blixx.boom.gui.views.MonitorPolicyTab;
import com.blixx.shared.Condition;
import com.blixx.shared.Conditions;
import com.blixx.shared.Policy;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.OwnerDrawLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Table;

public class MonitorCondListProvider
extends OwnerDrawLabelProvider
implements IStructuredContentProvider {
    public TableViewer m_tableViewer = null;
    private Conditions m_conditions = null;
    private Policy m_policy = null;
    private List<List<Object>> m_condTableList = new ArrayList<List<Object>>();
    public MonitorPolicyTab m_policyTab;
    public MonitorCondDetails m_conditionDetails = null;
    public static GUIDisplayElements m_guiElements = new GUIDisplayElements();
    private static String COLOR_UNKNOWN = "COLOR_UNKNOWN";
    private static String COLOR_NORMAL = "COLOR_NORMAL";
    private static String COLOR_WARNING = "COLOR_WARNING";
    private static String COLOR_MINOR = "COLOR_MINOR";
    private static String COLOR_MAJOR = "COLOR_MAJOR";
    private static String COLOR_CRITICAL = "COLOR_CRITICAL";
    private static String COLOR_LINE = "COLOR_LINE";
    private static String COLOR_SELECTED = "COLOR_SELECTED";

    static {
        JFaceResources.getColorRegistry().put(COLOR_UNKNOWN, BMUI.color_white.getRGB());
        JFaceResources.getColorRegistry().put(COLOR_NORMAL, BMUI.color_normal.getRGB());
        JFaceResources.getColorRegistry().put(COLOR_WARNING, BMUI.color_warning.getRGB());
        JFaceResources.getColorRegistry().put(COLOR_MINOR, BMUI.color_minor.getRGB());
        JFaceResources.getColorRegistry().put(COLOR_MAJOR, BMUI.color_major.getRGB());
        JFaceResources.getColorRegistry().put(COLOR_CRITICAL, BMUI.color_critical.getRGB());
        JFaceResources.getColorRegistry().put(COLOR_LINE, BMUI.color_unknown.getRGB());
        JFaceResources.getColorRegistry().put(COLOR_SELECTED, new RGB(10, 36, 106));
    }

    public MonitorCondListProvider(TableViewer tv, Conditions cs, Policy p, MonitorPolicyTab policyTab) {
        this.m_tableViewer = tv;
        this.m_conditions = cs;
        this.m_policy = p;
        this.m_policyTab = policyTab;
        this.initList();
        this.setOwnerDrawEnabled((ColumnViewer)tv, null, false);
    }

    public void initList() {
        ArrayList<Object> subList = null;
        this.m_condTableList = new ArrayList<List<Object>>();
        List<Condition> list = this.getCondList();
        int i = 0;
        while (i < list.size()) {
            Condition c = list.get(i);
            subList = new ArrayList<Object>();
            subList.add(i);
            subList.add(c);
            this.m_condTableList.add(subList);
            ++i;
        }
    }

    public void updateList() {
        this.initList();
    }

    public void updateTable() {
        if (this.m_tableViewer.getContentProvider() != null) {
            this.m_tableViewer.setInput((Object)this.getElements(null));
        }
    }

    public void moveOneUp() {
        int ind = this.m_tableViewer.getTable().getSelectionIndex();
        if (ind != 0 && ind > 0) {
            Condition c = this.getCondList().remove(ind);
            this.getCondList().add(ind - 1, c);
            this.updateList();
            this.updateTable();
            this.setTableSelection(ind - 1, true);
        }
    }

    public void moveOneDown() {
        int count;
        int ind = this.m_tableViewer.getTable().getSelectionIndex();
        if (ind != (count = this.m_condTableList.size()) - 1 && ind > -1) {
            Condition c = this.getCondList().remove(ind);
            this.getCondList().add(ind + 1, c);
            this.updateList();
            this.updateTable();
            this.setTableSelection(ind + 1, true);
        }
    }

    public void moveToTop() {
        int ind = this.m_tableViewer.getTable().getSelectionIndex();
        if (ind != 0 && ind > 0) {
            Condition c = this.getCondList().remove(ind);
            this.getCondList().add(0, c);
            this.updateList();
            this.updateTable();
            this.setTableSelection(0, true);
        }
    }

    public void moveToBottom() {
        int count;
        int ind = this.m_tableViewer.getTable().getSelectionIndex();
        if (ind != (count = this.m_condTableList.size()) - 1 && ind < count - 1) {
            Condition c = this.getCondList().remove(ind);
            this.getCondList().add(count - 1, c);
            this.updateList();
            this.updateTable();
            this.setTableSelection(count - 1, true);
        }
    }

    public void addCondition(Condition condition) {
        if (condition == null) {
            this.m_policy.getConditions().addNewCondition();
        } else {
            this.m_policy.getConditions().addCondition(condition);
        }
        this.updateList();
        this.updateTable();
        int count = this.m_policy.getConditions().getConditionList().size();
        this.setTableSelection(count - 1, true);
        this.m_conditionDetails.reload((Condition)this.m_policy.getConditions().getConditionList().get(count - 1), true);
    }

    public void duplicateCondition() {
        int[] sIndices = this.m_tableViewer.getTable().getSelectionIndices();
        if (sIndices.length == 0) {
            return;
        }
        int i = 0;
        while (i < sIndices.length) {
            Condition cond = this.getCondList().get(sIndices[i]);
            Condition newCond = cond.clone();
            this.getCondList().add(newCond);
            ++i;
        }
        this.updateList();
        this.updateTable();
        int count = this.m_policy.getConditions().getConditionList().size();
        this.setTableSelection(count - 1, true);
        try {
            this.m_conditionDetails.reload((Condition)this.m_policy.getConditions().getConditionList().get(count - 1), true);
        }
        catch (Exception exception) {}
    }

    public void deleteCondition() {
        List<Condition> condList = this.getCondList();
        ArrayList<Condition> selection = new ArrayList<Condition>();
        int[] sIndices = this.m_tableViewer.getTable().getSelectionIndices();
        if (sIndices.length == 0) {
            return;
        }
        int i = 0;
        while (i < sIndices.length) {
            selection.add(condList.get(sIndices[i]));
            ++i;
        }
        condList.removeAll(selection);
        int newSelection = sIndices[0];
        if (condList.size() != 0 && condList.size() <= newSelection) {
            --newSelection;
        }
        this.updateList();
        this.updateTable();
        this.setTableSelection(newSelection, true);
        try {
            this.m_conditionDetails.reload((Condition)this.m_policy.getConditions().getConditionList().get(newSelection), true);
        }
        catch (Throwable throwable) {}
    }

    public void setTableSelection(int index, boolean refreshTV) {
        int pos;
        Table table = this.m_tableViewer.getTable();
        if (table.getItemCount() == 0) {
            this.addCondition(null);
            return;
        }
        if (index == -1 && this.m_policyTab.m_selectedCondUUID == null) {
            table.select(0);
            table.setSelection(0);
            this.m_policyTab.m_selectedCond = (Condition)this.m_policy.getConditions().getConditionList().get(0);
            this.m_policyTab.m_selectedCondUUID = this.m_policyTab.m_selectedCond.getConditionId();
        } else if (index != -1) {
            table.select(index);
            table.setSelection(index);
            this.m_policyTab.m_selectedCond = (Condition)this.m_policy.getConditions().getConditionList().get(index);
            this.m_policyTab.m_selectedCondUUID = this.m_policyTab.m_selectedCond.getConditionId();
        } else if (this.m_policyTab.m_selectedCondUUID != null && (pos = this.m_policy.getConditions().getConditionNumber(this.m_policyTab.m_selectedCondUUID)) != -1) {
            table.select(pos);
            table.setSelection(pos);
        }
        if (refreshTV) {
            this.m_tableViewer.refresh();
        }
    }

    public void setConditionDetails(MonitorCondDetails condDetails) {
        this.m_conditionDetails = condDetails;
    }

    public Object[] getElements(Object inputElement) {
        return this.m_condTableList.toArray();
    }

    public List<Condition> getCondList() {
        return this.m_conditions.getConditionList();
    }

    public int getRowIndex(String condID) {
        int rowIndex = -1;
        List<Condition> condList = this.getCondList();
        int i = 0;
        while (i < condList.size()) {
            Condition cond = condList.get(i);
            if (cond.getConditionId().equals(condID)) {
                rowIndex = i;
                break;
            }
            ++i;
        }
        return rowIndex;
    }

    public void checkButtonStatus() {
        if (this.m_policyTab.isReadOnly() || this.m_tableViewer.getTable() == null || this.m_tableViewer.getTable().isDisposed()) {
            return;
        }
        int count = this.m_condTableList.size();
        if (count == 0) {
            m_guiElements.enableField(this.m_policyTab.m_up_Button, false);
            m_guiElements.enableField(this.m_policyTab.m_down_Button, false);
            m_guiElements.enableField(this.m_policyTab.m_top_Button, false);
            m_guiElements.enableField(this.m_policyTab.m_bottom_Button, false);
            m_guiElements.enableField(this.m_policyTab.m_copy_Button, false);
            m_guiElements.enableField(this.m_policyTab.m_delete_Button, false);
            m_guiElements.enableField(this.m_policyTab.m_add_Button, true);
        } else if (count == 1) {
            m_guiElements.enableField(this.m_policyTab.m_up_Button, false);
            m_guiElements.enableField(this.m_policyTab.m_down_Button, false);
            m_guiElements.enableField(this.m_policyTab.m_top_Button, false);
            m_guiElements.enableField(this.m_policyTab.m_bottom_Button, false);
            m_guiElements.enableField(this.m_policyTab.m_copy_Button, true);
            m_guiElements.enableField(this.m_policyTab.m_delete_Button, false);
            m_guiElements.enableField(this.m_policyTab.m_add_Button, true);
        } else if (count > 1) {
            int[] sIndices = this.m_tableViewer.getTable().getSelectionIndices();
            if (sIndices.length == 0) {
                m_guiElements.enableField(this.m_policyTab.m_up_Button, false);
                m_guiElements.enableField(this.m_policyTab.m_down_Button, false);
                m_guiElements.enableField(this.m_policyTab.m_top_Button, false);
                m_guiElements.enableField(this.m_policyTab.m_bottom_Button, false);
                m_guiElements.enableField(this.m_policyTab.m_copy_Button, false);
                m_guiElements.enableField(this.m_policyTab.m_delete_Button, false);
                m_guiElements.enableField(this.m_policyTab.m_add_Button, true);
            } else if (sIndices.length > 1) {
                m_guiElements.enableField(this.m_policyTab.m_up_Button, false);
                m_guiElements.enableField(this.m_policyTab.m_down_Button, false);
                m_guiElements.enableField(this.m_policyTab.m_top_Button, false);
                m_guiElements.enableField(this.m_policyTab.m_bottom_Button, false);
                m_guiElements.enableField(this.m_policyTab.m_copy_Button, true);
                m_guiElements.enableField(this.m_policyTab.m_delete_Button, true);
                m_guiElements.enableField(this.m_policyTab.m_add_Button, true);
            } else if (sIndices.length == 1) {
                int selIndex = sIndices[0];
                if (selIndex == 0) {
                    m_guiElements.enableField(this.m_policyTab.m_up_Button, false);
                    m_guiElements.enableField(this.m_policyTab.m_down_Button, true);
                    m_guiElements.enableField(this.m_policyTab.m_top_Button, false);
                    m_guiElements.enableField(this.m_policyTab.m_bottom_Button, true);
                    m_guiElements.enableField(this.m_policyTab.m_copy_Button, true);
                    m_guiElements.enableField(this.m_policyTab.m_delete_Button, true);
                    m_guiElements.enableField(this.m_policyTab.m_add_Button, true);
                } else if (selIndex == count - 1) {
                    m_guiElements.enableField(this.m_policyTab.m_up_Button, true);
                    m_guiElements.enableField(this.m_policyTab.m_down_Button, false);
                    m_guiElements.enableField(this.m_policyTab.m_top_Button, true);
                    m_guiElements.enableField(this.m_policyTab.m_bottom_Button, false);
                    m_guiElements.enableField(this.m_policyTab.m_copy_Button, true);
                    m_guiElements.enableField(this.m_policyTab.m_delete_Button, true);
                    m_guiElements.enableField(this.m_policyTab.m_add_Button, true);
                } else if (selIndex > 0) {
                    m_guiElements.enableField(this.m_policyTab.m_up_Button, true);
                    m_guiElements.enableField(this.m_policyTab.m_down_Button, true);
                    m_guiElements.enableField(this.m_policyTab.m_top_Button, true);
                    m_guiElements.enableField(this.m_policyTab.m_bottom_Button, true);
                    m_guiElements.enableField(this.m_policyTab.m_copy_Button, true);
                    m_guiElements.enableField(this.m_policyTab.m_delete_Button, true);
                    m_guiElements.enableField(this.m_policyTab.m_add_Button, true);
                }
            }
        }
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    protected void measure(Event event, Object element) {
    }

    protected void paint(Event event, Object element) {
    }

    public void update(ViewerCell cell) {
        String cellText = null;
        ArrayList list = (ArrayList)cell.getElement();
        Condition condition = (Condition)list.get(1);
        int colIndex = cell.getColumnIndex();
        int currRowIndex = this.getRowIndex(condition.getConditionId());
        int selRowIndex = this.m_tableViewer.getTable().getSelectionIndex();
        switch (colIndex) {
            case 0: {
                break;
            }
            case 1: {
                if (condition.getActionType().equalsIgnoreCase("STOP")) {
                    cell.setImage(BMUI.IMAGE_STOP);
                    break;
                }
                if (condition.getInsertClosed() != 0) {
                    cell.setImage(BMUI.IMAGE_INSERT_CLOSED);
                    break;
                }
                cell.setImage(BMUI.IMAGE_TRANSPARENT_12x12);
                break;
            }
            case 2: {
                cellText = !this.m_policy.getType().contains("MIN") ? ">= " + condition.getThreshold() : "<= " + condition.getThreshold();
                cell.setText(cellText);
                if (currRowIndex == selRowIndex) break;
                cell.setBackground(BMUI.getColor(condition.getSetSeverity()));
                break;
            }
            case 3: {
                cellText = condition.getDescription();
                cell.setText(cellText);
                if (currRowIndex == selRowIndex) {
                    cell.setBackground(BMUI.color_selected);
                    break;
                }
                cell.setBackground(BMUI.color_white);
            }
        }
        super.update(cell);
    }
}

