/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.gui.dialogs.MonprogDialog;
import com.blixx.boom.gui.dialogs.ShowMessageDialog;
import com.blixx.boom.gui.views.AbstractPolicyTab;
import com.blixx.boom.gui.views.FilterPolicyTab;
import com.blixx.shared.MsgPolicy;
import com.blixx.shared.Policy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.OwnerDrawLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TableItem;

public class MonprogTableProvider
extends OwnerDrawLabelProvider
implements IStructuredContentProvider {
    private String m_callTypeInCombo = null;
    private TableViewer m_tableViewer = null;
    private FilterPolicyTab m_filterPolTab = null;
    private Object m_policy = null;
    private String m_polType = null;
    private String m_opmType = null;
    private String[] m_callParams = null;
    private ArrayList<String[]> m_elements = null;
    private Map<String, Map<Integer, List<Boolean>>> m_validationStatus = null;
    public static String SNMP = "SNMP";
    public static String OPM = "OPM";
    public static String EXEC = "EXEC";
    public static String EXTERNAL = "EXTERNAL";
    public static String JAVA = "JAVA";
    public static String NAGIN = "NAGIN";
    public static String LOGFILE_MONITOR = "Logfile Monitor";
    public static String LOGFILE_TRANSACTION_MONITOR = "Logfile Transaction Monitor";
    public static String LOGFILE_TRANSACTION_MONITOR_MULITLINE = "Logfile Transaction Monitor (multiline)";
    public static String LOGFILE_MONITOR_MPATH = "(MP) Logfile Monitor";
    public static String LOGFILE_TRANSACTION_MONITOR_MPATH = "(MP) Logfile Transaction Monitor";
    public static String LOGFILE_TRANSACTION_MONITOR_MULITLINE_MPATH = "(MP) Logfile Transaction Monitor (multiline)";
    public static String OPM_MONITOR_NAME = "com.blixx.agent.monitors.Opm";
    public static String SNMP_MONITOR_NAME = "com.blixx.boom.snmp.SNMPWalkMonitor";
    public static String LOGFILE_MONITOR_NAME = "com.blixx.agent.monitors.LogFileMonitor";
    public static String LOGFILE_TRANSACTION_MONITOR_NAME = "com.blixx.agent.monitors.LogFileTransactionMonitor";
    public static String LOGFILE_TRANSACTION_MONITOR_MULTILINE_NAME = "com.blixx.agent.monitors.LogFileTransactionMonitorML";
    public static String LOGFILE_MONITOR_NAME_MPATH = "com.blixx.agent.monitors.MPathLogFileMonitor";
    public static String LOGFILE_TRANSACTION_MONITOR_NAME_MPATH = "com.blixx.agent.monitors.MPathLogFileTransactionMonitor";
    public static String LOGFILE_TRANSACTION_MONITOR_MULTILINE_NAME_MPATH = "com.blixx.agent.monitors.MPathLogFileTransactionMonitorML";
    public static String LINE_BY_LINE = "LineByLine";
    public static String TABLE_SUMMARY = "TableSummary";
    public static String PUNCHCARD = "PunchCard";
    public static String SNMP_SUBMIT = "SNMPSubmit";
    public static String FROM_START_FROM_LAST = "FROM_START Or FROM_LAST";
    public static String[] operator_list = new String[]{"+", "-", "*", "/", "\\"};

    public MonprogTableProvider(TableViewer tv, String callType4Combo, String opmType, Object policy) {
        this.m_tableViewer = tv;
        this.m_policy = policy;
        this.m_opmType = opmType;
        this.setConfig(callType4Combo, policy);
    }

    public MonprogTableProvider(TableViewer tv, String callType4Combo, Object policy, FilterPolicyTab tab) {
        this.m_tableViewer = tv;
        this.m_policy = policy;
        this.m_filterPolTab = tab;
        this.setConfig(callType4Combo, policy);
    }

    public void setConfig(String callType4Combo, Object policy) {
        this.m_callTypeInCombo = callType4Combo;
        if (policy == null) {
            return;
        }
        if (policy instanceof MsgPolicy) {
            this.m_polType = BMUI.type_msg;
            MsgPolicy p = (MsgPolicy)policy;
            this.m_callParams = p.getMonprog().split("\n");
        } else if (policy instanceof Policy) {
            this.m_polType = BMUI.type_mon;
            Policy p = (Policy)policy;
            this.m_callParams = p.getMonprog().split("\n");
        }
        this.m_validationStatus = new HashMap<String, Map<Integer, List<Boolean>>>();
    }

    public Object[] getElements(Object object) {
        this.m_elements = this.getCallTypeElements();
        return this.m_elements.toArray();
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public ArrayList<String[]> getCallTypeElements() {
        this.m_elements = new ArrayList();
        if (this.m_callParams == null || this.m_callParams.length == 0) {
            return this.m_elements;
        }
        if (this.m_polType.equals(BMUI.type_msg)) {
            if (this.m_callTypeInCombo.endsWith(LOGFILE_MONITOR)) {
                ArrayList<String[]> logfileMonitors = this.getLogfileMonitors();
                if (logfileMonitors != null && logfileMonitors.size() > 0) {
                    this.m_elements.addAll(logfileMonitors);
                }
            } else if (this.m_callTypeInCombo.endsWith(LOGFILE_TRANSACTION_MONITOR) || this.m_callTypeInCombo.endsWith(LOGFILE_TRANSACTION_MONITOR_MULITLINE)) {
                ArrayList<String[]> logfileTransactionMonitors = this.getTransactionMonitors();
                if (logfileTransactionMonitors != null && logfileTransactionMonitors.size() > 0) {
                    this.m_elements.addAll(logfileTransactionMonitors);
                }
            } else {
                ArrayList<String[]> otherMonitors = this.getOtherMonitors();
                if (otherMonitors != null && otherMonitors.size() > 0) {
                    this.m_elements.addAll(otherMonitors);
                }
            }
        } else if (this.m_polType.equals(BMUI.type_mon)) {
            ArrayList<String[]> snmpSubmits;
            if (this.m_callTypeInCombo.equals(OPM)) {
                ArrayList<String[]> opmMonitors = this.getOpmMonitors();
                if (opmMonitors != null && opmMonitors.size() > 0) {
                    this.m_elements.addAll(opmMonitors);
                }
            } else if (this.m_callTypeInCombo.equals(SNMP) && (snmpSubmits = this.getSNMPSubmits()) != null && snmpSubmits.size() > 0) {
                this.m_elements.addAll(snmpSubmits);
            }
        }
        return this.m_elements;
    }

    private ArrayList<String[]> getLogfileMonitors() {
        ArrayList<String[]> logfileMonitors = new ArrayList<String[]>();
        String[] elem = null;
        if (this.m_callParams.length < 3) {
            String name = "";
            String path = "";
            String[] newParams = new String[6];
            try {
                name = this.m_callParams[0];
                name = MonprogTableProvider.removeLineBreak(name);
            }
            catch (Exception exception) {}
            try {
                path = this.m_callParams[1];
                path = MonprogTableProvider.removeLineBreak(path);
            }
            catch (Exception exception) {}
            newParams[0] = name;
            newParams[1] = path;
            newParams[2] = "";
            newParams[3] = "";
            newParams[4] = "";
            newParams[5] = "";
            this.m_callParams = newParams;
        } else {
            String startPattern = "";
            String generalPattern = "";
            String fromStartFromLast = "";
            String executable = "";
            try {
                startPattern = this.m_callParams[2];
                startPattern = MonprogTableProvider.removeLineBreak(startPattern);
                elem = new String[]{"Split Records", startPattern, "0"};
            }
            catch (Exception exception) {
                elem = new String[]{"Split Records", "", "0"};
            }
            logfileMonitors.add(elem);
            try {
                generalPattern = this.m_callParams[3];
                generalPattern = MonprogTableProvider.removeLineBreak(generalPattern);
                elem = new String[]{"General Pattern", generalPattern, "1"};
            }
            catch (Exception exception) {
                elem = new String[]{"General Pattern", "", "1"};
            }
            logfileMonitors.add(elem);
            try {
                fromStartFromLast = this.m_callParams[4];
                fromStartFromLast = MonprogTableProvider.removeLineBreak(fromStartFromLast);
                elem = new String[]{FROM_START_FROM_LAST, fromStartFromLast, "2"};
            }
            catch (Exception exception) {
                elem = new String[]{FROM_START_FROM_LAST, "", "2"};
            }
            logfileMonitors.add(elem);
            try {
                executable = this.m_callParams[5];
                executable = MonprogTableProvider.removeLineBreak(executable);
                elem = new String[]{"Executable Call (optional)", executable, "3"};
            }
            catch (Exception exception) {
                elem = new String[]{"Executable Call (optional)", "", "3"};
            }
            logfileMonitors.add(elem);
        }
        return logfileMonitors;
    }

    private ArrayList<String[]> getTransactionMonitors() {
        ArrayList<String[]> logfileTransactionMonitors = new ArrayList<String[]>();
        if (this.m_callParams.length == 0) {
            return logfileTransactionMonitors;
        }
        int startIndex = 2;
        if (this.m_callTypeInCombo.endsWith(LOGFILE_TRANSACTION_MONITOR_MULITLINE)) {
            startIndex = 3;
        }
        int counter = 0;
        int counter2 = 0;
        int i = startIndex;
        while (i < this.m_callParams.length) {
            String startPattern = "";
            try {
                startPattern = this.m_callParams[i];
                startPattern = MonprogTableProvider.removeLineBreak(startPattern);
            }
            catch (Exception exception) {
                ++counter2;
            }
            ++i;
            String finishPattern = "";
            try {
                finishPattern = this.m_callParams[i];
                finishPattern = MonprogTableProvider.removeLineBreak(finishPattern);
            }
            catch (Exception exception) {
                ++counter2;
            }
            ++i;
            String failPattern = "";
            try {
                failPattern = this.m_callParams[i];
                failPattern = MonprogTableProvider.removeLineBreak(failPattern);
            }
            catch (Exception exception) {
                ++counter2;
            }
            ++i;
            String timeout = "";
            try {
                timeout = this.m_callParams[i];
                timeout = MonprogTableProvider.removeLineBreak(timeout);
            }
            catch (Exception exception) {
                ++counter2;
            }
            ++i;
            String[] elem = new String[]{startPattern, finishPattern, failPattern, timeout, "" + counter};
            logfileTransactionMonitors.add(elem);
            if (counter2 > 0) {
                String[] arr = new String[this.m_callParams.length + counter2];
                int ii = 0;
                while (ii < arr.length) {
                    String value = "";
                    try {
                        value = this.m_callParams[ii];
                    }
                    catch (Exception exception) {}
                    arr[ii] = value;
                    ++ii;
                }
                this.m_callParams = arr;
                if (this.m_filterPolTab != null) {
                    this.m_filterPolTab.setPolicyMonProg(this.m_callParams);
                }
            }
            ++counter;
        }
        return logfileTransactionMonitors;
    }

    private ArrayList<String[]> getOtherMonitors() {
        ArrayList<String[]> otherMonitors = new ArrayList<String[]>();
        String[] elem = null;
        int i = 0;
        while (i < this.m_callParams.length) {
            elem = new String[]{"", this.m_callParams[i]};
            if (elem != null) {
                otherMonitors.add(elem);
            }
            ++i;
        }
        return otherMonitors;
    }

    private ArrayList<String[]> getOpmMonitors() {
        ArrayList<String[]> opmMonitors = new ArrayList<String[]>();
        String[] elem = null;
        String opmType = "";
        if (this.m_callParams.length < 3) {
            return opmMonitors;
        }
        try {
            opmType = this.m_callParams[2];
            opmType = MonprogTableProvider.removeLineBreak(opmType);
        }
        catch (Exception exception) {}
        if (opmType.equals(TABLE_SUMMARY)) {
            int start;
            int i = start = 4;
            while (i < this.m_callParams.length) {
                String line = MonprogTableProvider.removeLineBreak(this.m_callParams[i]);
                elem = new String[]{line};
                if (elem != null) {
                    opmMonitors.add(elem);
                }
                ++i;
            }
        } else if (opmType.equals(LINE_BY_LINE)) {
            int start;
            int i = start = 3;
            while (i < this.m_callParams.length) {
                String pattern = "";
                String obj = "";
                try {
                    pattern = this.m_callParams[i];
                    pattern = MonprogTableProvider.removeLineBreak(pattern);
                    ++i;
                }
                catch (Exception exception) {}
                try {
                    obj = this.m_callParams[i];
                    obj = MonprogTableProvider.removeLineBreak(obj);
                    String[] sub = obj.split("=");
                    if (sub.length == 2) {
                        this.m_callParams[i] = obj = String.valueOf(sub[0]) + "=" + MonprogTableProvider.checkCalculation(sub[1]);
                    }
                    ++i;
                }
                catch (Exception exception) {}
                elem = new String[]{pattern, obj};
                if (elem == null) continue;
                opmMonitors.add(elem);
            }
        } else if (opmType.equals(PUNCHCARD)) {
            int start;
            int i = start = 6;
            while (i < this.m_callParams.length) {
                String regex = "";
                String vars = "";
                try {
                    regex = MonprogTableProvider.removeLineBreak(this.m_callParams[i]);
                }
                catch (Exception exception) {}
                try {
                    vars = MonprogTableProvider.removeLineBreak(this.m_callParams[++i]);
                }
                catch (Exception exception) {}
                elem = new String[]{regex, vars};
                if (elem != null) {
                    opmMonitors.add(elem);
                }
                ++i;
            }
        } else {
            int i = 1;
            while (i < this.m_callParams.length) {
                elem = new String[]{this.m_callParams[i], ""};
                if (elem != null) {
                    opmMonitors.add(elem);
                }
                ++i;
            }
        }
        return opmMonitors;
    }

    private ArrayList<String[]> getSNMPSubmits() {
        ArrayList<String[]> snmpSubmitters = new ArrayList<String[]>();
        int i = 1;
        while (i < this.m_callParams.length) {
            String param = this.m_callParams[i];
            if (!param.startsWith("-")) {
                snmpSubmitters.add(new String[]{param});
            }
            ++i;
        }
        return snmpSubmitters;
    }

    public static String getCallType4Combo(String polType, String callType, String firstLineInCallField) {
        String callType4Combo = "";
        if (polType.equals(BMUI.type_msg)) {
            if (firstLineInCallField == null) {
                return JAVA;
            }
            callType4Combo = callType.equals(JAVA) ? (firstLineInCallField.equals(LOGFILE_MONITOR_NAME) ? LOGFILE_MONITOR : (firstLineInCallField.equals(LOGFILE_TRANSACTION_MONITOR_NAME) ? LOGFILE_TRANSACTION_MONITOR : (firstLineInCallField.equals(LOGFILE_TRANSACTION_MONITOR_MULTILINE_NAME) ? LOGFILE_TRANSACTION_MONITOR_MULITLINE : (firstLineInCallField.equals(LOGFILE_MONITOR_NAME_MPATH) ? LOGFILE_MONITOR_MPATH : (firstLineInCallField.equals(LOGFILE_TRANSACTION_MONITOR_NAME_MPATH) ? LOGFILE_TRANSACTION_MONITOR_MPATH : (firstLineInCallField.equals(LOGFILE_TRANSACTION_MONITOR_MULTILINE_NAME_MPATH) ? LOGFILE_TRANSACTION_MONITOR_MULITLINE_MPATH : JAVA)))))) : callType;
        } else if (polType.equals(BMUI.type_mon)) {
            if (firstLineInCallField == null) {
                return EXEC;
            }
            callType4Combo = callType.equals(JAVA) ? (firstLineInCallField.equals(OPM_MONITOR_NAME) ? OPM : (firstLineInCallField.equals(SNMP_MONITOR_NAME) ? SNMP : JAVA)) : callType;
        }
        return callType4Combo;
    }

    public String getMonprog() {
        String monprog = "";
        TableItem[] items = this.m_tableViewer.getTable().getItems();
        int i = 0;
        while (i < items.length) {
            TableItem ti = items[i];
            monprog = String.valueOf(monprog) + "\n" + ti.getText(1);
            ++i;
        }
        if (monprog.startsWith("\n")) {
            monprog = monprog.substring(1);
        }
        return monprog;
    }

    public String[] moveOPMMonitor(String type, String[] monprog_old, int selIndex, int newIndex) {
        String[] monprog_new;
        block18: {
            int monprogLength;
            String[] monprog;
            block19: {
                block17: {
                    monprog_new = null;
                    monprog = ((Policy)this.m_policy).getMonprog().split("\n");
                    monprogLength = monprog.length;
                    if (!type.equals(LINE_BY_LINE)) break block17;
                    if (this.isEvenNumber(monprogLength)) {
                        ++monprogLength;
                    }
                    monprog_new = new String[monprogLength];
                    ArrayList<List> list = new ArrayList<List>();
                    int start = 3;
                    int i = 0;
                    while (i < monprogLength) {
                        if (i < start) {
                            monprog_new[i] = monprog[i];
                        } else {
                            ArrayList<String> l = new ArrayList<String>();
                            String mProg = "";
                            try {
                                mProg = monprog[i];
                            }
                            catch (Exception exception) {}
                            l.add(mProg);
                            ++i;
                            mProg = "";
                            try {
                                mProg = monprog[i];
                            }
                            catch (Exception exception) {}
                            l.add(mProg);
                            list.add(l);
                        }
                        ++i;
                    }
                    List patternPair = (List)list.remove(selIndex);
                    list.add(newIndex, patternPair);
                    int s = start;
                    int ii = 0;
                    while (ii < list.size()) {
                        List l = (List)list.get(ii);
                        monprog_new[s++] = (String)l.get(0);
                        monprog_new[s++] = (String)l.get(1);
                        ++ii;
                    }
                    break block18;
                }
                if (!type.equals(TABLE_SUMMARY)) break block19;
                monprog_new = new String[monprogLength];
                ArrayList<String> list = new ArrayList<String>();
                int start = 4;
                int i = 0;
                while (i < monprogLength) {
                    if (i < start) {
                        monprog_new[i] = monprog[i];
                    } else {
                        list.add(monprog[i]);
                    }
                    ++i;
                }
                String calculation = (String)list.remove(selIndex);
                list.add(newIndex, calculation);
                int s = start;
                int ii = 0;
                while (ii < list.size()) {
                    monprog_new[s++] = (String)list.get(ii);
                    ++ii;
                }
                break block18;
            }
            if (!type.equals(PUNCHCARD)) break block18;
            monprog_new = new String[monprogLength];
            ArrayList<String[]> list = new ArrayList<String[]>();
            int startIndex = 6;
            int i = 0;
            while (i < monprogLength) {
                if (i < startIndex) {
                    monprog_new[i] = monprog[i];
                } else {
                    list.add(new String[]{monprog[i], monprog[++i]});
                }
                ++i;
            }
            String[] elemToMove = (String[])list.remove(selIndex);
            list.add(newIndex, elemToMove);
            int pos = startIndex;
            int ii = 0;
            while (ii < list.size()) {
                String[] elem = (String[])list.get(ii);
                monprog_new[pos++] = elem[0];
                monprog_new[pos++] = elem[1];
                ++ii;
            }
        }
        return monprog_new;
    }

    public String[] deleteOPMMonitor(int selIndex, String type) {
        if (type.endsWith(LOGFILE_TRANSACTION_MONITOR)) {
            int start = 2;
            if (selIndex > 0) {
                start = selIndex * 4 + start;
            }
            String[] monprog_old = ((MsgPolicy)this.m_policy).getMonprog().split("\n");
            String[] monprog_new = null;
            int mod = (monprog_old.length - 2) % 4;
            if (mod == 0) {
                monprog_new = new String[monprog_old.length - 4];
            } else {
                int rest = (monprog_old.length - 2) / 4;
                int correctSize = (rest + 1) * 4 + 2;
                monprog_new = new String[correctSize - 4];
            }
            ArrayList<String> monprogToDelete = new ArrayList<String>();
            int count = 0;
            int i = 0;
            while (i < monprog_old.length) {
                if (i >= start && i <= start + 3) {
                    monprogToDelete.add(monprog_old[i]);
                } else {
                    monprog_new[count] = monprog_old[i];
                    ++count;
                }
                ++i;
            }
            String title = "Delete Logfile Transaction Monitor";
            String header = "Do you want to delete the following Logfile Transaction Monitor:";
            String noElementsText = "No Logfile Transaction Monitor to delete!";
            ShowMessageDialog md = new ShowMessageDialog(Display.getCurrent().getActiveShell(), title, header, null, true, "Delete", monprogToDelete, noElementsText, ShowMessageDialog.TYPE_LIST_WITHOUT_IMAGES);
            md.setBlockOnOpen(true);
            md.open();
            if (md.getReturnCode() == 0) {
                return monprog_new;
            }
        } else if (type.endsWith(LOGFILE_TRANSACTION_MONITOR_MULITLINE)) {
            int start = 3;
            if (selIndex > 0) {
                start = selIndex * 4 + start;
            }
            String[] monprog_old = ((MsgPolicy)this.m_policy).getMonprog().split("\n");
            String[] monprog_new = null;
            int mod = (monprog_old.length - 3) % 4;
            if (mod == 0) {
                monprog_new = new String[monprog_old.length - 4];
            } else {
                int rest = (monprog_old.length - 3) / 4;
                int correctSize = (rest + 1) * 4 + 3;
                monprog_new = new String[correctSize - 4];
            }
            ArrayList<String> monprogToDelete = new ArrayList<String>();
            int count = 0;
            int i = 0;
            while (i < monprog_old.length) {
                if (i >= start && i <= start + 3) {
                    monprogToDelete.add(monprog_old[i]);
                } else {
                    monprog_new[count] = monprog_old[i];
                    ++count;
                }
                ++i;
            }
            String title = "Delete Logfile Transaction Monitor (mulitline)";
            String header = "Do you want to delete the following Logfile Transaction Monitor (multiline):";
            String noElementsText = "No Logfile Transaction Monitor (multiline) to delete!";
            ShowMessageDialog md = new ShowMessageDialog(Display.getCurrent().getActiveShell(), title, header, null, true, "Delete", monprogToDelete, noElementsText, ShowMessageDialog.TYPE_LIST_WITHOUT_IMAGES);
            md.setBlockOnOpen(true);
            md.open();
            if (md.getReturnCode() == 0) {
                return monprog_new;
            }
        } else if (type.equals(LINE_BY_LINE)) {
            String title = "Delete OPM Monitor";
            String header = "Do you want to delete the following OPM Monitor:";
            String noElementsText = "No OPM Monitor to delete!";
            ArrayList<String> monprogToDelete = new ArrayList<String>();
            String[] monprog_new = null;
            if (SNMP.equals(this.m_callTypeInCombo)) {
                String[] monprog_old = ((Policy)this.m_policy).getMonprog().split("\n");
                ArrayList<String> mplist = new ArrayList<String>(Arrays.asList(monprog_old));
                int firstOFCline = -1;
                int i = 1;
                while (i < mplist.size()) {
                    if (!((String)mplist.get(i)).startsWith("-")) {
                        firstOFCline = i;
                        break;
                    }
                    ++i;
                }
                int lineToDelete = firstOFCline + selIndex;
                String toDelete = (String)mplist.remove(lineToDelete);
                monprogToDelete.add(toDelete);
                monprog_new = mplist.toArray(new String[0]);
                title = "Delete SNMP Walk monitor submit";
                header = "Do you want to delete the following submitting string:";
            } else {
                int start = selIndex * 2 + 3;
                String[] monprog_old = ((Policy)this.m_policy).getMonprog().split("\n");
                int length = monprog_old.length;
                if (this.isEvenNumber(length)) {
                    ++length;
                }
                monprog_new = new String[length - 2];
                int count = 0;
                int i = 0;
                while (i < monprog_old.length) {
                    if (i == start) {
                        monprogToDelete.add("Pattern: " + monprog_old[i]);
                    } else if (i == start + 1) {
                        monprogToDelete.add("Object: " + monprog_old[i]);
                    } else {
                        monprog_new[count] = monprog_old[i];
                        ++count;
                    }
                    ++i;
                }
                if (monprogToDelete.size() == 1) {
                    monprogToDelete.add("Object: <no value>");
                }
            }
            ShowMessageDialog md = new ShowMessageDialog(Display.getCurrent().getActiveShell(), title, header, null, true, "Delete", monprogToDelete, noElementsText);
            md.setBlockOnOpen(true);
            md.open();
            if (md.getReturnCode() == 0) {
                return monprog_new;
            }
        } else if (type.equals(TABLE_SUMMARY)) {
            int start = selIndex + 4;
            String[] monprog_old = ((Policy)this.m_policy).getMonprog().split("\n");
            String[] monprog_new = new String[monprog_old.length - 1];
            ArrayList<String> monprogToDelete = new ArrayList<String>();
            int count = 0;
            int i = 0;
            while (i < monprog_old.length) {
                if (i == start) {
                    monprogToDelete.add(monprog_old[i]);
                } else {
                    monprog_new[count] = monprog_old[i];
                    ++count;
                }
                ++i;
            }
            String title = "Delete OPM Monitor";
            String header = "Do you want to delete the following OPM Monitor:";
            String noElementsText = "No OPM Monitor to delete!";
            ShowMessageDialog md = new ShowMessageDialog(Display.getCurrent().getActiveShell(), title, header, null, true, "Delete", monprogToDelete, noElementsText);
            md.setBlockOnOpen(true);
            md.open();
            if (md.getReturnCode() == 0) {
                return monprog_new;
            }
        } else if (type.equals(PUNCHCARD)) {
            ArrayList<String> monprogToDelete = new ArrayList<String>();
            int start = 6 + (selIndex + 1) * 2 - 2;
            String[] monprog_old = ((Policy)this.m_policy).getMonprog().split("\n");
            int length = monprog_old.length;
            String[] monprog_new = new String[length - 2];
            int i = 0;
            while (i < monprog_old.length) {
                if (i == start) {
                    monprogToDelete.add("Pattern: " + monprog_old[i]);
                } else if (i == start + 1) {
                    monprogToDelete.add("Variables: " + monprog_old[i]);
                } else {
                    monprog_new[i] = monprog_old[i];
                }
                ++i;
            }
            if (monprogToDelete.size() == 1) {
                monprogToDelete.add("Object: <no value>");
            }
            String title = "Delete OPM Monitor";
            String header = "Do you want to delete the following OPM Monitor:";
            String noElementsText = "No OPM Monitor to delete!";
            ShowMessageDialog md = new ShowMessageDialog(Display.getCurrent().getActiveShell(), title, header, null, true, "Delete", monprogToDelete, noElementsText);
            md.setBlockOnOpen(true);
            md.open();
            if (md.getReturnCode() == 0) {
                return monprog_new;
            }
        }
        return null;
    }

    private void updateValidationStatus(String type, int colIndex, int lineIndex, boolean valid) {
        List<Boolean> values;
        if (type == null) {
            return;
        }
        Map<Integer, List<Boolean>> tbl_lines = this.m_validationStatus.get(type);
        if (tbl_lines == null) {
            tbl_lines = new HashMap<Integer, List<Boolean>>();
        }
        if ((values = tbl_lines.get(lineIndex)) == null) {
            values = new ArrayList<Boolean>();
        }
        try {
            values.remove(colIndex);
        }
        catch (Exception exception) {}
        values.add(colIndex, valid);
        tbl_lines.put(lineIndex, values);
        this.m_validationStatus.put(type, tbl_lines);
    }

    public boolean isMonprogValid() {
        for (String type : this.m_validationStatus.keySet()) {
            Map<Integer, List<Boolean>> tbl_lines = this.m_validationStatus.get(type);
            for (int lineIndex : tbl_lines.keySet()) {
                List<Boolean> cols = tbl_lines.get(lineIndex);
                for (boolean valid : cols) {
                    if (valid) continue;
                    return false;
                }
            }
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public void update(ViewerCell cell) {
        block50: {
            block52: {
                block54: {
                    block56: {
                        block55: {
                            block53: {
                                block51: {
                                    if (!(cell.getElement() instanceof String[])) break block50;
                                    elem = (String[])cell.getElement();
                                    colIndex = cell.getColumnIndex();
                                    value = null;
                                    row = cell.getViewerRow();
                                    item = (TableItem)row.getItem();
                                    lineIndex = -1;
                                    items = this.m_tableViewer.getTable().getItems();
                                    i = 0;
                                    while (i < items.length) {
                                        ti = items[i];
                                        if (ti.equals(item)) {
                                            lineIndex = i;
                                            break;
                                        }
                                        ++i;
                                    }
                                    isValid = -1;
                                    if (!this.m_callTypeInCombo.endsWith(MonprogTableProvider.LOGFILE_TRANSACTION_MONITOR) && !this.m_callTypeInCombo.endsWith(MonprogTableProvider.LOGFILE_TRANSACTION_MONITOR_MULITLINE)) break block51;
                                    switch (colIndex) {
                                        case 0: {
                                            value = elem[0];
                                            cell.setText(value);
                                            isValid = 0;
                                            if (value.equals("") || !AbstractPolicyTab.validatePattern(value)) {
                                                cell.setBackground(BMUI.color_light_red);
                                                isValid = 1;
                                                break;
                                            }
                                            break block52;
                                        }
                                        case 1: {
                                            value = elem[1];
                                            cell.setText(value);
                                            isValid = 0;
                                            if (value.equals("") || !AbstractPolicyTab.validatePattern(value)) {
                                                cell.setBackground(BMUI.color_light_red);
                                                isValid = 1;
                                                break;
                                            }
                                            break block52;
                                        }
                                        case 2: {
                                            value = elem[2];
                                            cell.setText(value);
                                            isValid = 0;
                                            if (value.equals("") || !AbstractPolicyTab.validatePattern(value)) {
                                                cell.setBackground(BMUI.color_light_red);
                                                isValid = 1;
                                                break;
                                            }
                                            break block52;
                                        }
                                        case 3: {
                                            value = elem[3];
                                            cell.setText(value);
                                            isValid = 1;
                                            try {
                                                i = Integer.parseInt(value);
                                                if (i > 0) {
                                                    isValid = 0;
                                                }
                                            }
                                            catch (NumberFormatException v0) {
                                                isValid = 1;
                                            }
                                            if (isValid == 0) {
                                                cell.setBackground(BMUI.color_white);
                                                break;
                                            }
                                            cell.setBackground(BMUI.color_light_red);
                                            break;
                                        }
                                    }
                                    break block52;
                                }
                                if (!this.m_callTypeInCombo.endsWith(MonprogTableProvider.LOGFILE_MONITOR)) break block53;
                                switch (colIndex) {
                                    case 0: {
                                        value = elem[0];
                                        cell.setText(value);
                                        isValid = 0;
                                        break;
                                    }
                                    case 1: {
                                        value = elem[1];
                                        cell.setText(value);
                                        if (elem[0].contains("Pattern") || elem[0].contains("Split Records")) {
                                            isValid = 0;
                                            if (value.equals("") || !AbstractPolicyTab.validatePattern(value)) {
                                                cell.setBackground(BMUI.color_light_red);
                                                isValid = 1;
                                                break;
                                            }
                                        } else if (elem[0].equals(MonprogTableProvider.FROM_START_FROM_LAST)) {
                                            isValid = 0;
                                            if (!value.equalsIgnoreCase(MonprogDialog.FROM_START) && !value.equalsIgnoreCase(MonprogDialog.FROM_LAST)) {
                                                cell.setBackground(BMUI.color_light_red);
                                                isValid = 1;
                                                break;
                                            }
                                        } else if (elem[0].equals("Executable Call (optional)")) {
                                            isValid = 0;
                                            break;
                                        } else {
                                            break;
                                        }
                                    }
                                }
                                break block52;
                            }
                            if (!this.m_callTypeInCombo.equals(MonprogTableProvider.OPM)) break block54;
                            if (!this.m_opmType.equals(MonprogTableProvider.LINE_BY_LINE)) break block55;
                            switch (colIndex) {
                                case 0: {
                                    value = elem[0];
                                    cell.setText(value);
                                    isValid = 0;
                                    if (value.equals("") || !AbstractPolicyTab.validatePattern(value)) {
                                        cell.setBackground(BMUI.color_light_red);
                                        isValid = 1;
                                        break;
                                    }
                                    break block52;
                                }
                                case 1: {
                                    value = elem[1];
                                    cell.setText(value);
                                    isValid = 0;
                                    if (!MonprogTableProvider.validateMonprogOPMObject(this.m_opmType, value)) {
                                        cell.setBackground(BMUI.color_light_red);
                                        isValid = 1;
                                        break;
                                    }
                                    break block52;
                                }
                            }
                            break block52;
                        }
                        if (!this.m_opmType.equals(MonprogTableProvider.TABLE_SUMMARY)) break block56;
                        switch (colIndex) {
                            case 0: {
                                value = elem[0];
                                cell.setText(value);
                                isValid = 0;
                                if (!MonprogTableProvider.validateMonprogOPMObject(this.m_opmType, value)) {
                                    cell.setBackground(BMUI.color_light_red);
                                    isValid = 1;
                                    break;
                                } else {
                                    break;
                                }
                            }
                        }
                        break block52;
                    }
                    if (!this.m_opmType.equals(MonprogTableProvider.PUNCHCARD)) break block52;
                    switch (colIndex) {
                        case 0: {
                            value = elem[0];
                            cell.setText(value);
                            isValid = 0;
                            if (!MonprogTableProvider.validateMonprogOPMObject(this.m_opmType, value)) {
                                cell.setBackground(BMUI.color_light_red);
                                isValid = 1;
                                ** break;
                            }
                            break block52;
                        }
                        case 1: {
                            value = elem[1];
                            cell.setText(value);
                            isValid = 0;
                            if (!MonprogTableProvider.validateMonprogOPMObject(this.m_opmType, value)) {
                                cell.setBackground(BMUI.color_light_red);
                                isValid = 1;
                                ** break;
                            }
                            break block52;
                        }
                        default: {
                            ** break;
                        }
                    }
lbl154:
                    // 3 sources

                    break block52;
                }
                if (this.m_callTypeInCombo.equals(MonprogTableProvider.SNMP)) {
                    switch (colIndex) {
                        case 0: {
                            value = elem[0];
                            cell.setText(value);
                            isValid = 0;
                            if (MonprogTableProvider.validateMonprogOPMObject(MonprogTableProvider.LINE_BY_LINE, value)) break;
                            cell.setBackground(BMUI.color_light_red);
                            isValid = 1;
                            break;
                        }
                    }
                }
            }
            type = this.m_opmType;
            if (!this.m_callTypeInCombo.equals(MonprogTableProvider.OPM)) {
                type = this.m_callTypeInCombo;
            }
            if (isValid == 0) {
                this.updateValidationStatus(type, colIndex, lineIndex, true);
            } else if (isValid == 1) {
                this.updateValidationStatus(type, colIndex, lineIndex, false);
            }
        }
        super.update(cell);
    }

    public static boolean validateMonprogOPMObject(String callType, String value) {
        if (value.equals("")) {
            return false;
        }
        if (callType.equals(LINE_BY_LINE)) {
            String operator;
            String calculation;
            String object;
            block23: {
                object = "";
                calculation = "";
                operator = "";
                try {
                    value = MonprogTableProvider.removeLineBreak(value);
                    int i = 1;
                    while (i < MonprogDialog.OP_LIST_LBL.length) {
                        if (value.indexOf(MonprogDialog.OP_LIST_LBL[i]) != -1) {
                            operator = MonprogDialog.OP_LIST_LBL[i];
                            break;
                        }
                        ++i;
                    }
                    if (!operator.equals("")) break block23;
                    return false;
                }
                catch (Exception exception) {}
            }
            String[] sub = value.split(operator);
            try {
                object = sub[0];
            }
            catch (Exception exception) {
                return false;
            }
            try {
                calculation = sub[1];
            }
            catch (Exception exception) {
                return false;
            }
            return !object.equals("") && !operator.equals("") && !calculation.equals("");
        }
        if (callType.equals(TABLE_SUMMARY)) {
            String operator;
            String calculation;
            String object;
            block25: {
                object = "";
                calculation = "";
                operator = "";
                try {
                    value = MonprogTableProvider.removeLineBreak(value);
                    int i = 1;
                    while (i < MonprogDialog.OP_LIST_TS.length) {
                        if (value.indexOf(MonprogDialog.OP_LIST_TS[i]) != -1) {
                            operator = MonprogDialog.OP_LIST_TS[i];
                            break;
                        }
                        ++i;
                    }
                    if (!operator.equals("")) break block25;
                    return false;
                }
                catch (Exception exception) {}
            }
            String[] sub = value.split(operator);
            try {
                object = sub[0];
            }
            catch (Exception exception) {
                return false;
            }
            try {
                calculation = sub[1];
            }
            catch (Exception exception) {
                return false;
            }
            return !object.equals("") && !operator.equals("") && !calculation.equals("");
        }
        return callType.equals(PUNCHCARD) && value != null && value.length() > 0;
    }

    public int getLineIndex(TableItem ti) {
        int index = -1;
        TableItem[] items = this.m_tableViewer.getTable().getItems();
        int i = 0;
        while (i < items.length) {
            TableItem item = items[i];
            if (item.equals(ti)) {
                index = i;
                break;
            }
            ++i;
        }
        return index;
    }

    public static String removeLineBreak(String text) {
        if (text == null) {
            return "";
        }
        if (text.endsWith("\r")) {
            text = text.substring(0, text.length() - 1);
        }
        return text;
    }

    public static String removeLineBreak2(String text) {
        if (text == null) {
            return "";
        }
        if (text.endsWith("\n")) {
            text = text.substring(0, text.length() - 1);
        }
        return text;
    }

    public static String checkCalculation(String calculaction) {
        boolean hasLeadingMinus = calculaction.trim().startsWith("-");
        int i = 0;
        while (i < operator_list.length) {
            String operator = operator_list[i];
            if (calculaction.indexOf(operator) != -1) {
                String elem = "";
                String[] sub = calculaction.split("\\" + operator);
                int ii = 0;
                while (ii < sub.length) {
                    elem = elem.equals("") ? sub[ii].trim() : String.valueOf(elem) + " " + operator + " " + sub[ii].trim();
                    ++ii;
                }
                calculaction = elem;
            }
            ++i;
        }
        if (hasLeadingMinus) {
            calculaction = "-" + calculaction;
        }
        return calculaction;
    }

    public boolean isEvenNumber(int n) {
        return n % 2 == 0;
    }

    public void dispose() {
    }

    protected void measure(Event event, Object element) {
    }

    protected void paint(Event event, Object element) {
    }
}

