/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views;

import com.blixx.boom.engine.BMUI;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.GroupTreeObjectLast;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;

public class NodeGroupDialogTableProvider
implements ILabelProvider,
IStructuredContentProvider {
    private static NodeGroupDialogTableProvider m_instance = null;
    private ArrayList<GroupTreeObject> m_nodeGroups = new ArrayList();
    private static String COLOR_GREY = "COLOR_GREY";

    static {
        JFaceResources.getColorRegistry().put(COLOR_GREY, BMUI.color_darkGrey2.getRGB());
    }

    public static NodeGroupDialogTableProvider getInstance() {
        if (m_instance == null) {
            m_instance = new NodeGroupDialogTableProvider();
        }
        return m_instance;
    }

    public void init(GroupTreeObject root, String[] currentNodeGroups) {
        int i = 0;
        while (i < currentNodeGroups.length) {
            GroupTreeObject gto = root.searchPath(currentNodeGroups[i], BMUI.type_folder);
            if (gto != null) {
                this.m_nodeGroups.add(gto);
            }
            ++i;
        }
    }

    public void addNodeGroups(List<GroupTreeObject> list) {
        int i = 0;
        while (i < list.size()) {
            GroupTreeObject gto = list.get(i);
            if (gto != null && !this.m_nodeGroups.contains(gto)) {
                this.m_nodeGroups.add(gto);
            }
            ++i;
        }
    }

    public void removeNodeGroup(ArrayList<GroupTreeObject> list) {
        int i = 0;
        while (i < list.size()) {
            GroupTreeObject gto = list.get(i);
            if (gto != null && this.m_nodeGroups.contains(gto)) {
                this.m_nodeGroups.remove(gto);
            }
            ++i;
        }
    }

    public ArrayList<GroupTreeObject> getNodeGroups() {
        return this.m_nodeGroups;
    }

    public Object[] getElements(Object inputElement) {
        return this.m_nodeGroups.toArray();
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public Image getImage(Object element) {
        if (!(element instanceof GroupTreeObjectLast) && element instanceof GroupTreeObject) {
            GroupTreeObject gto = (GroupTreeObject)element;
            Image image = BMUI.IMAGE_MAP.get(gto.getType());
            if (image == null) {
                image = BMUI.IMAGE_FOLDER_DEFAULT;
            }
            return image;
        }
        return null;
    }

    public String getText(Object element) {
        String text = "";
        if (element instanceof GroupTreeObject) {
            GroupTreeObject gto = (GroupTreeObject)element;
            text = gto.getTreeObject().getName();
        }
        return text;
    }

    public void dispose() {
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

