/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views;

import com.blixx.boom.engine.AgentCard;
import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.engine.UIJob;
import com.blixx.boom.gui.Activator;
import com.blixx.boom.gui.policies.ViewContentProvider;
import com.blixx.boom.gui.utils.FilterComposite;
import com.blixx.boom.gui.utils.STreeViewer;
import com.blixx.boom.gui.views.StyledTreeLabelProvider;
import com.blixx.boom.gui.views.actions.AddHostGroupAction;
import com.blixx.boom.gui.views.actions.AddNewAgent;
import com.blixx.boom.gui.views.actions.AddNewAgentActionSlave;
import com.blixx.boom.gui.views.actions.AddVirtAgentAction;
import com.blixx.boom.gui.views.actions.ApproveAgentAction;
import com.blixx.boom.gui.views.actions.DeleteAgentAction;
import com.blixx.boom.gui.views.actions.EnableDisableHostAction;
import com.blixx.boom.gui.views.actions.ExpandCollapseAction;
import com.blixx.boom.gui.views.actions.FastAndRemoteActions;
import com.blixx.boom.gui.views.actions.GtoAddAgentLinkAction;
import com.blixx.boom.gui.views.actions.GtoDelete;
import com.blixx.boom.gui.views.actions.OpenMessageBrowserAction;
import com.blixx.boom.gui.views.actions.RedeployAgentAction;
import com.blixx.boom.gui.views.actions.RefreshNodeGroups;
import com.blixx.boom.gui.views.actions.RefreshNodeListAction;
import com.blixx.boom.gui.views.actions.RenameHostGroupAction;
import com.blixx.boom.gui.views.actions.RestartAgentAction;
import com.blixx.boom.gui.views.actions.SetFirewallAction;
import com.blixx.boom.gui.views.actions.ShowAssignedPoliciesAction;
import com.blixx.boom.gui.views.actions.ShowRelatedHostInfosAction;
import com.blixx.boom.gui.views.actions.StartAdHocMaintenanceAction;
import com.blixx.boom.gui.views.actions.SyncAgentsAction;
import com.blixx.boom.gui.views.actions.TriggerMasterUpdate;
import com.blixx.boom.gui.views.actions.UndeployFromAll;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.GroupTreeObjectLast;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.part.ViewPart;

public class NodeListView
extends ViewPart
implements IDoubleClickListener {
    public static final String ID = "com.blixx.boom.gui.views.nodelistview";
    public static NodeListView m_nlv = null;
    protected Composite m_parent = null;
    protected STreeViewer m_treeViewer = null;
    protected Text m_searchText = null;
    public static String ENABLE = "Enable Agent";
    public static String DISABLE = "Disable Agent";
    public static String SET_FIREWALLED_OFF = "Set firewalled-OFF";
    public static String SET_FIREWALLED_ON = "Set firewalled-ON";
    public static String VIEWER_TYPE = "VIEWER_TYPE";
    public static String NODE_LIST = "NODE_LIST";

    public NodeListView() {
        m_nlv = this;
    }

    public static NodeListView getInstance() {
        return m_nlv;
    }

    public void createPartControl(Composite parent) {
        if (Repository.getInstance().getRights(1002) <= 1) {
            parent.setLayout((Layout)new GridLayout(2, false));
            Label l = new Label(parent, 0);
            l.setText(" Insufficient rights.");
            l.setForeground(BMUI.color_critical);
            Button close = new Button(parent, 8);
            close.setText("Close");
            close.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    NodeListView.this.getSite().getPage().hideView(NodeListView.this.getSite().getPage().findView(NodeListView.ID));
                }
            });
            UIJob uiJob = new UIJob("Close Viewcom.blixx.boom.gui.views.nodelistview"){

                @Override
                public IStatus runInUIThread(IProgressMonitor monitor) {
                    NodeListView.this.getSite().getPage().hideView(NodeListView.this.getSite().getPage().findView(NodeListView.ID));
                    return Status.OK_STATUS;
                }
            };
            Repository.getUIJobManager().schedule(uiJob);
            return;
        }
        this.m_parent = parent;
        this.m_parent.setLayout((Layout)new GridLayout(1, false));
        new FilterComposite(this.m_parent, (Object)this);
        this.m_treeViewer = new STreeViewer(this.m_parent, 268438274);
        this.m_treeViewer.setData(VIEWER_TYPE, NODE_LIST);
        this.m_treeViewer.setUseHashlookup(true);
        this.m_treeViewer.setContentProvider((IContentProvider)new ViewContentProvider());
        this.m_treeViewer.getTree().setLayoutData((Object)new GridData(4, 4, true, true));
        this.m_treeViewer.setLabelProvider((IBaseLabelProvider)new StyledTreeLabelProvider());
        this.m_treeViewer.setInput(Repository.getInstance().createAgentCardsTree((StructuredViewer)this.m_treeViewer, false));
        this.m_treeViewer.expandToLevel(2);
        this.m_treeViewer.addDoubleClickListener(this);
        IWorkbenchPartSite part = this.getSite();
        part.setSelectionProvider((ISelectionProvider)this.m_treeViewer);
        this.createContentMenu();
        this.setTitleImage(BMUI.IMAGE_PC_TREE);
    }

    public void setTreeSelection(String agentID) {
        GroupTreeObject root = Repository.getInstance().getAgentTree();
        List<GroupTreeObject> elements = root.getAllElements();
        int i = 0;
        while (i < elements.size()) {
            AgentCard ac;
            Object obj;
            GroupTreeObjectLast gtol;
            GroupTreeObject o = elements.get(i);
            if (o instanceof GroupTreeObjectLast && ((gtol = (GroupTreeObjectLast)o).getLinkedPath() == null || gtol.getLinkedPath().length() <= 0) && (obj = gtol.getTreeObject().getObject()) instanceof AgentCard && (ac = (AgentCard)obj).getAgentID().equals(agentID)) {
                this.m_treeViewer.setSelection((ISelection)new StructuredSelection((Object)gtol));
                this.m_treeViewer.refresh();
                Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().activate((IWorkbenchPart)m_nlv);
                return;
            }
            ++i;
        }
    }

    public static void setTreeSelectionAgentLink(String groupPath, AgentCard ac) {
        if (ac == null) {
            GroupTreeObject root = Repository.getInstance().getAgentTree();
            GroupTreeObject gto = root.searchPath(groupPath, BMUI.type_folder);
            if (gto != null) {
                NodeListView.getInstance().m_treeViewer.setSelection((ISelection)new StructuredSelection((Object)gto));
                NodeListView.getInstance().m_treeViewer.refresh();
                Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().activate((IWorkbenchPart)m_nlv);
            }
        } else {
            GroupTreeObject root = Repository.getInstance().getAgentTree();
            GroupTreeObject gto = root.searchPath(groupPath, BMUI.type_folder);
            if (gto != null) {
                List<GroupTreeObject> elements = gto.getAllElements();
                int i = 0;
                while (i < elements.size()) {
                    GroupTreeObjectLast gtol;
                    GroupTreeObject o = elements.get(i);
                    if (o instanceof GroupTreeObjectLast && (gtol = (GroupTreeObjectLast)o).getName().equals(ac.toString())) {
                        NodeListView.getInstance().m_treeViewer.setSelection((ISelection)new StructuredSelection((Object)gtol));
                        NodeListView.getInstance().m_treeViewer.refresh();
                        Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().activate((IWorkbenchPart)m_nlv);
                    }
                    ++i;
                }
            }
        }
    }

    public STreeViewer getTreeViewer() {
        return this.m_treeViewer;
    }

    public void setFocus() {
        try {
            this.m_treeViewer.getControl().setFocus();
        }
        catch (Throwable throwable) {}
    }

    public void createContentMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        Menu menu = menuMgr.createContextMenu(this.m_treeViewer.getControl());
        this.m_treeViewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.m_treeViewer);
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                try {
                    StructuredSelection ssel = (StructuredSelection)NodeListView.this.m_treeViewer.getSelection();
                    manager.add((IAction)new RefreshNodeListAction());
                    manager.add((IContributionItem)new Separator());
                    if (!ssel.isEmpty()) {
                        Object o = ssel.getFirstElement();
                        if (o instanceof GroupTreeObject && !(o instanceof GroupTreeObjectLast)) {
                            GroupTreeObject folder = (GroupTreeObject)o;
                            String path = folder.getPath();
                            boolean slaveSelected = folder.getType().equals("IMAGE_FOLDER_SLAVE");
                            if (path.equalsIgnoreCase("/root/_Groups")) {
                                manager.add((IAction)new RefreshNodeGroups((Viewer)NodeListView.this.m_treeViewer));
                                manager.add((IAction)new AddHostGroupAction((Viewer)NodeListView.this.m_treeViewer, "nodeGroups.xml", "srv/groups/", String.valueOf(Repository.getUserTmpDirectory()) + "/", folder.getName(), path, folder.getType(), Repository.getInstance().getNodeGroupTree()));
                            } else if (path.startsWith("/root/_Groups/")) {
                                manager.add((IAction)new RefreshNodeGroups((Viewer)NodeListView.this.m_treeViewer));
                                manager.add((IAction)new AddHostGroupAction((Viewer)NodeListView.this.m_treeViewer, "nodeGroups.xml", "srv/groups/", String.valueOf(Repository.getUserTmpDirectory()) + "/", folder.getName(), path, folder.getType(), Repository.getInstance().getNodeGroupTree()));
                                manager.add((IAction)new RenameHostGroupAction((Viewer)NodeListView.this.m_treeViewer, "nodeGroups.xml", "srv/groups/", String.valueOf(Repository.getUserTmpDirectory()) + "/", folder.getName(), folder.getType(), folder.getParentPath(), Repository.getInstance().getNodeGroupTree()));
                                manager.add((IAction)new GtoDelete("nodeGroups.xml", "srv/groups/", String.valueOf(Repository.getUserTmpDirectory()) + "/", ssel, Repository.getInstance().getNodeGroupTree(), "Delete Group"));
                                manager.add((IContributionItem)new Separator());
                                manager.add((IAction)new GtoAddAgentLinkAction(NodeListView.this.m_treeViewer, "nodeGroups.xml", "srv/groups/", String.valueOf(Repository.getUserTmpDirectory()) + "/", folder.getName(), path, folder.getType(), Repository.getInstance().getNodeGroupTree()));
                                manager.add((IContributionItem)new Separator());
                                manager.add((IAction)new UndeployFromAll(ssel));
                                manager.add((IContributionItem)new Separator());
                                ArrayList<AgentCard> acList = new ArrayList<AgentCard>();
                                GroupTreeObject root = (GroupTreeObject)o;
                                List<GroupTreeObject> elements = root.getAllElements();
                                int i = 0;
                                while (i < elements.size()) {
                                    GroupTreeObjectLast gtol;
                                    Object obj;
                                    GroupTreeObject oel = elements.get(i);
                                    if (oel instanceof GroupTreeObjectLast && (obj = (gtol = (GroupTreeObjectLast)oel).getTreeObject().getObject()) instanceof AgentCard) {
                                        AgentCard ac = (AgentCard)obj;
                                        acList.add(ac);
                                    }
                                    ++i;
                                }
                                manager.add((IContributionItem)new Separator());
                                manager.add((IAction)new StartAdHocMaintenanceAction(acList, 3));
                                manager.add((IAction)new StartAdHocMaintenanceAction(acList, 1));
                                manager.add((IContributionItem)new Separator());
                                manager.add((IAction)new OpenMessageBrowserAction(ssel, "Node group", false));
                                manager.add((IAction)new OpenMessageBrowserAction(ssel, "Node group", true));
                                manager.add((IAction)new OpenMessageBrowserAction(ssel, "Node group [Hosts]", false));
                                manager.add((IAction)new OpenMessageBrowserAction(ssel, "Node group [Hosts]", true));
                                FastAndRemoteActions fastAndRemoteActions = new FastAndRemoteActions(manager, NodeListView.this.m_parent.getShell(), NodeListView.this.m_treeViewer);
                                if (fastAndRemoteActions.selectionContainsRunnableAgents(ssel)) {
                                    fastAndRemoteActions.addActions();
                                }
                            } else if (path.contains("  Not approved Agents ".trim()) || path.contains("  Not approved _External ".trim())) {
                                manager.add((IAction)new ApproveAgentAction(folder));
                                manager.add((IAction)new DeleteAgentAction(NodeListView.this.m_treeViewer, null, null));
                            } else {
                                FastAndRemoteActions fastAndRemoteActions;
                                if (path.startsWith("/root/Agents")) {
                                    manager.add((IAction)new AddNewAgent());
                                    manager.add((IAction)new AddNewAgent(true));
                                } else if (slaveSelected) {
                                    String slaveHostName = folder.getName();
                                    manager.add((IAction)new TriggerMasterUpdate(slaveHostName, "BINARIES"));
                                    manager.add((IAction)new TriggerMasterUpdate(slaveHostName, "POLICIES_AND_ASSIGNMENTS"));
                                    manager.add((IAction)new AddNewAgentActionSlave(slaveHostName));
                                    manager.add((IAction)new AddNewAgentActionSlave(slaveHostName, true));
                                    manager.add((IAction)new OpenMessageBrowserAction(slaveHostName));
                                }
                                if (!slaveSelected) {
                                    manager.add((IAction)new RedeployAgentAction(NodeListView.this.m_treeViewer, null));
                                }
                                manager.add((IContributionItem)new Separator());
                                if (!slaveSelected) {
                                    manager.add((IAction)new SyncAgentsAction(ssel));
                                }
                                if ((fastAndRemoteActions = new FastAndRemoteActions(manager, NodeListView.this.m_parent.getShell(), NodeListView.this.m_treeViewer)).selectionContainsRunnableAgents(ssel)) {
                                    fastAndRemoteActions.addActions();
                                }
                            }
                        } else if (o instanceof GroupTreeObjectLast) {
                            AgentCard aCard;
                            GroupTreeObjectLast gtoLast = (GroupTreeObjectLast)o;
                            if (gtoLast.getPath().startsWith("/root/_Groups/")) {
                                manager.add((IAction)new GtoDelete("nodeGroups.xml", "srv/groups/", String.valueOf(Repository.getUserTmpDirectory()) + "/", ssel, Repository.getInstance().getNodeGroupTree(), "Remove Link"));
                            }
                            if ((aCard = (AgentCard)gtoLast.getTreeObject().getObject()) == null) {
                                aCard = Repository.getInstance().getAgentCard(gtoLast.getLinkedPath());
                            }
                            manager.add((IAction)new ShowAssignedPoliciesAction(NodeListView.this.m_treeViewer));
                            ArrayList<AgentCard> acList = new ArrayList<AgentCard>();
                            LinkedList<String> ids = new LinkedList<String>();
                            if (ssel.size() == 1) {
                                if (aCard != null) {
                                    acList.add(aCard);
                                }
                                manager.add((IAction)new ApproveAgentAction(acList));
                                manager.add((IAction)new RedeployAgentAction(NodeListView.this.m_treeViewer, aCard));
                                manager.add((IAction)new EnableDisableHostAction(acList, null));
                                manager.add((IAction)new UndeployFromAll(aCard.getAgentID()));
                                if (aCard.isFirewalled()) {
                                    manager.add((IAction)new SetFirewallAction(acList, SET_FIREWALLED_OFF));
                                } else {
                                    manager.add((IAction)new SetFirewallAction(acList, SET_FIREWALLED_ON));
                                }
                                manager.add((IContributionItem)new Separator());
                                manager.add((IAction)new StartAdHocMaintenanceAction(aCard, 3));
                                manager.add((IAction)new StartAdHocMaintenanceAction(aCard, 1));
                            } else if (ssel.size() > 1) {
                                LinkedList<AgentCard> acDisabled = new LinkedList<AgentCard>();
                                LinkedList<AgentCard> acEnabled = new LinkedList<AgentCard>();
                                LinkedList<AgentCard> acFirewalledOn = new LinkedList<AgentCard>();
                                LinkedList<AgentCard> acFirewalledOff = new LinkedList<AgentCard>();
                                for (Object obj : ssel) {
                                    if (!(obj instanceof GroupTreeObjectLast)) continue;
                                    GroupTreeObjectLast gtol = (GroupTreeObjectLast)obj;
                                    AgentCard ac = (AgentCard)gtol.getTreeObject().getObject();
                                    if (ac == null) {
                                        ac = Repository.getInstance().getAgentCard(gtol.getLinkedPath());
                                    }
                                    if (ac == null) continue;
                                    ids.add(ac.getID());
                                    if (ac.isDisabled()) {
                                        acDisabled.add(ac);
                                    } else {
                                        acEnabled.add(ac);
                                    }
                                    if (!ac.isExternal()) {
                                        if (ac.isFirewalled()) {
                                            acFirewalledOn.add(ac);
                                        } else {
                                            acFirewalledOff.add(ac);
                                        }
                                    }
                                    acList.add(ac);
                                }
                                manager.add((IAction)new ApproveAgentAction(acList));
                                manager.add((IAction)new RedeployAgentAction(acList));
                                if (acDisabled.size() > 0) {
                                    manager.add((IAction)new EnableDisableHostAction(acDisabled, ENABLE));
                                }
                                if (acEnabled.size() > 0) {
                                    manager.add((IAction)new EnableDisableHostAction(acEnabled, DISABLE));
                                }
                                manager.add((IAction)new UndeployFromAll(ids));
                                if (acFirewalledOn.size() > 0) {
                                    manager.add((IAction)new SetFirewallAction(acFirewalledOn, SET_FIREWALLED_OFF));
                                }
                                if (acFirewalledOff.size() > 0) {
                                    manager.add((IAction)new SetFirewallAction(acFirewalledOff, SET_FIREWALLED_ON));
                                }
                                manager.add((IContributionItem)new Separator());
                                manager.add((IAction)new StartAdHocMaintenanceAction(acList, 3));
                                manager.add((IAction)new StartAdHocMaintenanceAction(acList, 1));
                            }
                            manager.add((IContributionItem)new Separator());
                            manager.add((IAction)new AddNewAgent());
                            manager.add((IAction)new AddVirtAgentAction());
                            manager.add((IAction)new RestartAgentAction(acList));
                            if (!gtoLast.getPath().startsWith("/root/_Groups/")) {
                                manager.add((IAction)new DeleteAgentAction(NodeListView.this.m_treeViewer, aCard, null));
                            }
                            manager.add((IContributionItem)new Separator());
                            manager.add((IAction)new ShowRelatedHostInfosAction((Object)NodeListView.this.m_treeViewer, aCard, NodeListView.this.m_parent.getShell()));
                            manager.add((IAction)new OpenMessageBrowserAction(ssel, false));
                            manager.add((IAction)new OpenMessageBrowserAction(ssel, true));
                            manager.add((IContributionItem)new Separator());
                            manager.add((IAction)new SyncAgentsAction(ssel));
                            FastAndRemoteActions fastAndRemoteActions = new FastAndRemoteActions(manager, NodeListView.this.m_parent.getShell(), NodeListView.this.m_treeViewer);
                            if (fastAndRemoteActions.selectionContainsRunnableAgents(ssel)) {
                                fastAndRemoteActions.addActions();
                            }
                        }
                    }
                    manager.add((IContributionItem)new Separator());
                    manager.add((IAction)new ExpandCollapseAction(NodeListView.this.m_treeViewer, "ExpandAll"));
                    manager.add((IAction)new ExpandCollapseAction(NodeListView.this.m_treeViewer, "CollapseAll"));
                }
                catch (RuntimeException runtimeException) {}
            }
        });
    }

    public void doubleClick(DoubleClickEvent event) {
        ISelection iSelect = event.getViewer().getSelection();
        Object obj = ((IStructuredSelection)iSelect).getFirstElement();
        if (obj instanceof GroupTreeObjectLast) {
            AgentCard ac = null;
            GroupTreeObjectLast gtol = (GroupTreeObjectLast)obj;
            if (gtol.getLinkedPath() != null) {
                String realAgentID = gtol.getLinkedPath();
                ac = Repository.getInstance().getAgentCard(realAgentID);
            } else {
                ac = (AgentCard)gtol.getTreeObject().getObject();
            }
            if (ac != null) {
                ShowAssignedPoliciesAction sa = new ShowAssignedPoliciesAction(ac);
                sa.run();
            }
        } else if (obj instanceof GroupTreeObject) {
            this.m_treeViewer.setExpandedState((GroupTreeObject)obj, !this.m_treeViewer.getExpandedState((GroupTreeObject)obj));
        }
    }
}

