/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.gui.dialogs.ShowMessageBox;
import com.blixx.boom.gui.utils.GUIDisplayElements;
import com.blixx.boom.gui.views.AbstractPolicyTab;
import com.blixx.boom.gui.views.FilterPolicyTab;
import com.blixx.boom.gui.views.MonitorPolicyTab;
import com.blixx.boom.gui.views.PolicyView;
import com.blixx.log.RTLogger;
import com.blixx.shared.MsgPolicy;
import com.blixx.shared.Policy;
import com.blixx.shared.PolicyFactory;
import com.blixx.shared.PolicyParsingException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import org.eclipse.compare.BufferedContent;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareViewerPane;
import org.eclipse.compare.IContentChangeListener;
import org.eclipse.compare.IContentChangeNotifier;
import org.eclipse.compare.IEditableContent;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.contentmergeviewer.TextMergeViewer;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.compare.structuremergeviewer.ICompareInputChangeListener;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class PolicyCompareTab
implements ShellListener,
SelectionListener,
ICompareInputChangeListener {
    protected static final String BUTON_Refresh = "SAVE_LEFT";
    protected static final String BUTTON_Apply = "SAVE";
    public File m_mainTMP = null;
    public File m_version = null;
    protected Shell m_shell = new Shell(Display.getCurrent().getActiveShell(), 1264);
    protected Shell m_parentshell;
    protected String m_verLeftLabel = null;
    protected String m_verRightLabel = null;
    protected Comp m_left;
    protected Object m_policy = null;
    protected DiffNode m_node;
    protected TextMergeViewer m_viewer;
    protected boolean m_isReadOnly = false;

    public PolicyCompareTab(Object policyObj, Shell parentShell, File main, File version, String policy, String verLeft, String verRight, boolean readOnly) {
        this.m_parentshell = parentShell;
        this.m_mainTMP = main;
        this.m_version = version;
        this.m_verLeftLabel = String.valueOf(policy) + " v" + verLeft;
        this.m_verRightLabel = String.valueOf(policy) + " v" + verRight;
        this.m_policy = policyObj;
        this.m_isReadOnly = readOnly;
        this.m_shell.setText("Compare: " + policy + " (" + verLeft + ") (" + verRight + ")");
        this.m_shell.setLayout((Layout)new GridLayout());
        this.m_shell.setData((Object)this.createDialogArea((Composite)this.m_shell));
        this.m_shell.setImage(BMUI.IMAGE_PRODUCT);
    }

    public PolicyCompareTab(Shell parentShell, File file1, File file2, String policy1, String policy2, boolean readOnly) {
        this.m_parentshell = parentShell;
        this.m_mainTMP = file1;
        this.m_version = file2;
        this.m_verLeftLabel = policy1;
        this.m_verRightLabel = policy2;
        this.m_policy = null;
        this.m_isReadOnly = readOnly;
        this.m_shell.setText("Compare: " + policy1 + " vs " + policy2);
        this.m_shell.setLayout((Layout)new GridLayout());
        this.m_shell.setData((Object)this.createDialogArea((Composite)this.m_shell));
        this.m_shell.setImage(BMUI.IMAGE_PRODUCT);
    }

    protected Control createDialogArea(Composite parent) {
        Composite comp = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        comp.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        gd.widthHint = 600;
        gd.heightHint = 600;
        comp.setLayoutData((Object)gd);
        CompareViewerPane main = new CompareViewerPane(comp, 0x800800);
        main.setLayoutData((Object)new GridData(1808));
        CompareConfiguration config = new CompareConfiguration();
        config.setAncestorImage(BMUI.IMAGE_PRODUCT);
        config.setLeftLabel(this.m_verLeftLabel);
        config.setRightLabel(this.m_verRightLabel);
        config.setProperty("IGNORE_WHITESPACE", (Object)true);
        if (this.m_mainTMP.getName().endsWith(String.valueOf(BMUI.file_extension_mon) + ".tmp") || this.m_mainTMP.getName().endsWith(BMUI.file_extension_mon)) {
            config.setLeftImage(BMUI.IMAGE_MON);
        } else {
            config.setLeftImage(BMUI.IMAGE_MSG);
        }
        if (this.m_version.getName().indexOf(BMUI.file_extension_mon) != -1) {
            config.setRightImage(BMUI.IMAGE_MON);
        } else {
            config.setRightImage(BMUI.IMAGE_MSG);
        }
        config.setProperty("org.eclipse.compare.internal.CONFIRM_SAVE_PROPERTY", (Object)true);
        this.m_viewer = new TextMergeViewer((Composite)main, 2048, config);
        this.m_left = new Comp("left", this.m_mainTMP, true);
        Comp right = new Comp("right", this.m_version, false);
        this.m_node = new DiffNode((ITypedElement)this.m_left, (ITypedElement)right);
        this.m_node.addCompareInputChangeListener((ICompareInputChangeListener)this);
        this.m_viewer.setInput((Object)this.m_node);
        main.setContent(this.m_viewer.getControl());
        GUIDisplayElements gde = new GUIDisplayElements();
        Composite compBtn = new Composite(comp, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        compBtn.setLayout((Layout)gridLayout);
        compBtn.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        Button refresh = gde.addButton(compBtn, BUTON_Refresh, " Refresh Compare Dialog ", true, 80, 20, 1, this);
        refresh.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        Button apply = gde.addButton(compBtn, BUTTON_Apply, " Apply Changes To The Policy ", true, 80, 20, 1, this);
        apply.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        if (this.m_isReadOnly) {
            apply.setEnabled(false);
        }
        return comp;
    }

    public void open() {
        this.m_shell.pack();
        this.m_shell.open();
    }

    private void storeTmpFile() {
        try {
            byte[] content = this.m_left.getContent();
            if (content == null || content.length == 0) {
                return;
            }
            FileOutputStream fos = new FileOutputStream(this.m_mainTMP);
            fos.write(content);
            fos.close();
            this.m_viewer.refresh();
        }
        catch (Throwable e) {
            RTLogger.print(5, "cd001", e);
        }
    }

    public void shellActivated(ShellEvent e) {
        this.m_shell.moveAbove(null);
    }

    public void shellClosed(ShellEvent e) {
    }

    public void shellDeactivated(ShellEvent e) {
    }

    public void shellDeiconified(ShellEvent e) {
    }

    public void shellIconified(ShellEvent e) {
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.getSource() instanceof Button) {
            Button b = (Button)e.getSource();
            String buttonName = (String)b.getData();
            if (buttonName == BUTTON_Apply) {
                this.m_viewer.flush(null);
                this.storeTmpFile();
                try {
                    PolicyFactory pf = new PolicyFactory();
                    if (this.m_mainTMP.getName().endsWith(String.valueOf(BMUI.file_extension_msg) + ".tmp")) {
                        MsgPolicy mp = null;
                        try {
                            mp = pf.initMsgPolicy(this.m_mainTMP);
                        }
                        catch (PolicyParsingException e1) {
                            RTLogger.print(3, "Invalid FilterPolicy Content, " + e1);
                        }
                        if (mp == null) {
                            new ShowMessageBox("Error", "Invalid FilterPolicy Content!", 1);
                            return;
                        }
                        MsgPolicy m_orig = (MsgPolicy)this.m_policy;
                        mp.setVersion(m_orig.getVersion());
                        mp.setName(m_orig.getName());
                        CTabItem cTab = PolicyView.displayPolicy(mp, BMUI.type_msg);
                        if (cTab != null && cTab instanceof AbstractPolicyTab) {
                            ((FilterPolicyTab)cTab).setDirty(true);
                        }
                    } else if (this.m_mainTMP.getName().endsWith(String.valueOf(BMUI.file_extension_mon) + ".tmp")) {
                        Policy p = null;
                        try {
                            p = pf.initPolicy(this.m_mainTMP);
                        }
                        catch (PolicyParsingException e1) {
                            RTLogger.print(3, "Invalid Monitor Policy Content, " + e1);
                        }
                        if (p == null) {
                            new ShowMessageBox("Error", "Invalid Monitor Policy Content!", 1);
                            return;
                        }
                        Policy m_orig = (Policy)this.m_policy;
                        p.setVersion(m_orig.getVersion());
                        p.setName(m_orig.getName());
                        CTabItem cTab = PolicyView.displayPolicy(p, BMUI.type_mon);
                        if (cTab != null && cTab instanceof AbstractPolicyTab) {
                            ((MonitorPolicyTab)cTab).setDirty(true);
                        }
                    } else {
                        RTLogger.print(3, "Unsupported filename");
                    }
                    this.m_shell.dispose();
                }
                catch (Throwable e1) {
                    RTLogger.print(5, "", e1);
                }
            } else if (buttonName == BUTON_Refresh) {
                this.m_viewer.flush(null);
            }
        }
    }

    public void compareInputChanged(ICompareInput source) {
    }

    public class Comp
    extends BufferedContent
    implements ITypedElement,
    IEditableContent,
    IContentChangeListener {
        public String m_name;
        public File m_file;
        public boolean m_isEditable = false;

        public Comp(String name, File file, boolean isEditable) {
            this.m_name = name;
            this.m_file = file;
            this.m_isEditable = isEditable;
        }

        public Image getImage() {
            return null;
        }

        public String getName() {
            return this.m_name;
        }

        public String getType() {
            return "txt";
        }

        protected InputStream createStream() throws CoreException {
            InputStream is = new ByteArrayInputStream(this.m_file.getName().getBytes());
            try {
                FileInputStream fis = new FileInputStream(this.m_file);
                is = fis;
            }
            catch (FileNotFoundException e) {
                RTLogger.print(4, "", e);
            }
            return is;
        }

        public boolean isEditable() {
            return this.m_isEditable;
        }

        public ITypedElement replace(ITypedElement dest, ITypedElement src) {
            PolicyCompareTab.this.storeTmpFile();
            return src;
        }

        protected void fireContentChanged() {
            PolicyCompareTab.this.storeTmpFile();
            super.fireContentChanged();
        }

        public void contentChanged(IContentChangeNotifier source) {
            PolicyCompareTab.this.storeTmpFile();
        }

        public void setContent(byte[] contents) {
            super.setContent(contents);
        }
    }
}

